{$M 50000,0,32767}
{$O+}
(****************************************************************************
 ** UNIT: Init.Pas                                                         **
 ** PURPOSE: To initialize the data at runtime, and to close and save data **
 **          upon exiting.                                                 **
 ****************************************************************************)


unit Init;

interface

uses Dos, Crt, Common, Setup1, Fossil, ExecSwap;

procedure Initialize;
procedure DeInitialize;

implementation

procedure InitilizeModem;
begin
  messagebox('Initializing Modem');
  delay(10);
  prt2m(modemf.initstr);
  delay(2000);
end;

procedure checkfordsz(s: string);

var
  f: searchrec;

begin
  findfirst(s,anyfile,f);
  if doserror <> 0 then error(1,s+' not found in current directory!');
end;

procedure checkforpkzip(s: string);

var
  f: searchrec;

begin
  findfirst(s,anyfile,f);
  if doserror <> 0 then error(1,s+' not found in current directory!');
end;

procedure checkforpkunzip(s: string);

var
  f: searchrec;

begin
  findfirst(s,anyfile,f);
  if doserror <> 0 then error(1,s+' not found in current directory!');
end;

function CheckDir(S: string): boolean;

var
  O: string;
  I: byte;
  F: searchrec;
  T: boolean;

begin
  checkdir := false;
  O := S;
  repeat
    I := pos('\',S);
    if i > 0 then
      delete(s,1,i);
  until I <= 0;
  findfirst(s,directory,f);
  if doserror <> 0 then t := false else begin checkdir := true; t := true; end;
  if t <> true then
  begin
    messagebox('Creating '+O+'...');
    mkdir(s);
    checkdir := true;
  end;
end;

procedure Initialize;

var
  F: File of systemrec;
  B: boolean;

begin
  clrscr;
  b:= FALSE;
  cursoroff;

(* Check if Directories Exist *)

  if not checkdir(systemf.datapath) then
  begin
    b:= true;
    error(0,'Directory '+systemf.datapath+' not found!');
  end;
  if not checkdir(systemf.messagepath) then
  begin
    b:= true;
    error(0,'Directory '+systemf.messagepath+' not found!');
  end;
  if not checkdir(systemf.textfilepath) then
  begin
    b:= true;
    error(0,'Directory '+systemf.textfilepath+' not found!');
  end;
  if not checkdir(systemf.menupath) then
  begin
    b:= true;
    error(0,'Directory '+systemf.menupath+' not found!');
  end;
  if not checkdir(systemf.xferpath) then
  begin
    b:= true;
    error(0,'Directory '+systemf.xferpath+' not found!');
  end;
  if not checkdir(systemf.temppath) then
  begin
    b:= true;
    error(0,'Directory '+systemf.temppath+' not found!');
  end;
  if b then error(1,'');

  checkfordsz(systemf.zmodem);
  checkforpkzip(systemf.zip);
  checkforpkunzip(systemf.unzip);

  UseEMSIfAvailable:= TRUE;
  if not InitExecSwap(HeapPtr,'ONYXSWAP.$$$') then
    error(1,'Unable to allocate swap space!');

  if InitDriver(modemf.comport) then
   begin
    InitModem(modemf.comport,modemf.speed,'N',8,1);
    InitilizeModem;
    Cursoron;
   end
  else
   Begin
    CursorOff;
    MessageBox('FOSSIL Driver not Installed!');
    Delay(2000);
    CursorOn;
    Halt(666);
   End;

(* Set Thisuser.etc to defaults *)
   with thisuser do
   begin
     handle:='';
     baud:='';
   end;
end;

procedure DeInitialize;
var s: file of systemrec;
    m: file of modemrec;
    h: file of historyrec;

begin
  ClrScr;
  PurgeBuffer(modemf.comport,'B');
  DeinitDriver(modemf.comport);
  assign(s, 'setup.dat');
  assign(m, 'modem.dat');
  assign(h, 'history.dat');
  {$I-}
  reset(s);
  if IOResult = 0 then
  begin
    write(s, systemf);
    close(s);
  end;
  reset(m);
  if IOResult = 0 then
  begin
    write(m, modemf);
    close(m);
  end;
  reset(h);
  if IOResult = 0 then
  begin
    write(h, historyf);
    close(h);
  end;
  {$I+}
  ShutDownExecSwap;
end;

end.