(* Global Records and Types *)

type

(* Color Record *)
colorrec = record
  Regular,
  Prompt,
  Stat,
  Input,
  Message: byte;
end;

(* User Index Record *)
userindexrec = record
  Handle: string[30];
  Password: string[15];
end;

(* User Flags *)
UserFlagRec = (Wanted, NoFile, NoMessage, NoDL, NoNUV, NoChat,
                 CoSysOp, NoNet, OncePerDay, LockedOut);

(* User Record *)
userrec = record
  Handle: string[30];
  Baud: string[6];
  RealName: string[50];
  Sex: char;
  VoiceNum,
  DataNum: string[20];
  Password: string[15];
  Address1,
  Address2: string[50];
  UserNote: string[30];
  SysOpNote: string[50];
  LastOn: longint;
  NumOn: word;
  TimeAllowed: word;
  TimeOn: word;
  TimeLeft: word;
  UploadK: longint;
  Uploads: word;
  DownloadK: longint;
  Downloads: word;
  TotalTimeOn: longint;
  MainLevel,
  MessageLevel,
  FileLevel: integer;
  FilePoints: longint;
  Colors: colorrec;
  Xpert: boolean;
  MsgHeaderType,
  PromptType,
  MenuType,
  StringType: byte;
  NFO1,
  NFO2,
  NFO3,
  NFO4,
  NFO5: boolean;
  Validated: boolean;
  DisplayLength: byte;
  VideoMode: (TTY, ANSI, AVATAR);
  LastRead: array[1 .. 255] of word;
  ExpireDate: longint;
  TimeInBank: longint;
  ConfOn: byte;
  ConfAccessA: array [1 .. 5] of boolean;
  ConfAccessB: array [1 .. 5] of boolean;
  TimePerDay: longint;
  PCRratio: integer;
  UDratio: integer;
  HackAttempts: byte;
  Posted: word;
  UserFlags: UserFlagRec;
  DownloadKLimit: longint;
  EmailWaiting: byte;
  UserPrompt: string[255];
  UserSig: string[255];
end;

(* Prompt Record *)
promptrec = record
  Name: string[50];
  Number: byte;
  PromptData: string[255];
end;

(* Menu Type Record *)
menutyperec = record
  Name: string[50];
  Number: byte;
  MenuFile: string[12];
  MenuDir: string[60];
end;

(* String Record *)
stringtyperec = record
  Name: string[50];
  Number: byte;
  StringFile: string[12];
end;

(* Message Header Record *)
messageheaderrec = record
  Name: string[50];
  Number: byte;
  Filename: string[12];
  Id:Word;
end;

(* Menu Command Record *)
menucommandrec = record
  Description: string[50]; {DESCRIPTION OF COMMAND}
  Default: string[50];     {NO IDEA}
  CMDKey: string[50];      {COMMAND TO USE IT}
  FString: string[2];      {Function Code}
  PString: string[50];     {Parameters Area Change *}
  Access: integer;         {Access Number}
  Hidden: boolean;         {Take Out}
 End;

(* Menu Record *)
menurec = record
  Name: string[8];
  Command: array[0 .. 99] of MenuCommandRec;
end;

(* System Setup Record *)
systemrec = record
  BBSNameLng: string[80];
  BBSNameSht: string[50];
  BBSPhone: string[12];
  SysOp: string[30];
  MainPath,
  DataPath,
  MessagePath,
  TextfilePath,
  MenuPath,
  XferPath,
  TempPath: string[80];
  InfoForm1,
  InfoForm2,
  InfoForm3,
  InfoForm4,
  InfoForm5: boolean;
  Zmodem,
  Zip,
  Unzip: string[80];
  NUP: string[50];
  System1: string[50];
  System2: string[50];
  System3: string[50];
  LockOutBaud: string[6];
  LockOutPw: string[50];
  UseConfs: boolean;
  UseConf1,
  UseConf2,
  UseConf3,
  UseConf4,
  UseConf5: boolean;
  Conf1a,
  Conf1b,
  Conf2a,
  Conf2b,
  Conf3a,
  Conf3b,
  Conf4a,
  Conf4b,
  Conf5a,
  Conf5b: string[80];
  HangupOnNewbies: boolean;{NEW}
  Numtries: byte;
  Maskchar: char;
  IdleTime: byte;
end;

(* Modem Record *)
modemrec = record
  Speed: longint;
  ComPort: byte;
  InitStr: string[80];
  AnswerStr: string[80];
  HangupStr: string[80];
  OffhookStr: string[80];
  SoundOnStr: string[80];
  SoundOffStr: string[80];
  TimeToWait: byte;
end;

(* History Record *)
historyrec = record
  TotalCalls: word;
  TotalDays: word;
  RecentPosts: word;
  RecentCalls: word;
  RecentULs: word;
  RecentDLs: word;
  MinsUsed: word;
  NumFeedBack: word;
  NewEmail: word;
  Available: boolean;
  CallsToday: word;
  LastOn: string[50];
end;

(* String Record *)
stringrec = record
  Anonymous: string[30];      { Anonymous String }
  Logon: string[50];          { Logon Name String }
  Password: string[50];       { Logon Password String }
  System: string[50];        { System Password Prompts }
  Detect: string[80];         { Detecting ANSI String }
  Ansi: string[80];           { ANSI Detected String }
  Avatar: string[80];         { Avatar Detected String }
  Nothing: string[80];        { Nothing Detected String }
  Pause: string[80];          { Pause Prompt }
  NewUserName: string[50];    { Desired Name For New Users String }
  NUP: string[50];            { Enter NUP String }
  NUPWrong: string[80];       { NUP Incorrect String }
  AlreadyUser: string[80];    { Person Is Already A User String }
  DesiredPW: string[50];      { Desired Password String }
  PhoneNum1,
  PhoneNum2: string[80];      { Phone Number Prompt }
  DataNum1,
  DataNum2: string[80];       { Modem Number Prompt }
  RealName: string[50];
  Address1,
  Address2: string[50];       { Address Prompts }
  Age: string[50];            { Age Prompt }
  Sex: string[50];            { Sex Prompt }
  Birthday: string[50];       { Birthday Prompt }
end;

(* Message Sub Record *)
subrec = record
  Num: word;
  Name: string[50];
  FileN: string[8];
end;

(* Index Record *)
indexrec = record
  Number: word;
  Title: string[50];
  From: string[30];
  WhoTo: string[30];
  DateSent: word;
  TimeSent: word;
  MsgLoc: longint;
  MsgLen: longint;
end;

(* Message Info Record *)
inforec = record
  Title: string[50];
  WhoTo: string[30];
  NumTo: word;
end;

(* Conference Info Record *)
confinforec = record
  Num: byte;
  MName: string[50];
  FName: string[50];
end;

