{$M 50000,0,32767}
{$O+}
(***************************************************************************
 **  UNIT: Common.Pas                                                         **
 **  PURPOSE: Provides a set of procedures and functions that most other  **
 **           units will need to share.                                   **
 ***************************************************************************)

unit Common;

interface

uses Dos, Crt, Fossil, Overlay,Windows;

{$I GlobType.Pas}
{$I GlobVars.Pas}

type
  ScreenType = array[0 .. 3999] of byte;
  MenuStack = array[1 .. 10] of string[8];
  str2 = string[2];
  str50 = string[50];
  str8 = string[8];

var
  Stack: MenuStack;
  CurrS: byte;
  screenadr: screentype absolute $B800:0000;
  Done: Boolean;
  Local: boolean;
  IncomingCall,Online: boolean;
  SysTemF: systemrec;
  ModemF: modemrec;
  HistoryF: historyrec;
  StringF: stringrec;
  CurrMenu: menurec;

procedure ansicolor (attrib:integer);
function Expand(S: string; Num: byte): string;
procedure PrintFile(Filename: string);
procedure PrintAnsi(Filename: string);
procedure ClearScreen;
procedure Color(b: byte);
procedure GoXY(X, Y: byte);
function StrComp(S1, S2: string): boolean;
procedure FindUserName(var Name: string);
procedure LoadUser(Name: string);
procedure AnsiDetect;
procedure Error(I: integer; S: string);
procedure C(b: byte);
procedure WriteAt(X,Y:byte; s: string);
procedure ReadData(var A: byte);
procedure WriteCon(s:string);
function v2str(I: longint): string;
function str2v(S: string): longint;
function b2str(B: boolean): string;
procedure Prt(s:string);
procedure Prtln(s:string);
procedure Prt2M(s:string);
procedure Prt2S(s:string);
function KeyHit: boolean;
function GetKey: char;
procedure UNCRUNCH (var Addr1,Addr2; BlkLen:Integer);
procedure Input1(var Sn: string);
procedure Input2(var Sn: string; maskchar: char);
function Time: string;
function Date: string;
procedure Toggle(var B: boolean);
function Prompt(Number: byte): string;
function ToUpper(S: string): string;
function Carrier: boolean;
procedure PhoneInput(var S: string);
procedure Nl;
function TestPassword(Prompt, Pw, Bad: string): boolean;
procedure BackGround(b: byte);
procedure CursorOff;
procedure CursorOn;
procedure MessageBox(S: string);
procedure Hangup;
function Timer: word;
function TimeTill(Time: word): word;
function TimeBetween(Time1, Time2: word): word;
function TimeLeft: word;
function UserPos(S: string): longint;
procedure CreateUserIndex;
function gethiddenkey:char;
implementation

procedure CreateUserIndex;
var uf: file of userrec;
    uif: file of userindexrec;
    u: userrec;
    ui: userindexrec;
begin
  assign(uf, 'USER.LST');
  assign(uif, 'USER.NDX');
  {$I-} reset(uf); {$I+}
  if IOResult <> 0 then exit;
  rewrite(uif);
  while not eof(uf) do
  begin
    read(uf, u);
    ui.handle := u.handle;
    ui.password := u.password;
    write(uif, ui);
  end;
  close(uif);
  close(uf);
end;

function UserPos(S: string): longint;
var u: file of UserIndexRec;
    temp: UserIndexRec;
    x: longint;
begin
  x := 0;
  assign(u, 'USER.NDX');
  {$I-} reset(u); {$I+}
  if IOResult <> 0 then begin CreateUserIndex; reset(u); end;
  while ((not eof(u)) and (ToUpper(s) <> temp.handle)) do
  begin
    read(u, temp);
    inc(x);
  end;
  close(u);
  userpos := x;
end;

function TimeLeft: word;
begin
  TimeLeft := thisuser.timeperday - (timer - thisuser.timeon);
end;

function TimeBetween(Time1, Time2: word): word;
begin
  if Time2 < Time1 then
    Time2 := Time2 + 1440;
  TimeBetween := Time2 - Time1;
end;

function TimeTill(Time: word): word;
var w: word;
begin
  w := timer;
  if time < w then
    time := time + 1440;
  TimeTill := time - w;
end;

function Timer: word; assembler;
asm
 mov ah, 2Ch
 int 21h
 mov ax, cx
 mov bx, ax
 mov cl, 8
 shr ax, cl
 mov cx, 60
 mul cx
 xor bh, bh
 add ax, bx
end;

function Expand(S: string; Num: byte): string;
var temp: string;
    x: integer;
    y: byte;
begin
  temp := '';
  x := num - length(s);
  if x < 0 then begin expand := s; exit; end;
  for y := 1 to x do
    temp := temp + ' ';
  insert(temp, s, 1);
  expand := s;
end;

procedure PrintFile(Filename: string);
var f: file of char;
    x: longint;
    c: char;
begin
  assign(f, filename);
  {$I-} reset(f); {$I+}
  if IOResult <> 0 then
  begin
    prtln(filename+' not found!');
    exit;
  end;
  while not eof(f) do
  begin
    read(f, c);
    prt(c);
  end;
  close(f);
  nl;
end;

procedure PrintAnsi(Filename: string);
var f: file of char;
    x: longint;
    c: char;
begin
  if thisuser.videomode <> tty then
    filename := filename + '.ANS'
  else
    filename := filename + '.ASC';
  assign(f, filename);
  {$I-} reset(f); {$I+}
  if IOResult <> 0 then
  begin
    prtln(filename+' not found!');
    exit;
  end;
  while not eof(f) do
  begin
    read(f, c);
    prt(c);
  end;
  close(f);
  nl;
end;

procedure Hangup;
begin
  local := false;
  if Carrier then fossil.hangup(modemf.comport);
end;

procedure MessageBox(S: string);
var x,y,z: byte;
begin
  clrscr;
  x := 40 - (length(s) div 2);
  z := length(s) mod 2;
  textcolor(red);
  gotoxy(x-5,11); write(#218);
  textcolor(darkgray); textbackground(lightgray);
  write(#221);
  textcolor(black);
  write(#218);
  for y := x to (80 - (x - 3) + z) do
    write(#196);
  write(#191);
  textcolor(darkgray);
  write(#222);
  textcolor(red); textbackground(black);
  write(#191);
  gotoxy(x-5,12); write('');
  textcolor(darkgray); textbackground(lightgray);
  write(#221);
  textcolor(black);
  write(#179'  ');
  textcolor(white);
  write(s);
  textcolor(black);
  write('  '#179);
  textcolor(darkgray);
  write(#222);
  textcolor(red); textbackground(black);
  write(#179' ');
  gotoxy(x-5,13); write(#192);
  textcolor(darkgray); textbackground(lightgray);
  write(#221);
  textcolor(black);
  write(#192);
  for y := x to (80 - (x - 3) + z) do
    write(#196);
  write(#217);
  textcolor(darkgray);
  write(#222);
  textcolor(red); textbackground(black);
  write(#217);
end;

procedure CursorOff; assembler;
asm
  mov ax, 0100h
  mov cx, 2000h

  int 10h
end;

procedure CursorOn; assembler;
asm
  mov ax, 0100h
  mov cx, 0607h

  int 10h
end;

procedure Print(F, B: byte; S: string);
begin
  Color(f);
  BackGround(b);
  prt(s);
end;

procedure BackGround(b: byte);
const colors: array[0 .. 7] of string[2] =
              ('40','44','42','46','41','45','43','47');
var s: string[20];
begin
  textbackground(b);
  case thisuser.videomode of
    ansi: begin
            s := #27'[' + colors[b] + 'm';
            xmitstring(modemf.comport,s,false);
          end;
    avatar: begin
            end;
  end;
end;

procedure Color(b: byte);
const colors: array[0 .. 7] of string[2] =
              ('30','34','32','36','31','35','33','37');
var s: string[20];
begin
  textattr:=b;
  case thisuser.videomode of
    ansi: begin
            s := #27'[';
            if b > 7 then
            begin
              s := s + '1;';
              b := b - 8;
            end
            else
              s := s + '0;';
            s := s + colors[b] + 'm';
            xmitstring(modemf.comport,s,false);
          end;
    avatar: begin
            end;
  end;
end;

procedure ClearScreen;
var x: word;
begin
  clrscr;
  case thisuser.videomode of
    ansi: xmitstring(modemf.comport,#27'[2J',false);
    avatar: ;
    tty: for x := 1 to thisuser.displaylength do
           xmitstring(modemf.comport,'',true);
  end;
end;

function TestPassword(Prompt, Pw, Bad: string): boolean;
var x: byte;
    s: string;
begin
  TestPassword := false;
  for x := 1 to systemf.numtries do
  begin
    prt(Prompt);
    input2(s, systemf.maskchar);
    if ToUpper(s) = ToUpper(Pw) then
    begin
      TestPassword := true;
      exit;
    end;
    nl;
    prtln(Bad);
    nl;
  end;
end;

procedure Nl;
begin
  prtln('');
end;

procedure PhoneInput(var S: string);
var cnt: byte;
    temp: string;
    c: char;
    FreeFormat: boolean;
begin
  FreeFormat := FALSE;
  temp := '';
  cnt := 0;
  repeat
    repeat until KeyHit;
    c := GetKey;
    if (cnt = 0) and (c = '+') then FreeFormat := TRUE;
    case c of
      #8: if cnt > 0 then
          begin
            if cnt = 1 then FreeFormat := FALSE;
            if ((cnt = 4) or (cnt = 8)) and not FreeFormat then
            begin
              dec(cnt); dec(cnt);
              prt(#8#8#32#32#8#8);
              temp[0] := chr(cnt);
            end else
            begin
              dec(cnt);
              prt(#8#32#8);
              temp[0] := chr(cnt)
            end;
          end;
      #13: prt(#13#10);
      #32 .. #127: if (FreeFormat) or (cnt < 12) then
                   begin
                     if ((cnt = 3) or (cnt = 7)) and not FreeFormat then
                     begin
                       inc(cnt); inc(cnt);
                       prt('-'+c);
                       temp := temp + '-' + c;
                     end else
                     begin
                       inc(cnt);
                       prt(c);
                       temp := temp + c;
                     end;
                   end;
    end;
  until c = #13;
  S := temp;
end;

procedure GoXY(X, Y: byte);
begin
  if thisuser.videomode = ansi then
    prt(#27+'['+v2str(Y)+';'+v2str(X)+'H');
end;

function Carrier: boolean;
begin
  Carrier := Fossil.Carrier(modemf.comport);
end;

function StrComp(S1, S2: string): boolean;
var x: byte;
begin
  StrComp:=TRUE;
  if length(s1) >= length(s2) then
  begin
    for x:= 1 to length(s1) do
     if UpCase(S1[x]) <> UpCase(S2[x]) then
     begin
       StrComp:=False;
       exit;
     end;
  end else
    StrComp:=FALSE;
end;


function ToUpper(S: string): string;
var x: byte;
begin
  if s='' then exit;
  for x:= 1 to length(s) do
    s[x]:=Upcase(s[x]);
  ToUpper := S;
end;

procedure FindUserName(var Name: string);
var U: file of userrec;
    x: word;
    tu: userrec;
begin
  assign(u, 'user.lst');
  {$I-} reset(u); {$I+}
  if IOResult <> 0 then begin name:=''; exit; end;
  If (Str2v(Name)>0) Then
   Begin
    If Str2v(Name)<=FileSize(U) Then
     Begin
      Seek(U,Str2v(Name)-1);
      Read(U,TU);
      Close(U);
      Name:=Tu.Handle;
      ThisUser:=Tu;
      Exit;
     End;
   End
  Else
   Begin
    for x:=1 to filesize(u) do
     begin
      read(u, tu);
      if (ToUpper(tu.handle) = ToUpper(name)) or (v2str(x) = name) then
       begin
        close(u);
        ThisUser:=Tu;
        exit;
       end;
     end;
   End;
  name := '';
  close(u);
end;

procedure LoadUser(Name: string);
var u: file of userrec;
    x: word;
    tu: userrec;
begin
  assign(u, 'user.lst');
  {$I-} reset(u); {$I+}
  if IOResult <> 0 then begin name:=''; exit; end;

  x:=1;
  while ((x <= filesize(u)) and
         (ToUpper(thisuser.handle) <> ToUpper(name))) do
  begin
    read(u, tu);
    if (ToUpper(tu.handle) = ToUpper(name)) or
       (v2str(x) = name) then
      thisuser := tu;
  end;
  if ToUpper(thisuser.handle) <> ToUpper(name) then
    Error(0, 'User Not Found!');
  close(u);
end;

function Prompt(Number: byte): string;
var
  f: file of promptrec;
  s: string;
  p: promptrec;
begin
  prompt:='Command: ';
  p.number:=0;
  assign(f, 'prompts.dat');
  {$I-} reset(f); {$I+}
  if IOResult <> 0 then
  begin
    error(0,'PROMPTS.DAT missing or invalid!');
    close(f);
    exit;
  end;
  {$I-}
  while ((IOResult = 0) and (number <> p.number)) do
    read(f,p);
  close(f);
  prompt:=p.promptdata;
end;

procedure Toggle(var B: boolean);
begin
  if b then b:=false else b:=true;
end;

function Date: string;
var Day, Month, Year, DOW: word;
    temp, temp2: string;
begin
  GetDate(Year, Month, Day, DOW);
  temp2:=v2str(year);
  temp[1]:=temp2[3];
  temp[2]:=temp2[4];
  temp[0]:=chr(2);
  Date:=v2str(month)+'/'+v2str(Day)+'/'+temp;
end;

function Time: string;
var H, M, S, Hund: word;
    PM: char;
    Min: string;
begin
  PM:='a';
  GetTime(h,m,s,hund);
  if h > 12 then begin h := h - 12; PM:='p'; end;
  if h = 0 then h := 12;
  if m < 10 then min := '0'+v2str(m) else min := v2str(m);
  Time:=v2str(h)+':'+min+pm;
end;

procedure UNCRUNCH (var Addr1,Addr2; BlkLen:Integer);
begin
  inline (
    $1E/$C5/$B6/ADDR1/$C4/$BE/ADDR2/$8B/$8E/BLKLEN/$E3/$5B/$8B/$D7/
    $33/$C0/$FC/$AC/$3C/$20/$72/$05/$AB/$E2/$F8/$EB/$4C/$3C/$10/
    $73/$07/$80/$E4/$F0/$0A/$E0/$EB/$F1/$3C/$18/$74/$13/$73/$19/
    $2C/$10/$02/$C0/$02/$C0/$02/$C0/$02/$C0/$80/$E4/$8F/$0A/$E0/
    $EB/$DA/$81/$C2/$A0/$00/$8B/$FA/$EB/$D2/$3C/$1B/$72/$07/$75/$CC/
    $80/$F4/$80/$EB/$C7/$3C/$19/$8B/$D9/$AC/$8A/$C8/$B0/$20/$74/$02/
    $AC/$4B/$32/$ED/$41/$F3/$AB/$8B/$CB/$49/$E0/$AA/$1F);
end;

function b2str(B: boolean): string;
begin
  if b = false then begin b2str:= 'NO '; exit; end;
  if b = true then begin b2str:= 'YES'; exit; end;
end;

procedure Prt2S;
var c: char;
    cnt: byte;
begin
  while pos('|',s) > 0 do
  begin
    cnt:=pos('|',s);
    c:= s[cnt+1];
    case c of
      'B': begin
             delete(s,cnt,2);
             insert(#27'[1;34m',s,cnt);
           end;
      'b': begin
             delete(s,cnt,2);
             insert(#27'[0;34m',s,cnt);
           end;
      'R': begin
             delete(s,cnt,2);
             insert(#27'[1;31m',s,cnt);
           end;
      'r': begin
             delete(s,cnt,2);
             insert(#27'[0;31m',s,cnt);
           end;
      'Y': begin
             delete(s,cnt,2);
             insert(#27'[1;33m',s,cnt);
           end;
      'y': begin
             delete(s,cnt,2);
             insert(#27'[0;33m',s,cnt);
           end;
      'G': begin
             delete(s,cnt,2);
             insert(#27'[1;32m',s,cnt);
           end;
      'g': begin
             delete(s,cnt,2);
             insert(#27'[0;32m',s,cnt);
           end;
      'W': begin
             delete(s,cnt,2);
             insert(#27'[1;37m',s,cnt);
           end;
      'w': begin
             delete(s,cnt,2);
             insert(#27'[0;37m',s,cnt);
           end;
      'M': begin
             delete(s,cnt,2);
             insert(#27'[1;35m',s,cnt);
           end;
      'm': begin
             delete(s,cnt,2);
             insert(#27'[0;35m',s,cnt);
           end;
      'D': begin
             delete(s,cnt,2);
             insert(#27'[1;30m',s,cnt);
           end;
      'd': begin
             delete(s,cnt,2);
             insert(#27'[0;30m',s,cnt);
           end;
      'C': begin
             delete(s,cnt,2);
             insert(#27'[1;36m',s,cnt);
           end;
      'c': begin
             delete(s,cnt,2);
             insert(#27'[0;36m',s,cnt);
           end;
    end;
  end;
  writecon(s+#13#10);
end;

procedure Input1;
var s: string;
    c: char;
    b: byte;
begin
  s:='';
  b:=0;
  repeat
    c:=getkey;
    if not carrier and not local then exit;
    if (c <> #8) and (c <> #13) then
    begin
      s:=s+c;
      inc(b);
    end else if (c = #8) and (b > 0) then
    begin
      s[0] := chr(ord(length(s)-1));
      prt(#8#32#8);
      dec(b);
    end;
    if c <> #8 then prt(c);
    if c = #13 then prt(#10);
  until c=#13;
  sn:=s;
end;

procedure Input2;
var s: string;
    c: char;
    b: byte;
begin
  s:='';
  b:=0;
  repeat
    c:=getkey;
    if not carrier and not local then exit;
    if (c <> #8) and (c <> #13) then
    begin
      s:=s+c;
      inc(b);
    end else if (c = #8) and (b > 0) then
    begin
      s[0] := chr(ord(length(s)-1));
      prt(#8#32#8);
      dec(b);
    end;
    if c <> #8 then begin writecon(c); xmitchar(modemf.comport,maskchar); end;
    if c = #13 then prt(#13#10);
  until c=#13;
  sn:=s;
end;

function GetKey;
var IdleStart, IdleTime: word;
    xx,yy: byte;
 begin
  if not carrier and not local then exit;
  IdleStart := timer;
  Winds[2].Color:=8;
  Winds[1].Color:=9;
  repeat
    xx := wherex;
    yy := wherey;
    WINDS[1].CX:=XX;
    WINDS[1].CY:=YY;
     CursorOff;
    BOTTOM;
    gotoxy(1,1); write('TimeON:',thisuser.timeon,' TIMELEFT:',thisuser.timeleft,' TIMER:',timer);
    TOP;
    GotoXY(XX,YY);
    CursorOn;
    idletime := timer;
    thisuser.timeleft := timeleft;
    if idletime < IdleStart then idletime := idletime + 1440;
    if idletime - IdleStart >= systemf.idletime then begin hangup; exit; end;
    if thisuser.timeleft <= 0 then begin hangup; exit; end;
  until KeyHit;
  if keypressed then begin GetKey := Readkey; exit; end;
  if carrier then
    if remotekeyhit(modemf.comport) then
    begin
      GetKey := GetChar(modemf.comport);
      exit;
    end;
 end;

function KeyHit;
begin
  KeyHit := false;
  if keypressed then keyhit := true;
  if carrier then
    if remotekeyhit(modemf.comport) then KeyHit := true;
end;

Function GetHiddenKey:Char;
 var IdleStart, IdleTime: word;
 begin
  if not carrier and not local then exit;
  IdleStart := timer;
  repeat
   idletime := timer;
   thisuser.timeleft := timeleft;
   if idletime < IdleStart then idletime := idletime + 1440;
   if idletime - IdleStart >= systemf.idletime then begin hangup; exit; end;
   if thisuser.timeleft <= 0 then begin hangup; exit; end;
  until KeyHit;
  if keypressed then begin GetHiddenKey := Readkey; exit; end;
  if carrier then
    if Remotekeyhit(modemf.comport) then
    begin
      GetHiddenKey := GetChar(modemf.comport);
      exit;
    end;
 end;

procedure Prt;
var b: byte;
    c: char;
    cnt: byte;
begin
  while pos('|',s) > 0 do
  begin
    cnt:=pos('|',s);
    c:= s[cnt+1];
    case c of
      'B': begin
             delete(s,cnt,2);
             insert(#27'[1;34m',s,cnt);
           end;
      'b': begin
             delete(s,cnt,2);
             insert(#27'[0;34m',s,cnt);
           end;
      'R': begin
             delete(s,cnt,2);
             insert(#27'[1;31m',s,cnt);
           end;
      'r': begin
             delete(s,cnt,2);
             insert(#27'[0;31m',s,cnt);
           end;
      'Y': begin
             delete(s,cnt,2);
             insert(#27'[1;33m',s,cnt);
           end;
      'y': begin
             delete(s,cnt,2);
             insert(#27'[0;33m',s,cnt);
           end;
      'G': begin
             delete(s,cnt,2);
             insert(#27'[1;32m',s,cnt);
           end;
      'g': begin
             delete(s,cnt,2);
             insert(#27'[0;32m',s,cnt);
           end;
      'W': begin
             delete(s,cnt,2);
             insert(#27'[1;37m',s,cnt);
           end;
      'w': begin
             delete(s,cnt,2);
             insert(#27'[0;37m',s,cnt);
           end;
      'M': begin
             delete(s,cnt,2);
             insert(#27'[1;35m',s,cnt);
           end;
      'm': begin
             delete(s,cnt,2);
             insert(#27'[0;35m',s,cnt);
           end;
      'D': begin
             delete(s,cnt,2);
             insert(#27'[1;30m',s,cnt);
           end;
      'd': begin
             delete(s,cnt,2);
             insert(#27'[0;30m',s,cnt);
           end;
      'C': begin
             delete(s,cnt,2);
             insert(#27'[1;36m',s,cnt);
           end;
      'c': begin
             delete(s,cnt,2);
             insert(#27'[0;36m',s,cnt);
           end;
    else
      delete(s,cnt,1);
    end;
  end;
  writecon(s);
  if Carrier then XmitString(modemf.comport,s,FALSE);
end;

procedure Prtln;
var b: byte;
    c: char;
    cnt: byte;
begin
  while pos('|',s) > 0 do
  begin
    cnt:=pos('|',s);
    c:= s[cnt+1];
    case c of
      'B': begin
             delete(s,cnt,2);
             insert(#27'[1;34m',s,cnt);
           end;
      'b': begin
             delete(s,cnt,2);
             insert(#27'[0;34m',s,cnt);
           end;
      'R': begin
             delete(s,cnt,2);
             insert(#27'[1;31m',s,cnt);
           end;
      'r': begin
             delete(s,cnt,2);
             insert(#27'[0;31m',s,cnt);
           end;
      'Y': begin
             delete(s,cnt,2);
             insert(#27'[1;33m',s,cnt);
           end;
      'y': begin
             delete(s,cnt,2);
             insert(#27'[0;33m',s,cnt);
           end;
      'G': begin
             delete(s,cnt,2);
             insert(#27'[1;32m',s,cnt);
           end;
      'g': begin
             delete(s,cnt,2);
             insert(#27'[0;32m',s,cnt);
           end;
      'W': begin
             delete(s,cnt,2);
             insert(#27'[1;37m',s,cnt);
           end;
      'w': begin
             delete(s,cnt,2);
             insert(#27'[0;37m',s,cnt);
           end;
      'M': begin
             delete(s,cnt,2);
             insert(#27'[1;35m',s,cnt);
           end;
      'm': begin
             delete(s,cnt,2);
             insert(#27'[0;35m',s,cnt);
           end;
      'D': begin
             delete(s,cnt,2);
             insert(#27'[1;30m',s,cnt);
           end;
      'd': begin
             delete(s,cnt,2);
             insert(#27'[0;30m',s,cnt);
           end;
      'C': begin
             delete(s,cnt,2);
             insert(#27'[1;36m',s,cnt);
           end;
      'c': begin
             delete(s,cnt,2);
             insert(#27'[0;36m',s,cnt);
           end;
    else
      delete(s,cnt,1);
    end;
  end;
  writecon(s+#13#10);
  if Carrier then XmitString(modemf.comport,s,TRUE);
end;

procedure Prt2M;
var b: byte;
begin
  s:=s+#13;
  XmitString(modemf.comport,s,FALSE);
end;

function str2v(S: string): longint;
var L,code: integer;
begin
  val(S,L,code);
  str2v:=L;
end;

function v2str(I: Longint): string;
var s: string;
    b: byte;
begin
  str(I,s);
  v2str:=s;
end;

procedure AnsiDetect;
var
  s,s2: string;
  c:char;
  i,y,y2,cnt: byte;
begin
 If Not(Local) Then
  Begin
   i:=0;
   s:='';
   prtln('Detecting Ansi');
   purgebuffer(modemf.comport, 'B');
   prt2m(#27'[6n');
   delay(1500);
   repeat
     c:=GetChar(modemf.comport);
     s:=s+c;
   until not remotekeyhit(modemf.comport);
   if pos(#27'[',s) > 0 then
   begin
     delete(s,pos(#27'[',s),2);
     delete(s,pos('R',s),1);
     s2:='';
     for cnt := 1 to pos(';',s) do
       delete(s,cnt,1);
     for cnt := pos(';',s)+1 to length(s) do
     begin
       c:=s[cnt];
       s2:=s2+c;
     end;
     y:=str2v(s2);
     prtln('Ansi Detected!');
     i:=1;
   end
    Else
     prtln('Nothing Detected');
   PurgeBuffer(modemf.comport,'B');
   if i=1 then
    begin
     s:='';
     s2:='';
     prt2m(^Y' '#25);
     delay(1500);
     prt2m(#27'[6n');
     delay(1500);
     repeat
       c:=GetChar(modemf.comport);
       s:=s+c;
     until not remotekeyhit(modemf.comport);
     if pos(#27'[',s) > 0 then
     begin
       delete(s,pos(#27'[',s),2);
       delete(s,pos('R',s),1);
       for cnt := 1 to pos(';',s) do
         delete(s,cnt,1);
       for cnt := 1 to length(s) do
       begin
         c:=s[cnt];
         s2:=s2+c;
       end;
       y2:=str2v(s2);
     end;
     if y2 - y = 25 then i:=2;
   end;
   if i=2 then
     prtln('Avatar Detected!')
   else
     prtln('Nothing Detected');
   End
  Else
   Begin
    I:=1;
   End;
end;

procedure ReadData(var A: byte);
var f: file of systemrec;
    m: file of modemrec;
    h: file of historyrec;
    u: file of userrec;
    s: file of stringrec;
    i: byte;
begin
  a:=0;
  assign(f,'setup.dat');
  {$I-} reset(f); {$I+}
  if IOResult = 0 then
    read(f,systemf)
  else
  begin
    a:=1;
    cursoroff;
    MessageBox('SETUP.DAT Missing or Invalid!  Running Setup...');
    delay(2000);
    cursoron;
  end;
  assign(m, 'modem.dat');
  {$I-} reset(m); {$I+}
  if IOResult = 0 then
    read(m, modemf)
  else
  begin
    a:=1;
    cursoroff;
    MessageBox('MODEM.DAT Missing or Invalid!  Running Setup...');
    delay(2000);
    cursoron;
  end;
  assign(h, 'history.dat');
  {$I-} reset(h); {$I+}
  if IOResult = 0 then
    read(h, historyf)
  else
  begin
    cursoroff;
    MessageBox('HISTORY.DAT Missing or Invalid!  Creating...');
    delay(2000);
    cursoron;
    rewrite(h);
    with historyf do
    begin
      TotalCalls:=1;
      TotalDays:=1;
      RecentPosts:=0;
      RecentCalls:=1;
      RecentULs:=0;
      RecentDLs:=0;
      NumFeedBack:=0;
      NewEmail:=0;
      Available:=FALSE;
      CallsToday:=1;
      LastOn:='DarkHawk & TES';
    end;
    write(h, historyf);
    close(h);
  end;
  assign(u, 'user.lst');
  {$I-} reset(u); {$I+}
  if IOResult <> 0 then
  begin
    cursoroff;
    MessageBox('USER.LST Missing or Invalid!  Creating...');
    delay(2000);
    cursoron;
    with thisuser do
    begin
      Handle:='DarkHawk';
      Baud:='14400';
      RealName:='Bob Jones';
      Sex:='M';
      VoiceNum:='214-555-FUCK';
      DataNum:='214-555-WiSH';
      Password:='SYSOP';
      Address1:='666 Lucifer Lane';
      Address2:='Hell Hole, AZ  75911';
      SysOpNote:='I''m the SysOp, therefore I need no note!';
      MainLevel:=100;
      MessageLevel:=100;
      FileLevel:=100;
      FilePoints:=500;
      XPert:=FALSE;
      MsgHeaderType:=1;
      PromptType:=1;
      MenuType:=1;
      StringType:=1;
      NFO1:=FALSE;
      NFO2:=FALSE;
      NFO3:=FALSE;
      NFO4:=FALSE;
      NFO5:=FALSE;
      Validated:=FALSE;
      DisplayLength:=25;
      VideoMode:=ANSI;
      ExpireDate:=123199;
      TimeInBank:=0;
      ConfOn:=1;
      for i := 1 to 5 do
      begin
        confaccessa[i] := true;
        confaccessb[i] := true;
      end;
      TimePerDay:=32767;
      Rewrite(U);
    end;
    write(u, thisuser);
    close(u);
  end;
  assign(s,'string.dat');
  {$I-} reset(s); {$I+}
  if IOResult = 0 then
    read(s,stringf)
  else
  begin
    cursoroff;
    MessageBox('STRING.DAT Missing or Invalid!  Creating...');
    delay(2000);
    cursoron;
    rewrite(s);
    with stringf do
    begin
      anonymous:='Some Lamer';
      logon:='|BLogin ID: ';
      password:='Password: ';
      system:='System 1 Password: ';
      detect:='Detecting Your Terminal Emulation';
      ansi:='You Have Ansi';
      avatar:='You Have Avatar';
      nothing:='You Have TTY';
      pause:='This Is A Pause';
      NewUserName:='Desired Handle: ';
      NUP:='Enter the NUP: ';
      NUPWrong:='Sorry, that''s the wrong NUP!';
      AlreadyUser:='You''re alread on this bbs!';
      DesiredPW:='Enter a Password to use: ';
      PhoneNum1:='Enter your phone number in the format ###-###-#### or';
      PhoneNum2:='for international numbers precede number with a "+".';
      DataNum1:='Enter your data number in the format ###-###-#### or';
      DataNum2:='for international numbers precede number with a "+".';
    end;
    write(s,stringf);
    close(s);
  end;
end;

procedure WriteAt(X,Y:byte; S: string);
begin
  gotoxy(x,y);
  write(s);
end;

procedure C(B: Byte);
begin
  textattr := (b);
end;

procedure Error(I: integer; S: string);
begin
  if i <> 0 then
  begin
    writeln(s);
    cursoron;
    halt(i);
  end;

  if i = 0 then
  begin
    writeln(s);
  end;
end;

procedure writecon (s:string);
var r:registers;
    i: integer;
begin
  for i:= 1 to length(s) do
  begin
   if s[i]=^J
    then write(s[i])
    else
      begin
        r.dl:=ord(s[i]);
        r.ah:=2;
        intr($21,r)
      end
  end;
end;

procedure ansicolor (attrib:integer);
 var
  tc:integer;
  m:string;
 const
  colorid:array [0..7] of byte=(30,34,32,36,31,35,33,37);
 begin
  m:=#27+'[0';
  tc:=attrib and 7;
  if tc<>7 then
   m:=m+';'+V2str(colorid[tc]);
  tc:=(attrib shr 4) and 7;
  if tc<>0 then
   m:=m+';'+V2str(colorid[tc]+10);
  if (attrib and 8)=8 then
   m:=m+';1';
  if (attrib and 128)=128 then
   m:=m+';5';
  m:=m+'m';
  Winds[InUSE].Color:=Attrib;
  Prt(m);
{  TextAttr:=Attrib;}
end;

end.
