/*********************************************************************/
/* This is the header file for all the Real48 <-> Double function    */
/* declarations and structures.                                      */
/*                                                                   */
/* You can use this file with the only restriction you cannot change */
/* Any specific information such as the copyright.                   */
/*                                                                   */
/* You may modify this if needed to fit your compiler.               */
/*                                                                   */
/* Use these files at your own risk.  There is no warranty for       */
/* them and they are provided AS IS.  I will not be held responsible */
/* for any damages this code may cause!                              */
/*                                                                   */
/* Copyright (C) 2000 Michael Dillon.  All Rights Reserved.          */
/* Created on: May 18, 2000                                          */
/*********************************************************************/


#if !defined( REAL48_DOUBLE_CONV__H )
#define REAL48_DOUBLE_CONV__H 1

/* These lines are needed to set structure alighment.  If your       */
/* compiler supports this, please add it to the IF statement, or     */
/* modify this one to fit your compiler only.  Structure alignment   */
/* must be 1.                                                        */
#if defined( _MSC_VER ) || defined( DJGPP ) || defined( unix )
        #pragma pack( 1 )
#endif

/* Designed structure for holding all the elements of a              */
/* Turbo Pascal real or Delphi Real48 (Real for Delphi v3 and lower) */
/* variables.                                                        */
/* This structure should not exceed nor be less than 6 bytes         */
typedef struct {
        unsigned char           Exponent;    /* Whole number value from divison     */
        unsigned short int      Mantissa1;   /* First fractional section  (16 bits) */
        unsigned short int      Mantissa2;   /* Second fractional section (16 bits) */
        union {
                unsigned char           Mantissa3:7; /* Final fractional section  ( 7 bits) */
                unsigned char           Sign:1;      /* Sign bit                            */
        } MS;
} TPReal;

/* Basic structure of the IEEE Double format.              */
/* This strcture should not exceed or be less than 8 bytes */
typedef struct {
        unsigned short int      Mantissa1; /* First fractional section  (16 bits)  */
        unsigned short int      Mantissa2; /* Second fractional section (16 bits)  */
        unsigned short int      Mantissa3; /* Third fractional section  (16 bits)  */
        unsigned short int      M4ES;      /* Final fraction (4 bits),             */
                                           /* Exponent (11 bits), and the Sign Bit */
} DoubleStruct;

/* This function will take a variable defined with the TPReal structure  */
/* and convert it to a standard Double type.                             */
double Real48ToDouble( TPReal Real48 );

/* Converts a standard double value to that of TPReal's structure format */
/* You can then save to a file using this structure.                     */
TPReal DoubleToReal48( double DblValue );

#endif
