/***************************************************************************
exus nexus nexus nexus nexus nexus nexus nexus nexus nexus nexus nexus nexus
nexus nexus nexus                nexus nexus nexu 
 nexus nexus nexus             s nexus nexus nex 
s nexus nexus nexu   ܰ          us nexus nexus ne 
us nexus nexus nex                   xus nexus nexus n 
xus nexus nexus ne                exus nexus nexus  
exus nexus nexus n               nexus nexus nexus 
nexus nexus nexus         ܰ   nexus nexus nexu 
 nexus nexus nexus NEXUS   BULLETIN      BOARD   SYSTEM s nexus nexus nex 
s nexus nexus nexus nexus nexus nexus n   nexus nexus nexus nexus nexus ne 
us nexus nexus nexus nexus nexus nexus nexus nexus nexus nexus nexus nexus n 
============================================================================ 

                      Nexus Bulletin Board System v1.00


                 Developer's Kit - PRE-RELEASE - REVISION 7.02
                            Released: 02/22/2001


    (c) Copyright 1996-2000 George A. Roberts IV. All rights reserved.

                        C/C++ FORMAT DATA STRUCTURES

                     Converted from Pascal Structures by
                         Michael Dillon aka GSValore


 Nexus, Nexus Bulletin Board System, Nexecutable, Nexus File Database
 System, Epoch Language Definition Format, and Epoch Language File Format
 are trademarks of George A. Roberts IV.

 Blue Wave is a trademark of Cutting Edge Computing.  Turbo Pascal is a
 trademark of Borland International.

============================================================================ 
        PRE-RELEASE STRUCTURES FOR NEXUS BULLETIN BOARD SYSTEM v1.00

 Note to developers: These are the pre-release structures.  All structures
 have not been included in this version due to the fact that there will be
 major changes on those files.

 The author does not guarantee that these structures will remain unchanged
 for the final (1.00) release.  We will do what we can to keep to these
 structures, as we do not wish to cause anyone undue work.

 Thank you for considering developing for Nexus!

============================================================================ 
 NOTE TO DEVELOPERS:

     George A. Roberts IV (the Author) guarantees no reliability of these    
 structures.  The Author has provided these structures to allow
 Developers to develop Nexus compatible applications.

 These structures are provided AS IS.  The Author provides no warranty,
 expressed or implied, to those who use these structures.  At no time, for
 any reason, shall the Author, his employees, contractors, or other
 affiliates be held responsible for any loss due to the use of these
 structures, whether direct or indirect.


   IMPORTANT - IMPORTANT - IMPORTANT - IMPORTANT - IMPORTANT - IMPORTANT

 DO NOT MODIFY any variables that are labeled as RESERVED.  These are
 reserved for future enhancements and modifying them may cause current or
 future versions of Nexus to run improperly or even crash.
****************************************************************************/

/****************************************************************************
  NOTE TO C/C++ DEVELOPERS

  Among these structures there are a few variables that use the Turbo Pascal
  REAL48 format.  You must convert these variables (defined as 3 short
  integers) into the double format.  When you write back to the file you must
  convert a double back to the REAL48 format.

  If your compiler supports the pack() pragma, you must use it to set the
  alignment to 1.  If your compiler supports a command line version of this
  then you can use that instead.

  When you compile your programs, you might want to verify the structure
  sizes with the ones as follows:

  tNxsUserIDX     : 85
  tNxsUserID      : 6
  tNxsUser        : 1205
  tNxsOnline      : 261
  tNxsTag         : 76
  tNxsNetwork     : 2177
  tNxsInternet    : 3560
  tNxsCallInfo    : 139
  tNxsTotals      : 309
  tNxsArchiver    : 553
  tNxsNode        : 12259
  tNxsSystem      : 94
  tNxsSecurity    : 157
  tNxsMatrix      : 2724
  tNxsSubscription: 85
  tNxsLanguage    : 213
  tNxsBaseIDX     : 6
  tNxsBaseIDIDX   : 6
  tNxsBaseTagIDX  : 51
  tNxsMsgBase     : 385
  tNxsConfIDX     : 32768
  tNxsFileBase    : 360
  tNxsLaston      : 97
  tNxsDoorTrack   : 108
  tNxsNxsDoor     : 934
  tNxsNxsProtocol : 675
  tNxsCDROMIDX    : 26
  tNxsCD          : 153
  tNxsCDMAP       : 52
  tNxsConference  : 64
  tNxsConfs       : 3328
  tNxsRequest     : 154
  tNxsFlagged     : 541
  tNxsMenu        : 591
  tNxsMenuCommand : 229
  tNxsStringIDX   : 8000
  tNxsNodeMsg     : 119
  tNxsFHeader     : 164
  tNxsFKeyword    : 21
  tNxsFDesc       : 46

  These structures were tested with Visual C++ 6 Professional.  They should
  work with any GCC or C compliant compiler.

  -- Michael Dillon aka GSValore
****************************************************************************/
#ifndef NEXUS__DEVELOPER_STRUCTURES___HEADER
#define NEXUS__DEVELOPER_STRUCTURES___HEADER_12222000 1

/****************************************************************************
 Version Number Information:
                                                                             
 <Version>    String formatted typed CONSTANT representing the string        
              display of the version number                                  
 <MajVersion> Major/Minor Version numbers - byte format. This is the current 
 <MinVersion> version that these structures support.  This can be used to    
              check the MATRIX.DAT for the version number that it is being   
              used with, for compatibility sake.                             
****************************************************************************/

const char Version[ 5 ] = "0.99";
const char MajVersion = 0;
const char MinVersion = 99;

/****************************************************************************
 CONSTANT Declarations:                                                      
                                                                             
 Various CONSTANTS that are used internally in Nexus.  They are included     
 here for reference.  They give you an idea of what type of limitations      
 that Nexus places on certain data files, so that you can impose the same    
 limitations in your programs.  Please follow these restrictions closely,    
 as if you add more than the maximum allowed, those above maximum will not   
 be used by Nexus.                                                           
****************************************************************************/


const short int MaxMsgBases     = 32767;  /* 0 to 32767                          */
const short int MaxFileBases    = 32767;  /* 0 to 32767                          */
const short int MaxMenuCommands = 50;     /* 1 to 50                             */
const short int MaxGlobalCmds   = 20;     /* 1 to 20                             */


/****************************************************************************
 TYPE Declarations:                                                         

 Various TYPES that are used throughout Nexus for internal workings and for 
 data structures in data files.  If a structure is the specific foundation  
 of a file, the filename and information will be listed before the structure
 information, so as to help you with which structures go with which files.  
****************************************************************************/

typedef char ACString[21];        /* Access Control String                 */
/* Conference Set.  Bits 0 to 25 represent a conference between A and Z    */
typedef unsigned long int JoinedConfs;

/****************************************************************************
 Filename: USERS.IDX                                                        
 Location: DATA Directory                                                   
 Format  : 1 <tNxsUserIDX> record per entry, 0 record is blank buffer           
                                                                            
 Notes   : Used to have a quick index to to the USERS.DAT file.  Records    
           must correspond with the appropriate record in the USERS.DAT     
           file.  i.e. Record 1 of USERS.IDX should match Record 1 of       
           USERS.DAT.  The <number> variable is a safeguard for a case      
           where they do not match.                                         
****************************************************************************/

typedef struct {
    char Alias[ 37 ];          /* Alias                                    */ 
    char RealName[ 37 ];       /* Real Name                                */
    signed short int Number;   /* Record Number in USERS.DAT               */
    signed long int  UserID;   /* UserID number matching the UserREC.UserID*/
    char RESERVED[ 5 ];        /* RESERVED - DO NOT MODIFY                 */
} tNxsUserIDX;

/****************************************************************************
 Filename: USERID.IDX                                                       
 Location: DATA Directory                                                   
 Format  : 1 <tNxsUserID> record per entry                                   
                                                                            
 Notes   : Used to have a quick index to to the UserIDs.  There will be one 
           record for each UserID.  The <Number> variable will be set to -1 
           if the user has been deleted.                                    
****************************************************************************/

typedef struct {
    signed long int  UserID;   /* UserID Number matching UserREC.UserID    */
    signed short int Number;   /* Record number in USERS.DAT               */
} tNxsUserID;


/****************************************************************************
 Filename: USERS.DAT                                                        
 Location: DATA Directory                                                   
 Format  : 1 <tNxsUser> record per entry, 0 record is blank buffer           
                                                                            
 Notes   : Used to store user information.  One record per user. Record     
           #0 is a blank record that is used to buffer the file out so      
           that the user numbers start at 1.                                
****************************************************************************/

/****************************************************************************
 Uflags Set:                                                                
               Items have a starting designation character to tell you what 
               type of flag they are:                                       
                                                                            
               R  =  Restriction                                            
               C  =  Control                                                
               S  =  Special Priveledge                                     
                                                                            
****************************************************************************/

/* AR flags : Bits 0 to 26 define flags the rest are unused.               */
typedef unsigned long int ARFlags;

/* UFlags : User Flags, defined by the values of the 3 bytes using the     */
/*          UFLAGS_* constants                                             */
typedef unsigned char UFlags[3];

/* First Byte of UFlags */
#define UF_RLOGON       0x01  /* Restrict: One Call Per Day               */
#define UF_RCHAT        0x02  /* Restrict: Cannot Page SysOp              */
#define UF_RESERVED1    0x04  /* RESERVED - DO NOT MODIFY                 */
#define UF_RESERVED2    0x08  /* RESERVED - DO NOT MODIFY                 */
#define UF_RESERVED3    0x10  /* RESERVED - DO NOT MODIFY                 */
#define UF_RESERVED4    0x20  /* RESERVED - DO NOT MODIFY                 */
#define UF_RPOST        0x40  /* Restrict: Cannot Post Messages           */
#define UF_RPRIVATE     0x80  /* Restrict: Cannot Post Private Messages   */
/* Second Byte of UFlags */
#define UF_RESERVED5    0x01  /* RESERVED - DO NOT MODIFY                 */
#define UF_RDELMSG      0x02  /* Restrict: Force Private Message Deletion */
#define UF_RESERVED6    0x04  /* RESERVED - DO NOT MODIFY                 */
#define UF_CQUICKKEY    0x08  /* Control : QuickKey Input Mode            */
#define UF_RESERVED7    0x10  /* RESERVED - DO NOT MODIFY                 */
#define UF_CPAUSE       0x20  /* Control : Pause When Screen Full         */
#define UF_CNOVICE      0x40  /* Control : Novice Help Level for Menus    */
#define UF_CANSI        0x80  /* Control : ANSI when detected             */
/* Third Byte of UFlags */
#define UF_CCOLOR       0x01  /* Control : Display Color                  */
#define UF_CALERT       0x02  /* Control : Alert SysOp When User Logs On  */
#define UF_CUSETAGLINES 0x04  /* Control : Use Taglines for Messages      */
#define UF_CRIP         0x08  /* Control : RIP when detected              */
#define UF_SNOULDLRATIO 0x10  /* Special : No UL/DL Ratio enforced        */
#define UF_SNOPOSTRATIO 0x20  /* Special : No Post/Call Ratio enforced    */
#define UF_SNOFILEPTS   0x40  /* Special : No File Point Checking enforced*/
#define UF_SNODELETION  0x80  /* Special : May not be Deleted             */


typedef struct {
    char       Alias[ 37 ];       /* User's Alias                            */
    char       RealName[ 37 ];    /* User's Real Name                        */
    long int   UserID;            /* User's ID                               */
    unsigned char RESERVED[ 33 ]; /* RESERVED - DO NOT MODIFY                */
    char       Password[ 21 ];    /* Password                                */
    char       VoicePhone[ 21 ];  /* Voice Phone Number                      */
    char       DataPhone[ 21 ];   /* Data Phone Number                       */
    char       OptPhone1[ 21 ];   /* Optional Phone #1                       */
    char       OptPhone2[ 21 ];   /* Optional Phone #2                       */
    char       Street1[ 31 ];     /* Street Address Line #1                  */
    char       Street2[ 31 ];     /* Street Address Line #2                  */
    char       CityState[ 41 ];   /* City, State (Province)                  */
    char       ZipCode[ 21 ];     /* Zipcode                                 */
    long int   Birthdate;         /* Birthdate (UNIX Time/Date)              */
    char       Gender;            /* Gender                                  */
    char       Option1[ 31 ];     /* Optional Field #1                       */
    char       Option2[ 41 ];     /* Optional Field #2                       */
    char       Option3[ 41 ];     /* Optional Field #3                       */
    char       SysopNote[ 41 ];   /* SysOp note                              */
    char       CallingFrom[ 41 ]; /* Calling From String                     */
    char       Title[ 21 ];       /* Title (FUTURE USE)                      */
    char       Description[4][41];/* User Self Description (FUTURE USE)      */
    char       ClearEntry[ 20 ];  /* Clear Entries Flags (BOOLEAN)           */
    unsigned char RESERVED2[ 37 ];/* RESERVED - DO NOT MODIFY                */
    unsigned char phEntryType;    /* Phone Number Entry Type:                */
                                  /* 1: US/Canada  2: International          */
    unsigned char zipEntryType;   /* Zipcode Entry Type:                     */
                                  /* 1: US         2: Canada/International   */
    long int   FirstOnDate;       /* First Called BBS Date (UNIX Time/Date)  */
    long int   LastOnDate;        /* Last Called BBS Date  (UNIX Time/Date)  */
    long int   LastFileScan;      /* Last File Newscan Date/Time             */
    unsigned char SecurityLevel;  /* Security Level (1-100)                  */
    UFlags     UserFlags;         /* User Flags                              */
    ARFlags    UserARFlags;       /* User AR Flags                           */
    char       LockedOut;         /* Is User Locked Out? (BOOLEAN)           */ 
    char       Deleted;           /* Is User Deleted? (BOOLEAN)              */
    char       LockedFile[ 9 ];   /* Lockout File to Display to User         */
    unsigned char RESERVED3[ 50 ];/* RESERVED - DO NOT MODIFY                */
    long int   TotalTime;         /* Total Minutes spent on this BBS         */
    short int        TotalCalls;        /* Number of Calls to this BBS             */
    short int        TimeLeftToday;     /* Number of Minutes Left Today            */
    unsigned char CallsToday;     /* Number of Calls Today                   */
    unsigned char IllegalLogons;  /* Number of Illegal Logon Attempts        */
    long int   Credits;           /* Credits                                 */
    short int  TimeBank;          /* Number of Minutes in Time Bank          */
    short int  TimeBankToday;     /* Time Added to Time Bank Today           */
    char       TrapActivity;      /* Trapping User's Activity?               */
    char       TrapSeperate;      /* If above=TRUE, Use seperate TRAP file?  */
    char       AutoChatLog;       /* Automatically Log User's Chat Activity? */
    char       ChatLogSep;        /* If above=TRUE, Use seperate CHAT file?  */
    char       LogSep;            /* Log this user seperately?               */
    unsigned char ScreenLength;   /* Number of Lines on Screen               */
    short int  ColorScheme;       /* Color Scheme Number (SCHEME.DAT)        */
    short int  UserStartMenu;     /* Menu Number to Start User On            */
    short int  TimeBankWith;      /* time withdrawn from timebank TODAY      */
    unsigned char RESERVED4[ 48 ];/* RESERVED - DO NOT MODIFY                */
    unsigned char LastFConf;      /* Last File Conference In                 */
    short int  LastFBase;         /* Last File Base In                       */
    long int   UploadKB;          /* KB Uploaded                             */
    long int   DownloadKB;        /* KB Downloaded                           */
    short int  UploadFiles;       /* Number of Files Uploaded                */
    short int  DownloadFiles;     /* Number of Files Downloaded              */
    short int  FilePoints;        /* File Points                             */
    char       DefProtocol;       /* Default Protocol, @=Ask Each Transfer   */
                                  /* File Bases that User is Sysop of        */
    short int  FBaseSysop[ 20 ];
    unsigned char RESERVED5[ 50 ];/* RESERVED - DO NOT MODIFY                */
    unsigned char LastMConf;      /* Last Message Conference In              */
    short int  LastMBase;         /* Last Message Base In                    */
    short int  NumPosts;          /* Number of Posts                         */
    short int  NumFeedback;       /* Number of Feedback Sent                 */
    char       MessageRuler;      /* Message Ruler 0 = OFF  1 = ON           */
    char       MessageEditor;     /*-1 : Nexus Full-Screen Editor            */
                                  /* 0 : Nexus Line Editor                   */
                                  /* 1^: External Editor                     */
                                  /* Message Bases that user is Sysop of     */
    short int  MBaseSysop[ 20 ];
    unsigned char Subscription;   /* Current Subscription Level              */
    long int   SubDate;           /* Subscription Level Start Date/Time in   */
                                  /* UNIX Date/Time Stamp format             */
    unsigned char Language;       /* Language this user has selected         */
    unsigned char RESERVED6[ 99 ];/* RESERVED - DO NOT MODIFY                */
} tNxsUser;

/****************************************************************************
 Filename: USERxxxx.DAT    (xxxx = Node number in format 0001, 0010, etc.)  
 Location: DATA Directory                                                   
 Format  : 1 <tNxsOnline> record                                             
                                                                            
 Notes   : Used to provide information to external programs about a         
           particular node's current status.  This information is useful    
           for a door program that is written specifically to work with     
           Nexus, such as a callback verifier or multiline chat program.    
           Much of the information found in the USERS.DAT file may not be   
           necessary, so the information in the USERxxxx.DAT file may be    
           used.  If more information is needed, the <Number> variable      
           points to the record number in the USERS.DAT file where this     
           user is located.                                                 
                                                                            
           This file is automatically created when a user logs on to Nexus  
           and is deleted when the user logs off.  Nexus creates a file for 
           the node if it is at the Waiting for Caller screen logged in and 
           places a 2 in the appropriate index value in the ONLINE.IDX so   
           that other nodes of Nexus will see that this node is waiting for 
           a caller.                                                        
****************************************************************************/

typedef struct {
    char          Name[ 37 ];     /* User Logon Name                        */
    char          real[ 37 ];     /* User Real Name                         */
    long int      UserID;         /* UserID                                 */
    short int     TimeLeft;
    unsigned char RESERVED[ 31 ]; /* RESERVED - DO NOT MODIFY               */
    char          business[ 41 ]; /* User Business (calling from)           */
    short int     number;         /* User Number                            */
    char          activity[ 21 ]; /* Current Activity                       */
    char          available;      /* User Available?                        */
    char          paged;          /* User Paged?                            */
    short int     pagedby;        /* Paged by Node Number                   */
    char          pagedstr[ 73 ]; /* Paged Reason                           */
    unsigned short int  Baud;           /* 0 = Local  Other = Connect Rate / 10   */
    unsigned short int  LockBaud;       /* 0 = Port not locked                    */
                                  /* Locked Baud Rate / 10                  */
    unsigned short int  Comport;        /* 0=Local                                */
    unsigned char Comtype;        /* 0=Fossil  1=Interrupt (internal)       */
                                  /* 2=Digiboard                            */
    unsigned short int  emulation;      /* 0=TTY   1=ANSI   2=RIPscrip            */
} tNxsOnline;

/****************************************************************************
 Filename: TAGLINES.DAT                                                     
 Location: DATA Directory                                                   
 Format  : 1 <tNxsTag> record per entry                                      
                                                                            
 Notes   : Used to provide users the ability to add taglines to their       
           messages.  A global tagline file is able to be added to by the   
           users and then they may select any of the taglines to add to     
           their message.                                                   
****************************************************************************/
  
typedef struct {
        char      Tag[ 76 ];      /* Tagline                               */
} tNxsTag;

/****************************************************************************
 Filename: NETWORK.DAT                                                      
 Location: DATA Directory                                                   
 Format  : 1 <tNxsNetwork> record                                            
                                                                            
 Notes   : Used to store default values and information regarding message   
           networks.  There is one record of <tNxsNetwork> in the            
           NETWORK.DAT file.                                                
****************************************************************************/

typedef struct {
    struct {
     unsigned short int Zone;     /* Zone number                            */
     unsigned short int Net;      /* Net number                             */
     unsigned short int Node;     /* Node number                            */
     unsigned short int Point;    /* Point number                           */
    } Address[ 30 ];              /* Address Information                    */
    char          Origins[20][51];/* Origin Lines                           */
    unsigned char RES2[ 807 ];    /* RESERVED - DO NOT MODIFY               */
    unsigned char NodelistType;   /* Nodelist Type Found in NODELIST PATH   */
                                  /*     0: No Nodelist                     */
                                  /*     1: Version 7                       */
                                  /*     2: Frontdoor                       */
                                  /* other: RESERVED                        */
                                  /* currently UNUSED                       */
    unsigned char Text_color;     /* default color of standard text         */
    unsigned char Quote_color;    /* default color of quoted text           */
    unsigned char Tag_color;      /* default color of tagline               */
    unsigned char Oldtear_color;  /* default color old tearline             */
    unsigned char Tear_color;     /* default color of tear line             */
    unsigned char Origin_color;   /* default color of origin line           */
    char          SKludge;        /* default strip kludge lines?            */
    char          SSeenby;        /* default strip SEEN-BY lines?           */
    char          SOrigin;        /* default strip origin line?             */
    char          nodelistp[80];  /* Path to Nodelist Files                 */
    char          isprivate;      /* Default Netmail Private?               */
    char          iscrash;        /* Default Netmail Crash?                 */
    char          isfattach;      /* Default Netmail File Attach?           */
    char          iskillsent;     /* Default Netmail Kill/Sent?             */
    char          ishold;         /* Default Netmail Hold?                  */
    char          isfilereq;      /* Default Netmail File Request?          */
    char          isreqrct;       /* Default Netmail ReturnReceiptRequest?  */
    char          isdirect;       /* Default Netmail Direct?                */
    unsigned char res[ 12 ];      /* RESERVED - DO NOT MODIFY               */
} tNxsNetwork;

/****************************************************************************
 Filename: INTERNET.DAT                                                     
 Location: DATA Directory                                                   
 Format  : 1 <tNxsInternet> record                                           
                                                                            
 Notes   : Used to store default values and information regarding Internet  
           gateways.  There is one record of <InternetREC> in the           
           INTERNET.DAT file.                                               
****************************************************************************/

typedef struct {
    struct {
     char         Name[ 41 ];     /* Name of Gateway (for informational use) */
     char         ToName[ 37 ];   /* Name messages should be addressed to,   */
                                  /* many times 'UUCP'                       */
     struct {
           unsigned short int Zone;     /* Zone number                             */
           unsigned short int Net;      /* Net number                              */
           unsigned short int Node;     /* Node number                             */
           unsigned short int Point;    /* Point number                            */
     } ToAddress;                 /* Address that messages should be sent to */
     unsigned char FromAddress;   /* Address (from NETWORK.DAT) that messages*/
                                  /* should come from                        */
     unsigned char RESERVED1[30]; /* RESERVED - DO NOT MODIFY                */
    } Gateways[ 30 ];
    unsigned char  RESERVED2[50]; /* RESERVED - DO NOT MODIFY                */
} tNxsInternet;

/****************************************************************************
 Filename: CALLINFO.DAT, CALLINFO.xxx                                       
 Location: DATA Directory                                                   
 Format  : 1 <tNxsCallInfo> record for each date                            
                                                                            
 Notes   : Used to store information regarding statistics per node (in the  
           CALLINFO.xxx files) and for the whole system (CALLINFO.DAT).     
           These statistics are on a per date basis.  Dates may or may not  
           be consecutive.  If a date does not exist, there was no activity.
****************************************************************************/

typedef struct {
    unsigned char RESERVED1[ 9 ];       /* RESERVED - DO NOT MODIFY           */
    short int     UserBaud[ 41 ];       /* Number of calls at this particular */
                                        /* baud rate.  Baud rates are:        */
                                        /*                                    */
                                        /*  0 - 300     1 - 1200    2 - 2400  */
                                        /*  3 - 4800    4 - 7200    5 - 9600  */
                                        /*  6 - 12000   7 - 14400   8 - 16800 */
                                        /*  9 - 19200  10 - 21600  11 - 24000 */
                                        /* 12 - 26400  13 - 28800  14 - 31200 */
                                        /* 15 - 33600  16 - 38400  17 - n/a   */
                                        /* 18 - n/a    19 - n/a    20 - n/a   */
                                        /* 21 - n/a    22 - 57600  23 - n/a   */
                                        /* 24 - n/a    25 - n/a    26 - n/a   */
                                        /* 27 - n/a    28 - 76800  29 - n/a   */
                                        /* 30 - n/a    31 - n/a    32 - n/a   */
                                        /* 33 - n/a    34 - 115200 35 - n/a   */
                                        /* 36 - n/a    37 - n/a    38 - n/a   */
                                        /* 39 - n/a    40 - All others        */
    short int     Active;               /* Percent Activity                   */
    short int     Calls;                /* Number of Calls                    */
    short int     Newusers;             /* Number of New Users                */
    short int     Pubpost;              /* Public Posts                       */
    short int     Comments;             /* Comments to SysOp                  */
    short int     CriticalErrors;       /* Critical Errors                    */
    short int     Uploads;              /* Files Uploaded                     */
    short int     Downloads;            /* Files Downloaded                   */
    long int      UlKB;                 /* KB Uploaded                        */
    long int      DlKB;                 /* KB Downloaded                      */
    long int      Date;                 /* Date of entry (UNIX Time/Date)     */
    unsigned char RESERVED[ 20 ];       /* RESERVED - DO NOT MODIFY           */
} tNxsCallInfo;

/****************************************************************************
 Filename: TOTALS.DAT, TOTALS.xxx                                           
 Location: DATA Directory                                                   
 Format  : 1 <tNxsTotals> record in each file                               
                                                                            
 Notes   : Used to store information regarding statistics per node (in the  
           TOTALS.xxx files) and for the whole system (TOTALS.DAT).  This   
           information is information since the <date> field.               
****************************************************************************/

typedef struct {
    unsigned char RESERVED1[ 9 ];       /* RESERVED - DO NOT MODIFY           */
    long int      UserBaud[ 41 ];       /* Number of calls at this particular */
                                        /* baud rate.  Baud rates are:        */
                                        /*                                    */
                                        /*  0 - 300     1 - 1200    2 - 2400  */
                                        /*  3 - 4800    4 - 7200    5 - 9600  */
                                        /*  6 - 12000   7 - 14400   8 - 16800 */
                                        /*  9 - 19200  10 - 21600  11 - 24000 */
                                        /* 12 - 26400  13 - 28800  14 - 31200 */
                                        /* 15 - 33600  16 - 38400  17 - n/a   */
                                        /* 18 - n/a    19 - n/a    20 - n/a   */
                                        /* 21 - n/a    22 - 57600  23 - n/a   */
                                        /* 24 - n/a    25 - n/a    26 - n/a   */
                                        /* 27 - n/a    28 - 76800  29 - n/a   */
                                        /* 30 - n/a    31 - n/a    32 - n/a   */
                                        /* 33 - n/a    34 - 115200 35 - n/a   */
                                        /* 36 - n/a    37 - n/a    38 - n/a   */
                                        /* 39 - n/a    40 - All others        */
    long int      Active;               /* Percent Activity                   */
    long int      Calls;                /* Number of Calls                    */
    long int      Newusers;             /* Number of New Users                */
    long int      Pubpost;              /* Public Posts                       */
    long int      Comments;             /* Comments to SysOp                  */
    long int      CriticalErrors;       /* Critical Errors                    */
    long int      Uploads;              /* Files Uploaded                     */
    long int      Downloads;            /* Files Downloaded                   */
    long int      Date;                 /* Last Date this was written         */
    unsigned char RESERVED[ 100 ];      /* RESERVED - DO NOT MODIFY           */
} tNxsTotals;

/****************************************************************************
 Filename: ARCHIVER.DAT                                                     
 Location: DATA Directory                                                   
 Format  : 1 <tNxsArchiver> record in each file                              
                                                                            
 Notes   : Used to store information regarding statistics per node (in the  
           TOTALS.xxx files) and for the whole system (TOTALS.DAT).  This   
           information is information since the <date> field.               
****************************************************************************/

typedef struct {
    char          Active;         /* Is archiver active to be used?           */
                                  /* Note if set to view with internal methods*/
                                  /* Nexus will still allow viewing even if   */
                                  /* archiver is disabled.                    */
    char          Name[41];       /* Name of archiver                         */
    char          ListFiles[81];  /* List archive commandline (blank=internal)*/
    char          Compress[81];   /* Compress archive commandline             */
    char          Decompress[81]; /* Decompress archive commandline           */
    char          TestFiles[81];  /* Test archive commandline                 */
    char          Comment[81];    /* Comment archive commandline              */
    short int     ErrorLevel;     /* Errorlevel for success on external       */
    char          Extension[4];   /* File extention (used only for records 12+*/
    unsigned char RESERVED[100];  /* RESERVED -- DO NOT MODIFY                */
} tNxsArchiver;

/****************************************************************************
 Filename: NODExxxx.DAT                                                     
 Location: DATA Directory                                                   
 Format  : 1 <tNxsNode> Record                                              
                                                                            
 Notes   : Used to store modem and node specific information for each node. 
           There will be one file for each node that has been configured    
           for use in Nexus.                                                
****************************************************************************/

typedef struct {
    unsigned char PortNumber;     /* Com Port Number/Digiboard Port Number    */
                                  /* 1-8  : Fossil/Interrupt                  */
                                  /* 1-30 : Digiboard                         */
    long int      MaximumBaud;    /* Maximum/Locked Baud Rate                 */
    char          LockPort;       /* whether to force baud rate               */
    unsigned char drvType;        /* 0 : Local Only                           */
                                  /* 1 : Fossil                               */
                                  /* 2 : Digiboard                            */
                                  /* 3 : Interrupt Serial                     */
    short int     chatBegin[ 7 ]; /* Start Time when SysOp is available for   */
                                  /* Chat with Users   Start/End=0 Always     */
    short int     chatEnd[ 7 ];   /* Chat Time End                            */
    short int     dlBegin[ 7 ];   /* Start Time when Users may download files */
                                  /* Start/End = 0 for always                 */
    short int     dlEnd[ 7 ];     /* Download Time End                        */
    long int      MinBaudRate;    /* Minimum Baud Rate allowed on System      */
    short int     minStart[ 7 ];  /* Start Time when Callers below the Min.   */
                                  /* baud rate may log on to the system       */
                                  /* Start/End=0 Never allowed on             */
    short int     minEnd[ 7 ];    /* End Below Min Time                       */
    short int     mindlStart[ 7 ];/* Start Time when Callers below the Min.   */
                                  /* Baud rate may download files.            */
                                  /* Start/End = 0  Never Allow               */
    short int     mindlEnd[ 7 ];  /* Below Min. DL Time End                   */
    char          NoNewUsers;     /* This node does not accept New Users      */
    unsigned char swapProtocol;
    unsigned char swapArchiver;
    unsigned char swapDoor;
    unsigned char swapEditor;
    unsigned char swapChat;
    unsigned char swapLShell;
    unsigned char swapFrontEnd;   /* swap setting for front-end program       */
    char          UseFrontEnd;    /* Use front-end program                    */
    char          FrontEndPath[80];/*path\filename to front-end program       */
    char          Init1[ 81 ];    /* Modem Init String #1                     */
    char          Init2[ 81 ];    /* Modem Init String #2                     */
    char          Init3[ 81 ];    /* Modem Init String #3                     */
    char          Answer[ 81 ];   /* Modem Answer String                      */
    char          Hangup[ 41 ];   /* Modem Hang-Up String                     */
    char          Offhook[ 41 ];  /* Modem Off-Hook String                    */
    char          Onhook[ 41 ];   /* Modem On-Hook String                     */
    struct {
      char          Response[41]; /* Modem Response String                    */
      unsigned char OutELevel;    /* Errorlevel returned from frontend        */
      unsigned char Action;       /* Action to perform when receiving this    */ 
                                  /* Response string or OutELevel:            */
                                  /* 1: LOG ON WITH baud BAUD RATE            */
                                  /* 2: EXIT WITH elevel ERRORLEVEL           */
                                  /* 3: RUN cmdline COMMANDLINE               */
      signed long int Baud;       /* Baud to log on with                      */
      unsigned char ELevel;       /* Errorlevel to exit with                  */
      char          CmdLine[80];  /* CmdLine to shell out with                */
      unsigned char RESERVED[100];/* RESERVED -- DO NOT USE!                  */
    } Responses[ 50 ];
    unsigned char RESERVED[200];  /* RESERVED -- DO NOT USE!                  */
} tNxsNode;

/****************************************************************************
 Filename: SYSTEM.DAT                                                       
 Location: DATA Directory                                                   
 Format  : 1 <tNxsSystem> record                                             
                                                                            
 Notes   : Used to store information neccessary for the BBS to operate.     
           This information is sensitive, and should be modified with care. 
           Modifying the information this file improperly could render a    
           system totally useless, and could seriously damage data files.   
****************************************************************************/

typedef struct {                  /* SYSTEM.DAT                               */
    long int      callernum;      /* System Caller Number                     */
    long int      numusers;       /* Number of Callers to this node           */
    short int     highnode;       /* Highest Node Number Ever Executed        */
    unsigned char RESERVED1[ 9 ]; /* RESERVED - DO NOT MODIFY                 */
    long int      LastMBaseID;    /* Last MBaseID that was used               */
    long int      LastFBaseID;    /* Last FBaseID that was used               */
    long int      LastDoorID;     /* Last DoorID that was used                */
    long int      LastEditorID;   /* Last EditorID that was used              */
    long int      LastUserID;     /* Last UserID that was used                */
    long int      NKeywords;      /* Number of Keyword Records per file entry */
    long int      NDescLines;     /* Number of Description lines per file     */
    long int      LastDate;       /* Last date Nexus was run (UNIX Time/Date) */
    unsigned char RESERVED[ 43 ]; /* RESERVED - DO NOT MODIFY                 */
} tNxsSystem;

/****************************************************************************
 Filename: SECURITY.DAT                                                     
 Location: DATA Directory                                                   
 Format  : Record #0 is holding record                                      
           100 <tNxsSecurity> records                                       
                                                                            
 Notes   : Used to store security level configuration for each security     
           level.  The security level is not used if the <Active> variable  
           is set to FALSE.                                                 
****************************************************************************/


typedef struct {
    char          Active;          /* Is Security Level begin used?            */
    char          Description[21]; /* Description of Security Level            */
    unsigned char CallsPerDay;     /* Number of Calls Per Day for SL           */
    short int     TimePerCall;     /* Time Per Call (minutes)  0=Use Time/Day  */
    short int     TimePerDay;      /* Time Per Day (minutes)                   */
    short int     PostPerCall;     /* Posts Per Call Required                  */
    short int     DLRatioFiles;    /* Number of Files DLed before 1 upload req */
    short int     DLRatioKb;       /* Number of Kb DLed before 1 Kb required   */
    short int     MaxInTB;         /* Maximum amount in Time Bank              */
    short int     WithTBDay;       /* Withdrawal Maximum per Day               */
    short int     WithTBCall;      /* Withdrawal Maximum per Call              */
    short int     AddTBDay;        /* Maximum minutes per Day can be Added     */
    short int     AddTBCall;       /* Maximum minutes per Call can be Added    */
    unsigned char RESERVED1[10];   /* RESERVED - DO NOT MODIFY                 */
    short int     MaxDLPerCall[12];/* Max Files DLed based on baud             */
                                   /*           1 =300    2 =1200   3 =2400    */
                                   /* 4 =4800   5 =7200   6 =9600   7 =12000   */
                                   /* 8 =14400  9 =19200  10=38400  11=57600   */
                                   /* 12=115200                                */
    short int     RESERVED2[8];    /* RESERVED - DO NOT MODIFY                 */
    long int      MaxKbPerCall[12];/* Max Kb DLed based on baud                */
                                   /*           1 =300    2 =1200   3 =2400    */
                                   /* 4 =4800   5 =7200   6 =9600   7 =12000   */
                                   /* 8 =14400  9 =19200  10=38400  11=57600   */
                                   /* 12=115200                                */
    short int     RESERVED3[8];    /* RESERVED - DO NOT MODIFY                 */
} tNxsSecurity;

/****************************************************************************
 Filename: MATRIX.DAT                                                       
 Location: Main NEXUS Directory                                             
 Format  : 1 <tNxsMatrix> Record                                             
                                                                            
 Notes   : This is the main Nexus Data File.  It contains various info      
           regarding the general setup of the system.  This file will       
           usually be read before any other data files in order to obtain   
           the path information.  You may obtain the location of this file  
           (i.e. the main Nexus Directory) by getting the NEXUS environment 
           variable ( getenv("NEXUS"); ).  More information on the Nexus    
           environment variable will be found in ENVIRON.DOC in the Nexus   
           Developer's Kit.                                                 
                                                                            
****************************************************************************/

typedef struct {
    unsigned char MajorVersion;     /* major version number                    */
    unsigned char MinorVersion;     /* major version number                    */
    char          DataPATH[80];     /* DATA path                               */
    char          GraphicsPATH[80]; /* GRAPHICS path                           */
    char          MenuPATH[80];     /* MENUS path                              */
    char          LogPATH[80];      /* LOG path                                */
    char          MessagePATH[80];  /* MESSAGE path                            */
    char          UtilityPATH[80];  /* UTILITY path                            */
    char          SemaphorePATH[80];/* SEMAPHORE FILE path                     */
    char          FileReqPATH[80];  /* FILE REQUEST Holding path               */
    char          FilePATH[80];     /* Default FILE path (.NFB Files)          */
    char          TempPATH[80];     /* TEMP path (node temp is NODExxxx under) */
    char          SwapPATH[80];     /* SWAP path (node swap is NODExxxx under) */
    char          NexecutePATH[80]; /* Compiled Nexecutable Path               */
    char          ExtUploadPATH[80];/* Path to external program run after      */
                                    /* an upload and before checking for       */
                                    /* FILE_ID.DIZ                             */
    char          FileAttPATH[80];  /* File Attach Path for MSGs               */
    char          NetmailPATH[80];  /* Netmail Path for nxEMAIL                */
    
    char          BBSName[81];      /* BBS name                                */
    unsigned char RESERVED1[44];    /* RESERVED - DO NOT MODIFY                */
    char          SysopName[31];    /* SysOp's Full Real Name or Alias         */
    short int     MaximumUsers;     /* Currently unused                        */
    unsigned char CurrentBuild;     /* Current Build number (1 => .01 )        */
    char          CurBuildMod;      /* Current Build Modifier (should be       */
                                    /* appended to the build number (.01a)     */
                                    /* will be #32 or 0x20 if no modifier      */
    unsigned char RESERVED2[54];    /* RESERVED - DO NOT MODIFY                */
    char          pwSysOp[21];      /* SysOp Password (BLANK for None)         */
    char          pwNewUser[21];    /* NewUser Password (BLANK for None)       */
    unsigned char RESERVED3[62];    /* RESERVED - DO NOT MODIFY                */
    short int     PreEventWarn;     /* Time before event Warning (min)         */
    unsigned char defLanguage;      /* Default Language (FUTURE)               */
    unsigned char RESERVED4[29];    /* RESERVED - DO NOT MODIFY                */
    ACString      acsSysOp;         /* SysOp Access String                     */
    ACString      acsCoSysOp;       /* Co-SysOp Access String                  */
    ACString      acsMsgSysOp;      /* Message Base SysOp Access String        */
    ACString      acsFileSysOp;     /* File Base SysOp Access String           */
    ACString      acsSeePW;         /* See Password at Logon Access String     */
    ACString      acsSeeSysOpPW;    /* See SysOp Password remotely             */
    ACString      acsNormalPost;    /* Post Public Message Access String       */
    ACString      acsNetmail;       /* Post Netmail Access String              */
    ACString      acsSeeUnval;      /* See Unvalidated Files Access String     */
    ACString      acsDLUnval;       /* Download Unvalidated Files Access String*/
    ACString      acsNoDLRatio;     /* No UL/DL Ratio Access String            */
    ACString      acsRESERVED1;     /* RESERVED - DO NOT MODIFY                */
    ACString      acsNoFilePts;     /* No Filepoint Checking Access String     */
    ACString      acsULValidate;    /* Uploads Need Validation Access String   */
    ACString      acsSetNetFlag;    /* Set Netmail Flags Access String         */
    ACString      acsNetOutZone;    /* Netmail Out-of-Zone Access String       */
    ACString      acsNoNodeChk;     /* No Nodelist Check Access String         */
    ACString      acsUntagMand;     /* Allow to untag mandatory bases?         */
    unsigned char RESERVED5[189];   /* RESERVED - DO NOT MODIFY                */

    unsigned char maxFeedback;      /* Maximum Feedback per call               */
    unsigned char maxPublicPost;    /* Maximum Public Posts per call           */
    unsigned char maxPage;          /* Maximum Sysop Pages per call            */
    unsigned char maxMsgLines;      /* Maximum Lines in Message                */
    unsigned char maxCSMsgLines;    /* Maximum Lines in Message for Co-SysOp + */
    unsigned char maxLogonTries;    /* Maximum Attempts to enter Password      */
    unsigned char chatSysOp;        /* SysOp color in chat mode (TEXTATTR)     */
    unsigned char chatUser;         /* User color in chat mode (TEXTATTR)      */
    short int     minMsgSpace;      /* Minimum KB drive space left to post     */
    unsigned char RESERVED6[2];     /* RESERVED - DO NOT MODIFY                */
    unsigned char KeepLogDays;      /* Days to keep NEXxxxx.LOG                */
    unsigned char ScreenLength;     /* Default Screen Length (4-50)            */
    unsigned char RESERVED7[31];    /* RESERVED - DO NOT MODIFY                */

    char          AskAlias;         /* Prompt user for Alias Name or use Real  */ /*BOOL*/
    char          PhoneAccess;      /* Prompt for last 4 digits at logon       */ /*BOOL*/
    char          lSecurity;        /* Local Security: Ask Password at Local   */ /*BOOL*/
                                    /* Logon                                   */ 
    char          lViewSecurity;    /* Local View Security: Display Passwords  */ /*BOOL*/
                                    /* locally as they are entered             */ 
    char          GlobalDump;       /* Dump all screen output to GLOBxxxx.TRP  */ /*BOOL*/
    char          AutoChatDump;     /* Automatically Dump all chat activity to */ /*BOOL*/
                                    /* CHATxxxx.LOG                            */ 
    char          AliasPrimary;     /* Is Alias used as primary display name in*/ /*BOOL*/
                                    /* items such as User Listings, Node Lists,*/ 
                                    /* etc.                                    */ 
    char          AllowIEMSI;       /* Allow IEMSI logins?                     */ /*BOOL*/

    unsigned char RESERVED8[9];     /* RESERVED - DO NOT MODIFY                */


    short int     NewUserApp;       /* User Record # to send new user          */
                                    /* application to (0=Inactive)             */
    short int     InactBeep;        /* Minutes before Inactivity Beep          */
    short int     InactLogoff;      /* Minutes of Inactvity before Logoff      */
    char          EMSOverlay;       /* Attempt to load overlays in EMS         */ /*BOOL*/
    char          BiosVideo;        /* Use ROM BIOS for local video output     */ /*BOOL*/
    char          CGASnow;          /* Suppress snow on CGA systems            */ /*BOOL*/
    char          ProtOutput;       /* Display output for protocols?           */ /*BOOL*/
    char          ArcOutput;        /* Display output for archivers?           */ /*BOOL*/
    char          UseEXTchat;       /* Use External Chat defined in record 0 of*/ /*BOOL*/
                                    /* DOORS.DAT?                              */
    unsigned char RESERVED9[27];    /* RESERVED - DO NOT MODIFY                */
    char          ArcComments[3][81];/* Path/Filename of Comment Text Files    */
    char          fULDLRatio;       /* UL/DL Ratio System in use?              */ /*BOOL*/
    char          fFilePoint;       /* FilePoint System in use?                */ /*BOOL*/
                                    /* Either, Both, or None of the above two  */
                                    /* items may be set to TRUE.               */
    unsigned char FPCompRatio;      /* Percentage of File's File Points that   */
                                    /* will be awarded to user upon upload     */
                                    /* (0-255)                                 */
    unsigned char FPKBperPoint;     /* When file is Uploaded, the Number of    */
                                    /* KB required to assign 1 File Point to   */
                                    /* the File.  Example: FPKBperPoint is set */
                                    /* to 10.  File uploaded is 20Kb in size.  */
                                    /* FilePoints assigned to that file would  */
                                    /* be 2.                                   */
    unsigned char ULTimeRefund;     /* Percentage of UL time spent that is     */
                                    /* refunded to the user's account after UL */
                                    /* is complete.                            */
    unsigned char RESERVED10;       /* RESERVED - DO NOT MODIFY                */
    char          AutoValidate;     /* Validate files automatically?           */ /*BOOL*/
    char          RemRedirect[11];  /* Remote redirection device (COMx,etc)    */
    short int     maxTempKB;        /* Maximum KB allowed in Temporary Dirs    */
    short int     minResumeKB;      /* Minimum Filesize in KB to allow resume  */
    short int     minUploadKB;      /* Minimum KB required for Uploads         */
    unsigned char DupSearchType;    /* Search for duplicate filenames on upload*/
                                    /*      0 = NONE                           */
                                    /*      1 = All Bases                      */
                                    /*      2 = Only Hard Drive Bases          */
    char          DupStrict;        /* Search for duplicates strictly          */ /*BOOL*/
                                    /* TRUE = Match Files with Exact Filename  */
                                    /*        ONLY.  (Example: File user is    */
                                    /*        uploading is FIRST.ARJ.  File    */
                                    /*        that already exists is FIRST2.ZIP*/
                                    /*        This file would NOT be matched.) */
                                    /* FALSE= Match Files with Filename found  */
                                    /*        somewhere in it.  (Example: File */
                                    /*        user is uploading is FIRST.ARJ.  */
                                    /*        File that already exists is      */
                                    /*        FIRST2.ZIP.  This file WOULD BE  */
                                    /*        MATCHED.                         */
    unsigned char FileListLines;    /* 0 - 10 lines                            */
                                    /* 1 - 5 lines                             */
                                    /* 2 - 1 line                              */
    short int     PrvSysOpBase;     /* -1 DISABLED                             */
    char          OfflineReq;       /* Allow Offline Files to be requested?    */ /*BOOL*/
    char          ConvertWithAV;    /* Convert files with known AV stamp?      */ /*BOOL*/
    char          ConvertSame;      /* Convert archives even if source and     */ /*BOOL*/
                                    /* destination are same archive type?      */
    char          AddWithAV;        /* Allow adding of files to archives with  */ /*BOOL*/
                                    /* an AV stamp?                            */
    unsigned char RESERVED11[13];   /* RESERVED - DO NOT MODIFY                */
    unsigned char TimeZone;         /* Local Time Zone                         */
                                    /* See TIMEZONE.DOC for more info          */
    unsigned char RESERVED12[214];  /* RESERVED - DO NOT MODIFY                */
} tNxsMatrix;

/****************************************************************************
 Filename: SUBSCRIP.DAT                                                     
 Location: DATA Directory                                                   
 Format  : Record #0 is holding record                                      
           Up to 255 <tNxsSubscription> Records (plus holding record)        
                                                                            
 Notes   : Used to store subscription level configuration.  There may be up 
           to 255 subscription levels assigned, and each level will have a  
           record for it.  This record number corresponds directly to the   
           UserREC.Subscription variable.                                   
****************************************************************************/

typedef struct {
    char          Description[41];/* Description of Subscription Level        */
    unsigned char SL;             /* Security Level of Subscription Level     */
    ARFlags       ARflags;        /* AR Flag Set for this Subscription Level  */
    unsigned char ARmodifier;     /* 0: Set AR Flags to this Set              */
                                  /* 1: Soft update of AR Flags               */
    UFlags        ACflags;        /* AC Flag Set for this Subscription Level  */
    unsigned char ACmodifier;     /* 0: Set AC Flags to this Set              */
                                  /* 1: Soft update of AC Flags               */
    short int     FilePoints;     /* File Points for this Subscription Level  */
    unsigned char FPmodifier;     /* 0: Set FP to value                       */
                                  /* 1: Add value to FP                       */
                                  /* 2: Subtract value from FP                */
    long int      Credits;        /* Credits for this Subscription Level      */
    unsigned char Cmodifier;      /* 0: Set Credits to value                  */
                                  /* 1: Add value to Credits                  */
                                  /* 2: Subtract value from Credits           */
    short int     TimeBank;       /* Time Bank for this Subscription Level    */
    unsigned char TBmodifier;     /* 0: Set Time Bank to value                */
                                  /* 1: Add value to Time Bank                */
                                  /* 2: Subtract value from TimeBank          */
    short int     SubLength;      /* Length of subscription level             */
                                  /* -1: No length (indefinate)               */
    short int     NewSubLevel;    /* New Subscription Level after expiration  */
    unsigned char RESERVED[19];   /* RESERVED - DO NOT MODIFY                 */
} tNxsSubscription;
    
/****************************************************************************
 Filename: LANGUAGE.DAT                                                     
 Location: DATA Directory                                                   
 Format  : Record #0 is holding record                                      
           1 record for each installed language                             
                                                                            
 Notes   : Used to store information regarding installed languages.  There  
           will be 1 record for each language.  The record number directly  
           corresponds to the UserREC.Language variable.                    
****************************************************************************/

typedef struct {                    /* LANGUAGE.DAT                           */
    char          Name[41];         /* Description of Language                */
    char          Filename[9];      /* [FILENAME].NXL                         */
    char          Menuname[9];      /* [MENUNAME].NXM                         */
    ACString      Access;           /* Access Control String                  */
    char          DisplayPATH[80];  /* Display File Path                      */
                                    /* <blank> = Use Default Path             */
    char          CheckDefPath;     /* If display file does not exist in      */
    /* CheckDefPath is BOOLEAN */   /* DisplayPATH, check Default Path?       */
                                    /* Ignored if DisplayPATH is <blank>      */
    unsigned short int  Startmenu;        /* Start Menu # For this Language         */
                                    /* Record number+1 in MENUS.DAT           */
    unsigned char RESERVED1[50];    /* RESERVED - DO NOT MODIFY               */
} tNxsLanguage;

/****************************************************************************
 Filename: MBASES.IDX, FBASES.IDX                                           
 Location: DATA Directory
 Format  : 1 <tNxsBaseIDX> record for each corresponding Message/File Base
                                                                            
 Notes   : This is an index containing one record for each message/file base
           that exists.  The Offset variable will contain the the offset to 
           the record number in the file MBASES.DAT/FBASES.DAT for the base.
           The Offset variable MUST match the current record number in the  
           index file.  The BaseID value will contain the BaseID for the    
           base that is referenced by the index.                            
****************************************************************************/

typedef struct {
        short int Offset;       /* Offset to record # in base data file      */
        long int  BaseID;       /* Permanent Base ID - Should match record # */
} tNxsBaseIDX;

/****************************************************************************
 Filename: MBASEID.IDX, FBASEID.IDX                                         
 Location: DATA Directory                                                   
 Format  : 1 <tNxsBaseIDIDX> record for each corresponding Message/File BaseID
                                                                            
 Notes   : This is the index of all present AND past Message/File BaseID    
           values.  When a BaseID is active, it will contain the number,    
           which MUST be the same as the record number in the file, and the 
           offset variable will contain the record number of the appropriate
           file (MBASES.DAT/FBASES.DAT) that contains the base information  
           that has this BaseID.                                            
****************************************************************************/

typedef struct {
        long int  BaseID;       /* Permanent Base ID - Should match record # */
        short int Offset;       /* Offset to record # in base data file      */
} tNxsBaseIDIDX;

/****************************************************************************
 Filename: MBTAGS.IDX                                                       
 Location: DATA Directory                                                   
 Format  : 1 <tNxsBaseTagIDX> record for each corresponding Message Base    
                                                                            
 Notes   : Quick index to tagnames for Message Bases.                       
****************************************************************************/

typedef struct {
        char NetTagname[ 51 ]; /* Network/Blue Wave Tag Name for this       */
                               /* base.  MUST NOT BE DUPLICATED!            */
} tNxsBaseTagIDX;

/****************************************************************************
 Filename: MBASES.DAT                                                       
 Location: DATA Directory                                                   
 Format  : 1 <tNxsMsgBase> record for each corresponding Message Base        
                                                                            
 Notes   : Message Base Data File, containing all information about each    
           message base.  Up to MaxMsgBases of records.                     
****************************************************************************/

typedef unsigned char MBFlags;

/* Message Base Flags */
#define MB_UNHIDDEN 0x01          /* whether *VISIBLE* to users w/o access    */
#define MB_REALNAME 0x02          /* whether real names are forced            */
#define MB_FILTER   0x04          /* whether to filter ANSI/8-bit ASCII       */
#define MB_SKLUDGE  0x08          /* strip IFNA kludge lines                  */
#define MB_SSEENBY  0x10          /* strip SEEN-BY lines                      */
#define MB_NETMAIL  0x20          /* Netmail can be sent from this base       */
#define MB_SORIGIN  0x40          /* strip origin lines                       */
                                                                              
typedef unsigned char MBPrivLvl;

/* Message Types Allowed */
#define MB_PRIVATE  0x01          /* Private Only                             */
#define MB_PUBLIC   0x02          /* Public Only                              */
#define MB_PUBPRV   0x04          /* Public OR Private                        */

typedef struct {
    char          Name[71];       /* Message base description                 */
    char          Filename[9];    /* JAM/SQUISH Message Base Filename         */
                                  /* *NOT NEEDED for .MSG                     */
    char          NetTagName[51]; /* Network Tag Name                         */
    short int     MBType;         /* 0 = Local                                */
                                  /* 1 = Echo                                 */
                                  /* 2 = Netmail                              */
                                  /* 3 = Internet E-Mail                      */
    char          MSGPath[41];    /* Messages pathname                        */
                                  /* For JAM/Squish this is the path to the   */
                                  /* Message Base Files.  For *.MSG, this is  */
                                  /* the path to the .MSG files               */
    MBFlags       MBFlag;         /* Message Base Flags                       */
    MBPrivLvl     MBPriv;         /* Message Priveledge Level                 */
    ACString      Access;         /* Access to this Base                      */
    ACString      PostAccess;     /* Access to Post on this Base              */
    unsigned short int  MaxMSGS;  /* Maximum Messages in this Base            */
    char          Password[21];   /* Password to this Base                    */

                                  /* Following colors are in TEXTATTR form:   */
                                  /* Bits 0-3: Foreground                     */
                                  /* Bits 4-6: Background                     */
                                  /* Bit    8: Blink Attribute                */

    unsigned char TextColor;      /* color of standard text                   */
    unsigned char QuoteColor;     /* color of quoted text                     */
    unsigned char TagColor;       /* color of taglines                        */
    unsigned char OldTearColor;   /* color of old tear lines (___ or ~~~)     */
    unsigned char TearColor;      /* color of tear line                       */
    unsigned char OriginColor;    /* color of origin line                     */
    char          Address[30];    /* --- BOOLEAN VARIABLE ---                 */
                                  /* Address (1-30) out of NETWORK.DAT        */
                                  /* Only one TRUE for ECHOMAIL bases         */
                                  /* Only one TRUE for INTERNET EMAIL bases   */
                                  /* Any number TRUE for NETMAIL Bases        */
                                  

    unsigned char Origin;         /* Origin Line (1-20) out of NETWORK.DAT    */
    unsigned char RESERVED1;      /* RESERVED - DO NOT MODIFY                 */
    unsigned char MessageType;    /* 1 = Squish                               */
                                  /* 2 = JAM(mbp)(tm)                         */
                                  /* 3 = .MSG                                 */
    unsigned char DefTagType;     /* 0 = Default Tagged                       */
                                  /* 1 = Default Untagged                     */
                                  /* 2 = Mandatory                            */
    unsigned char NameUsage;      /* 0 = Real Name                            */
                                  /* 1 = Alias                                */
                                  /* 2 = Ask                                  */
                                  /* Included for FUTURE USE                  */
    JoinedConfs   InConfs;        /* Conferences this Message Base is in      */
    unsigned char Gateway;        /* For INTERNET BASES : GATEWAY NUMBER from */
                                  /* INTERNET.DAT.  Ignored on other bases.   */
    unsigned char RESERVED2[94];  /* RESERVED - DO NOT MODIFY                 */
    long int      MBaseID;        /* permanent index #                        */
} tNxsMsgBase;

/****************************************************************************
 Filename: MCONF?.IDX, FCONF?.IDX (where ? is A-Z)                          
 Location: DATA Directory                                                   
 Format  : 1 <tNxsConfIDX> record                                               
                                                                            
 Notes   : Conference Index, which contains TRUE for each message base that 
           is tagged as using this particular conference.  Example:  If you 
           wish to know if Message Base #10 is in Conference B, you would   
           open MCONFB.IDX, and see if <ConfIDX>.Index[10] is TRUE.         
                                                                            
           An alternative is to open the file as a FILE of BOOLEAN, seek to 
           the position that you are interested in, read in that boolean and
           check the status of it.                                          
****************************************************************************/

typedef struct {
     char Index[ 32768 ];  /* Boolean Array containing Bases                */
} tNxsConfIDX;


/****************************************************************************
 Filename: FBASES.DAT                                                       
 Location: DATA Directory                                                   
 Format  : 1 <tNxsFileBase> record for each corresponding File Base         
                                                                            
 Notes   : File Base Date File, containing all information about each File  
           base.  Up to MaxFileBases of records.                            
****************************************************************************/

typedef unsigned char FBFlags;

/* File Base Flags, defined in FBFlags variables */
#define FB_NORATIO     0x01          /* if all files are FREE                */
#define FB_UNHIDDEN    0x02          /* whether *VISIBLE* to users w/o access*/
#define FB_DIRDLPATH   0x04          /* if *.NFB file stored in DLPATH       */
#define FB_TICBASE     0x08          /* if a Network (TIC) type base         */
#define FB_USEGIFSPECS 0x10          /* whether to use GifSpecs              */
#define FB_NFMBASE     0x20          /* whether NFM uses this base           */
#define FB_ALLOWOLREQ  0x40          /* Allow requesting of offline files?   */

typedef struct {                     /* FBASES.DAT : File base records        */
    char          Name[71];          /* Base Description                      */
    char          Filename[9];       /* Filename of filebase (no extension)   */
    unsigned char RESERVED1[4];      /* RESERVED - DO NOT MODIFY              */
    char          FilePATH[80];      /* path to this bases files              */
    unsigned char RESERVED2[2];      /* RESERVED - DO NOT MODIFY              */
    short int     MaxFiles;          /* max files allowed                     */
    char          Password[21];      /* Password required                     */
    unsigned char Archiver;          /* wanted archive type (1..max,0=inactive*/
    unsigned char Comment;           /* wanted comment type (1..3,0=inactive) */
    FBFlags       fbFlag;            /* file base status vars                 */
    ACString      Access;            /* access requirements                   */
    ACString      ULAccess;          /* upload requirements                   */
    ACString      NameAccess;        /* see-names requirements                */
    char          CDROM;             /* Is this base on a CD?                 */ /*BOOL*/
    char          cdUploaded;        /* Has this base been uploaded by NFM?   */ /*BOOL*/
    short int     cdNumber;          /* CD-ROM Disk Number associated with    */
    unsigned char RESERVED3;         /* RESERVED - DO NOT MODIFY              */
    unsigned char DefTagType;        /* 0 = Default Tagged                    */
                                     /* 1 = Default Untagged                  */
                                     /* 2 = Mandatory                         */
    JoinedConfs   InConfs;           /* Conferences this File Base is in      */
    long int      FBaseID;           /* Permanent ID - DO NOT MODIFY          */
    unsigned char RESERVED4[91];     /* RESERVED - DO NOT MODIFY         */
} tNxsFileBase;

/****************************************************************************
 Filename: LASTON.DAT                                                       
 Location: DATA Directory                                                   
 Format  : 1 <tNxsLaston> record for each call to the BBS                   
           There will be 10 records at all times (records 0-9)              

 Notes   : The 0 record is the newest entry, down to the last record.       
/****************************************************************************/

typedef struct {
    char          Name[37];       /* Name of user (Real or Alias based on     */
                                  /* system settings                          */
    short int     RESERVED;       /* RESERVED                                 */
    char          CallingFrom[31];/* Caller's Calling From string             */
    char          UserBaud[7];    /* Baud rate connected at                   */
    short int     Node;           /* Node connected on                        */
    char          DateOn[9];      /* Date connected                           */
    char          TimeOn[9];      /* Time connected                           */
} tNxsLaston;

/****************************************************************************
 Filename: DOORS.DAT, EDITORS.DAT                                           
 Location: DATA Directory                                                   
 Format  : 1 <tNxsDoor> record for each door/editor                          
           EDITORS.DAT has 0 holding record                                 
           DOORS.DAT 0 record is information for External Chat              
                                                                            
****************************************************************************/

typedef struct {
        long int      TimesUsed;
        long int      MinutesUsed;
        unsigned char DTRESERVED[100];
} tNxsDoorTrack;

typedef struct {
    char          DOORFilename[80];/* Path/Filename to Door or Batch File      */
    char          DOORName[41];    /* Name for Display of Door                 */
    unsigned char DOORDropType;    /* Drop File Type:                          */
                                   /*     1 - DOOR.SYS                         */
                                   /*     2 - DOORFILE.SR                      */
                                   /*     3 - CHAIN.TXT                        */
                                   /*     4 - DORINFO1.DEF                     */
                                   /*     5 - SFDOORS.DAT                      */
                                   /*     6 - CALLINFO.BBS                     */
                                   /*     7 - No drop file                     */
    char          DOORDropPath[80];/* Path to the location to place the Drop   */
                                   /* File                                     */
    char          RIPenabled;      /* RIPscrip graphics enabled for this door  */ /* BOOL */
    char          Realname;        /* Use Realnames                            */ /* BOOL */
    unsigned short int MaxMinutes[3];/* REAL48 Variable, You must convert to     */
                                   /*        Double to use this variable       */
                                   /* Maximum minutes allowed (time left is    */
                                   /* max if less than this value, 0 means     */
                                   /* disabled, use time left always           */
    char          LocalOnly;       /* For EDITORS only (ignored in Doors)      */ /* BOOL */
    char          ShowLoadStr;     /* Whether the "Loading..." string should be*/ /* BOOL */
                                   /* shown before running this door           */
    unsigned char DRESERVED1[94];  /* RESERVED - DO NOT MODIFY                 */
    long int      DoorID;          /* Permanent DoorID number (DO NOT MODIFY)  */
    tNxsDoorTrack TRACKToday;      /* Door Tracking for Today - used for       */
                                   /* running total and then moved to yesterday*/
                                   /* at nightly maintenance                   */
    tNxsDoorTrack TRACKYest;       /* Door Tracking for Yesterday              */
    tNxsDoorTrack TRACKForever;    /* Door Tracking for Forever                */
    unsigned char DRESERVED2[300]; /* RESERVED - DO NOT MODIFY                 */
} tNxsDoor;

/****************************************************************************
 Filename: PROTOCOL.DAT                                                     
 Location: DATA Directory                                                   
 Format  : 1 <tNxsProt> record per entry, 0 record is blank buffer           
                                                                            
 Notes   : This file is used to store the protocol definitions for the BBS.
           There is one record for each protocol, and they may be turned on
           or off via the <xbActive> flag.                                  
                                                                            
           FOR INTERNAL PROTOCOLS:  Records 1-5 are used for internal       
           protocol definitions.  Records 6-10 are left blank for future    
           additions of internal protocols.  These records should NOT be    
           removed, and the guidelines below should be followed when        
           modifying them.  The following are the UL and DL commands for the
           internal protocols:                                              
                                                                            
           INT_ZMODEM_SEND             Zmodem Send                          
           INT_ZMODEM_RECV             Zmodem Receive                       
           INT_YMOD-G_SEND             Ymodem/G Send                        
           INT_YMOD-G_RECV             Ymodem/G Receive                     
           INT_YMODEM_SEND             Ymodem Send                          
           INT_YMODEM_RECV             Ymodem Receive                       
           INT_XMOD1K_SEND             Xmodem/1K Send                       
           INT_XMOD1K_RECV             Xmodem/1K Receive                    
           INT_XMODEM_SEND             Xmodem Send                          
           INT_XMODEM_RECV             Xmodem Receive                       
****************************************************************************/

typedef unsigned char protFlags;

/* Protocol Flags, defined by variables using protFlags */
#define PROT_ACTIVE   0x01      /* Is this protocol active?             */
#define PROT_BATCH    0x02      /* Is this protocol a batch protocol?   */
#define PROT_RESUME   0x04      /* Does this protocol support RESUME?   */
#define PROT_USEOPUS  0x08      /* Add OPUS coding to batch list file?  */
#define PROT_NAMESNGL 0x10      /* Ask for the name when sending 1 file */
#define PROT_INTERNAL 0x20      /* INTERNAL PROTOCOL DEFINITION         */
                                /* RESERVED -- DO NOT MODIFY THIS FLAG!!*/
#define PROT_MINIDISP 0x40      /* INTERNAL - MiniDisplay Mode          */

typedef struct {
    char          Name[71];        /*  Description of Protocol            */
    char          KeyChar;         /*  Character used to select protocol  */
    protFlags     pFlags;          /*  Protocol flags                     */
    ACString      Access;          /*  Access Control String              */
    char          ulCommand[80];   /*  UL Batch File Name                 */
    char          dlCommand[80];   /*  DL Batch File Name                 */
    char          TempLog[80];     /*  Temporary log file                 */
    char          ulLog[80];
    char          dlLog[80];       /*  Permanent log files                */
    char          EnvCMD[61];      /*  Environment command before transfer*/
    char          dlFList[80];     /*  DL File list filename              */
    short int     ulCode;          /*  UL errorcode OK                    */
    short int     dlCode;          /*  DL errorcode OK                    */
    short int     MaxChars;        /*  Maximum characters in cmdline      */
    short int     LogPf;
    short int     LogPs;           /*  Position in log file for data      */
    unsigned char RESERVED[30];    /*  RESERVED                           */
} tNxsProtocol;

/****************************************************************************
 Filename: CDS.IDX                                                          
 Location: DATA Directory                                                   
 Format  : 1 <tNxsCDROMIDX> record                                              
                                                                            
 Notes   : There is no holding record in this file.                         
           Each element in the array represents a drive letter.  As a double
           security measure, the drive letter (capitalized) is placed in the
           appropriate spot for the letter, which is (int)(letter)-64.        
           Therefore, A would be placed in 1, B in 2, etc.                  
****************************************************************************/

typedef struct {
    char Drives[26];     /* Drives currently available for CDs             */
} tNxsCDROMIDX;

/****************************************************************************
 Filename: CDS.DAT                                                          
 Location: DATA Directory                                                   
 Format  : 1 <tNxsCD> record per entry, 0 is holding record                  
                                                                            
 Notes   : This file contains the information about each CD-ROM disk that   
           is configured to be used on this system.  When Nexus starts up,  
           it will check all the drives in the CDS.IDX file that are set to 
           be CD-ROM drives, and will match the appropriate drive with the  
           appropriate disk based on either the VolumeID or a Unique        
           Filename.  This file stores the information about each of the    
           disks.                                                           
****************************************************************************/

typedef struct {
    char          Name[37];            /* Name of CD for Display Purposes    */
    char          VolumeID[13];        /* Volume ID of CD                    */
    char          UniqueFile[41];      /* Unique filename to use instead     */
    char          UseUnique;           /* Use Unique Filename instead of     */
                                       /* VolumeID? (BOOLEAN)                */
    ACString      ViewACS;             /* Access String to View if this CD is*/
                                       /* available or not                   */
    unsigned char RESERVED[40];        /* RESERVED -- DO NOT MODIFY!         */
} tNxsCD;

/****************************************************************************
 Filename: CDS.MAP                                                          
 Location: DATA Directory                                                   
 Format  : 1 <tNxsCDMAP> record                                                 
                                                                            
 Notes   : This file contains a list of the last CD-ROM discs that were     
           scanned in by Nexus.  When a sysop uses the -CDMAP parameter on  
           startup, Nexus will read in this file.  It is especially of use  
           to Sysops using slower CD-ROM changers.  Each integer value that 
           is greater than 0 represents the disc number from the CDS.DAT    
           file, and maps to the drive letter (array position 0 = A, 1 = B, 
           .. 26 = Z).  Thus, CDMAP.Discs[1]=1 would denote that the first  
           disc record in CDS.MAP is the disc that is in Drive A.           
****************************************************************************/

typedef struct {
        short int Discs[ 26 ]; /* Disk mapping to each drive                     */
} tNxsCDMAP;

/****************************************************************************
 Filename: CONFS.DAT                                                        
 Location: DATA Directory                                                   
 Format  : 1 <tNxsConfs> record                                              
                                                                            
 Notes   : There is no holding record in this file.                         
           Each conference is represented by a letter A-Z (1-26).  To access
           information for Message Conference A, you would use:             
           <ConfsRec>.MSGconf[1].<field>                                    
****************************************************************************/

typedef struct {
        char     name[41];     /* Name of this conference                    */
        ACString access;       /* Access String for this conference          */
        char     active;       /* Is this conference active? (boolean)       */
        char     hidden;       /* Is this conference hidden? (boolean)       */
} tNxsConference;

typedef struct {
        tNxsConference MSGconf[26];  /* Message Conferences     */
        tNxsConference FILEconf[26]; /* File Conferences        */
} tNxsConfs;

/****************************************************************************
 Filename: REQUESTS.DAT                                                     
 Location: FILE Directory                                                   
 Format  : 1 <tNxsRequest> record for each request                           
                                                                            
 Notes   : There is no holding record in this file.                         
           A new record is added to the file each time a file is requested. 
****************************************************************************/

typedef struct {
    char          FileAvail;     /* whether file has been made available in */
                                 /* the Systat.FileReqPath Path (bool)      */
    char          ReqDenied;     /* If Sysop has denied File Request (bool) */
    char          Filename[13];  /* Filename of File Requested              */
    short int     FileBase;      /* Base Number File is In                  */
    char          UserReal[37];  /* User's Real Name that Requested File    */
    unsigned char RESERVED[100]; /* RESERVED                                */
} tNxsRequest;

/****************************************************************************
 Filename: FLAGxxxx.DAT (xxxx is node number)                               
 Location: TEMP Directory                                                   
 Format  : 1 <tNxsFlagged> record for each flagged file                      
                                                                            
 Notes   : There is no holding record in this file.                         
           A new record is added to the file each time a file is flagged.   
****************************************************************************/

typedef struct {
    char     Filename[66];       /* Filename of file flagged, full path     */
    char     Description[10][46];/* First 10 lines of description           */
    short int      Filebase;           /* Filebase this file is located in, -1 for*/
                                 /* unlisted.                               */
    short int      Filepoints;         /* Filepoints for this file.               */
    long int KB;                 /* Number of KB for this file              */
    unsigned short int TransTime[3];/* REAL48 Variable, you must convert this  */
                                 /*        to a double before using.        */
                                 /* Estimated Transfer time                 */
    char     isCDromFile;        /* Is this file on CD-ROM?                 */
} tNxsFlagged;

/****************************************************************************
 Filename: MENUS.DAT                                                        
 Location: DATA Directory                                                   
 Format  : 1 <tNxsMenu> record for each menu                                 
                                                                            
 Notes   : There is no holding record in this file.                         
           Although menus are numbered 1+, the actual location of the record
           is Menu Number - 1.                                              
****************************************************************************/

typedef unsigned char mnuFlags;

/* Menu Flags, defined by mnuFlags variables */
#define MNU_CLRSCREEN  0x01      /* Clear screen before menu display         */
#define MNU_NOCENTER   0x02      /* Don't center the menu titles!            */
#define MNU_NOPROMPT   0x04      /* No menu prompt whatsoever?               */
#define MNU_FORCEPAUSE 0x08      /* Force a pause before menu display?       */
#define MNU_AUTOTIME   0x10      /* Is time displayed automatically?         */
#define MNU_FILECHANGE 0x20      /* Allow Filebase QuickChange?              */
#define MNU_MSGCHANGE  0x40      /* Allow Messagebase QuickChange?           */
#define MNU_NOGLOBAL   0x80      /* Do not use Global Commands in this menu  */

typedef struct {
    char          Name[61];      /* Menu Name                                */
    char          Filename[9];   /* Menu Filename (*.MNU)                    */
    char          Header[13];    /* Menu Header Filename                     */
    char          Footer[13];    /* Menu Footer Filename                     */
    char          Display[13];   /* Menu Display File (blank=GENERIC)        */
    char          HelpScreen[13];/* Menu Help File (blank=GENERIC)           */
    unsigned short int Fallback; /* Fallback Menu #                          */
    char          Title[3][101]; /* GENERIC Menu Header                      */
    char          Prompt[121];   /* Menu Prompt                              */
    ACString      Access;        /* Access Control String                    */
    char          Password[16];  /* Password for Access to Menu              */
    unsigned char Helplevel;     /* Force Help Level to                      */
    unsigned char Columns;       /* GENERIC Number of Columns                */
    unsigned char Colors[3];     /* GENERIC Colors                           */
    mnuFlags      menuFlags;     /* Menu Flags                               */
} tNxsMenu;

/****************************************************************************
 Filename: *.MNU                                                            
 Location: MENU Directory                                                   
 Format  : 1 <tNxsMenuCommand> record for each menu command                  
                                                                            
 Notes   : There is no holding record in this file.                         
****************************************************************************/

typedef unsigned char cmdFlags;

/* Command Flags, defined by cmdFlags variables */
#define CMD_HIDDEN    0x01       /* Command is ALWAYS hidden                 */
#define CMD_UNHIDDEN  0x02       /* Command is ALWAYS visible                */
#define CMD_AUTOEXEC  0x04       /* Auto exececute command upon menu startup */
#define CMD_TITLELINE 0x08       /* Command is a Title Display line          */

typedef struct {
    char          LongDesc[71];  /* Long Description                         */
    char          ShortDesc[37]; /* Short Description                        */
    char          ExecKeys[15];  /* Command Execution Keys                   */
    ACString      Access;        /* Access String                            */
    unsigned char RESERVED;      /* RESERVED                                 */
    char          Command[2];    /* Command Type                             */
    char          CommData[81];  /* Additional Command Data                  */
    cmdFlags      cFlags;        /* Command Flags                            */
} tNxsMenuCommand;

/****************************************************************************
 Filename: *.NXL                                                            
 Location: DATA Directory                                                   
 Format  : 1 <tNxsStringIDX> record at the beginning of file                    
           RAW String Data following Index                                  
                                                                            
 Notes   : This file type is a RAW data file with an index placed at the    
           beginning of the file.  The index is an index placeholder for    
           each of the configurable strings.  The index entry may be filled 
           with either the byte offset in the file of the beginning of the  
           string, or -1 if the string is blank.  The strings are stored    
           beginning with the first byte in the file after the index.  They 
           are stored in Turbo Pascal format ([length byte][data]).  The    
           best way to find a string is to blockread the contents of the    
           index into a variable of type <StringIDX>.  Then when you wish to
           retrieve a string, seek to the byte position identified for that 
           string number in the index (returning a blank string for those   
           which contain -1), and blockread one byte into the [0] byte of   
           the string.  Once you have obtained this, you can blockread the  
           rest of the string.                                              
****************************************************************************/

typedef struct {
    long int Offset[2000];
} tNxsStringIDX;

/****************************************************************************
 Filename: NODEMSG.xxx                                                      
 Location: SEMAPHORE Directory                                              
 Format  : Multiple <tNxsNodeMsg> records                                   
                                                                            
 Notes   : This is a semaphore file that is used as an internode message    
           file.  There will be multiple records in this file, and new      
           records should be added to the end of the file.  Nexus will read 
           and display the messages starting with the first record first.   
****************************************************************************/

typedef struct {
    char SentBy[37];                    /* This is the name of the user that  */
                                        /* has sent the message               */
    short int  SentByNode;                    /* This is the node number that sent  */
                                        /* the message                        */
    char Message[80];                   /* This is the message itself.        */
} tNxsNodeMsg;

/****************************************************************************
 Filename: *.NFD                                                            
 Location: FILEBASE Directory                                               
 Format  : For each file record there will be                               
           1 (one) <tNxsFHeader> record                                      
           (SystemREC.NKeywords) * <tNxsFKeyword> record(s)                  
           (SystemREC.NDescLines) * <tNxsFDesc> record(s)                    
                                                                            
 Notes   : If you are not going to use the nxFILSYS object that is included 
           in this package, you will have to open the *.NFD files as UNTYPED
           files, and blockread the different records in.  Again, there will
           be one <tNxsFHeader> followed by (tNxsSystem.NKeywords) *          
           <tNxsFKeyword> record(s) followed by (tNxsSystem.NDescLines) *     
           <tNxsFDesc> record(s) for EACH file entry.                        
****************************************************************************/

typedef unsigned short int FFlags;

/* File Flags, defined by FFlags variables */
#define FF_NOFLAGS     0x0000      /* No Flag defined */
#define FF_NOTVAL      0x0001      /* if file is NOT validated                */
#define FF_ISREQUEST   0x0002      /* if file is REQUEST                      */
#define FF_RESUMELATER 0x0004      /* if file is RESUME-LATER                 */
#define FF_ISFREE      0x0008      /* is file free?                           */
#define FF_CHKSECURITY 0x0010      /* check ACS before Download?              */
#define FF_HIDDEN      0x0020      /* is file hidden no matter what?          */
#define FF_ISHATCHED   0x0040      /* has file been hatched via TICK ?        */
#define FF_RESERVED1   0x0080      /* RESERVED                                */
#define FF_RESERVED2   0x0100      /* RESERVED                                */
#define FF_RESERVED3   0x0200      /* RESERVED                                */
#define FF_RESERVED4   0x0400      /* RESERVED                                */
#define FF_RESERVED5   0x0800      /* RESERVED                                */
#define FF_RESERVED6   0x1000      /* RESERVED                                */
#define FF_RESERVED7   0x2000      /* RESERVED                                */
#define FF_RESERVED8   0x4000      /* RESERVED                                */
#define FF_RESERVED9   0x8000      /* RESERVED                                */

typedef struct {
    char          FheaderID[7];    /* 0x01,'N','E','X','U','S',0x01           */
    char          Filename[13];    /* Filename                                */
    char          Magicname[13];   /* Magic name of file                      */
    short int     FilePoints;      /* Filepoints needed to download this file */
    long int      FileSize;        /* File size in bytes                      */
    long int      FileDate;        /* UNIX Time/Date Stamp of File            */
    long int      UploadedDate;    /* UNIX Time/Date Stamp of UL              */
    long int      LastDLDate;      /* UNIX Time/Date Stamp Last DLed          */
    short int     NumDownloads;    /* Number of times downloaded              */
    char          UploadedBy[37];  /* Uploaded by user name                   */
    ACString      Access;          /* Access to this file                     */
    char          Password[21];    /* Password to this file ''=none           */
    FFlags        FileFlags;       /* File Flags                              */
    unsigned char RESERVED[30];    /* RESERVED                                */
} tNxsFHeader;
        
typedef struct {
    char          Keyword[21];     /* Keyword (blank=NO MORE KEYWORDS)        */
} tNxsFKeyword;

typedef struct {
    char          Description[46]; /* Description Line                        */
                                   /*                                         */
                                   /* If the string= #1+'EOF'+#1 then the     */
                                   /* previous line was the last line of the  */
                                   /* description                             */
                                   /* There are always SystemREC.NDesclines   */
                                   /* allotted per file record in the .NFD    */
                                   /* file.  If you reach that number of      */
                                   /* records, the description is finished.   */
} tNxsFDesc;

/****************************************************************************/
/*  NEXUS.H - NEXUS BBS C FILE STRUCTURES HEADER FILE                       */
/****************************************************************************/

#endif /* End Of File */
