# TEST.MPS: Sample program for the Mystic BBS Programming Language
# ----------------------------------------------------------------
# If you have any suggestions for additions to the language, please
# contact me through the Mystic BBS web page.  The MPL is far from
# being complete, but what is done now is a good start!
#

Uses USER

Var Str String
Var A   Integer
Var B   Byte
Var Ch  Char

Proc List_Users
     CLS
     WriteLn ('|14Accessing BBS Information Demo|CR|03')
     WriteLn ('This example displays a simple user list to the screen.  It')
     WriteLn ('gives an example of how to access some of the BBS data files.')
     WriteLn ('|CR|PA')
     WriteLn ('|15User Handle                     Location')
     WriteLn ('|09---------------------------------------------------------')
     A := 1
     While GetUser(A)
          WriteLn ('|14' + PadRT(UserAlias, 32, ' ') + '|10' + UserCity)
          A := A + 1
     WEND
     WriteLn ('|09---------------------------------------------------------')

     A := A - 1
     WriteLn ('|15Total of ' + A + ' users.')
     WriteLn ('|CR|PA')
Pend List_Users

Proc Input_Demo
     CLS
     WriteLn ('|14Input Demo|CR|03')
     WriteLn ('This example demonstrates the types of input functions')
     WriteLn ('which can be used in your MPE programs.|CR')

     Write   ('|09Regular Input  ') Str := Input(30, 30, 11, '')
     Write   ('|09Caps Input     ') Str := Input(30, 30, 12, '')
     Write   ('|09Proper Input   ') Str := Input(30, 30, 13, '')
     Write   ('|09Phone Input    ') Str := Input(12, 12, 14, '')
     Write   ('|09Date Input     ') Str := Input(8,  8,  15, '')
     Write   ('|09Password Input ') Str := Input(20, 20, 16, '')

     WriteLn ('|CR|14Text can also be pushed into the input buffer:|CR')
     Write   ('|09Regular Input  ') Str := Input(30, 30, 11, 'Default Text')

     WriteLn ('|CR|14Input can be used without the input field:|CR')
     Write   ('|09Regular Input  |11') Str := Input(30, 30, 1, 'Default Text')

     WriteLn ('|CR|14Input also makes full use of ANSI editing.  Arrow keys, wordstar keys,')
     WriteLn ('HOME, END, DEL, CTRL-Y keys all work while getting input.  Text')
     WriteLn ('longer than the input field can be entered in both ASCII and ANSI')
     WriteLn ('graphic modes.  Example: Type more than 30 characters below.')
     Write   ('|CR|09Scroll Input   ') Str := Input(30, 255, 11, '')

     Write   ('|CR|PA')
Pend Input_Demo

If Not InputYN('|CR|12Would you like to run this demo? |11')
     Halt
Endif

StatusWrite (1, 1, PadCT(' Welcome to the example MPE program ', 80, ' '))
StatusWrite (1, 2, PadCT('', 80, ' '))

CLS
WriteLn ('|CR|14Welcome to the MPE demo program.|CR|03')
WriteLn ('This program demonstrates some of the MPE functions to help give')
WriteLn ('you an idea of how to write your own programs.  The MPE language')
WriteLn ('offers about 75 functions which can be used to write add-ons for')
WriteLn ('Mystic BBS.  Not even close to all of the functions are covered')
WriteLn ('in this demo, but it will at least give you an idea of what can')
WriteLn ('be accomplished.  For more examples, see the SCRIPTS directory')
WriteLn ('which the Mystic BBS installation creates.')
WriteLn ('|CR|PA')

StatusWrite (1, 2, PadCT('Let''s check out a demonstraton of the input functions', 80, ' '))
Input_Demo

StatusWrite (1, 2, PadCT('Now check out a list of all the system users!', 80, ' '))
List_Users

StatusWrite (1, 2, PadCT('Thanks for checking out this demo.  See MPL.DOC for more info.', 80, ' '))

WriteLn ('|14This it for the MPE demo.  For more information on the MPE language')
WriteLn ('see the MPL.DOC file located in the scripts directory.')
WriteLn ('|CR|PA')

StatusUpdate
