# ---------------------------------------------------------------------------
# BULLETIN.MPS: Bulletin Menu Script for Mystic BBS
# ---------------------------------------------------------------------------
# This MPE program creates a simple bulletin menu.  The display file for the
# menu is "BULLETIN.XXX" with each bulletin being "BULLETx.XXX" where x is
# any character up to two characters in length.  IE: BULLET1, BULLET99,
# BULLETA, BULLETAA, etc.
#
# If you run it with a command line option of "CHECK" the program will check
# for updated bulletins since the user's last call and prompt them to read
# the bulletins if there are new bulletins.  This is handy to put as an
# FIRSTCMD command during the login somewhere, as the default Mystic BBS
# installation does.
#
# Feel free to make any modifications to this code that you want.  The only
# request I have is that if you want to distribute it, you must follow these
# guidelines:
#
#   1. Get my approval first
#   2. Release the source code
#   3. Give me FULL credit for the original work
#   4. List ALL changes you've made to the original program
#
# You can contact me at mysticbbs@geocities.com
#
# Another FREEWARE Mystic BBS modification. (C) 1998 By James Coyle.
# ---------------------------------------------------------------------------

Uses CFG
Uses DIR
Uses USER

Var MenuName String
Var Prefix   String
Var Done     Boolean
Var InStr    String
Var NewNum   Byte
Var NewStr   String

Proc Check_New
  NewStr := ''
  NewNum := 0
  FindFirst (PreFix + '*.*', AnyFile)
  While DosError = 0
    If DirTime > UserLast And Copy(DirName, 1, Pos('.', DirName) - 1) <> 'BULLETIN' Then
      InStr := Copy(DirName, 7, Pos('.', DirName) - 7) + ' '
      If Pos(InStr, NewStr) = 0 Then
        NewStr := NewStr + InStr
        NewNum := NewNum + 1
      EndIf
    EndIf
    FindNext
  WEnd
  FindClose
Pend Check_New

GetCFG
GetThisUser

MenuName := CfgTextPath + 'BULLETIN'
Prefix   := CfgTextPath + 'BULLET'
Done     := False

Check_New
If NewNum = 0 Then
  NewStr := 'None'
EndIf

If Upper(ParamStr(1)) = 'CHECK' Then
  If NewNum = 0 Then
    WriteLn ('|CR|12There are no new bulletins since your last call.')
    Halt
  Else
    WriteLn ('|CR|14There are |15' + NewNum + ' |14new bulletins.')
    If Not InputYN('|CR|12Read bulletins now? |11') Then
      Halt
    EndIf
  EndIf
EndIf

DispFile (MenuName)

Repeat
  WriteLn ('|CR|14New: |15' + NewStr)
  Write ('|14Bulletins [|15##|14] [|15?/List|14] [|15Q/Quit|14]: ')

  InStr := Input(4, 4, 12, '')
  If InStr = '?' Then
    DispFile (MenuName)
  ElseIf InStr = 'Q'
    Done := True
  Else
    DispFile (PreFix + InStr)
  EndIf
Until Done
