# -------------------------------------------------------------------------
# BBSLIST.MPS : BBS list creator for Mystic BBS software v1.05 +
# -------------------------------------------------------------------------
# This program will export the BBS list data to a text file, and allow the
# user to download the created text file.
#
# Modify this for your own needs, but do NOT modify this code and release it
# to the public.  If you think you have added something useful to many, you
# can send the code to me and i'll give you PERMISSION to release it if I
# choose to.  My e-mail address is mysticbbs@geocities.com
#
# -------------------------------------------------------------------------

Uses CFG

Var ListName      String               # Holds path/name of list index file
Var OutName       String               # Holds path/name of output file

Var bbs_cType     Byte
Var bbs_Phone     String
Var bbs_Telnet    String
Var bbs_Name      String
Var bbs_Location  String
Var bbs_Sysop     String
Var bbs_Baud      String
Var bbs_Software  String
Var bbs_Deleted   Boolean
Var bbs_AddedBy   String
Var bbs_Verified  LongInt
Var bbs_Extra1    LongInt
Var bbs_Extra2    Integer

Var Total         Integer
Var Temp          String

##############################
## START MAIN PROGRAM BLOCK ##
##############################

GetCFG

If ParamCount <> 1 Then
  WriteLn ('Invalid command line option.')
  WriteLn ('')
  WriteLn ('Usage: BBSLIST.MPE [bbs list id]')
  Halt
EndIf

ListName := CfgDataPath + ParamStr(1) + '.BBI'
OutName  := CfgSysPath  + 'TEMP' + Int2Str(NodeNum) + '\BBSLIST.TXT'

If Not fExist(ListName) Then
  WriteLn ('|CR|12There are no entries in the BBS list.')
  Halt
EndIf

If Not InputYN('|CR|12Download the BBS list? ') Then
  Halt
EndIf

Write ('|CR|14Creating BBS list ... ')

fOpen (1, Bin,  Reset,   ListName)
fOpen (2, Text, ReWrite, OutName)

fWriteLn (2, '')
fWriteLn (2, '.-------------------------------------------.')
fWriteLn (2, '| BBS listing created on ' + DateStr(DateTime, 0) + ' at ' + TimeStr(DateTime, 0) + ' |')
fWriteLn (2, '`-------------------------------------------''')
fWriteLn (2, '')

Total := 0

While Not Eof(1)

  fReadRec (1, bbs_cType)
  fReadRec (1, bbs_Phone, 15)
  fReadRec (1, bbs_Telnet, 40)
  fReadRec (1, bbs_Name, 30)
  fReadRec (1, bbs_Location, 25)
  fReadRec (1, bbs_Sysop, 30)
  fReadRec (1, bbs_Baud, 6)
  fReadRec (1, bbs_Software, 10)
  fReadRec (1, bbs_Deleted)
  fReadRec (1, bbs_AddedBy, 30)
  fReadRec (1, bbs_Verified)
  fReadRec (1, bbs_Extra1)
  fReadRec (1, bbs_Extra2)

  If Not bbs_Deleted Then
    Total := Total + 1

    fWriteLn (2, '      BBS Name: ' + bbs_Name)    

    If bbs_cType = 0 Then
      fWriteLn (2, ' Accessible By: Dialup')
      fWriteLn (2, '  Phone Number: ' +  bbs_Phone)
      fWriteLn (2, ' Max Baud Rate: ' + bbs_Baud)
    EndIf

    If bbs_cType = 1 Then
      fWriteLn (2, ' Accessible By: Telnet')
      fWriteLn (2, '        Telnet: ' + bbs_Telnet)
    EndIf

    If bbs_cType = 2 Then
      fWriteLn (2, ' Accessible By: Dialup & Telnet')
      fWriteLn (2, '  Phone Number: ' + bbs_Phone)
      fWriteLn (2, ' Max Baud Rate: ' + bbs_Baud)
      fWriteLn (2, '        Telnet: ' + bbs_Telnet)
    EndIf

    fWriteLn (2, '    Sysop Name: ' + bbs_Sysop)
    fWriteLn (2, '      Location: ' + bbs_Location)
    fWriteLn (2, '  BBS Software: ' + bbs_Software)
    fWriteLn (2, ' Last Verified: ' + DateStr(BBSVerify, 0))

    fWriteLn (2, '')
    fWriteLn (2, '----------------------------------------------------------')
    fWriteLn (2, '')
  EndIf  
Wend

fWriteLn (2, 'Total BBSes listed: ' + Int2Str(Total))

fClose (1)
fClose (2)

WriteLn ('Done.')

If Local Then
  If InputYN ('|CR|12Local mode: Save list to file? |11') Then
    Write ('|CR|03Enter full path and filename for BBS list|CR|09:')
    Temp := Input (60, 60, 12, CfgSysPath + 'BBSLIST.TXT')
    If Temp <> '' Then
      Write ('|CR|14Saving: |15' + Temp + '|14: ')
      If fCopy(OutName, Temp) Then
        WriteLn ('OK')
      Else
        WriteLn ('ERROR')
      EndIf
    EndIf
  EndIf
Else
  MenuCmd ('F3', OutName)
EndIf

fErase (OutName)
