/***************************************************************************
 *                                                                         *
 *   RESERVE.H                                                             *
 *                                                                         *
 *   Copyright (C) 1994 GALACTICOMM, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   File Reservations Kernel, for avoiding read/write and write/write     *
 *   conflicts.                                                            *
 *                                                                         *
 *                                        - RNStein  7/6/94                *
 *                                                                         *
 ***************************************************************************/

#define NOCONFLICT -1              /* meaning:  nobody else has reserved   */

struct reserve {                   /* reservations domain                  */
     int nusers;                   /* number of users (e.g. nterms)        */
     int *iuser;                   /* ptr to user-index var (e.g. &usrnum) */
     int lkpusr;                   /* write locks per user                 */
     int grpsiz;                   /* size of group strings (incl NUL)     */
     int filsiz;                   /* size of file strings (incl NUL)      */
     void *writloks;               /* alcblok of write-lock structures     */
     int (*amreading)(             /* vector for resolving who's reading   */
          char *grp,               /* group name (e.g. Library name)       */
          char *fil);              /* file name (or "*"=any file in group) */
};

extern
struct reserve *reserve;           /* current (or only) reservations domain*/

struct reserve *
inireserve(                        /* initialize a new reservations domain */
int nusers,                        /* number of users (e.g. nterms)        */
int *iuser,                        /* ptr to user-index var (e.g. &usrnum) */
int lkpusr,                        /* write locks per user                 */
int grpsiz,                        /* size of group strings (incl NUL)     */
int filsiz,                        /* size of file strings (incl NUL)      */
int (*amrhdl)(char *grp,char *fil));/* default "amreading()" resolver      */
                                   /* (or NULL=assume NOCONFLICT)          */
                                   /* returns ptr to reservations domain   */

void
setrsv(                            /* set reservations domain              */
struct reserve *rsv);              /* return value from inireserve()       */

int
w2writ(                            /* "I want to write (modify) this file" */
char *grp,                         /* group name (e.g. Library name)       */
char *fil,                         /* file name (or "*"=any file in group) */
int lkn);                          /* lock number, 0 to lkpusr-1           */
                                   /* returns NOCONFLICT=reserved for you  */
                                   /*         else=who writes or reads     */

void
donewrit(                          /* "I'm done writing the file"          */
int lkn);                          /* lock number, 0 to lkpusr-1, or -1=all*/
                                   /* (un-write-reserve)                   */

int
w2read(                            /* "I want to read this file"           */
char *grp,                         /* group name (e.g. Library name)       */
char *fil);                        /* file name (or "*"=any file in group) */
                                   /* to read-reserve,intercept amreading()*/
                                   /* return NOCONFLICT=ok, else=who writes*/

int
whouse(                            /* Who is using this group?             */
char *grp);                        /* group name (e.g. Library name)       */
                                   /* return NOCONFLICT=nobody, else=who   */

