/****************************************************************************
 *                                                                          *
 *  GALNOTE.C                                                               *
 *                                                                          *
 *  Copyright (C) 1993-1994 GALACTICOMM, Inc.  All rights reserved.         *
 *                                                                          *
 *  Display text files automatically to each user at logon.                 *
 *                                                                          *
 *                                 - Bill Hyatt, March 1993                 *
 *                                                                          *
 ****************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "bbsmajor.h"
#undef    LEVEL4                 /* don't need Level 4 from BBSMAJOR.MSG    */
#include "galnote.h"

#define ANCING -1                /* announcing to user substate             */
#define noteptr ((struct noteusr *)vdaptr)
#define BYT2RD 512               /* no. of bytes to read from disk at once  */
#define NTENAM "GCOMM NOTES"

void EXPORT init__galnote(void);
int  note(void);
void notests(void);
int  prcafl(void);
void endafl(void);
void clsafl(void);
void notefin(void);
STATIC int ntgge(void);
STATIC void ntuge(void);

struct module noteblk={          /* module interface block                  */
     "",                         /*    description for main menu            */
     note,                       /*    user logon supplemental routine      */
     NULL,                       /*    input routine if selected            */
     notests,                    /*    status-input rtn if selected         */
     NULL,                       /*    "injoth" routine for this mod        */
     NULL,                       /*    user logoff supplemental rtn         */
     clsafl,                     /*    hangup (lost carrier) routine        */
     NULL,                       /*    midnight cleanup routine             */
     NULL,                       /*    delete-account routine               */
     notefin                     /*    finish-up (sys shutdown) rtn         */
};

struct noteusr {                 /* announcer vda data block                */
     FILE *notefil;              /*     handle for announcement file        */
};

static
int notestt;                     /* Logon Notes state                       */

FILE *notemb,                    /* GALNOTE.MCV                             */
     *notefil;                   /* file containing announcement text       */

extern
FILE *mjrmb;                     /* BBSMAJOR.MCV                            */

char *notefnm,                   /* name of file containing annc. text      */
     *txtatr;                    /* ANSI attr for announcement text         */

int ufphdr,                      /* use text block FPGHDR as annc. txt hdr? */
    shwalw;                      /* show announcements every logon 1=YES    */

static
struct fndblk notefb;            /* fndblk structure for announcement file  */

struct ntgen {                   /* BBSGEN.DAT load/save structure          */
     char userid[UIDSIZ];        /*     User-ID for load/save               */
     char modnam[MNMSIZ];        /*     Module name (GCOMM NOTES)           */
     struct fndblk ntblk;        /*     fndblk for last read file           */
} *ntgbuf;                       /* ptr to single load/save area            */

void EXPORT
init__galnote(void)              /* Initialize Logon Notes                  */
{
     stzcpy(noteblk.descrp,gmdnam("GALNOTE.MDF"),MNMSIZ);
     notestt=register_module(&noteblk);
     dclvda(sizeof(struct noteusr));
     notemb=opnmsg("GALNOTE.MCV");
     notefnm=stgopt(ANCFNM);
     ufphdr=ynopt(UFPHDR);
     txtatr=stgopt(TXTATR);
     shwalw=ynopt(SHWALW);
     ntgbuf=(struct ntgen *)alcmem(sizeof(struct ntgen));
}

int
note(void)                        /* Logon Notes supp. logon routine        */
{
     setmbk(notemb);
     switch (usrptr->substt) {
     case 0:
          if ((noteptr->notefil=fopen(notefnm,FOPRB)) == NULL) {
               return(0);
          }
          if (!shwalw) {
               fnd1st(&notefb,notefnm,0);
               if (ntgge()) {
                    if (sameas(notefb.name,ntgbuf->ntblk.name)
                      && notefb.time == ntgbuf->ntblk.time
                      && notefb.date == ntgbuf->ntblk.date
                      && notefb.size == ntgbuf->ntblk.size) {
                         fclose(noteptr->notefil);
                         noteptr->notefil=NULL;
                         return(0);
                    }
               }
          }
          if ((usaptr->ansifl&ANSON) && (samend(notefnm,".ANS")
                                      || samend(notefnm,".IBM"))) {
               btutsw(usrnum,0);
               btuxnf(usrnum,0,19);
          }
          if (ufphdr) {
               setmbk(mjrmb);
               prfmsg(FPGHDR);
               rstmbk();
          }
          else {
               prfmsg(ANCHDR);
          }
          prf("\33[0m%s",txtatr);
          outprf(usrnum);
          usrptr->substt=ANCING;
          btuinj(usrnum,CYCLE);
          break;
     case ANCING:
          if (usrptr->flags&ABOIP) {
               endafl();
               return(0);
          }
          break;
     case ANCTRL:
          prfmsg(ANCTRL);
          outprf(usrnum);
          return(0);
     }
     return(1);
}

void
notests(void)                     /* Logon Notes status handler             */
{
     switch (status) {
     case CYCLE:
          if (prcafl()) {
               btuinj(usrnum,CYCLE);
          }
          else {
               usrptr->substt=ANCTRL;
               injacr();
          }
          break;
     default:
          dfsthn();
     }
}

int
prcafl(void)                     /* ongoing announce-file read/processing   */
{
     int oba;
     static char txtbuf[BYT2RD];

     clrprf();
     oba=min(btuoba(usrnum),4096);
     while (oba > (BYT2RD*2)) {
          if (mdfgets(txtbuf,BYT2RD,noteptr->notefil) == NULL) {
               if (btuoba(usrnum) == outbsz-1 && prfbuf[0] == '\0') {
                    endafl();
                    return(0);
               }
               break;
          }
          prf("%s",txtbuf);
          oba-=strlen(txtbuf);
     }
     if (prfbuf[0] != '\0') {
          xltctls(prfbuf);       /* translate ^'s into control characters   */
          outprf(usrnum);
     }
     return(1);
}

void
endafl(void)                     /* file-read operation complete, finish up */
{
     clsafl();
     btutsw(usrnum,usaptr->scnwid);
     rstrxf();
     if (btuoba(usrnum) != outbsz-1) {
          btuclo(usrnum);
          prf("\r");
     }
     if (!shwalw) {
          ntuge();
     }
}

void
clsafl(void)                     /* close user's handle for anncmnt file    */
{
     if (usrptr->state == notestt && noteptr->notefil != NULL) {
          fclose(noteptr->notefil);
          noteptr->notefil=NULL;
     }
}

void
notefin(void)                    /* Logon Notes system shutdown rtn         */
{
     clsmsg(notemb);
}

STATIC int
ntgge(void)                        /* read BBSGEN.DAT's GALNOTE info       */
{
     int retval;

     setmem(ntgbuf,sizeof(struct ntgen),0);
     strcpy(ntgbuf->userid,usaptr->userid);
     strcpy(ntgbuf->modnam,NTENAM);
     setbtv(genbb);
     retval=acqbtv(ntgbuf,ntgbuf,0);
     rstbtv();
     return(retval);
}

STATIC void
ntuge(void)                        /* update BBSGEN.DAT's GALNOTE info     */
{
     setmem(ntgbuf,sizeof(struct ntgen),0);
     strcpy(ntgbuf->userid,usaptr->userid);
     strcpy(ntgbuf->modnam,NTENAM);
     movmem(&notefb,&ntgbuf->ntblk,sizeof(struct fndblk));
     setbtv(genbb);
     if (acqbtv(NULL,ntgbuf,0)) {
          upvbtv(ntgbuf,sizeof(struct ntgen));
     }
     else {
          invbtv(ntgbuf,sizeof(struct ntgen));
     }
     rstbtv();
}
