/***************************************************************************
 *                                                                         *
 *   GALFILUZ.C                                                            *
 *                                                                         *
 *   Copyright (C) 1993-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   File Libraries - UnZip Submodule                                      *
 *                                                                         *
 *                                                 - D. Pitchford  9/28/93 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "filexfer.h"
#include "reserve.h"
#include "galfilh.h"

                                   /* static functions                     */
int dizftyp(char *);
int fend(char *);
int huff_build(unsigned *,unsigned,unsigned,unsigned short *,
     unsigned short *,struct huff **,int *);
int readbits(int);
int readbyte(unsigned short *);
int revbits(int);
int rvtree(struct sftree *);
int undefl(FILE *,struct filhead *);
int unimpl(FILE *,struct filhead *);
int unshrink(FILE *);
void huff_free(struct huff *);
void inflate(void);
void flush(unsigned);
void loadst(struct sftree *,int);
void outb(int);
void outbyte(char);
void zipext(int,char *,struct filhead *);
int initfixd(void);

static
struct filhead {         /* 30 bytes+filename needed */
     char headr[4];      /* Should be 0x04034B50                      */
     int versneed;       /* version of pkzip needed to extract        */
     int flags;          /* general purpose bitflags                  */
     int method;         /* compression method                        */
     int ftime;          /* file time                                 */
     int fdate;          /* file date                                 */
     unsigned long crc32;/* file crc                                  */
     long compsz;        /* compressed size                           */
     long normsz;        /* uncompressed size                         */
     int namesz;         /* filename size                             */
     int xtrasz;         /* extra field size                          */
} *fhdr;

static
struct dirhead {         /* 46+filename */
     char headr[4];      /* Should be 0x02014B50                      */
     int versmade;       /* version of pkzip that created             */
     int versneed;       /* version of pkzip needed to extract        */
     int flags;          /* general purpose bitflags                  */
     int method;         /* compression method                        */
     int ftime;          /* file time                                 */
     int fdate;          /* file date                                 */
     unsigned long crc32;/* file crc                                  */
     long compsz;        /* compressed size                           */
     long normsz;        /* uncompressed size                         */
     int namesz;         /* filename size                             */
     int xtrasz;         /* extra field size                          */
     int commsz;         /* file comment length                       */
     int dsknst;         /* disk number start                         */
     int infatr;         /* internal file attributes                  */
     long extatr;        /* external file attributes                  */
     long offshd;        /* offset to local header                    */
} *dhdr;

static
struct endcdr {          /* end of central directory record           */
     char headr[4];      /* should be 0x06054b50                      */
     int diskno;         /* number of this disk                       */
     int ctrbeg;         /* number of disk with start of central dir  */
     int ctrcnt;         /* number of entries in central dir on disk  */
     int totcnt;         /* total number of central dir entries       */
     unsigned long ctrsiz;/* size of the central directory            */
     long ctroff;        /* offset of start of central directory      */
     int commsz;         /* zip file comment length                   */
} *ehdr;

struct sftree_entry {
     char bit_length;
     int code;
     char value;
};

static
struct sftree {
     struct sftree_entry *tree;
     int entries;
     int max_length;
} ltree,lentree,distree;

#define INFLATE2  12               /* Various inflate() "states"           */
#define INFLATE3  13
#define INFLATE4  14
#define INFNOK    15
#define INFOK     16
#define INFLATE5  17
#define INFLATE6  18
#define INFLATE7  19
#define WSIZE  0x800
#define BMAX      16
#define N_MAX    288

     /* below find macros for inflating */

#define NEXTBYTE    (readbyte(&zp.bytebuf), zp.bytebuf)
#define NEEDBITS(n) {while(k<(n)){b|=((unsigned long)NEXTBYTE)<<k;k+=8;}}
#define DUMPBITS(n) {b>>=(n);k-=(n);}
#define NEEDBITS2(n) {while(zp.k<(n)) \
     {zp.b|=((unsigned long)NEXTBYTE)<<zp.k;zp.k+=8;}}
#define DUMPBITS2(n) {zp.b>>=(n);zp.k-=(n);}
#define NEEDBITS3(n) {while(zp.k4<(n))\
     {zp.b4|=((unsigned long)NEXTBYTE)<<zp.k4;zp.k4+=8;}}
#define DUMPBITS3(n) {zp.b4>>=(n);zp.k4-=(n);}
#define NEEDBITS4(n) {while(zp.k3<(n))\
     {zp.b3|=((unsigned long)NEXTBYTE)<<zp.k3;zp.k3+=8;}}
#define DUMPBITS4(n) {zp.b3>>=(n);zp.k3-=(n);}
#define NEEDBITS5(n) {while(zp.k5<(n))\
     {zp.b5|=((unsigned long)NEXTBYTE)<<zp.k5;zp.k5+=8;}}
#define DUMPBITS5(n) {zp.b5>>=(n);zp.k5-=(n);}

typedef unsigned char  byte;       /* code assumes UNSIGNED bytes          */

struct huff {
     byte e;                       /* number of extra bits or operation    */
     byte b;                       /* number of bits in this code/subcode  */
     union {
          unsigned short n;        /* literal, length base, or dist base   */
          struct huff *t;          /* pointer to next level of table       */
     } v;
};

static
struct inflate {
     unsigned short bytebuf;
     unsigned huffs;
     unsigned wp;                  /* current position in slide            */
     unsigned long bb;             /* bit buffer                           */
     unsigned bk;                  /* bits in bit buffer                   */
     int lbits;                    /* bits in base lit/len lookup table    */
     int dbits;                    /* bits in base distance lookup table   */
     unsigned long b;              /* bit buffer                           */
     unsigned int k;               /* number of bits in bit buffer         */
     int e2;                       /* last block flag                      */
     unsigned h2;                  /* maximum struct huff's malloc'ed      */
     unsigned t3;                  /* block type                           */
     unsigned long b3;             /* bit buffer                           */
     unsigned int k3;              /* number of bits in bit buffer         */
     int i4;                       /* temporary variables                  */
     unsigned j4;
     unsigned l4;                  /* last length                          */
     unsigned m4;                  /* mask for bit lengths table           */
     unsigned n4;                  /* number of lengths to get             */
     struct huff *tl4;             /* literal/length code table            */
     struct huff *td4;             /* distance code table                  */
     int bl4;                      /* lookup bits for tl                   */
     int bd4;                      /* lookup bits for td                   */
     unsigned nb4;                 /* number of bit length codes           */
     unsigned nl4;                 /* number of literal/length codes       */
     unsigned nd4;                 /* number of distance codes             */
     unsigned ll4[286+30];         /* literal/length and distance code len */
     unsigned long b4;             /* bit buffer                           */
     unsigned int k4;              /* number of bits in bit buffer         */
     unsigned int e5;              /* table entry flag/number of xtra bits */
     unsigned n5, d5;              /* length and index for copy            */
     unsigned w5;                  /* current window position              */
     struct huff *t5;              /* pointer to table entry               */
     unsigned ml5, md5;            /* masks for bl and bd bits             */
     unsigned long b5;             /* bit buffer                           */
     unsigned int k5;              /* number of bits in bit buffer         */
     int defstate;                 /* current "state" of inflate routine   */
     long csize;                   /* bytes-remaining to inflate           */
     long cur_zip_bs;
     char *inptr;
} zp;

static
unsigned border[]={16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15};
static
unsigned short cplens[]={3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,
     43,51,59,67,83,99,115,131,163,195,227,258,0,0};
static
unsigned short cplext[]={0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,
     4,4,5,5,5,5,0,99,99};
static
unsigned short cpdist[]={1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,
     257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577};
static
unsigned short cpdext[]={0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,
     10,10,11,11,12,12,13,13};
static
unsigned short mask_bits[]={0x0000,0x0001,0x0003,0x0007,0x000f,0x001f,0x003f,
     0x007f,0x00ff,0x01ff,0x03ff,0x07ff,0x0fff,0x1fff,0x3fff,0x7fff,0xffff};

static
byte slide[WSIZE];

static
int output_index,
    output_avail,
    input_avail,
    input_index,
    zip_eof,
    bits_left,
    *prefix_of;                    /* utility array for unshrinking        */

static
long compressed,
     input_offset,
     output_offset;

static
char *input_buf,                   /* a buffer                             */
     *output_buf,                  /* another buffer                       */
     *stack,                       /* utility array for unshrinking        */
     *suffix_of;                   /* utility array for unshrinking        */

int
dizread(void)                      /* CYCLE calls this, read some more     */
{
     int go=1,x,loop;
     char *b;
     long y;
     char fin[13];

     b=vdaptr;
     switch (flo->state) {
     case 0: /* read initial ID */
          setmem(b,2049,0);
          if (fread(b,1,52,flo->fsrc) != 52) {
               go=0;
          }
          else {
               x=dizftyp(b);
               switch (x) {
               case 2:
               case 4:
                    if ((b[2] != 0x07) || (b[3] != 0x08)) {
                         break;
                    }
               default:
               case 0:
                    go=0;
                    break;
               case 1:
               case 3:
                    break;
               }
               if (go) {
                    flo->state=1; /* look through whole thing */
               }
          }
          break;
     case 1:
          if (fseek(flo->fsrc,flo->pos,0) != 0) {
               go=0;
               break;
          }
          if (fread(b,1,128,flo->fsrc) == 0) {
               go=0;
               break;
          }
          dhdr=(struct dirhead *)b;
          fhdr=(struct filhead *)b;
          x=b[2]+b[3]*256;
          switch (x) {
          case 0x01EF:
               flo->pos=0x31F0L;
               break;
          case 0x0201:
               flo->pos+=0x2e+dhdr->namesz+dhdr->xtrasz+dhdr->commsz;
               break;
          case 0x0403:
               setmem(fin,13,0);
               if (fhdr->namesz < 13) {
                    for (loop=0 ; loop < fhdr->namesz ; loop++) {
                         fin[loop]=b[0x1e+loop];
                    }
                    if (sameas(fin,"FILE_ID.DIZ")) {
                         if (fhdr->normsz < 1000) {
                              flo->pos+=0x1e+fhdr->namesz+fhdr->xtrasz;
                              zipext(3,b,fhdr);
                              flo->pos+=fhdr->compsz;
                              break;
                         }
                    }
                    else if (sameas(fin,"DESC.SDI")) {
                         if (fhdr->normsz < 100) {
                              flo->pos+=0x1e+fhdr->namesz+fhdr->xtrasz;
                              zipext(2,b,fhdr);
                              flo->pos+=fhdr->compsz;
                              break;
                         }
                    }
               }
               flo->pos+=0x1e+fhdr->namesz+fhdr->xtrasz+fhdr->compsz;
               break;
          case 0x0605:
               go=0; /* end normally */
               break;
          default:
               go=0;
               break;
          }
          break;
     case 2:
          if (fseek(flo->fsrc,flo->pos,0) != 0) {
               go=0;
               break;
          }
          y=flo->filen;
          if (y > 2048L) {
               y=2048L;
          }
          if (fread(b,1,(int)y,flo->fsrc) != (int)y) {
               go=0;
               break;
          }
          go=fend(b);
          break;
     default:
          go=0;
          break;
     }
     if (!go) {
          fclose(flo->fsrc);
          flo->fsrc=NULL;
     }
     return(go);
}

void
init_galfiluz(void)                /* initialize library variables         */
{
     suffix_of=(char *)alcmem(8192);
     stack=(char *)alcmem(8192);
     prefix_of=(int *)alcmem(8192*sizeof(int));
     output_buf=(char *)alcmem(1025);
     input_buf=(char *)alcmem(512);
     ltree.tree=(struct sftree_entry *)alcmem(256*sizeof(struct sftree_entry));
     lentree.tree=(struct sftree_entry *)alcmem(64*sizeof(struct sftree_entry));
     distree.tree=(struct sftree_entry *)alcmem(64*sizeof(struct sftree_entry));
     dclvda(2049);
}

int
openzip(void)                     /* open .ZIP file, determine if valid   */
{
     struct fndblk fb;

     if (fnd1st(&fb,flo->destpath,0)) {
          flo->filen=fb.size;
          flo->fsrc=fopen(flo->destpath,FOPRB);
          flo->pos=0l;
          if (flo->fsrc != NULL) {
               flo->state=0;
               return(1);
          }
     }
     return(0);
}

STATIC void
zipext(                           /* extract compressed desc file         */
int name,                          /* 2 = userdir(2)    3 = userdir(3)     */
char *buf,
struct filhead *f)
{
     int ok=0,n;
     FILE *outfil=NULL;

     if (fseek(flo->fsrc,flo->pos,0) != 0) {
          return;
     }
     outfil=fopen(userdir(name),FOPWB);
     if (outfil == NULL) {
          return;
     }
     compressed=f->compsz;
     switch (f->method) {
     case 0: /* stored */
          n=(int)f->compsz;
          if (fread(buf,1,n,flo->fsrc) == n) {
               fwrite(buf,n,1,outfil);
               ok=1;
          }
          break;
     case 1: /* shrunk */
          ok=unshrink(outfil);
          break;
     case 6: /* imploded */
          ok=unimpl(outfil,f);
          break;
     case 8: /* deflated */
          ok=undefl(outfil,f);
          break;
     default:
          break;
     }
     if (outfil != NULL) {
          fclose(outfil);
          outfil=NULL;
     }
     if (!ok) {
          unlink(userdir(name));
     }
}

STATIC int
unshrink(                          /* [unshrink]  initializer              */
FILE *out)
{
     int code_bits;
     int stack_index;
     int final_char;
     int last_code;
     int i,this_code,code,prefix,got;
     int first_free;

     bits_left=0;
     input_index=0;
     input_avail=0;
     input_offset=0L;
     zip_eof=0;
     code_bits=9;
     first_free=257;
     for (i=0 ; i < 8192 ; i++) {
          prefix_of[i]=0xffff;
     }
     for (i=0 ; i < 256 ; i++) {
          prefix_of[i]=0;
          suffix_of[i]=i;
     }
     last_code=readbits(code_bits);
     if (zip_eof) {
          return(0);
     }
     final_char=last_code;
     fprintf(out,"%c",(char)final_char);
     stack_index=0;
     while (!zip_eof) {
          do {
               code=readbits(code_bits);
               if (zip_eof) {
                    break;
               }
               if (code == 256) {
                    code=readbits(code_bits);
                    switch (code) {
                    case 1:
                         code_bits++;
                         break;
                    case 2:
                         for (code=257 ; code < first_free ; code++) {
                              prefix_of[code]|=0x8000;
                         }
                         for (code=257 ; code < first_free ; code++) {
                              prefix=prefix_of[code]&0x7fff;
                              if (prefix >= 257) {
                                   prefix_of[prefix]&=0x7fff;
                              }
                         }
                         for (code=257 ; code < first_free ; code++) {
                              if (prefix_of[code]&0x8000) {
                                   prefix_of[code]=-1;
                              }
                         }
                         first_free=257;
                         while ((first_free < (1<<13)) &&
                            (prefix_of[first_free] != -1)) {
                              first_free++;
                         }
                         break;
                    }
                    got=1;
               }
               else {
                    got=0;
               }
          } while (got);
          this_code=code;
          if (prefix_of[code] == -1) {
               stack[stack_index++]=final_char;
               code=last_code;
          }
          while (code >= 257) {
               stack[stack_index++]=suffix_of[code];
               code=prefix_of[code];
          }
          final_char=suffix_of[code];
          stack[stack_index++]=final_char;
          while (stack_index) {
               fprintf(out,"%c",stack[--stack_index]);
          }
          code=first_free;
          if (code < (1<<13)) {
               prefix_of[code]=last_code;
               suffix_of[code]=final_char;
               while ((first_free < (1<<13)) &&
                  (prefix_of[first_free] != -1)) {
                    first_free++;
               }
          }
          last_code=this_code;
     }
     return(1);
}

STATIC int
unimpl(                            /* [explode]   initializer              */
FILE *out,
struct filhead *f)
{
     int distance,length,ldb,ltreep,mml,back_index,i;

     bits_left=0;
     input_index=0;
     input_avail=0;
     input_offset=0L;
     zip_eof=0;
     output_index=0;
     output_avail=0;
     output_offset=0L;
     if (f->flags&2) {
          ldb=7;
     }
     else {
          ldb=6;
     }
     if (f->flags&4) {
          mml=3;
          loadst(&ltree,256);
          ltreep=1;
     }
     else {
          mml=2;
          ltreep=0;
     }
     loadst(&lentree,64);
     loadst(&distree,64);
     while (!zip_eof) {
          if (readbits(1)) {
               if (ltreep) {
                    outbyte(rvtree(&ltree));
                    if (zip_eof) {
                         break;
                    }
               }
               else {
                    outbyte(readbits(8));
                    if (zip_eof) {
                         break;
                    }
               }
          }
          else {
               if (zip_eof) {
                    break;
               }
               distance=readbits(ldb)+(rvtree(&distree)<<ldb);
               if (zip_eof) {
                    break;
               }
               length=rvtree(&lentree)+mml;
               if (zip_eof) {
                    break;
               }
               if (length == (63+mml)) {
                    length+=readbits(8);
               }
               back_index=output_index-(distance+1);
               if (back_index < 0) {
                    back_index+=1025;
               }
               while (length) {
                    outbyte(output_buf[back_index]);
                    back_index=(back_index+1)%1025;
                    length--;
               }
          }
     }
     i=0;
     while (output_avail) {
          fprintf(out,"%c",output_buf[i++]);
          output_avail--;
     }
     return(1);
}

STATIC void
outbyte(                           /* [unshrink, explode]   "output byte"  */
char b)
{
     output_buf[output_index]=b;
     output_index=(output_index+1)%1025;
     output_avail++;
     output_offset++;
     if (output_avail > 1025-10) {
          zip_eof=1;
     }
}

STATIC int
readbits(                          /* [unshrink, explode]   "read bits"    */
int b)
{
     register int x;
     register int mask;
     int n;

     x=0;
     mask=1;
     while (b) {
          if (!bits_left) {
               input_index++;
               if (input_index >= input_avail) {
                    n=512;
                    if (compressed-input_offset < n) {
                         n=(int)(compressed-input_offset);
                    }
                    input_avail=fread(input_buf,1,n,flo->fsrc);
                    if (!input_avail) {
                         zip_eof=1;
                         return(0);
                    }
                    input_offset+=input_avail;
                    input_index=0;
               }
               bits_left=8;
          }
          if (input_buf[input_index]&1) {
               x|=mask;
          }
          input_buf[input_index] >>= 1;
          bits_left--;
          mask<<=1;
          b--;
     }
     return(x);
}

STATIC void
loadst(                            /* [explode]   "load sf tree"           */
struct sftree *t,
int tree_size)
{
     int ctbs,i,num,len,code,codeinc,lbitlen;
     char swapped,x,y;
     struct sftree_entry temp;

     t->entries=tree_size;
     ctbs=readbits(8)+1;
     i=0;
     t->max_length=0;
     while (ctbs) {
          len=readbits(4)+1;
          num=readbits(4)+1;
          while (num != 0) {
               if (len > t->max_length) {
                    t->max_length=len;
               }
               t->tree[i].bit_length=len;
               t->tree[i].value=i;
               i++;
               num--;
          }
          ctbs--;
     }
     do {
          swapped=0;
          for (i=0; i < t->entries-1; i++) {
               x=t->tree[i].bit_length;
               y=t->tree[i+1].bit_length;
               if (x > y ||
                  (x == y && t->tree[i].value > t->tree[i+1].value)) {
                    temp=t->tree[i];
                    t->tree[i]=t->tree[i+1];
                    t->tree[i+1]=temp;
                    swapped=1;
               }
          }
     } while (swapped);
     code=0;
     codeinc=0;
     lbitlen=0;
     i=t->entries-1;
     while (i >= 0) {
          code+=codeinc;
          if (t->tree[i].bit_length != lbitlen) {
               lbitlen=t->tree[i].bit_length;
               codeinc=1<<(16-lbitlen);
          }
          t->tree[i].code=revbits(code);
          i--;
     }
}

STATIC int
revbits(int x)                     /* [explode]   "reverse bits"           */
{
     register int in,out;
     int b;

     in=x;
     out=0;
     for (b=0; b < 16; b++) {
          out<<=1;
          if (in&1) {
               out|=1;
          }
          in>>=1;
     }
     return(out);
}

STATIC int
rvtree(                            /* [explode]   "read via tree"          */
struct sftree *t)
{
     int code,bits,index;

     code=bits=index=0;
     for (;;) {
          code|=readbits(1)<<bits;
          bits++;
          while (t->tree[index].bit_length < bits) {
               index++;
               if (index >= t->entries) {
                    zip_eof=1;
                    return(0);
               }
          }
          while (t->tree[index].bit_length == bits) {
               if (t->tree[index].code == code) {
                    return(t->tree[index].value);
               }
               index++;
               if (index >= t->entries) {
                    zip_eof=1;
                    return(0);
               }
          }
     }
}

STATIC int
undefl(                            /* [inflate] initializer                */
FILE *out,
struct filhead *f)
{
     int i;

     output_index=0;
     output_avail=0;
     input_avail=0;
     output_offset=0L;
     zp.lbits=9;
     zp.dbits=6;
     zp.wp=0;
     zp.bk=0;
     zp.bb=0;
     zp.h2=0;
     zp.huffs=0;
     zp.defstate=INFLATE2;
     zp.csize=f->compsz;
     while ((zp.defstate != INFOK) && (zp.defstate != INFNOK)) {
          inflate();
     }
     if (zp.defstate == INFNOK) {
          return(0);
     }
     i=0;
     while (output_avail) {
          fprintf(out,"%c",output_buf[i++]);
          output_avail--;
     }
     return(1);
}

STATIC void
inflate(void)                      /* Routine to INFLATE deflated .ZIPs    */
{
     switch (zp.defstate) {
     case INFLATE2:
          zp.b3=zp.bb;
          zp.k3=zp.bk;
          NEEDBITS4(1)
          zp.e2=(int)zp.b3&1;
          DUMPBITS4(1)
          NEEDBITS4(2)
          zp.t3=(unsigned)zp.b3&3;
          DUMPBITS4(2)
          zp.bb=zp.b3;
          zp.bk=zp.k3;
          switch (zp.t3) {
          case 2:
               zp.defstate=INFLATE3;
               break;
          case 1:
               if (initfixd()) {
                    zp.defstate=INFLATE4;
                    break;
               }
          default:
               zp.defstate=INFNOK;
          }
          return;
     case INFLATE3:
          zp.b4=zp.bb;
          zp.k4=zp.bk;
          NEEDBITS3(5)
          zp.nl4=257+((unsigned)zp.b4&0x1f);
          DUMPBITS3(5)
          NEEDBITS3(5)
          zp.nd4=1+((unsigned)zp.b4&0x1f);
          DUMPBITS3(5)
          NEEDBITS3(4)
          zp.nb4=4+((unsigned)zp.b4&0xf);
          DUMPBITS3(4)
          if (zp.nl4 > 286 || zp.nd4 > 30) {
               zp.defstate=INFNOK;
               return;
          }
          for (zp.j4=0 ; zp.j4 < zp.nb4 ; zp.j4++) {
               NEEDBITS3(3)
               zp.ll4[border[zp.j4]]=(unsigned)zp.b4&7;
               DUMPBITS3(3)
          }
          for ( ; zp.j4 < 19 ; zp.j4++) {
               zp.ll4[border[zp.j4]]=0;
          }
          zp.bl4=7;
          if ((zp.i4=huff_build(zp.ll4,19,19,NULL,NULL,
              &zp.tl4,&zp.bl4)) != 0) {
               if (zp.i4 == 1) {
                    huff_free(zp.tl4);
               }
               zp.defstate=INFNOK;
               return;
          }
          zp.n4=zp.nl4+zp.nd4;
          zp.m4=mask_bits[zp.bl4];
          zp.i4=zp.l4=0;
          while ((unsigned)zp.i4 < zp.n4) {
               NEEDBITS3((unsigned)zp.bl4)
               zp.j4=(zp.td4=zp.tl4+((unsigned)zp.b4&zp.m4))->b;
               DUMPBITS3(zp.j4)
               zp.j4=zp.td4->v.n;
               if (zp.j4 < 16) {
                    zp.ll4[zp.i4++]=zp.l4=zp.j4;
               }
               else if (zp.j4 == 16) {
                    NEEDBITS3(2)
                    zp.j4=3+((unsigned)zp.b4&3);
                    DUMPBITS3(2)
                    if ((unsigned)zp.i4+zp.j4 > zp.n4) {
                         zp.defstate=INFNOK;
                         return;
                    }
                    while (zp.j4--)
                         zp.ll4[zp.i4++]=zp.l4;
               }
               else if (zp.j4 == 17) {
                    NEEDBITS3(3)
                    zp.j4=3+((unsigned)zp.b4&7);
                    DUMPBITS3(3)
                    if ((unsigned)zp.i4+zp.j4 > zp.n4) {
                         zp.defstate=INFNOK;
                         return;
                    }
                    while (zp.j4--) {
                         zp.ll4[zp.i4++]=0;
                    }
                    zp.l4=0;
               }
               else {
                    NEEDBITS3(7)
                    zp.j4=11+((unsigned)zp.b4&0x7f);
                    DUMPBITS3(7)
                    if ((unsigned)zp.i4+zp.j4 > zp.n4) {
                         zp.defstate=INFNOK;
                         return;
                    }
                    while (zp.j4--) {
                         zp.ll4[zp.i4++]=0;
                    }
                    zp.l4=0;
               }
          }
          huff_free(zp.tl4);
          zp.bb=zp.b4;
          zp.bk=zp.k4;
          zp.bl4=zp.lbits;
          if ((zp.i4=huff_build(zp.ll4,zp.nl4,257,cplens,cplext,
               &zp.tl4,&zp.bl4)) != 0) {
               if (zp.i4 == 1) {
                    huff_free(zp.tl4);
               }
               zp.defstate=INFNOK;
               return;
          }
          zp.bd4=zp.dbits;
          if ((zp.i4=huff_build(zp.ll4+zp.nl4,zp.nd4,0,
              cpdist,cpdext,&zp.td4,&zp.bd4)) != 0) {
               if (zp.i4 == 1) {
                    huff_free(zp.td4);
               }
               huff_free(zp.tl4);
               zp.defstate=INFNOK;
               return;
          }
          zp.defstate=INFLATE4;
          return;
     case INFLATE4:
          zp.b5=zp.bb;
          zp.k5=zp.bk;
          zp.w5=zp.wp;
          zp.ml5=mask_bits[zp.bl4];
          zp.md5=mask_bits[zp.bd4];
          zp.defstate=INFLATE5;
          return;
     case INFLATE5:
          NEEDBITS5((unsigned)zp.bl4)
          if ((zp.e5=(zp.t5=zp.tl4+
              ((unsigned)zp.b5&zp.ml5))->e) > 16) {
               do {
                    if (zp.e5 == 99) {
                         zp.defstate=INFNOK;
                    }
                    DUMPBITS5(zp.t5->b)
                    zp.e5-=16;
                    NEEDBITS5(zp.e5)
               } while ((zp.e5=(zp.t5=zp.t5->v.t+
                 ((unsigned)zp.b5&mask_bits[zp.e5]))->e) > 16);
          }
          DUMPBITS5(zp.t5->b)
          if (zp.e5 == 16) {
               slide[zp.w5++]=(unsigned char)zp.t5->v.n;
               if (zp.w5 == WSIZE) {
                    flush(zp.w5);
                    zp.w5=0;
               }
          }
          else {
               /* exit if end of block */
               if (zp.e5 == 15) {
                    zp.defstate=INFLATE6;
                    return;
               }
               NEEDBITS5(zp.e5)
               zp.n5=zp.t5->v.n+((unsigned)zp.b5&mask_bits[zp.e5]);
               DUMPBITS5(zp.e5);
               NEEDBITS5((unsigned)zp.bd4)
               if ((zp.e5=(zp.t5=zp.td4+
                   ((unsigned)zp.b5&zp.md5))->e) > 16) {
                    do {
                         if (zp.e5 == 99) {
                              zp.defstate=INFNOK;
                         }
                         DUMPBITS5(zp.t5->b)
                         zp.e5-=16;
                         NEEDBITS5(zp.e5)
                    } while ((zp.e5=(zp.t5=zp.t5->v.t+
                       ((unsigned)zp.b5&mask_bits[zp.e5]))->e)
                        > 16);
               }
               DUMPBITS5(zp.t5->b)
               NEEDBITS5(zp.e5)
               zp.d5=zp.w5-zp.t5->v.n-((unsigned)zp.b5&mask_bits[zp.e5]);
               DUMPBITS5(zp.e5)
               zp.defstate=INFLATE7;
               return;
          }
          return;
     case INFLATE6:
          zp.wp=zp.w5;
          zp.bb=zp.b5;
          zp.bk=zp.k5;
          huff_free(zp.tl4);
          huff_free(zp.td4);
          if (zp.huffs > zp.h2) {
               zp.h2=zp.huffs;
          }
          if (!zp.e2) {
               zp.huffs=0;
               zp.defstate=INFLATE2;
               return;
          }
          flush(zp.wp);
          zp.defstate=INFOK;
          return;
     case INFLATE7:
          zp.n5-=(zp.e5=(zp.e5=WSIZE-((zp.d5&=WSIZE-1)
           > zp.w5 ? zp.d5 : zp.w5)) > zp.n5 ? zp.n5 :
            zp.e5);
          if (zp.w5-zp.d5 >= zp.e5) {
               memcpy(slide+zp.w5,slide+zp.d5,zp.e5);
               zp.w5+=zp.e5;
               zp.d5+=zp.e5;
          }
          else {
               do {
                    slide[zp.w5++]=slide[zp.d5++];
               } while (--zp.e5);
          }
          if (zp.w5 == WSIZE) {
               flush(zp.w5);
               zp.w5=0;
          }
          if (!zp.n5) { /* 3 */
               zp.defstate=INFLATE5;
          }
          return;
     }
}

STATIC int
initfixd(void)                     /* init inflate of fixed code block     */
{
     int i;

     for (i=0 ; i < 144 ; i++) {
          zp.ll4[i]=8;
     }
     for (; i < 256 ; i++) {
          zp.ll4[i]=9;
     }
     for (; i < 280 ; i++) {
          zp.ll4[i]=7;
     }
     for (; i < 288 ; i++) {
          zp.ll4[i]=8;
     }
     zp.bl4=7;
     if ((i=huff_build(zp.ll4,288,257,cplens,cplext,&zp.tl4,&zp.bl4)) != 0) {
          return(0);
     }
     for (i=0 ; i < 30 ; i++) {
          zp.ll4[i]=5;
     }
     zp.bd4=5;
     if ((i=huff_build(zp.ll4,30,0,cpdist,cpdext,&zp.td4,&zp.bd4)) > 1) {
          huff_free(zp.tl4);
          return(0);
     }
     return(1);
}

STATIC int                         /* build Huffman tables                 */
huff_build(unsigned *b,
           unsigned n,
           unsigned s,
           unsigned short *d,
           unsigned short *e,
           struct huff **t,
           int *m)
{
     unsigned a;                   /* counter for codes of length k        */
     unsigned c[BMAX+1];           /* bit length count table               */
     unsigned f;                   /* i repeats in table every f entries   */
     int g;                        /* maximum code length                  */
     int h;                        /* table level                          */
     unsigned int i;               /* counter, current code                */
     unsigned int j;               /* counter                              */
     int k;                        /* number of bits in current code       */
     int l;                        /* bits per table (returned in m)       */
     unsigned int *p;              /* pointer into c[], b[], or v[]        */
     struct huff *q;               /* points to current table              */
     struct huff r;                /* table entry for structure assignment */
     struct huff *u[BMAX];         /* table stack                          */
     unsigned v[N_MAX];            /* values in order of bit length        */
     int w;                        /* bits before this table == (l * h)    */
     unsigned x[BMAX+1];           /* bit offsets, then code stack         */
     unsigned *xp;                 /* pointer into x                       */
     int y;                        /* number of dummy codes added          */
     unsigned z;                   /* number of entries in current table   */

     memset(c,0,sizeof(c));
     p=b;
     i=n;
     do {
          c[*p++]++;
     } while (--i);
     if (c[0] == n) {
          *t=(struct huff *)NULL;
          *m=0;
          return(0);
     }
     l=*m;
     for (j=1 ; j <= BMAX ; j++) {
          if (c[j]) {
               break;
          }
     }
     k=j;
     if ((unsigned)l < j) {
          l=j;
     }
     for (i=BMAX ; i ; i--) {
          if (c[i]) {
               break;
          }
     }
     g=i;
     if ((unsigned)l > i) {
          l=i;
     }
     *m=l;
     for (y=1<<j ; j < i ; j++,y<<=1) {
          if ((y-=c[j]) < 0) {
               return(2);
          }
     }
     if ((y-=c[i]) < 0) {
          return(2);
     }
     c[i]+=y;
     x[1]=j=0;
     p=c+1;
     xp=x+2;
     while (--i) {
          *xp++=(j+=*p++);
     }
     p=b;
     i=0;
     do {
          if ((j=*p++) != 0) {
               v[x[j]++]=i;
          }
     } while (++i < n);
     x[0]=i=0;
     p=v;
     h=-1;
     w=-l;
     u[0]=(struct huff *)NULL;
     q=(struct huff *)NULL;
     z=0;
     for ( ; k <= g ; k++) { /* 1 */
          a=c[k];
          while (a--) { /* 2 */
               while (k > w+l) { /* 3 */
                    h++;
                    w+=l;
                    z=(z=g-w) > (unsigned)l ? l : z;
                    if ((f=1 << (j=k-w)) > a+1) {
                         f-=a+1;
                         xp=c+k;
                         while (++j < z) {
                              if ((f<<=1) <= *++xp) {
                                   break;
                              }
                              f-=*xp;
                         }
                    }
                    z=1<<j;
                    if ((q=(struct huff *)malloc((z+1)*
                        sizeof(struct huff))) == (struct huff *)NULL) {
                         if (h) {
                              huff_free(u[0]);
                         }
                         return(3);
                    }
                    zp.huffs+=z+1;
                    *t=q+1;
                    *(t=&(q->v.t))=(struct huff *)NULL;
                    u[h]=++q;
                    if (h) {
                         x[h]=i;
                         r.b=(unsigned char)l;
                         r.e=(unsigned char)(16 + j);
                         r.v.t=q;
                         j=i>>(w-l);
                         u[h-1][j]=r;
                    }
               }
               r.b=(unsigned char)(k-w);
               if (p >= v+n) {
                    r.e=99;
               }
               else if (*p < s) {
                    r.e=(unsigned char)(*p < 256 ? 16 : 15);
                    r.v.n=*p++;
               }
               else {
                    r.e=(unsigned char)e[*p-s];
                    r.v.n=d[*p++-s];
               }
               f=1 << (k-w);
               for (j=i>>w ; j < z ; j+=f) {
                    q[j]=r;
               }
               for (j=1<<(k-1) ; i&j ; j>>=1) {
                    i^=j;
               }
               i^=j;
               while ((i&((1<<w)-1)) != x[h]) {
                    h--;
                    w-=l;
               }
          }
     }
     return(y != 0 && g != 1);
}

STATIC void                        /* "Release" Huffman tables             */
huff_free(struct huff *t)
{
     struct huff *p, *q;

     p=t;
     while (p != (struct huff *)NULL) {
          q=(--p)->v.t;
          free(p);
          p=q;
     }
}

STATIC void                        /* Output inflated byte                 */
outb(int intc)
{
     if (output_avail == (1025-10)) {
          return;
     }
     output_buf[output_avail++]=(byte)intc;
}

STATIC void                        /* Flush out "w" inflated bytes         */
flush(unsigned w)
{
     unsigned n;

     for (n=0 ; n < w ; n++) {
          outb((int)slide[n]);
     }
}

STATIC int                         /* Read in next byte from .ZIP file     */
readbyte(unsigned short *x)
{
     if (zp.csize-- <= 0) {
          return(0);
     }
     if (input_avail == 0) {
          if ((input_avail=
           fread((char *)input_buf,1,512,flo->fsrc)) <= 0) {
               return(0);
          }
          /* buffer ALWAYS starts on a block boundary:  */
          zp.cur_zip_bs+=512;
          zp.inptr=input_buf;
     }
     *x=*zp.inptr;
     zp.inptr++;
     input_avail--;
     return(8);
}

STATIC int
dizftyp(                           /* determine what kind of zipfile       */
char *recbuf)
{
     if (recbuf[0] == 'P'
      && recbuf[1] == 'K'
      && ((recbuf[2] == 0x03
      && recbuf[3] == 0x04)
      || (recbuf[2] == 0x07
      && recbuf[3] == 0x08))) {
          return(recbuf[4] < 0x14 ? 1 : 2);
     }
     if (recbuf[0] == 'M'
      && recbuf[1] == 'Z') {
          if (recbuf[2] == 0xEF
            && recbuf[3] == 0x01
            && recbuf[0x32] == 'P'
            && recbuf[0x33] == 'K') {
               return(3);
          }
          if ((recbuf[2] == 0xBA
            && recbuf[3] == 0x01)
            || (recbuf[2] == 0xF4
            && recbuf[3] == 0x01
            && recbuf[0x1E] == 'P'
            && recbuf[0x1F] == 'K'
            && recbuf[0x20] == 'L')) {
               return(4);
          }
     }
     return(0);
}

STATIC int
fend(                              /* find end of central dir record       */
char *b)
{
     char *ptr;
     int cnt=0;
     long oldpos;
     int byts;

     oldpos=flo->pos;
     ptr=b;
     byts=flo->filen > 2048L ? 2048 : (int)flo->filen;
     while (cnt <= byts-sizeof(struct endcdr)) {
          if (*ptr == 'P'
            && *(ptr+1) == 'K'
            && *(ptr+2) == 5
            && *(ptr+3) == 6) {
               ehdr=(struct endcdr *)&b[cnt];
               flo->pos=ehdr->ctroff;
               flo->state=1;
               return(1);
          }
          ptr++;
          cnt++;
     }
     if (oldpos != 0L) {
          flo->pos-=(long)(2048-sizeof(struct endcdr));
          if (flo->pos < 0L) {
               flo->pos=0L;
          }
     }
     else {
          return(0);
     }
     return(1);
}
