/***************************************************************************
 *                                                                         *
 *   FTFXYMD.H                                                             *
 *                                                                         *
 *   Copyright (C) 1992-1994 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   File Transfer Software header for XMODEM and YMODEM                   *
 *                                                                         *
 *                                                  - R. Stein  1/92       *
 *                                                                         *
 ***************************************************************************/

struct xymdat {      /* data fields used for XMODEM/YMODEM receive/transmit */
     struct ftfscb scb;              /* standard session control block data */
     char flags;                     /* X/YMODEM recv/xmit flags, see below */
     unsigned char blknum;                   /* expected block number 0-255 */
     int retry;                                /* count consecutive retries */
     unsigned char headc;                    /*  \                          */
     unsigned char gotbkn;                   /*   \                         */
     unsigned char notbkn;                   /*    > X/YMODEM packet buffer */
     unsigned char block[1024];              /*   /                         */
     unsigned crc;                           /*  /                          */
     int nbytes;              /* number of actual data bytes in this packet */
     char nak;                                         /* NAK or 'G' or 'C' */
     int toxtra;                 /* optional extra timeout value (in ticks) */
};

#define xymscb ((struct xymdat *)ftfscb)


/* X/YMODEM receive/transmit flags */
#define XUF1024  0x02                       /* accept/use 1024-byte blocks? */
#define XUFCRC   0x04    /* expect/use 2-byte crc? (versus 1-byte checksum) */
#define XUTIME   0x08                               /* when to start timing */
#define XUBATCH  0x10                                   /* batch capability */
#define XUNAMNX  0x20       /* file name coming in next block for receiving */
#define XUFG     0x40                        /* "G" option for YMODEM Batch */
#define XXLOCK   0x80                         /* transmission locked (XOFF) */

extern struct ftfpsp ftpxmr;                   /* XMODEM-Checksum receiving */
extern struct ftfpsp ftpxmx;                /* XMODEM-Checksum transmitting */
extern struct ftfpsp ftpxcr;                        /* XMODEM-CRC receiving */
extern struct ftfpsp ftpxcx;                     /* XMODEM-CRC transmitting */
extern struct ftfpsp ftpx1r;                         /* XMODEM-1K receiving */
extern struct ftfpsp ftpx1x;                      /* XMODEM-1K transmitting */
extern struct ftfpsp ftpybr;                      /* YMODEM Batch receiving */
extern struct ftfpsp ftpybx;                   /* YMODEM Batch transmitting */
extern struct ftfpsp ftpygr;                          /* YMODEM-g receiving */
extern struct ftfpsp ftpygx;                       /* YMODEM-g transmitting */
