/***************************************************************************
 *                                                                         *
 *   ACCOUNT.C                                                             *
 *                                                                         *
 *   Copyright (C) 1987-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Major BBS online accounting utility.                      *
 *                                                                         *
 *                                            - T. Stryker 7/6/86          *
 *                 "class" accounting update  - C. Robert  2/2/92          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "message.h"
#include "bbsacct.h"

STATIC void inicls(void);
STATIC void inista(void);
STATIC void usetdy(unsigned acsb4d);
STATIC int lowdel(char *userid);
STATIC void repusr(struct usracc *uacc);
STATIC void svtask(int taskid);
STATIC void clssta(void);
STATIC void clscls(void);
STATIC void pbf2txt(void);
void decevy(void);
void decdft(void);
void chkliu(void);
void savvbl(void);
void updtrk(void);
void put2scn(struct usracc *accptr);

FILE *acnmb,                  /* accounting named-message file block ptr   */
     *repfp;                  /* debt report file pointer                  */
BTVFILE *accbb,               /* user accounts btrieve data file           */
        *clsbb,               /* "class" btrieve block pointer             */
        *svbb;                /* system variables btrieve block pointer    */

void *usracc;                 /* dummy user account table pointer          */
                              /* DO NOT USE THIS POINTER -- USE UACOFF()   */

void *uablok;                 /* user account array blok pointer (internal)*/

struct usracc *usaptr,        /* user accounting block pointer for usrnum  */
              *othuap,        /* gen purp other-user accounting data ptr   */
               acctmp;        /* temporary user account storage area       */
static
struct usracc *accptr;        /* general purpose pointer to user account   */

static int gotsv=0;           /* loaded sv yet? (in case of early catastro)*/

int numcls=0;                 /* total # of classes (! including disabled) */
unsigned dtrack;              /* number of HOURS since stats were zero'd   */

struct clstab *clshead,       /* head record for class table               */
              *clsptr;        /* handle ptr                                */

struct acclass clsrec;        /* one in-memory class record for temp use   */

int msgsiz;                   /* size of text message area buffer          */
#define mp ((struct message *)vdatmp)   /* message pointer                 */

extern int shwcrd;            /* show credits to guys online? (1 or 0)     */

struct sysvbl sv;             /* system variables (part 1 of 3)            */
struct sysvb2 sv2;            /* system variables (part 2 of 3)            */
struct sysvb3 sv3;            /* system variables (part 3 of 3)            */

int inmcu=0;                  /* are we in midnight cleanup now? (1 or 0)  */

                              /*-- variables for decevy() & (*decusr)() ---*/
int decusn;                   /* user number                               */
struct user *decusp;          /* user online information (MAJORBBS.H)      */
struct usracc *decuap;        /* user account information (USRACC.H)       */
long deccst;                  /* cost of online time since last (*decusr)()*/
void (*decusr)(void)=decdft;  /* decevy() service vector                   */

/*--- OPTIONS FROM BBSACCT.MSG ---*/

int pester,                   /* pester users with "how to buy creds" msg? */
    hwtlog,                   /* Time limit for logging in during hi  usage*/
    lwtlog,                   /* Time limit for logging in during low usage*/
    hwtsup,                   /* Time limit for signing up during hi  usage*/
    lwtsup;                   /* Time limit for signing up during low usage*/

void
iniacc(void)                  /* initialize accounting                     */
{
     int i;

     inicls();
     cntdir("BBSDBT.RPT");
     if ((repfp=fopen("BBSDBT.RPT",FOPAA)) == NULL) {
          shocst("CAN'T RECORD DEBTS TO DISK!",
                 "(ERROR: Can't open \"BBSDBT.RPT\" for updating!)");
     }
     else if (numfils == 0L) {
          fprintf(repfp,"User-ID                            Debt (in credits)\n");
          fprintf(repfp,"----------------------------------------------------\n\n");
     }
     acnmb=opnmsg("bbsacct.mcv");
     accbb=opnbtv("bbsusr.dat",sizeof(struct usracc));
     uablok=alcblok(nterms,sizeof(struct usracc));
     usracc=uacoff(0);        /* (for non-protected mode compatibility)    */
     for (i=0 ; i < nterms ; i++) {
          setmem(uacoff(i),sizeof(struct usracc),0);
     }
     msgsiz=outbsz-384;
     dclvda(sizeof(struct message)+msgsiz);
     pester=ynopt(PESTER);
     hwtlog=numopt(HWTLOG,-32767,32767);
     lwtlog=numopt(LWTLOG,-32767,32767);
     hwtsup=numopt(HWTSUP,-32767,32767);
     lwtsup=numopt(LWTSUP,-32767,32767);
     rtkick(15,decevy);
     inista();
}

struct usracc *
uacoff(                            /* get pointer to user's account rec    */
int unum)                          /*   user number to grab                */
{
     return((struct usracc *)ptrblok(uablok,unum));
}

STATIC
void
inicls(void)                       /* fill in class table from data file   */
{
     clsbb=opnbtv("bbsclas.dat",sizeof(struct acclass));
     clshead=NULL;
     if (qlobtv(0)) {
          gcrbtv(NULL,0);
          do {
               movmem(clsbb->data,&clsrec,sizeof(struct acclass));
               if (clshead == NULL) {
                    clshead=(struct clstab *)alcmem(sizeof(struct clstab));
                    clsptr=clshead;
               }
               else {
                    clsptr->next=(struct clstab *)alcmem(sizeof(struct clstab));
                    clsptr=clsptr->next;
               }
               clsptr->next=NULL;
               movmem(&clsrec,clsptr,sizeof(struct clstab)-sizeof(struct clstab *));
               if (!(clsptr->flags&HASCRD && clsptr->flags&NOCRED)) {
                    numcls++;
               }
          } while (qnxbtv());
     }
     else {
          catastro("EMPTY BBSCLAS.DAT!  RUN BBSSETCL UTILITY!");
     }
}

STATIC
void
inista(void)                       /* initialize the statistics collector  */
{
     svbb=opnbtv("bbsvbl.dat",sizeof(struct sysvb3));
     geqbtv(&sv,"key",0);
     geqbtv(&sv2,"ky2",0);
     geqbtv(&sv3,"ky3",0);
     updtrk();
     gotsv=1;
     rtkick(60,chkliu);
     if (svrate) {
          rtkick(svrate,savvbl);
     }
}

int
crtclass(                          /* add a class to class table and file  */
struct acclass *cptr)                   /* pointer to data to be added     */
{
     if (clshead == NULL) {
          clshead=(struct clstab *)malloc(sizeof(struct clstab));
          if (clshead == NULL) {
               return(0);
          }
          clsptr=clshead;
     }
     else {
          clsptr=clshead;
          while (clsptr->next != NULL) {
               clsptr=clsptr->next;
          }
          clsptr->next=(struct clstab *)malloc(sizeof(struct clstab));
          if (clsptr->next == NULL) {
               return(0);
          }
          clsptr=clsptr->next;
     }
     setmem(clsptr,sizeof(struct clstab),0);
     movmem(cptr,clsptr,sizeof(struct clstab)-sizeof(struct clstab *));
     setbtv(clsbb);
     insbtv(cptr);
     rstbtv();
     numcls++;
     return(1);
}

struct clstab *
fndcls(                            /* find this guy's class in the table   */
char *clsname)                          /* what class name to look for     */
{
     struct clstab *fndptr;

     if (clsname == NULL || clshead == NULL) {
          return(NULL);
     }
     for (fndptr=clshead ; fndptr != NULL ; fndptr=fndptr->next) {
          if (sameas(clsname,fndptr->clname)) {
               return(fndptr);
          }
     }
     return(NULL);
}

void
swtcls(                            /* switch user to another class         */
struct usracc *uacc,                    /* usracc to switch to new class   */
int makprm,                             /* make this permanent? (1 or 0)   */
char *clsnam,                           /* class name to switch to         */
int dest,                               /* destination result of (0-4)     */
int days)                               /* # of days 'till expire (0=dft)  */
{
     int savnum,svlngo;
     FILE *savmb;
     char swtto[KEYSIZ];
     struct clstab *tclptr;
     static int numitr=0;

     if (++numitr >= 10) {
          catastro("BAD CLASS SETUP!  CLASSES ARE IMMEDIATELY EXPIRING TO\n"
                   "ONE-ANOTHER (INVOLVING THE %s CLASS)!",clsnam);
     }
     savmb=curmbk;
     if ((tclptr=fndcls(clsnam)) == NULL) {
          delacct(uacc->userid);
     }
     else if (((tclptr->flags&NOCRED) && uacc->creds <= 0L)
              || ((tclptr->flags&HASCRD) && uacc->creds > 0L)) {
          strcpy(swtto,tclptr->nxtcls[DCREDIT]);
          swtcls(uacc,makprm,swtto,1,0);
     }
     else {
          if ((clsptr=fndcls(uacc->curcls)) != NULL) {
               if (clsptr->users > 0) {
                    clsptr->users--;
               }
          }
          tclptr->users++;
          strcpy(clsrec.clname,uacc->curcls);
          strcpy(uacc->curcls,tclptr->clname);
          if (makprm) {
               strcpy(uacc->prmcls,tclptr->clname);
               if (tclptr->flags&DAYEXP) {
                    uacc->daystt=(days == 0 ? tclptr->dftday : days);
               }
               else {
                    uacc->daystt=0;
               }
               uacc->fgvdys=0;
          }
          prf("");
          outprf(usrnum);
          clrprf();
          setmbk(acnmb);
          savnum=usrnum;
          usrnum=-1;
          if (onbbs(uacc->userid,1)) {
               usrnum=savnum;
               othusn=uisusn;
               othusp=&user[othusn];
               othuap=uacoff(othusn);
          }
          else {
               othusn=-1;
               svlngo=clingo;
               clingo=0;
          }
          if (dest < 2) {
               setbtv(clsbb);
               geqbtv(&clsrec,clsrec.clname,0);
               if (clsrec.msgs[dest][0] != '\0') {
                    pmlt(clsrec.msgs[dest]);
               }
               rstbtv();
          }
          if (prfbuf[0] == '\0') {
               if (makprm) {
                    prfmlt(dest == 3 ? SYSSWT : NEWCLS,tclptr->clname,
                           tclptr->limcal == -1 ? "UNLIMITED" :
                           spr("%d minutes",tclptr->limcal),
                           tclptr->limday == -1 ? "UNLIMITED" :
                           spr("%d minutes",tclptr->limday));
               }
               else {
                    prfmlt(dest == 0 ? TMPCLS : NWTCLS,tclptr->clname,
                           uacc->prmcls,tclptr->limcal == -1 ? "UNLIMITED"
                           : spr("%d minutes",tclptr->limcal),
                           tclptr->limday == -1 ? "UNLIMITED"
                           : spr("%d minutes",tclptr->limday));
               }
               if (shwcrd) {
                    prfmlt(CRDCLS,spr(uacc->creds > 0L ? "+%ld"
                            : "%ld",uacc->creds),
                           !(tclptr->flags&CRDXMT) ? ""
                            : "(Exempt from credit charges)");
                    if (!(tclptr->flags&CRDXMT)) {
                         prfmlt(LMTCLS,tclptr->dbtlmt == -1L
                                ? "UNLIMITED" : spr("%s credits",
                                 l2as(tclptr->dbtlmt*-1L)));
                    }
               }
               prfmlt(BOTCLS);
          }
          if (othusn == -1) {
               setmem(mp,sizeof(struct message)+msgsiz,0);
               mp->msgno=++sv.msgtot;
               stzcpy(mp->userto,uacc->userid,UIDSIZ);
               stzcpy(mp->to,uacc->userid,UIDSIZ);
               stzcpy(mp->from,"Sysop",UIDSIZ);
               strcpy(mp->topic,"Class Switch Notification");
               pbf2txt();
               mp->flags=0;
               mp->crdate=today();
               mp->crtime=now();
               sendmsg(mp,uacc->userid);
               clingo=svlngo;
               usrnum=savnum;
          }
          else {
               injoth();
               clrmlt();
               rstmbk();
               othusp->cltptr=tclptr;
               movmem(uacc,othuap,sizeof(struct usracc));
               savnum=usrnum;
               curusr(othusn);
               loadkeys(tclptr->clname);
               curusr(savnum);
          }
          setbtv(accbb);
          geqbtv(NULL,uacc->userid,0);
          updbtv(uacc);
          rstbtv();
     }
     setmbk(savmb);
     numitr--;
}

int
namacls(                           /* check a proposed new class name      */
char *clsname)                          /* class name to check             */
{
     char *ptr;

     if (strlen(clsname) > KEYSIZ-1 || strlen(clsname) < 3) {
          return(0);
     }
     for (ptr=strupr(clsname) ; *ptr != '\0' ; ptr++) {
          if (!isalnum(*ptr) && *ptr != '_') {
               return(0);
          }
     }
     return(1);
}

long
tfcchg(                            /* charge user for traffic              */
long nbytes,                            /* number of bytes of traffic      */
long credpk)                            /* charge, in credits/1024 bytes   */
{                                       /* returns actual number deducted  */
     long charge;
     int n;

     if (credpk > 0L) {
          for (n=10 ; n > 0 && nbytes > (1L<<15) ; n--) {
               nbytes>>=1;
          }
          for (charge=credpk ; n > 0 && charge > (1L<<15) ; n--) {
               charge>>=1;
          }
          charge*=nbytes;
          if (n > 0) {
               charge>>=n;
          }                        /* IOW: charge=credpk*nbytes/1024       */
          return(hdedcrd(uacoff(usrnum),charge,0,1));
     }
     return(0L);
}

int
dedcrd(                            /* deduct credits from an online account*/
long amt,                               /* amount to deduct                */
int asmuch)                             /* take as much as possible? 1 or 0*/
{
     return(ldedcrd(uacoff(usrnum),amt,0,asmuch));
}

int
rdedcrd(                           /* deduct real credits from online guy  */
long amt,                               /* amount to deduct                */
int asmuch)                             /* take as much as possible? 1 or 0*/
{
     return(ldedcrd(uacoff(usrnum),amt,1,asmuch));
}

int
odedcrd(                           /* deduct credits from an online account*/
int unum,                               /* user # of user to deduct from   */
long amt,                               /* amount to deduct                */
int real,                               /* real creds only? (no debt=1)    */
int asmuch)                             /* take as much as possible? 1 or 0*/
{
     return(ldedcrd(uacoff(unum),amt,real,asmuch));
}

int
ndedcrd(                           /* deduct credits from an offline acct  */
char *uid,                              /* userid of user to deduct from   */
long amt,                               /* amount to deduct                */
int real,                               /* real creds only? (no debt=1)    */
int asmuch)                             /* take as much as possible? 1 or 0*/
{
     long creds;
     int retval=0;

     setbtv(accbb);
     if (acqbtv(&acctmp,uid,0)) {
          retval=ldedcrd(&acctmp,amt,real,asmuch);
          creds=acctmp.creds;
          geqbtv(&acctmp,acctmp.userid,0);
          acctmp.creds=creds;
          updbtv(&acctmp);
     }
     rstbtv();
     return(retval);
}

int
gdedcrd(                           /* general deduct creds: online or off  */
char *uid,                              /* userid of user to deduct from   */
long amt,                               /* amount to deduct                */
int real,                               /* real creds only? (no debt=1)    */
int asmuch)                             /* take as much as possible? 1 or 0*/
{
     if (onsysn(uid,1)) {
          return(ldedcrd(othuap,amt,real,asmuch));
     }
     return(ndedcrd(uid,amt,real,asmuch));
}

int
ldedcrd(                           /* low-level deduct credits facility    */
struct usracc *uptr,                    /* user # of user to deduct from   */
long amt,                               /* amount to deduct                */
int real,                               /* real creds only? (no debt=1)    */
int asmuch)                             /* take as much as possible? 1 or 0*/
{
     int tmpunm,loop,retval=0;
     struct clstab *tabptr;

     othusn=-1;
     for (loop=0 ; loop < nterms ; loop++) {
          if (sameas(uptr->userid,uacoff(loop)->userid)
             && user[loop].class > SUPIPG) {
               othusn=loop;
               break;
          }
     }
     tabptr=fndcls(uptr->curcls);
     if (amt <= 0L) {
          uptr->creds-=amt;
          return(1);
     }
     else if (!real && tabptr != NULL && (tabptr->flags&CRDXMT)) {
          return(1);
     }
     switch (real || tabptr == NULL ? 0L : tabptr->dbtlmt) {
     case -1L:
          uptr->creds-=amt;
          retval=1;
          break;
     case 0L:
          if (asmuch || uptr->creds >= amt) {
               uptr->creds-=amt;
               retval=(uptr->creds >= 0L);
               if (uptr->creds <= 0L) {
                    uptr->creds=0L;
                    if (tabptr != NULL && tabptr->flags&NOCRED) {
                         tmpunm=othusn;
                         swtcls(uptr,sameas(uptr->curcls,uptr->prmcls),
                                tabptr->nxtcls[DCREDIT],1,0);
                         othusn=tmpunm;
                    }
                    if (pester && othusn != -1 && usrnum != -1) {
                         prf("");
                         outprf(usrnum);
                         setmbk(acnmb);
                         prfmlt(HOWBUY,chgmin,chgtime,company,addres1,addres2);
                         rstmbk();
                         injoth();
                         clrmlt();
                    }
               }
          }
          break;
     default:
          if (asmuch || (uptr->creds-amt) >= -tabptr->dbtlmt) {
               uptr->creds-=amt;
               retval=(uptr->creds >= -tabptr->dbtlmt);
               if (uptr->creds <= -tabptr->dbtlmt) {
                    if (tabptr->flags&HITLMT) {
                         if (tabptr->flags&REPDBT) {
                              repusr(uptr);
                         }
                         uptr->creds=0L;
                    }
                    else {
                         uptr->creds=-tabptr->dbtlmt;
                    }
                    if (tabptr->flags&DBTLMT) {
                         swtcls(uptr,sameas(uptr->curcls,uptr->prmcls),
                                tabptr->nxtcls[DCREDIT],1,0);
                    }
               }
          }
     }
     if (retval == 1 && othusn != -1) {
          if (!gen_haskey(syskey,othusn,&user[othusn]) && grpnum[othusn] != 0) {
               mdstats[user[othusn].state].creds+=amt;
               sv3.crdghr[grpnum[othusn]-1][dthour(now())]+=amt;
          }
     }
     return(retval);
}

long
hdedcrd(                           /* deduct credits, return num. deducted */
struct usracc *uptr,                    /* user # of user to deduct from   */
long amt,                               /* amount to deduct                */
int real,                               /* real creds only? (no debt=1)    */
int asmuch)                             /* take as much as possible? 1 or 0*/
{
     long origcred;

     origcred=uptr->creds;
     if (ldedcrd(uptr,amt,real,asmuch)) {
          return(origcred-uptr->creds); /* return number of credits taken */
     }
     return(0L);
}

int
tstcrd(                            /* does user have enough creds? (1 or 0)*/
long amt)                               /* amount of creds to test for     */
{
     return(ltstcrd(usaptr,amt,0));
}

int
rtstcrd(                           /* does user have enough REAL credits?  */
long amt)                               /* amount of creds to test for     */
{
     return(ltstcrd(usaptr,amt,1));
}

int
otstcrd(                           /* check if other user can spare creds  */
int unum,                               /* user # of user to deduct from   */
long amt,                               /* proposed amount to deduct       */
int real)                               /* real creds? (1=no debt or xmpt) */
{
     return(ltstcrd(uacoff(unum),amt,real));
}

int
ntstcrd(                           /* see if offline account has amt creds */
char *uid,                              /* userid of user to look at       */
long amt,                               /* proposed amount to deduct       */
int real)                               /* real creds? (1=no debt or xmpt) */
{
     setbtv(accbb);
     if (acqbtv(&acctmp,uid,0)) {
          rstbtv();
          return(ltstcrd(&acctmp,amt,real));
     }
     rstbtv();
     return(0);
}

int
gtstcrd(                           /* general test credits: online or off  */
char *uid,                              /* userid of user to look at       */
long amt,                               /* proposed amount to deduct       */
int real)                               /* real creds? (1=no debt or xmpt) */
{
     if (onsysn(uid,1)) {
          return(ltstcrd(othuap,amt,real));
     }
     return(ntstcrd(uid,amt,real));
}

int
ltstcrd(                           /* can user spare creds?  (low-level)   */
struct usracc *uptr,                    /* user account to look at         */
long amt,                               /* proposed amount to deduct       */
int real)                               /* real creds? (1=no debt or xmpt) */
{
     int retval=0;
     struct clstab *uclptr;

     if ((uclptr=fndcls(uptr->curcls)) == NULL) {
          return(0);
     }
     if (amt <= 0L || (!real && (uclptr->flags&CRDXMT))) {
          return(1);
     }
     switch (real ? 0L : uclptr->dbtlmt) {
     case -1L:
          retval=1;
          break;
     case 0L:
          if (uptr->creds >= amt) {
               retval=1;
          }
          break;
     default:
          if ((uptr->creds-amt) >= -uclptr->dbtlmt) {
               retval=1;
          }
     }
     return(retval);
}

void
dltcls(tabptr)                     /* delete an existing class             */
struct clstab *tabptr;                  /* pointer to class table entry    */
{
     int savnum;
     FILE *savmb;
     char kring[UIDSIZ];
     struct clstab *tmpptr;

     savmb=curmbk;
     savnum=usrnum;
     for (usrnum=0 ; usrnum < nterms ; usrnum++) {
          if (sameas(uacoff(usrnum)->curcls,tabptr->clname)) {
               delacct(uacoff(usrnum)->userid);
          }
     }
     curusr(savnum);
     setbtv(clsbb);
     geqbtv(NULL,tabptr->clname,0);
     delbtv();
     if (!(tabptr->flags&HASCRD && tabptr->flags&NOCRED)) {
          numcls--;
     }
     rstbtv();
     kring[0]=RINGID;
     strcpy(kring+1,tabptr->clname);
     dlkeys(kring);
     if (tabptr->next != NULL) {
          movmem(tmpptr=tabptr->next,tabptr,sizeof(struct clstab));
          free(tmpptr);
     }
     else {
          for (tmpptr=clshead ; tmpptr != NULL ; tmpptr=tmpptr->next) {
               if (tmpptr->next == tabptr) {
                    free(tmpptr->next);
                    tmpptr->next=tabptr=NULL;
                    break;
               }
          }
     }
     setmbk(savmb);
}

int
addcrd(keyuid,tckstg,real)    /* utility for posting credits to an account */
char *keyuid,*tckstg;
int real;
{
     int ison;

     if ((ison=crdusr(keyuid,tckstg,real,1)) >= 0) {
          if (real) {
               sv2.paidpst+=atol(tckstg);
          }
          else {
               sv2.freepst+=atol(tckstg);
          }
          shocst(spr("%s CREDITS POSTED",(real ? "PAID" : "FREE")),
                 "User-ID: %-29s Credits posted: %7s",keyuid,tckstg);
     }
     return(ison);
}

int
crdusr(keyuid,tckstg,real,affall) /* low-level utility for posting credits */
char *keyuid,*tckstg;
int real,affall;
{
     int ison;
     long ticks;

     setbtv(accbb);
     if (!acqbtv(&acctmp,keyuid,0)) {
          rstbtv();
          return(-1);
     }
     ison=onsysn(keyuid,1);
     if (ison) {
          accptr=othuap;
     }
     else if (onbbs(keyuid,1)) {
          accptr=uacoff(uisusn);
     }
     else {
          accptr=&acctmp;
     }
     if (accptr->flags&DELTAG) {
          rstbtv();
          return(-1);
     }
     ticks=atol(tckstg);
     accacct(accptr,-1);
     accptr->creds+=ticks;
     if (affall) {
          if ((accptr->totcreds+=ticks) < 0L) {
               accptr->totcreds=0;
          }
          if (real && (accptr->totpaid+=ticks) < 0L) {
               accptr->totpaid=0;
          }
     }
     accacct(accptr,1);
     if (accptr->creds > 0L && (clsptr=fndcls(accptr->curcls)) != NULL) {
          if (accptr->creds > 0L && (clsptr->flags&HASCRD)) {
               ison=0;
               swtcls(accptr,sameas(accptr->curcls,accptr->prmcls),
                      clsptr->nxtcls[DCREDIT],1,0);
          }
          else {
               updbtv(accptr);
          }
     }
     else {
          updbtv(accptr);
     }
     strcpy(keyuid,accptr->userid);
     rstbtv();
     put2scn(accptr);
     return(ison);
}

int
saycrd(tckstg,real)           /* notify creditee (if online) of credits    */
char *tckstg;
int real;
{
     setmbk(acnmb);
     prfmlt(real ? YOUCRD : YCRFRE,tckstg);
     rstmbk();
     return(injoth());
}

void
cpykey(dest,src,len)          /* format data (src) for Btrieve use (dest)  */
char *dest,*src;
int len;
{
     int dstlen;

     movmem(src,dest,len);
     *(dest+len-1)='\0';
     dstlen=strlen(dest);
     setmem(dest+dstlen,len-dstlen,0);
}

void
decevy(void)                  /* rtkick() to gobble credits of users online*/
{
     static int altbnf;

     setmbk(acnmb);
     for (decusn=0,decusp=user ; decusn < nterms ; decusn++,decusp++) {
          if (!(decusp->flags&BYEBYE)) {
               decuap=uacoff(decusn);
               deccst=lincst(decusn);
               (*decusr)();
               if ((altbnf&1) && decusp->pfnacc != 0) {
                    decusp->pfnacc--;
               }
          }
     }
     altbnf++;
     rtkick(15,decevy);
}

int
declog(void)                       /* check logon time limit               */
{                                  /* 1=staying online, 0=forced logoff    */
     return(decusp->usetmr++ < wtwait(lwtlog,hwtlog));
}

int
decsup(void)                       /* check signup time limit              */
{                                  /* 1=staying online, 0=forced logoff    */
     return(decusp->usetmr++ < wtwait(lwtsup,hwtsup));
}

int
dectdy(void)                       /* check today's time limit             */
{                                  /* -1=log off, 1=warn, 0=nothing        */
     long lim;

     lim=decusp->cltptr->limday;
     if ((decuap->timtdy+=15L)/60L >= lim && lim != -1) {
          if (decusp->cltptr->flags&KCKOFF) {
               if (!(decusp->flags&NOZAP)) {
                    return(-1);
               }
          }
          else {
               swtcls(decuap,0,decusp->cltptr->nxtcls[DOUTTIM],0,0);
          }
     }
     else if (!(decusp->flags&ONEMIN) && lim != -1
              && decuap->timtdy/60L >= lim-1
              && decusp->cltptr->flags&KCKOFF) {
          decusp->flags|=ONEMIN;
          return(1);
     }
     return(0);
}

int
deccal(void)                       /* check per/call time limit            */
{                                  /* -1=log off, 1=warn, 0=nothing        */
     long lim;

     lim=decusp->cltptr->limcal;
     if ((decusp->minut4>>2) >= lim && lim != -1) {
          if (!(decusp->flags&NOZAP)) {
               return(-1);
          }
     }
     else if (!(decusp->flags&ONEMIN) && lim != -1
              && (decusp->minut4>>2) >= lim-1) {
          decusp->flags|=ONEMIN;
          return(1);
     }
     return(0);
}

void
dec15s(void)                       /* count out 15 sec of statistics       */
{
     decusp->cltptr->seconds+=15L;
     if (!gen_haskey(syskey,decusn,decusp) && grpnum[decusn] != 0) {
          mdstats[decusp->state].seconds+=15L;
          sv3.secghr[grpnum[decusn]-1][dthour(now())]+=15L;
     }
}

void
deccrd(                            /* decrement credits for 15 sec online  */
long surdsc)                       /* +surcharge / -discount for 15 sec    */
{
     deccst+=(decusp->crdrat>>2)+((decusp->minut4&3) < (decusp->crdrat&3));
     deccst+=surdsc;
     usrnum=-1;
     odedcrd(decusn,deccst,0,1);
}

void
decdft(void)                       /* 15sec per-channel handler            */
{                                  /* default (*decusr)() vector           */
     if (decusp->class != VACANT) {
          decusp->minut4++;
     }
     switch (decusp->class) {
     case VACANT:
          break;
     case ONLINE:
          if (!declog()) {
               curusr(decusn);
               byenow(SEEYEZ);
          }
          break;
     case BBSPRV:
          break;
     case SUPIPG:
          if (!decsup()) {
               curusr(decusn);
               byenow(SEEYEZ);
          }
          break;
     case SUPLON:
     case SUPLOF:
     case ACTUSR:
          switch (dectdy()) {
          case -1:
               curusr(decusn);
               byenow(OUTTDY);
               break;
          case 1:
               prfmlt(ALMTDY);
               othusn=decusn;
               injoth();
               clrmlt();
               break;
          }
          switch (deccal()) {
          case -1:
               curusr(decusn);
               byenow(OUTOFT);
               break;
          case 1:
               prfmlt(ALMOFT);
               othusn=decusn;
               injoth();
               clrmlt();
               break;
          }
          dec15s();
          deccrd(0L);
          break;
     }
}

void
chkliu(void)                       /* rtkick()'d checker of lines in use   */
{
     int hr,min;
     static int nsamps=0,totliu=0;

     nsamps++;
     totliu+=nliniu();
     if ((min=dtmin(now())) == 0 || min == 30) {
          min=(min == 30 ? 1 : 0);
          if ((hr=dthour(now())) == 0) {
               sv2.nliniu[min ? 0 : 47]+=(totliu+nsamps/2)/nsamps;
          }
          else {
               sv2.nliniu[hr*2+min-1]+=(totliu+nsamps/2)/nsamps;
          }
          nsamps=totliu=0;
     }
     rtkick(61,chkliu);
}

void
updtrk(void)                       /* rtkick()'d updating of dtrack        */
{
     extern int mcuhr;

     if (sv2.lstzer == 0) {
          dtrack=24;
     }
     else {
          if ((dtrack=(cofdat(today())-cofdat(sv2.lstzer))*24) == 0) {
               dtrack=24;
          }
          else if (mcuhr > dthour(now())) {
               dtrack+=(23-mcuhr);
               dtrack+=dthour(now());
          }
          else {
               dtrack+=(dthour(now())-mcuhr);
          }
     }
     rtkick(1800,updtrk);
}

void
savvbl(void)                       /* rtkick()'d system variable saver     */
{
     initask(svtask);
}

STATIC void
svtask(                            /* system variable saver background task*/
int taskid)
{
     static int countr=0;

     setbtv(svbb);
     switch (countr++) {
     case 0:
          geqbtv(NULL,"key",0);
          upvbtv(&sv,sizeof(struct sysvbl));
          break;
     case 1:
          geqbtv(NULL,"ky2",0);
          upvbtv(&sv2,sizeof(struct sysvb2));
          break;
     default:
          geqbtv(NULL,"ky3",0);
          upvbtv(&sv3,sizeof(struct sysvb3));
          countr=0;
          mfytask(taskid,NULL);
          rtkick(svrate,savvbl);
     }
     rstbtv();
}

int
imbump(logon)            /* immediate bump?  logon or post-sign-up cases    */
int logon;
{
     int limcal,limday;

     clsptr=usrptr->cltptr;
     if (((clsptr->flags&NOCRED) && usaptr->creds <= 0L)
         || ((clsptr->flags&HASCRD) && usaptr->creds > 0L)) {
          swtcls(usaptr,sameas(usaptr->curcls,usaptr->prmcls),
                 clsptr->nxtcls[DCREDIT],1,0);
          if (usaptr->flags&DELTAG) {
               return(1);
          }
     }
     limcal=usrptr->cltptr->limcal;
     limday=usrptr->cltptr->limday;
     if (limcal == 0 || (limday != -1 && ((usaptr->timtdy+30)/60) >= limday
         && usrptr->cltptr->flags&KCKOFF)) {
          setmbk(acnmb);
          byenow(logon ? ((!limcal || !limday) ? IMMEDL : NOTIME) : IMMEDB);
          rstmbk();
          return(1);
     }
     return(0);
}

int
wtwait(lomin,himin)      /* interpolate between time limits for lo/hi usage */
int lomin,himin;                            /* returns time in 15 sec units */
{
     return(((max(nliniu(),1)-1)*(himin-lomin)<<2)/max(nterms-1,1)+(lomin<<2));
}

int
nliniu(void)                  /* returns number of system lines "in use"   */
{
     int othusn,retval;
     struct user *othusp;

     retval=0;
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          if (othusp->class != VACANT) {
               retval++;
          }
     }
     return(retval);
}

void
updacc(void)                  /* update a user's account utility           */
{
     setbtv(accbb);
     geqbtv(NULL,usaptr->userid,0);
     updbtv(usaptr);
     rstbtv();
}

int
accmcu(void)                  /* account midnight cleanup routine          */
{
     unsigned numact;
     struct usracc mcuact;
     struct clstab *mclptr;
     int mcudys,ctoday,tday,bomonth;

     usrnum=-2;
     if (ddyear(tday=today()) == 1980) {
          shocst("CLEANUP NOT ATTEMPTED","(DATE NOT SET:  %s)",ncdate(tday));
          return(0);
     }
     inmcu=1;
     ctoday=cofdat(tday);
     mcudys=sv2.lastmcu == 0 ? 1 : (ctoday-cofdat(sv2.lastmcu));
     bomonth=(ddday(tday) == 1);
     numact=sv2.numact;
     sv2.numact=sv2.numfem=sv2.numcor=sv2.numans=0;
     setmem(sv2.matrix,sizeof(sv2.matrix),0);
     if (clshead != NULL) {
          for (mclptr=clshead ; mclptr != NULL ; mclptr=mclptr->next) {
               mclptr->users=0;
          }
     }
     setbtv(accbb);
     if (qlobtv(0)) {
          gcrbtv(NULL,0);
          do {
               movmem(accbb->data,&mcuact,sizeof(struct usracc));
               accacct(&mcuact,1);
               mcuact.timtdy=0L;
               if (!sameas(mcuact.curcls,mcuact.prmcls)) {
                    strcpy(mcuact.curcls,mcuact.prmcls);
               }
               mclptr=fndcls(mcuact.curcls);
               if (mclptr != NULL && !(mcuact.flags&DELTAG)) {
                    mclptr->users++;
                    if (((mclptr->flags&NUMDAY) && (mcuact.fgvdys+=mcudys)
                        >= mclptr->fgvday) || (mcudys != 0 && daytoday() == 1
                        && (mclptr->flags&MONDAY))
                        || (mcudys != 0 && bomonth && (mclptr->flags&FSTMTH))) {
                         mcuact.fgvdys=0;
                         if (mcuact.creds < 0L) {
                              if (mclptr->flags&REPDBT) {
                                   repusr(&mcuact);
                              }
                              mcuact.creds=0L;
                         }
                    }
                    if ((mclptr->flags&DAYEXP) && mcuact.daystt == 0) {
                         mcuact.daystt=mclptr->dftday;
                    }
                    if ((mclptr->flags&DAYEXP) && (mcuact.daystt < mcudys
                        || (mcuact.daystt-=mcudys) == 0)) {
                         mcuact.daystt=0;
                         swtcls(&mcuact,1,mclptr->nxtcls[DEXPIRE],2,0);
                    }
                    else if ((mclptr->flags&IDLEXP)
                        && ctoday-cofdat(mcuact.usedat) >= mclptr->idlday) {
                         swtcls(&mcuact,1,mclptr->nxtcls[DLOAFER],4,0);
                    }
                    else {
                         updbtv(&mcuact);
                    }
               }
               else {
                    if (mclptr != NULL) {
                         mclptr->users++;
                    }
                    lowdel(mcuact.userid);
               }
               setbtv(accbb);
          } while (qnxbtv());
     }
     sv2.lastmcu=today();
     inmcu=0;
     usetdy(numact);
     return(1);
}

STATIC
void
usetdy(acsb4d)                /* find and report today's use (hrs & creds) */
unsigned acsb4d;                   /* number of accounts before deletions  */
{
     int i,j;
     long totsecs=0L,totcreds=0L;
     static struct sysvbl osv;
     static struct sysvb2 osv2;
     static struct sysvb3 osv3;

     setbtv(svbb);
     if (!acqbtv(&osv,"old",0)) {
          setmem(&osv,sizeof(struct sysvbl),0);
          setmem(&osv2,sizeof(struct sysvb2),0);
          setmem(&osv3,sizeof(struct sysvb3),0);
     }
     else {
          geqbtv(&osv2,"ol2",0);
          geqbtv(&osv3,"ol3",0);
          if (sv2.lstzer != osv2.lstzer) {
               setmem(osv3.secghr,(NGROUPS-1)*24*sizeof(long),0);
               setmem(osv3.crdghr,(NGROUPS-1)*24*sizeof(long),0);
          }
     }
     for (i=0 ; i < NGROUPS-1 ; i++) {
          for (j=0 ; j < 24 ; j++) {
               totsecs+=(sv3.secghr[i][j]-osv3.secghr[i][j]);
               totcreds+=(sv3.crdghr[i][j]-osv3.crdghr[i][j]);
          }
     }
     shocst("SYSTEM USAGE SINCE LAST CLEANUP","%s%s",
            spr("Calls: %-6ldSignups: %-5u",
                sv2.totcalls-osv2.totcalls,acsb4d-osv2.numact),
            spr("Hrs used: %-5ldCreds used: %ld",
                 (totsecs+1800L)/3600L,totcreds));
     movmem(&sv,&osv,sizeof(struct sysvbl));
     movmem(&sv2,&osv2,sizeof(struct sysvb2));
     movmem(&sv3,&osv3,sizeof(struct sysvb3));
     strcpy(osv.key,"old");
     strcpy(osv2.ky2,"ol2");
     strcpy(osv3.ky3,"ol3");
     if (!acqbtv(NULL,"old",0)) {
          invbtv(&osv,sizeof(struct sysvbl));
          invbtv(&osv2,sizeof(struct sysvb2));
          invbtv(&osv3,sizeof(struct sysvb3));
     }
     else {
          upvbtv(&osv,sizeof(struct sysvbl));
          geqbtv(NULL,"ol2",0);
          upvbtv(&osv2,sizeof(struct sysvb2));
          geqbtv(NULL,"ol3",0);
          upvbtv(&osv3,sizeof(struct sysvb3));
     }
     rstbtv();
}

void
accacct(accptr,plusor)        /* calculate system statistics for accounts  */
struct usracc *accptr;
int plusor;
{
     int i;
     static int agebra[NAGEBK]={20,30,40,50,9999};

     sv2.numact+=plusor;
     if (accptr->sex != 'M') {
          sv2.numfem+=plusor;
     }
     if (accptr->usrad1[0] != '\0') {
          sv2.numcor+=plusor;
     }
     if (accptr->ansifl&ANSON) {
          sv2.numans+=plusor;
     }
     for (i=0 ; i < NAGEBK ; i++) {
          if (accptr->age < agebra[i]) {
               sv2.matrix[accptr->systyp][i]+=plusor;
               break;
          }
     }
}

int
delacct(userid)               /* delete an account from system routine     */
char *userid;
{
     int savusn;

     if (inmcu) {
          return(lowdel(userid));
     }
     else {
          setbtv(accbb);
          if (!acqbtv(&acctmp,userid,0) || (acctmp.flags&UNDAXS)) {
               return(-1);
          }
          acctmp.flags|=DELTAG;
          updbtv(&acctmp);
          rstbtv();
          savusn=usrnum;
          usrnum=-1;
          if (onbbs(userid,1)) {
               uacoff(uisusn)->flags|=DELTAG;
               kilchn(uisusn);
          }
          usrnum=savusn;
     }
     return(0);
}

STATIC
int
lowdel(userid)                /* low-level delete user function (MCU only) */
char *userid;                      /* user-id to delete                    */
{
     int i;
     void (*rouptr)();

     setbtv(accbb);
     if (!acqbtv(&acctmp,userid,0) || (acctmp.flags&UNDAXS)) {
          return(-1);
     }
     delbtv();
     delxrf(acctmp.userid);
     if ((clsptr=fndcls(acctmp.curcls)) != NULL) {
          clsptr->users--;
     }
     accacct(&acctmp,-1);
     for (i=1 ; i < nmods ; i++) {
          if ((rouptr=module[i]->dlarou) != NULL) {
               (*rouptr)(userid);
          }
     }
     dlkeys(userid);
     delgen(userid);
     shocst("USER ACCOUNT DELETED","User-ID: %-29s (Had %ld credits)",
            userid,acctmp.creds);
     rstbtv();
     return(0);
}

int
kiluid(userid)                /* "kill" the User-ID just by setting flag   */
char *userid;
{
     int savusn;

     setbtv(accbb);
     if (!acqbtv(&acctmp,userid,0)) {
          return(-1);
     }
     acctmp.flags|=SUSPEN;
     updbtv(&acctmp);
     rstbtv();
     savusn=usrnum;
     usrnum=-1;
     if (onbbs(userid,1)) {
          uacoff(uisusn)->flags|=SUSPEN;
          kilchn(uisusn);
     }
     usrnum=savusn;
     shocst("USER ACCOUNT SUSPENDED","Suspended User-ID: %-29s",userid);
     return(0);
}

void
howbuy(void)                       /* emit the "how to buy creds" msg      */
{
     if (pester) {
          setmbk(acnmb);
          prfmsg(HOWBUY,chgmin,chgtime,company,addres1,addres2);
          rstmbk();
     }
}

STATIC
void
repusr(uacc)                       /* add user to debt report              */
struct usracc *uacc;                    /* ptr to user account to report   */
{
     if (repfp != NULL) {
          fprintf(repfp,"%-34s %ld\n",uacc->userid,-uacc->creds);
     }
}

STATIC
void
clssta(void)                       /* close down the statistic collector   */
{
     if (gotsv) {
          setbtv(svbb);
          geqbtv(NULL,"key",0);
          upvbtv(&sv,sizeof(struct sysvbl));
          geqbtv(NULL,"ky2",0);
          upvbtv(&sv2,sizeof(struct sysvb2));
          geqbtv(NULL,"ky3",0);
          upvbtv(&sv3,sizeof(struct sysvb3));
          clsbtv(svbb);
          gotsv=0;
     }
}

void
clsacc(void)                       /* close account-related files for shutd*/
{
     clscls();
     clssta();
     clsbtv(accbb);
     clsmsg(acnmb);
     if (repfp != NULL) {
          fclose(repfp);
     }
}

STATIC
void
clscls(void)                       /* save class data back to disk         */
{
     if (clshead != NULL) {
          setbtv(clsbb);
          for (clsptr=clshead ; clsptr != NULL ; clsptr=clsptr->next) {
               geqbtv(&clsrec,clsptr->clname,0);
               movmem(clsptr,&clsrec,
                      sizeof(struct clstab)-sizeof(struct clstab *));
               updbtv(&clsrec);
          }
          clsbtv(clsbb);
     }
}

STATIC void
pbf2txt(void)                      /* xfer prfbuf to message text area     */
{
     char *cp;

     stpans(prfbuf);
     if (strlen(prfbuf) >= msgsiz) {
          prfbuf[msgsiz-1]='\0';
     }
     for (cp=prfbuf ; *cp != '\0' ; cp++) {
          if (*cp == '\n') {
               *cp='\r';
          }
          else if (*cp == '') {
               *cp=' ';
          }
     }
     strcpy(mp->text,prfbuf);
     clrmlt();
}
