/***************************************************************************
 *                                                                         *
 *   UINFED.C                                                              *
 *                                                                         *
 *   Copyright (C) 1987-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Major BBS user-info editor.                               *
 *                                                                         *
 *                                            - T. Stryker 7/13/86         *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "majorbbs.h"
#include "usracc.h"
#include "signup.h"
#include "btvstf.h"
#include "portable.h"
 
int iniuin(),uinfed(),uinlon(),dfsthn();
 
#define UEDSTT      12        /* system info requesting state         */
struct module module12={      /* module interface block               */
     '*',                     /*    main menu select character (config'able) */
     "",                      /*    description for main menu  (config'able) */
     iniuin,                  /*    system initialization routine     */
     uinlon,                  /*    user logon supplemental routine   */
     uinfed,                  /*    input routine if selected         */
     dfsthn,                  /*    status-input routine if selected  */
     NULL,                    /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     NULL                     /*    finish-up (sys shutdown) routine  */
};
 
#define MAXTKC 100000000L     /* maximum char count of tick xfer request   */
 
char *sysstg[]={              /* strings corresponding to sys type codes   */
     "(nonstandard)",
     "IBM PC or compatible",
     "Apple Macintosh",
     "Apple other than Mac",
     "Commodore Amiga",
     "Atari",
     "Radio Shack",
     "CP/M system"
};
 
char *ansstg[]= {             /* strings corresponding to ANSI settings    */
     "non-ANSI","ANSI","ANSI OFF","ANSI ON"
};
 
struct xfinfo {               /* credit-transfer info    */
     char tranfid[UIDSIZ];    /*   transferee's User-ID  */
     long tikreq;             /*   amount of the xfer    */
} *xfidat;
 
struct usracc acctmp,*accptr; /* user account temporary holding area & ptr */
int newstt;                   /* new sub-state code                        */
 
extern
BTVFILE *accbb;               /* user accounts btrieve data file           */
extern
FILE *supmb;                  /* uses the signup module's message file     */
 
/*--- OPTIONS FROM SIGNUP.MSG ---*/
 
long mincxf;                  /* minimum number of credits per xfer oper   */
 
iniuin()                           /* initialize user info editor module   */
{
     int n;
     long lngopt();
 
     xfidat=(struct xfinfo *)alcmem(n=nterms*sizeof(struct xfinfo));
     setmem(xfidat,n,0);
     setmbk(supmb);
     mincxf=lngopt(MINCXF,0L,1000000000L);
     inimid(UEDSTT,UEDSEL,UEDMNU);
}
 
uinlon()                           /* supplement log on; shows credits     */
{
     if (usaptr->tckavl != 0) {
          setmbk(supmb);
          prfmsg(LIVLON,city,ltoa(usaptr->tckavl));
          outprf(usrnum);
     }
}
 
uinfed()                           /* user info editor main module         */
{
     int c,intguy;
     static int prmts[]={
          NEWUSN,NEWAD1,NEWAD2,NEWAD3,NEWPHO,
          NEWSYT,NEWSWD,NEWSLN,NEWAGE,NEWSEX,NEWPSW,CREDTR
     };
 
     setmbk(supmb);
     newstt=usrptr->substt;
     if (margc == 0) {
          prfmsg(newstt);
     }
     else if (margc == 1 && sameas(margv[0],"x")) {
          return(0);
     }
     else {
          do {
               bgncnc();
               if (margc == 1 && sameas(margv[0],"?")) {
                    newstt=0;
               }
               switch (newstt) {
               case 0:
                    cncchr();
                    usrptr->flags&=~X2MAIN;
                    shwusr(usaptr,0);
                    prfmsg(newstt=CHGORX);
                    break;
               case CHGORX:
                    if ((c=cncint()) >= 1 && c <= 12) {
                         if (c == 12) {
                              if (usaptr->tckavl <= mincxf) {
                                   prfmsg(NOCRDX,ltoa(mincxf),chgmin,chgtime,
                                                 company,addres1,addres2);
                                   cncall();
                                   go2mai();
                              }
                              else if (usaptr->tckpai == 0) {
                                   prfmsg(NOCRFX,chgmin,chgtime,
                                                 company,addres1,addres2);
                                   cncall();
                                   go2mai();
                              }
                              else {
                                   prfmsg(newstt=CREDTR);
                              }
                         }
                         else {
                              prfmsg(newstt=prmts[c-1]);
                         }
                    }
                    else {
                         prfmsg(ONLERR2);
                         cncall();
                         go2mai();
                    }
                    break;
               case NEWUSN:
                    if (uinfok(NEWUSN,5,NADSIZ,usaptr->usrnam)) {
                         go2mai();
                    }
                    cncall();
                    break;
               case NEWAD1:
                    accacct(usaptr,-1);
                    if (uinfok(NEWAD1,0,NADSIZ,usaptr->usrad1)) {
                         go2mai();
                    }
                    accacct(usaptr,1);
                    cncall();
                    break;
               case NEWAD2:
                    if (uinfok(NEWAD2,5,NADSIZ,usaptr->usrad2)) {
                         go2mai();
                    }
                    cncall();
                    break;
               case NEWAD3:
                    if (uinfok(NEWAD3,5,NADSIZ,usaptr->usrad3)) {
                         go2mai();
                    }
                    cncall();
                    break;
               case NEWPHO:
                    if (uinfok(NEWPHO,7,PHOSIZ,usaptr->usrpho)) {
                         go2mai();
                    }
                    cncall();
                    break;
               case NEWSYT:
                    accacct(usaptr,-1);
                    if (unumok(NEWSYT,0,7,&intguy)) {
                         usaptr->systyp=intguy;
                         prfmsg(newstt=NEWANS);
                    }
                    accacct(usaptr,1);
                    break;
               case NEWANS:
                    accacct(usaptr,-1);
                    if (unumok(NEWANS,1,3,&intguy)) {
                         switch (intguy) {
                         case 1:
                              usaptr->ansifl=ANSMAN;
                              break;
                         case 2:
                              usaptr->ansifl=ANSMAN+ANSON;
                              break;
                         case 3:
                              usaptr->ansifl&=~ANSMAN;
                              break;
                         }
                         stansi();
                         go2mai();
                    }
                    accacct(usaptr,1);
                    cncall();
                    break;
               case NEWSWD:
                    if (unumok(NEWSWD,20,136,&intguy)) {
                         btutsw(usrnum,usaptr->scnwid=intguy);
                         go2mai();
                    }
                    cncall();
                    break;
               case NEWSLN:
                    if (morcnc() == 'C') {
                         usaptr->scnlen=CTNUOS;
                    }
                    else {
                         if (!unumok(NEWSLN,3,254,&intguy)) {
                              cncall();
                              break;
                         }
                         usaptr->scnlen=intguy;
                    }
                    cncall();
                    rstrxf();
                    go2mai();
                    break;
               case NEWAGE:
                    accacct(usaptr,-1);
                    if (unumok(NEWAGE,5,99,&usaptr->age)) {
                         go2mai();
                    }
                    accacct(usaptr,1);
                    cncall();
                    break;
               case NEWSEX:
                    accacct(usaptr,-1);
                    if (usexok()) {
                         go2mai();
                    }
                    accacct(usaptr,1);
                    cncall();
                    break;
               case NEWPSW:
                    if (uinfok(GPSWORD,1,PSWSIZ,usaptr->psword)) {
                         prfmsg(PSWWRN);
                         go2mai();
                    }
                    cncall();
                    break;
               case CREDTR:
                    scredtr();
                    break;
               case UIDEN:
                    suiden();
                    break;
               case QUERYN:
                    squeryn();
                    break;
               }
          } while (!endcnc());
     }
     outprf(usrnum);
     usrptr->substt=newstt;
     return(1);
}
 
static
go2mai()                           /* go back to main unifed menu, or exit */
{
     condex();
     prfmsg(newstt=CHGORX);
}
 
scredtr()                          /* get number of credits to transfer    */
{
     long num,numeok();
 
     if (usaptr->tckavl <= mincxf) {
          prfmsg(RANOUT);
          cncall();
          go2mai();
          return;
     }
     if ((num=numeok()) == -1) {
          prfmsg(NUMBAD,ltoa(mincxf),ltoa(usaptr->tckavl-1));
          prfmsg(CREDTR);
          cncall();
          return;
     }
     if ((xfidat[usrnum].tikreq=num) >= usaptr->tckavl) {
          prfmsg(NOTENO,ltoa(usaptr->tckavl-1));
          prfmsg(CREDTR);
          cncall();
          return;
     }
     prfmsg(newstt=UIDEN);
}
 
suiden()                           /* get userid to transfer credits to    */
{
     char *uidptr;
 
     if (usaptr->tckavl <= mincxf) {
          prfmsg(RANOUT);
          cncall();
          go2mai();
          return;
     }
     setbtv(accbb);
     movmem(uidptr=cncuid(),xfidat[usrnum].tranfid,UIDSIZ);
     if (sameas(usaptr->userid,uidptr)) {
          prfmsg(NOTSELF);
          prfmsg(UIDEN);
          cncall();
          return;
     }
     if (!acqbtv(&acctmp,uidptr,0)) {
          prfmsg(UIDBAD);
          prfmsg(UIDEN);
          cncall();
          return;
     }
     if (acctmp.tckpai == 0) {
          prfmsg(WRNNOP,input,input);
     }
     prfmsg(QYNPRE,ltoa(xfidat[usrnum].tikreq),usaptr->userid,uidptr);
     prfmsg(newstt=QUERYN);
}
 
squeryn()                          /* verify transfer of credits           */
{
     int ison;
     long treq;
     char *tfid;
 
     if (usaptr->tckavl <= mincxf) {
          prfmsg(RANOUT);
          cncall();
          go2mai();
          return;
     }
     if (cncchr() == 'Y') {
          treq=xfidat[usrnum].tikreq;
          if (usaptr->tckavl <= treq) {
               treq=usaptr->tckavl-1;
               prfmsg(NOENOT,ltoa(treq));
          }
          tfid=xfidat[usrnum].tranfid;
          if ((ison=crdusr(tfid,ltoa(treq),0,0)) < 0) {
               prfmsg(ACCDEL,tfid);
               cncall();
               go2mai();
               return;
          }
          usaptr->tckavl-=treq;
          prfmsg(DATATR,ltoa(treq),usaptr->userid,tfid);
          outprf(usrnum);
          if (ison) {
               prfmsg(SENDUS,usaptr->userid,ltoa(treq));
               if (injoth()) {
                    prfmsg(NOTICE,tfid);
               }
          }
          shocst(1,"XF %-9s%9s->%-9s",ltoa(treq),usaptr->userid,tfid);
     }
     else {
          prfmsg(CDXABO);
     }
     cncall();
     go2mai();
}
 
shwusr(usaptr,sysop)               /* display's a user's account info      */
struct usracc *usaptr;
int sysop;
{
     FILE *savmb;
     extern FILE *curmbk;
 
     savmb=curmbk;
     setmbk(supmb);
     prfmsg((sysop ? SOPINFN : UINFENI),usaptr->userid,
                  usaptr->credat,
                  usaptr->usedat,
                  usaptr->usrnam,
                  usaptr->usrad1,
                  usaptr->usrad2,
                  usaptr->usrad3,
                  usaptr->usrpho,
                  sysstg[usaptr->systyp],ansstg[usaptr->ansifl],
                  usaptr->scnwid,
                  usaptr->scnlen == CTNUOS ? "(continuous)"
                                           : spr("%d",usaptr->scnlen),
                  usaptr->age,
                  usaptr->sex,
                  (sysop ? usaptr->psword :
                           "<not displayed, for security reasons>"),
                  ltoa(usaptr->tckavl));
     setmbk(savmb);
}
 
long numeok()                      /* is number ok? (for credits to xfer)  */
{
     long retval;
 
     if ((retval=cnclon()) < mincxf) {
          return(-1);
     }
     if (retval > MAXTKC) {
          return(-1);
     }
     return(retval);
}
