/***************************************************************************
 *                                                                         *
 *   TYPULBL.C                                                             *
 *                                                                         *
 *   Copyright (C) 1986, 1987 by GALACTICOMM, Inc.  All Rights Reserved.   *
 *                                                                         *
 *   This is the account file formatter for mailing label generation.      *
 *                                                                         *
 *                                            - T. Stryker 2/5/87          *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "setjmp.h"
#include "btvstf.h"
#include "majorbbs.h"
#include "usracc.h"
#include "portable.h"
#include "fkcode.h"
 
extern jmp_buf disaster;      /* master error-recovery longjmp save block  */
 
main(argc,argv)
int argc;
char *argv[];
{
     BTVFILE *fp;
     struct usracc acct;
     char unam[120],uad1[120],uad2[120],uad3[120];
     static char *filnam={"usracc.dat"};
     int startm=1,startd=1,starty=80;
     int cremon,creday,creyar;
     static FILE *outf=stdout;
     static int pagbrk=0,line=-1;
     static char outnam[129]={""};
     static char repnam[]={"User Mailing Labels"};
     char inpbuf[80];
     char c;
     int ziponl;
 
     fprintf(stderr,"%s for The Major BBS\n",repnam);
     fprintf(stderr,"(C) Copyright 1988, Galacticomm Inc.\n\n");
     if (setjmp(ADDR_OFdisaster)) {
          exit(1);
     }
     if (argc > 1 && strcmp(argv[1],"?") == 0) {
          fprintf(stderr,"Would you like to produce labels only for new users?\n");
          fprintf(stderr,"If so, enter the starting date like \"MM/DD/YY\".\n");
          fprintf(stderr,"Or just hit Enter to include ALL users.\n\n");
          do {
               fprintf(stderr,"Starting date:  ");
               gets(inpbuf);
               if (inpbuf[0] == '\0') {
                    startm=startd=1;
                    starty=80;
                    break;
               }
          } while (sscanf(inpbuf,"%d/%d/%d",&startm,&startd,&starty) != 3);
          fprintf(stderr,"\n\nWould you like to produce labels only for users");
          fprintf(stderr,"\nwith valid U.S.A. ZIP codes (enter NO to produce");
          fprintf(stderr,"\nlabels for ALL users, with or without ZIP codes)...? ");
          while (1) {
               gets(inpbuf);
               switch (inpbuf[0]) {
               case 'y':
               case 'Y':
                    ziponl=1;
                    break;
               case 'n':
               case 'N':
                    ziponl=0;
                    break;
               default:
                    fprintf(stderr,"Produce ZIP-coded labels ONLY (Y/N)? ");
                    continue;
               }
               break;
          }
          fprintf(stderr,"\n\nWhere do you want to send the %s?\n",repnam);
          fprintf(stderr,"\n");
          fprintf(stderr,"   (1) to your Screen\n");
          fprintf(stderr,"   (2) to your Printer\n");
          fprintf(stderr,"   (3) to a Disk File\n");
          fprintf(stderr,"\n");
          fprintf(stderr,"Please choose a number (or 0 to exit):  ");
          while (1) {
               switch (getchc()) {
               case F1:
               case '1':
                    pagbrk=22;
                    fprintf(stderr,"1\n\n");
                    break;
               case F2:
               case '2':
                    strcpy(outnam,"PRN");
                    fprintf(stderr,"2\n\nPrinting the %s...",repnam);
                    break;
               case F3:
               case '3':
                    fprintf(stderr,"3\nFile name:  ");
                    scanf("%s",outnam);
                    fprintf(stderr,"\nWriting the %s to \"%s\"...",repnam,outnam);
                    break;
               case F10:
               case '0':
                    fprintf(stderr,"\n");
                    exit(0);
               default:
                    continue;
               }
               break;
          }
     }
     else if (argc >= 2) {
          sscanf(argv[1],"%d/%d/%d",&startm,&startd,&starty);
     }
     if (outnam[0] != '\0') {
          if ((outf=fopen(outnam,FOPWA)) == NULL) {
               catastro("CANNOT OPEN OUTPUT FILE \"%s\"",outnam);
          }
     }
     fp=opnbtv(filnam,sizeof(struct usracc));
     setbtv(fp);
     if (!qlobtv(0)) {
          catastro("User account file is empty!");
     }
     do {
          gcrbtv(&acct,0);
          cremon=creday=creyar=0;
          sscanf(acct.credat,"%d/%d/%d",&cremon,&creday,&creyar);
          if (creyar > starty ||
             (creyar == starty && (cremon > startm ||
                                  (cremon == startm && creday >= startd)))) {
               refmt(acct.usrnam,unam);
               refmt(acct.usrad1,uad1);
               refmt(acct.usrad2,uad2);
               refmt(acct.usrad3,uad3);
               if (cisazp(uad3) || !ziponl) {
                    if (pagbrk > 0 && (line+=6) >= pagbrk) {
                         fprintf(stderr,"<< hit any key to continue >>");
                         getchc();
                         fprintf(stderr,"\n\n");
                         line=0;
                    }
                    if (alblank(uad1)) {
                         fprintf(outf,"%-40s%s\n%s\n%s\n\n\n\n",unam,
                              acct.userid,
                              uad2,uad3);
                    }
                    else {
                         fprintf(outf,"%-40s%s\n%s\n%s\n%s\n\n\n",unam,
                              acct.userid,
                              uad1,
                              uad2,uad3);
                    }
               }
          }
     } while (qnxbtv());
     clsbtv(fp);
     fclose(outf);
     fprintf(stderr,"End of report.\n");
     exit(0);
}
 
cisazp(stg)
char *stg;
{
     if (pcmtch(stg,"\5\5\5\2\2\2\2\2")) {
          if (pcmtch(stg,"\5\5\5, \2\2\2\2\2")) {
               movmem(stg+strlen(stg)-6,stg+strlen(stg)-7,7);
          }
          if (pcmtch(stg,"\5\5\5 \1\1 \2\2\2\2\2")) {
               *(stg+strlen(stg)-7)=toupper(*(stg+strlen(stg)-7));
          }
          return(1);
     }
     if (pcmtch(stg,"\5\5\5\2\2\2\2\2-\2\2\2\2")) {
          if (pcmtch(stg,"\5\5\5, \2\2\2\2\2-\2\2\2\2")) {
               movmem(stg+strlen(stg)-11,stg+strlen(stg)-12,12);
          }
          if (pcmtch(stg,"\5\5\5 \1\1 \2\2\2\2\2-\2\2\2\2")) {
               *(stg+strlen(stg)-12)=toupper(*(stg+strlen(stg)-12));
          }
          return(1);
     }
     return(0);
}
 
pcmtch(input,picstg)
char *input,*picstg;
{
     char c,pc;
     char *lanypc=NULL,*lanyin;
 
     while ((c=*input++) != '\0') {
          if ((pc=*picstg++) == '\5') {
               while ((pc=*(picstg+=2)) == '\5') {
                    picstg+=1;
               }
               while (!cmtch(c,pc)) {
                    if (c == '\0') {
                         return(0);
                    }
                    c=*input++;
               }
               lanypc=picstg-3;
               lanyin=input;
               input-=1;
          }
          else {
               if (!cmtch(c,pc)) {
                    if (lanypc != NULL) {
                         picstg=lanypc;
                         input=lanyin;
                    }
                    else {
                         return(0);
                    }
               }
          }
     }
     while (*picstg == '\5') {
          picstg+=3;
     }
     return(*picstg == '\0');
}
 
cmtch(c,pc)
char c,pc;
{
     switch (pc) {
     case '\1':                       /* alpha */
          return(isalpha(c));
     case '\2':                       /* numeric */
          return(isdigit(c));
     case '\3':                       /* plus-or-minus */
          return(c == '+' || c == '-' || c == ' ');
     case '\4':                       /* any-char */
          return(1);
     default:
          return(c == pc);
     }
}
 
efflen(stg)
char *stg;
{
     int i,len;
 
     for (i=len=0 ; *stg != '\0' ; ) {
          i+=1;
          if (*stg++ != ' ') {
               len=i;
          }
     }
     return(len);
}
 
refmt(stg,rts)
char *stg,*rts;
{
     int alpha1,c;
     char *inistg;
 
     inistg=stg;
     *(stg+efflen(stg))='\0';
     alpha1=1;
     for ( ; *stg != '\0' ; stg++) {
          if (isalpha(*stg) || isdigit(*stg) || *stg == '\'') {
               if (alpha1) {
                    *rts++=toupper(*stg);
                    alpha1=0;
               }
               else if (*(stg-2) == ' '
                 && ((c=toupper(*(stg-1))) == 'N' || c == 'S')
                 && ((c=toupper(*stg)) == 'E' || c == 'W')
                 && (*(stg+1) == ' ' || *(stg+1) == '\0')) {
                    *rts++=toupper(*stg);
               }
               else if (stg == inistg+1
                 && ((c=toupper(*(stg-1))) == 'P')
                 && ((c=toupper(*stg)) == 'O')
                 && ((c=toupper(*(stg+1))) == ' ' || c == 'B')) {
                    *rts++=toupper(*stg);
               }
               else {
                    *rts++=tolower(*stg);
               }
          }
          else {
               alpha1=1;
               if ((*stg == '.' || *stg == ',') && *(stg+1) != ' '
                 && *(stg+1) != ',') {
                    *rts++=*stg;
                    *rts++=' ';
               }
               else if (*stg == ' ' && (*(stg+1) == ' ' || *(stg+1) == ',')) {
                    /* do nothing */
               }
               else {
                    *rts++=*stg;
               }
          }
     }
     *rts='\0';
}
 
alblank(stg)
char *stg;
{
     while (*stg != '\0') {
          if (*stg != ' ') {
               return(0);
          }
          stg+=1;
     }
     return(1);
}
 
char *catfix1()
{
     return("");
}
 
char *catfix2()
{
     return("");
}
