/***************************************************************************
 *                                                                         *
 *   TYPUACC.C                                                             *
 *                                                                         *
 *   Copyright (C) 1986-1989  by GALACTICOMM, Inc.  All Rights Reserved.   *
 *                                                                         *
 *   This is the account file formatter (human-readable output) mainline.  *
 *                                                                         *
 *                                            - T. Stryker 10/20/86        *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "setjmp.h"
#include "btvstf.h"
#include "majorbbs.h"
#include "usracc.h"
#include "portable.h"
#include "fkcode.h"
 
extern jmp_buf disaster;      /* master error-recovery longjmp save block  */
 
main(argc,argv)
int argc;
char *argv[];
{
     BTVFILE *fp;
     struct usracc acct;
     long numact,numpai,numale,numfem,usetot,usefre,usepai,useavl;
     static char *filnam={"usracc.dat"};
     static FILE *outf=stdout;
     static int pagbrk=0,line;
     static char outnam[129]={""};
     static char repnam[]={"User Account Report"};
     char c;
 
     fprintf(stderr,"%s for The Major BBS\n",repnam);
     fprintf(stderr,"(C) Copyright 1989 Galacticomm Inc.\n\n");
     if (setjmp(ADDR_OFdisaster)) {
          exit(1);
     }
     if (argc > 1 && strcmp(argv[1],"?") == 0) {
          fprintf(stderr,"Where do you want to send the %s?\n",repnam);
          fprintf(stderr,"\n");
          fprintf(stderr,"   (1) to your Screen\n");
          fprintf(stderr,"   (2) to your Printer\n");
          fprintf(stderr,"   (3) to a Disk File\n");
          fprintf(stderr,"\n");
          fprintf(stderr,"Please choose a number (or 0 to exit):  ");
          while (1) {
               switch (getchc()) {
               case F1:
               case '1':
                    pagbrk=22;
                    fprintf(stderr,"1\n\n");
                    break;
               case F2:
               case '2':
                    strcpy(outnam,"PRN");
                    fprintf(stderr,"2\n\nPrinting the %s...",repnam);
                    break;
               case F3:
               case '3':
                    fprintf(stderr,"3\nFile name:  ");
                    scanf("%s",outnam);
                    fprintf(stderr,"\nWriting the %s to \"%s\"...",repnam,outnam);
                    break;
               case F10:
               case '0':
                    fprintf(stderr,"\n");
                    exit(0);
               default:
                    continue;
               }
               break;
          }
     }
     if (outnam[0] != '\0') {
          if ((outf=fopen(outnam,FOPWA)) == NULL) {
               catastro("CANNOT OPEN OUTPUT FILE \"%s\"",outnam);
          }
     }
     numact=0L;
     numpai=0L;
     numale=0L;
     numfem=0L;
     usetot=0L;
     usefre=0L;
     usepai=0L;
     useavl=0L;
     fp=opnbtv(filnam,sizeof(struct usracc));
     setbtv(fp);
     if (!qlobtv(0)) {
          catastro("User account file is empty!");
     }
     do {
          if (pagbrk > 0 && (line+=6) >= pagbrk) {
               fprintf(stderr,"<< hit any key to continue >>");
               getchc();
               fprintf(stderr,"\n\n");
               line=0;
          }
          gcrbtv(&acct,0);
          fprintf(outf,"USER-ID: %-10s PASSWORD: %-10s SYS: %d%s  CRT: %2dx%2d  AGE: %2d  SEX: %c\n",
             acct.userid,acct.psword,acct.systyp,
             ((acct.ansifl&ANSON) ? "(A)" : "   "),
             acct.scnwid,acct.scnlen,acct.age,acct.sex);
          fprintf(outf,"%-48s %30s\n",acct.usrnam,acct.usrad1);
          fprintf(outf,"%s, %s   Phone: %s\n",
             acct.usrad2,acct.usrad3,acct.usrpho);
          fprintf(outf,"Created %s, Last Used %s   Non-live time: %ld minutes\n",
             acct.credat,acct.usedat,acct.frescu/60L);
          fprintf(outf,"CREDITS:      %ld total      %ld paid      %ld available\n\n",
             acct.tcktot,acct.tckpai,acct.tckavl);
          numact+=1;
          if (acct.tckpai != 0L) {
               numpai+=1;;
          }
          if (acct.sex == 'M') {
               numale+=1;
          }
          else {
               numfem+=1;
          }
          usetot+=acct.frescu+(acct.tcktot-acct.tckavl);
          usefre+=acct.frescu;
          usepai+=max(0L,acct.tckpai-acct.tckavl);
          useavl+=min(acct.tckpai,acct.tckavl);
     } while (qnxbtv());
     if (pagbrk > 0 && (line+=10) >= pagbrk) {
          fprintf(stderr,"<< hit any key for summary >>");
          getchc();
          fprintf(stderr,"\n");
     }
     clsbtv(fp);
 
     fprintf(outf,"\14\nTotal Accounts:  %ld\n",numact);
     fprintf(outf,"Paying Accounts: %ld\n",numpai);
     fprintf(outf,"Male Accounts:   %ld\n",numale);
     fprintf(outf,"Female Accounts: %ld\n",numfem);
     fprintf(outf,"\nTotal Usage:          %ld user-hours\n",usetot/3600L);
     fprintf(outf,"Total Non-Live Usage: %ld user-hours\n",usefre/3600L);
     fprintf(outf,"Total Paid Usage:     %ld user-hours\n",usepai/3600L);
     fprintf(outf,"Total Paid Time Left: %ld user-hours\n",useavl/3600L);
     fclose(outf);
     fprintf(stderr,"\nEnd of report.\n");
     exit(0);
}
 
char *catfix1()
{
     return("");
}
 
char *catfix2()
{
     return("");
}
