/***************************************************************************
 *                                                                         *
 *   TYPAUDIT.C                                                            *
 *                                                                         *
 *   Copyright (C) 1986, 1987 by GALACTICOMM, Inc.  All Rights Reserved.   *
 *                                                                         *
 *   This is the Major BBS audit trail output utility.                     *
 *                                                                         *
 *                                            - T. Stryker 03/31/87        *
 *                                                                         *
 ***************************************************************************/

#include "stdio.h"
#include "setjmp.h"
#include "btvstf.h"
#include "majorbbs.h"
#include "portable.h"
#include "fkcode.h"

extern jmp_buf disaster;      /* master error-recovery longjmp save block  */

main(argc,argv)
int argc;
char *argv[];
{
     BTVFILE *fp;
     char audrec[AUDSIZ];
     static char *filnam={"auditrai.dat"};
     static FILE *outf=stdout;
     static int pagbrk=0,line=-1;
     static char outnam[129]={""};
     static char repnam[]={"Audit Trail Report"};
     char c;

     fprintf(stderr,"%s for The Major BBS\n",repnam);
     fprintf(stderr,"(C) Copyright 1988, Galacticomm Inc.\n\n");
     if (setjmp(ADDR_OFdisaster)) {
          exit(1);
     }
     if (argc > 1 && strcmp(argv[1],"?") == 0) {
          fprintf(stderr,"Where do you want to send the %s?\n",repnam);
          fprintf(stderr,"\n");
          fprintf(stderr,"   (1) to your Screen\n");
          fprintf(stderr,"   (2) to your Printer\n");
          fprintf(stderr,"   (3) to a Disk File\n");
          fprintf(stderr,"\n");
          fprintf(stderr,"Please choose a number (or 0 to exit):  ");
          while (1) {
               switch (getchc()) {
               case F1:
               case '1':
                    pagbrk=22;
                    fprintf(stderr,"1\n\n");
                    break;
               case F2:
               case '2':
                    strcpy(outnam,"PRN");
                    fprintf(stderr,"2\n\nPrinting the %s...",repnam);
                    break;
               case F3:
               case '3':
                    fprintf(stderr,"3\nFile name:  ");
                    scanf("%s",outnam);
                    fprintf(stderr,"\nWriting the %s to \"%s\"...",repnam,outnam);
                    break;
               case F10:
               case '0':
                    fprintf(stderr,"\n");
                    exit(0);
               default:
                    continue;
               }
               break;
          }
     }
     if (outnam[0] != '\0') {
          if ((outf=fopen(outnam,FOPWA)) == NULL) {
               catastro("CANNOT OPEN OUTPUT FILE \"%s\"",outnam);
          }
     }
     fp=opnbtv(filnam,AUDSIZ);
     setbtv(fp);
     if (!qlobtv(0)) {
          catastro("Audit trail file is empty!");
     }
     do {
          if (pagbrk > 0 && ++line >= pagbrk) {
               fprintf(stderr,"<< hit any key to continue >>");
               getchc();
               fprintf(stderr,"\n");
               line=0;
          }
          gcrbtv(audrec,0);
          fprintf(outf,"%s\n",audrec);
     } while (qnxbtv());
     clsbtv(fp);
     fclose(outf);
     fprintf(stderr,"\n\nEnd of report.\n");
     exit(0);
}

char *catfix1()
{
     return("");
}

char *catfix2()
{
     return("");
}
