/***************************************************************************
 *                                                                         *
 *   SYSINF.C                                                              *
 *                                                                         *
 *   Copyright (C) 1987-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the demo board system-info request handler.                   *
 *                                                                         *
 *                                            - T. Stryker 7/1/86          *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "majorbbs.h"
#include "usracc.h"
#include "sysinf.h"
#include "dosface.h"
#include "portable.h"
 
int inisin(),logons(),sysinf(),dfsthn(),loghup(),clssin();
 
#define SINSTT      05        /* system info requesting state         */
struct module module05={      /* module interface block               */
     '*',                     /*    main menu select character (config'able) */
     "",                      /*    description for main menu  (config'able) */
     inisin,                  /*    system initialization routine     */
     logons,                  /*    user logon supplemental routine   */
     sysinf,                  /*    input routine if selected         */
     dfsthn,                  /*    status-input routine if selected  */
     loghup,                  /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     clssin                   /*    finish-up (sys shutdown) routine  */
};
 
static
FILE *sinmb;                  /* sys info named-message file block pointer */
static
int newstt;                   /* new substate for this user                */
 
struct huplog {               /* structure definition of hang-up log       */
     char userid[UIDSIZ];     /* User-ID                                   */
     int timeon;              /* time logged into system                   */
     int timeof;              /* time logged off system                    */
} *huplog,                    /* dynamically allocated log of hangups      */
  *logptr;                    /* pointer for use with huplog               */
int *linlog;                  /* array of log-in times for each user       */
 
int whoson,                   /* activate "who's been on recently" option? */
    maxinl;                   /* maximum number of users in hangup log     */
 
extern
struct module *module[NMODS]; /* module access block pointer table         */
 
inisin()                           /* initialize system information module */
{
     int n;
 
     sinmb=opnmsg("sysinf.mcv");
     inimid(SINSTT,SINSEL,SINMNU);
     whoson=ynopt(WHOSON);
     maxinl=numopt(MAXINL,2,50);
     huplog=(struct huplog *)alcmem(n=maxinl*sizeof(struct huplog));
     setmem(huplog,n,0);
     linlog=(int *)alcmem(nterms*sizeof(int));
}
 
logons()                           /* records time of login for a user     */
{
     linlog[usrnum]=now();
}
 
sysinf()                           /* main system information input handler*/
{
     int c,i,j;
 
     setmbk(sinmb);
     newstt=usrptr->substt;
     do {
          bgncnc();
          switch (newstt) {
          case 0:
               cncchr();
               usrptr->flags&=~X2MAIN;
               prfmsg(newstt=INTRO);
               break;
          case INTRO:
               if (margc == 0 && !(usrptr->flags&INJOIP)) {
                    prfmsg(EXISIN);
                    return(0);
               }
          case REPRMT:
               if (usrptr->flags&INJOIP) {
                    prfmsg(REPRMT);
               }
               else if (margc == 0) {
                    prfmsg(newstt=INTRO);
               }
               else if ((c=cncchr()) == '1') {
                    usrson();
                    go2mai();
               }
               else if (whoson && c == '0') {
                    prf("\rUSER-ID ...... TIME ON   TIME OFF\r");
                    for (i=0,j=0,logptr=huplog ; i < maxinl ; i++,logptr++) {
                         if (logptr->userid[0] != '\0') {
                              prf("%-11s... %-9s",logptr->userid,
                                   nctime(logptr->timeon));
                              prf(" %s\r",nctime(logptr->timeof));
                              j++;
                         }
                    }
                    if (j == 0) {
                         prf("  (no log-offs since system up)\r");
                    }
                    go2mai();
               }
               else if (c >= '2' && c <= '6') {
                    prfmsg(SI2+(c-'2'));
                    go2mai();
               }
               else if (c == '?') {
                    prfmsg(newstt=INTRO);
               }
               else if (c == 'X') {
                    prfmsg(EXISIN);
                    cncall();
                    return(0);
               }
               else {
                    prfmsg(CNOTIL,c);
                    go2mai();
               }
               cncall();
               break;
          }
     } while (!endcnc());
     outprf(usrnum);
     usrptr->substt=newstt;
     return(1);
}
 
static
go2mai()                           /* go to main sysinf prompt, or exit    */
{
     condex();
     prfmsg(newstt=REPRMT);
}
 
loghup()                           /* records user in hangup log           */
{
     movmem(&huplog[1],&huplog[0],(maxinl-1)*sizeof(struct huplog));
     strcpy(huplog[maxinl-1].userid,usaptr->userid);
     huplog[maxinl-1].timeon=linlog[usrnum];
     huplog[maxinl-1].timeof=now();
}
 
clssin()                           /* close system info files for shutdown */
{
     clsmsg(sinmb);
}
