/***************************************************************************
 *                                                                         *
 *   STDPROT.C                                                             *
 *                                                                         *
 *   Copyright (C) 1990 GALACTICOMM, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   E-Mail and SIG standard upload/download handling.                     *
 *                                                                         *
 *                                  - R. Stein 4/26/90                     *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "majorbbs.h"
#include "usracc.h"
#include "btvstf.h"
#include "esigs.h"
#include "message.h"
#include "dosface.h"
#include "portable.h"
 
int reclen[]={                /* array of byte counts for download records */
     0,                       /*   NULL position for dnltyp[0] index       */
     0,                       /*   ASCII download, no byte count needed    */
     128+4,                   /*   XMODEM (128 byte blocks)                */
     128+5,                   /*   XMODEM CRC (128 byte blocks)            */
     1024+5                   /*   YMODEM CRC (1K blocks)                  */
};
 
int blksiz[]={                /* array of byte counts for download blocks  */
     0,                       /*   NULL position for dnltyp[0] index       */
     0,                       /*   ASCII download, no byte count needed    */
     128,                     /*   XMODEM (128 byte blocks)                */
     128,                     /*   XMODEM CRC (128 byte blocks)            */
     1024                     /*   YMODEM CRC (1K blocks)                  */
};
 
#define ACK  6                /* ASCII controls chars used in XMODEM       */
#define NAK 21
#define CCC 67                /*   'C' (rep's NAK) tells sender use CRC-16 */
#define SOH  1
#define STX  2                /*   (rep's SOH) tells rcver 1024-byte block */
#define EOT  4
#define CAN 24
 
char *uptmrs;                 /* array of upload/download timers per usrnum */
char *nakchs;                        /* array of NAK characters, per usrnum */
 
iniprot()              /* Stub routine, because Library Edition not present */
{
     uptmrs=alcmem(nterms);
     setmem(uptmrs,nterms,0);
     nakchs=alcmem(nterms);
}
 
libpsp()               /* Stub routine, because Library Edition not present */
{
}
 
pmtdnp()                            /* Email/SIGs ask for download protocol */
{
     prfmsg(ASCORX);
}
 
sascorx()                     /* state: ascii or xmodem flavor choice      */
{
     char c;
     char *ostyle;
 
     switch (c=cncchr()) {
     case '?':
          prohlp(ASCXHL);
          return;
     case '1':
          if (cncchr() == 'C') {
               btuxnf(usrnum,0,19);
               esgptr->sflags|=NOPGBK;
          }
          cncall();
          prompt(GOASC);
          btuinj(usrnum,CYCLE);
          ostyle=FOPRA;
          btuech(usrnum,0);
          break;
     case '2':
     case '3':
     case '4':
          cncall();
          prompt(GODNLDD);
          btutrg(usrnum,1);
          esgptr->blknum=1;
          esgptr->lstsiz=0;
          esgptr->curpos=0L;
          ostyle=FOPRB;
          nakchs[usrnum]=(c == '2' ? NAK : 'C');
          break;
     default:
          errmsg(either(EMLHUH,SIGHUH));
          return;
     }
     esgptr->fxftyp=c-'0';
     usrptr->flags|=NOINJO;
     if ((esgptr->fp=fopen(attfs(),ostyle)) == NULL || filen < 0) {
          dnloff();
          meither(prompt(REFBPN),gorep());
          clrprf();
          errmsg(ATTNF,ltoa(esgptr->msg.msgno));
     }
}
 
pmtupp()                                      /* prompt for upload protocol */
{
     prfmsg((usrptr->flags&ISYSOP) ? UPMSOP : UPMODE);
}
 
supmode()                     /* state: what upload mode?                  */
{
     char c;
     char *ostyle;
 
     switch (c=cncchr()) {
     case '?':
          prohlp(esgstt == UPMODE ? UPMODH : UPMSPH);
          return;
     case '1':
          cncall();
          prompt(UPASC);
          btubsz(usrnum,outbsz,INPSIZ);
          btumil(usrnum,INPSIZ);
          ostyle=FOPWA;
          break;
     case '2':
     case '3':
     case '4':
          cncall();
          prompt(GOUPLD);
          uptmrs[usrnum]=2;
          btubsz(usrnum,outbsz,INPSIZ);
          btutrg(usrnum,reclen[c-'0']);
          esgptr->lstsiz=-1;
          esgptr->blknum=1;
          ostyle=FOPWB;
          break;
     case '5':
          if (usrptr->flags&ISYSOP) {
               prompt(SOPFSP);
               return;
          }
     default:
          errmsg(either(EMLHUH,SIGHUH));
          return;
     }
     esgptr->fxftyp=c-'0'+UPLTYPS;
     nakchs[usrnum]=(c == '2' ? NAK : 'C');
     usrptr->flags|=NOINJO;
     btuffo(usrnum,1);
     if ((esgptr->fp=fopen(attfs(),ostyle)) == NULL) {
          uploff(0);
          clrprf();
          esgstt=UPLAGN;
          errmsg(UPLFER);
     }
}
 
int
protih()                                          /* protocol input handler */
{
     int rc=1;
     switch (esgstt) {
     case ASCORX:
          sascorx();
          break;
     case GOASC:
          abodnl();
          break;
     case UPMODE:
     case UPMSOP:
          supmode();
          break;
     case SOPFSP:
          ssopfsp();
          break;
     case UPASC:
          supasc();
          break;
     case GOUPLD:
     case GODNLDD:
     case COMPLT:
          prf("");
          break;
     default:
          rc=0;
          break;
     }
     return(rc);
}
 
int udfilex()                       /* upload/download file close upon exit */
{
     if (esgptr->fp != NULL) {
          fclose(esgptr->fp);
          esgptr->fp=NULL;
          return(1);
     }
     return(0);
}
 
supasc()                      /* state: uploading ascii file               */
{
     cncall();
     if (sameas(input,"OK")) {
          uploff(1);
          (*esgptr->whndun)();
     }
     else {
          fprintf(esgptr->fp,"%s\n",input);
          prf("");
     }
}
 
int protcy()                                    /* protocol 1-second cycler */
{
     for (usrnum=0 ; usrnum < nterms ; usrnum++) {
          if (uptmrs[usrnum] != 0 && --uptmrs[usrnum] == 0) {
               btuinj(usrnum,CYCLE);
          }
     }
}
 
int protsh()                                     /* protocol status handler */
{
     char ch;
     int ibw,sl;
     int rc=1;
 
     switch (esgstt) {
     case GOASC:
          switch (status) {
          case CYCLE:
               btucli(usrnum);
               if (btuoba(usrnum) < outbsz-1024) {
                    btuinj(usrnum,CYCLE);
                    break;
               }
               else if (fgets(prfbuf,1024,esgptr->fp) != NULL) {
                    if ((sl=strlen(prfbuf)) != 0 && prfbuf[sl-1] == '\n') {
                         prfbuf[sl-1]='\r';
                    }
                    outprf(usrnum);
                    btuinj(usrnum,CYCLE);
               }
               else {
                    btuoes(usrnum,1);
                    if (btuoba(usrnum) == outbsz-1) {
                         btuinj(usrnum,OUTMT);
                    }
                    esgstt=COMPLT;
               }
               break;
          default:
               dfsthn();
          }
          break;
     case GODNLDD:
          switch (status) {
          case INBLK:
               btuict(usrnum,&ch);
               switch (ch) {
               case CCC:
               case NAK:
                    if (ch != nakchs[usrnum]) {
                         break;
                    }
                    esgptr->curpos-=esgptr->lstsiz;
                    if (fseek(esgptr->fp,esgptr->curpos,0) != 0) {
                         catastro("GODNLDD FSEEK ERROR");
                    }
                    esgptr->blknum-=1;
               case ACK:
                    if (ch == ACK) {
                         nakchs[usrnum]=NAK;
                    }
                    setmem(prfbuf+3,blksiz[esgptr->fxftyp],0);
                    if ((esgptr->lstsiz=fread(prfbuf+3,1,
                       blksiz[esgptr->fxftyp],esgptr->fp)) > 0) {
                         esgptr->blknum=((esgptr->blknum+1)&0xFF);
                         prfbuf[0]=(blksiz[esgptr->fxftyp] == 1024 ? STX : SOH);
                         prfbuf[1]=(char)(esgptr->blknum);
                         prfbuf[2]=(char)(esgptr->blknum^0xFF);
                         switch (esgptr->fxftyp) {
                         case 2:
                              prfbuf[131]=cksumv(prfbuf+3,128);
                              break;
                         case 3:
                              mkcrc(128);
                              break;
                         case 4:
                              mkcrc(1024);
                              break;
                         }
                         btuxct(usrnum,reclen[esgptr->fxftyp],prfbuf);
                         esgptr->curpos+=esgptr->lstsiz;
                    }
                    else {
                         prfbuf[0]=EOT;
                         btuxct(usrnum,1,prfbuf);
                         uptmrs[usrnum]=2;
                         esgstt=COMPLT;
                    }
                    break;
               case CAN:
                    abodnl();
                    outprf(usrnum);
                    break;
               }
               break;
          default:
               dfsthn();
          }
          break;
     case COMPLT:
          switch (status) {
          case CYCLE:
               btuoes(usrnum,1);
               setmem(prfbuf,10,EOT);
               btuxct(usrnum,10,prfbuf);
               break;
          case OUTMT:
               goodnl();
               outprf(usrnum);
               break;
          default:
               dfsthn();
          }
          break;
     case GOUPLD:
          switch (status) {
          case CYCLE:
               ibw=btuibw(usrnum);
               if (esgptr->lstsiz == ibw) {
                    prfbuf[0]=0;
                    btuict(usrnum,prfbuf);
                    if (prfbuf[0] == EOT || prfbuf[0] == CAN) {
                         btubsz(usrnum,INPSIZ,outbsz);
                         btuffo(usrnum,0);
                         btuxmt(usrnum,"\6");                  /* ACK, done */
                         if (prfbuf[0] == CAN) {
                              donupl(0,"BY OPERATOR ");
                              prompt(UPLAGN);
                         }
                         else {
                              donupl(1);
                              (*esgptr->whndun)();
                         }
                         outprf(usrnum);
                         break;
                    }
                    btuxct(usrnum,1,&nakchs[usrnum]);                /* NAK */
                    btucli(usrnum);
               }
               else {
                    esgptr->lstsiz=ibw;
               }
               uptmrs[usrnum]=3;
               break;
          case INBLK:
               esgptr->lstsiz=-1;
               btuict(usrnum,prfbuf);
               if (prfbuf[0] != SOH && prfbuf[0] != STX) {
                    break;
               }
               else if (prfbuf[1] == (char)((esgptr->blknum-1)&0xFF)
                     && prfbuf[2] == (char)(((esgptr->blknum-1)^0xFF)&0xFF)) {
                    btuxct(usrnum,1,"\6");                /* ACK but ignore */
               }
               else if (prfbuf[1] == (char)(esgptr->blknum&0xFF)
                 && prfbuf[2] == (char)((esgptr->blknum^0xFF)&0xFF)) {
                    if (cksmok()) {
                         btuxct(usrnum,1,"\6");           /* ACK and accept */
                         esgptr->blknum+=1;
                         nakchs[usrnum]=NAK;
                         fwrite(prfbuf+3,1,blksiz[esgptr->fxftyp-UPLTYPS],
                                        esgptr->fp);
                    }
               }
               break;
          default:
               dfsthn();
          }
          break;
     default:
          rc=0;
          break;
     }
     usrptr->substt=esgstt;
     return(rc);
}
 
mkcrc(len)                    /* make CRC from prfbuf record, len long     */
int len;
{
     int crc;
 
     crc=ckscrc(prfbuf+3,len);
     prfbuf[len+3]=(char)(crc>>8);
     prfbuf[len+4]=(char)(crc&0xFF);
}
 
cksmok()                      /* check if record in prfbuf checksum is ok  */
{
     int typ,crc,len;
 
     switch (typ=esgptr->fxftyp-UPLTYPS) {
     case 2:
          return(cksumv(prfbuf+3,128) == prfbuf[131]);
     case 3:
     case 4:
          len=blksiz[typ];
          crc=ckscrc(prfbuf+3,len);
          return((char)(crc>>8) == prfbuf[len+3]
              && (char)(crc&0xFF) == prfbuf[len+4]);
     }
     return(0);
}
 
cksumv(stg,len)               /* compute XMODEM checksum value             */
char *stg;
int len;
{
     int cks=0;
 
     while (--len >= 0) {
          cks+=*stg++;
     }
     return(cks&0xFF);
}
 
int ckscrc(stg,len)           /* compute CRC value                         */
char *stg;
int len;
{
     int crc,i;
 
     crc=0;
     while (--len >= 0) {
          crc=crc^((int)*stg++<<8);
          for (i=0 ; i < 8 ; i++) {
               if (crc&0x8000) {
                    crc=(crc<<1)^0x1021;
               }
               else {
                   crc=crc<<1;
               }
          }
     }
     return(crc);
}
 
abodnl()                      /* abort download                            */
{
     btuclo(usrnum);
     dnloff();
     esgstt=DWNAGN;
     errmsg(ABORTD);
}
 
goodnl()                      /* good download, finish up and go on        */
{
     sv.dwnlds+=1;
     if (meither(ednaud,sdnaud)) {
          shocst(1,"%s D:%s",usaptr->userid,attfs());
     }
     dnloff();
     prfmsg(COMPLT);
     (*esgptr->whndun)();
}
