/***************************************************************************
 *                                                                         *
 *   SIGS.C                                                                *
 *                                                                         *
 *   Copyright (C) 1988-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is The Major BBS Special Interest Group handler.                 *
 *                                                                         *
 *                                  - T. Stryker 7/26/88                   *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "majorbbs.h"
#include "usracc.h"
#include "btvstf.h"
#include "esigs.h"
#include "message.h"
#include "dosface.h"
#include "portable.h"
 
int iniesg(),sigs(),emsthn(),sigdla(),clssig();
 
/* note first few lines in MESSAGE.H before changing the following name */
 
struct module module09={      /* module interface block               */
     '*',                     /*    main menu select character (config'able) */
     "",                      /*    description for main menu  (config'able) */
     iniesg,                  /*    system initialization routine     */
     NULL,                    /*    user logon supplemental routine   */
     sigs,                    /*    input routine if selected         */
     emsthn,                  /*    status-input routine if selected  */
     NULL,                    /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     sigdla,                  /*    delete-account routine            */
     clssig                   /*    finish-up (sys shutdown) routine  */
};
 
/*--- OPTIONS FROM ESIGS.MSG ---*/
 
int nsigs,                    /* number of SIGs allowed for                */
    sigccr,                   /* default SIG credit consumption rate       */
    siglif,                   /* default lifetime of a SIG message, in days*/
    sigtck,                   /* default "ticks" (credits) per SIG msg     */
    sattck,                   /* default "ticks" (credits) per file upload */
    sdnaud,                   /* Do audit trail entry per SIG download?    */
    supaud,                   /* Do audit trail entry per SIG upload?      */
    sopmhd;                   /* allow SIG-Ops to modify SIG headers?      */
 
char dftsig[UIDSIZ];          /* default SIG for new users etc.            */
 
#define MMENU (readac() >= OPAXES ? ORSPRMT : RSPRMT)
#define HUH   SIGHUH
 
int eclqscbas;                /* quickscan table base selector if ECLIPSE  */
 
inisig()                      /* initialize sig processing                 */
{
     struct sighdr *tmp;
     unsigned i,size;
 
     nsigs=numopt(NSIGS,1,MAXSIG);
     sigccr=numopt(SIGCCR,-32767,32767);
     siglif=numopt(SIGLIF,-1,32767);
     sigtck=numopt(SIGTCK,-32767,32767);
     sattck=numopt(SATTCK,-32767,32767);
     sdnaud=ynopt(SDNAUD);
     supaud=ynopt(SUPAUD);
     sopmhd=ynopt(SOPMHD);
     strncpy(dftsig,getmsg(DFTSIG),UIDSIZ-1);
     inimid(SIGSTT,SIGSEL,SIGMNU);
 
     alcqsc();
     for (i=0 ; i < nterms ; i++) {
          setmem(qscoff(i),sizeof(struct qscfg),0);
     }
     sigdat=(struct sigdat *)alcmem(size=nsigs*sizeof(struct sigdat));
     setmem(sigdat,size,0);
     sopqsc=(struct qscfg *)alcmem(sizeof(struct qscfg));
     sopusa=(struct usracc *)alcmem(sizeof(struct usracc));
 
     tmp=(struct sighdr *)alcmem(sizeof(struct sighdr)+msgbyts);
     if (!agtbtv(tmp,"/\0\0\0\0\0\0\0\0",TONUM)) {
          catastro("Empty ESIGS.DAT!");
     }
     do {
          if (tmp->signo >= nsigs || !(tmp->flags&ISSHDR)) {
               catastro("INISIG: BAD HDR #%u",tmp->signo);
          }
          mnewsg(tmp);
          esgbb->key[UIDSIZ-1]='\1';
     } while (agtbtv(tmp,NULL,TONUM) && tmp->to[0] == SIGIDC);
     free(tmp);
}
 
mnewsg(hdrptr)                /* fill in new sigdat entry from msg         */
struct sighdr *hdrptr;
{
     int sn;
 
     sn=hdrptr->signo;
     if (sn > sv.hisign) {
          sv.hisign=sn;
     }
     movmem(hdrptr->from,&sigdat[sn],sizeof(struct sigdat));
     wracut(dftnlv,hdrptr->dfnlv,sn);
     wracut(dftliv,hdrptr->dfliv,sn);
     wracut(maxnlv,hdrptr->mxnlv,sn);
     mkdir(hdrptr->to+1);
}
 
sigs()                        /* main status-3 input vector for sigs       */
{
     if (fireup()) {
          if (margc == 1 && sameas(input,"x")) {
               switch (esgstt) {
               case SSTART:
               case RSPRMT:
               case OPSTART:
               case ORSPRMT:
                    prfmsg(MAINSX);
                    return(0);
               }
               abostf();
          }
          else {
               do {
                    bgncnc();
                    switch (esgstt) {
                    case 0:
                         cncchr();
                         usrptr->flags&=~X2MAIN;
                         sigst0();
                         break;
                    case SSTART:
                    case RSPRMT:
                    case OPSTART:
                    case ORSPRMT:
                         if (ssstart()) {
                              return(1);
                         }
                         break;
                    case READBUL2:
                    case DNLFILL2:
                         sreadbu();
                         break;
                    case SRKEY:
                         ssrkey();
                         break;
                    case STARTS:
                         sstarts();
                         break;
                    case LISTYP2:
                         slistyp();
                         break;
                    case STARTL:
                         sstartl();
                         break;
                    case RQUICKL2:
                         srquick();
                         break;
                    case QUICKC:
                    case QUICKC4:
                         squickc();
                         break;
                    case QCADD:
                         sqcadd();
                         break;
                    case QCDEL:
                         sqcdel();
                         break;
                    case QCKWDS:
                         sqckwds();
                         break;
                    case QCSRKY:
                         sqcsrky();
                         break;
                    case MODWHT:
                         smodwhs();
                         break;
                    case DELMSN:
                         sdelmss();
                         break;
                    case MMINF:
                    case SRCHNG:
                    case SCANNG:
                    case SCANAP:
                    case LISTNG:
                    case SLSTTL:
                    case CPYING:
                         btuclo(usrnum);
                         prfmsg(ABOLST);
                         abostf();
                         break;
                    case SELSIG:
                         sselsig();
                         break;
                    case SIGCON:
                         ssigcon();
                         break;
                    case SIG123:
                    case SYS123:
                         s123();
                         break;
                    case SIGUID:
                    case SYSUID:
                         suid();
                         break;
                    case OPRMNU:
                         soprmnu();
                         break;
                    case CRESIG:
                         scresig();
                         break;
                    case DELSIG:
                         sdelsig();
                         break;
                    case DELRUS:
                         sdelrus();
                         break;
 
                    case CPYSRC:
                         scpysrc();
                         break;
                    case CPYDST:
                         scpydst();
                         break;
                    case UCPSRC:
                         sucpsrc();
                         break;
                    case UCPDST:
                    case UCPDST2:
                         sucpdst();
                         break;
 
                    default:
                         hdlesg();
                    }
               } while (!endcnc());
          }
     }
     outprf(usrnum);
     usrptr->substt=esgstt;
     return(1);
}
 
abostf()                      /* abort "stuff" (whatever is going on)      */
{
     uploff(0);
     dnloff();
     cpyoff();
     esgptr->sflags=0;
     esgptr->prethr=0L;
     esgptr->keynum=TONUM;
     setmem(esgptr->prvpos,NPREVS*sizeof(long),0);
     esgptr->pvpidx=0;
     cncall();
     prfmsg(SX2MAI);
     if (esgptr->usigno != qscptr->cursig) {
          prfmsg(R2SIG,sigdat[esgptr->usigno=qscptr->cursig].signam);
     }
     prompt(MMENU);
}
 
sigst0()                      /* SIG substate 0 handler (from Main Menu)   */
{
     esgptr->keynum=TONUM;
     iniqsc();
     if (qscptr->cursig == NOSIG || rdautl(qscptr->cursig) == NOAXES) {
          if ((qscptr->cursig=findsig(dftsig)) == NOSIG
           && rdautl(qscptr->cursig=0) == NOAXES) {
               catastro("LEVEL 2 CONFIGURATION OPTION \"DFTSIG\" NAMES A SIG THAT DOESN'T EXIST: %s",
                         dftsig);
          }
     }
     joinsg(qscptr->cursig);
}
 
onsqsc(userid)                /* is user "on system"? (if so, update qscfg)*/
char *userid;
{
     if (onsys(userid)) {
          if (qscoff(othusn)->userid[0] == '\0') {
               iqscfg(qscoff(othusn),userid);
          }
          return(1);
     }
     return(0);
}
 
iniqsc()                      /* initialize qscfg area if not already      */
{
     if (qscptr->userid[0] == '\0') {
          iqscfg(qscptr,usaptr->userid);
     }
}
 
iqscfg(qscptr,userid)         /* initialize qscfg from disk (if none, make)*/
struct qscfg *qscptr;
char *userid;
{
     setbtv(qscbb);
     while (!acqbtv(qscptr,userid,0)) {
          setmem(qscptr,sizeof(struct qscfg),0);
          movmem(userid,qscptr->userid,UIDSIZ);
          qscptr->cursig=NOSIG;
          setmem(qscptr->access,MAXSIG/2,NOTSET+(NOTSET<<4));
          insbtv(qscptr);
     }
     setbtv(esgbb);
}
 
ssstart()                     /* state: sitting at main sig menu           */
{
     int c,pstdun(),upodun();
 
     switch (c=cncchr()) {
     case '?':
          switch (esgstt) {
          case SSTART:
          case OPSTART:
               asig(FIRSTM);
               xtext();
               fupqs(MMINF,0);
               break;
          case RSPRMT:
               prompt(SSTART);
               break;
          case ORSPRMT:
               prompt(OPSTART);
               break;
          }
          break;
     case 'R':
          prompt(READBUL2);
          break;
     case 'W':
          if (readac() < WRAXES) {
               errmsg(NWRSIG);
          }
          else if (credsf(esgptr->sigtck)) {
               esgptr->msg.auxtpc[0]='\0';
               edimsg(1,1,pstdun,0);
          }
          break;
     case 'D':
          esgptr->sflags|=SCN4AT;
          prompt(DNLFILL2);
          break;
     case 'U':
          if (readac() < ULAXES) {
               errmsg(NUPSIG);
          }
          else if (credsf(esgptr->sigtck+esgptr->sattck)) {
               esgptr->msg.auxtpc[0]='\0';
               edimsg(1,1,upodun,1);
          }
          break;
     case 'T':
          usrptr->substt=esgstt;
          joint(esgptr->usigno);
          return(1);
     case 'S':
          prompt(SELSIG);
          break;
     default:
          if (readac() >= OPAXES) {
               switch (c) {
               case 'M':
                    prfmsg(MODWRN);
                    prompt(MODWHT);
                    break;
               case 'E':
                    prompt(DELMSN);
                    break;
               case 'A':
                    asig(LASTM);
                    fupqs(SCANAP,SCN4AT+SCN4UA);
                    break;
               case 'C':
                    prompt(SIGCON);
                    break;
               case 'O':
                    if (usrptr->flags&ISYSOP) {
                         prompt(OPRMNU);
                         break;
                    }
               default:
                    errmsg(CNOTIL);
               }
               break;
          }
          errmsg(CNOTIL);
     }
     return(0);
}
 
ssigcon()                     /* state: Sysop/SIG-Op configure-users       */
{
     char *up;
     int lvl;
 
     switch (morcnc()) {
     case '?':
          prohlp(SIGCONH);
          break;
     case '1':
     case '2':
     case '3':
          if (!isdigit(*(nxtcmd+1))) {
               esgptr->blknum=cncchr();
               prompt((usrptr->flags&ISYSOP) ? SYS123 : SIG123);
               break;
          }
     default:
          if ((lvl=rdoutl(up=cncuid())) == NOTSET) {
               errmsg(HUH);
          }
          else {
               movmem(up,esgptr->keywds,UIDSIZ);
               prfmsg(CURLVL,up,accstg[lvl]);
               prompt((usrptr->flags&ISYSOP) ? SYSUID : SIGUID);
          }
     }
}
 
s123()                        /* state: configure dftnlv, dftliv or maxnlv */
{
     static char *dftarr[]={dftnlv,dftliv,maxnlv};
     int newlvl;
 
     switch (cncchr()) {
     case '?':
          prohlp(esgstt == SIG123 ? SIG123H : SYS123H);
          return;
     case 'Z':
          newlvl=NOAXES;
          break;
     case 'R':
          newlvl=RDAXES;
          break;
     case 'D':
          newlvl=DLAXES;
          break;
     case 'W':
          newlvl=WRAXES;
          break;
     case 'U':
          newlvl=ULAXES;
          break;
     case 'C':
          newlvl=COAXES;
          break;
     case 'S':
          if (usrptr->flags&ISYSOP) {
               newlvl=OPAXES;
               break;
          }
     default:
          errmsg(HUH);
          return;
     }
     wracar(dftarr[esgptr->blknum-'1'],newlvl);
     prompt(MMENU);
}
 
suid()                        /* state: configure User-ID                  */
{
     int newlvl,actlvl;
 
     switch (cncchr()) {
     case '?':
          prohlp(esgstt == SIGUID ? SIGUIDH : SYSUIDH);
          return;
     case 'Z':
          newlvl=NOAXES;
          break;
     case 'R':
          newlvl=RDAXES;
          break;
     case 'D':
          newlvl=DLAXES;
          break;
     case 'W':
          newlvl=WRAXES;
          break;
     case 'U':
          newlvl=ULAXES;
          break;
     case 'C':
          newlvl=COAXES;
          break;
     case 'S':
          if (usrptr->flags&ISYSOP) {
               newlvl=OPAXES;
               break;
          }
     default:
          errmsg(HUH);
          return;
     }
     writac(esgptr->keywds,newlvl);
     actlvl=rdoutl(esgptr->keywds);
     if (actlvl != newlvl) {
          if (newlvl == NOAXES && actlvl == RDAXES) {
               prfmsg(DFTSOV);
          }
          else if (actlvl == OPAXES) {
               prfmsg(RMNSOP);
          }
          else if (actlvl == SYAXES) {
               prfmsg(RMNSYS);
          }
          else {
               prfmsg(MXNLOV,esgptr->keywds,accstg[actlvl]);
          }
          outprf(usrnum);
     }
     esgptr->keywds[0]='\0';
     prompt(MMENU);
}
 
soprmnu()                     /* state: operations menu                    */
{
     switch (cncchr()) {
     case 'C':
          prompt(CRESIG);
          break;
     case 'D':
          prompt(DELSIG);
          break;
     case 'F':
          prfmsg(CPYWRN);
          prompt(CPYSRC);
          break;
     case 'U':
          prfmsg(UCPINF);
          prompt(UCPSRC);
          break;
     default:
          errmsg(HUH);
     }
}
 
scresig()                     /* state: create a sig, enter new name       */
{
     char *signam;
     int csgdun();
     struct sighdr *hdrptr;
 
     if (*(signam=cncuid()) != SIGIDC || morcnc()) {
          errmsg(SIGNNG);
     }
     else if (findsig(signam) != NOSIG) {
          errmsg(SIGXST);
     }
     else if (sv.hisign >= nsigs-1) {
          blwoff(NOROOM);
     }
     else {
          hdrptr=(struct sighdr *)(&esgptr->msg);
          setmem(hdrptr,sizeof(struct sighdr),0);
          hdrptr->signo=sv.hisign+1;
          movmem(signam,esgptr->msg.to,UIDSIZ);
          prfmsg(MAKSIG2,sigccr,siglif,sigtck,sattck);
          outprf(usrnum);
          edimsg(1,1,csgdun,0);
     }
}
 
csgdun()                      /* create-SIG done, finish up                */
{
     struct sighdr *hdrptr;
 
     hdrptr=(struct sighdr *)(&esgptr->msg);
     hdrptr->flags=ISSHDR;
     hdrptr->dfnlv=RDAXES;
     hdrptr->dfliv=ULAXES;
     hdrptr->mxnlv=COAXES;
     postit();
     mnewsg(hdrptr);
     prfmsg(SIGCNF,hdrptr->to);
     pstpst();
     joinsg(hdrptr->signo);
}
 
sdelsig()                     /* state: delete sig, what name?             */
{
     int signo,rprdls();
     char *signam;
 
     if (morcnc() == '?') {
          lissgs(rprdls);
     }
     else if (sameas(signam=cncuid(),dftsig)) {
          errmsg(CANTDD);
     }
     else if ((signo=findsig(signam)) == NOSIG) {
          errmsg(SLSNXI);
     }
     else if (anyone(signo)) {
          errmsg(CANTDL);
     }
     else {
          esgptr->blknum=signo;
          prompt(DELRUS);
     }
}
 
anyone(insig)                 /* is there anyone in this sig right now?    */
int insig;
{
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          if (othusp->state == SIGSTT
            && (esgarr(othusn)->usigno == insig
             || qscoff(othusn)->cursig == insig)) {
               return(1);
          }
     }
     return(0);
}
 
sdelrus()                     /* state: delete SIG, are you sure??         */
{
     switch (cncyesno()) {
     case 'Y':
          if (anyone(esgptr->blknum)) {
               blwoff(SNUKIN);
          }
          else {
               esgptr->usigno=esgptr->blknum;
               asig(FIRSTM);
               do {
                    delmsg();
               } while (aqnbtv(&esgptr->msg));
               esgptr->usigno=qscptr->cursig;
               if (rmdir(sigdat[esgptr->blknum].signam+1) == 0) {
                    prfmsg(SIGDOK);
               }
               else {
                    prfmsg(SIGDNR);
               }
               setmem(&sigdat[esgptr->blknum],sizeof(struct sigdat),0);
               prompt(OPRMNU);
          }
          break;
     case 'N':
          prompt(OPRMNU);
          break;
     default:
          errmsg(HUH);
     }
}
 
rprdls()                      /* re-prompt after sig-list under sdelsig()  */
{
     prompt(DELSIG);
}
 
scpysrc()                     /* state: file copy source filespec?         */
{
     char *fsp;
 
     if ((esgptr->fp=fopen(fsp=cncall(),FOPRB)) == NULL) {
          errmsg(CPYFNG,fsp);
     }
     else {
          esgptr->sflags|=CPYIPG;
          esgptr->fpout=NULL;
          prompt(CPYDST);
     }
}
 
scpydst()                     /* state: file copy destination filespec?    */
{
     char *fsp;
     int cpydun();
 
     if ((esgptr->fpout=fopen(fsp=cncall(),FOPWB)) == NULL) {
          errmsg(CPYFNG,fsp);
     }
     else {
          esgptr->whndun=cpydun;
          fupqs(CPYING,0);
     }
}
 
cpydun()                      /* copy comes here when finished             */
{
     prfmsg(CPYFIN);
     prompt(MMENU);
}
 
cpyoff()                      /* turn file-copying process off             */
{
     if (esgptr->sflags&CPYIPG) {
          fclose(esgptr->fp);
          if (esgptr->fpout != NULL) {
               fclose(esgptr->fpout);
          }
          esgptr->sflags&=~CPYIPG;
     }
}
 
sucpsrc()                     /* state: user-copy source User-ID?          */
{
     char *up;
 
     if (getqsc(up=cncuid(),sopqsc) == NULL) {
          errmsg(SOPUNG);
     }
     else {
          movmem(up,esgptr->msg.from,UIDSIZ);
          prompt(UCPDST);
     }
}
 
sucpdst()                     /* state: user-copy destination User-ID?     */
{
     char *dstuid;
     struct qscfg *srcuqp,*dstuqp;
 
     if (onsys(dstuid=cncuid())) {
          errmsg(DCBONL,dstuid);
     }
     else if ((srcuqp=getqsc(esgptr->msg.from,esgptr->msg.text)) == NULL) {
          blwoff(SOPUNG);
     }
     else if ((dstuqp=getqsc(dstuid,sopqsc)) == NULL) {
          errmsg(SOPUNG);
     }
     else {
          setbtv(qscbb);
          movmem(srcuqp->access,dstuqp->access,MAXSIG/2);
          updbtv(dstuqp);
          prompt(UCPDST2);
     }
}
 
smodwhs()                     /* state: modify what sig msg number?        */
{
     int moddun();
 
     if (isalon()) {
          if (acqbtv(&esgptr->msg,&compos,TONUM)) {
               esgmod(moddun);
          }
          else {
               errmsg(NSUCHM);
          }
     }
}
 
sdelmss()                     /* state: delete (erase) what msg number?    */
{
     if (isalon()) {
          if (acqbtv(&esgptr->msg,&compos,TONUM)) {
               cncall();
               delwck();
          }
          else {
               errmsg(NSUCHM);
          }
     }
}
 
sreadbu()                     /* state: read-msg menu                      */
{
     switch (cncchr()) {
     case '?':
          prohlp(esgstt == READBUL2 ? RBLHLP2 : DLLHLP2);
          break;
     case 'K':
          prompt(SRKEY);
          btumil(usrnum,MXKWLN-1);
          break;
     case 'S':
          asig(qscptr->lsofar[qscptr->cursig]);
          prompt(STARTS);
          break;
     case 'L':
          asig(FIRSTM);
          prompt(LISTYP2);
          break;
     case 'Q':
          if (qscptr->flags&QSCFGD) {
               prompt(RQUICKL2);
          }
          else {
               qscptr->flags|=QSCFGD;
               cncall();
               setmem(qscptr->lsofar,MAXSIG*sizeof(long),0);
               prfmsg(FIRSQC2);
               prompt(QUICKC4);
          }
          break;
     default:
          errmsg(HUH);
     }
}
 
ssrkey()                      /* state: enter search key?                  */
{
     char *kwp;
 
     if (morcnc() == '?') {
          prohlp(SRKEYH);
     }
     else {
          if (*(kwp=cncall()) != '.') {
               movmem(kwp,esgptr->keywds,MXKWLN-1);
          }
          if (findkw(esgptr->keywds) == NULL && (kwp=findkw("")) != NULL) {
               movmem(esgptr->keywds,kwp,MXKWLN-1);
          }
          btumil(usrnum,DFTIMX);
          asig(FIRSTM);
          fupqs(SRCHNG,SCNNXT+SCNKWD);
     }
}
 
char *
findkw(kwd)                   /* find kwd in quickscan keyword list        */
char *kwd;
{
     int i;
     char *kwdptr;
 
     for (i=0,kwdptr=qscptr->qskwds[0]; i < NQSKWG ; i++,kwdptr+=MXKWLN) {
          if (sameas(kwd,kwdptr)) {
               return(kwdptr);
          }
     }
     return(NULL);
}
 
sstarts()                     /* state: start scan at what msg number?     */
{
     if (strtup(RTSHLP)) {
          sgonext();
     }
}
 
sscosig()                     /* state: next, previous, thread, or read?   */
{
     int gorep();
 
     switch (cncchr()) {
     case 'N':
          sgonext();
          break;
     case 'P':
          sgoprev();
          break;
     case 'T':
          prompt(THRFBP);
          break;
     case '#':
          prompt(GONUM);
          break;
     case 'R':
          xtext();
          switch (esgptr->msg.flags&(FILATT+APPVED)) {
          case 0:
               gorep();
               break;
          case FILATT:
               prfmsg(ATTNAP);
               if (readac() < OPAXES) {
                    gorep();
               }
               else {
                    dnload(gorep);
               }
               break;
          case FILATT+APPVED:
               if (readac() < DLAXES) {
                    prfmsg(FBNODL);
                    gorep();
               }
               else {
                    dnload(gorep);
               }
               break;
          }
          break;
     case 'D':
          if (esgstt == SCDSIG) {
               esgptr->whndun=gorep;
               prompt(ASCORX);
               break;
          }
     default:
          errmsg(HUH);
     }
}
 
gorep()                       /* go issue reply etc. prompt line           */
{
     if (usrptr->state == EMLSTT && esgptr->keynum == UTONUM) {
          prompt(readac() < OPAXES ? REPSEM : RESOP);
     }
     else {
          prompt(readac() < OPAXES ? REPSIG : REPOP);
     }
}
 
sgoprev()                     /* sig go-to-previous msg utility            */
{
     long p;
     int sn;
 
     if (usrptr->state == EMLSTT) {
          oncors();
          goprev();
     }
     else if (esgptr->sflags&SCNQUI) {
          if (esgptr->pvpidx >= NPREVS-1
           || (p=esgptr->prvpos[esgptr->pvpidx+1]) == 0
           || !aabbtv(&esgptr->msg,p,TONUM)
           || (sn=findsig(esgptr->msg.to)) == NOSIG) {
               estabc();
               errmsg(PVPGON);
          }
          else {
               esgptr->usigno=sn;
               esgptr->pvpidx+=1;
               sumscn(1);
          }
     }
     else {
          if (esgptr->sflags&SCN4UA) {
               esgptr->sflags|=SCNNXT;
          }
          else {
               esgptr->sflags&=~SCNNXT;
          }
          gocyc();
     }
}
 
sgonext()                     /* sig go-to-next msg utility                */
{
     int sn;
 
     if (usrptr->state == EMLSTT) {
          oncors();
          gonext();
     }
     else {
          while (esgptr->pvpidx > 0) {
               esgptr->pvpidx-=1;
               if (aabbtv(&esgptr->msg,esgptr->prvpos[esgptr->pvpidx],TONUM)
                && (sn=findsig(esgptr->msg.to)) != NOSIG) {
                    esgptr->usigno=sn;
                    sumscn(0);
                    return;
               }
          }
          if (esgptr->sflags&SCN4UA) {
               esgptr->sflags&=~SCNNXT;
          }
          else {
               esgptr->sflags|=SCNNXT;
          }
          gocyc();
     }
}
 
oncors()                      /* get back on course after possible threads */
{
     if (esgptr->prethr != 0L) {
          esgptr->fpos=esgptr->prethr;
          esgptr->prethr=0L;
          esgptr->keynum=esgptr->pthkyn;
     }
}
 
gocyc()                       /* go cycle onward through msgs (continue)   */
{
     int flags;
 
     oncors();
     flags=esgptr->sflags;
     if (flags&SCNKWD) {
          prompt(SRCHNG);
     }
     else if (flags&SCN4UA) {
          prompt(SCANAP);
     }
     else if (flags&SCN4AT) {
          prompt(SCANNG);
     }
     else {
          esgstt=SCANNG;
     }
     bgncyc();
}
 
srepsig()                     /* state: reply, thread, prev, next, etc.?   */
{
     int srpdun();
 
     switch (cncchr()) {
     case 'R':
          if (readac() < WRAXES) {
               errmsg(NWRSIG);
          }
          else if (credsf(esgptr->sigtck)) {
               movmem(esgptr->msg.from,esgptr->msg.userto,UIDSIZ);
               addaux(formax("Reply to #"));
               edimsg(2,1,srpdun,0);
          }
          break;
     case 'C':
          if (usrptr->state == EMLSTT && esgptr->keynum == UTONUM) {
               refclr(USING);
          }
          else {
               errmsg(HUH);
          }
          break;
     case 'T':
          prompt(THRFBP);
          break;
     case 'P':
          sgoprev();
          break;
     case 'N':
          sgonext();
          break;
     case '#':
          prompt(GONUM);
          break;
     case 'S':
          if (readac() >= OPAXES) {
               if ((esgptr->msg.flags&(FILATT+APPVED)) == FILATT) {
                    prompt(REPOPA);
               }
               else {
                    prompt((esgptr->msg.flags&EXEMPT) ? REPOPU : REPOPX);
               }
               break;
          }
     default:
          errmsg(HUH);
     }
}
 
srepopx()                     /* state: operator functions menu            */
{
     int modurs();
 
     switch (cncchr()) {
     case 'N':
          sgonext();
          break;
     case '#':
          prompt(GONUM);
          break;
     case 'F':
          if (esgptr->msg.flags&ISSHDR) {
               errmsg(NOFWSH);
          }
          else {
               prompt(OPFWD);
          }
          break;
     case 'T':
          estabc();
          esgptr->msg.flags|=EXEMPT;
          upvbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
          prfmsg(XMPCNF);
          gorep();
          break;
     case 'U':
          estabc();
          esgptr->msg.flags&=~EXEMPT;
          upvbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
          prfmsg(UXMCNF);
          gorep();
          break;
     case 'E':
          if (esgptr->msg.flags&ISSHDR) {
               errmsg(NDELHD);
          }
          else if (esgcfl()) {
               errmsg(USING);
          }
          else {
               prfmsg(OKGONE,ltoa(esgptr->msg.msgno));
               delsms();
          }
          break;
     case 'M':
          estabc();
          esgmod(modurs);
          break;
     case 'A':
          if (esgstt == REPOPA) {
               estabc();
               esgptr->msg.flags|=APPVED;
               upvbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
               sigdat[esgptr->usigno].nw4app-=1;
               sigdat[esgptr->usigno].nfiles+=1;
               prfmsg(APVCNF);
               gorep();
               break;
          }
     default:
          errmsg(HUH);
     }
}
 
modurs()                      /* modify finish-up during a scan            */
{
     wrtmod();
     sgonext();
}
 
srpdun()                      /* sig reply done, possible attachment?      */
{
     int sradun();
 
     possat(sradun);
}
 
sradun()                      /* sig reply attachment done, proceed        */
{
     long temp,ultdest;
 
     postwc();
     cncall();
     temp=esgptr->fpos;
     sgonext();
     ultdest=esgptr->fpos;
     esgptr->fpos=temp;
     estabc();
     esgptr->msg.nreply+=1;
     if (strcmp(usaptr->userid,esgptr->msg.userto) == 0) {
          esgptr->msg.userto[0]=clrchr(esgptr->msg.userto[0]);
     }
     upvbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
     esgptr->fpos=ultdest;
     estaab();
}
 
postwc()                      /* post SIG msg (with blank-check)           */
{
     if (esgptr->msg.text[1] != '\0' || (esgptr->msg.flags&FILATT)) {
          postit();
          stdcnf();
     }
}
 
sthrfbp()                     /* state: thread forwd, backwd, or parent?   */
{
     char *sptr;
 
     if (esgptr->prethr == 0L) {
          esgptr->prethr=esgptr->fpos;
          esgptr->pthkyn=esgptr->keynum;
          esgptr->keynum=TOTOPIC;
     }
     switch (cncchr()) {
     case '?':
          prohlp(FBPHLP2);
          break;
     case 'F':
          thrutl(1);
          break;
     case 'B':
          thrutl(0);
          break;
     case 'P':
          esgstt=scoscd();
          sptr=esgptr->msg.auxtpc;
          if (sameto("Rep",sptr)) {
               while (!isdigit(*sptr) && *sptr != '\0') {
                    sptr+=1;
               }
               movmem(esgptr->msg.to,compos.userid,UIDSIZ);
               compos.msgno=atol(sptr);
               if (acqbtv(&esgptr->msg,&compos,TONUM)) {
                    sumscn(0);
               }
               else {
                    errmsg(THPNF,ltoa(compos.msgno));
               }
          }
          else {
               errmsg(THPNRP);
          }
          break;
     default:
          errmsg(HUH);
     }
}
 
thrutl(fwd)                   /* thread forward/backward utility           */
int fwd;
{
     char savtpc[TPCSIZ];
 
     estabc();
     strcpy(savtpc,esgptr->msg.topic);
     if (fwd ? aqnbtv(&esgptr->msg) : aqpbtv(&esgptr->msg)) {
          if (sameas(esgptr->msg.topic,savtpc)) {
               sumscn(0);
               return;
          }
     }
     estabc();
     esgstt=scoscd();
     errmsg(fwd ? THFEND : THBBGN);
}
 
sopfwd()                      /* state: Sysop/SIG-Op forward msg to who?   */
{
     char *uid;
 
     if (validwr(uid=cncuid())) {
          if (esgcfl()) {
               errmsg(USING);
          }
          else {
               fwdit(uid);
               delsms();
          }
     }
}
 
delsms()                      /* delete a SIG msg utility                  */
{
     long temp,ultdest;
 
     cncall();
     if (usrptr->state == EMLSTT) {
          temp=esgptr->fpos;
          oncors();
          estabc();
          if (aqnbtv(&esgptr->msg)) {
               ultdest=absbtv();
               esgptr->fpos=temp;
               estabc();
               delmsg();
               esgptr->fpos=ultdest;
               if (estaab()) {
                    sumnew();
               }
               else {
                    blwoff(WOWEE);
               }
          }
          else {
               esgptr->fpos=temp;
               estabc();
               delmsg();
               blwoff(RPREND);
          }
     }
     else {
          estabc();
          delmsg();
          esgptr->prethr=0L;
          asig((esgptr->sflags&SCN4UA) ? LASTM : esgptr->msg.msgno);
          sgonext();
     }
}
 
slistyp()                     /* state: what listing mode?                 */
{
     switch (cncchr()) {
     case '?':
          prohlp(LTPHLP2);
          break;
     case 'F':
          esgptr->sflags|=SCNFTX;
     case 'T':
          esgptr->sflags|=SCN2LT;
     case 'B':
          if (esgptr->sflags&SCNQUI) {
               fupqsn(LISTNG,SCNQUI);
          }
          else {
               prompt(STARTL);
          }
          break;
     default:
          errmsg(HUH);
     }
}
 
sstartl()                     /* state: start listing at what msg number?  */
{
     if (strtup(RTLHLP)) {
          esgstt=LISTNG;
          if (!(esgptr->sflags&SCN2LT)) {
               prf("\r");
          }
          evlals();
          bgncyc();
     }
}
 
srquick()                     /* state: read quickscan menu                */
{
     switch (cncchr()) {
     case '?':
          prohlp(RQLHLP2);
          break;
     case 'K':
          fupqsn(SRCHNG,SCNQUI+SCNNXT+SCNKWD);
          break;
     case 'S':
          fupqsn(SCANNG,SCNQUI+SCNNXT);
          break;
     case 'L':
          esgptr->sflags|=SCNQUI;
          prompt(LISTYP2);
          break;
     case 'C':
          prompt(QUICKC);
          break;
     default:
          errmsg(HUH);
     }
}
 
fupqs(qsprmt,flags)           /* fire up (quick) scan, involving cycling   */
int qsprmt,flags;
{
     esgptr->sflags|=flags;
     prompt(qsprmt);
     bgncyc();
}
 
fupqsn(qsprmt,flags)          /* fire up (quick) scan without prompt       */
int qsprmt,flags;
{
     esgptr->sflags|=flags;
     esgstt=qsprmt;
     esgptr->dftinp='\0';
     bgncyc();
}
 
squickc()                     /* state: quickscan configuring, + or -?     */
{
     switch (cncchr()) {
     case '?':
          cncall();
          prfmsg(QCHELP3);
          prompt(QUICKC4);
          break;
     case 'V':
          prompt(QUICKC);
          break;
     case '+':
          prompt(QCADD);
          break;
     case '-':
          prompt(QCDEL);
          break;
     case 'K':
          prompt(QCKWDS);
          break;
     default:
          errmsg(HUH);
     }
}
 
sqcadd()                      /* state: quickscan config, add a SIG to list*/
{
     int rprqca(),sn;
     char *cp;
 
     if (morcnc() == '?') {
          lissgs(rprqca);
     }
     else if (sameas(cp=cncuid(),"ALL")) {
          for (sn=0 ; sn < MAXSIG ; sn++) {
               if (margc > 1 && sameas(margv[1],"+ALL")) {
                    qscptr->lsofar[sn]=sv.msgtot;
               }
               else if (qscptr->lsofar[sn] < 0) {
                    qscptr->lsofar[sn]=0;
               }
          }
          prompt(QUICKC4);
     }
     else if ((sn=findsig(cp)) == NOSIG) {
          errmsg(SLSNXI);
     }
     else {
          if (qscptr->lsofar[sn] >= 0) {
               qscptr->lsofar[sn]=sv.msgtot;
          }
          else {
               qscptr->lsofar[sn]=0;
          }
          prompt(QUICKC4);
     }
}
 
rprqca()                      /* reprompt after sig list under sqcadd()    */
{
     prompt(QCADD);
}
 
sqcdel()                      /* state: quickscan config, delete what sig? */
{
     int sn;
     char *cp;
 
     if (sameas(cp=cncuid(),"ALL")) {
          for (sn=0 ; sn < MAXSIG ; sn++) {
               qscptr->lsofar[sn]=-1;
          }
          prompt(QUICKC4);
     }
     else if ((sn=findsig(cp)) == NOSIG || qscptr->lsofar[sn] < 0) {
          esgstt=QUICKC;
          errmsg(QCDERR);
     }
     else {
          qscptr->lsofar[sn]=-1;
          prompt(QUICKC4);
     }
}
 
sqckwds()                     /* state: quickscan config keywords, which 1?*/
{
     switch (esgptr->blknum=cncchr()) {
     case '?':
          cncall();
          prfmsg(QCKWDH);
          prompt(QCKWDS);
          break;
     case '1':
     case '2':
     case '3':
     case '4':
     case '5':
          prompt(QCSRKY);
          btumil(usrnum,MXKWLN-1);
          break;
     default:
          errmsg(HUH);
     }
}
 
sqcsrky()                     /* state: quickscan config new keyword entry */
{
     if (margc == 0) {
          if (input[0] == '\0') {
               prohlp(QCSRKYH);
               return;
          }
          morcnc();
     }
     else if (morcnc() == '?') {
          prohlp(QCSRKYH);
          return;
     }
     movmem(cncall(),qscptr->qskwds[esgptr->blknum-'1'],MXKWLN-1);
     btumil(usrnum,DFTIMX);
     prompt(QCKWDS);
}
 
qsignx(idx)                   /* quickscan SIG list: next SIG no.?    */
int idx;
{
     while (idx < nsigs) {
          if (qscptr->lsofar[idx] >= 0) {
               if (rdautl(idx) > NOAXES) {
                    return(idx);
               }
               qscptr->lsofar[idx]=0;
          }
          idx+=1;
     }
     return(NOSIG);
}
 
scoscd()                      /* return SCOSIG or SCDSIG, dep on att'ment  */
{
     if ((esgptr->msg.flags&(FILATT+APPVED)) == FILATT+APPVED
       && readac() >= DLAXES) {
          return(SCDSIG);
     }
     return(SCOSIG);
}
 
lissgs(whndun)                /* list-sigs utility, when done invoke whndun*/
int (*whndun)();
{
     cncall();
     esgptr->usigno=-1;
     esgptr->whndun=whndun;
     prompt(SLSTTL);
     bgncyc();
}
 
bgncyc()                      /* begin cycling                             */
{
     cycmed();
     prf("");
}
 
cycmed()                      /* cycle mediator, called from emsthn()      */
{
     int instt,smslif,bufndd;
     char *chcred();
 
     if (esgstt == MMINF || (esgstt == LISTNG && (esgptr->sflags&SCNFTX))) {
          bufndd=outbsz-2;
     }
     else {
          bufndd=outbsz-2-1024;         /* (this way we don't get more than */
     }                                  /*   a K "ahead of ourselves"       */
     if (btuoba(usrnum) > bufndd) {
          instt=esgstt;
          switch (esgstt) {
          case MMINF:
               sdtptr=&sigdat[esgptr->usigno];
               prfmsg(SINFO,accstg[readac()],
                            sdtptr->sigop,
                            chcred(usrptr->crdrat),
                            chcred(esgptr->sigtck),
                            chcred(esgptr->sattck),
                            esgptr->sattck > 0 ? "rebate" : "bonus");
               smslif=sigopt("message-lifetime:",siglif);
               prfmsg(smslif >= 0 ? INFSLM : INFSUL,smslif);
               cncall();
               prompt(MMENU);
               break;
          case SRCHNG:
          case SCANNG:
          case SCANAP:
               vnxmsg();
               break;
          case LISTNG:
               listms();
               break;
          case SLSTTL:
               lsnams();
               break;
          case CPYING:
               copysm();
               break;
          default:
               return;
          }
          outprf(usrnum);
          if (esgstt != instt) {
               return;
          }
     }
     cncall();
     btuinj(usrnum,CYCLE);
}
 
char *
chcred(amt)                   /* generate charge-amount phrase for info    */
int amt;
{
     char *retval;
 
     if (amt == 0) {
          retval="not charged at all";
     }
     else if (amt > 0) {
          retval=spr("charged %d credits",amt);
     }
     else {
          retval=spr("given %d credits",-amt);
     }
     return(retval);
}
 
copysm()                      /* copy some data from src to dest (cycled)  */
{
     int i,c;
 
     for (i=0 ; i < 512 ; i++) {
          if ((c=fgetc(esgptr->fp)) == EOF) {
               cpyoff();
               (*esgptr->whndun)();
               return;
          }
          fputc(c,esgptr->fpout);
     }
     prf(".");
}
 
lsnams()                      /* list SIG names (one at a time, cycled)    */
{
     while (++(esgptr->usigno) < nsigs) {
          if (readac() != NOAXES) {
               sdtptr=&sigdat[esgptr->usigno];
               prf("%-9s  %5u  %5u  %-9s  %.43s\r",sdtptr->signam,sdtptr->nmsgs,
                    sdtptr->nfiles,sdtptr->sigop,sdtptr->descrp);
               return;
          }
     }
     esgptr->usigno=qscptr->cursig;
     (*esgptr->whndun)();
}
 
listms()                      /* list msgs, quickscan or regular (cycled)  */
{
     if (esgptr->sflags&SCNQUI) {
          if (esgptr->sflags&SCNCIS) {
               estabc();
               if (aqnbtv(&esgptr->msg)) {
                    evlals();
                    return;
               }
               esgptr->sflags&=~SCNCIS;
          }
          switch (nxtqs(qslidx())) {
          case FOUND:
               evlals();
               esgptr->sflags|=SCNCIS;
               break;
          case KEEPON:
               break;
          case DONE:
               prf("\rEnd of Quickscan List!");
               abostf();
               break;
          }
     }
     else {
          estabc();
          if (aqnbtv(&esgptr->msg)) {
               evlals();
          }
          else {
               prf("\rEnd of list!");
               abostf();
          }
     }
}
 
vnxmsg()                      /* validate next msg (cycled scans & kwdsr)  */
{
     switch (esgptr->sflags&(SCNQUI+SCNNXT+SCNCIS)) {
     case 0:
     case SCNNXT:
          esgptr->sflags|=SCNCIS;
          evlams();
          break;
     case SCNCIS:
          estabc();
          if (aqpbtv(&esgptr->msg)) {
               evlams();
          }
          else {
               estabc();
               cncall();
               prompt(SCNBGN2);
               esgstt=scoscd();
          }
          break;
     case SCNNXT+SCNCIS:
          estabc();
          if (aqnbtv(&esgptr->msg)) {
               evlams();
          }
          else {
               estabc();
               cncall();
               prompt(SCNEND2);
               esgstt=scoscd();
          }
          break;
     case SCNQUI+SCNNXT:
          switch (nxtqs(qslidx())) {
          case FOUND:
               evlams();
               esgptr->sflags|=SCNCIS;
               break;
          case KEEPON:
               break;
          case DONE:
               prf("\rQuickscan Complete!");
               abostf();
               break;
          }
          break;
     case SCNQUI+SCNNXT+SCNCIS:
          estabc();
          if (aqnbtv(&esgptr->msg)) {
               evlams();
          }
          else {
               prf(".");
               esgptr->sflags&=~SCNCIS;
          }
          break;
     default:
          catastro("VNXMSG: PREV/QSCAN!");
     }
}
 
qslidx()                      /* quickscan last index, plus 1 (0 if none)  */
{
     int retval;
 
     if (!(esgptr->sflags&SCNCIQ)) {
          retval=0;
          esgptr->sflags|=SCNCIQ;
     }
     else {
          retval=esgptr->usigno+1;
     }
     return(retval);
}
 
evlams()                      /* evaluate a msg for possible scan halt     */
{
     int phit;
 
     if (kwdmat()) {
          phit=(((esgptr->sflags&SCNNXT) == 0)^((esgptr->sflags&SCN4UA) != 0));
          sumscn(phit);
          if (esgptr->sflags&SCNQUI) {
               movmem(esgptr->prvpos,esgptr->prvpos+1,(NPREVS-1)*sizeof(long));
               esgptr->prvpos[0]=esgptr->fpos;
          }
     }
     else {
          esgptr->fpos=absbtv();
          prf(".");
     }
}
 
evlals()                      /* evaluate a listing for poss display       */
{
     char *prepbp;
 
     esgptr->fpos=absbtv();
     if (!(esgptr->sflags&SCN4AT) || (esgptr->msg.flags&APPVED)) {
          switch (esgptr->sflags&(SCN2LT+SCNFTX)) {
          case 0:
               prepbp=prfptr;
               prf("#%s %s %9s: %s %s\r",
                 spr(spr("%%%dld",strlen(ltoa(sv.msgtot))),esgptr->msg.msgno),
                 ncedat(esgptr->msg.crdate),
                 esgptr->msg.from,
                 esgptr->msg.topic,
                 (esgptr->msg.flags&ISSHDR) ? "" : axtstg());
               if (prfptr-prepbp > 79) {
                    prepbp[77]='*';
                    prepbp[78]='\r';
                    prepbp[79]='\0';
               }
               break;
          case SCN2LT:
               sumams();
               break;
          case SCN2LT+SCNFTX:
               sumams();
               outprf(usrnum);
               prf("");
               xtext();
               break;
          }
     }
     else {
          prf((esgptr->sflags&SCN2LT) ? "." : "");
     }
}
 
nxtqs(nxtidx)                 /* next quickscan activity FOUND/KEEPON/DONE */
int nxtidx;
{
     if (nxtidx < nsigs && (nxtidx=qsignx(nxtidx)) != NOSIG) {
          esgptr->usigno=nxtidx;
          compos.msgno=qscptr->lsofar[nxtidx];
          movmem(sigdat[nxtidx].signam,compos.userid,UIDSIZ);
          prompt(esgstt);
          if (agtbtv(&esgptr->msg,&compos,TONUM)
            && sameas(esgptr->msg.to,compos.userid)) {
               esgptr->fpos=absbtv();
               return(FOUND);
          }
          return(KEEPON);
     }
     return(DONE);
}
 
kwdmat()                      /* keyword match current msg (genly qualify) */
{
     int i,flags;
     char *kwlptr;
 
     flags=esgptr->sflags;
     if (flags&SCN4UA) {
          return((esgptr->msg.flags&(FILATT+APPVED)) == FILATT);
     }
     if ((flags&SCN4AT) && !(esgptr->msg.flags&APPVED)) {
          return(0);
     }
     if (!(flags&SCNKWD)) {
          return(1);
     }
     if (prfptr != prfbuf) {
          outprf(usrnum);
     }
     sumams();
     clrprf();
     if (flags&SCNQUI) {
          for (i=0 ; i < NQSKWG ; i++) {
               if (*(kwlptr=qscptr->qskwds[i]) != '\0' && kwdchk(kwlptr)) {
                    prfmsg(FNDQSK,kwlptr);
                    return(1);
               }
          }
          return(0);
     }
     return(kwdchk(esgptr->keywds));
}
 
kwdchk(list)                  /* check if this compound keyword matches    */
char *list;
{
     int i;
 
     strcpy(input,list);
     parsin();
     cncall();
     for (i=0 ; i < margc ; i++) {
          if (!findstg(margv[i],prfbuf)
            && !findstg(margv[i],esgptr->msg.text)) {
               return(0);
          }
     }
     return(1);
}
 
pstdun()                      /* post-to-SIG done, possible attachment?    */
{
     int attdun();
 
     movmem(sigdat[esgptr->usigno].signam,esgptr->msg.to,UIDSIZ);
     movmem(ALL,esgptr->msg.userto,UIDSIZ);
     possat(attdun);
}
 
upodun()                      /* upload descrip done, unconditional upload */
{
     int attdun();
 
     movmem(sigdat[esgptr->usigno].signam,esgptr->msg.to,UIDSIZ);
     movmem(ALL,esgptr->msg.userto,UIDSIZ);
     prompt((usrptr->flags&ISYSOP) ? UPMSOP : UPMODE);
     esgptr->whndun=attdun;
}
 
attdun()                      /* attachment processing done, post SIG msg  */
{
     postwc();
     cncall();
     prompt(MMENU);
}
 
sselsig()                     /* state: select new SIG, enter name?        */
{
     int signo,pmtssg();
     char signam[UIDSIZ];
 
     switch (morcnc()) {
     case '?':
          lissgs(pmtssg);
          return;
     case SIGIDC:
          movmem(cncuid(),signam,UIDSIZ);
          break;
     default:
          signam[0]=SIGIDC;
          movmem(cncuid(),signam+1,UIDSIZ-1);
     }
     if ((signo=findsig(signam)) == NOSIG) {
          errmsg(SLSNXI);
     }
     else {
          joinsg(signo);
     }
}
 
pmtssg()                      /* re-prompt after SIG list under sselsig()  */
{
     prompt(SELSIG);
}
 
joinsg(signo)                 /* join a SIG                                */
int signo;
{
     int oidx;
 
     esgptr->usigno=qscptr->cursig=signo;
     asig(FIRSTM);
     usrptr->crdrat=sigopt("credit-consumption-rate:",sigccr);
     esgptr->sigtck=sigopt("charge-per-message-posted:",sigtck);
     esgptr->sattck=sigopt("charge-per-file-uploaded:",sattck);
     if ((oidx=findstg("thoughts-of-the-day:",esgptr->msg.text)) > 0) {
          prf("%s\r",esgptr->msg.text+oidx);
     }
     prompt(readac() >= OPAXES ? OPSTART : SSTART);
}
 
sigopt(idstg,dftval)          /* find a SIG option in intro message        */
char *idstg;
int dftval;
{
     int oidx;
 
     if ((oidx=findstg(idstg,esgptr->msg.text)) > 0) {
          return(atoi(esgptr->msg.text+oidx));
     }
     return(dftval);
}
 
asig(msgnum)                  /* acquire lowest msg >= msgnum in this SIG  */
long msgnum;
{
     if (!alomsg(TONUM,msgnum)) {
          catastro("ASIG: NO SIG #%d",esgptr->usigno);
     }
}
 
findstg(stg,body)             /* find a string (keyword) in a body of text */
char *stg,*body;
{
     char *sscan,*bscan,*bsptr,sc,bc;
 
     for (bscan=body ; *bscan != '\0' ; bscan++) {
          for (sscan=stg,bsptr=bscan ;  ; sscan++,bsptr++) {
               sc=*sscan;
               bc=*bsptr;
               if (sc == '-') {
                    while (bc != '\0' && !isalnum(bc)) {
                         if (sc == '-') {
                              sc=*++sscan;
                         }
                         bc=*++bsptr;
                    }
               }
               if (sc == '\0') {
                    return((int)(bsptr-body));
               }
               if (tolower(sc) != tolower(bc)) {
                    break;
               }
          }
     }
     return(0);
}
 
readac()                      /* read access level, curr guy, curr SIG     */
{
     rdautl(esgptr->usigno);
}
 
saxxok(signo)                 /* SIG access is ok (for external modules)   */
int signo;
{
     qscptr=qscoff(usrnum);
     iniqsc();
     return(rdautl(signo) > NOAXES);
}
 
alcqsc()                           /* allocate quickscan data structures   */
{
     if ((qsarea=getml(nterms*(long)sizeof(struct qscfg))) == NULL) {
          catastro("ALCQSC: NOT ENOUGH MEMORY");
     }
#ifdef ECLIPSE
     if ((eclqscbas=ecltile(qsarea,sizeof(struct qscfg))) == 0) {
          catastro("ALCQSC: NOT ENOUGH SELECTORS");
     }
#endif
}
 
struct qscfg *
qscoff(unum)                       /* qscptr calculation routine           */
int unum;
{
#ifdef ECLIPSE
     return((struct qscfg *)((long)(eclqscbas+(unum<<3))<<16));
#else
     return((struct qscfg *)(qsarea+(unum*(long)sizeof(struct qscfg))));
#endif
}
 
#define acclvl(x,sn) (((sn)&1) ? x[(sn)>>1]>>4 : (x[(sn)>>1]&0x0F))
 
rdautl(signo)                 /* read access level, curr guy, another SIG  */
int signo;
{
     if (signo >= nsigs || sigdat[signo].signam[0] == '\0') {
          return(NOAXES);
     }
     if (usrptr->flags&ISYSOP) {
          return(SYAXES);
     }
     if (sameas(usaptr->userid,sigdat[signo].sigop)) {
          return(OPAXES);
     }
     return(alvutl(qscptr,usaptr,signo));
}
 
rdoutl(userid)                /* read access level, another guy, curr SIG  */
char *userid;
{
     int signo;
     struct qscfg *othuqp;
 
     if (sameas(userid,"Sysop")) {
          return(SYAXES);
     }
     if ((othuqp=getqsc(userid,sopqsc)) == NULL) {
          return(NOTSET);
     }
     signo=esgptr->usigno;
     if (sameas(userid,sigdat[signo].sigop)) {
          return(OPAXES);
     }
     return(alvutl(othuqp,othuap,signo));
}
 
struct qscfg *
getqsc(userid,sopqsc)         /* point at qscfg, either online or disk     */
char *userid;
struct qscfg *sopqsc;
{
     struct qscfg *othuqp;
 
     if (onsqsc(userid)) {
          othuqp=qscoff(othusn);
     }
     else {
          setbtv(accbb);
          if (!acqbtv(sopusa,userid,0)) {
               setbtv(esgbb);
               return(NULL);
          }
          setbtv(esgbb);
          iqscfg(sopqsc,userid);
          othuap=sopusa;
          othuqp=sopqsc;
     }
     return(othuqp);
}
 
alvutl(othuqp,othuap,signo)   /* access level sense utility                */
struct qscfg *othuqp;
struct usracc *othuap;
int signo;
{
     int setval,maxval,retval;
 
     if ((setval=acclvl(othuqp->access,signo)) == NOTSET) {
          retval=(othuap->tckavl <= 0 ? acclvl(dftnlv,signo)
                                      : acclvl(dftliv,signo));
     }
     else if (othuap->tckavl <= 0 && setval > (maxval=acclvl(maxnlv,signo))) {
          retval=maxval;
     }
     else {
          retval=setval;
     }
     if (retval == NOAXES && sameas(sigdat[signo].signam,dftsig)) {
          return(RDAXES);
     }
     return(retval);
}
 
dftlvl(array)                 /* get default access lvl, curr SIG          */
char *array;
{
     return(acclvl(array,esgptr->usigno));
}
 
writac(userid,value)          /* write an access level for spec'd user     */
char *userid;
int value;
{
     int oldval;
 
     if (value == OPAXES) {
          mksigo(userid);
          if (onsys(userid)) {
               prfmsg(UNOWOP,sigdat[esgptr->usigno].signam);
               injoth();
               prfmsg(SNOTIFD,userid);
          }
     }
     else {
          oldval=rdoutl(userid);
          if (oldval == OPAXES && value < OPAXES) {
               mksigo(usaptr->userid);
          }
          if (onsqsc(userid)) {
               wracar(qscoff(othusn)->access,value);
               if ((value=rdoutl(userid)) != oldval) {
                    prfmsg(UNEWAC,usaptr->userid,accstg[value],
                                  sigdat[esgptr->usigno].signam);
                    injoth();
                    prfmsg(SNOTIFD,userid);
               }
          }
          else {
               iqscfg(sopqsc,userid);
               wracar(sopqsc->access,value);
               setbtv(qscbb);
               updbtv(sopqsc);
               setbtv(esgbb);
          }
     }
}
 
mksigo(userid)                /* make userid the SIG-Op of current SIG     */
char *userid;
{
     movmem(userid,sigdat[esgptr->usigno].sigop,UIDSIZ);
     asig(FIRSTM);
     movmem(userid,esgptr->msg.from,UIDSIZ);
     upvbtv(&esgptr->msg,NVMSIZ+strlen(esgptr->msg.text));
}
 
wracar(acarpt,value)          /* write an access level to a spec'd array   */
char *acarpt;
int value;
{
     wracut(acarpt,value,esgptr->usigno);
}
 
wracut(acarpt,value,signo)    /* write-access-level utility                */
char *acarpt;
int value,signo;
{
     char *cp;
 
     cp=&acarpt[signo>>1];
     if (signo&1) {
          *cp&=0x0F;
          *cp|=value<<4;
     }
     else {
          *cp&=0xF0;
          *cp|=value;
     }
}
 
sigdla(uid)                   /* SIG account-delete vector                 */
char *uid;
{
     setbtv(qscbb);
     if (acqbtv(NULL,uid,0)) {
          delbtv();
     }
}
 
clssig()                      /* close down SIG activity, system shutdown  */
{
     struct sighdr *tmp;
 
     if (esgbb != NULL) {
          setbtv(esgbb);
          tmp=(struct sighdr *)alcmem(sizeof(struct sighdr)+msgbyts);
          ggtbtv(tmp,"/\0\0\0\0\0\0\0\0",TONUM);
          do {
               if (tmp->signo >= nsigs || !(tmp->flags&ISSHDR)) {
                    catastro("CLSSIG: BAD HDR #%u",tmp->signo);
               }
               movmem(&sigdat[tmp->signo],tmp->from,sizeof(struct sigdat));
               tmp->dfnlv=acclvl(dftnlv,tmp->signo);
               tmp->dfliv=acclvl(dftliv,tmp->signo);
               tmp->mxnlv=acclvl(maxnlv,tmp->signo);
               upvbtv(tmp,NVMSIZ+strlen(tmp->text));
               esgbb->key[UIDSIZ-1]='\1';
          } while (agtbtv(tmp,NULL,TONUM) && tmp->to[0] == SIGIDC);
          free(tmp);
          clsbtv(esgbb);
     }
     clsbtv(qscbb);
     clsmsg(esgmb);
}
 
