/***************************************************************************
 *                                                                         *
 *   PORTABLE.H                                                            *
 *                                                                         *
 *   Copyright (C) 1988,1990 GALACTICOMM, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   This header file supports compatibility of the source code of The     *
 *   Major BBS with multiple C language compilers, specifically, those     *
 *   of Microsoft and Borland (Turbo).                                     *
 *                                                                         *
 *   This declaration:  include "portable.h"  should appear in each        *
 *   source file, immediately following the other include directives.      *
 *                                                                         *
 *                         WARNING!                                        *
 *                                                                         *
 *   Your compiler command line must define one of the symbols:            *
 *   MSC_C or TSC_C.   This identifies the C compiler                      *
 *   (Microsoft or Turbo).  If Microsoft C 5.0 is in use,                  *
 *   you must also define the symbol MS5.  If you plan to use the          *
 *   protected-mode facilities associated with the Eclipse package,        *
 *   you must also define the symbol ECLIPSE.  To use the Turbo C          *
 *   "huge" model without going to protected mode, no special              *
 *   symbol need be defined (other than TSC_C, indicating Turbo C,         *
 *   of course!).                                                          *
 *                                                                         *
 *                                                 - R. Stein   1/24/88    *
 *   Lattice eliminated, "huge" and Eclipse added  - T. Stryker 2/28/90    *
 *                                                                         *
 ***************************************************************************/
 
#ifdef MSC_C
#define allmem()            ;
#ifdef ECLIPSE
#define sizmem()            eclcoreleft()
#define getml(ln)           eclmalloc(ln)
#define free(p)             eclfree(p)
#define malloc(in)          eclmalloc((long)(in))
char far *eclmalloc(unsigned long size);
long eclcoreleft();
#else
#define getml(ln)           halloc(ln,1)
char huge *halloc();
void *malloc();
#endif
#define ADDR_OFdisaster     disaster
#define ADDR_OFeximod       eximod
#define FOPRB  "rb"     /* fopen() 2nd parameter for read binary mode       */
#define FOPRA  "ra"     /* fopen() 2nd parameter for read ASCII mode        */
#define FOPWB  "wb"     /* fopen() 2nd parameter for write binary mode      */
#define FOPWA  "wa"     /* fopen() 2nd parameter for write ASCII mode       */
#define FOPRWB "r+b"    /* fopen() 2nd parameter for read/write binary mode */
#define FOPRWA "r+a"    /* fopen() 2nd parameter for read/write ASCII mode  */
#define FOPAB  "ab"     /* fopen() 2nd parameter for append binary mode     */
#define FOPAA  "aa"     /* fopen() 2nd parameter for append ASCII mode      */
#define CNTLIT 0        /* does sscanf() count literal matches?             */
#define CFREGS 1        /* REGS has a cflag field (see TurboC dos.h)        */
#define CKNOWN
#define setmem(p,n,c)       memset(p,c,n)
#ifdef MS5
#define movmem(s,d,n)       memmove(d,s,n)   /* microsoft 5.0 memcpy does   */
#else                                        /*   not deal with overlaps    */
#define movmem(s,d,n)       memcpy(d,s,n)
#endif
#endif
 
#ifdef TSC_C
#define allmem()            ;
#ifdef ECLIPSE
#define sizmem()            eclcoreleft()
#define getml(ln)           eclmalloc(ln)
#define free(p)             eclfree(p)
#define malloc(in)          eclmalloc((long)(in))
char far *eclmalloc(unsigned long size);
long eclcoreleft();
#else
#define getml(ln)           farmalloc(ln)
#define sizmem()            farcoreleft()
char far *farmalloc(unsigned long size);
void *malloc(unsigned size);
long farcoreleft();
#endif
#define ADDR_OFdisaster     disaster
#define ADDR_OFeximod       eximod
#define FOPRB  "rb"     /* fopen() 2nd parameter for read binary mode       */
#define FOPRA  "rt"     /* fopen() 2nd parameter for read ASCII mode        */
#define FOPWB  "wb"     /* fopen() 2nd parameter for write binary mode      */
#define FOPWA  "wt"     /* fopen() 2nd parameter for write ASCII mode       */
#define FOPRWB "r+b"    /* fopen() 2nd parameter for read/write binary mode */
#define FOPRWA "r+t"    /* fopen() 2nd parameter for read/write ASCII mode  */
#define FOPAB  "ab"     /* fopen() 2nd parameter for append binary mode     */
#define FOPAA  "at"     /* fopen() 2nd parameter for append ASCII mode      */
#define CNTLIT 0        /* does sscanf() count literal matches?             */
#define CFREGS 1        /* REGS has a cflag field (see TurboC dos.h)        */
#define CKNOWN
#endif
 
#ifndef min
#define min(a,b)        (((a) < (b)) ? (a) : (b))
#define max(a,b)        (((a) > (b)) ? (a) : (b))
#define abs(a)          (((a) < 0) ? -(a) : (a))
#endif
 
#ifdef CKNOWN
#undef CKNOWN
#else
#error YOU SHOULD IDENTIFY THE COMPILER!  (See the warning in PORTABLE.H)
#endif
 
