/***************************************************************************
 *                                                                         *
 *   OPRDSP.C                                                              *
 *                                                                         *
 *   Copyright (C) 1987-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This collection of routines runs the operator display and keyboard.   *
 *                                                                         *
 *                                            - T. Stryker 10/9/86         *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "dos.h"
#include "majorbbs.h"
#include "majormsg.h"
#include "usracc.h"
#include "btvstf.h"
#include "fkcode.h"
#include "dosface.h"
#include "portable.h"
 
char *maiscn;                 /* main-screen current address (or NULL)     */
static
char *maisav,                 /* main-screen off-screen ram image ptr      */
     *malscn,                 /* monitor-all current address (or NULL)     */
     *malsav,                 /* monitor-all off-screen ram image ptr      */
     *emuscn,                 /* emulate-channel current address (or NULL) */
     *emusav,                 /* emulate-channel off-screen ram image ptr  */
     *actscn,                 /* detail-account off-screen ram image ptr   */
     *infscn;                 /* system info off-screen ram image ptr      */
#define CMWYUL 20             /* command window y-top boundary             */
#define CMWXLR 77             /* command window x-right boundary           */
int cmwxul,cmwylr,            /* command window x-left and y-bottom bdys   */
    atoggl=ANSON;             /* ANSI-display toggle (defaults to ON)      */
 
int syssyc,                   /* system status rectangle low y coor        */
    dsppag,                   /* display page in effect                    */
    quiefl,                   /* quiet soft-key legends just put in place  */
    chn2em,                   /* channel to be emulated                    */
    chnemd,                   /* channel currently being emulated          */
    ltoggl,                   /* log-emu-session-to-disk toggle            */
    emux,emuy,                /* channel emulation screen (x,y) coords     */
    rmtsys=-1,                /* remote sysop emulation channel (-1 if no) */
    strtmd=0,                 /* module index where F9 statistics start    */
    c;                        /* char received from keyboard if any        */
static
FILE *elogfp;                 /* file handle for emulated session          */
static
BTVFILE *audbb,               /* Btrieve file block ptr for audit trail    */
        *svbb;                /* Btrieve file block ptr for sys variables  */
struct sysvbl sv;             /* sys-variables record instance for updates */
struct sysvb2 sv2;            /* 2nd sys-vbl record instance for updates   */
 
#define CMDPAG 0              /*   command display page                    */
#define MALPAG 1              /*   monitor all modem activity page         */
#define EMUPAG 2              /*   monitor a specific channel page         */
#define ACTPAG 3              /*   detail account display page             */
#define INFPAG 4              /*   display system variables screen         */
 
extern
int mbdone,                   /* main-loop exit flag                       */
    rsetop,                   /* reset option: busy=B; no-answer=N         */
    kilipg,                   /* kill-system command in progress           */
    kilctr,                   /* number of minutes to shutdown             */
    kilsrc;                   /* kill-cmd src (-1=console, -2=MCU, -3=auto)*/
extern
int errcod;                   /* MS-DOS exit code (for batch files)        */
extern
int horiz;                    /* horizontal function keys flag             */
extern
int color;                    /* color display adapter in use flag         */
extern
int bsport,nmeach;            /* base port addr and num of modems each card*/
extern
struct module *module[NMODS]; /* module access block pointer table         */
extern
BTVFILE *accbb;               /* user accounts btrieve data file           */
 
int sndchn;                   /* destination for message to be sent        */
char txtstg[MTXSIZ],          /* message text string buffer                */
     *txtptr;                 /* message text string pointer               */
 
#define XTRIES 10             /* max number of tries to exit for opchat    */
#define CMLSIZ 80             /* max input command-line length             */
#define SKBSIZ 30             /* max number of keys used to construct it   */
char cmlbuf[CMLSIZ];          /* command line input buffer                 */
int skbuf[SKBSIZ],            /* soft-key input buffer                     */
    *skbptr,                  /* soft-key buffer pointer                   */
    *skbpeu;                  /* skbptr value upon transition to ENTUID    */
char cskbuf[SKBSIZ];          /* collapsed (char-wise) soft-key input buf  */
 
static
struct usracc acc;            /* holding-area for detail account data      */
 
static                        /* soft-key legend table                     */
char *sklegs[][10]={
     "monitor"," send  ","display"," post  ","detail ","set msg","emulate","","analyze"," kill ",
     "  ALL  ","channel","","","","","","","","",
     "","","","","","","","","","",
     "","","","","","","","","<ENTER>","",
     "  OK   ","","","","","","","",""," QUIT ",
     "mem avl"," hours ","#accnts","#paying","topmsg#","","","","","",
     "UsedYTD","LiveYTD","UsedMTD","LiveMTD","UsedDTD","LiveDTD","PaidYTD","PaidMTD","PaidDTD","",
     "   1   ","   2   ","   3   ","","","","","","","",
     "","","","","","","","","","",
     "(PAID) ","(FREE) ","","","","","","","","",
     "","","","","","","","","","",
     "","","","","","","","","<ENTER>","",
     "","","","","","","","","<ENTER>","",
     "User-ID","account","","","channel","","","","system ","",
     "in 1min","in 2min","in 5min","in10min",""," UNDO! ",""," asap  ",""," NOW",
     "","","","","","","","","","",
     "busyout","no-ansr","normal ","","","","","","<ENTER>","",
     "busyout","no-ansr","normal ","","","","","","<ENTER>",""
};
                              /* soft-key legend-set and input state no.'s */
#define QUIET  0              /*   all quiet on the western front          */
#define SNDAC  1              /*   send to ALL or channel no.              */
#define INPCHN 2              /*   inputting first channel digit           */
#define INPCH2 3              /*   inputting second channel digit          */
#define INPMSG 4              /*   inputting a message                     */
#define SELDSP 5              /*   select qty to be displayed              */
#define SELXTD 6              /*   select hours-type and Y, M, or DTD      */
#define SEL123 7              /*   select position to display in           */
#define ENTAMT 8              /*   enter amount of credits to credit       */
#define ENTAPF 9              /*   still entering amount, term w/PAID|FREE */
#define ENTUID 10             /*   enter user-id (proceeds to ENTORU)      */
#define ENTORU 11             /*   still entering user-id, ENTER available */
#define ENTONL 12             /*   accept ENTER only                       */
#define SELKIL 13             /*   select item to kill                     */
#define ENTMIN 14             /*   enter number of minutes to shutdown     */
#define INCHKL 15             /*   input first digit of chan to kill       */
#define INC2KL 16             /*   input second digit, or kill mode        */
#define INKLMD 17             /*   input kill mode, no more digits         */
 
struct otrail {               /* trail structure for backspace key         */
     struct otrail *link;     /*   link                                    */
     int opistt;              /*   operator input state                    */
     char *cmlptr;            /*   command-line string pointer             */
} opinf;                      /* trail header                              */
 
int stthue=0x1D,              /* Audit Trail display attribute code        */
    lblhue=0x1F,              /* soft-key labels display attribute code    */
    dsphue=0x1A,              /* system vbls display box attribute code    */
    ndfhue=0x1E,              /* undefined channels display attribute code */
    manhue=0x0B,              /* monitor-all normal display attribute code */
    mashue=0x50,              /* monitor-all "special" disp attribute code */
    emthue=0x0A,              /* emulation text display attribute code     */
    emshue=0x50,              /* emulation status display attribute code   */
    emhhue=0x0D;              /* emulation help-title display attr code    */
 
int gotsv=0;                  /* in case early catastro, has sv been read? */
extern int svrate;            /* system variables save-rate in seconds     */
char *frzseg();
static
long atbptr,                  /* audit trail window-bottom absolute pos    */
     atptrs[7];               /* audit trail record absolute positions     */
#define NUMOFP (horiz ? 7 : 6)     /* number of ptrs in atptrs             */
static
int atmess,                   /* audit trail has been messed with flag     */
    viscol;                   /* fully visible user box column number      */
 
static
struct uidisp {               /* User-ID display area info                 */
     char attrib;             /*   display attribute for user box          */
     char usrbox[UIDSIZ];     /*   user box contents (User-ID or legend)   */
} *uidarr,*uiarpt;
 
#define LILBXS "\376\376\376\376\376\376\376\376\376" /* li'l yellow boxes */
 
inisho()                           /* initialize operator display stuff    */
{
     int i;
 
     iniscn("mjrmal.scn",malscn=malsav=alcmem(4000));
     iniscn("mjremu.scn",emuscn=emusav=alcmem(4000));
     iniscn("mjract.scn",actscn=alcmem(4000));
     iniscn("mjrinf.scn",infscn=alcmem(4000));
     maisav=alcmem(4000);
     if (horiz) {
          iniscn(hichp1 > 0x40 ? "mjrbbsh2.scn" : "mjrbbsh.scn",maisav);
          syssyc=14;
          cmwxul=2;
          cmwylr=21;
     }
     else {
          iniscn(hichp1 > 0x40 ? "mjrbbsv2.scn" : "mjrbbsv.scn",maisav);
          syssyc=12;
          cmwxul=18;
          cmwylr=23;
     }
     if (hichp1 > 0x40) {
          uidarr=(struct uidisp *)alcmem(hichp1*sizeof(struct uidisp));
          for (i=0,uiarpt=uidarr ; i < hichp1 ; i++,uiarpt++) {
               uiarpt->attrib=ndfhue;
               strcpy(uiarpt->usrbox,LILBXS);
          }
     }
     monoff();
     emuset(-1);
     quiesk();
     audbb=opnbtv("auditrai.dat",AUDSIZ);
     svbb=opnbtv("sysvbl.dat",sizeof(struct sysvbl));
     geqbtv(&sv,"key",0);
     geqbtv(&sv2,"ky2",0);
     if (svrate) {
          updsv();
     }
     gotsv=1;
     uptnd();
}
 
rseman()                           /* reset-channel emulation ANSI check   */
{
     if (usrnum == chnemd) {
          rsansi();
     }
}
 
rsansi()                           /* reset emulation ANSI attributes      */
{
     sstatr(emthue);
     ansion(0);
}
 
scroat(up)                         /* scroll audit trail window up (0=down)*/
int up;
{
     int i;
     char *crtadr;
 
     setbtv(audbb);
     sstatr(stthue);
     cursact(0);
     setwin(maiscn,2,1,34,syssyc,1);
     if (up) {
          gabbtv(NULL,atptrs[NUMOFP-1],0);
          if (qnxbtv()) {
               printfat(2,syssyc,"\n%.28s\n%s",audbb->data,audbb->data+28);
               rstloc();
               movmem(atptrs+1,atptrs,(NUMOFP-1)*sizeof(long));
               atptrs[NUMOFP-1]=absbtv();
          }
     }
     else if (atptrs[0] != 0) {
          for (i=syssyc-2 ; i >= 1 ; i--) {
               crtadr=frzseg();
               movmem(crtadr+i*160+4,crtadr+(i+2)*160+4,32*2);
          }
          gabbtv(NULL,atptrs[0],0);
          movmem(atptrs,atptrs+1,(NUMOFP-1)*sizeof(long));
          locate(2,1);
          if (qprbtv()) {
               printf("%-28.28s\n%-32s",audbb->data,audbb->data+28);
               rstloc();
               atptrs[0]=absbtv();
          }
          else {
               printf("%32s\n%32s","","");
               rstloc();
               atptrs[0]=0;
          }
     }
     rstwin();
     cursact(1);
     atmess=1;
}
 
iniaud()                           /* initialize audit trail display       */
{
     int i,x,y;
 
     setbtv(audbb);
     cursact(0);
     x=curcurx();
     y=curcury();
     sstatr(stthue);
     setwin(maiscn,2,1,34,syssyc,1);
     printf("\14");
     setmem(atptrs,sizeof(atptrs),0);
     gcrbtv(NULL,0);
     for (i=1 ; i <= NUMOFP ; i++) {
          atptrs[NUMOFP-i]=absbtv();
          printfat(2,syssyc-i*2+1,"%.28s\n%s",audbb->data,audbb->data+28);
          if (!qprbtv()) {
               break;
          }
     }
     locate(x,y);
     rstwin();
     cursact(1);
     atmess=1;
}
 
uptnd()                            /* update time and date, etc.           */
{
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          switch (othusp->class) {
          case PAYING:
               if (othusp->state >= NMODS1) {
                    sv2.modliv2[othusp->state-NMODS1]+=1;
               }
               else {
                    sv2.modliv[othusp->state]+=1;
               }
          case FRELOA:
               if (othusp->state >= NMODS1) {
                    sv2.moduse2[othusp->state-NMODS1]+=1;
               }
               else {
                    sv2.moduse[othusp->state]+=1;
               }
          }
     }
     redisp();
     rtkick(60,uptnd);
}
 
redisp()                           /* re-display operator display window   */
{
     char tmpstg[20];
     long sizmem();
     int i,x,y;
     static int wxcoor[2][3]={ 2, 2,20,  20,20,20};
     static int wycoor[2][3]={16,17,17,  15,16,17};
 
     cursact(0);
     x=curcurx();
     y=curcury();
     sstatr(dsphue);
     setwin(maiscn,0,0,79,24,1);
     printfat(20,syssyc+2,"%-5.5s %s",nctime(now()),ncdate(today()));
     for (i=0 ; i < 3 ; i++) {
          locate(wxcoor[!horiz][i],wycoor[!horiz][i]);
          switch (sv.dspopt[i]) {
          case 0:
               break;
          case 1:
               sprintf(tmpstg,"%ldK",sizmem()>>10);
               printf("mem avl: %-5s",tmpstg);
               break;
          case 3:
               printf("#accnts: %-5u",sv.numact);
               break;
          case 4:
               printf("#paying: %-5u",sv.numpai);
               break;
          case 5:
               printf("topmsg#: %-5s",ltoa(sv.msgtot));
               break;
          default:
               sprintf(tmpstg,
                       "%ld hrs",*((&sv.usedytd)+(sv.dspopt[i]-21))/3600L);
               printf("%s: %-5.5s",sklegs[SELXTD][sv.dspopt[i]-21],tmpstg);
               break;
          }
     }
     locate(x,y);
     rstwin();
     cursact(1);
}
 
updsv()                            /* update system variables              */
{
     if (gotsv) {
          setbtv(svbb);
          geqbtv(NULL,"key",0);
          updbtv(&sv);
          geqbtv(NULL,"ky2",0);
          updbtv(&sv2);
     }
     if (!atmess && atbptr != atptrs[NUMOFP-1]) {
          setbtv(audbb);
          ghibtv(NULL,0);
          iniaud();
     }
     atmess=0;
     rtkick(svrate,updsv);
}
 
quiesk()                           /* quiescent soft key legends setup     */
{
     zappo();
     opinf.opistt=QUIET;
     plosk(0);
     locate(2,0);
     *(opinf.cmlptr=cmlbuf)='\0';
     *(skbptr=skbuf)=0;
     acckey();
     quiefl=1;
}
 
zappo()                            /* unravel soft key linked-list trail   */
{
     struct otrail *otrptr;
 
     while ((otrptr=opinf.link) != NULL) {
          opinf.link=otrptr->link;
          free(otrptr);
     }
}
 
plosk(sktnum)                      /* "plot" soft key table no. sktnum     */
int sktnum;
{
     char **plskpt;
     int i,savx,savy;
 
     cursact(0);
     savx=curcurx();
     savy=curcury();
     setwin(NULL,0,0,79,24,0);
     sstatr(lblhue);
     zapskl();
     for (plskpt=sklegs[sktnum],i=1 ; i <= 10 ; plskpt++,i++) {
          if (rmtsys < 0 || i != 7 || sktnum != 0) {
               lblsk(i,*plskpt);
          }
     }
     locate(savx,savy);
     rstwin();
     cursact(1);
}
 
zapskl()                      /*  clear soft key legends                   */
{
     int i;
 
     cursact(0);
     for (i=1 ; i <= 9 ; i++) {
          lblsk(i,"       ");
     }
     lblsk(10,"      ");
     cursact(1);
}
 
lblsk(sknum,lblstg)           /* label soft keys with legends              */
int sknum;
char *lblstg;
{
     if (horiz) {
          locate((sknum-1)*8+1,23);
     }
     else {
          locate(((sknum&1) ? 1 : 9),((sknum-1)&0xfffe)+15);
     }
     printf(lblstg);
}
 
acckey()                      /* accept a soft-key keystroke (build trail) */
{
     struct otrail *otrptr;
 
     otrptr=(struct otrail *)alcmem(sizeof(struct otrail));
     movmem(&opinf,otrptr,sizeof(struct otrail));
     opinf.link=otrptr;
}
 
bckspc()                      /* backspace over previous soft-key command  */
{
     struct otrail *otrptr;
 
     if (opinf.link->link != NULL) {
          otrptr=opinf.link;
          opinf.link=otrptr->link;
          free(otrptr);
          otrptr=opinf.link;
          movmem(otrptr,&opinf,sizeof(struct otrail));
          opinf.link=otrptr;
          plosk(opinf.opistt);
          *opinf.cmlptr='\0';
          *--skbptr='\0';
          locate(cmwxul+((int)(opinf.cmlptr-cmlbuf)),cmwylr);
          sstatr(lblhue);
          clreol();
     }
}
 
dwopr()                       /* main "deal with operator" entry point     */
{
     int i;
     char *ptr;
     static char dsbuf[40];
 
     while (kbhit()) {
          c=getchc();
          switch (dsppag) {
          case CMDPAG:
               scmdpag();
               break;
          case ACTPAG:
               switch (c) {
               case PGUP:
                    dpract();
                    break;
               case PGDN:
                    dnxact();
                    break;
               default:
                    monoff();
                    dsppag=CMDPAG;
                    break;
               }
               break;
          case MALPAG:
               monoff();
               dsppag=CMDPAG;
               break;
          case INFPAG:
               switch (c) {
               case CRSRUP:
                    showmd(max(0,strtmd-1));
                    break;
               case CRSRDN:
                    showmd(min(NMODS-19,strtmd+1));
                    break;
               case PGUP:
                    showmd(max(0,strtmd-18));
                    break;
               case PGDN:
                    showmd(min(NMODS-19,strtmd+18));
                    break;
               case HOME:
                    showmd(0);
                    break;
               case END:
                    showmd(NMODS-19);
                    break;
               default:
                    monoff();
                    dsppag=CMDPAG;
               }
               break;
          case EMUPAG:
               semupag();
               break;
          }
     }
     if ((c=btumds()) != 0) {
          cursact(0);
          setwin(emuscn,0,1,79,24,1);
          locate(emux,emuy);
          ansion(1);
          ansion(atoggl);
          do {
               dsbuf[0]=c;
               for (i=1,ptr=dsbuf+1 ; i < sizeof(dsbuf)-1 ; i++) {
                    if ((*ptr++=btumds()) == 0) {
                         break;
                    }
               }
               printf("%s",dsbuf);
               if (rmtsys >= 0) {
                    btuxct(rmtsys,i,dsbuf);
               }
               if (ltoggl) {
                    fprintf(elogfp,"%s",dsbuf);
               }
          } while ((c=btumds()) != 0);
          emux=curcurx();
          emuy=curcury();
          ansion(0);
          if (emuscn != NULL) {
               rstloc();
          }
          cursact(1);
     }
}
 
showmd(newmdi)                     /* show new module stats offset         */
int newmdi;
{
     strtmd=newmdi;
     cursact(0);
     setwin(NULL,0,0,79,24,0);
     spitmd();
     locate(9,0);
     cursact(1);
}
 
scmdpag()                          /* command page keystroke handler       */
{
     int i;
 
     setwin(maiscn,cmwxul,CMWYUL,CMWXLR,cmwylr,1);
     if ((c == 8 || c == 27 || c == CRSRLF)
       && opinf.opistt != INPMSG
       && opinf.opistt != QUIET) {
          bckspc();
     }
     else if (c == CRSRRT) {
          movvis(+1);
     }
     else if (c == CRSRLF) {
          movvis(-1);
     }
     else if (c == CRSRUP) {
          scroat(0);
     }
     else if (c == CRSRDN) {
          scroat(1);
     }
     else if (c == PGUP) {
          for (i=0 ; i < NUMOFP ; i++) {
               scroat(0);
          }
     }
     else if (c == PGDN) {
          for (i=0 ; i < NUMOFP ; i++) {
               scroat(1);
          }
     }
     else if (c == END) {
          setbtv(audbb);
          ghibtv(NULL,0);
          iniaud();
     }
     else if (c == HOME) {
          setbtv(audbb);
          globtv(NULL,0);
          for (i=0 ; i < NUMOFP-2 ; i++) {
               qnxbtv();
          }
          iniaud();
     }
     else {
          switch (opinf.opistt) {
          case QUIET:
               squiet();
               break;
          case SNDAC:
               ssndac();
               break;
          case INPCHN:
               sinpchn();
               break;
          case INPCH2:
               sinpch2();
               break;
          case INPMSG:
               dwtxte();
               break;
          case SELDSP:
               sseldsp();
               break;
          case SELXTD:
               sselxtd();
               break;
          case SEL123:
               ssel123();
               break;
          case ENTAMT:
               sentamt();
               break;
          case ENTAPF:
               sentapf();
               break;
          case ENTUID:
               sentuid();
               break;
          case ENTORU:
               if (isuidc(127&c) && skbptr-skbpeu < UIDSIZ-1) {
                    c=tolower(c);
                    hdlskc(ENTORU);
                    break;
               }
          case ENTONL:
               if (c == '\r' || c == F9) {
                    retkey();
               }
               break;
          case SELKIL:
               sselkil();
               break;
          case ENTMIN:
               sentmin();
               break;
          case INCHKL:
          case INC2KL:
          case INKLMD:
               scklmod();
               break;
          }
     }
}
 
movvis(dist)                       /* move visible user column right/left  */
int dist;
{
     static int rtbrak[18];
     int i,*crt,*ptr,horbar;
     int tx,ty;
 
     if (hichp1 > 0x40) {
          crt=(int *)frzseg();
          if (rtbrak[0] == 0) {
               for (i=0,ptr=crt+80+49 ; i < 18 ; i++,ptr+=80) {
                    rtbrak[i]=*ptr;
               }
          }
          setwin(maiscn,0,0,79,24,0);
          sstatr(ndfhue);
          tx=curcurx();
          ty=curcury();
          if (dist == 1 && viscol != 0x0F) {
               cursact(0);
               printfat(40+viscol*2,1,"%x",viscol);
               viscol+=1;
               for (i=0,ptr=crt+80+39+viscol*2 ; i < 18 ; i++,ptr+=80) {
                    *ptr=*(ptr-2);
               }
               *(ptr-80+8)=*(ptr-80+7);
          }
          else if (dist == -1 && viscol != 0) {
               cursact(0);
               printfat(48+viscol*2,1,"%x",viscol);
               viscol-=1;
               for (i=0,ptr=crt+80+49+viscol*2 ; i < 18 ; i++,ptr+=80) {
                    *ptr=rtbrak[i];
               }
               *(ptr-80-8)=*(ptr-80-7);
          }
          else {
               return;
          }
          horbar=*(crt+80+(dist < 0 ? 42 : 40)+viscol*2);
          for (i=0,ptr=crt+80+40+viscol*2 ; i < 9 ; i++,ptr++) {
               *ptr=horbar;
          }
          printfat(43+viscol*2,1,"(%x)",viscol);
          for (i=0,uiarpt=uidarr+viscol*16 ; i < 16 ; i++,uiarpt++) {
               locate(40+viscol*2,i+2);
               if (viscol*16+i >= hichp1) {
                    sstatr(ndfhue);
                    printf(LILBXS);
               }
               else {
                    sstatr(uiarpt->attrib);
                    printf(uiarpt->usrbox);
               }
          }
          locate(tx,ty);
          cursact(1);
          rstwin();
     }
}
 
squiet()                           /* main menu of soft keys               */
{
     switch (c) {
     case F1:
          monall();
          dsppag=MALPAG;
          break;
     case F2:
          hdlsk("Send a message to ",SNDAC);
          break;
     case F3:
          hdlsk("Display ",SELDSP);
          break;
     case F4:
          hdlsk("Post ",ENTAMT);
          break;
     case F5:
          hdlsk("Detail info on (User-ID): ",ENTUID);
          skbpeu=skbptr;
          break;
     case F6:
          hdlsk("Set log-on message",ENTONL);
          break;
     case F7:
          if (rmtsys < 0) {
               hdlsk("Emulate channel no. ",INPCHN);
          }
          break;
     case F9:
          dspinf();
          dsppag=INFPAG;
          break;
     case F10:
          hdlsk("Kill ",SELKIL);
          break;
     case 27:
          emuchn(chnemd);
          dsppag=EMUPAG;
          break;
     case SHIFT+F5:
          dspact(acc.userid);
          break;
     }
}
 
ssndac()                           /* send message to channel or all       */
{
     switch (c) {
     case F1:
          hdlsk("ALL online channels",ENTONL);
          break;
     case F2:
          hdlsk("channel no. ",INPCHN);
          break;
     }
}
 
sinpchn()                          /* input a channel number (first digit) */
{
     if (isxdigit(127&c)) {
          c=toupper(c);
          hdlskc(INPCH2);
     }
}
 
sinpch2()                          /* input a channel number (second digit)*/
{
     if (isxdigit(127&c)) {
          c=toupper(c);
          hdlskc(ENTONL);
     }
     else if (c == '\r' || c == F9) {
          retkey();
     }
}
 
dwtxte()                           /* deal with text entered               */
{
     sstatr(lblhue);
     if (c == F1) {
          xltctls(txtstg);
          if (*(txtptr-1) == '\r') {
               *--txtptr='\0';
          }
          if (sndchn == -2) {
               strcpy(sv.lonmsg,txtstg);
          }
          else if (txtptr == txtstg) {
               sstatr(0x70);
               printf(" NULL -- MESSAGE IGNORED ");
          }
          else if (sndchn >= 0) {
               snd2ch(sndchn,txtstg);
          }
          else if (sndchn == -1) {
               snd2al(txtstg);
          }
          quiesk();
     }
     else if (c == F10) {
          sstatr(0x70);
          printf(" QUIT -- MESSAGE IGNORED ");
          quiesk();
     }
     else if (c == 8 && txtptr != txtstg && *(txtptr-1) != '\r') {
          printf("\10");
          *--txtptr='\0';
     }
     else if (txtptr-txtstg < MTXSIZ-1) {
          if (c == '\r') {
               printf("\n");
               *txtptr++=(char)c;
               *txtptr='\0';
          }
          else if (c >= ' ' && (c&eurmsk)) {
               printf("%c",c);
               *txtptr++=(char)c;
               *txtptr='\0';
          }
     }
}
 
snd2ch(chan,text)                  /* send text to a specific channel      */
int chan;
char *text;
{
     if (user[chan].class > SUPIPG) {
          othusn=chan;
          prf("!!!\7\r\rFROM SYSOP:\r%s\r\r",text);
          injoth();
     }
}
 
snd2al(text)                       /* send text to all online channels     */
char *text;
{
     int i;
 
     for (i=0 ; i < nterms ; i++) {
          snd2ch(i,text);
     }
}
 
sseldsp()                          /* select "display" variable            */
{
     switch (c) {
     case F1:
          hdlsk("memory available, in position ",
               SEL123);
          break;
     case F2:
          hdlsk("hours ",SELXTD);
          break;
     case F3:
          hdlsk("total number of accounts, in position ",
               SEL123);
          break;
     case F4:
          hdlsk("number of paying accounts, in position ",
               SEL123);
          break;
     case F5:
          hdlsk("top (current) message no., in position ",
               SEL123);
          break;
     }
}
 
sselxtd()           /* select used/paid/live hours day/month/year-to-date  */
{
     switch (c) {
     case F1:
          hdlsk("used Year-To-Date, in position ",SEL123);
          break;
     case F2:
          hdlsk("of live use Year-To-Date, in position ",SEL123);
          break;
     case F3:
          hdlsk("used Month-To-Date, in position ",SEL123);
          break;
     case F4:
          hdlsk("of live use Month-To-Date, in position ",SEL123);
          break;
     case F5:
          hdlsk("used \"Day-To-Date\", in position ",SEL123);
          break;
     case F6:
          hdlsk("of live use \"Day-To-Date\", in position ",SEL123);
          break;
     case F7:
          hdlsk("paid-for Year-To-Date, in position ",SEL123);
          break;
     case F8:
          hdlsk("paid-for Month-To-Date, in position ",SEL123);
          break;
     case F9:
          hdlsk("paid-for \"Day-To-Date\", in position ",SEL123);
          break;
     }
}
 
ssel123()                          /* select position 1, 2, or 3           */
{
     switch (c) {
     case F1:
     case '1':
          c=F1;
          hdlsk("1",ENTONL);
          break;
     case F2:
     case '2':
          c=F2;
          hdlsk("2",ENTONL);
          break;
     case F3:
     case '3':
          c=F3;
          hdlsk("3",ENTONL);
          break;
     }
}
 
sentamt()                          /* enter amount of credits to post      */
{
     if (isdigit(127&c) || c == '-') {
          hdlskc(ENTAPF);
     }
}
 
sentapf()                          /* enter "paid" or "free" credits       */
{
     switch (c) {
     case F1:
          hdlsk(" PAID credits to User-Id: ",ENTUID);
          skbpeu=skbptr;
          break;
     case F2:
          hdlsk(" FREE credits to User-Id: ",ENTUID);
          skbpeu=skbptr;
          break;
     default:
          if (isdigit(127&c) && strlen(cmlbuf) < 13) {
               hdlskc(ENTAPF);
          }
     }
}
 
sentuid()                          /* enter a user-id                      */
{
     if (isuidc(127&c)) {
          if (skbptr == skbpeu) {
               c=toupper(c);
               hdlskc(ENTUID);
          }
          else {
               c=tolower(c);
               if (skbptr-skbpeu < 2) {
                    hdlskc(ENTUID);
               }
               else {
                    hdlskc(ENTORU);
               }
          }
     }
}
 
sselkil()                          /*   select a "kill" option             */
{
     switch (c) {
     case F1:
          hdlsk("User-ID: ",ENTUID);
          skbpeu=skbptr;
          break;
     case F2:
          hdlsk("user-account database record of User-ID: ",ENTUID);
          skbpeu=skbptr;
          break;
     case F5:
          hdlsk("channel no. ",INCHKL);
          break;
     case F9:
          hdlsk("system ",ENTMIN);
          break;
     }
}
 
sentmin()                          /* select a minute count      */
{
     switch (c) {
     case F1:
          hdlsk("within 1 minute",ENTONL);
          break;
     case F2:
          hdlsk("within 2 minutes",ENTONL);
          break;
     case F3:
          hdlsk("within 5 minutes",ENTONL);
          break;
     case F4:
          hdlsk("within 10 minutes",ENTONL);
          break;
     case F6:
          hdlsk("UNDO!",ENTONL);
          break;
     case F8:
          hdlsk("as soon as possible",ENTONL);
          break;
     case F10:
          hdlsk("NOW",ENTONL);
          break;
     }
}
 
scklmod()                          /* enter a channel to kill and a mode   */
{
     if (opinf.opistt != INKLMD && isxdigit(c&127)) {
          c=toupper(c&127);
          hdlskc(opinf.opistt == INCHKL ? INC2KL : INKLMD);
     }
     else if (opinf.opistt != INCHKL) {
          switch (c) {
          case F1:
               hdlsk(" to \"BUSY-OUT\"",ENTONL);
               break;
          case F2:
               hdlsk(" to \"NO-ANSWER\"",ENTONL);
               break;
          case F3:
               hdlsk(" to normal",ENTONL);
               break;
          case F9:
          case '\r':
               retkey();
               break;
          }
     }
}
 
semupag()                          /* command handler for emulation screen */
{
     int i;
 
     cursact(0);
     switch (c) {
     case 30*256:/* alt-A */
          atoggl^=ANSON;
          setwin(emuscn,0,1,79,24,1);
          locate(24,0);
          sstatr(0x70);
          printf(atoggl ? "(ANSI)     " : "(non-ANSI) ");
          rstloc();
          break;
     case 38*256:/* alt-L */
          setwin(emuscn,0,1,79,24,1);
          locate(41,0);
          sstatr(emhhue);
          if (ltoggl^=1) {
               if ((elogfp=fopen("EMUBBS.LOG",FOPAB)) == NULL) {
                    printf("\7");
               }
               else {
                    fprintf(elogfp,"Log activated at %s %s\r\n\r\n",
                         nctime(now()),ncedat(today()));
                    printf(" Logging session to file: EMUBBS.LOG ");
               }
          }
          else {
               fprintf(elogfp,"\r\n\r\nLog terminated at %s %s\r\n",
                    nctime(now()),ncedat(today()));
               fclose(elogfp);
               printf("(press ESC to return to main display)");
          }
          rstloc();
          break;
     case 27:
          if (rmtsys >= 0 && (user[rmtsys].flags&NOHDWE)) {
               emuset(rmtsys);
               zpremu(rmtsys);
          }
          else {
               monoff();
               dsppag=CMDPAG;
          }
          break;
     case SHIFT+F2:
          usrptr=&user[chnemd];
          usaptr=&usracc[chnemd];
          vdaptr=vdaoff(chnemd);
          usrnum=chnemd;
          if (usrptr->flags&OPCHAT) {
               lvchat();
          }
          else if (usrptr->class > SUPIPG) {
               usrptr->flags|=OPCHAT+NOINJO;
               usrptr->flags&=~CONCEX;
               if (usrptr->flags&X2MAIN) {
                    for (i=0 ; i < XTRIES && usrptr->state != 0 ; i++) {
                         strcpy(input,"x");
                         margc=1;
                         margv[0]=input;
                         hdlinp();
                         btuclo(usrnum);
                    }
               }
               btuclo(usrnum);
               btuxmt(usrnum,"\r\r\7*** SYSOP CHAT MODE ACTIVATED ***\r\r");
               shochn(usracc[usrnum].userid);
               btucli(usrnum);
               btumil(usrnum,-(usaptr->scnwid-1));
          }
          break;
     case SHIFT+F10:
          btuinj(chnemd,RING);
          break;
     default:
          if (c&eurmsk) {
               btumks(c);
          }
          else {
               switch (c) {
               case CRSRUP:
                    oprmks('A');
                    break;
               case CRSRDN:
                    oprmks('B');
                    break;
               case CRSRRT:
                    oprmks('C');
                    break;
               case CRSRLF:
                    oprmks('D');
                    break;
               }
          }
          break;
     }
     cursact(1);
}
 
oprmks(chr)                        /* emit an ANSI cursor-movement string  */
int chr;
{
     btumks('\33');
     btumks('[');
     btumks(chr);
}
 
lvchat()                           /* exit user from sysop chat mode       */
{
     othusn=chnemd;
     user[othusn].flags&=~(OPCHAT+NOINJO);
     prf("\r***\rLeaving chat mode, returning to system...\r");
     injoth();
     btucli(othusn);
     btumil(othusn,DFTIMX);
}
 
hdlskc(opistt)                     /* handle entry of a soft key command   */
int opistt;
{
     static char stg[2]={0,0};
 
     stg[0]=(char)c;
     hdlsk(stg,opistt);
}
 
hdlsk(echstg,opistt)          /* handle entry of a soft key command utility*/
char *echstg;
int opistt;
{
     cursact(0);
     strcpy(opinf.cmlptr,echstg);
     opinf.cmlptr+=strlen(echstg);
     locate(cmwxul,cmwylr);
     sstatr(lblhue);
     if (quiefl) {
          quiefl=0;
          printf("\n");
     }
     printf("%s",cmlbuf);
     *skbptr++=c;
     *skbptr=0;
     plosk(opistt);
     opinf.opistt=opistt;
     acckey();
     cursact(1);
}
 
retkey()                           /* handle soft-key commands now         */
{
     int tmplen,c,real,kilib4;
 
     collap();
     switch (skbuf[0]) {
     case F2:
          if (skbuf[1] == F1) {
               sndchn=-1;
          }
          else {
               sscanf(&cskbuf[2],"%x",&sndchn);
               if ((sndchn=usridx(sndchn)) < 0) {
                    break;
               }
          }
          printf(":\n");
          *(txtptr=txtstg)='\0';
          plosk(opinf.opistt=INPMSG);
          break;
     case F3:
          if (skbuf[1] == F2) {
               sv.dspopt[(skbuf[3]-F1)>>8]=((skbuf[2]-F1)>>8)+21;
          }
          else {
               sv.dspopt[(skbuf[2]-F1)>>8]=((skbuf[1]-F1)>>8)+1;
          }
          quiesk();
          redisp();
          break;
     case F4:
          tmplen=strlen(&cskbuf[1]);
          usrnum=-1;
          real=(skbuf[tmplen+1] == F1);
          switch (addcrd(&cskbuf[tmplen+2],&cskbuf[1],real)) {
          case 1:
               saycrd(&cskbuf[1],real);
          case 0:
               quiesk();
          case -1:
               break;
          }
          break;
     case F5:
          dspact(&cskbuf[1]);
          break;
     case F6:
          printf(":\n");
          sndchn=-2;
          *(txtptr=txtstg)='\0';
          plosk(opinf.opistt=INPMSG);
          break;
     case F7:
          if (rmtsys < 0) {
               sscanf(&cskbuf[1],"%x",&c);
               if ((c=usridx(c)) < 0) {
                    break;
               }
               chn2em=c;
          }
          else {
               chn2em=chnemd;
          }
          quiesk();
          emuchn(chn2em);
          dsppag=EMUPAG;
          break;
     case F10:
          switch (skbuf[1]) {
          case F1:
               bootem();
               if (kiluid(&cskbuf[2]) >= 0) {
                    quiesk();
               }
               break;
          case F2:
               bootem();
               usrnum=-1;
               if (delacct(&cskbuf[2]) >= 0) {
                    quiesk();
               }
               break;
          case F5:
               sscanf(&cskbuf[2],"%x",&usrnum);
               if ((usrnum=usridx(usrnum)) < 0) {
                    break;
               }
               else {
                    switch (!isxdigit(skbuf[3]&127) ? skbuf[3] : skbuf[4]) {
                    case 0:
                         hdlsk(" to normal",ENTONL);
                    case F3:
                         rsmode=NORMRS;
                         break;
                    case F2:
                         rsmode=NANSRS;
                         break;
                    case F1:
                         rsmode=BUSYRS;
                         break;
                    }
                    rsmodes[usrnum]=rsmode;
                    kilchn(usrnum);
               }
               quiesk();
               break;
          case F9:
               if (skbuf[2] == F6) {
                    kilipg=0;
                    rsmode=NORMRS;
                    prepff();
                    kilctr=-1;
               }
               else {
                    kilsrc=-1;
                    switch (skbuf[2]) {
                    case F1:
                         kilctr=1;
                         break;
                    case F2:
                         kilctr=2;
                         break;
                    case F3:
                         kilctr=5;
                         break;
                    case F4:
                         kilctr=10;
                         break;
                    case F8:
                         kilctr=-1;
                         break;
                    case F10:
                         kilctr=0;
                         break;
                    }
                    rsmode=rsetop;
                    kilib4=kilipg;
                    kilipg=1;
                    prepff();
                    if (!kilib4 || kilctr == 0) {
                         kiloop();
                    }
               }
               quiesk();
               break;
          }
     }
}
 
bootem()                           /* boot User-ID about to be killed      */
{
     if (onsys(&cskbuf[2])) {
          usrnum=othusn;
          usrptr=othusp;
          usaptr=othuap;
          vdaptr=vdaoff(usrnum);
          loscar();
     }
}
 
kiloop()                           /* kill-system loop once per minute     */
{
     if (kilipg) {
          if (kilctr == 0) {
               hupall();
          }
          else {
               if (kilctr > 0) {
                    kalert(GOING2,kilctr);
                    kilctr-=1;
               }
               rtkick(60,kiloop);
          }
     }
}
 
kilchn(num)                        /* kill a channel by channel number     */
int num;
{
     int temp;
 
     if (user[num].class == VACANT) {
          temp=usrnum;
          usrnum=num;
          rstchn();
          usrnum=temp;
          usrptr=&user[usrnum];
     }
     else {
          btuinj(num,RING);
     }
}
 
static char lstuid[UIDSIZ]="";
 
dnxact()                           /* display next account screen          */
{
     setbtv(accbb);
     if (agtbtv(NULL,lstuid,0) || ahibtv(NULL,0)) {
          dspact(((struct usracc *)accbb->data)->userid);
     }
}
 
dpract()                           /* display previous account screen      */
{
     setbtv(accbb);
     if (altbtv(NULL,lstuid,0) || alobtv(NULL,0)) {
          dspact(((struct usracc *)accbb->data)->userid);
     }
}
 
dspact(userid)                     /* detail account screen routine        */
char *userid;
{
     char *scrn;
     int ison;
     extern char *sysstg[];
     extern char *ansstg[];
 
     setbtv(accbb);
     if (!agebtv(&acc,userid,0) && !ahibtv(&acc,0)) {
          return;
     }
     cursact(0);
     if ((ison=onsys(acc.userid)) != 0) {
          movmem(othuap,&acc,sizeof(struct usracc));
     }
     movmem(acc.userid,lstuid,UIDSIZ);
     scrn=frzseg();
     if (dsppag == CMDPAG) {
          quiesk();
          movmem(scrn,maiscn=maisav,4000);
     }
     dsppag=ACTPAG;
     movmem(actscn,scrn,4000);
     setwin(NULL,0,0,79,24,0);
     sstatr(0x70);
     printfat(24,0,"%s ",acc.userid);
     sstatr(stthue);
     printfat(26,2,"%s",acc.usrnam);
     printfat(26,3,"%s",acc.usrad1);
     printfat(26,4,"%s",acc.usrad2);
     printfat(26,5,"%s",acc.usrad3);
     printfat(26,6,"%s",acc.usrpho);
     printfat(26,7,"%s (%s)",sysstg[acc.systyp],ansstg[acc.ansifl]);
     printfat(26,8,"%d x %s",acc.scnwid,
              acc.scnlen == CTNUOS ? "(continuous)" : spr("%d",acc.scnlen));
     printfat(26,9,"%d",acc.age);
     printfat(26,10,"%c",acc.sex);
     printfat(26,11,"%s",vispsw ? acc.psword : "<unlisted>");
     printfat(26,14,ltoa(acc.tcktot));
     printfat(26,15,ltoa(acc.tckpai));
     printfat(26,16,ltoa(acc.tcktot-acc.tckpai));
     printfat(26,17,ltoa(acc.tckavl));
     printfat(26,18,ltoa(acc.frescu/60L));
     printfat(26,20,"%s",acc.credat);
     printfat(26,21,"%s",acc.usedat);
     if (ison) {
          printfat(59,3,"%19.19s",module[othusp->state]->descrp);
          printfat(75,6,"%d",othusp->substt);
          printfat(75,7,"%d",othusp->minut4/4);
          printfat(75,8,"%d",othusp->pfnacc);
          if (othusp->flags&ISX25) {
               printfat(75,9,"X.25");
          }
          else {
               printfat(othusp->baud > 9999 ? 74 : 75,9,"%u",othusp->baud);
          }
     }
     else {
          printfat(60,4,"(USER NOT ONLINE)");
     }
     lowright(acc.userid);
     locate(5,0);
     cursact(1);
}
 
printfat(x,y,stg,p1,p2)            /* printf string on screen at (x,y)     */
int x,y;
char *stg;
long p1,p2;
{
     locate(x,y);
     printf(stg,p1,p2);
}
 
dspinf()                           /* display analysis screen information  */
{
     char *scrn;
     char *cvt2pp();
     static unsigned totcntr;
     static unsigned agetot[NAGEBK];
     int j,i;
 
     cursact(0);
     quiesk();
     scrn=frzseg();
     movmem(scrn,maiscn=maisav,4000);
     movmem(infscn,scrn,4000);
     setwin(NULL,0,0,79,24,0);
     spitmd();
     for (i=0 ; i < NAGEBK ; i++) {
          agetot[i]=0;
     }
     for (j=0 ; j < NCOMTY ; j++) {
          sstatr((j&1) ? 0x0B : 0x0F);
          for (i=0,totcntr=0 ; i < NAGEBK ; i++) {
               printfat(44+(i*6),3+j,"%5u",sv2.matrix[j][i]);
               totcntr+=sv2.matrix[j][i];
               agetot[i]+=sv2.matrix[j][i];
          }
          sstatr((j&1) ? 0x09 : 0x0D);
          printfat(74,3+j,"%5u",totcntr);
     }
     sstatr(0x0D);
     for (i=0 ; i < NAGEBK ; i++) {
          printfat(44+(i*6),11,"%5u",agetot[i]);
     }
     sstatr(0x0C);
     printfat(74,11,"%5u",sv.numact);
     diutl();
     sstatr(0x70);
     printfat(56,0,"%-5.5s %s",nctime(now()),ncdate(today()));
     locate(9,0);
     cursact(1);
}
 
spitmd()                           /* spit out current module stats utility*/
{
 
#define glomus(i) (i < NMODS1 ? sv2.moduse[i] : sv2.moduse2[i-NMODS1])
#define glomlv(i) (i < NMODS1 ? sv2.modliv[i] : sv2.modliv2[i-NMODS1])
 
     long use;
     int i;
     char *cvt2pp();
 
     sstatr(0x0B);
     for (i=0 ; i < 19 ; i++) {
          if (module[i+strtmd]->descrp != NULL) {
               printfat(2,3+i,"%2d. %-14.14s",i+strtmd,
                             module[i+strtmd]->descrp);
          }
          else {
               printfat(2,3+i,"%2d. ------------- ",i+strtmd);
          }
     }
     sstatr(0x0F);
     for (i=0 ; i < 19 ; i++) {
          if (module[i+strtmd]->descrp != NULL) {
               use=glomus(i+strtmd);
               printfat(21,3+i,"%7s",ltoa(use/60L));
               if (use >= 60L) {
                    printfat(29,3+i,"%5s",cvt2pp(((glomlv(i+strtmd)/60L)*1000)/
                                         (use/60L)));
                    continue;
               }
          }
          else {
               printfat(21,3+i,"       ");
          }
          printfat(29,3+i,"     ");
     }
}
 
diutl()                            /* display information screen utlity    */
{
     sstatr(0x0F);
     printfat(36,15,"%5u",sv.numfre);
     printfat(42,15,"%5u",sv.numdem);
     printfat(48,15,"%5u",sv.numpai);
     printfat(54,15,"%5u",sv.numact-sv.numfem);
     printfat(60,15,"%5u",sv.numfem);
     printfat(66,15,"%5u",sv.numcor);
     printfat(72,15,"%5u",sv.numans);
 
     sstatr(0x0F);
     printfat(49,18,ltoa(sv.dwnlds));
     printfat(70,18,ltoa(sv.uplds));
     printfat(49,19,ltoa(sv.ctdtot));
     printfat(70,19,ltoa(sv.ctdpai));
     printfat(49,20,ltoa(sv.msgtot));
     printfat(70,20,"%u",sv.emlopn);
     printfat(70,21,"%u",sv.sigopn);
     printfat(49,22,ltoa(sv.csitot));
     printfat(70,22,"%u",sv.csiopn);
     printfat(49,23,ltoa(sv2.x25mbs));
     printfat(70,23,ltoa(sv2.x25kps));
}
 
char *cvt2pp(longin)               /* convert to "pp" (percentage points)  */
long longin;
{
     static char retval[10];
 
     if (longin/10 != 100) {
          sprintf(retval,"%ld.%ld%%",longin/10,longin%10);
     }
     else {
          sprintf(retval,"100%%");
     }
     return(retval);
}
 
collap()                      /* collapse 2-bytes/key to 1-byte/key buffer */
{
     int *skptr;
     char *cskptr;
 
     setmem(cskbuf,sizeof(cskbuf),0);
     for (skptr=skbuf,cskptr=cskbuf ; skptr != skbptr ; ) {
          *cskptr++=(char)((*skptr++)&255);
     }
}
 
shochn(legend)                     /* show legend in channel's display area*/
char *legend;
{
     shochb(legend,0);
}
 
shochb(legend,blink)               /* show legend for chan with blink option */
char *legend;
int blink;
{
     int chan,baudcd,colcd,mask,attr;
     char usrbox[UIDSIZ];
     int chncol,chnrow;
 
     baudcd=((user[usrnum].baud/300)|0x80);
     for (colcd=0,mask=1 ; (mask&baudcd) == 0 ; mask<<=1,colcd++) {
     }
     sstatr(attr=(colcd == 0 ? 0x19 : colcd+0x18)+(blink ? 0x80 : 0));
     setwin(maiscn,0,0,79,24,0);
     chan=channel[usrnum];
     if (hichp1 > 0x40) {
          sprintf(usrbox,"%-9.9s",legend);
          if (blink && usrbox[UIDSIZ-2] == ' ') {
               usrbox[UIDSIZ-2]='!';
          }
          uidarr[chan].attrib=attr;
          movmem(usrbox,uidarr[chan].usrbox,UIDSIZ);
          chnrow=(chan&0x0F)+2;
          if ((chncol=(chan>>4)) == viscol) {
               printfat(chncol*2+40,chnrow,usrbox);
          }
          else if (chncol > viscol) {
               printfat(chncol*2+48,chnrow,usrbox+UIDSIZ-2);
          }
          else {
               usrbox[1]='\0';
               printfat(chncol*2+40,chnrow,usrbox);
          }
     }
     else {
          printfat((chan>>4)*10+40,(chan&0x0F)+2,"%-9s",legend);
     }
     rstloc();
}
 
shocst(wrtaud,text,parm1,parm2,parm3)   /* display text to audit trail     */
int wrtaud;
char *text,*parm1,*parm2,*parm3;
{
     char audrec[AUDSIZ+20];
     long oatbpt;
 
     setmem(audrec,AUDSIZ,0);
     sprintf(audrec,"%-5.5s %s ",nctime(now()),ncdate(today()));
     switch (usrnum) {
     case -3:
          strcat(audrec,spr("TIMED EVENT %d",errcod-10));
          break;
     case -2:
          strcat(audrec,"AUTO-CLEANUP ");
          break;
     case -1:
          strcat(audrec,"MAIN CONSOLE ");
          break;
     default:
          sprintf(audrec+15,"CHANNEL %02X   ",channel[usrnum]);
     }
     sprintf(audrec+28,text,parm1,parm2,parm3);
     audrec[60]='\0';
     if (wrtaud+1) {          /* note: this is now unconditional */
          redisp();
          setbtv(audbb);
          insbtv(audrec);
          oatbpt=atbptr;
          atbptr=absbtv();
     }
     if (atptrs[NUMOFP-1] == oatbpt) {
          sstatr(stthue);
          setwin(maiscn,2,1,34,syssyc,1);
          printfat(2,syssyc,"\n%.28s\n%s",audrec,audrec+28);
          movmem(atptrs+1,atptrs,(NUMOFP-1)*sizeof(long));
          atptrs[NUMOFP-1]=atbptr;
          rstloc();
          rstwin();
     }
}
 
shomal()                           /* show modem statuses in monitor all   */
{
     int rlen;
     char *inptr;
 
     cursact(0);
     setwin(malscn,1,2,78,23,1);
     locate(1,23);
     if (status == 3) {
          sstatr(manhue);
          printf("\n %02x %c%3d %c %.66s",channel[usrnum],179,status,179,input);
          for (rlen=inplen-66,inptr=input+66 ; rlen > 0 ; rlen-=66,inptr+=66) {
               printf("\n    %c    %c %.66s",179,179,inptr);
          }
     }
     else {
          sstatr(manhue);
          printf("\n");
          sstatr(mashue);
          printf(" %02x ",channel[usrnum]);
          sstatr(manhue);
          printf("%c",179);
          sstatr(mashue);
          printf("%3d ",status);
          sstatr(manhue);
          printf("%c",179);
          if (usrnum == chnemd && (status == RING || status == LOST2C)) {
               rstloc();
               emdisp(" * RESET * ");
               if (emuscn == NULL) {
                    return;
               }
          }
     }
     rstloc();
     cursact(1);
}
 
emdisp(ctlstg,parm)                /* emulation display for operator       */
char *ctlstg;
long parm;
{
     cursact(0);
     setwin(emuscn,0,1,79,24,1);
     locate(emux,emuy);
     sstatr(emthue);
     printf("\n");
     sstatr(emshue);
     printf(ctlstg,parm);
     sstatr(emthue);
     printf("\n");
     emux=curcurx();
     emuy=curcury();
     cursact(1);
}
 
sstatr(attrib)                     /* set a screen attribute               */
int attrib;
{
     if (!color) {
          attrib=(((attrib&0x07) ? 0x07 : 0x70)|(attrib&0x80));
     }
     setatr(attrib);
}
 
monall()                           /* enter "monitor all" screen           */
{
     char *scrn;
 
     scrn=frzseg();
     movmem(scrn,maiscn=maisav,4000);
     movmem(malsav,scrn,4000);
     malscn=NULL;
     locate(2,0);
}
 
emuchn(chn2em)                     /* enter current channel emulation      */
int chn2em;
{
     char *scrn;
 
     scrn=frzseg();
     movmem(scrn,maiscn=maisav,4000);
     movmem(emusav,scrn,4000);
     emuscn=NULL;
     bgnemu(chn2em);
     locate(emux,emuy);
}
 
bgnemu(chn2em)                     /* begin emulation of a channel         */
int chn2em;
{
     int x,y;
 
     if (chn2em != chnemd) {
          cursact(0);
          x=curcurx();
          y=curcury();
          setwin(emuscn,0,1,79,24,1);
          locate(emux=0,emuy=1);
          rsansi();
          printf("\14");
          if (emuscn != NULL) {
               locate(x,y);
          }
          rstwin();
          cursact(1);
     }
     emuset(chn2em);
     if (chnemd >= 0
       && user[chnemd].class == VACANT
       && (user[chnemd].flags&NOHDWE)) {
          btuinj(chnemd,RING);
     }
}
 
emuset(chn2em)                     /* set-up emulation of a channel        */
int chn2em;
{
     int x,y;
 
     cursact(0);
     if (chnemd != chn2em) {
          btumon(chnemd=chn2em);
     }
     x=curcurx();
     y=curcury();
     setwin(emuscn,0,1,79,24,1);
     if (chn2em >= 0) {
          locate(21,0);
          sstatr(0x70);
          printf("%02x",channel[chn2em]);
     }
     locate(x,y);
     rstwin();
     cursact(1);
}
 
rsyson(rsysch,rchemd)              /* turn on remote sysop emulation       */
int rsysch,rchemd;
{
     int x,y;
 
     rmtsys=rsysch;
     if (opinf.opistt == QUIET) {
          cursact(0);
          x=curcurx();
          y=curcury();
          setwin(maiscn,0,0,79,24,1);
          sstatr(lblhue);
          lblsk(7,rsysch >= 0 ? "       " : "emulate");
          rstwin();
          locate(x,y);
          cursact(1);
     }
     if (rmtsys >= 0 && chnemd >= 0 && chnemd < nterms
      && (user[chnemd].flags&OPCHAT) && rchemd != chnemd) {
          lvchat();
     }
}
 
monoff()                           /* leave "monitor all" screen           */
{
     char *scrn;
 
     scrn=frzseg();
     if (malscn == NULL) {
          movmem(scrn,malscn=malsav,4000);
     }
     else if (emuscn == NULL) {
          movmem(scrn,emuscn=emusav,4000);
     }
     movmem(maisav,scrn,4000);
     maiscn=NULL;
     locate(2,0);
}
 
iniscn(filnam,where)               /* initialize a screen from screen file */
char *filnam,*where;
{
     FILE *fp;
     char *ptr;
     int i;
 
     if ((fp=fopen(filnam,FOPRB)) == NULL) {
          catastro("INISCN UNABLE TO OPEN \"%s\" FOR INPUT",filnam);
     }
     if (fread(where,4000,1,fp) != 1) {
          catastro("INISCN ERROR READING \"%s\"",filnam);
     }
     if (!color) {
          for (i=0,ptr=where+1 ; i < 2000 ; i++,ptr+=2) {
               if ((*ptr&0x70) != 0x70) {
                    *ptr&=~0x70;
               }
               if ((*ptr&0x07) != 0) {
                    *ptr|=0x07;
                    *ptr&=~8;
               }
          }
     }
     fclose(fp);
}
 
finsho()                           /* finish up stuff for shutdown         */
{
     updsv();
     clsbtv(svbb);
     clsbtv(audbb);
     locate(0,24);
}
