/*        Header file for use with messages: E-Mail and SIGs               */
/*   Copyright (C) 1988,1990 GALACTICOMM, Inc.    All Rights Reserved.     */
 
#define SIGSTT       9        /* SIG and E-Mail state codes - don't change */
#define EMLSTT      11        /*  unless also changing module struct names */
 
#define MAXSIG 200                 /* max number of SIGs total             */
#define MXKWLN  15                 /* max keyword group length (incl. '\0')*/
#define NQSKWG   5                 /* number of quickscan keyword groups   */
 
struct qscfg {                     /* quickscan/config per-user data       */
     char userid[UIDSIZ];          /* master key for lookups               */
     long lsofar[MAXSIG];          /* highest-msg-#-so-far quickscan info  */
     char access[MAXSIG/2];        /* SIG access bits, 4/SIG/user (packed) */
     char qskwds[NQSKWG][MXKWLN];  /* quickscan keywords                   */
     char cursig;                  /* current SIG                          */
     char flags;                   /* SIG-related account attributes       */
     char spare[1018-987];         /* spare space, decrease when adding on */
};
extern
char huge    *qsarea;         /* base ptr to dynam alloc'd quickscan area  */
extern
struct qscfg *sopqsc,         /* singular SYSOP/SIG-Op scratch area        */
             *qscptr;         /* ptr to current user's qsarea entry        */
 
extern
struct usracc *sopusa;        /* singular SYSOP/SIG-Op scratch acct        */
 
extern
char dftnlv[MAXSIG/2],        /* default non-live SIG access bits          */
     dftliv[MAXSIG/2],        /* default live SIG access bits              */
     maxnlv[MAXSIG/2];        /* maximum non-live SIG access bits          */
 
                                   /* SIG access level codes               */
#define NOAXES 0                   /*   no access                          */
#define RDAXES 2                   /*   read access                        */
#define DLAXES 4                   /*   download access                    */
#define WRAXES 6                   /*   write access                       */
#define ULAXES 8                   /*   upload access                      */
#define COAXES 10                  /*   Co-Op access                       */
#define OPAXES 12                  /* (ret from readac() when SIG-Op)      */
#define SYAXES 14                  /* (ret from readac() when Sysop)       */
#define NOTSET 15                  /*   not set yet (use default)          */
 
                                   /* SIG-related account attributes       */
#define QSCFGD 1                   /*   quickscan has been configured      */
 
#define TPCSIZ   51                /* topic field size (including the '\0')*/
#define AXTSIZ   37                /* aux topic size   (including the '\0')*/
#define NVMSIZ  156                /* non-variable message size component  */
 
                                   /* esigs.dat message database key id's  */
#define TOTOPIC   0                /*   compos "to" User-ID + topic field  */
#define FROMNUM   1                /*   compos "from" User-ID + msg number */
#define TONUM     2                /*   compos "to" User-ID + msg number   */
#define UTONUM    3                /*   compos "userto" + msg number       */
 
#define FIRSTM    0L               /* "first message" code, for searches   */
#define LASTM  0x7FFFFFFFL         /* "last message" code, for searches    */
 
#define ALL    "** ALL **"         /* string for userto dest when general  */
 
struct message {
     long msgno;                   /* message number                       */
     char userto[UIDSIZ];          /* User-ID personally to, or "** ALL **"*/
     char from[UIDSIZ];            /* message originator                   */
     char to[UIDSIZ];              /* recipient User-ID or SIG name        */
     char topic[TPCSIZ];           /* main topic, editable, carried over   */
     char auxtpc[AXTSIZ];          /* auxillary topic (reply to #88888,    */
                                   /*   fw by Aaaaaaaaa, cc: of #99999)    */
     int crdate;                   /* message creation date                */
     int crtime;                   /* message creation time of day         */
     int nreply;                   /* number of times replied to           */
     int flags;                    /* message/attachment flag bits         */
     char spare[NVMSIZ-131];       /* spare space, decrease when adding on */
     char text[1];                 /* variable-length message text         */
};
                                   /* message flag bits                    */
#define ISSHDR  0x01               /*   message is SIG header format       */
#define EXEMPT  0x02               /*   message is exempt from auto-delete */
#define RECREQ  0x10               /*   return-receipt requested when read */
#define INDRCT  0x20               /*   "indirect" att, direct has filespec*/
#define FILATT  0x40               /*   file is attached to this message   */
#define APPVED  0x80               /*   file attached is ok to download    */
 
struct sighdr {
     long msgno;                   /* message number                       */
     char userto[UIDSIZ];          /* should always be "** ALL **"         */
     char from[UIDSIZ];            /* SIG-Op User-ID                       */
     char to[UIDSIZ];              /* SIG name (with leading slash)        */
     char topic[TPCSIZ];           /* SIG short description                */
 
     char signo;                   /* SIG number                           */
     int  nmsgs;                   /* number of messages in the SIG        */
     int  nfiles;                  /* number of files in the SIG           */
     int  nw4app;                  /* number of files waiting for apprvl   */
     char ispare[AXTSIZ-4-13];     /* a little internal spare space here   */
     int  dfnlv;                   /* default non-live access setting      */
     int  dfliv;                   /* default live access setting          */
     int  mxnlv;                   /* maximum non-live access setting      */
     char mispare[4];              /* more internal spare space            */
 
     int crdate;                   /* SIG creation date                    */
     int crtime;                   /* SIG creation time of day             */
     int nreply;                   /* number of times replied to           */
     int flags;                    /* settable SIG options                 */
     char spare[NVMSIZ-131];       /* spare space, decrease when adding on */
     char text[1];                 /* variable-length SIG intro text       */
};
 
#define SIGIDC '/'                 /* SIG identifier character             */
#define NOSIG  255                 /* code for absence-of-SIG              */
#define UPLTYPS 0x100              /* addend for upload protocol type codes*/
#define NPREVS   5                 /* previous-msg file pos's maintained   */
#define FSPSIZ  64                 /* filespec size (including the '\0')   */
 
struct esgusr {               /* esigs user data                           */
     long fpos;               /*   message file position                   */
     long prethr;             /*   fpos in effect b4 starting thread or cc:*/
     int keynum;              /*   key number in use                       */
     int pthkyn;              /*   key number in eff b4 starting thread    */
     FILE *fp;                /*   attachment/source file handle           */
     FILE *fpout;             /*   destination file handle when copying    */
     int fxftyp;              /*   file transfer method type code          */
     int blknum;              /*   block number in progress                */
     int lstsiz;              /*   DL: last block size UL: last byte count */
     long curpos;             /*   current position within download file   */
     int (*whndun)();         /*   esgutl when-done "return address"       */
     int ccount;              /*   carbon copy count toward maximum allowed*/
     char dftinp;             /*   default input letter if CR hit          */
     char usigno;             /*   SIG number that user is in, or NOSIG    */
     int sigtck;              /*   "ticks" (credits) per SIG msg in cursig */
     int sattck;              /*   "ticks" (credits) per upload in cursig  */
     char keywds[MXKWLN];     /*   keywords being searched for (input stg) */
     int sflags;              /*   run-time control flags                  */
     long prvpos[NPREVS];     /*   previous-message file positions         */
     int pvpidx;              /*   index position now active in prvpos[]   */
     struct message msg;      /*   esigs message data block                */
};
                              /* run-time control flags                    */
#define SCNNXT    1           /*   scan direction is forward ("next")      */
#define SCNCIS    2           /*   scan continuing in SIG (!starting anew) */
#define SCNQUI    4           /*   quickscan in progress                   */
#define SCNCIQ    8           /*   continuing quickscan (!first qs pass)   */
#define SCN4AT   16           /*   scanning for attachments (download)     */
#define SCN4UA   32           /*   scanning for unapproved attachments     */
#define SCNKWD   64           /*   scanning (searching) for keywords       */
#define SCN2LT  128           /*   scanning (listing) in 2-line-title mode */
#define SCNFTX  256           /*   scanning (listing) in full-text mode    */
#define CPYIPG  512           /*   file-copy operation in progress         */
#define NOPGBK 1024           /*   no-page-breaks in effect                */
#define RAFIPG 2048           /*   reply-after-forward in effect           */
 
#define esgptr ((struct esgusr *)vdaptr)    /* volatile data pointer casts */
#define esgarr(u) ((struct esgusr *)vdaoff(u))
 
extern
struct compos {               /* composite user-id/msg# for searches       */
     char userid[UIDSIZ];     /*   user-id to or from, or SIG name         */
     long msgno;              /*   message number                          */
} compos;
 
extern
struct sigdat {               /* ram-resident SIG data tables              */
     char sigop[UIDSIZ];      /*   User-ID of SIG-Op                       */
     char signam[UIDSIZ];     /*   SIG name                                */
     char descrp[TPCSIZ];     /*   SIG short description                   */
     char signo;              /*   SIG number                              */
     int  nmsgs;              /*   number of messages in the SIG           */
     int  nfiles;             /*   number of files in the SIG              */
     int  nw4app;             /*   number of files waiting for approval    */
} *sigdat,                    /* base ptr to dynamically allocated array   */
  *sdtptr;                    /* scratch ptr for scanning thru sigdat      */
 
extern
FILE *esgmb;                  /* esigs named-message file block ptr        */
extern
BTVFILE *esgbb,               /* esigs btrieve message file block ptr      */
        *qscbb;               /* esigs quickscan/config btrieve file ptr   */
extern
BTVFILE *accbb;               /* user account btrieve file block pointer   */
extern
long filen;                   /* length of attachment found, from opnatt() */
extern
int esgstt;                   /* current/new usrptr->substt hold register  */
extern
int msgbyts;                  /* maximum number of bytes in message texts  */
 
extern
char *accstg[];               /* names of access levels                    */
 
char *attfs(),                /* form attachment filespec for current msg  */
     *attfsd(),               /* form destination filespec for copy/fwd    */
     *attfsn(),               /* form attachment filespec name-only        */
     *formax(),               /* form auxillary topic phrase, using msg #  */
     *axtstg(),               /* aux topic string, suitable for "%s" fill  */
     *emlsig(),               /* string "E-Mail" or "SIG", dep'ing on cntxt*/
     *findkw(),               /* find quickscan keyword list in qscfg table*/
     *tpcfnm();               /* msg topic-located filename (or indirect)  */
 
struct qscfg *qscoff();       /* calculate a user's offset into qsarea     */
struct qscfg *getqsc();       /* get ptr to a user's config data           */
 
#define FOUND   1             /* return values for CYCLE-mediated activity */
#define KEEPON -1
#define DONE    0
 
/*--- OPTIONS FROM ESIGS.MSG ---*/
 
extern
int emllif,                   /* lifetime of an E-Mail message, in days    */
    nlveml,                   /* flag: may non-live users write E-Mail?    */
    nlveat,                   /* flag: may non-live users make attachments?*/
    nlvrrr,                   /* flag: may non-live users read RRR msgs?   */
    emltck,                   /* "ticks" (credits) eaten per E-Mail msg    */
    eattck,                   /* "ticks" (credits) eaten per attachment    */
    rrrtck,                   /* "ticks" (credits) eaten per return receipt*/
    ednaud,                   /* Do audit trail entry per E-Mail download? */
    eupaud;                   /* Do audit trail entry per E-Mail upload?   */
 
extern
int nsigs,                    /* number of SIGs allowed for                */
    sigccr,                   /* default SIG credit consumption rate       */
    siglif,                   /* default lifetime of a SIG message, in days*/
    sigtck,                   /* default "ticks" (credits) per SIG msg     */
    sattck,                   /* default "ticks" (credits) per file upload */
    sdnaud,                   /* Do audit trail entry per SIG download?    */
    supaud,                   /* Do audit trail entry per SIG upload?      */
    sopmhd,                   /* allow SIG-Ops to modify SIG headers?      */
    esgvda;                   /* max number of bytes required by email/sigs*/
 
extern
char dftsig[];                /* default SIG for new users etc.            */
 
/*--- Decide Email versus SIG ---*/
 
#define  either(x,y) (usrptr->state == EMLSTT ? (x) : (y)) /* E-Mail vs SIG */
#define meither(x,y) (esgptr->msg.to[0] != SIGIDC || esgptr->keynum == FROMNUM ? (x) : (y))
 
/*--- "Cleared" messages first char encode/decode macros ---*/
 
#define clrchr(x) (x-45 >= '*' ? x-44 : x-45)
#define uclchr(x) (x >= '0' ? x : (x > '*' ? x+44 : (x == '*' ? x : x+45)))
