/***************************************************************************
 *                                                                         *
 *   MAJORBBS.H                                                            *
 *                                                                         *
 *   Copyright (C) 1987-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the main Major BBS header file.                               *
 *                                                                         *
 *                                            - T. Stryker 6/24/86         *
 *                                                                         *
 ***************************************************************************/
 
#include "setjmp.h"
 
#define BBSVER        511     /* BBS underlying version code               */
 
#define NMODS1         20     /* first block of run-time modules supported */
#define NMODS2         30     /* second block of run-time modules supported*/
#define NMODS (NMODS1+NMODS2) /* number of run-time modules supported      */
#define INPSIZ        256     /* input buffer size for each channel        */
#define OUTSIZ     outbsz     /* config parameter: output buffer size/chan */
#define MTXSIZ        400     /* maximum message-text string size          */
#define DFTIMX        127     /* default input-char count maximum per line */
#define NCOMTY          8     /* number of computer type codes             */
#define NAGEBK          5     /* number of age brackets tallied            */
#define AUDSIZ         65     /* size of audit trail records               */
#define CTNUOS          2     /* screen length code used for "continuous"  */
 
struct user {                 /* volatile per-user info maintained         */
     int class;               /*    class (offline, or flavor of online)   */
     int state;               /*    state (module number in effect)        */
     int substt;              /*    substate (for convenience of module)   */
     int usetmr;              /*    usage timer (for nonlive timeouts etc) */
     int minut4;              /*    total minutes of use, times 4          */
     int countr;              /*    general purpose counter                */
     int pfnacc;              /*    profanity accumulator                  */
     int flags;               /*    runtime flags                          */
     unsigned baud;           /*    baud rate currently in effect          */
     int crdrat;              /*    credit-consumption rate                */
     int nlzapc;              /*    non-live forced zap counter            */
     int nazapc;              /*    no-activity auto-logoff counter        */
};
                                   /* user class codes                     */
#define VACANT 0                   /*    vacant, offline                   */
#define ONLINE 1                   /*    online, not logged on             */
#define SUPIPG 2                   /*    signup in progress                */
#define FRELOA 3                   /*    logged on and freeloading         */
#define PAYING 4                   /*    logged on and paying              */
 
                         /* VACANT class state codes:                      */
#define JSTRST   0       /* just reset, awaiting command confirmation      */
#define EMTATZ -10       /* emitting ATZ, awaiting completion              */
#define W4DLAY -11       /* waiting for 2-second delay after ATZ emitted   */
#define EKLVEC  -1       /* emitting kill-vector, awaiting completion      */
#define W4KILL  -2       /* waiting for kill-system to take effect         */
#define ESTVEC  -3       /* emitting startup string, awaiting completion   */
#define AWAITC  -4       /* awaiting call                                  */
#define XERING  -5       /* XE1201/3 phone rang, answered, awaiting carrier*/
#define HARING  -6       /* Hayes-style phone rang, answd, awaiting carrier*/
#define HPAUSE  -7       /* Hayes-style post-connect 2-second pause        */
#define ASKANS  -8       /* asking user whether wants ANSI or not          */
#define AUTANS  -9       /* auto-determining whether user has ANSI or not  */
#define WAIT29 -20       /* wait to be able to send X.29 string            */
 
                                   /* standard profanity thresholds        */
#define WRNPFN 7                   /*    warning level                     */
#define MAXPFN 12                  /*    logoff level                      */
 
                                   /* user runtime flag bit values         */
#define NOINJO 1                   /*    unable to receive injoth() msgs   */
#define INJOIP 2                   /*    injoth() operation in progress    */
#define BYEBYE 4                   /*    going away, just wait for msg done*/
#define NOHDWE 8                   /*    no hardware, emulation chan only  */
#define OPCHAT 16                  /*    chatting-with-sysop flag          */
#define ACTIVE 32                  /*    channel-is-active (gen'ing status)*/
#define ISYSOP 64                  /*    user-is-Sysop flag                */
#define IS2698 128                 /*    channel-is-2698 (XE2400)          */
#define NOZAP  256                 /*    don't logoff freeloader flag      */
#define ISRIAL 1024                /*    channel-is-serial-port            */
#define X2MAIN 2048                /*    exit-to-main-menu when sysop chat */
#define CONCEX 4096                /*    commands concatenated -- exit fast*/
#define ISX25  8192                /*    channel-is-X.25                   */
#define NOGLOB 16384               /*    don't interpret global commands   */
 
#define RING   1              /* btusts() return for ringing/lost carrier  */
#define CMDOK  2              /* btusts() return for command completed ok  */
#define CRSTG  3              /* btusts() return for CR-term'd string avail*/
#define INBLK  4              /* btusts() return for count-trg input avail */
#define OUTMT  5              /* btusts() return for output buffer empty   */
#define LOST2C 11             /* btusts() return for 2400 baud lost-carrier*/
#define CMN2OK 12             /* btusts() return for 2400 baud cmd complete*/
#define LOST25 21             /* btusts() return for X.25 lost-carrier     */
#define CM25OK 22             /* btusts() return for X.25 cmd complete     */
#define INAPP 'I'             /* Inappropriate status (fm ^H cmd if 300bd) */
 
#define CLOX29       230      /* btux29() call produced window-full error  */
#define ERRX29       231      /* btux29() produced some other fatal error  */
 
#define CYCLE        240      /* cycle-thru-other-users pseudo-status code */
#define RELOG        241      /* re-log-in pseudo-status code              */
 
extern
struct module {                    /* module interface block               */
     char select;                  /*    main menu select character        */
     char *descrp;                 /*    description for main menu         */
     int (*inirou)();              /*    system initialization routine     */
     int (*lonrou)();              /*    user logon supplemental routine   */
     int (*sttrou)();              /*    input routine if selected         */
     int (*stsrou)();              /*    status-input routine if selected  */
     int (*huprou)();              /*    hangup (lost carrier) routine     */
     int (*mcurou)();              /*    midnight cleanup routine          */
     int (*dlarou)();              /*    delete-account routine            */
     int (*finrou)();              /*    finish-up (sys shutdown) routine  */
} *module[NMODS];
 
struct sysvbl {                    /* system-variable btrieve record layout*/
     char key[4];                  /*    4-character dummy key of "key"    */
     int dspopt[3];                /*    display options by position number*/
     unsigned numero;              /*    message-number counter            */
     unsigned numact;              /*    number of user accounts total     */
     unsigned numpai;              /*    number of paying accounts         */
     long usedytd;                 /*    "tickies" used year-to-date       */
     long liveytd;                 /*    live "tickies" used year-to-date  */
     long usedmtd;                 /*    "tickies" used month-to-date      */
     long livemtd;                 /*    live "tickies" used month-to-date */
     long useddtd;                 /*    "tickies" used day-to-date        */
     long livedtd;                 /*    live "tickies" used day-to-date   */
     long paidytd;                 /*    "tickies" paid-for year-to-date   */
     long paidmtd;                 /*    "tickies" paid-for month-to-date  */
     long paiddtd;                 /*    "tickies" paid-for day-to-date    */
     char lonmsg[MTXSIZ];          /*    log-on message in effect          */
     unsigned numfre;              /*    number of free sample accounts    */
     unsigned numdem;              /*    number of "demo" live accounts    */
     unsigned numfem;              /*    number of female accounts         */
     unsigned numcor;              /*    number of corporate accounts      */
     long dwnlds;                  /*    total downloads to date           */
     long uplds;                   /*    total uploads to date             */
     long ctdtot;                  /*    total calls-to-date               */
     long ctdpai;                  /*    paid calls-to-date                */
     long msgtot;                  /*    msg (e-mail/SIGs) total to date   */
     long csitot;                  /*    Classified ads total to date      */
     unsigned emlopn;              /*    E-Mail open at the moment         */
     unsigned csiopn;              /*    classified ads open at the moment */
     unsigned sigopn;              /*    SIG messages open at the moment   */
     unsigned numans;              /*    number of ANSI-capable accounts   */
     int hisign;                   /*    highest SIG number used to date   */
     char spare[504-494];          /*    spare space, decrease when adding */
};
 
struct sysvb2 {                    /* second system variable btrieve layout*/
     char ky2[4];                  /*    4-character dummy key of "ky2"    */
     unsigned matrix[NCOMTY][NAGEBK];   /*   matrix of accts (computer/age)*/
     long moduse[NMODS1];          /*    array of module use (in minutes)  */
     long modliv[NMODS1];          /*    array of live module use (in mins)*/
     long x25kps;                  /*    X.25 kilopackets sent or received */
     unsigned x25ps;               /*    fractional X.25 kilopackets       */
     long x25mbs;                  /*    X.25 megabytes sent or received   */
     long x25bs;                   /*    fractional X.25 megabytes         */
     long moduse2[NMODS2];         /*    second array of module use        */
     long modliv2[NMODS2];         /*    second array of live module use   */
     char spare[504-498];          /*    spare space, decrease when adding */
};
 
extern
int nterms,                   /* this many simultaneous users are supported*/
    hichp1,                   /* highest channel number in use, plus 1     */
    usrnum,                   /* global user-number (channel) in effect    */
    othusn,                   /* general purpose other-user channel number */
    uisusn;                   /* uinsys() other-user channel number        */
extern
struct user *user,            /* user volatile-data structure array        */
            *usrptr,          /* global pointer to user data in effect     */
            *othusp;          /* gen purp other-user user structure ptr    */
extern
int *channel;                 /* array of channel codes (as displayed)     */
extern
char input[INPSIZ],           /* raw user input data buffer                */
     *margv[INPSIZ/2],        /* array of ptrs to word starts, a la argv[] */
     *margn[INPSIZ/2],        /* array of ptrs to word ends, for rstrin()  */
     *nxtcmd;                 /* pointer to next char for command concat.  */
extern
int margc,                    /* number of words in margv[], a la argc     */
    inplen,                   /* overall raw input string length           */
    pfnlvl,                   /* profanity level of current input (0-3)    */
    status,                   /* raw status from btusts, where appropriate */
    numcat;                   /* number of concat'd commands so far        */
 
extern
jmp_buf eximod;               /* exit-module longjmp save block            */
 
extern
struct sysvbl sv;             /* sys-variables record instance for updates */
extern
struct sysvb2 sv2;            /* 2nd sys-vbl record instance for updates   */
#define PFBSIZ 2001           /* size of prf buffer                        */
extern
char prfbuf[PFBSIZ],          /* buffer used by prfutl, used for staging   */
    *prfptr;                  /* pointer used as prfbuf placeholder        */
extern
int vdasiz;                   /* max. size requirement of volatile data    */
extern
char huge *vdarea;            /* volatile data area                        */
extern
char      *vdaptr,            /* user's pointer to volatile data area      */
          *vdatmp,            /* general-purpose temporary vda-size area   */
          *vdaoff();          /* vdaptr calculation routine                */
 
long atol(),
     lngopt(),
     cnclon();
char cncchr(),
     cncyesno(),
     morcnc();
char *ltoa(),
     *spr(),
     *getin(),
     *alcmem(),
     *getmsg(),
     *stgopt(),
     *cncuid(),
     *cncall(),
     *sigtpc();
FILE *opnmsg();
 
extern
char *bbsttl,                 /* Title of your BBS                          */
     *company,                /* Your company name                          */
     *addres1,                /* Address                                    */
     *addres2,                /* Address                                    */
     *city,                   /* Your city (again)                          */
     *dataph,                 /* The first phone line connected to BBS      */
     *liveph,                 /* The first phone line reserved 4 live users */
     *chghour,                /* Connect time charge per hour               */
     *chgmin,                 /* Minimum charge                             */
     *chgtime;                /* Minimum connect time                       */
extern
int outbsz,                   /* output buffer size per channel             */
    mmucrr,                   /* Main menu credit consumption rate per min  */
    emubel,                   /* emulation bell period                      */
    digalw,                   /* digits allowed in User-IDs?               */
    rsmode,                   /* reset-mode code for channels               */
    *rsmodes,                 /* reset-mode array by channel number         */
#define NORMRS 0              /*   normal reset                             */
#define BUSYRS 'B'            /*   busy-out                                 */
#define NANSRS 'N'            /*   no-answer                                */
    vispsw,                   /* make passwords visible in detail displays? */
    maxcat;                   /* maximum number of concat'd commands        */
extern
char eurmsk;                  /* 0x7F if U.S.A. only, 0xFF if European      */
 
