/***************************************************************************
 *                                                                         *
 *   EDITOR.C                                                              *
 *                                                                         *
 *   Copyright (C) 1988-1990 GALACTICOMM, Inc.   All Rights Reserved.      *
 *                                                                         *
 *   This is the general-purpose editor for use with e-mail, sigs, etc.    *
 *                                                                         *
 *                               - T. Stryker & D. Arnel 7/12/88           *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "majorbbs.h"
#include "usracc.h"
#include "portable.h"
#include "editor.h"
 
static
int  newstt;                  /* new sub-state returned                    */
 
static
struct edtusr {
     char *topic;             /* Pointer to topic buffer                   */
     int tpcsiz;              /* Max size of topic field + 1               */
     char *txtbuf;            /* pointer to text buffer                    */
     int substt;              /* editor sub-state                          */
     int txtsiz;              /* size of current allowable text buffer + 1 */
     int txtlen;              /* cumulative length of current text buffer  */
     int nlines;              /* number of lines processed                 */
     int curlin;              /* line currently being edited               */
     int rpclen;              /* length of line to replace                 */
     int crllen;              /* target line length                        */
     int flags;               /* misc. editor use flags                    */
     int (*imradr)();         /* ptr to import-message routine in effect   */
     char *begstg;            /* start of current line being edited        */
     char *endstg;            /* end of current line being edited          */
} *edtusr,                    /* pointer to array of users' editor data    */
  *edtptr;                    /* pointer to current user data              */
 
                              /* edtptr->flags values                      */
#define INSERT 1              /*   insert mode                             */
#define CHGTPC 2              /*   changing topic line                     */
#define FLFLVR 4              /*   file flavor of messages in effect       */
 
#define CONEDT 0              /* continue editing return value             */
#define SAVEDT 1              /* end editing and save message return value */
 
extern FILE *curmbk;          /* current message block pointer             */
 
static
FILE *edtmb,                  /* pointer to editor message block           */
     *edfmb,                  /* pointer to file description editor msg blk*/
     *savmb;                  /* msg block pointer saved on editor entry   */
 
iniedt()                      /* initialize editor for use                 */
{
     edtmb=opnmsg("editor.mcv");
     edfmb=opnmsg("editfl.mcv");
     edtusr=(struct edtusr *)alcmem(nterms*sizeof(struct edtusr));
}
 
edtimr(imradr)                /* set import routine address for curr user  */
int (*imradr)();
{
     edtusr[usrnum].imradr=imradr;
}
 
dunedt()                      /* main editor handler/ MajorBBS interface   */
{
     long mno,cnclon();
     int (*temp)();
 
     savmb=curmbk;
     edtptr=&edtusr[usrnum];
     setmbk((edtptr->flags&FLFLVR) ? edfmb : edtmb);
     newstt=edtptr->substt;
     do {
          bgncnc();
          switch (newstt) {
          case 0:
               bgnmsg();
               break;
          case GETTPC:
               if (margc == 0) {
                    errmsg(GETTPC,edtptr->tpcsiz-1);
               }
               else {
                    strncpy(edtptr->topic,cncall(),edtptr->tpcsiz-1);
                    if (edtptr->flags&CHGTPC) {
                         edtpmt();
                         btumil(usrnum,(usaptr->scnwid-1));
                    }
                    else {
                         errmsg(newstt=ENTTXT,edtptr->txtsiz-1);
                         smargn();
                    }
               }
               break;
          case INSLIN:
          case ENTTXT:
               return(procln());
          case EDPWKS:
          case EDTPMT:
          case EDTPMTWT:
               if (hdlecm()) {
                    return(SAVEDT);
               }
               break;
          case HLPWKS:
               hdlhcm();
               break;
          case RWCHLN:
               vldlin(REPLAC);
               break;
          case EWCHLN:
               vldlin(EDITLN);
               break;
          case DWCHLN:
               vldlin(DELLIN);
               break;
          case IWCHLN:
               vldlin(INSLIN);
               break;
          case REPLAC:
               rplcwt();
               break;
          case RPLCWW:
               rplctx();
               break;
          case EDITLN:
               edtptr->rpclen=edtptr->crllen;
               rplctx();
               break;
          case DELLIN:
               dellin();
               break;
          case NUSURB:
               if ((mno=cnclon()) != 0) {
                    if ((*(edtptr->imradr))(mno)) {
                         lstlns(0);
                         edtpmt();
                         break;
                    }
                    errmsg(IMPNF2);
               }
          case CUSURB:
               switch (cncchr()) {
               case 'C':
                    temp=edtptr->imradr;
                    if (edtptr->flags&FLFLVR) {
                         edtptr->tpcsiz=-edtptr->tpcsiz;
                    }
                    strtov(1,edtptr->txtsiz,edtptr->txtbuf,edtptr->tpcsiz,
                         edtptr->topic);
                    edtptr->imradr=temp;
                    bgnmsg();
                    break;
               case 'N':
                    cncall();
                    edtpmt();
                    break;
               default:
                    errmsg(newstt);
               }
               break;
          default:
               catastro("EDITOR SUBSTT ERROR");
          }
     } while (!endcnc());
     rtfedt();
     return(CONEDT);
}
 
rtfedt()                      /* prepare to return from editor to caller   */
{
     outprf(usrnum);
     edtptr->substt=newstt;
     rstmbk();
}
 
rstmbk()                      /* set message block back to caller's mb     */
{
     cncall();
     clrprf();
     prf("");
     setmbk(savmb);
}
 
edtmnu()                      /* display editor menu (w/ or w/o topic)     */
{
     prfmsg(msgtpc() ? EDTMNUWT : EDTMNU);
     edtptr->flags&=~INSERT;
     prfmsg(newstt=EDPWKS);
}
 
edtpmt()                      /* display editor prompt (w/ or w/o topic)   */
{
     edtptr->flags&=~INSERT;
     prfmsg(newstt=(msgtpc() ? EDTPMTWT : EDTPMT));
}
 
hlpmnu()                      /* display editor help (w/ or w/o topic)     */
{
     prfmsg(msgtpc() ? HLPAVLWT : HLPAVL);
     prfmsg(newstt=HLPWKS);
}
 
procln()                      /* process line while entering message text  */
{
     cncall();
     if (input[0] == '\0') {
          prfmsg(CNTENT);
     }
     else if (margc == 1 && sameas(margv[0],"ok")) {
          btumil(usrnum,(usaptr->scnwid-1));
          edtmnu();
     }
     else if (margc == 1 && (sameas(margv[0],".s") || sameas(margv[0],"/s"))) {
          btumil(usrnum,DFTIMX);
          return(savit());
     }
     else {
          apndtx();
          if (morspc()) {
               rstmbk();
               return(CONEDT);
          }
     }
     rtfedt();
     return(CONEDT);
}
 
morspc()                      /* check for more space left in message      */
{
     if ((edtptr->txtsiz-1)-edtptr->txtlen < DFTIMX) {
          prfmsg(TOOBIG);
          edtmnu();
          return(0);
     }
     return(1);
}
 
static
smargn()                      /* set margin to 72 if 80-column screen      */
{
     btumil(usrnum,usaptr->scnwid == 79 || usaptr->scnwid == 80 ? -72 :
          -(usaptr->scnwid-1));
}
 
hdlecm()                      /* editor menu command handler               */
{
     char c;
 
     if (margc == 0) {
          edtmnu();
     }
     else {
          switch (c=cncchr()) {
          case 'S':
               return(savit());
          case 'A':
               if (morspc()) {
                    errmsg(CNTENT);
                    newstt=ENTTXT;
                    smargn();
               }
               break;
          case 'L':
               lstlns(1);
               edtpmt();
               break;
          case 'C':
               prfmsg(newstt=RWCHLN,edtptr->nlines);
               break;
          case 'R':
               prfmsg(newstt=EWCHLN,edtptr->nlines);
               break;
          case 'D':
               prfmsg(newstt=DWCHLN,edtptr->nlines);
               break;
          case 'I':
               if (morspc()) {
                    prfmsg(newstt=IWCHLN,edtptr->nlines);
               }
               break;
          case 'N':
               prfmsg(newstt=(edtptr->imradr == NULL ? CUSURB : NUSURB));
               break;
          case 'H':
               if (sameto("help",margv[0])) {
                    nxtcmd+=3;
               }
               hlpmnu();
               break;
          case '?':
               edtmnu();
               break;
          case 'T':
          case 'F':
               if (msgtpc()) {
                    bgntpc();
                    edtptr->flags|=CHGTPC;
                    break;
               }
          default:
               errmsg(CNOTIL,c);
               edtmnu();
          }
     }
     return(CONEDT);
}
 
bgnmsg()                           /* begin a message                      */
{
     if (msgtpc() && edtptr->topic[0] == '\0') {
          bgntpc();
     }
     else {
          errmsg(newstt=ENTTXT,edtptr->txtsiz-1);
          smargn();
     }
}
 
bgntpc()                           /* enter topic for message              */
{
     prfmsg(newstt=GETTPC,edtptr->tpcsiz-1);
     btumil(usrnum,edtptr->tpcsiz-1);
}
 
hdlhcm()                           /* editor help menu command handler     */
{
     static char hlpsub[]={"SALCRDINTFQ"};
     static int hlpmsn[]={
          HLPSAV,HLPAPP,HLPLIS,HLPCHG,HLPRTY,
          HLPDEL,HLPINS,HLPNEW2,HLPTPC,HLPTPC,HLPQUT
     };
     int i,c;
 
     c=cncchr();
     cncall();
     for (i=0 ; i < sizeof(hlpsub)-1 ; i++) {
          if (c == hlpsub[i]) {
               errmsg(hlpmsn[i]);
               edtpmt();
               return;
          }
     }
     hlpmnu();
}
 
savit()                            /* save message utility                 */
{
     rstmbk();
     return(SAVEDT);
}
 
rplcwt()                           /* change text function                 */
{
     char *inword();
 
     cncall();
     if (input[0] == '\0') {
          prfmsg(REPLAC);
     }
     else {
          if ((edtptr->begstg=inword(input,edtptr->begstg)) != NULL) {
               edtptr->rpclen=inplen;
               prfmsg(newstt=RPLCWW);
          }
          else {
               prfmsg(NOMCHF);
               edtpmt();
          }
          rstrln();
     }
}
 
char *inword(stg1,stg2)            /* change text of stg2 with stg1   */
char *stg1,*stg2;
{
     int i,lw;
 
     lw=strlen(stg1);
     for (i=strlen(stg2) ; i >= lw ; stg2++,i--) {
          if (sameto(stg1,stg2)) {
               return(stg2);
          }
     }
     return(NULL);
}
 
dellin()                           /* delete a line function               */
{
     switch (cncyesno()) {
     case 'Y':
          edtptr->rpclen=edtptr->crllen+1;
          if (edtptr->curlin == edtptr->nlines) {
               edtptr->begstg-=1;
          }
          inplen=0;
          rplctx();
          lstlns(0);
          break;
     case 'N':
          edtpmt();
          break;
     default:
          errmsg(YORN);
          prfmsg(DELLIN);
     }
}
 
chk4nl(msg,parm)                   /* check for null entry, re-echo prompt */
int msg;
long parm;
{
     if (margc == 0) {
          prfmsg(msg,parm);
          return(1);
     }
     return(0);
}
 
apndtx()                           /* append or insert new text            */
{
     if (edtptr->flags&INSERT) {
          insttx();
     }
     else {
          edtptr->txtbuf[edtptr->txtlen++]='\r';
          strcpy(&(edtptr->txtbuf[edtptr->txtlen]),input);
          edtptr->txtlen+=inplen;
          edtptr->nlines+=1;
     }
}
 
insttx()                           /* inserts text into current message    */
{
     movmem(edtptr->begstg,&(edtptr->begstg[inplen+1]),
            strlen(edtptr->begstg)+1);
     movmem(input,edtptr->begstg,inplen);
     edtptr->begstg[inplen]='\r';
     edtptr->txtlen+=inplen+1;
     edtptr->nlines+=1;
     edtptr->curlin+=1;
     extlin();
     rstrln();
}
 
lstlns(shwlines)              /* calculates text info (may also show text) */
int shwlines;
{
     char *mptr,*linptr;
     int lineno,tmpchr;
 
     if (shwlines) {
          prf("\r");
          if (msgtpc()) {
               prf((edtptr->flags&FLFLVR) ? "File: %s\r\r" : "Topic: %s\r\r",
                    edtptr->topic);
          }
     }
     for (lineno=1,mptr=&(edtptr->txtbuf[1]) ; *mptr != '\0' ; ) {
          for (linptr=mptr ; *linptr != '\r' && *linptr != '\0' ; linptr++) {
          }
          tmpchr=*linptr;
          *linptr='\0';
          if (shwlines) {
               prf("%02d: %s\r",lineno,mptr);
               outprf(usrnum);
          }
          lineno+=1;
          if ((*linptr=tmpchr) == '\0') {
               break;
          }
          mptr=linptr+1;
     }
     edtptr->nlines=lineno-1;
     edtptr->txtlen=strlen(edtptr->txtbuf);
}
 
extlin()                           /* extract a specified line from text   */
{
     int lineno;
     char *bstg,*estg;
 
     for (lineno=1,bstg=&(edtptr->txtbuf[1]) ; *bstg != '\0' ; lineno++) {
          for (estg=bstg ; *estg != '\r' && *estg != '\0' ; estg++) {
          }
          if (lineno == edtptr->curlin) {
               *estg='\0';
               edtptr->crllen=strlen(bstg);
               break;
          }
          if (*estg == '\0') {
               break;
          }
          bstg=estg+1;
     }
     edtptr->begstg=bstg;
     edtptr->endstg=estg;
}
 
vldlin(msg)                        /* check for a valid line number        */
int msg;
{
     int lineno;
 
     if (!chk4nl(newstt,edtptr->nlines)) {
          if ((lineno=cncint()) > 0 && lineno <= edtptr->nlines) {
               edtptr->curlin=lineno;
               extlin();
               if (newstt != IWCHLN) {
                    prfmsg(CRLRDS,edtptr->curlin,edtptr->begstg);
               }
               else {
                    edtptr->flags|=INSERT;
                    smargn();
               }
               prfmsg(newstt=msg);
               rstrln();
               return(1);
          }
          else {
               cncall();
               prfmsg(INVLIN);
               edtpmt();
          }
     }
     return(0);
}
 
rplctx()                           /* replace re-typed line into message   */
{
     int nll;
     int ovrflo=0;
 
     cncall();
     if ((nll=(edtptr->crllen-edtptr->rpclen)+inplen) > DFTIMX) {
          prfmsg(ovrflo=LINOVR);
          inplen-=nll-DFTIMX;
          nll=DFTIMX;
          input[inplen]='\0';
     }
     if ((edtptr->txtlen-edtptr->crllen)+nll >= edtptr->txtsiz-1) {
          if (!ovrflo) {
               prfmsg(LINOVR);
          }
          inplen-=((edtptr->txtlen-edtptr->crllen)+nll)-(edtptr->txtsiz-1);
          input[inplen]='\0';
     }
     if (inplen > edtptr->rpclen) {
          movmem(edtptr->begstg,&(edtptr->begstg[inplen-edtptr->rpclen]),
                          strlen(edtptr->begstg)+1);
          edtptr->txtlen+=inplen-edtptr->rpclen;
     }
     movmem(input,edtptr->begstg,inplen);
     if (inplen < edtptr->rpclen) {
          movmem(&(edtptr->begstg[edtptr->rpclen]),&(edtptr->begstg[inplen]),
               strlen(edtptr->begstg+edtptr->rpclen)+1);
          edtptr->txtlen-=edtptr->rpclen-inplen;
          setmem(&(edtptr->txtbuf[edtptr->txtlen]),edtptr->rpclen-inplen,0);
     }
     if (newstt == RPLCWW) {
          extlin();
          prfmsg(NLNRDS,edtptr->curlin,edtptr->begstg);
          rstrln();
     }
     edtpmt();
}
 
rstrln()                           /* restores line after extlin()         */
{
     *(edtptr->endstg)=(edtptr->curlin == edtptr->nlines ? '\0' : '\r');
}
 
static
errmsg(msgn,parm)                  /* display error message utility        */
int msgn;
long parm;
{
     prfmsg(msgn,parm);
     cncall();
}
 
bgnedt(clr,siz,buf,tsiz,topic)     /* begin editing a message              */
int clr;                           /*   0=keep (edit) everything           */
                                   /*   1=clear everything, accept new     */
                                   /*   2=clear msg, keep (editable) topic */
int siz,tsiz;
char *buf,*topic;
{
     edtptr=&edtusr[usrnum];
     strtov(clr,siz,buf,tsiz,topic);
     endcnc();
     dunedt();
}
 
strtov(clr,siz,buf,tsiz,topic)     /* start editing a message over again   */
int clr;
int siz,tsiz;
char *buf,*topic;
{
     setmem(edtptr,sizeof(struct edtusr),0);
     edtptr->txtbuf=buf;
     edtptr->txtsiz=siz;
     edtptr->topic=topic;
     if (tsiz < 0) {
          tsiz=-tsiz;
          edtptr->flags|=FLFLVR;
     }
     edtptr->tpcsiz=tsiz;
     if (clr != 0) {
          setmem(buf,siz,0);
          if (clr != 2 && msgtpc()) {
               setmem(topic,tsiz,0);
          }
     }
     else {
          lstlns(0);
          edtpmt();
          edtptr->substt=newstt;
     }
}
 
msgtpc()                           /* does the message have a topic?       */
{
     return(edtptr->topic != NULL);
}
 
clsedt()                           /* close editor files for shutdown      */
{
     clsmsg(edtmb);
}
