/***************************************************************************
 *                                                                         *
 *   ECBTVSTF.C                                                            *
 *                                                                         *
 *   Copyright (C) 1987,1988,1990 GALACTICOMM, Inc.  All Rights Reserved.  *
 *                                                                         *
 *   This file contains a library of routines for accessing BTRIEVE files  *
 *   with fixed or variable length records, compatible with the Eclipse    *
 *   DOS extender protected mode environment.                              *
 *                                                                         *
 *                                            - T. Stryker 3/7/90          *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "setjmp.h"
#include "btvstf.h"
#include "portable.h"
 
long _maxheapsize=65536L;     /* allocate mem direct from DOS in prot mode */
 
extern
jmp_buf disaster;             /* master error-recovery longjmp save block  */
 
static struct btvblk *bb;     /* current btv file pointer set              */
static char *gpbptr;          /* general purpose buffer pointer            */
static int gpbseg;            /* real-mode segment of the above            */
static int *statusptr;        /* status code returned by btvu()            */
static int statusseg;         /* real-mode segment of the above            */
static int status;            /* value pointed to by statusptr             */
static int bbomode=PRIMBV;    /* opnbtv() file-open mode                   */
 
struct filspc {               /* Btrieve STAT command file spec            */
     int reclen;
     int pagsiz;
     int numofx;
     long numofr;
     int flags;
     int reserved;
     int unupag;
};
 
struct keyspc {               /* Btrieve STAT command key specs            */
     int keypos;
     int keylen;
     int flags;
     long numofk;
     int dontcare;
     long reserved;
};
#define ANOSEG  0x10          /* keyspc.flags bit for key has another seg  */
 
struct statbf {               /* STAT command ret buf layout               */
     struct filspc fs;
     struct keyspc ks[SEGMAX];
     char altcol[265];
};
 
static
struct btvdat {   /* btrieve parameter block structure for use with INT 0x7B */
     int datbufoff;
     int datbufseg;
     int dbflen;
     int posp38off;
     int posp38seg;
     int posblkoff;
     int posblkseg;
     int funcno;
     int keyoff;
     int keyseg;
     char keylen;
     char keyno;
     int statptoff;
     int statptseg;
     int magic;
} *btvdatptr;
static int btvdatseg;              /* real-mode segment of the above       */
 
struct msb {                       /* "machine state block"                */
     int ax,bx,cx,dx;              /*    (registers for eclint())          */
     int flags;
     int si,di,ds,es;
};
 
char *
eclalcrem(size)                    /* allocate real-mode dynamic memory    */
int size;                          /*   (make both real seg and selector)  */
{
     char *retval,*eclralloc();
 
     if ((retval=eclralloc(size)) == NULL) {
          catamsg("REAL-MODE MEMORY POOL EXHAUSTED");
          longjmp(disaster,2);
     }
     return(retval);
}
 
struct btvblk *
opnbtv(filnam,maxlen)              /* open a Btrieve file; return ptr.*/
char *filnam;
int maxlen;
{
     char *alcmem();
 
     if (statusptr == NULL) {
          statusptr=(int *)eclalcrem(sizeof(int));
          statusseg=eclrealseg();
          btvdatptr=(struct btvdat *)eclalcrem(sizeof(struct btvdat));
          btvdatseg=eclrealseg();
     }
     bb=(struct btvblk *)eclalcrem(sizeof(struct btvblk));
     bb->realseg=eclrealseg();
     bb->filnam=alcmem(strlen(filnam)+1);
     strcpy(bb->filnam,filnam);
     bb->reclen=maxlen;
     bb->data=eclalcrem(maxlen);
     bb->dataseg=eclrealseg();
     maksur(strlen(filnam+1));
     strcpy(gpbptr,filnam);
     if (btvu(0,0,gpbseg,bbomode,bb->reclen) != 0) {
          btverr("OPEN");
     }
     bb->key=eclalcrem(clckln());
     bb->keyseg=eclrealseg();
     return(bb);
}
 
#define GPBP ((struct statbf *)gpbptr)
 
clckln()                      /* calculate all key lengths in curr file    */
{                             /*   (and return the max of them all)        */
     static int kbfseg=0;
     int i,keyno,klen,maxofa;
 
     if (kbfseg == 0) {
          eclalcrem(64);
          kbfseg=eclrealseg();
     }
     maksur(sizeof(struct statbf));
     if (btvu(15,gpbseg,kbfseg,0,sizeof(struct statbf)) != 0) {
          btverr("STAT");
     }
     maxofa=0;
     for (i=0,keyno=0 ; keyno < GPBP->fs.numofx ; i++,keyno++) {
          klen=GPBP->ks[i].keylen;
          while (GPBP->ks[i].flags&ANOSEG) {
               klen+=GPBP->ks[++i].keylen;
          }
          bb->keylns[keyno]=klen;
          if (klen > maxofa) {
               maxofa=klen;
          }
     }
     return(maxofa);
}
 
maksur(size)                  /* make sure that gen purp buff is big enough*/
int size;
{
     static int gpbsiz=0;
 
     if (size > gpbsiz) {
          if (gpbsiz > 0) {
               free(gpbptr);
          }
          gpbptr=eclalcrem(size);
          gpbseg=eclrealseg();
          gpbsiz=size;
     }
}
 
omdbtv(mode)                  /* set opnbtv() file-open mode               */
int mode;
{
     bbomode=mode;
}
 
setbtv(bbptr)                 /* set a Btrieve data block for use          */
struct btvblk *bbptr;
{
     bb=bbptr;
}
 
qrybtv(key,keynum,qryopt)     /* query Btrieve operations utility          */
char *key;
int keynum;
int qryopt;
{
     if (bb == NULL) {
          return(0);
     }
     if (key != NULL) {
          movmem(key,bb->key,bb->keylns[keynum]);
     }
     if (keynum < 0) {
          keynum=bb->lastkn;
     }
     else {
          bb->lastkn=keynum;
     }
     if (btvu(qryopt,0,bb->keyseg,keynum,bb->reclen) != 0) {
          if (status == 4 || status == 9) {
               return(0);
          }
          btverr("QUERY");
     }
     return(1);
}
 
qnpbtv(getopt)                /* query next/previous Btrieve utility       */
int getopt;
{
     if (bb == NULL) {
          return(0);
     }
     if (btvu(getopt-50,bb->dataseg,bb->keyseg,bb->lastkn,bb->reclen) != 0) {
          if (status == 4 || status == 9) {
               return(0);
          }
          posbtverr(NULL,"QUERY-NP");
     }
     return(1);
}
 
getbtv(recptr,key,keynum,getopt)   /* get Btrieve operations utility       */
char *recptr;
char *key;
int keynum;
int getopt;
{
     int recseg;
 
     if (bb == NULL) {
          return;
     }
     if (recptr == NULL) {
          recseg=bb->dataseg;
     }
     else {
          maksur(bb->reclen);
          recseg=gpbseg;
     }
     if (key != NULL && bb != NULL) {
          movmem(key,bb->key,bb->keylns[keynum]);
     }
     if (keynum < 0) {
          keynum=bb->lastkn;
     }
     else {
          bb->lastkn=keynum;
     }
     if (btvu(getopt,recseg,bb->keyseg,keynum,bb->reclen) != 0) {
          posbtverr(recptr,"GET");
     }
     if (recptr != NULL) {
          movmem(gpbptr,recptr,btvdatptr->dbflen);
     }
}
 
static
posbtverr(recptr,stg)              /* possible btrieve error               */
char *recptr,*stg;                 /*  (don't crash on overflow, truncate) */
{
     if (status != 22) {
          btverr(stg);
     }
     if (recptr == NULL) {
          bb->data[bb->reclen-1]='\0';
     }
     else {
          gpbptr[bb->reclen-1]='\0';
     }
     status=0;
}
 
obtbtv(recptr,key,keynum,obtopt)   /* "acquire" Btrieve operations utiltiy */
char *recptr;
char *key;
int keynum;
int obtopt;
{
     int recseg;
 
     if (bb == NULL) {
          return(0);
     }
     if (recptr == NULL) {
          recseg=bb->dataseg;
     }
     else {
          maksur(bb->reclen);
          recseg=gpbseg;
     }
     if (key != NULL && bb != NULL) {
          movmem(key,bb->key,bb->keylns[keynum]);
     }
     if (keynum < 0) {
          keynum=bb->lastkn;
     }
     else {
          bb->lastkn=keynum;
     }
     if (btvu(obtopt,recseg,bb->keyseg,keynum,bb->reclen) != 0) {
          if (status == 4 || status == 9) {
               return(0);
          }
          posbtverr(recptr,"OBTAIN");
     }
     if (recptr != NULL) {
          movmem(gpbptr,recptr,btvdatptr->dbflen);
     }
     return(1);
}
 
anpbtv(recptr,anpopt)         /* "acquire" next/previous Btrieve utility   */
char *recptr;
int anpopt;
{
     if (bb == NULL) {
          return(0);
     }
     movmem(bb->key,bb->data,bb->keylns[bb->lastkn]);
     if (obtbtv(recptr,NULL,-1,anpopt) && strcmp(bb->data,bb->key) == 0) {
          return(1);
     }
     return(0);
}
 
long
absbtv()                      /* return current Btrieve file position      */
{
     if (bb == NULL) {
          return(0L);
     }
     maksur(sizeof(long));
     if (btvu(22,gpbseg,0,0,sizeof(long)) != 0) {
          posbtverr(gpbptr,"ABSOLUTE");
     }
     return(*(long *)gpbptr);
}
 
gabbtv(recptr,abspos,keynum)  /* get Btrieve record from a file position   */
char *recptr;
long abspos;
int keynum;
{
     if (bb == NULL) {
          return;
     }
     if (!aabbtv(recptr,abspos,keynum)) {
          btverr("GET-ABSOLUTE");
     }
}
 
aabbtv(recptr,abspos,keynum)  /* "acquire" a record from a file position   */
char *recptr;
long abspos;
int keynum;
{
     int recseg;
 
     if (bb == NULL) {
          return(0);
     }
     if (recptr == NULL) {
          recseg=bb->dataseg;
          *(long *)(bb->data)=abspos;
     }
     else {
          maksur(bb->reclen);
          recseg=gpbseg;
          *(long *)gpbptr=abspos;
     }
     bb->lastkn=keynum;
     btvu(23,recseg,bb->keyseg,keynum,bb->reclen);
     if (status == 22) {
          if (recptr == NULL) {
               bb->data[bb->reclen-1]='\0';
          }
          else {
               gpbptr[bb->reclen-1]='\0';
          }
          status=0;
     }
     if (status == 0 && recptr != NULL) {
          movmem(gpbptr,recptr,btvdatptr->dbflen);
     }
     return(status == 0);
}
 
sabbtv(recptr)                /* step "absolute" Btrieve operations        */
char *recptr;
{
     int recseg;
 
     if (bb == NULL) {
          return;
     }
     if (recptr == NULL) {
          recseg=bb->dataseg;
     }
     else {
          maksur(bb->reclen);
          recseg=gpbseg;
     }
     if (btvu(24,recseg,0,0,bb->reclen) != 0) {
          posbtverr(recptr,"STEP-ABSOLUTE");
     }
     if (recptr != NULL) {
          movmem(gpbptr,recptr,btvdatptr->dbflen);
     }
}
 
updbtv(recptr)                /* "update" a Btrieve record                 */
char *recptr;
{
     upvbtv(recptr,bb->reclen);
}
 
upvbtv(recptr,length)         /* "update" a variable-length Btrieve record */
char *recptr;
int length;
{
     int recseg;
 
     if (bb == NULL) {
          return;
     }
     if (recptr == NULL) {
          recseg=bb->dataseg;
     }
     else {
          maksur(length);
          movmem(recptr,gpbptr,length);
          recseg=gpbseg;
     }
     if (btvu(3,recseg,bb->keyseg,bb->lastkn,length) != 0) {
          btverr("UPDATE");
     }
}
 
insbtv(recptr)                /* insert a new Btrieve record               */
char *recptr;
{
     invbtv(recptr,bb->reclen);
}
 
invbtv(recptr,length)         /* insert new variable length Btrieve record */
char *recptr;
int length;
{
     int recseg;
 
     if (bb == NULL) {
          return;
     }
     if (recptr == NULL) {
          recseg=bb->dataseg;
     }
     else {
          maksur(length);
          movmem(recptr,gpbptr,length);
          recseg=gpbseg;
     }
     if (btvu(2,recseg,bb->keyseg,0,length) != 0) {
          btverr("INSERT");
     }
}
 
delbtv()                      /* delete the current Btrieve record         */
{
     if (bb == NULL) {
          return;
     }
     if (btvu(4,0,0,bb->lastkn,bb->reclen) != 0) {
          btverr("DELETE");
     }
}
 
clsbtv(bbp)                   /* close specified Btrieve file              */
struct btvblk *bbp;
{
     if ((bb=bbp) != NULL && bb->filnam != NULL) {
          if (btvu(1,0,0,0,0) != 0) {
               catamsg("BTRIEVE CLOSE ERROR %d ON FILE \"%s\"",status,bb->filnam);
          }
          free(bb->key);
          free(bb->data);
          free(bb->filnam);
          bb->filnam=NULL;
          free(bb);
     }
}
 
btverr(who)
char *who;
{
     char buff[40];
 
     sprintf(buff,"%s ERROR %d",who,status);
     catastro("BTRIEVE %s ON FILE \"%s\"",buff,bb->filnam);
}
 
btvu(funcno,datbufseg,keyseg,keyno,rlen) /* underlying Btrieve cmd interface */
int funcno;
int datbufseg;
int keyseg;
int keyno;
int rlen;
{
     struct msb eclregs;
     static int btrvup=0,alrcat=0;
 
     if (!btrvup) {
          eclregs.ax=0x357B;
          eclint(0x21,&eclregs);
          if (eclregs.bx != 0x33) {
               if (alrcat) {
                    return(0);
               }
               alrcat=1;
               catastro(
               "\14\n\n\n\n\n\nRun BTRIEVE first, before running The Major BBS!\n");
          }
          btrvup=1;
     }
     btvdatptr->datbufoff=0;
     btvdatptr->datbufseg=datbufseg;
     btvdatptr->dbflen=rlen;
     btvdatptr->posp38off=38;
     btvdatptr->posp38seg=bb->realseg;
     btvdatptr->posblkoff=0;
     btvdatptr->posblkseg=bb->realseg;
     btvdatptr->funcno=funcno;
     btvdatptr->keyoff=0;
     btvdatptr->keyseg=keyseg;
     btvdatptr->keylen=(char)255;
     btvdatptr->keyno=(char)keyno;
     btvdatptr->statptoff=0;
     btvdatptr->statptseg=statusseg;
     *statusptr=0;
     btvdatptr->magic=24950;
     eclregs.dx=0;
     eclregs.ds=btvdatseg;
     eclint(0x7B,&eclregs);
     return(status=*statusptr);
}
 
