/***************************************************************************
 *                                                                         *
 *   CNCUTL.C                                                              *
 *                                                                         *
 *   Copyright (C) 1988-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   These are the Major BBS command concatenation utilities.              *
 *                                                                         *
 *                                 - T. Stryker & S. Brinker 7/5/88        *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "majorbbs.h"
#include "usracc.h"
#include "btvstf.h"
#include "message.h"
#include "portable.h"
 
 
char *nxtcmd;                 /* pointer to next char. for command concat. */
 
int maxcat,                   /* maximum number of concat'd commands       */
    numcat;                   /* number of commands concat'd so far        */
 
bgncnc()                      /* prepare input for command concatenation   */
{
     nxtcmd=margv[0];
     clrprf();
     rstrin();
}
 
endcnc()                      /* check for end of command concatenation    */
{
     if (margc == 0) {
          return(1);
     }
     if (++numcat >= maxcat) {
          return(1);
     }
     movmem(nxtcmd,input,strlen(nxtcmd)+1);
     parsin();
     return(margc == 0);
}
 
char
cncchr()                      /* gobble-character command concatenation    */
{
     char retval;
 
     if ((retval=toupper(*nxtcmd)) != '\0') {
          nxtcmd+=1;
     }
     return(retval);
}
 
cncint()                      /* atoi() look-alike for command concat.     */
{
     long cnclon();
 
     return((int)cnclon());
}
 
long
cnclon()                      /* atol() look-alike for command concat.     */
{
     long retval=0L;
 
     while (isdigit(*nxtcmd)) {
          retval=retval*10+*(nxtcmd++)-'0';
     }
     return(retval);
}
 
char *
cncuid()                      /* grab a userid; prepares for Btrieve too   */
{
     char *rp;
     static char retval[UIDSIZ];
 
     setmem(retval,UIDSIZ,0);
     if (*nxtcmd == SIGIDC) {
          rp=retval;
          while (*nxtcmd != '\0' && *nxtcmd != ' ' && rp-retval < UIDSIZ-1) {
               *rp++=*nxtcmd++;
          }
     }
     else {
          for (rp=retval ; isuidc(*nxtcmd) && rp-retval < UIDSIZ-1
             ; nxtcmd++,rp++) {
               *rp=(rp == retval ? toupper(*nxtcmd) : tolower(*nxtcmd));
          }
     }
     return(retval);
}
 
char
cncyesno()                    /* yes/no -- returns a char, chomps rest too */
{
     char retval;
 
     switch (retval=cncchr()) {
     case 'Y':
          if (sameto("es",nxtcmd)) {
               nxtcmd+=2;
          }
          break;
     case 'N':
          if (toupper(*nxtcmd) == 'O') {
               nxtcmd+=1;
          }
          break;
     }
     return(retval);
}
 
char *
cncall()                      /* grab rest of input; ends concatenation    */
{
     char *retval;
 
     retval=nxtcmd;
     nxtcmd="";
     return(retval);
}
 
char
morcnc()                      /* check for more commands to be concat'd    */
{                             /*  (rets 0 if not or the next char if so)   */
     if (numcat+1 >= maxcat) {
          return(0);
     }
     while (isspace(*nxtcmd)) {
          nxtcmd+=1;
     }
     return(toupper(*nxtcmd));
}
 
