/*  Header file for use with Btrieve utilities in BTVSTF.C and ECBTVSTF.C  */
/*  Copyright (C) 1987,1988,1990 GALACTICOMM, Inc.  All Rights Reserved.   */
 
#define SEGMAX  24            /* max number of key segs per file           */
 
struct btvblk {                    /* btrieve file data block definition   */
     long posblk[128/4];           /*   position block                     */
     char *filnam;                 /*   file name                          */
     int reclen;                   /*   maximum record length              */
     char *key;                    /*   key for searching, etc.            */
     char *data;                   /*   actual record contents             */
     int lastkn;                   /*   last key number used               */
     int keylns[SEGMAX];           /*   lengths of all possible keys       */
#ifdef ECLIPSE
     int realseg;                  /*   real segment of this data block    */
     int keyseg;                   /*   real segment of the key area       */
     int dataseg;                  /*   real segment of the data area      */
#endif
};
 
#define BTVFILE struct btvblk      /* shorthand for btrieve file structure */
 
BTVFILE *opnbtv();                 /* non-int btvstf routine returns       */
long absbtv();
 
#define PRIMBV  0                  /* normal pre-image btvopn() mode       */
#define ACCLBV -1                  /* "accelerated" btvopn() mode          */
#define RONLBV -2                  /* read-only btvopn() mode              */
#define VERFBV -3                  /* verify (read-after-write) btvopn mode*/
#define EXCLBV -4                  /* "exclusive" btvopn() mode            */
 
#define qeqbtv(key,keynum) qrybtv(key, keynum,55)
#define qnxbtv()           qnpbtv(56)
#define qprbtv()           qnpbtv(57)
#define qgtbtv(key,keynum) qrybtv(key, keynum,58)
#define qgebtv(key,keynum) qrybtv(key, keynum,59)
#define qltbtv(key,keynum) qrybtv(key, keynum,60)
#define qlebtv(key,keynum) qrybtv(key, keynum,61)
#define qlobtv(keynum)     qrybtv(NULL,keynum,62)
#define qhibtv(keynum)     qrybtv(NULL,keynum,63)
 
#define geqbtv(recp,key,keynum) getbtv(recp,key, keynum,5)
#define gnxbtv(recp)            getbtv(recp,NULL,    -1,6)
#define gprbtv(recp)            getbtv(recp,NULL,    -1,7)
#define ggtbtv(recp,key,keynum) getbtv(recp,key, keynum,8)
#define ggebtv(recp,key,keynum) getbtv(recp,key, keynum,9)
#define gltbtv(recp,key,keynum) getbtv(recp,key, keynum,10)
#define glebtv(recp,key,keynum) getbtv(recp,key, keynum,11)
#define globtv(recp,keynum)     getbtv(recp,NULL,keynum,12)
#define ghibtv(recp,keynum)     getbtv(recp,NULL,keynum,13)
 
#define acqbtv(recp,key,keynum) obtbtv(recp,key, keynum,5)
#define aqnbtv(recp)            anpbtv(recp,            6)
#define aqpbtv(recp)            anpbtv(recp,            7)
#define agtbtv(recp,key,keynum) obtbtv(recp,key, keynum,8)
#define agebtv(recp,key,keynum) obtbtv(recp,key, keynum,9)
#define altbtv(recp,key,keynum) obtbtv(recp,key, keynum,10)
#define alebtv(recp,key,keynum) obtbtv(recp,key, keynum,11)
#define alobtv(recp,keynum)     obtbtv(recp,NULL,keynum,12)
#define ahibtv(recp,keynum)     obtbtv(recp,NULL,keynum,13)
 
#define gcrbtv(recp,keynum)     gabbtv(recp,absbtv(),keynum)
 
#ifdef MSC_C
#define XREG                WORDREGS
#endif
 
