/***************************************************************************
 *                                                                         *
 *   BTVSTF.C                                                              *
 *                                                                         *
 *   Copyright (C) 1987,1988,1990 GALACTICOMM, Inc.   All Rights Reserved. *
 *                                                                         *
 *   This file contains a library of routines for accessing BTRIEVE files  *
 *   with fixed or variable length records.                                *
 *                                                                         *
 *                                            - T. Stryker 9/30/86         *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "dos.h"
#include "btvstf.h"
#include "portable.h"
 
static struct btvblk *bb;               /* current btvu file pointer set   */
static int status;                      /* status code returned by btvu()  */
static int bbomode=PRIMBV;              /* opnbtv() file-open mode         */
 
struct filspc {               /* Btrieve STAT command file spec            */
     int reclen;
     int pagsiz;
     int numofx;
     long numofr;
     int flags;
     int reserved;
     int unupag;
};
 
struct keyspc {               /* Btrieve STAT command key specs            */
     int keypos;
     int keylen;
     int flags;
     long numofk;
     int dontcare;
     long reserved;
};
#define ANOSEG  0x10          /* keyspc.flags bit for key has another seg  */
 
struct statbf {               /* STAT command ret buf layout               */
     struct filspc fs;
     struct keyspc ks[SEGMAX];
     char altcol[265];
};
 
char *alcmem();               /* memory allocation utility in GENUTL.C     */
 
struct btvblk *
opnbtv(filnam,maxlen)                   /* open a Btrieve file; return ptr.*/
char *filnam;
int maxlen;
{
     bb=(struct btvblk *)alcmem(sizeof(struct btvblk));
     bb->filnam=alcmem(strlen(filnam)+1);
     strcpy(bb->filnam,filnam);
     bb->reclen=maxlen;
     bb->data=alcmem(maxlen);
     if (btvu(0,NULL,filnam,bbomode,bb->reclen) != 0) {
          btverr("OPEN");
     }
     bb->key=alcmem(clckln());
     return(bb);
}
 
clckln()                      /* calculate all key lengths in curr file    */
{                             /*   (and return the max of them all)        */
     static char kbf[64];
     int i,keyno,klen,maxofa;
     struct statbf *tmpbuf;
 
     tmpbuf=(struct statbf *)alcmem(sizeof(struct statbf));
     if (btvu(15,tmpbuf,kbf,0,sizeof(struct statbf)) != 0) {
          btverr("STAT");
     }
     maxofa=0;
     for (i=0,keyno=0 ; keyno < tmpbuf->fs.numofx ; i++,keyno++) {
          klen=tmpbuf->ks[i].keylen;
          while (tmpbuf->ks[i].flags&ANOSEG) {
               klen+=tmpbuf->ks[++i].keylen;
          }
          bb->keylns[keyno]=klen;
          if (klen > maxofa) {
               maxofa=klen;
          }
     }
     free(tmpbuf);
     return(maxofa);
}
 
omdbtv(mode)                  /* set opnbtv() file-open mode               */
int mode;
{
     bbomode=mode;
}
 
setbtv(bbptr)                 /* set a Btrieve data block for use          */
struct btvblk *bbptr;
{
     bb=bbptr;
}
 
qrybtv(key,keynum,qryopt)     /* query Btrieve operations utility          */
char *key;
int keynum;
int qryopt;
{
     if (key != NULL && bb != NULL) {
          movmem(key,bb->key,bb->keylns[keynum]);
     }
     if (keynum < 0) {
          keynum=bb->lastkn;
     }
     else {
          bb->lastkn=keynum;
     }
     if (btvu(qryopt,NULL,bb->key,keynum,bb->reclen) != 0) {
          if (status == 4 || status == 9) {
               return(0);
          }
          btverr("QUERY");
     }
     return(1);
}
 
qnpbtv(getopt)                /* query next/previous Btrieve utility       */
int getopt;
{
     if (btvu(getopt-50,bb->data,bb->key,bb->lastkn,bb->reclen) != 0) {
          if (status == 4 || status == 9) {
               return(0);
          }
          btverr("QUERY-NP");
     }
     return(1);
}
 
getbtv(recptr,key,keynum,getopt)   /* get Btrieve operations utility       */
char *recptr;
char *key;
int keynum;
int getopt;
{
     if (recptr == NULL) {
          recptr=bb->data;
     }
     if (key != NULL && bb != NULL) {
          movmem(key,bb->key,bb->keylns[keynum]);
     }
     if (keynum < 0) {
          keynum=bb->lastkn;
     }
     else {
          bb->lastkn=keynum;
     }
     if (btvu(getopt,recptr,bb->key,keynum,bb->reclen) != 0) {
          btverr("GET");
     }
}
 
obtbtv(recptr,key,keynum,obtopt)   /* "acquire" Btrieve operations utiltiy */
char *recptr;
char *key;
int keynum;
int obtopt;
{
     if (recptr == NULL) {
          recptr=bb->data;
     }
     if (key != NULL && bb != NULL) {
          movmem(key,bb->key,bb->keylns[keynum]);
     }
     if (keynum < 0) {
          keynum=bb->lastkn;
     }
     else {
          bb->lastkn=keynum;
     }
     if (btvu(obtopt,recptr,bb->key,keynum,bb->reclen) != 0) {
          if (status == 4 || status == 9) {
               return(0);
          }
          btverr("OBTAIN");
     }
     return(1);
}
 
anpbtv(recptr,anpopt)         /* "acquire" next/previous Btrieve utility   */
char *recptr;
int anpopt;
{
     movmem(bb->key,bb->data,bb->keylns[bb->lastkn]);
     if (obtbtv(recptr,NULL,-1,anpopt) && strcmp(bb->data,bb->key) == 0) {
          return(1);
     }
     return(0);
}
 
long
absbtv()                      /* return current Btrieve file position      */
{
     long abspos;
 
     if (btvu(22,&abspos,NULL,0,sizeof(long)) != 0) {
          btverr("ABSOLUTE");
     }
     return(abspos);
}
 
gabbtv(recptr,abspos,keynum)  /* get Btrieve record from a file position   */
char *recptr;
long abspos;
int keynum;
{
     if (recptr == NULL) {
          recptr=bb->data;
     }
     *(long *)recptr=abspos;
     bb->lastkn=keynum;
     if (btvu(23,recptr,bb->key,keynum,bb->reclen) != 0) {
          btverr("GET-ABSOLUTE");
     }
}
 
aabbtv(recptr,abspos,keynum)  /* "acquire" a record from a file position   */
char *recptr;
long abspos;
int keynum;
{
     if (recptr == NULL) {
          recptr=bb->data;
     }
     *(long *)recptr=abspos;
     bb->lastkn=keynum;
     return(btvu(23,recptr,bb->key,keynum,bb->reclen) == 0);
}
 
sabbtv(recptr)                /* step "absolute" Btrieve operations        */
char *recptr;
{
     if (recptr == NULL) {
          recptr=bb->data;
     }
     if (btvu(24,recptr,NULL,0,bb->reclen) != 0) {
          btverr("STEP-ABSOLUTE");
     }
}
 
updbtv(recptr)                /* "update" a Btrieve record                 */
char *recptr;
{
     upvbtv(recptr,bb->reclen);
}
 
upvbtv(recptr,length)         /* "update" a variable-length Btrieve record */
char *recptr;
int length;
{
     if (recptr == NULL) {
          recptr=bb->data;
     }
     if (btvu(3,recptr,bb->key,bb->lastkn,length) != 0) {
          btverr("UPDATE");
     }
}
 
insbtv(recptr)                /* insert a new Btrieve record               */
char *recptr;
{
     invbtv(recptr,bb->reclen);
}
 
invbtv(recptr,length)         /* insert new variable length Btrieve record */
char *recptr;
int length;
{
     if (recptr == NULL) {
          recptr=bb->data;
     }
     if (btvu(2,recptr,bb->key,0,length) != 0) {
          btverr("INSERT");
     }
}
 
delbtv()                      /* delete the current Btrieve record         */
{
     if (btvu(4,NULL,NULL,bb->lastkn,bb->reclen) != 0) {
          btverr("DELETE");
     }
}
 
clsbtv(bbp)                   /* close specified Btrieve file              */
struct btvblk *bbp;
{
     if ((bb=bbp) != NULL && bb->filnam != NULL) {
          if (btvu(1,NULL,NULL,0,0) != 0) {
               catamsg("BTRIEVE CLOSE ERROR %d ON FILE \"%s\"",status,bb->filnam);
          }
          free(bb->key);
          free(bb->data);
          free(bb->filnam);
          bb->filnam=NULL;
          free(bb);
     }
}
 
btverr(who)
char *who;
{
     char buff[40];
 
     sprintf(buff,"%s ERROR %d",who,status);
     catastro("BTRIEVE %s ON FILE \"%s\"",buff,bb->filnam);
}
 
struct btvdat {   /* btrieve parameter block structure for use with INT 0x7B */
     char *datbuf;
     int dbflen;
     char *posp38;
     char *posblk;
     int funcno;
     char *key;
     char keylen;
     char keyno;
     int *statpt;
     int magic;
};
 
btvu(funcno,datbuf,key,keyno,rlen) /* underlying Btrieve command interface */
int funcno;
char *datbuf;
char *key;
int keyno;
int rlen;
{
     union REGS regs;
     struct SREGS sregs;
     struct btvdat btvdat;
     static int btrvup=0,alrcat=0;
 
     if (!btrvup) {
          regs.x.ax=0x357B;
          int86x(0x21,&regs,&regs,&sregs);
          if (regs.x.bx != 0x33) {
               if (alrcat) {
                    return(0);
               }
               alrcat=1;
               catastro(
               "\14\n\n\nRun BTRIEVE /P:2048 first, before running The Major BBS!\n");
          }
          btrvup=1;
     }
     btvdat.datbuf=datbuf;
     btvdat.dbflen=rlen;
     btvdat.posp38=((char *)bb->posblk)+38;
     btvdat.posblk=(char *)bb->posblk;
     btvdat.funcno=funcno;
     btvdat.key=key;
     btvdat.keylen=(char)255;
     btvdat.keyno=(char)keyno;
     *(btvdat.statpt=&status)=0;
     btvdat.magic=24950;
     regs.x.dx=(short)&btvdat;
     segread(&sregs);
     sregs.ds=sregs.ss;
     int86x(0x7B,&regs,&regs,&sregs);
     if (status == 22) {                     /* truncate buffer overflows  */
          datbuf[bb->reclen-1]='\0';
          status=0;
     }
     return(status);
}
 
