/***************************************************************************
 *                                                                         *
 *   ACCOUNT.C                                                             *
 *                                                                         *
 *   Copyright (C) 1987-1990 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Major BBS online accounting utility.                      *
 *                                                                         *
 *                                            - T. Stryker 7/6/86          *
 *                                                                         *
 ***************************************************************************/
 
#include "stdio.h"
#include "ctype.h"
#include "majorbbs.h"
#include "usracc.h"
#include "btvstf.h"
#include "account.h"
#include "dosface.h"
#include "portable.h"
 
FILE *acnmb;                  /* accounting named-message file block ptr   */
BTVFILE *accbb;               /* user accounts btrieve data file           */
 
struct usracc *usracc,        /* user accounting block array               */
              *usaptr,        /* user accounting block pointer for usrnum  */
              *othuap;        /* gen purp other-user accounting data ptr   */
 
static
struct usracc acctmp,         /* temporary user account storage area       */
             *accptr;         /* general purpose pointer to user account   */
static
int acninu=-1,                /* "accounting" in use, and by who (-1 if no)*/
    acnstt,                   /* accounting sub-state                      */
    acnopt,                   /* account menu option selected              */
    acnchn,                   /* accounting channel no. to take action on  */
    real;                     /* paid/free flag (real=paid=1)              */
static
char acnmsg[MTXSIZ],          /* accounting message accumulation buf       */
     acnuid[UIDSIZ],          /* accounting user-id hold area              */
     tckstg[10];              /* "tickies" string (credits)                */
 
extern
struct module *module[NMODS]; /* module access block pointer table         */
extern
int kilipg,                   /* kill-system command in progress           */
    kilsrc;                   /* kill-command source (-1=console, -2=MCU)  */
 
 
/*--- OPTIONS FROM ACCOUNT.MSG ---*/
 
int idulif,                   /* Lifetime of an idle user, in days         */
    hwtlog,                   /* Time limit for logging in during hi  usage*/
    lwtlog,                   /* Time limit for logging in during low usage*/
    hwtsup,                   /* Time limit for signing up during hi  usage*/
    lwtsup,                   /* Time limit for signing up during low usage*/
    hwtnlv,                   /* Time limit for non-live users,   hi  usage*/
    lwtnlv;                   /* Time limit for non-live users,   low usage*/
long daygiv,                  /* Daily   credits given to paying users     */
     mongiv,                  /* Monthly credits given to paying users     */
     yergiv,                  /* Yearly  credits given to paying users     */
     dayfre,                  /* Daily   credits given to non-paying users */
     monfre,                  /* Monthly credits given to non-paying users */
     yerfre;                  /* Yearly  credits given to non-paying users */
 
iniacc()                      /* initialize accounting                     */
{
     int decevy();
     static long lo=0x80000001L,hi=0x7FFFFFFFL;
     long lngopt();
 
     acnmb=opnmsg("account.mcv");
     accbb=opnbtv("usracc.dat",sizeof(struct usracc));
     usracc=(struct usracc *)alcmem(nterms*sizeof(struct usracc));
     idulif=numopt(IDULIF,-1,32767);
     hwtlog=numopt(HWTLOG,-32767,32767);
     lwtlog=numopt(LWTLOG,-32767,32767);
     hwtsup=numopt(HWTSUP,-32767,32767);
     lwtsup=numopt(LWTSUP,-32767,32767);
     hwtnlv=numopt(HWTNLV,-32767,32767);
     lwtnlv=numopt(LWTNLV,-32767,32767);
     daygiv=lngopt(DAYGIV,lo,hi);
     mongiv=lngopt(MONGIV,lo,hi);
     yergiv=lngopt(YERGIV,lo,hi);
     dayfre=lngopt(DAYFRE,lo,hi);
     monfre=lngopt(MONFRE,lo,hi);
     yerfre=lngopt(YERFRE,lo,hi);
     rtkick(15,decevy);
     srand(now());
}
 
account(clr)                  /* remote sysop command handler              */
int clr;
{
     int lenlft;
     static int soppmt[]={
         ENTMSG,ENTUID,ENTUID,0,ENTUID,ENTMSG,ENTUOC,ENTUOC,ENTUID,KILSYS};
     int ucdkil();
 
     if (!(usrptr->flags&ISYSOP)) {
          zapacn();
          return(0);
     }
     setmbk(acnmb);
     setbtv(accbb);
     if (clr) {
          if (acninu >= 0) {
               prfmsg(ALRINU);
               return(0);
          }
          acninu=usrnum;
          prfmsg(FMENU);
          acnstt=SMENU;
     }
     else if (margc == 0 && (acnstt != ENTMSG || input[0] == '\0')) {
          prfmsg(acnstt == ENTMSG ? CONTXT : acnstt);
     }
     else if (sameas(margv[0],"x")) {
          if (acnstt == SMENU) {
               zapacn();
               return(0);
          }
          prfmsg(acnstt=SMENU);
     }
     else {
          switch (acnstt) {
          case SMENU:
               acnmsg[0]='\0';
               if ((acnopt=atoi(margv[0])) >= 1
                 && acnopt <= 10 && acnopt != 4) {
                    prfmsg(acnstt=soppmt[acnopt-1]);
               }
               else if (*margv[0] == '?') {
                    prfmsg(FMENU);
               }
               else {
                    errmsg(CNOTIL);
               }
               break;
          case ENTMSG:
               if (margc == 1 && sameas(margv[0],"ok")) {
                    xltctls(acnmsg);
                    switch (acnopt) {
                    case 1:                                 /* send to ALL */
                         usrptr->flags|=NOINJO;
                         snd2al(acnmsg);
                         usrptr->flags&=~NOINJO;
                         prfmsg(CONFMA);
                         break;
                    case 2:                                 /* send to chn */
                         snd2ch(acnchn,acnmsg);
                         prfmsg(CONFMU,acnuid);
                         break;
                    case 6:                                 /* set log-msg */
                         strcpy(sv.lonmsg,acnmsg);
                         prfmsg(CONFML);
                         break;
                    }
                    prfmsg(acnstt=SMENU);
               }
               else {
                    rstrin();
                    if ((lenlft=MTXSIZ-(strlen(acnmsg)+1)) < inplen+2) {
                         prfmsg(RETYPE,lenlft-2);
                    }
                    else {
                         strcat(acnmsg,input);
                         strcat(acnmsg,"\r");
                         prf("");
                    }
               }
               break;
          case ENTUID:
          case ENTUOC:
               makhdl();
               movmem(input,acnuid,UIDSIZ);
               switch (acnopt) {
               case 2:                                 /* send to chn */
                    if (onsys(input)) {
                         acnchn=othusn;
                         prfmsg(acnstt=ENTMSG);
                    }
                    else {
                         blwoff(UNOTON);
                    }
                    break;
               case 3:                                 /* post creds  */
                    if (qeqbtv(input,0)) {
                         prfmsg(acnstt=HMTCK);
                    }
                    else {
                         blwoff(UNOTEX);
                    }
                    break;
               case 5:                                 /* detail user */
                    if (acqbtv(&acctmp,input,0)) {
                         accptr=(onsys(input) ? othuap : &acctmp);
                         shwusr(accptr,vispsw);
                         setmbk(acnmb);
                         prfmsg(DETPT2,ltoa(accptr->tcktot),
                                       ltoa(accptr->tcktot-accptr->tckpai),
                                       ltoa(accptr->tckpai),
                                       ltoa(accptr->frescu/60));
                         prfmsg(acnstt=SMENU);
                    }
                    else {
                         blwoff(UNOTEX);
                    }
                    break;
               case 7:                                 /* emulate uid */
                    if (uorchn()) {
                         if (othusn == usrnum) {
                              blwoff(EMUYOU);
                         }
                         else {
                              acnchn=othusn;
                              btutrg(usrnum,1);
                              rsyson(usrnum,acnchn);
                              usrptr->flags|=NOINJO;
                              bgnemu(acnchn);
                              prfmsg(EMUBGN);
                              btuscr(usrnum,0);
                              prf("\r\n\n");
                         }
                    }
                    else {
                         blwoff(UNOTON);
                    }
                    break;
               case 8:                                 /* disconnect  */
                    if (uorchn()) {
                         kilchn(othusn);
                         prfmsg(CONFDS);
                         prfmsg(acnstt=SMENU);
                    }
                    else {
                         blwoff(UNOTON);
                    }
                    break;
               case 9:                                 /* delete user */
                    if (onsys(input)) {
                         blwoff(CANTDL);
                    }
                    else if (delacct(acnuid) >= 0) {
                         setmbk(acnmb);
                         prfmsg(CONFDL);
                         prfmsg(acnstt=SMENU);
                    }
                    else {
                         blwoff(UNOTEX);
                    }
                    break;
               }
               break;
          case KILSYS:
               if (sameto(margv[0],"yes")) {
                    kilipg=1;
                    kilsrc=usrnum;
                    hupall();
                    prf("");
               }
               else {
                    prfmsg(acnstt=SMENU);
               }
               break;
          case HMTCK:
               cpykey(tckstg,margv[0],10);
               prfmsg(acnstt=PORF);
               break;
          case PORF:
               sporf();
               break;
          case ISOKQ:
               sisokq();
               break;
          }
     }
     return(1);
}
 
uorchn()                      /* user-or-channel-number utility            */
{
     return(onsys(input)
      || (sscanf(margv[0],"%2x",&othusn) == 1 && (othusn=usridx(othusn)) >= 0));
}
 
sporf()                       /* check to see if credits are paid or free  */
{
     int c;
 
     if ((c=tolower(*margv[0])) == 'p') {
          real=1;
     }
     else if (c == 'f') {
          real=0;
     }
     else {
          prfmsg(PORF);
          return;
     }
     prfmsg(HEREAR,tckstg,(real ? "PAID" : "FREE"),acnuid);
     prfmsg(acnstt=ISOKQ);
}
 
sisokq()                      /* verify if posting credits is OK           */
{
     int c;
 
     if ((c=tolower(*margv[0])) == 'n') {
          prfmsg(acnstt=SMENU);
          return;
     }
     else if (c != 'y') {
          prfmsg(ISOKQ);
          return;
     }
     switch (addcrd(acnuid,tckstg,real)) {
     case -1:
          prfmsg(MYSDEL,acnuid);
          break;
     case 0:
          break;
     case 1:
          if (othusn == usrnum) {
               prf("You got it.\r");
          }
          else {
               if (saycrd(tckstg,real)) {
                    prfmsg(NOTIF,acnuid);
               }
               else {
                    prfmsg(CANTNO,acnuid);
               }
          }
          break;
     }
     prfmsg(acnstt=SMENU);
}
 
acsthn()                      /* status handler while in remote emulation  */
{
     char c;
 
     if (status == INBLK) {
          btuict(usrnum,&c);
          if (c == 27) {
               zpremu(usrnum);
          }
          else {
               btumks(c);
          }
     }
     else {
          dfsthn();
     }
}
 
zpremu(unum)                  /* exiting remote sysop emulation            */
int unum;
{
     btutrg(unum,0);
     btuscr(unum,'\n');
     rsyson(-1);
     user[unum].flags&=~NOINJO;
     setmbk(acnmb);
     prfmsg(EMUEND,acnuid);
     prfmsg(acnstt=SMENU);
     outprf(unum);
}
 
static
errmsg(msgnum,parm)           /* utility for prf()ing error messages       */
int msgnum;
long parm;
{
     prfmsg(msgnum,parm);
     prfmsg(acnstt);
}
 
static
blwoff(msgnum,parm)           /* prf()s message and returns to account menu*/
int msgnum;
long parm;
{
     prfmsg(msgnum,parm);
     prfmsg(acnstt=SMENU);
}
 
zapacn()                      /* exiting remote sysop "accounting" stuff   */
{
     if (usrnum == acninu) {
          rsyson(-1);
          acninu=-1;
     }
}
 
addcrd(keyuid,tckstg,real)    /* utility for posting credits to an account */
char *keyuid,*tckstg;
int real;
{
     int ison;
     long ticks,atol();
 
     if ((ison=crdusr(keyuid,tckstg,real,1)) >= 0) {
          shocst(1,"CREDITED %-9s%7s %s",keyuid,tckstg,
                    (real ? "(PAID)" : "(FREE)"));
     }
     return(ison);
}
 
crdusr(keyuid,tckstg,real,affall) /* low-level utility for posting credits */
char *keyuid,*tckstg;
int real,affall;
{
     int ison;
     long ticks;
 
     setbtv(accbb);
     if (!acqbtv(&acctmp,keyuid,0)) {
          return(-1);
     }
     ison=onsys(keyuid);
     if (ison) {
          accptr=othuap;
     }
     else if (uinsys(keyuid)) {
          accptr=&usracc[uisusn];
     }
     else {
          accptr=&acctmp;
     }
     ticks=atol(tckstg);
     accacct(accptr,-1);
     if ((accptr->tckavl+=ticks) < 0) {
          accptr->tckavl=0;
     }
     if (affall) {
          if ((accptr->tcktot+=ticks) < 0) {
               accptr->tcktot=0;
          }
          if (real) {
               if ((accptr->tckpai+=ticks) < 0) {
                    accptr->tckpai=0;
               }
               sv.paidytd+=ticks;
               sv.paidmtd+=ticks;
               sv.paiddtd+=ticks;
          }
     }
     accacct(accptr,1);
     updbtv(accptr);
     if (ison && accptr->tckavl > 0) {
          othusp->class=PAYING;
     }
     return(ison);
}
 
saycrd(tckstg,real)           /* notify creditee (if online) of credits    */
char *tckstg;
int real;
{
     setmbk(acnmb);
     prfmsg(real ? YOUCRD : YCRFRE,tckstg);
     return(injoth());
}
 
cpykey(dest,src,len)          /* format data (src) for Btrieve use (dest)  */
char *dest,*src;
int len;
{
     int dstlen;
 
     movmem(src,dest,len);
     *(dest+len-1)='\0';
     dstlen=strlen(dest);
     setmem(dest+dstlen,len-dstlen,0);
}
 
decevy()                      /* rtkick() to gobble credits of users online*/
{
     static int altbnf;
     long lincst(),lc;
 
     setmbk(acnmb);
     othuap=usracc;
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          lc=lincst(othusn);
          switch (othusp->class) {
          case VACANT:
               break;
          case ONLINE:
               othusp->minut4+=1;
               if ((othusp->usetmr)++ >= wtwait(lwtlog,hwtlog)) {
                    usrnum=othusn;
                    byenow(SEEYEZ);
               }
               break;
          case SUPIPG:
               othusp->minut4+=1;
               if ((othusp->usetmr)++ >= wtwait(lwtsup,hwtsup)) {
                    usrnum=othusn;
                    byenow(SEEYEZ);
               }
               break;
          case FRELOA:
               othusp->minut4+=1;
               othuap->frescu+=15;
               sv.usedytd+=15;
               sv.usedmtd+=15;
               sv.useddtd+=15;
               othusp->usetmr++;
               if (othusp->nlzapc > 0) {
                    if(--(othusp->nlzapc) == 0) {
                         usrnum=othusn;
                         byenow(SYSFUL,chghour);
                    }
               }
               else if (!(othusp->flags&(NOZAP+OPCHAT)) &&
                  othusp->usetmr >= wtwait(lwtnlv,hwtnlv)-4) {
                    othusp->nlzapc=4;
                    prfmsg(NLZOMW);
                    injoth();
               }
               break;
          case PAYING:
               othusp->minut4+=1;
               sv.usedytd+=15;
               sv.usedmtd+=15;
               sv.useddtd+=15;
               sv.liveytd+=15;
               sv.livemtd+=15;
               sv.livedtd+=15;
               othuap->tckavl-=(othusp->crdrat>>2)
                               +((othusp->minut4&3)<(othusp->crdrat&3))
                               +lc;
               if (othuap->tckavl <= 0) {
                    othuap->tckavl=0;
                    othusp->class=FRELOA;
                    othusp->usetmr=0;
                    prfmsg(SW2FRE);
                    injoth();
               }
               break;
          }
          if ((altbnf&1) && othusp->pfnacc != 0) {
               othusp->pfnacc-=1;
          }
          othuap+=1;
     }
     altbnf+=1;
     rtkick(15,decevy);
}
 
imbump(logon)            /* immediate bump?  logon or post-sign-up cases    */
int logon;
{
     if (usaptr->tckavl <= 0 && wtwait(lwtnlv,hwtnlv) <= 0) {
          setmbk(acnmb);
          byenow(logon ? IMMLOB : IMMEDB);
          return(1);
     }
     else {
          return(0);
     }
}
 
wtwait(lomin,himin)      /* interpolate between time limits for lo/hi usage */
int lomin,himin;                            /* returns time in 15 sec units */
{
     return(((max(nliniu(),1)-1)*(himin-lomin)<<2)/max(nterms-1,1)+(lomin<<2));
}
 
nliniu()                      /* returns number of system lines "in use"   */
{
     int othusn,retval;
     struct user *othusp;
 
     retval=0;
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          if (othusp->class != VACANT) {
               retval+=1;
          }
     }
     return(retval);
}
 
updacc()                      /* update a user's account utility           */
{
     setbtv(accbb);
     geqbtv(NULL,usaptr->userid,0);
     updbtv(usaptr);
}
 
static long avl;
 
givem(howmch)                 /* add/subract midnight cleanup credits amt. */
long howmch;
{
     avl=howmch < 0L ? avl+howmch : max(avl,howmch);
}
                              /* account midnight cleanup routine          */
accmcu()
{
     int ctoday,tday,bomonth,boyear;
     long accpos;
 
     usrnum=-2;
     if (ddyear(tday=today()) == 1980) {
          shocst(1,"DATE SET WRONG, CLEANUP NOT DONE");
          return(0);
     }
     ctoday=cofdat(tday);
     boyear=(bomonth=(ddday(tday) == 1)) != 0 && ddmon(tday) == 1;
     sv.numact=sv.numpai=sv.numfem=sv.numcor=sv.numdem=sv.numfre=sv.numans=0;
     setmem(sv2.matrix,sizeof(sv2.matrix),0);
     setbtv(accbb);
     if (qlobtv(0)) {
          do {
               gabbtv(&acctmp,accpos=absbtv(),0);
               avl=acctmp.tckavl;
               if (acctmp.tckpai > 0L) {
                    givem(daygiv);
                    if (bomonth) {
                         givem(mongiv);
                         if (boyear) {
                              givem(yergiv);
                         }
                    }
               }
               else {
                    givem(dayfre);
                    if (bomonth) {
                         givem(monfre);
                         if (boyear) {
                              givem(yerfre);
                         }
                    }
               }
               if ((avl=max(0L,avl)) < acctmp.tckavl) {              /* TAX */
                    acctmp.tckavl=avl;
                    updbtv(&acctmp);
               }
               else if (avl > acctmp.tckavl) {                     /* GRANT */
                    addcrd(acctmp.userid,ltoa(avl-acctmp.tckavl),0);
                    setbtv(accbb);
                    gabbtv(&acctmp,accpos,0);
               }
               accacct(&acctmp,1);
               if (idulif >= 0
                 && ctoday-cofdat(dcdate(acctmp.usedat)) > idulif
                 && acctmp.tckavl <= 0L) {
                    delacct(acctmp.userid);
               }
          } while (qnxbtv());
     }
     shocst(1,"HrsDTD U: %ld L: %ld P: %ld",sv.useddtd/3600L,
          sv.livedtd/3600L,sv.paiddtd/3600L);
     sv.useddtd=sv.livedtd=sv.paiddtd=0;
     if (bomonth) {
          shocst(1,"HrsMTD U: %ld L: %ld P: %ld",sv.usedmtd/3600L,
               sv.livemtd/3600L,sv.paidmtd/3600L);
          sv.usedmtd=sv.livemtd=sv.paidmtd=0;
          if (boyear) {
               shocst(1,"HrsYTD U: %ld L: %ld P: %ld",sv.usedytd/3600L,
               sv.liveytd/3600L,sv.paidytd/3600L);
               sv.usedytd=sv.liveytd=sv.paidytd=0;
          }
     }
     return(1);
}
 
accacct(accptr,plusor)        /* calculate system statistics for accounts  */
struct usracc *accptr;
int plusor;
{
     static int agebra[NAGEBK]={20,30,40,50,9999};
     int i;
 
     sv.numact+=plusor;
     if (accptr->tcktot != 0L) {
          if (accptr->tckpai != 0L) {
               sv.numpai+=plusor;
          }
          else {
               sv.numdem+=plusor;
          }
     }
     else {
          sv.numfre+=plusor;
     }
     if (accptr->sex != 'M') {
          sv.numfem+=plusor;
     }
     if (accptr->usrad1[0] != '\0') {
          sv.numcor+=plusor;
     }
     if (accptr->ansifl&ANSON) {
          sv.numans+=plusor;
     }
     for (i=0 ; i < NAGEBK ; i++) {
          if (accptr->age < agebra[i]) {
               sv2.matrix[accptr->systyp][i]+=plusor;
               break;
          }
     }
}
 
delacct(userid)               /* delete an account from system routine     */
char *userid;
{
     int i,(*rouptr)();
 
     setbtv(accbb);
     if (!acqbtv(&acctmp,userid,0)) {
          return(-1);
     }
     delbtv();
     accacct(&acctmp,-1);
     for (i=1 ; i < NMODS ; i++) {
          if ((rouptr=module[i]->dlarou) != NULL) {
               (*rouptr)(userid);
          }
     }
     shocst(1,"DELETED %-9s (Cr: %ld)",userid,acctmp.tckavl);
     setbtv(accbb);
     return(0);
}
 
kiluid(userid)                /* "kill" just the User-ID by random password*/
char *userid;
{
     int i;
 
     setbtv(accbb);
     if (!acqbtv(&acctmp,userid,0)) {
          return(-1);
     }
     for (i=0 ; i < PSWSIZ-1 ; i++) {
          acctmp.psword[i]=rand()%26+'A';
     }
     acctmp.psword[PSWSIZ-1]='\0';
     updbtv(&acctmp);
     return(0);
}
 
clsacc()                      /* close account-related files for shutdown  */
{
     clsbtv(accbb);
     clsmsg(acnmb);
}
 
