(* This Unit contains all the functions/procedures that handle strings *)
UNIT STRINGS;
INTERFACE
Function strr(l:longint):string;                  {Longint to String }
FUNCTION UPSTRING(S:STRING):STRING;
Function strlong(l:longint):string;
Function valu(q:string):Integer;
Function Strip (L, C: Char; Str: String): String;
Function StrToInt (Str: String): LongInt;

IMPLEMENTATION
Function StrToInt (Str: String): LongInt;
Var
  code : Integer;
  Temp : LongInt;
Begin
  If Length (Str) = 0 Then
    StrToInt := 0
  Else
  Begin
    Val (Str, temp, code);
    If code = 0 Then
      StrToInt := temp
    Else
      StrToInt := 0;
  End;
End;

Function Strip (L, C: Char; Str: String): String;
Var
  I :  Byte;
Begin
  Case upcase (L) Of
    'L' :
          Begin       {Left}
            While (Str [1] = C) And (Str [0] <> #0) do
              Delete (Str, 1, 1);
          End;
    'R' :
          Begin       {Right}
            While (Str [Length (Str) ] = C) And (Str [0] <> #0) do
              Dec (Str [0]);
          End;
    'B' :
          Begin       {Both left and right}
            While (Str [1] = C) And (Str [0] <> #0) do
              Delete (Str, 1, 1);
            While (Str [Length (Str) ] = C) And (Str [0] <> #0)  do
              Dec (Str [0]);
          End;
    'A' :
          Begin       {All}
            I := 1;
            Repeat
              If (Str [I] = C) And (Str [0] <> #0) Then
                Delete (Str, I, 1)
              Else
                Inc (I);
            Until (I > Length (Str) ) Or (Str = '');
          End;
  End;
  Strip := Str;
End;  {Strip}

  Function valu(q:string):Integer;
    Var i,s,pu:Integer;
      r:Real;
    Begin
      valu:=0;
      If Length(q)=0 Then exit;
      If Not(q[1] In ['0'..'9','-']) Then exit;
      If Length(q)>5 Then exit;
      Val(q,r,s);
      If s<>0 Then exit;
      If (r<=32767.0) And (r>=-32767.0)
      Then valu:=Round(r)
    End;

FUNCTION UPSTRING(S:STRING):STRING;
VAR C:CHAR;
    TEMP:STRING;
    X:BYTE;
BEGIN
C:=#0;
TEMP:='';
FOR X:=1 TO LENGTH(S) DO TEMP:=TEMP+UPCASE(S[X]);
UPSTRING:=TEMP;
END;

  Function strlong(l:longint):string;
    Var q:string;
    Begin
      Str(l,q);
      strlong:=q
    End;

Function strr(l:longint):string;
    Var q:string;
    Begin
      Str(l,q);
      strr:=q
    End;


END.

