Unit totMSG;
{$I Sys75.INC}

Interface

Uses DOS, CRT, totSYS, totINPUT, totFAST, totIO1, totWIN, totSTR;

Const
  MaxButtons = 10;

Type
  MsgNodePtr = ^MsgNode;
  MsgNode = Record
              Txt : Pointer;
              Next: MsgNodePtr;
            End; {MsgNode}

  ButtonDetails = Record
                    Txt: stringbut;
                    Code: tAction;
                    HK: Word;
                    Len : Byte;
                  End; {ButtonDetails}

  pBaseMessageOBJ = ^BaseMessageOBJ;
  BaseMessageOBJ = Object
                     vTxtStack: MsgNodePtr;
                     vManager: WinFormOBJ;
                     vTotLines: Byte;
                     vStyle: Byte;
                     vWidth : Byte;
                     vButtonDepth: Byte;
                     vMinWidth: Byte;
                     vTotButtons: Byte;
                     vButtons: Array [1..MaxButtons] Of pItemIOOBJ;
                     vDefault: tAction;
                     {methods ...}
                     Constructor Init (Style: Byte; Tit: String);
                     Procedure   SetColors (A, A2, B, C, C2, D, D2: Byte);
                     Procedure   AddLine (Str: String);
                     Function    MsgTxt (LineNo: Byte): String;
                     Function    WinForm: WinFormPtr;
                     Procedure   AssignButton (Var Button: ItemIOOBJ);
                     Procedure   CalcSize;
                     Procedure   SetDefault (TimeOut: Word; Default: tAction);
                     Function    Show: tAction;
                     Destructor  Done;                               Virtual;
                   End; {BaseMessageOBJ}

  pMessageOBJ = ^MessageOBJ;
  MessageOBJ = Object (BaseMessageOBJ)
                 vButtonText : stringbut;
                 vButtonHK: Word;
                 {methods ...}
                 Constructor Init (Style: Byte; Tit: String);
                 Procedure   SetOption (Str: String; Hotkey: Word);
                 Procedure   Show;
                 Destructor  Done;                                   Virtual;
               End; {MessageOBJ}

  pButtonMessageOBJ = ^ButtonMessageOBJ;
  ButtonMessageOBJ = Object (MessageOBJ)
                       {methods ...}
                       Constructor Init (Style: Byte; Tit: String);
                       Procedure   Show;
                       Destructor  Done;                                     Virtual;
                     End; {ButtonMessageOBJ}

  pPromptOBJ = ^PromptOBJ;
  PromptOBJ = Object (BaseMessageOBJ)
                vButtonInfo : Array [1..3] Of ButtonDetails;
                vTotPrompts: Byte;
                {methods ...}
                Constructor Init (Style: Byte; Tit: String);
                Procedure   SetOption (ID: Byte; Str: stringbut; HotKey: Word; Act: tAction);
                Procedure   LoadButtonRecord (Rec: Byte; Str: stringbut; Hotkey: Word; Act: tAction);
                Function    Show: tAction;
                Destructor  Done;                                    Virtual;
              End; {PromptOBJ}

  pButtonPromptOBJ = ^ButtonPromptOBJ;
  ButtonPromptOBJ = Object (promptOBJ)
                      {methods ...}
                      Constructor Init (Style: Byte; Tit: String);
                      Function    Show: tAction;
                      Destructor  Done;                              Virtual;
                    End; {ButtonPromptOBJ}

Implementation

{|||||||||||||||||||||||||||||||||||||||||||||||||||}
{                                                   }
{    B a s e M e s s a g e O B J   M E T H O D S    }
{                                                   }
{|||||||||||||||||||||||||||||||||||||||||||||||||||}
Constructor BaseMessageOBJ. Init (Style: Byte; Tit: String);
{}
Begin
  vTotLines := 0;
  vStyle := Style;
  vTxtStack := Nil;
  vWidth := Length (Tit) + 10;
  vMinWidth := 10;
  vTotButtons := 0;
  vButtonDepth := 1;
  With vManager do
  Begin
    Init;
    Win^. SetTitle (Tit);
  End;
End; {BaseMessageOBJ.Init}

Procedure BaseMessageObj. SetColors (A, A2, B, C, C2, D, D2: Byte);
Begin
  vManager. Win^. SetColors (A, A2, B, C, C2, D, D2);
End;

Procedure BaseMessageOBJ. AddLine (Str: String);
{}
Var L : Byte;
  Temp: MsgNodePtr;
Begin
  L := Succ (Length (Str) );
  If vTxtStack = Nil Then
  Begin
    GetMem (vTxtStack, SizeOf (vTxtStack^) );
    vTxtStack^. Next := Nil;
    If Str <> '' Then
    Begin
      GetMem (vTxtStack^. Txt, L);
      Move (Str [0], vTxtStack^. Txt^, L);
    End
    Else
      vTxtStack^. Txt := Nil;
  End
  Else
  Begin
    Temp := vTxtStack;
    While Temp^. Next <> Nil do
      Temp := Temp^. Next;
    GetMem (Temp^. Next, SizeOf (Temp^. Next^) );
    Temp := Temp^. Next;
    Temp^. Next := Nil;
    If Str <> '' Then
    Begin
      GetMem (Temp^. Txt, L);
      Move (Str [0], Temp^. Txt^, L);
    End
    Else
      Temp^. Txt := Nil;
  End;
  Inc (vTotLines);
End; {BaseMessageOBJ.AddLine}

Function BaseMessageOBJ. MsgTxt (LineNo: Byte): String;
{}
Var
  Temp: MsgNodePtr;
  I: Integer;
  L : Byte;
  Str: String;
Begin
  Temp := vTxtStack;
  for I := 2 to LineNo do
    If Temp <> Nil Then
      Temp := Temp^. Next;
  If (Temp <> Nil) And (Temp^. Txt <> Nil) Then
  Begin
    Move (Temp^. Txt^, L, 1);
    Move (Temp^. Txt^, Str [0], Succ (L) );
  End
  Else
    Str := '';
  MsgTxt := Str;
End; {BaseMessageOBJ.MsgTxt}

Procedure BaseMessageOBJ. AssignButton (Var Button: ItemIOOBJ);
{}
Begin
  If vTotButtons < MaxButtons Then
  Begin
    Inc (vTotButtons);
    vButtons [vTotButtons] := @Button
  End;
End; {BaseMessageOBJ.AssignButton}

Procedure BaseMessageOBJ. CalcSize;
{}
Var
  X1, Y1, X2, Y2: ShortInt;
  Height: Byte;
  I : Integer;
  Str : String;
  b: byte;
Begin
  for I := 1 to b do
  Begin
    Str := MsgTxt (I);
    If Length (Str) > vWidth Then
      vWidth := Length (Str);
  End;
  If vWidth < vMinWidth Then
    vWidth := vMinWidth
  Else If vWidth > 80 Then
    vWidth := 76;
  If (vStyle <> 0) Then
    vWidth := vWidth + 2;
  X1 := (Monitor^. Width - vWidth) Div 2;
  X2 := X1 + Pred (vWidth);
  Case vStyle Of
    0: Height := vTotLines;
    6: Height := vTotLines + 3;
    Else Height := vTotLines + 2;
  End; {case}
  If vStyle = 6 Then Inc (Height, vButtondepth + 2 )
  Else Inc (Height, Succ (vButtondepth) );
  Y1 := (Monitor^. Depth - Height) Div 2;
  Y2 := Y1 + Pred (Height);
  vManager. Win^. SetSize (X1, Y1, X2, Y2, vStyle);
End; {BaseMessageOBJ.CalcSize}

Procedure BaseMessageOBJ. SetDefault (TimeOut: Word; Default: tAction);
{}
Begin
  Key^. vTimeOut := TimeOut;
  vDefault := Default;
End; {FormOBJ.SetDefault}

Function BaseMessageOBJ. Show: tAction;
{}
Var
  I : Integer;
  S : String;
Begin
  for I := 1 to vTotButtons do
    vManager. AddItem (vButtons [I]^);
  If vStyle = 6 Then Inc (vTotLines);
  vManager. Draw;
  If vStyle = 6 Then Dec (vTotLines);
  for I := 1 to vTotLines do
  Begin
    S := MsgTxt (I);
    If S <> '' Then
      Case S [1] Of
        '^': Begin
          Delete (S, 1, 1);
          Screen^. WriteCenter (I, vManager. Win^. GetBodyAttr, S);
        End;
        '"':
             Begin
               Delete (S, 1, 1);
               Screen^. WriteRight (vWidth - 2 * Ord (vStyle <> 0), I,
               vManager. Win^. GetBodyAttr, S);
             End;
        Else   Screen^. WritePlain (1, I, S);
      End;  {case}
  End;
  Show := vManager. Go;
  vManager. Done;
End; {BaseMessageOBJ.Show}

Function BaseMessageOBJ. WinForm: WinFormPtr;
{}
Begin
  WinForm := @vManager;
End; {BaseMessageOBJ.WinForm}

Destructor BaseMessageOBJ. Done;
{}
Var
  L: Byte;
  TempA, TempB: MsgNodePtr;
  I : Integer;
Begin
  TempA := vTxtStack;
  While TempA <> Nil do
  Begin
    TempB := TempA;
    TempA := TempB^. Next;
    If TempB^. Txt <> Nil Then
    Begin
      Move (TempB^. Txt^, L, 1);
      FreeMem (TempB^. Txt, Succ (L) ); {dispose of text}
    End;
    FreeMem (TempB, SizeOf (tempB^) );
  End;
End; {BaseMessageOBJ.Done}
{||||||||||||||||||||||||||||||||||||||||||||}
{                                            }
{     M e s s a g e O B J   M E T H O D S    }
{                                            }
{||||||||||||||||||||||||||||||||||||||||||||}
Constructor MessageOBJ. Init (Style: Byte; Tit: String);
{}
Begin
  BaseMessageOBJ. Init (Style, Tit);
  vButtonText := '  ~O~K  ';
  vButtonHK :=  79;
End; {MessageOBJ.Init}
   
Procedure MessageOBJ. SetOption (Str: String; HotKey: Word);
{}
Begin
  vButtonText := Str;
  vButtonHK := HotKey;
End; {MessageOBJ.SetOptionText}

Procedure MessageOBJ. Show;
{}
Var
  OK: Strip3dIOOBJ;
  EscHK: HotKeyIOOBJ;
  HK: HotKeyIOOBJ;
  TempAct: tAction;
Begin
  vMinWidth := Length (vButtonText) + 4;
  CalcSize;
  OK. Init (Succ ( (vWidth - Length (vButtonText) ) ) Div 2 , Succ (vTotLines), vButtonText, Finished); {1.00a}
  EscHK. Init (27, Finished);
  OK. SetHotkey (vButtonHK);
  AssignButton (OK);
  AssignButton (EscHK);
  TempAct := BaseMessageOBJ. Show;
  OK. Done;
  EscHK. Done;
End; {MessageOBJ.Show}

Destructor MessageOBJ. Done;
{}
Begin
  BaseMessageOBJ. Done
End; {MessageOBJ.Done}
{||||||||||||||||||||||||||||||||||||||||||||||||||||||||}
{                                                        }
{     B u t t o n M e s s a g e O B J   M E T H O D S    }
{                                                        }
{||||||||||||||||||||||||||||||||||||||||||||||||||||||||}
Constructor ButtonMessageOBJ. Init (Style: Byte; Tit: String);
{}
Begin
  MessageOBJ. Init (Style, Tit);
  vButtonDepth := 2;
End; {ButtonMessageOBJ.Init}
   
Procedure ButtonMessageOBJ. Show;
{}
Var
  OK: ButtonIOOBJ;
  EscHK: HotKeyIOOBJ;
  TempAct: tAction;
Begin
  CalcSize;
  OK. Init (Succ ( (vWidth - Length (vButtonText) ) Div 2) , Succ (vTotLines), {1.00a}
  vButtonText, Finished);
  OK. SetHotkey (vButtonHK);
  EscHK. Init (27, Finished);
  AssignButton (OK);
  AssignButton (EscHK);
  TempAct := BaseMessageOBJ. Show;
  EscHk. Done;
End; {ButtonMessageOBJ.Show}

Destructor ButtonMessageOBJ. Done;
{}
Begin
  MessageOBJ. Done
End; {ButtonMessageOBJ.Done}
{||||||||||||||||||||||||||||||||||||||||||}
{                                          }
{     P r o m p t O B J   M E T H O D S    }
{                                          }
{||||||||||||||||||||||||||||||||||||||||||}
Constructor PromptOBJ. Init (Style: Byte; Tit: String);
{}
Begin
  BaseMessageOBJ. Init (Style, Tit);
  SetOption (1, '   ~O~K   ', 79, Finished);        {1.00a}
  SetOption (2, ' ~C~ancel ', 67, Escaped);
  vTotPrompts := 2;
End; {PromptOBJ.Init}
   
Procedure PromptOBJ. LoadButtonRecord (Rec: Byte; Str: stringbut;
                                     Hotkey: Word; Act: tAction);
{}
Begin
  With vButtonInfo [Rec] do
  Begin
    Txt := Str;
    Code := Act;
    Len := Length (Strip ('A', '~', Str) );
    HK := Hotkey;
  End;
End; {PromptOBJ.LoadButtonRecord}

Procedure PromptOBJ. SetOption (ID: Byte; Str: stringbut; HotKey: Word; Act: tAction);
{}
Begin
  If ID in [1..3] Then
    LoadButtonRecord (ID, Str, HotKey, Act);
  If ID = 3 Then
    vTotPrompts := 3;
End; {PromptOBJ.SetOptions}

Function PromptOBJ. Show: tAction;
{}
Type 
  But = Record
          Button: Strip3dIOOBJ;
          XCoord: Byte;
        End;
Var
  MoveKeys: ControlKeysIOOBJ;
  Buttons : Array [1..3] Of But;
  Temp: Byte;
  I : Integer;
Begin
  Temp := 0;
  for I := 1 to vTotprompts do
    Inc (Temp, vButtonInfo [I].Len);
  vMinWidth := Temp + Succ (vTotPrompts) + 3; {1.00a}
  CalcSize;
  Temp := (vWidth - Temp) Div Succ (vTotPrompts);
  Buttons [1].XCoord := Temp;
  for I := 2 to vTotPrompts do
    Buttons [I].XCoord := Temp + Buttons [Pred (I) ].XCoord + vButtonInfo [Pred (I) ].Len;
  for I := 1 to vTotPrompts do
  Begin
    With Buttons [I] do
    Begin
      Button. Init (XCoord, Succ (vTotLines), vButtonInfo [I].Txt, vButtonInfo [I].Code);
      If vButtonInfo [I].HK <> 0 Then
        Button. Sethotkey (vButtonInfo [I].HK);
      AssignButton (Button);
    End; 
  End;
  MoveKeys. Init;
  AssignButton (MoveKeys);
  Show := BaseMessageOBJ. Show;
  for I := 1 to vTotPrompts do
    Buttons [I].Button. Done;
  MoveKeys. Done;
End; {PromptOBJ.Show}

Destructor PromptOBJ. Done; 
{}
Begin
  BaseMessageOBJ. Done;
End; {PromptOBJ.Done}
{||||||||||||||||||||||||||||||||||||||||||||||||||||||}
{                                                      }
{     B u t t o n P r o m p t O B J   M E T H O D S    }
{                                                      }
{||||||||||||||||||||||||||||||||||||||||||||||||||||||}
Constructor ButtonPromptOBJ. Init (Style: Byte; Tit: String);
{}
Begin
  PromptOBJ. Init (Style, Tit);
  vButtonDepth := 2;
End; {ButtonPromptOBJ.Init}
   
Function ButtonPromptOBJ. Show: tAction;
{}
Type 
  But = Record
          Button: ButtonIOOBJ;
          XCoord: Byte;
        End;
Var
  MoveKeys: ControlKeysIOOBJ;
  Buttons : Array [1..3] Of But;
  Temp: Byte;
  I : Integer;
Begin
  Temp := 0;
  for I := 1 to vTotprompts do
    Inc (Temp, vButtonInfo [I].Len + 2);
  vMinWidth := Temp + Succ (vTotPrompts);
  CalcSize;
  Temp := (vWidth - Temp) Div Succ (vTotPrompts);
  Buttons [1].XCoord := Temp;
  for I := 2 to vTotPrompts do
    Buttons [I].XCoord := Temp + Buttons [Pred (I) ].XCoord + vButtonInfo [Pred (I) ].Len + 2;
  for I := 1 to vTotPrompts do
  Begin
    With Buttons [I] do
    Begin
      Button. Init (XCoord, Succ (vTotLines), vButtonInfo [I].Txt, vButtonInfo [I].Code);
      If vButtonInfo [I].HK <> 0 Then
        Button. Sethotkey (vButtonInfo [I].HK);
      AssignButton (Button);
    End; 
  End;
  MoveKeys. Init;
  AssignButton (MoveKeys);
  Show := BaseMessageOBJ. Show;
  for I := 1 to vTotPrompts do
    Buttons [I].Button. Done;
  MoveKeys. Done;
End; {ButtonPromptOBJ.Show}

Destructor ButtonPromptOBJ. Done;
{}
Begin
  PromptOBJ. Done
End; {ButtonPromptOBJ.Done}
End.



