Unit totLINK;
{$I Sys75.Inc}

Interface

Uses DOS, CRT,
  totSTR;

Const
  NoFiles: String [20] = 'No Files';

Type

  tFileInfo = Record
                FileName: String [12];
                Path: DirStr;
                Attr: Byte;
                Time: LongInt;
                Size: LongInt;
                Tagged: Boolean;
                LoadID: LongInt;
              End; {tFileInfo}

  DLLNodePtr = ^DLLNodeObj;
  pDLLNodeOBJ = ^DLLNodeOBJ;
  DLLNodeOBJ = Object         {this object is not extensible}
                 vNextPtr: DLLNodePtr;
                 vPrevPtr: DLLNodePtr;
                 vDataPtr: Pointer;
                 vSize: LongInt;
                 vStatus: Byte;   {selectable, selected}
                 {methods...}
                 Procedure FreeData;
                 Function  NextPtr: DLLNodePtr;
                 Function  PrevPtr: DLLNodePtr;
                 Function  GetStatus (BitPos: Byte): Boolean;
                 Procedure SetStatus (BitPos: Byte; On: Boolean);
                 Function  GetStatusByte: Byte;
                 Procedure SetStatusByte (Val: Byte);
               End; {DLLNodeOBJ}

  DLLPtr = ^DLLOBJ;
  pDLLOBJ = ^DLLOBJ;
  DLLOBJ = Object
             vStartNodePtr:  DLLNodePtr;
             vEndNodePtr:    DLLNodePtr;
             vActiveNodePtr: DLLNodePtr;
             vTotalNodes:       LongInt;
             vActiveNodeNumber: LongInt;
             vSortID:           ShortInt;
             vSortAscending:    Boolean;
             vSorted:           Boolean;
             vMaxNodeSize :     LongInt;
             {methods...}
             Constructor Init;
             Function    Add (Var TheData; Size: LongInt): Integer;
             Function    Change (Node: DLLNodePtr; Var TheData; Size: LongInt): Integer;
             Function    InsertBefore (Node: DLLNodePtr; Var TheData; Size: LongInt): Integer;
             Procedure   Get (Var TheData);
             Procedure   GetNodeData (Node: DLLNodePtr; Var TheData);
             Function    GetNodeDataSize (Node: DLLNodePtr): LongInt;
             Function    GetMaxNodeSize: LongInt;
             Procedure   Advance (Amount: LongInt);
             Procedure   Retreat (Amount: LongInt);
             Function    NodePtr (NodeNumber: LongInt): DLLNodePtr;
             Procedure   Jump (NodeNumber: LongInt);
             Procedure   ShiftActiveNode (NewNode: DLLNodePtr; NodeNumber: LongInt);
             Procedure   DelNode (Node: DLLNodePtr);
             Procedure   DelAllStatus (BitPos: Byte; On: Boolean);
             Function    TotalNodes: LongInt;
             Function    ActiveNodeNumber: LongInt;
             Function    ActiveNodePtr: DLLNodePtr;
             Function    StartNodePtr: DLLNodePtr;
             Function    EndNodePtr: DLLNodePtr;
             Procedure   EmptyList;
             Procedure   Sort (SortID: ShortInt; Ascending: Boolean);
             Function    WrongOrder (Node1, Node2: DLLNodePtr; Asc: Boolean): Boolean; Virtual;
             Procedure   SwapNodes (Node1, Node2: DLLNodePtr);                       Virtual;
             Function    GetStr (Node: DLLNodePtr; Start, Finish: LongInt): String;    Virtual;
             Destructor  Done;
           End; {DLLOBJ}

  StrDLLPtr = ^StrDLLOBJ;
  pStrDLLOBJ = ^StrDLLOBJ;
  StrDLLOBJ = Object (DLLOBJ)
                {methods ...}
                Constructor Init;
                Function    Add (Str: String): Integer;
                Function    Change (Node: DLLNodePtr; Str: String): Integer;
                Function    InsertBefore (Node: DLLNodePtr; Str: String): Integer;
                Function    WrongOrder (Node1, Node2: DLLNodePtr; Asc: Boolean): Boolean; Virtual;
                Function    GetStr (Node: DLLNodePtr; Start, Finish: LongInt): String;    Virtual;
                Destructor  Done;
              End; {StrDLLOBJ}

  FileDLLPtr = ^FileDLLOBJ;
  pFileDLLOBJ = ^FileDLLOBJ;
  FileDLLOBJ = Object (DLLOBJ)
                 vFileMasks: String;
                 vFileAttrib: Word;
                 {methods ...}
                 Constructor Init;
                 Procedure   FillList;
                 Procedure   SetFileDetails (FileMasks: String; FileAttrib: Word);
                 Procedure   FillNewMask (FileMasks: String);
                 Function    GetLongStr (Node: DLLNodePtr): String;
                 Procedure   GetFileRecord (Var FileInfo: tFileInfo; Item: LongInt);
                 Function    GetFileMask: String;
                 Function    WrongOrder (Node1, Node2: DLLNodePtr; Asc: Boolean): Boolean; Virtual;
                 Procedure   SwapNodes (Node1, Node2: DLLNodePtr);                       Virtual;
                 Function    GetStr (Node: DLLNodePtr; Start, Finish: LongInt): String;    Virtual;
                 Destructor  Done;
               End; {FileDLLOBJ}

Function Subdirectory (B : Byte): Boolean;
Function Drive (B : Byte): Boolean;
Function FileAttribs (B: Byte): String;
Function LongName (Info: tFileInfo): String;

Implementation
{|||||||||||||||||||||||||||||||||||||||||||||}
{                                             }
{     M i s c.  P r o c s   &   F u n c s     }
{                                             }
{|||||||||||||||||||||||||||||||||||||||||||||}
Function Subdirectory (B : Byte): Boolean;
Begin
  Subdirectory := (B And Directory) = Directory;
End; {Subdirectory}

Function Drive (B : Byte): Boolean;
Begin
  Drive := (B And VolumeID) = VolumeID;
End; {Subdirectory}

Function FileAttribs (B: Byte): String;
Var
  S : String;
Begin
  S := '    ';
  If ( (B And ReadOnly) = ReadOnly) Then
    S [1] := 'R';
  If ( (B And Hidden) = Hidden) Then
    S [2] := 'H';
  If ( (B And SysFile) = SysFile) Then
    S [3] := 'S';
  If ( (B And Archive) = Archive) Then
    S [4] := 'A';
  FileAttribs := S;
End; {FileAttribs}

Function LongName (Info: tFileInfo): String;
{}
Var
  DT : DateTime;
  S: String;
Begin
  S := padleft (Info. FileName, 12, ' ');
  UnpackTime (Info. Time, DT);
  If Drive (Info. Attr) Then
    S := PadLeft (Info. FileName, 23, ' ')
  Else Begin
    If Subdirectory (Info. Attr) Then
      S := S + Padright ('<DIR>', 8, ' ')
    Else
      S := S + Padright (InttoStr (Info. Size), 8, ' ');
    S := S + ' ';
    With DT do
    Begin
      Case Month Of
        1 : S := S + 'Jan ';
        2 : S := S + 'Feb ';
        3 : S := S + 'Mar ';
        4 : S := S + 'Apr ';
        5 : S := S + 'May ';
        6 : S := S + 'Jun ';
        7 : S := S + 'Jul ';
        8 : S := S + 'Aug ';
        9 : S := S + 'Sep ';
        10: S := S + 'Oct ';
        11: S := S + 'Nov ';
        12: S := S + 'Dec ';
      End; {case}
      S := S + Padright (InttoStr (Day), 2, '0') + ',' + IntToStr (Year) + ' ';
      If Hour > 12 Then
        S := S + Padright (IntToStr (Hour - 12), 2, ' ') + ':' + Padright (IntToStr (Min), 2, '0') + 'p'
      Else
        S := S + Padright (IntToStr (Hour), 2, ' ') + ':' + Padright (IntToStr (Min), 2, '0') + 'a';
      S := S + ' ' + FileAttribs (Info. Attr);
    End;
  End;
  LongName := S;
End; {LongName}
{||||||||||||||||||||||||||||||||||||||||||||||}
{                                              }
{     D L L  N o d e O b j   M E T H O D S     }
{                                              }
{||||||||||||||||||||||||||||||||||||||||||||||}
Procedure DLLNodeObj. FreeData;
{}
Begin
  If (vDataPtr <> Nil) And (vSize > 0) Then
  Begin
    FreeMem (vDataPtr, vSize);
    vDataPtr := Nil;
    vSize := 0;
  End;
End; {DLLNodeObj.FreeData}

Function DLLNodeObj. NextPtr: DLLNodePtr;
{}
Begin
  NextPtr := vNextPtr;
End; {DLLNodeOBJ.NextPtr}

Function DLLNodeObj. PrevPtr: DLLNodePtr;
{}
Begin
  PrevPtr := vPrevPtr;
End; {DLLNodeOBJ.PrevPtr}

Function DLLNodeObj. GetStatus (BitPos: Byte): Boolean;
{}
Var TestByte: Byte;
Begin
  If BitPos > 7 Then
    GetStatus := False
  Else
  Begin
    Testbyte := vStatus;
    TestByte := TestByte ShR BitPos; {move to end bit}
    GetStatus := Odd (TestByte);
  End;
End; {DLLNodeOBJ.GetStatus}

Procedure DLLNodeObj. SetStatus (BitPos: Byte; On: Boolean);
{}
Var
  Test : Integer;
Begin
  If BitPos <= 7 Then
  Begin
    If On Then
    Begin
      Test := 1 ShL BitPos;
      vStatus := vStatus Or Test
    End
    Else
    Begin
      Test := Not (1 ShL BitPos);
      vStatus := vStatus And Test;
    End;
  End;
End; { DLLNodeObj.SetStatus }

Function DLLNodeObj. GetStatusByte: Byte;
{}
Begin
  GetStatusByte := vStatus;
End; {DLLNodeObj.GetStatusByte}

Procedure DLLNodeObj. SetStatusByte (Val: Byte);
{}
Begin
  vStatus := Val;
End; {DLLNodeObj.SetStatusByte}
{|||||||||||||||||||||||||||||||||||||}
{                                     }
{     D L L O b j   M E T H O D S     }
{                                     }
{|||||||||||||||||||||||||||||||||||||}
Constructor DLLOBJ. Init;
{}
Begin
  vStartNodePtr := Nil;
  vEndNodePtr := Nil;
  vActiveNodePtr := Nil;
  vTotalNodes := 0;
  vActiveNodeNumber := 0;
  vSortID := 0;
  vSortAscending := True;
  vSorted := True;
  vMaxNodeSize := 0;
End; {DLLOBJ.Init}

Function DLLOBJ. Add (Var TheData; Size: LongInt): Integer;
{ Adds node after the ActiveNodePtr, and increments the
  ActiveNodePtr.

  Returns status indicating result of attemp to add.
  Codes:          0      Success
                  1      Not enough memory
                  2      Not enough memory for data
}
Var
  Temp: DLLNodePtr;
Begin
  If MaxAvail < SizeOf (vStartNodePtr^) Then
  Begin
    Add := 1;  {not enough memory}
    Exit;
  End;
  If vStartNodePtr = Nil Then
  Begin
    GetMem (vStartNodePtr, SizeOf (vStartNodePtr^) );
    vStartNodePtr^. vPrevPtr := Nil;
    vActiveNodePtr := vStartNodePtr;
    vActiveNodePtr^. vNextPtr := Nil;
    vActiveNodeNumber := 1;
    vEndNodePtr := vActiveNodePtr;
  End
  Else
  Begin
    If vActiveNodePtr^. vNextPtr = Nil Then
    Begin
      GetMem (vActiveNodePtr^. vNextPtr, SizeOf (vActiveNodePtr^) );
      vActiveNodePtr^. vNextPtr^. vPrevPtr := vActiveNodePtr;
      vActiveNodePtr := vActiveNodePtr^. vNextPtr;
      vActiveNodePtr^. vNextPtr := Nil;
      Inc (vActiveNodeNumber);
      vEndNodePtr := vActiveNodePtr;
    End
    Else  {insert a node}
    Begin
      GetMem (Temp, SizeOf (temp^) );
      vActiveNodePtr^. vNextPtr^. vPrevPtr := Temp;
      Temp^. vNextPtr := vActiveNodePtr^. vNextPtr;
      Temp^. vPrevPtr := vActiveNodePtr;
      vActiveNodePtr^. vNextPtr := Temp;
      vActiveNodePtr := Temp;
      Inc (vActiveNodeNumber);
    End;
  End;
  Inc (vTotalNodes);
  {now add the data to the node data pointer}
  If MemAvail < Size Then
  Begin
    Add := 2;   {not enough memory for data}
    vActiveNodePtr^. vSize := 0;
    vActiveNodePtr^. vDataPtr := Nil;
    Exit;
  End;
  If Size > 0 Then
  Begin
    GetMem (vActiveNodePtr^. vDataPtr, Size);
    Move (TheData, vActiveNodePtr^. vDataPtr^, Size);
    If Size > vMaxNodeSize Then
      vMaxNodeSize := Size;
  End
  Else
    vActiveNodePtr^. vDataPtr := Nil;
  vActiveNodePtr^. vSize := Size;
  vActiveNodePtr^. vStatus := 0;
  vSorted := False;  {1.00d}
  Add := 0;
End; {DLLOBJ.Add}

Function DLLOBJ. Change (Node: DLLNodePtr; Var TheData; Size: LongInt): Integer;
{ Returns status indicating result of attemp to add.
  Codes:          0      Success
                  2      Not enough memory for data
                  3      Invalid Node Ptr
}
Begin
  If node = Nil Then
    Change := 3
  Else 
  Begin
    Node^. FreeData;
    If MaxAvail < Size Then
      Change := 2
    Else
    Begin
      Change := 0;
      GetMem (Node^. vDataPtr, Size);
      Move (TheData, Node^. vDataPtr^, Size);
      Node^. vSize := Size;
      vSorted := False;  {1.00d}
    End;
  End;
End; {DLLOBJ.Change}

Function DLLOBJ. InsertBefore (Node: DLLNodePtr; Var TheData; Size: LongInt): Integer;
{ Returns status indicating result of attemp to add.
  Codes:          0      Success
                  1      Not enough memory
                  2      Not enough memory for data
                  3      Invalid Node Ptr
}
Var
  Temp: DLLNodePtr;
Begin
  If node = Nil Then
    InsertBefore := 3
  Else If MaxAvail < SizeOf (Node^) Then
    InsertBefore := 1  {not enough memory}
  Else
  Begin
    If Node = vStartNodePtr Then {add to head of list}
    Begin
      GetMem (Node^. vPrevPtr, SizeOf (Node^) );
      Node^. vPrevPtr^. vNextPtr := Node;
      Node := Node^. vPrevPtr;
      Node^. vPrevPtr := Nil;
      vStartNodePtr := Node;
    End
    Else
    Begin
      GetMem (Temp, SizeOf (Temp^) );
      Node^. vPrevPtr^. vNextPtr := Temp;
      Temp^. vPrevPtr := Node^. PrevPtr;
      Node^. vPrevPtr := Temp;
      Temp^. vNextPtr := Node;
      Node := Temp;
    End;
    Inc (vTotalNodes);
    vActiveNodeNumber := 1;
    vActiveNodePtr := vStartNodePtr;
    If MemAvail < Size Then
    Begin
      InsertBefore := 2;   {not enough memory for data}
      Node^. vSize := 0;
      Node^. vDataPtr := Nil;
    End
    Else
    Begin
      If Size > 0 Then
      Begin
        GetMem (Node^. vDataPtr, Size);
        Move (TheData, Node^. vDataPtr^, Size);
      End
      Else
        Node^. vDataPtr := Nil;
      Node^. vSize := Size;
      InsertBefore := 0;
    End;
  End;
  vSorted := False;  {1.00d}
End; {DLLOBJ.InsertBefore}

Procedure DLLOBJ. Get (Var TheData);
Begin
  With vActiveNodePtr^ do
    If vDataPtr <> Nil Then
      Move (vDataPtr^, TheData, vSize);
End; {DLLOBJ.Get}

Procedure DLLOBJ. GetNodeData (Node: DLLNodePtr; Var TheData);
Begin
  With Node^ do
    If vDataPtr <> Nil Then
      Move (vDataPtr^, TheData, vSize);
End; {DLLOBJ.GetNodedata}

Function DLLOBJ. GetNodeDataSize (Node: DLLNodePtr): LongInt;
{}
Begin
  With Node^ do
  Begin
    If vDataPtr = Nil Then
      GetNodeDataSize := 0
    Else
      GetNodeDataSize := vSize;
  End;
End; {DLLOBJ.GetNodeDataSize}

Function DLLOBJ. GetMaxNodeSize: LongInt;
{}
Begin
  GetMaxNodeSize := vMaxNodeSize;
End; {DLLOBJ.GetMaxNodeSize}

Function DLLOBJ. GetStr (Node: DLLNodePtr; Start, Finish: LongInt): String;
{generic method..usually in descendant object}
Var temp: String;
Begin
  If Start < 0 Then Start := 0;
  If Finish < 0 Then Finish := 0;
  {validate Start and Finish Parameters}
  If ( (Finish = 0) And (Start = 0) )
     Or (Start > Finish) 
  Then   {get full string}
  Begin
    Start := 1;
    Finish := 255;
  End
  Else If Finish - Start > 254 Then      {too long to fit in string}
    Finish := Start + 254;
  
  If (Node = Nil)
     Or (Node^. vDataPtr = Nil)
     Or (Node^. vSize = 0)
     Or (Start > Node^. vSize) 
  Then
    GetStr := ''
  Else
  Begin
    If Finish > Node^. vSize Then
      Finish := Node^. vSize;
    If Start = 0 Then
      Inc (Start);
    Move (mem [Seg (Node^. vDataPtr^): Ofs (Node^. vDataPtr^) + Pred (Start) ], Temp [1], Succ (Finish - Start) );
    Temp [0] := Chr (Succ (Finish - Start) );
    GetStr := Temp;
  End;
End; {DLLOBJ.GetStr}

Procedure DLLOBJ. Advance (Amount: LongInt);
{}
Var
  I : LongInt;
Begin
  for I := 1 to Amount do
    If vActiveNodePtr^. vNextPtr <> Nil Then
    Begin
      vActiveNodePtr := vActiveNodePtr^. vNextPtr;
      Inc (vActiveNodeNumber);
    End;
End; {DLLOBJ.Advance}

Procedure DLLOBJ. Retreat (Amount: LongInt);
{}
Var
  I : LongInt;
Begin
  for I := 1 to Amount do
    If vActiveNodePtr^. vPrevPtr <> Nil Then
    Begin
      vActiveNodePtr := vActiveNodePtr^. vPrevPtr;
      Dec (vActiveNodeNumber);
    End;
End; {DLLOBJ.Retreat}

Procedure DLLOBJ. Jump (NodeNumber: LongInt);
{}
Begin
  If NodeNumber = 1 Then
  Begin
    vActiveNodePtr := vStartNodePtr;
    vActiveNodeNumber := 1;
  End
  Else
  Begin
    If NodeNumber < vActiveNodeNumber Then
      Retreat (vActiveNodeNumber - NodeNumber)
    Else
      Advance (NodeNumber - vActiveNodeNumber);
  End;
End; {DLLOBJ.Jump}

Procedure DLLOBJ. ShiftActiveNode (NewNode: DLLNodePtr; NodeNumber: LongInt);
{}
Begin
  vActiveNodePtr := NewNode;
  vActiveNodeNumber := NodeNumber;
End; {DLLOBJ.ShiftActiveNode}

Function DLLOBJ. NodePtr (NodeNumber: LongInt): DLLNodePtr;
{}
Var
  StartNode: DLLNodePtr;
  DistanceA,
  DistanceB,
  DistanceC,
  Counter,
  I: LongInt;
  Forwards : Boolean;
  Indicator : Byte;
Begin
  If (NodeNumber < 1) Or (NodeNumber > vTotalNodes) Then
    NodePtr := Nil
  Else
  Begin
    If NodeNumber = 1 Then
      NodePtr := vStartNodePtr
    Else If NodeNumber = vTotalNodes Then
      NodePtr := vEndNodePtr
    Else If NodeNumber = vActiveNodeNumber Then
      NodePtr := vActiveNodePtr
    Else
    Begin
      {check for the nearest node ptr, and jump from there}
      DistanceA := Abs (NodeNumber - vActiveNodeNumber);
      DistanceB := NodeNumber;
      DistanceC := vTotalNodes - NodeNumber;
      If DistanceA < DistanceB Then
      Begin
        If DistanceA < DistanceC Then
        Begin
          StartNode := vActiveNodePtr;
          Forwards := (vActiveNodeNumber < NodeNumber);
          Counter := DistanceA;
        End
        Else
        Begin
          StartNode := vEndNodePtr;
          Forwards := False;
          Counter := DistanceC;
        End;
      End
      Else      {DA > DB}
      Begin
        If DistanceB < DistanceC Then
        Begin
          StartNode := vStartNodePtr;
          Forwards := True;
          Counter := Pred (DistanceB);
        End
        Else
        Begin
          StartNode := vEndNodePtr;
          Forwards := False;
          Counter := DistanceC;
        End;
      End;
      If Forwards Then
        for I := 1 to Counter do
          StartNode := StartNode^. NextPtr
      Else
        for I := 1 to Counter do
          StartNode := StartNode^. PrevPtr;
      NodePtr := StartNode;
      
    End;
  End;
End; {DLLOBJ.NodePtr}

Function DLLOBJ. TotalNodes: LongInt;
{}
Begin
  TotalNodes := vTotalNodes;
End;

Function DLLOBJ. ActiveNodeNumber: LongInt;
{}
Begin
  ActiveNodeNumber := vActiveNodeNumber;
End;

Function DLLOBJ. StartNodePtr: DLLNodePtr;
{}
Begin
  StartNodePtr := vStartNodePtr;
End; {DLLOBJ.StartNodePtr}

Function DLLOBJ. EndNodePtr: DLLNodePtr;
{}
Begin
  EndNodePtr := vEndNodePtr;
End; {DLLOBJ.EndNodePtr}

Function DLLOBJ. ActiveNodePtr: DLLNodePtr;
{}
Begin
  ActiveNodePtr := vActiveNodePtr;
End; {DLLOBJ.ActiveNodePtr}

Procedure DLLOBJ. SwapNodes (Node1, Node2: DLLNodePtr);
{}
Var 
  Ptr1: Pointer;
  Size1, Size2: LongInt;
  Status1: Byte;
  Ecode: Integer;
Begin
  Status1 := Node1^. GetStatusByte;
  Node1^. SetStatusByte (Node2^. GetStatusByte);
  Node2^. SetStatusByte (Status1);
  Size1 := GetNodeDataSize (Node1);
  If Size1 > 0 Then
  Begin
    GetMem (Ptr1, Size1);
    GetNodeData (Node1, Ptr1^);
  End;
  Size2 := GetNodeDataSize (Node2);
  Ecode := Change (Node1, Node2^. vDataPtr^, Size2);
  Ecode := Change (Node2, Ptr1^, Size1);
  If Size1 > 0 Then
    FreeMem (Ptr1, Size1);
End; {DLLOBJ.SwapNodes}

Procedure DLLOBJ. DelNode (Node: DLLNodePtr);
{}
Begin
  If Node <> Nil Then  {1.00b}
  Begin
    If vActiveNodePtr = Node Then   {move active ptr to next entry in list}
    Begin
      If vActiveNodePtr^. vNextPtr = Nil Then
      Begin
        Dec (vActiveNodeNumber);
        vActiveNodePtr := vActiveNodePtr^. vPrevPtr;
      End
      Else
        vActiveNodePtr := vActiveNodePtr^. vNextPtr;
    End;
    If Node = vStartNodePtr Then
    Begin
      If Node^. vNextPtr = Nil Then {only node in list}
      Begin
        Node^. FreeData;
        FreeMem (vStartNodePtr, SizeOf (vStartNodePtr^) );
        vStartNodePtr := Nil;
        vEndNodePtr := Nil;
      End
      Else
      Begin
        vStartNodePtr := vStartNodePtr^. vNextPtr;
        vStartNodePtr^. vPrevPtr := Nil;
        Node^. FreeData;
        FreeMem (Node, SizeOf (Node^) );
      End;
    End
    Else
    Begin
      Node^. vPrevPtr^. vNextPtr := Node^. vNextPtr;
      If Node = vEndNodePtr Then
        vEndNodePtr := vEndNodePtr^. vPrevPtr
      Else
        Node^. vNextPtr^. vPrevPtr := Node^. vPrevPtr;
      Node^. FreeData;
      FreeMem (Node, SizeOf (Node^) );
    End;
    Dec (vTotalNodes);
    vSorted := False;  {1.00d}
  End;
End; {DLLOBJ.DelNode}

Procedure DLLOBJ. DelAllStatus (BitPos: Byte; On: Boolean);
{}
Var
  TempPtr, TempNextPtr: DLLNodePtr;
Begin
  If vStartNodePtr <> Nil Then
  Begin
    TempPtr := vStartNodePtr;
    TempNextPtr := TempPtr^. NextPtr;
    While TempNextPtr <> Nil do
    Begin
      If TempNextPtr^. GetStatus (BitPos) = On Then
        DelNode (TempNextPtr)
      Else
        TempPtr := TempPtr^. NextPtr;
      TempNextPtr := TempPtr^. NextPtr;
    End;
    If vStartNodePtr^. GetStatus (BitPos) = On Then
      DelNode (vStartNodePtr);
    vSorted := False;  {1.00d}
  End;
End; {DLLOBJ.DelAllStatus}

Function DLLOBJ. WrongOrder (Node1, Node2: DLLNodePtr; Asc: Boolean): Boolean;
{abstract}
Begin
  WrongOrder := False;
End; {DLLOBJ.WrongOrder}

Procedure DLLOBJ. Sort (SortID: ShortInt; Ascending: Boolean);
{Shell sort}
Var
  I, J, Delta : LongInt;
  Swapped : Boolean;
  Ptr1, Ptr2 : DLLNodePtr;
Begin
  If ( (vSortID <> SortID) Or (vSortAscending <> Ascending) Or (vSorted = False) )
     And (vTotalNodes >= 2)
  Then
  Begin
    vSortID := SortID;
    vSortAscending := Ascending;
    Delta := vTotalNodes Div 2;
    Repeat
      Repeat
        Swapped := False;
        Ptr1 := vStartNodePtr;
        Ptr2 := Ptr1;
        for I := 1 to Delta do
          Ptr2 := Ptr2^. vNextPtr;
        for I := 1 to vTotalNodes - Delta do
        Begin
          If I > 1 Then
          Begin
            Ptr1 := Ptr1^. vNextPtr;
            Ptr2 := Ptr2^. vNextPtr;
          End;
          If WrongOrder (Ptr1, Ptr2, vSortAscending) Then
          Begin
            SwapNodes (Ptr1, Ptr2);
            Swapped := True;
          End;
        End;
      Until (Not Swapped);
      Delta := Delta Div 2;
    Until Delta = 0;
  End;
  vSorted := True;
End; {DLLOBJ.Sort}

Procedure DLLOBJ. EmptyList;
{removes all the memory allocated on the heap by chaining back
 through the list and disposing of each node.}
Var TempPtr: DLLNodePtr;
Begin
  TempPtr := vEndNodePtr;
  If vEndNodePtr <> Nil Then
    While TempPtr^. vPrevPtr <> Nil do
    Begin
      TempPtr^. FreeData;
      TempPtr := TempPtr^. vPrevPtr;
      FreeMem (TempPtr^. vNextPtr, SizeOf (TempPtr^) );
    End;
  If vStartNodePtr <> Nil Then
  Begin
    vStartNodePtr^. FreeData;
    FreeMem (vStartNodePtr, SizeOf (vStartNodePtr^) );
    vStartNodePtr := Nil;
  End;
  vEndNodePtr := Nil;
  vActiveNodePtr := Nil;
  vTotalNodes := 0;
  vActiveNodeNumber := 0;
  vSorted := False;  {1.00d}
End; {DLLOBJ.EmptyList}

Destructor DLLOBJ. Done;
{}
Begin
  EmptyList;
End; {of dest DLLOBJ.Done}

{|||||||||||||||||||||||||||||||||||||||||||}
{                                           }
{     S t r D L L O b j   M E T H O D S     }
{                                           }
{|||||||||||||||||||||||||||||||||||||||||||}

{The StrDLLOBJ object is a descendant of the DLLOBJ object, and
 it is designed to specifically manipulate strings}

Constructor StrDLLOBJ. Init;
{}
Begin
  DLLOBJ. Init;
End; {StrDLLOBJ.Init}

Function StrDLLOBJ. Add (Str: String): Integer;
{}
Var
  Len : Byte;
Begin
  Len := Length (Str);
  Add := DLLOBJ. Add (Str [1], Len);
End; {StrDLLOBJ.Add}

Function StrDLLOBJ. GetStr (Node: DLLNodePtr; Start, Finish: LongInt): String;
{}
Begin
  GetStr := DLLOBJ. GetStr (Node, Start, Finish);
End; {StrDLLOBJ.GetStr}

Function StrDLLOBJ. Change (Node: DLLNodePtr; Str: String): Integer;
{}
Var
  Len: Byte;
Begin
  Len := Length (Str);
  Change := DLLOBJ. Change (Node, Str [1], Len);
End; {StrDLLOBJ.Change}

Function StrDLLOBJ. InsertBefore (Node: DLLNodePtr; Str: String): Integer;
{}
Var
  Len: Byte;
Begin
  Len := Length (Str);
  InsertBefore := DLLOBJ. InsertBefore (Node, Str [1], Len);
End; {StrDLLOBJ.InsertBefore}

Function StrDLLOBJ. WrongOrder (Node1, Node2: DLLNodePtr; Asc: Boolean): Boolean;
{}
Var S1, S2: String;
Begin
  If Asc Then Begin
    S1 := GetStr (Node1, 1, 255);
    S2 := GetStr (Node2, 1, 255);
  End Else Begin
    S1 := GetStr (Node2, 1, 255);
    S2 := GetStr (Node1, 1, 255);
  End;
  WrongOrder := (S1 > S2);
End; {StrDLLOBJ.WrongOrder}

Destructor StrDLLOBJ. Done;
{}
Begin
  DLLOBJ. Done;
End; {StrDLLOBJ.Done}
{|||||||||||||||||||||||||||||||||||||||||||||}
{                                             }
{     F i l e D L L O b j   M E T H O D S     }
{                                             }
{|||||||||||||||||||||||||||||||||||||||||||||}
Constructor FileDLLOBJ. Init;
{}
Begin
  DLLOBJ. Init;
  vFileMasks := '*.*';
  vFileAttrib := Archive + ReadOnly;
End; {FileDLLOBJ.Init}

Function FileDLLOBJ. GetStr (Node: DLLNodePtr; Start, Finish: LongInt): String;
{ignores Start and Finish parameters - first 80 bytes of the Data is
 the filename.}
Var temp : String;
Begin
  If (Node = Nil)
     Or (Node^. vDataPtr = Nil)
     Or (Node^. vSize = 0)
  Then
    GetStr := ''
  Else
  Begin
    Move (mem [Seg (Node^. vDataPtr^): Ofs (Node^. vDataPtr^) ], Temp [0], 80);
    GetStr := Temp;
  End;
End; {FileDLLOBJ.GetStr}

Function FileDLLOBJ. GetLongStr (Node: DLLNodePtr): String;
{}
Var Info: tFileInfo;
Begin
  If (Node = Nil)
     Or (Node^. vDataPtr = Nil)
     Or (Node^. vSize = 0)
  Then
    GetLongStr := ''
  Else
  Begin
    Move (mem [Seg (Node^. vDataPtr^): Ofs (Node^. vDataPtr^) ], Info, SizeOf (Info) );
    If Info. FileName = NoFiles Then
      GetLongStr := 'No matching files found'
    Else
      GetLongStr := LongName (Info);
  End;
End; {FileDLLOBJ.GetLongStr}

Procedure FileDLLOBJ. GetFileRecord (Var FileInfo: tFileInfo; Item: LongInt);
{}
Var
  Node: DLLNodePtr;
Begin
  Node := NodePtr (Item);
  If (Node = Nil)
     Or (Node^. vDataPtr = Nil)
     Or (Node^. vSize = 0)
  Then
    FileInfo. FileName := ''
  Else
    Move (mem [Seg (Node^. vDataPtr^): Ofs (Node^. vDataPtr^) ], FileInfo, SizeOf (FileInfo) );
End; {FileDLLOBJ.GetFileRecord}

Function FileDLLOBJ. GetFileMask: String;
{}
Begin
  GetFileMask := vFileMasks;
End; {FileDLLOBJ.GetFileMask}

Procedure FileDLLOBJ. SetFileDetails (FileMasks: String; FileAttrib: Word);
{}
Begin
  If FileMasks = '' Then
    FileMasks := '*.*';
  vFileMasks := FileMasks;
  vFileAttrib := FileAttrib;
End; {FileDLLOBJ.SetFileDetails}

Var
  Drv : Array [1..3] of Byte;

Procedure FileDLLOBJ. FillList;
{}
Var
  FileDetails: SearchRec;
  FileInfo: tFileInfo;
  TotMasks: Byte;
  Mask: String;
  RecSize: Byte;
  ECode : Integer;

Procedure SaveFileDetails (IsDir: Boolean);
Var
  Ext: ExtStr;
  Nam: NameStr;

  Begin
    If FileDetails. Name <> '.' Then
    Begin
      With FileInfo do
      Begin
        FileName := FileDetails. Name;
        If IsDir Then
          Path := FileName
        Else
          FSplit (FExpand (FileName), Path, Nam, Ext);
        Attr := FileDetails. Attr;
        Time := FileDetails. Time;
        Size := FileDetails. Size;
        LoadID := Succ (vTotalNodes);
        Tagged := False;
      End;  {with}
      Ecode := Add (FileInfo, RecSize);
      If Ecode = 0 Then
        vActiveNodePtr^. SetStatus (1, IsDir);
    End;
  End; {SaveFileDetails}

Procedure GetDrives;
Var
  Regs    : Registers;
  Count   : Integer;
  Fcb     : Array [1..37] of Byte;
  Drive   : DirStr;
  CurDir  : Byte;
begin
  GetDir (0, Drive);
  If IoResult = 0 Then
    CurDir := Ord (Drive [1]) - 64
  Else
    CurDir := 0;
  For Count := 1 to 26 do         {Try drives A..Z}
  begin
    if Count = curdir Then continue;
    Drv[1]  := Count + 64;         {A=ASCII 65, etc}
    Drv[2]  := Ord(':');
    Drv[3]  := 0;
    Regs.AX := $2906;          {Dos Function 29h = Parse Filename}
    Regs.SI := Ofs(Drv[1]);    {Point to drive String}
    Regs.DI := Ofs(Fcb[1]);    {Point to File Control Block}
    Regs.DS := DSeg;
    Regs.ES := DSeg;
    MsDos(Regs);               {Dos Interrupt}
    if Regs.AL = $FF then continue;
    FillChar (FileInfo, Sizeof (FileInfo), 0);
    With FileInfo do Begin
      FileName := '[-' + Chr (Count + 64) + '-]';
      Path := Chr (Count + 64) + ':';
      Attr := VolumeId;
      LoadID := Succ (vTotalNodes);
    End;
    Ecode := Add (FileInfo, RecSize);
    If Ecode = 0 Then
      vActiveNodePtr^. SetStatus (1, True);
  end;
End;

  Procedure ProcessFiles (Attrib: Word);
  {}
  Var I : Integer;
  Begin
    for I := 1 to TotMasks do
    Begin
      If Attrib = Directory Then
        Mask := '*.*'
      Else
        Mask := ExtractWords (I, 1, vFileMasks);
      FindFirst (Mask, Attrib, FileDetails);
      While DosError = 0 do
      Begin
        If (Attrib <> Directory) Then
          SaveFileDetails (False)
        Else If ( (Attrib = Directory) And (FileDetails. Attr = Directory) ) Then
          SaveFileDetails (True);
        FindNext (FileDetails);
      End;
      If Attrib = Directory Then   {1.00c}
        Exit;
    End;
  End; {ProcessFiles}

Begin
  RecSize := SizeOf (FileInfo);
  If vStartNodePtr <> Nil Then
    EmptyList;
  TotMasks := WordCnt (vFilemasks);
  If ( (vFileAttrib And Directory) = Directory) Then
  Begin
    GetDrives;
    ProcessFiles (Directory);
    If vFileAttrib <> Directory Then {1.00a}
      ProcessFiles (vFileAttrib And (AnyFile- Directory - VolumeID) );
  End
  Else
    ProcessFiles (vFileAttrib);
  If vTotalNodes = 0 Then
  Begin
    FileInfo. Filename := NoFiles;
    FileInfo. Time := 0;
    FileInfo. Tagged := False;
    Ecode := Add (FileInfo, RecSize);
  End;
  vSorted := (vSortID = 0) And (vSortAscending = True);
End; {FileDLLOBJ.FillList}

Procedure FileDLLOBJ. FillNewMask (FileMasks: String);
{}
Begin
  SetFileDetails (FileMasks, vFileAttrib);
  FillList;
End; {FileDLLOBJ.FillNewMask}

Function FileDLLOBJ. WrongOrder (Node1, Node2: DLLNodePtr; Asc: Boolean): Boolean;
{}
Var F1, F2: tFileInfo;
  P: Integer;
  Name1, Name2: String [8];
  Ext1, Ext2: String [3];

Function Name (F: tFileInfo): String;
    {}
    Begin
      P := Pos ('.', F. FileName);
      If P = 0 Then
        Name := F. FileName
      Else
        Name := Copy (F. FileName, 1, Pred (P) );
    End; {Name}

    Function Ext (F: tFileInfo): String;
    {}
    Begin
      P := Pos ('.', F. FileName);
      If P = 0 Then
        Ext := ''
      Else
        Ext := Copy (F. FileName, Succ (P), 3);
    End; {Ext}

Begin
  FillChar (F1, SizeOf (F1), #0);
  FillChar (F2, SizeOf (F2), #0);
  If Asc Then
  Begin
    GetNodeData (Node1, F1);
    GetNodeData (Node2, F2);
  End
  Else
  Begin
    GetNodeData (Node1, F2);
    GetNodeData (Node2, F1);
  End;
  Case vSortID Of
    0: WrongOrder := (F1.LoadID > F2.LoadID);  {DOS}
    1:
       Begin                                    {NAME}
         Name1 := Name (F1);
         Name2 := Name (F2);
         If (Name1 = Name2) Then
           WrongOrder := (Ext (F1) > Ext (F2) )
         Else
           WrongOrder := (Name1 > Name2);
       End;
    2:
       Begin                                    {EXT}
         Ext1 := Ext (F1);
         Ext2 := Ext (F2);
         If Ext1 = Ext2 Then
           WrongOrder := (Name (F1) > Name (F2) )
         Else
           WrongOrder := (Ext1 > Ext2);
       End;
    3: WrongOrder := (F1.Size > F2.Size);      {SIZE}
    4: WrongOrder := (F1.Time > F2.Time);      {TIME}
    Else WrongOrder := False;
  End; {case}
End; {FileDLLOBJ.WrongOrder}

Procedure FileDLLOBJ. SwapNodes (Node1, Node2: DLLNodePtr);
{}
Var
  FileInfo: tFileInfo;
  Size: LongInt;
  Status1: Byte;
Begin
  Status1 := Node1^. GetStatusByte;
  Node1^. SetStatusByte (Node2^. GetStatusByte);
  Node2^. SetStatusByte (Status1);
  GetNodeData (Node1, FileInfo);
  Size := SizeOf (FileInfo);
  Move (Node2^. vDataPtr^, Node1^. vDataPtr^, Size);
  Move (FileInfo, Node2^. vDataPtr^, Size);
End; {FileDLLOBJ.SwapNodes}

Destructor FileDLLOBJ. Done;
{}
Begin
  DLLOBJ. Done;
End; {FileDLLOBJ.Done}
End.
