{$A+,B+,D-,E+,F+,I+,L-,N-,O+,R-,S+,V-}
USES DOS,CRT,TOTLINK,STRINGS;
TYPE

  xy = Record
    x, y: byte;
  end;

  axy = Record
    a, x, y: byte;
  end;

  menurec =                        { *.Mnu : Menu records }
  Record
    Name: String [8];              { used to specify which menu to load }
    prompt: String;                { menu prompt if script or name }
    helpfile: PathStr;             { help or pulldown display file }
    acs: STRING;                   { minimum acs requirements }
    password: STRING;              { password required }
    Special: String [2];           { menu type }
    FallBack: String [8];          { menu to set as fallback }
  End;

  pullinfo=
  Record
    ON:STRING;
    OFF:STRING;
    X:1..80;
    Y:1..25;
    END;

  commandrec =                { *.Cmd : Command records }
  Record
    desc: string[30];              { description for generics and reference only }
    keys: string[30];              { command-execution keys }
    acs: string[30];               { minimum acs requirements }
    data: String [2];              { the actual command }
    param: String;                 { command data }
    pull: PULLINFO;            { for pulldown menus }
    hidden: boolean;               { should command show up in generic menus? }
    pause: boolean;                { wait for enter after command? }
  End;

  pulldownrec = record
    vaxy: axy;
    comm: commandrec;
  end;
  var pulldown,
      list:pDLLobj;
      cmdlist: pDllobj;
      menu:Menurec;
      command:commandrec;
  Const
  FailFlag     : Boolean = False;
  NewMenu      : Boolean = False;
  LOGOFF       : BOOLEAN = FALSE;
  RunFirstCmd  : Boolean = True;
  BadMenu      : Boolean = False;
  MaxInLen     : Byte = 80;
  TopMenu      : String[8] = '';
  CurMenu      : String[8] = '';
  BadCommandStr: String = '';
  InputStr     : String = '';
  WildCardStr  : String = '';
const
  maxchoices=30;
type
PULLD=RECORD
    CURRENTCHOICE:INTEGER;
    K:CHAR;
    CH:INTEGER;
    MAXC:INTEGER;
    UNHIGHLIGHT:ARRAY[1..MAXCHOICES] OF STRING[80];
    HIGHLIGHT:ARRAY[1..MAXCHOICES] OF STRING[80];
    COMMANDCHAR:ARRAY[1..MAXCHOICES] OF CHAR;
    CX:ARRAY[1..MAXCHOICES] OF INTEGER;
    CY:ARRAY[1..MAXCHOICES] OF INTEGER;
    END;
VAR PM:PULLD;
FUNCTION LPULLMENU:INTEGER;
    VAR X:INTEGER;
    CINPUT:CHAR;
    C:CHAR;

BEGIN
FOR X:=1 TO pm.MAXC DO BEGIN
GOTOXY(pm.CX[X],pm.CY[X]);
WRITE(pm.UNHIGHLIGHT[X]);
END;
GOTOXY(pm.CX[pm.CURRENTCHOICE],pm.CY[pm.CURRENTCHOICE]);
WRITE(pm.HIGHLIGHT[pm.CURRENTCHOICE]);
REPEAT
    C:=READKEY;
    if c=#0 then begin
    c:=readkey;
IF ORD(C) IN [72,75] THEN BEGIN
    GOTOXY(pm.CX[pm.CURRENTCHOICE],pm.CY[pm.CURRENTCHOICE]);
    WRITE(pm.UNHIGHLIGHT[pm.CURRENTCHOICE]);
    DEC(pm.CURRENTCHOICE);
    IF pm.CURRENTCHOICE=0 THEN pm.CURRENTCHOICE:=pm.MAXC;
    GOTOXY(pm.CX[pm.CURRENTCHOICE],pm.CY[pm.CURRENTCHOICE]);
    WRITE(pm.HIGHLIGHT[pm.CURRENTCHOICE]);
    END ELSE
IF ORD(C) IN [77,80] THEN BEGIN
    GOTOXY(pm.CX[pm.CURRENTCHOICE],pm.CY[pm.CURRENTCHOICE]);
    WRITE(pm.UNHIGHLIGHT[pm.CURRENTCHOICE]);
    INC(pm.CURRENTCHOICE);
    IF pm.CURRENTCHOICE=pm.MAXC+1 THEN pm.CURRENTCHOICE:=1;
    GOTOXY(pm.CX[pm.CURRENTCHOICE],pm.CY[pm.CURRENTCHOICE]);
    WRITE(pm.HIGHLIGHT[pm.CURRENTCHOICE]);
    END;
end;
UNTIL ORD(C) IN [13];
LPULLMENU:=pm.CURRENTCHOICE;
END;

  procedure loadmenu(name:String);
  var f:FILE OF MENUREC;
      G:FILE OF COMMANDREC;
      X:INTEGER;
  begin
  assign(f,name+'.DAT');
  reset(f);
  FILLCHAR(MENU,SIZEOF(MENU),#0);
  READ(F,MENU);
  CLOSE(F);
  assign(G,name+'.MNU');
  reset(G);
  NEW(CMDLIST,INIT);
  X:=0;
  REPEAT
  SEEK(G,X);
  FILLCHAR(COMMAND,SIZEOF(COMMAND),#0);
  READ(G,COMMAND);
  CMDLIST^. Add (Command, Sizeof (Command));
  INC(X);
  UNTIL EOF(G);
  CLOSE(G);
  end;

  PROCEDURE ADDCOMMAND(NAME:STRING;A:COMMANDREC);
  VAR F:FILE OF COMMANDREC;
  BEGIN
  ASSIGN(F,NAME+'.MNU');
  {$I-} RESET(F); {$I+}
  IF IORESULT<>0 THEN REWRITE(F);
  SEEK(F,FILESIZE(f));
  WRITE(F,A);
  CLOSE(f);
  END;

  PROCEDURE PROCESS(C:COMMANDREC);
  BEGIN
  IF C.DATA='-L' THEN WRITE(#7) ELSE
  IF C.DATA='-G' THEN BEGIN
  LOGOFF:=TRUE;
  DISPOSE(CMDLIST);
  END
  ELSE

  IF C.DATA='LM' THEN BEGIN
  DISPOSE(CMDLIST);
  NEWMENU:=TRUE;
  LOADMENU(COMMAND.PARAM);
  END;

  END;

  PROCEDURE RUNMENU;
  VAR E:INTEGER;
      CHOICE:INTEGER;
      INPUT:STRING;
  BEGIN
  IF MENU.SPECIAL='PD' THEN BEGIN
  FOR E:=1 TO CMDLIST^.TOTALNODES DO BEGIN
  CMDLIST^. GetNodeData (CMDLIST^. NodePtr (E), Command);
  PM.UNHIGHLIGHT[E]:=COMMAND.PULL.OFF;
  PM.HIGHLIGHT[E]  :=COMMAND.PULL.ON;
  PM.CX[E]         :=COMMAND.PULL.X;
  PM.CY[E]         :=COMMAND.PULL.Y;
  PM.MAXC:=CMDLIST^.TOTALNODES;
  PM.CURRENTCHOICE:=1;
  END;
  CHOICE:=LPULLMENU;
  CMDLIST^. GetNodeData (CMDLIST^. NodePtr (CHOICE), Command);
  PROCESS(COMMAND);
  END ELSE
  IF MENU.SPECIAL='LI' THEN BEGIN
  WRITE(MENU.PROMPT);
  READLN(INPUT);
  FOR E:=1 TO CMDLIST^.TOTALNODES DO BEGIN
  CMDLIST^. GetNodeData (CMDLIST^. NodePtr (E), Command);
  IF COMMAND.KEYS=INPUT THEN PROCESS(COMMAND);
  IF NEWMENU=TRUE THEN BEGIN
  NEWMENU:=FALSE;
  EXIT;
  END;
  END;
  END;
  END;

  VAR G:INTEGER;
  BEGIN
  COMMAND.DESC:='LOGOFF';
  COMMAND.KEYS:='G';
  COMMAND.ACS:='';
  COMMAND.DATA:='-G';
  COMMAND.PARAM:='';
  COMMAND.PULL.ON :='|B1|15 LOGOFF ';
  COMMAND.PULL.OFF:='|B0|15 LOGOFF ';
  COMMAND.PULL.X:=64;
  COMMAND.PULL.Y:=19;
  COMMAND.HIDDEN:=TRUE;
  COMMAND.PAUSE:=FALSE;
  ADDCOMMAND('MATRIX',COMMAND);


  END.

