Unit Extense;
{$G+}
Interface

Const
  Multiplex = $2f;
  std_dos   = $21;

TYpe MStr = String[80];

var
  Screen : Array[0..$b800] of byte absolute $b800:0000;
  {windows information variables}
  Win_Installed  : boolean;
  Win_HiVer      : integer;
  Win_LoVer      : integer;
  Win_386enh     : boolean;
  Win_machver    : word;
  {OS information Variables}
  _4Dos_Installed : Boolean;
  _4Dos_Hiver     : Integer;
  _4Dos_Lover     : Integer;
  Shell_Num      : Integer;
  Dos_Hiver      : Integer;
  Dos_Lover      : Integer;
  {DesqView Information variables}
  Dv_Installed   : boolean;
  Dv_HiVer       : integer;
  Dv_LoVer       : integer;

{-- Video Functions --}
Function  IsVesa:Boolean;
Function  VGACard : Boolean;
Procedure ClearLine(Line : Byte);
Procedure Reset_Video;
Procedure Set8x16Font;
Procedure GotoXy(x,y : Word);
Procedure Setcursorshape(shape : word);
Procedure qwrite(x,y:byte;s:string;f,b:byte;CharsperRow:Word);
Procedure Uncrunch(var Addr1,Addr2; BlkLen:Integer);
Procedure Putpixel(X,Y : Word;Color : Byte);
Procedure SetScreenStart(ScanLine:word);

{-- Keyboard Functions --}
Procedure SetTypeRate(Kdelay, Krate:Byte);
Function  ScrollLock : Boolean;
Function  CapsLock   : Boolean;
Function  InsKey     : Boolean;
Procedure WaitRetrace;
Function  Yesno(unlit,lit : Byte) : Boolean;
Procedure InputNums(var Lne:String;Chars:Byte;AllowZero:Boolean);
Procedure InputLn(var Lne:String;Chars:Byte;Caps:Boolean;Allcaps:Boolean);
Procedure InputRelaxed(var Lne:String;Chars:Byte;Caps:Boolean;Allcaps:Boolean);
Procedure GetKeys(Var C1 : Char;Var C2 : Char);
Function  Get_Extended_KeyCode : Word;

{-- String Functions --}
Function  Uppercase(Str : String) : String;
Function  Strr(I : LongInt) : String;
Function  Center(Str : String) : Byte;
Function  Padcenter(Str : String;Amount : Byte) : String;
Function  Padstring(Outp : String;Number : Byte): String;
Function  LeadingZero(w : Word) : String;
Function  ASCIZToString (ASCIZ: array of Char): String;
Function  StrJust(S : String; Size : Byte) : String;
function  Real2String (r:real):mstr;
function  Str2Byte(q:mstr):integer;
Function Hex(Value:byte):string;

{-- Memory Handling --}
Procedure FillWord(var x; count:integer; w:word);
Procedure FastMove(VAR source;VAR dest;numToMove : WORD);
Procedure MovW(var source,dest; num: word);
Procedure Cold_Boot;
Procedure Warm_Boot;

{-- Bitwise Opperations --}
Function  GetBitA(var a;Bit:Word):Boolean;
Procedure InvertBitA(var a;Bit:Word);

{-- Misc. Schtuff --}
Procedure Draw_Dialog(X,Y,Height : Byte);
Procedure Clear_Column(Column : Byte);
Procedure Beep(Freq,Dely : Word);
Procedure PipeWrite(S : String);
procedure mousesensetivity(x,y:word);
Procedure FadeWrite(Strng : String);

{-- Clearing Functions --}
Procedure Woop_dat_screen;
Procedure PulltheBars;
Procedure RollUp;
Procedure Column_Clear;
Procedure Row_Clear;
Procedure Close_Horizontal;
Procedure Close_Vertical;
Procedure SlideUp;
Procedure SlideDown;
Procedure SlideLeft;
Procedure SlideRight;
Procedure Squish_Screen;

{-- File Handling --}
Function  FileExist(FileName : String) : Boolean;
Procedure DeleteFile(FileName : string);
Function  DirExist(StDir : String): Boolean;

Implementation

Uses Dos,Crt,Strings;

Var Kb : Byte Absolute $0040:$0017;

Function ASCIZToString (ASCIZ: array of Char): String;
begin
 ASCIZToString := StrPas(@ASCIZ);
end;

Function Hex(Value:byte):string;
Const HexTable : Array[0..15] of Char=
('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
Var HexStr : String;
Begin
  HexStr[2]:=HexTable[Value and $0F];        { Convert low nibble }
  HexStr[1]:=HexTable[Value and $F0 div 16]; { Convert high nibble }
  HexStr[0]:=#2; { Set Stringlength }
  Hex := HexStr;
End;


function Str2Byte(q:mstr):integer;
var i,s,pu: integer;
    r     : real;
begin
  While Q[Byte(Q[0])]=#32 Do Q[Byte(Q[0])]:=Pred(Q[Byte(Q[0])]);
  Str2Byte:=0;
  if byte(q[0])=0 then exit;
  if not (q[1] in ['0'..'9','-']) then exit;
  if byte(q[0])>5 then exit;
  val (q,r,s);
  if s<>0 then exit;
  if (r<=32767.0) and (r>=-32767.0)
    then Str2Byte:=round(r)
end;


function Real2String (r:real):mstr;
var q:mstr;
begin
 str (r:0:0,q);
 Real2String := q
end;

Function StrJust(S : String; Size : Byte) : String;
Begin
  While Length(S) < Size Do Insert(#32, S, 1);
  StrJust := S;
End;

Procedure DeleteFile(FileName : string); Assembler;
Asm
  push ds
  lds si,FileName
  inc byte ptr [si]
  mov bl,byte ptr [si]
  xor bh,bh
  mov dx,si
  inc dx
  mov byte ptr [si+bx],0
  mov ah,41h
  int 21h
  pop ds
End;


Procedure Warm_Boot;
Begin
 Inline($BB/$00/$01/$B8/$40/$00/$8E/$D8/$89/$1E/$72/$00/$EA/$00/$00/$FF/$FF);
End;

Procedure Cold_Boot;
Begin
 Inline($BB/$38/$12/$B8/$40/$00/$8E/$D8/$89/$1E/$72/$00/$EA/$00/$00/$FF/$FF);
End;

Procedure Squish_Screen;
Label Rulp;
Begin
 asm           { Clear the Next 4 Screens in video memory }
  cld
  mov     ax,0b800h
  mov     es,ax
  mov     di,4000
  mov     cx,8000
  mov     ax,0720h
  rep     stosw
  mov     cx,0fh
 End;
rulp:
 asm
  mov     dx,3d4h
  mov     ah,cl
  mov     al,9
  out     dx,ax
 end;
waitretrace;
 asm
  loop    rulp
  xor     di,di
  mov     cx,2000
  mov     ax,0720h
  rep     stosw
  mov     dx,3d4h
  mov     ah,0fh
  mov     al,9
  out     dx,ax
 end;
 asm
  mov ax,3; int 10h;
 end;
End;


Procedure Draw_Dialog(X,Y,Height : Byte);
Var P : Byte;
Begin
 Qwrite(X,Y,'     ',8,0,80);
 GotoXy(X,Y+1);PipeWrite('|08  |07|08  ');
 GotoXy(X,Y+2);PipeWrite('|08 |15|23                                          |16|07|08  ');
 For P := 1 to Height do
  Begin
   GotoXy(X,Y+3+P-1);
   PipeWrite('|08|15|23|23                                          |16|07|08 ');
  End;
 GotoXy(X,Y+Height+3);PipeWrite('|08 |08|08|23|23|15                                         |16|07|08   ');
 GotoXy(X,Y+Height+4);
 Pipewrite('|08  |07|08   ');
 Qwrite(X,Y+height+5,'           ',8,0,80);
End;


Function DirExist(StDir : String): Boolean;
Var
  WoFattr : Word;
  FiTemp  : File;
Begin
 Assign(fiTemp, (stDir + '.'));
 Getfattr(fiTemp, woFattr);
 if (doserror <> 0) then DirExist := false
                    else DirExist := ((woFattr and directory) <> 0)
End;

Procedure InputRelaxed(var Lne : String;Chars:Byte;Caps:Boolean;Allcaps:Boolean);
Var
 StartedX,X,Y,Counter,OldAttr : Byte;
 CH   : Char;
 P    : String;
 Done : boolean;
Begin
 OldAttr  := Textattr;
 StartedX := WhereX;
 P        := '';
 Counter  := 0;
 asm mov ah,1; mov ch,6; mov cl,7;int 10h; end; {Yes Cursor}
 Done := False;
 For X := 1 to Chars do Write(' ');GotoXy(StartedX,WhereY);
Repeat
 X := WhereX;
 Y := WhereY;
 MemW[$0000:$041C] := MemW[$0000:$041A];
 CH := Readkey;If CH = #0 then CH := Readkey;
 Case CH of
  #8 : If Counter > 0 then
        Begin
         GotoXy(X-1,Y);Write(' ');
         GotoXy(X-1,Y);Delete(P,Length(P),1);
         Dec(Counter);
        End;
 #13 : Done := True;
 #27 : Begin
        P := 'Aborted';
        Done := True;
       End;
 #32..#255 : If Counter < Chars then
              Begin
               Inc(Counter);
               If Caps then If (P[Counter-1]=#0) or (P[Counter-1]=#32) or (P[Counter-1]=',') then
                CH := Upcase(CH);
               If Allcaps then CH := Upcase(CH);
               P := P + (CH);
               Write(CH);
              End;
     End;
 Until Done = True;
 Lne := P;
 GotoXy(StartedX,WhereY);
 Textattr := 7;For X := 1 to Chars do Write(' ');
 If Lne <> 'Aborted' then Begin
                            GotoXy(StartedX,WhereY);
                            Write(Lne);
                          End;
 Textattr := OldAttr;
End;


Function Get_Extended_KeyCode : Word;
Var Regs : Registers;
Begin
  regs.ah := $10;
  intr($16, regs);
  Get_Extended_KeyCode := (regs.ah shl 4) + regs.al;
End;

Procedure FadeWrite(Strng : String);
Var
 StartX,StartY,X : Byte;
Begin
 StartX := WhereX;
 StartY := WhereY;
 Strng := Strng + '    ';
 For X := 1 to Length(Strng)-4 do
  Begin
   GotoXy(X,WhereY);
   textattr := 8;
   GotoXy(StartX,StartY);
   Write(Copy(Strng,1,X-1));
   Textattr := 8;Write(Strng[X]);
   Textattr := 3;Write(Strng[X+1]);
   Textattr := 11;Write(Strng[X+2]);
   Delay(50);
  End;
End;


procedure FillWord(var x; count:integer; w:word);
Begin
 Inline($c4/$be/x/$8b/$86/w/$8b/$8e/count/$fc/$f2/$ab);
End;

Procedure SetScreenStart(ScanLine:word);
Var StartAddress: Word;
Begin
 StartAddress := (ScanLine div 16)*80;
 portw[$3D4] := hi(StartAddress) shl 8 + $0C;    { Set start address     }
 portw[$3D4] := lo(StartAddress) shl 8 + $0D;
 repeat until port[$3DA] and 8<>0;               { wait for retrace      }
 portw[$3D4] := (ScanLine mod 16) shl 8 + 8;     { Set start scanline    }
 repeat until port[$3DA] and 8=0;                { wait out retrace      }
End;

Function Padcenter(Str : String;Amount : Byte) : String;
Var X : Byte;
 Temp : String;
Begin
 Temp := Str;
 For X := 1 to (Amount div 2) do Temp := ' ' + Temp;
 For X := 1 to (Amount div 2) do Temp := Temp + ' ';
 Padcenter := Temp;
End;


Function Strr(I : LongInt) : String;
Var Strng : String;
Begin
 Str(I,Strng);
 Strr  := Strng;
End;

procedure GoToXY(x,y : word);
begin
  asm
    mov    ax,y
    mov    dh,al
    dec    dh
    mov    ax,x
    mov    dl,al
    dec    dl
    mov    ah,2
    xor    bh,bh
    int    10h
  end
end;

Procedure RollUp;
Var X,Y : Integer;
Begin
 For X := 1 to 40 do
Begin
  WaitRetrace;
 For Y := 0 to 25 do
 Begin
  FastMove(Mem[$B800:((Y*160)+ 82)],Mem[$B800:((Y*160)+80)],80);
  FastMove(Mem[$B800:((Y*160))],Mem[$B800:((Y*160)+2)],80);
  Mem[$b800:(Y*160)+1] := 0;
  Mem[$b800:(Y*160)+158] := 0;
 End;
End;
End;

Procedure Woop_dat_screen;
Var X,Y: Byte;
Begin
 For X := 1 to 80 do
 Begin
 WaitRetrace;
 For Y := 0 to 12 do
  Begin
   Mem[$b800:0000+(Y*160)+158] := 0;
   Mem[$b800:0000+(Y*160)+159] := 0;
   Fastmove(Mem[$b800:0000+(Y*160)+2],Mem[$b800:0000+(Y*160)],160-2);
  End;
 For Y := 13 to 25 do
  Begin
   Mem[$b800:0000+(Y*160)+0] := 0;
   Mem[$b800:0000+(Y*160)+1] := 0;
   Fastmove(Mem[$b800:0000+(Y*160)],Mem[$b800:0000+(Y*160)+2],160-2);
  End;
 End;
End;


Procedure Putpixel(X,Y : Word;Color : Byte);Assembler;
Asm
 MOV ax,$a000
 MOV es,ax
 MOV ah,byte ptr y
 MOV bx,x
 ADD bx,ax
 SHR ax,2
 ADD bx,ax
 MOV al,color
 MOV es:[bx],al
End;

Procedure Reset_Video;Assembler;
Asm
 mov ax,3
 int 10h
End;


Function FileExist(FileName : String) : Boolean; ASSEMBLER;
Asm
  PUSH DS          {Save DS                         }
  LDS  SI,Filename {DS:SI => Filename               }
  XOR  BX,BX       {Clear BX                        }
  MOV  BL,[SI]     {BX = Length(Filename)           }
  INC  SI          {DS:SI => Filename[1]            }
  MOV  DX,SI       {DS:DX => Filename[1]            }
  MOV  [SI+BX],BH  {Append Ascii 0 to Filename      }
  MOV  AX,4300h    {Get Attribute Function Code     }
  INT  21h         {Get File Attributes             }
  MOV  AL,BH       {Default Result = FALSE          }
  ADC  CL,CL       {Attribute * 2 + Carry Flag      }
  AND  CL,31h      {Directory or VolumeID or Failed }
  JNZ  @@Done      {Yes - Exit                      }
  INC  AL          {No - Change Result to TRUE      }
@@Done:
  POP  DS          {Restore DS                      }
End; {FileExists}

Function LeadingZero(W : Word) : String;
Var S : String;
Begin
 Str(w:0,S);
 If Length(s) = 1 then S := '0'+S;
 LeadingZero := S;
End;

Function Uppercase(Str : String) : String;
Var X : Byte;
Begin
 For X := 1 to Length(Str) do Str[X] := Upcase(Str[X]);
 Uppercase := Str;
End;

Procedure ClearLine(Line : Byte);
Begin
 GotoXy(1,Line);ClrEol;
End;
Procedure Mousesensetivity(x,y:word); Assembler;
Asm
 mov ax,1ah;
 mov bx,x;
 mov cx,y;
 xor dx,dx;
 int 33h
end;

Procedure Setcursorshape(Shape : word);Assembler;
Asm
 mov ah,1;
 mov cx,shape;
 int 10h;
End;

{Procedure Set8x16Font;assembler;
Asm
 mov dx,03c4h
 mov ax,0100h
 out dx,ax
 mov dx,03c4h
 mov ax,0301h
 out dx,ax
 mov dx,03c2h
 mov al,063h
 out dx,al
 mov dx,03c4h
 mov ax,0300h
 out dx,ax
 mov dx,03d4h
 mov ax,4f09h
 out dx,ax
end;}

Procedure Set8x16Font;ASsembler;
ASM
 MOV    DX,003CCh         { Misc output register READ port    }
 IN     AL,DX             { Read value.                       }
 AND    AL,0F3h           { Bits 2 & 3 off (Clock select 0).  }
 MOV    DX,003C2h         { Misc Output Write port            }
 OUT    DX,AL             { Writeback modified value          }

 CLI                      { NO interrupts for a while         }
 MOV    DX,03C4h          { Sequencer register                }
 MOV    AX,100h           { \ Generate and hold Synchronous   }
 OUT    DX,AX             { / reset                           }

 MOV    AL,001h           { Clocking mode register            }
 OUT    DX,AL             { Activate Clocking mode register   }
 INC    DX                { Data register                     }
 IN     AL,DX             { Read value                        }
 OR     AL,1              { Set Bit 0 (8/9)                   }
 OUT    DX,AL             { Writeback.                        }
 DEC    DX                { Back to Address register          }

 MOV    AX,300h           { \ Release Reset state. (normal)   }
 OUT    DX,AX             { /                                 }

 MOV    DX,03DAh         { CRTC Status register              }
 IN     AL,DX             { Read CRTC Status. (This'll reset  }
                          { Attribute controller flip-flop)   }
 MOV    DX,03C0h         { Attribute controller              }
 MOV    AL,13h            { Horizontal Pixel Pan              }
 OUT    DX,AL             { Activate HPP                      }
 MOV    AL,0              { \ Set HPP to 0                    }
 OUT    DX,AL             { /                                 }
 MOV    AL,20h
 OUT    DX,AL             { Set PAS field (Video has access   }
                          { to palette)                       }

 STI                      { Interrupts allowed again          }
END;

Function CapsLock : Boolean;
Begin
 if (Kb and $40) = $40 then Capslock := True else Capslock := False;
End;

Function ScrollLock : Boolean;
Begin
 If (Kb and $10) = $10 then ScrollLock := True Else ScrollLock := False;
End;

Function Inskey : Boolean;
Function ShiftState: Byte;
Var Regs: Registers;
Begin
  Regs.Ah:=2;
  Intr($16, Regs);
  ShiftState:=Regs.Al;
End;
Begin
 InsKey :=(ShiftState and 128)<>0;
End;

Procedure SetTypeRate(Kdelay, Krate:Byte);Assembler;
asm
 Mov AX,$0305;
 Mov BH, Kdelay;
 Mov BL, Krate;
 Int $16;
End;

{Procedure Blinking(State : Boolean);Assembler;
Asm
 MOV AX,1003h
 MOV BH,0
 MOV BL,State
 INT 10h
End;}

Procedure GetKeys(Var C1 : Char;Var C2 : Char);
Begin
 C1 := #0;C2 := #0;
 C1 := Readkey;If C1 = #0 then C2 := Readkey;
End;

Function Padstring(Outp : String;Number : Byte): String;
Var X : Byte;
Begin
 For X := 1 to (Number - Length(Outp)) do Outp := Outp + ' ';
 Padstring := Outp;
End;

Function VGACard : Boolean;
Var VideoCard : Byte;
  Begin
   Asm
    MOV AX,1A00h
    INT 10h
    CMP AL,08h
    JNZ @VGA
    MOV VideoCard,0
    JMP @DONE
   @VGA:
    MOV VideoCard,1
   @DONE:
   End;
  If VideoCard = 1 then VGACard := True Else VGACard := False;
End;

Procedure InputNums(var Lne : String;Chars : Byte;AllowZero : Boolean);
Var StartedX,X,Y,Counter : Byte;
    CH       : Char;
    P        : String;
    Done     : Boolean;
    Lower : Byte;
Begin
asm mov ah,1; mov ch,6; mov cl,7;int 10h; end; {Yes Cursor}
P := '';
Counter := 0;
StartedX := WhereX;
For X := 1 to Chars do Write(' ');
GotoXy(StartedX,WhereY);
Done := False;
Repeat
 X := WhereX;
 Y := WhereY;
 MemW[$0000:$041C] := MemW[$0000:$041A];
 CH := Readkey;
 If Allowzero then Lower := 48 else Lower := 49;
 If CH = #8 then If Counter > 0 then
                  Begin
                   GotoXy(X-1,Y);Write(' ');
                   GotoXy(X-1,Y);Delete(P,Length(P),1);
                   Dec(Counter);
                  End;
 If CH = #13 then Done := True;
 If CH = #27 then
             Begin
              P := 'Aborted';
              Done := True;
             End;
 If Counter < Chars then
     If (Ord(CH) < 58) and (Ord(CH) > Lower-1) then
             Begin
              Inc(Counter);
              P := P+(CH);
              Write(CH);
             End;
 Until (Done = True);
 Lne := P;
 GotoXy(StartedX,WhereY);
 For X := 1 to Chars do Write(' ');
 If Lne <> 'Aborted' then
  Begin
   GotoXy(StartedX,WhereY);
   Write(Lne);
  End;
End;

Procedure PipeWrite(S : String);
Var X,Code : Byte;
    Error  : Integer;
Begin
For X := 1 to Length(S) do
 Begin
  If S[X] <> '|' then Write(S[X])
   Else Begin
         Val(Copy(S,X+1,2),Code,Error);
         If Error>0 then Write(S[X])
                     Else Begin
                            If Code<16 then Textcolor(Code)
                             Else Textbackground(Code-16);
                            If X + 2 > Length(S) then Inc(X,1) else Inc(X,2);
                           End;
        End;
 End;
End;

Procedure Uncrunch(var Addr1,Addr2; BlkLen:Integer);
Begin
  Inline (
    $1E/$C5/$B6/ADDR1/$C4/$BE/ADDR2/$8B/$8E/BLKLEN/$E3/$5B/$8B/$D7/
    $33/$C0/$FC/$AC/$3C/$20/$72/$05/$AB/$E2/$F8/$EB/$4C/$3C/$10/
    $73/$07/$80/$E4/$F0/$0A/$E0/$EB/$F1/$3C/$18/$74/$13/$73/$19/
    $2C/$10/$02/$C0/$02/$C0/$02/$C0/$02/$C0/$80/$E4/$8F/$0A/$E0/
    $EB/$DA/$81/$C2/$A0/$00/$8B/$FA/$EB/$D2/$3C/$1B/$72/$07/$75/$CC/
    $80/$F4/$80/$EB/$C7/$3C/$19/$8B/$D9/$AC/$8A/$C8/$B0/$20/$74/$02/
    $AC/$4B/$32/$ED/$41/$F3/$AB/$8B/$CB/$49/$E0/$AA/$1F);
End;

Procedure InputLn(var Lne : String;Chars:Byte;Caps:Boolean;Allcaps:Boolean);
Var
 StartedX,Counter,OldAttr : Byte;
 CH   : Char;
 P    : String;
 Done : boolean;
 X : Byte;
Begin
 OldAttr  := Textattr;
 StartedX := WhereX;
 P        := '';
 Counter  := 0;
 asm mov ah,1; mov ch,6; mov cl,7;int 10h; end; {Yes Cursor}
 Done := False;
 For X := 1 to Chars do Write(' ');GotoXy(StartedX,WhereY);
Repeat
 MemW[$0000:$041C] := MemW[$0000:$041A];
 GotoXy(StartedX,WhereY);Write(Padstring(P,Chars));GotoXy(StartedX+Counter,WhereY);
 CH := Readkey;If CH = #0 then CH := Readkey;
 Case CH of
  #8 : If Counter > 0 then
        Begin
         Delete(P,Length(P),1);
         Dec(Counter);
        End;
 #13 : Done := True;
 #27 : Begin
        P := 'Aborted';
        Done := True;
       End;
 #32..#126 : If Counter < Chars then
              Begin
               Inc(Counter);
               If Caps then If (P[Counter-1] = #0) or (P[Counter-1]=#32) then CH := Upcase(CH);
               If Allcaps then CH := Upcase(CH);
               P := P + (CH);
              End;
     End;
 Until Done = True;
 Lne := P;
 GotoXy(StartedX,WhereY);
 Textattr := 7;For X := 1 to Chars do Write(' ');
 If Lne <> 'Aborted' then Begin
                            GotoXy(StartedX,WhereY);
                            Write(Lne);
                          End;
 Textattr := OldAttr;
End;

Procedure WaitRetrace; assembler;
asm
 mov dx,3DAh
 @l1: in al,dx;and al,08h;jnz @l1
 @l2: in al,dx;and al,08h;jz  @l2
end;

Procedure FastMove(VAR source;VAR dest;numToMove : WORD);
Begin
 Inline($8C/$DA/$C5/$B6/>SOURCE/$C4/$BE/>DEST/$8B/$8E/>NUMTOMOVE);
 Inline($39/$FE/$72/$08/$FC/$D1/$E9/$73/$11/$A4/$EB/$0E/$FD/$01/$CE);
 Inline($4E/$01/$CF/$4F/$D1/$E9/$73/$01/$A4/$4E/$4F/$F2/$A5/$8E/$DA);
End;

procedure MovW(var source,dest; num: word); assembler;
asm
 push ds;les di,[dest];lds si,[source];mov cx,[num];rep movsw;pop ds
end;

Procedure qwrite(x, y : byte; s : string; f, b : byte;CharsperRow : Word);
Var
  Cnter,Attrib  : Word;
  VidPtr : ^Word;
Begin
  attrib := swap((b shl 4) + f);
  vidptr := ptr($B800, 2 * (CharsPerRow * pred(y) + pred(x)));
  If lastmode = 7 then dec(longint(vidptr), $08000000);
  For cnter := 1 to length(s) do
  Begin
   vidptr^ := attrib or byte (s[cnter]);
   inc(vidptr);
  End;
End;

Procedure Beep(Freq,Dely : Word);
Begin
 Sound(Freq);
 Delay(Dely);
 Nosound;
End;

Function Yesno(unlit,lit : Byte) : Boolean;
Var X,Y : Byte;
    CH : Char;
    Yes : Boolean;
Label GetaKey,Ending;
Begin
X := WhereX;
Y := WhereY;
asm mov ah,1; mov cx,2000h;Int 10h end; {No Cursor}
GotoXy(X,Y);
Textattr := Lit;Write(' Yes ');
Textattr := Unlit;Write(' No ');
GotoXy(X,Y);
Yes := True;
While not (CH in['Y','N',#13,#27]) do
Begin
 CH := Readkey;If CH = #0 then CH := Readkey;CH := Upcase(CH);
 If CH in[#75,'Y'] then Yes := True;
 If CH in[#77,'N',#27] then Yes := False;
 GotoXy(X,Y);
 If Yes then Begin
              Textattr := lit;Write(' Yes ');
              Textattr := unlit;Write(' No ');
             End
        else Begin
              Textattr := unlit;Write(' Yes ');
              Textattr := lit;Write(' No ');
             End;
End;
Textcolor(7);Textbackground(0);
Yesno := Yes;
End;

Procedure Row_Clear;
Const Lines : Array[1..25] of Byte =
(1,3,5,7,9,11,13,15,17,19,21,23,25,24,22,20,18,16,14,12,10,8,6,4,2);
Var X : Byte;
Begin
 For X := 1 to 25 do Begin
                      GotoXy(1,Lines[X]);
                      ClrEol;
                      Delay(50);
                     End;
End;

Procedure Clear_Column(Column : Byte);
Var X : Byte;
Begin
 For X := 1 to 25 do
   Begin
    GotoXy(Column,X);
    If Column < 80 then Write(#0);
   End;
End;

Procedure Column_Clear;
Const Column : Array[1..80] of Byte =
 (1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,
  53,55,57,59,61,63,65,67,69,71,73,75,77,79,80,78,76,74,72,70,68,66,64,62,
  60,58,56,54,52,50,48,46,44,42,40,38,36,34,32,30,28,26,24,22,20,18,16,14,
  12,10,8,6,4,2);
var P : Byte;
Begin
 For P := 1 to 160 do
 Begin
  Clear_Column(Column[P]);
  Delay(5);
 End;
End;

Procedure Close_Vertical;
Const Column : Array[1..80] of Byte =
 (1,80,2,79,3,78,4,77,5,76,6,75,7,74,8,73,9,72,10,71,11,70,12,69,13,
 68,14,67,15,66,16,65,17,64,18,63,19,62,20,61,21,60,22,59,23,58,24,57,
 25,56,26,55,27,54,28,53,29,52,30,51,31,50,32,49,33,48,34,47,35,46,36,
 45,37,44,38,43,39,42,40,41);
Var X : Byte;
Begin
 For X := 1 to 80 do Begin
                      Clear_Column(Column[X]);
                      Delay(5);
                     End;
End;

Procedure Close_Horizontal;
Const Row : Array[1..25] of Byte =
 (1,25,2,24,3,23,4,22,5,21,6,20,7,19,8,18,9,17,10,16,11,15,12,14,13);
Var P : Byte;
Begin
For P := 1 to 25 do Begin
                     GotoXy(1,Row[P]);
                     ClrEol;
                     Delay(10);
                    End;
End;

Function Center(Str : String) : Byte;
Begin
 Center := 40 - (length(Str) div 2);
End;

Function GetBitA(var a;Bit:Word):Boolean;assembler;
Const Bits:array[0..7] of Byte = ($1,$2,$4,$8,$10,$20,$40,$80);
asm
 Les di,a
 Mov si,bit
 Mov bx,si
 And si,07h
 Shr bx,03h
 Mov al,Byte(Bits[si])
 And al,es:[di+bx]
end;

Procedure InvertBitA(var a;Bit:Word);assembler;
Const Bits:array[0..7] of Byte = ($1,$2,$4,$8,$10,$20,$40,$80);
asm
  Les di,a
  Mov si,bit
  Mov bx,si
  And si,07h
  Shr bx,03h
  Mov al,Byte(Bits[si])
  Xor es:[di+bx],al
end;

Procedure PulltheBars;
var Y,X : Byte;
Begin
 For X := 1 to 80 do
  Begin
   WaitRetrace;
   For Y := 0 to 12 do
    Begin
     Mem[$b800:0000+(Y*2*160)+158] := 0;
     Mem[$b800:0000+(Y*2*160)+159] := 0;
     Mem[$b800:0000+((Y*2+1)*160)] := 0;
     Mem[$b800:0000+((Y*2+1)*160)+1] := 0;
     Fastmove(Mem[$b800:0000+(Y*2*160)+2],Mem[$b800:0000+(Y*2*160)],160-2);
     Fastmove(Mem[$b800:0000+((Y*2+1)*160)],Mem[$b800:0000+((Y*2+1)*160)+2],160-2);
    End;
 End;
End;

Procedure SlideLeft;
Var Y,X : Byte;
Begin
For X := 1 to 80 do
Begin
WaitRetrace;
For Y := 0 to 25 do
Begin
 Mem[$b800:0000+(Y*160)+158] := 0;
 Mem[$b800:0000+(Y*160)+159] := 0;
 Fastmove(Mem[$b800:0000+(Y*160)+2],Mem[$b800:0000+(Y*160)],160-2);
End;
End;
End;

Procedure SlideRight;
Var Y,X : Byte;
Begin
For X := 1 to 80 do
Begin
WaitRetrace;
For Y := 0 to 25 do
Begin
 Mem[$b800:0000+(Y*160)]   := 0;
 Mem[$b800:0000+(Y*160)+1] := 0;
 Fastmove(Mem[$b800:0000+(Y*160)],Mem[$b800:0000+(Y*160)+2],160-2);
End;
End;
End;

Procedure SlideUp;
Var X : Byte;
Begin
 Fillword(Mem[$b800:160*25-160],80,0);
 For X := 1 to 25 do
  Begin
   WaitRetrace;
   Fastmove(Mem[$b800:0160],Mem[$b800:0000],3840);
  End;
End;

Procedure SlideDown;
Var X : Byte;
Begin
 FillWord(Mem[$b800:0000],80,0);
 For X := 1 to 25 do
  Begin
   WaitRetrace;
   Fastmove(Mem[$b800:0000],Mem[$b800:0160],3840);
  End;
End;

Procedure V_ID; {return windows 3.x 386enh mode virtual machine number}
Var Regs : Registers;
Begin
 regs.ax := $1638;
 intr(multiplex,regs);
 Win_Machver := regs.bx;
End;

Procedure winstal;{check for windows 3.x install}
Var Regs : Registers;
Begin
 regs.ax:=$160A;
 intr(multiplex,regs);
 if regs.ax = $0000 then
  begin
   Win_Installed  := true;
   Win_HiVer := regs.bh;
   Win_LoVer := regs.bl;
   if regs.cx = $0003 then
    begin
     Win_386enh := true;
     v_id;
    end else
    begin
     Win_386enh := false;
     Win_MachVer := 0;
    end;
   end else
   begin
    Win_Installed  := false;
    Win_HiVer := 0;
    Win_LoVer := 0;
    Win_MachVer := 0;
   end;
end;

Procedure dvinstall;{check for dv}
Var Regs : Registers;
begin
 if win_installed then
  begin
   dv_installed := false;
   exit;
  end;
 regs.ax := $2b00;
 regs.cx := $4445;
 regs.dx := $5351;
 regs.ax := $0001;
 intr(std_dos,regs);
 if regs.al<>$ff then
  begin
   dv_hiver := regs.bh;
   dv_Lover := regs.bl;
          dv_installed  := true;
        end
      else
        begin
          Dv_Hiver := 0;
          Dv_LoVer := 0;
          dv_installed := false;
       end;
end; { dv install check}

procedure I_4dos;
Var Regs : Registers;
    begin
      regs.ax := $d44d;
      regs.bx := $0000;
      intr(std_dos,regs);
      if regs.ax = $44dd then
        begin
          _4dos_Hiver := regs.bh;
          _4dos_LoVer := regs.bl;
          _4dos_installed  := true;
          shell_num := regs.dl;
        end
      else
        begin { no 4dos }
          _4dos_installed  := false;
          _4dos_hiver := 0;
          _4dos_Lover := 0;
          shell_num := -1;
        end;
    end;

procedure dos_ver; {get dos version}
Var Regs : Registers;
begin
      regs.ax:=$3001;
      intr(std_dos,regs);
      _4Dos_Hiver := regs.al;
      _4Dos_lover :=regs.ah;
end;

function base_free : longint;
begin;
  base_free := MemAvail;
end;

Function IsVesa:Boolean;
Var Regs : Registers;
Begin
  regs.ax:=$4F03;
  Intr($10,regs);
  IsVesa:=(regs.al=$4F);
End;

begin
 Winstal;   { Check for Windows  }
 I_4dos;    { Check for 4Dos     }
 dos_ver;   { Get MS-DOS Version }
End.