unit fse;
interface
Uses Crt,dos,strings,tpansi,subs1,io;
procedure startmsg;
implementation

Const
 Up     = 1;Down   = 2;Left   = 3;Right  = 04;Enter  = 05;Home   = 6;
 EndKey = 7;PageUp = 8;PageDn = 9;Escape = 10;BackSp = 11;

Type BufType = record
         from:string[20];
         too:string[20];
         date:string[8];
         description:string[50];
         lines:Array[1..20,0..159] of Byte;
         end;

Var Buffer  : BufType;
         FROMX,FROMY:BYTE;
         TOOX,TOOY:BYTE;
         DATEX,DATEY:BYTE;
         DESCX,DESCY:BYTE;
         from:string[20];
         too:string[20];
         date:string[8];
         description:string[80];

    Width   : Byte;  { Width of Window in Spaces     }
    Top     : Byte;  { ScrollDown Marker             }
    XPos    : Byte;  { X Position in Window          }
    YPos    : Byte;  { Y Position in Window          }
    Attrib  : Byte;  { Current Color                 }
    CH      : Char;  { Dummy Character               }
    Key     : Byte;  { Dummy Byte                    }
    X,Y,Z   : Byte;  { Dummy Counters                }
    Done    : Boolean; { End Fullscreen Editor?      }
{   Console : Text;}
    WorkColor : Byte;

    StartX,StartY       : Byte;
    EndX,EndY           : Byte;
    QuickPalX,QuickPalY : Byte;
    ColorBarX,ColorBarY : Byte;
    InputX,InputY       : Byte;
    var msgf:file of buftype;

Procedure ChangeColor(Attribute : Byte);
Const AnsiFG : Array[0..7] of Byte = (30,34,32,36,31,35,33,37);
      AnsiBG : Array[0..7] of Byte = (40,44,42,46,41,45,43,47);
Var FG,BG : Byte;
    High  : Byte;
Begin
 FG := Attribute and $0f;
 BG := (Attribute and $f0) shr 4;
 If FG > 7 then High := 1 else High := 0;
 If High = 1 then Dec(FG,8);
 print(#27+'['+Strr(High)+';'+Strr(AnsiFG[FG])+';'+Strr(AnsiBG[BG])+'m');
End;

procedure savemsg;
begin
seek(msgf,0);
write(msgf,buffer);
end;

Procedure ShowAnsi2(s:string);
Var TFile : Text;
Begin
Assign(TFile,s);
{$I-} Reset(TFile); {$I+}
If IOResult <> 0 then Exit;
Repeat
 Read(TFile,CH);
  Begin
   Read(TFile,CH);
   Write(CH);
     End;
Until Eof(TFile);
Width := EndX - StartX;
Close(TFile);
End;



procedure FillWord(var x; count:integer; w:word);
Begin
 Inline($c4/$be/x/$8b/$86/w/$8b/$8e/count/$fc/$f2/$ab);
End;

Procedure GotoXy(X,Y : Byte);
Begin
print(#27+'['+Strr(Y)+';'+Strr(X)+'H');
End;

Procedure Redraw;
Begin
 For Y := 1 to (EndY-StartY+1) do
 Begin
  GotoXy(StartX,StartY+Y-1);
  For X := 0 to Width do
   Begin
{   TextAttr := Buffer.lines[Y+Top-1,X*2+1];}
    changecolor(Buffer.lines[Y+Top-1,X*2+1]);
   print  (Chr(Buffer.lines[Y+Top-1,X*2]));
   End;
 End;
 GotoXy(StartX+Xpos-1,StartY+Ypos-1);
End;

Procedure Ansi_Up;
Begin
 print(#27+'[A');
End;

Procedure Ansi_Down;
Begin
 print(#27+'[B');
End;

Procedure Ansi_Left(N : Byte);
Begin
 print(#27+'['+Strr(N)+'D');
End;

Procedure Ansi_Right(N : Byte);
Begin
 print(#27+'['+Strr(N)+'C');
End;

Procedure ScrollDown;
Begin
 If Top+(EndY-StartY) < 20 then
  Begin
   Inc(Top);
   Redraw;
  End;
End;

Procedure MoveDown;
Begin
 If YPos < (EndY - StartY+1) then
  Begin
   Inc(Ypos);
   Ansi_Down;
  End else ScrollDown;
End;

Procedure ScrollUp;
Begin
 If Top > 1 then
  Begin
   Dec(Top,1);
   Redraw;
  End;
End;

Procedure MoveUp;
Begin
 If YPos > 1 then
  Begin
   Dec(YPos,1);
   Ansi_Up;
  End else ScrollUp;
End;

Procedure ShowAnsi(s:string);
Var TFile : Text;
Begin
Assign(TFile,s);
{$I-} Reset(TFile); {$I+}
If IOResult <> 0 then Exit;
Repeat
 Read(TFile,CH);
 If CH <> '' then write(ansi,CH) else
  Begin
   Read(TFile,CH);
   Case CH of
    '1' : Begin
           StartX := WhereX;
           StartY := WhereY;
           Ansi_Right(2);
          End;
    '2' : Begin
           EndX := WhereX;
           EndY := WhereY;
           Ansi_Right(2);
          End;
    '3' : Begin
           QuickPalX := WhereX;
           QuickPalY := WhereY;
           Ansi_Right(2);
          End;
     '4' : BEGIN
            FROMX:=WHEREX;
            FROMY:=WHEREY;
            ANSI_RIGHT(2);
           END;
     '5' : BEGIN
             TOOX:=WHEREX;
             TOOY:=WHEREY;
             ANSI_RIGHT(2);
           END;
     '6' : BEGIN
            DATEX:=WHEREX;
            DATEY:=WHEREY;
            ANSI_RIGHT(2);
           END;
     '7' : BEGIN
             DESCX:=WHEREX;
             DESCY:=WHEREY;
             ANSI_RIGHT(2);
           END;

     else print(CH);
   End;
  End;
Until Eof(TFile);
Width := EndX - StartX;
Close(TFile);
End;

Function GrabKey : Byte;
Var C1,C2 : Char;
Begin
 C1 := sReadkey;If C1 = #0 then C2 := sReadkey;
   Case C1 of
    #13 : GrabKey := Enter;
    #27 : GrabKey := Escape;
    #8  : GrabKey := BackSp;
     else GrabKey := Ord(C1);
   Case C2 of
    #72 : GrabKey := Up;
    #80 : GrabKey := Down;
    #75 : GrabKey := Left;
    #77 : GrabKey := Right;
    #71 : GrabKey := Home;
    #79 : GrabKey := EndKey;
    #73 : GrabKey := PageUp;
    #81 : GrabKey := PageDn;
     else GrabKey := Ord(C1);
   End;
   End;
End;

Procedure QuickPallette;
Var TFile : Text;
    Y : Byte;
    Line : String;
    Donewithquickpallette : boolean;
 Foreground,background : Byte;
Begin
 Assign(TFile,'FSEQP.ANS');
 {$I-} Reset(TFile); {$I+}
 If IOResult <> 0 then Exit;
 Y := 0;
 Repeat
  Inc(Y);
  Readln(TFile,Line);
  GotoXy(QuickPalX,QuickPalY+Y-1);
  For X := 1 to Length(Line) do
   Begin
     Case Line[X] of
      '|' : Begin
             If (Line[X+1] = 'C') and (Line[X+2] = 'B') then
              Begin
               ColorBarX := WhereX;
               ColorBarY := WhereY;
               Ansi_Right(3);
               Inc(X,2);
              End;
            End;
      '&' : Begin
             InputX := WhereX;
             InputY := WhereY;
             Ansi_Right(1);
            End;
         Else print(Line[X]);
     End;
{    If Line[X] = '|' then
     Begin
      If (Line[X+1] = 'C') and (Line[X+2] = 'B') then
       Begin
        ColorBarX := WhereX;
        ColorBarY := WhereY;
       End;
     End;
    If Line[X] = '&' then
     Begin
      InputX := WhereX;
      InputY := WhereY;
     End;
    Write(ansi,Line[X]);}
   End;
 Until Eof(TFile);
 Close(TFile);
 GotoXy(ColorBarX,ColorBarY);
 print('|07 |01 |02 |03 |04 |05 |06 |07 |08 |09 |10 |11 |12 |13 |14 |15');
 DoneWithQuickPallette := False;
 Foreground := (Attrib and $0f);
 Background := (Attrib and $f0) shr 4;
 GotoXy(InputX,InputY);print(' ');Ansi_Left(1);
 Repeat
  GotoXy(ColorBarX+(Foreground*2),ColorBarY-1); print('');
  GotoXy(ColorBarX+(Background*2),ColorBarY+1); print('');
  GotoXy(InputX,InputY);
  Key := Grabkey;
  Case Key of
   Ord('A'),Ord('a'),Ord('S'),Ord('s'),Ord('Q'),Ord('q') : print(Chr(Key));
  End;
  Case Key of
   Ord('a'),
   Ord('A') : Begin
               Done := True;
               doneWithQuickpallette := True;
              End;
   ORD('S'):begin
            savemsg;
            end;

   Enter,Escape : DoneWithQuickpallette := True;
   Left   : Begin
             GotoXy(ColorBarX+(Foreground*2),ColorBarY-1);
             print(' ');
             If Foreground > 0 then Dec(Foreground) else Foreground := 15;
            End;
   Right  : Begin
             GotoXy(ColorBarX+(Foreground*2),ColorBarY-1);
             print(' ');
             If Foreground < 15 then Inc(Foreground) else Foreground := 0;
            End;
    Up    : Begin
             GotoXy(ColorBarX+(Background*2),ColorBarY+1);
             print(' ');
             If Background < 7 then Inc(Background) else Background := 0;
            End;
    Down  : Begin
             GotoXy(ColorBarX+(Background*2),ColorBarY+1);
             print(' ');
             If Background > 0 then Dec(Background) else Background := 7;
            End;
  End;
 until DoneWithQuickPallette;
 Key := 0;
 Redraw;
 Attrib := Background shl 4 + foreground;
End;

procedure msgstat;
begin
gotoxy(fromx,fromy);
print(buffer.from);
gotoxy(toox,tooy);
print(buffer.too);
gotoxy(datex,datey);
print(buffer.date);
gotoxy(descx,descy);
print(buffer.description);
end;

procedure msgpost(readit:boolean);
 var count:integer;
 begin
 ShowAnsi('fse.ans');
 Assign(ansi,'');
 REwrite(ansi);
 Top := 1;CH := #0;X := 0;Y := 0;Z := 0;XPos := 1;YPos := 1;Done := False;
 Textcolor(7);Textbackground(0);
 Attrib := 7;
 buffer.date:='';
 if readit=false then begin
{ Getmem(Buffer,SizeOf(Buffer));}
 Fillword(Buffer,SizeOf(buffer),$0702);
 buffer.date:=date;
 buffer.from:=from;
 buffer.too:=too;
 buffer.description:=description;
 end else begin;
 redraw;
 end;
 msgstat;
 GotoXy(StartX,StartY);
 WorkColor := 7;
 ChangeColor(WorkColor);
 Repeat
  Key := 0;
  Key := Grabkey;
  if readit=false then
  If (XPos = 1) and (Key = Ord('/')) then QuickPallette;
  Case Key of
   Escape : if readit=false then QuickPallette;
   BackSp : if readit=false then If XPos > 1 then
            Begin
             Dec(Xpos);
             Buffer.lines[YPos+Top-1,XPos*2-2] := 32;
             Buffer.lines[YPos+Top-1,XPos*2-1] := 7;
             Ansi_Left(1);
             print(' ');
             Ansi_Left(1);
            End;
   Left   : If XPos > 1 then
             Begin
              Dec(Xpos);
              Ansi_left(1);
             End;
   PageUp : Inc(WorkColor);
   PageDn : Dec(WorkColor);
   Right  : If XPos < (EndX-StartX) then
            Begin
             Inc(XPos);
             Ansi_Right(1);
            End;
   Home   : Begin
             XPos := 1;
             GotoXy(StartX+Xpos-1,StartY+Ypos-1);
            End;
   EndKey : Begin
             XPos := Width;
             GotoXy(StartX+Xpos-1,StartY+Ypos-1);
            End;
   Down   : MoveDown;
   Up     : MoveUp;
   Enter  : if readit=false then Begin
             XPos := 1;
             GotoXy(StartX+Xpos-1,StartY+Ypos-1);
             MoveDown;
            End;
  30..254 : if readit=false then Begin
             Buffer.lines[YPos+Top-1,XPos*2-2] := Key;
             Buffer.lines[YPos+Top-1,XPos*2-1] := Attrib;
             ChangeColor(Attrib);
             print(Chr(key));
             If XPos < (EndX-StartX) then Inc(XPos) else
              Begin
               XPos := 1;
               GotoXy(StartX+Xpos-1,StartY+Ypos-1);
               MoveDown;
              End;
            End;
  End;
 Until Done;
{ Freemem(Buffer,Sizeof(Buffer));}
End;

procedure startmsg;
begin
from:='Judge Dredd';
clrscr;
println('From: '+from);
print  ('To  : ');
sreadln(too);
print  ('Description: ');
sreadln(description);
assign(msgf,'msg.dat');
rewrite(msgf);
msgpost(false);
close(msgf);
end;

procedure readmsg(s:string);
begin
{ Getmem(Buffer,SizeOf(Buffer));}
 Fillword(Buffer,SizeOf(buffer),$0702);
assign(msgf,'msg.dat');
reset(msgf);
read(msgf,buffer);
msgpost(true);
end;

begin
end.