unit openf;

interface
USES DOS,CRT;
const
  Allfiles : boolean = false;               { Whether to print files belonging
                                              to other processes }

procedure print_open_files(var where:text);

implementation


type
  dos2openfilerec = record
    numhandles : byte;
    junk1 : array[1..3] of byte;
    filename : array[4..$e] of char;
    junk2 : array[$f..$27] of byte;
  end;

  dos30openfilerec = record                   {!!2}
    numhandles : word;                        {!!2}
    junk1 : array[2..$20] of byte;            {!!2}
    filename : array[$21..$2b] of char;       {!!2}
    junk2 : array[$2c..$31] of byte;          {!!2}
    pspseg : word;                            {!!2}
    junk3 : array[$34..$37] of byte;          {!!2}
  end;

  dos3openfilerec = record
    numhandles : word;
    junk1 : array[2..$1f] of byte;
    filename : array[$20..$2a] of char;
    junk2 : array[$2b..$30] of byte;          {!!2}
    pspseg : word;                            {!!2}
    junk3 : array[$33..$34] of byte;          {!!2}
  end;

  dos4openfilerec = record
    numhandles : word;
    junk1 : array[2..$1f] of byte;
    filename : array[$20..$2a] of char;
    junk2 : array[$2b..$30] of byte;         {!!2}
    pspseg : word;                           {!!2}
    junk3 : array[$33..$3a] of byte;         {!!2}
  end;

  filelistptr = ^filelistrec;
  filelistrec = record
    next : filelistptr;
    numfiles : word;
    case byte of
    2 : (dos2files : array[1..1] of dos2openfilerec);
   30 : (dos30files: array[1..1] of dos30openfilerec);  {!!2}
    3 : (dos3files : array[1..1] of dos3openfilerec);
    4 : (dos4files : array[1..1] of dos4openfilerec);
  end;

procedure print_open_files(var where:text);
var
  r : registers;
  list : filelistptr;
  list1 : filelistptr;
  i : word;
begin
  with r do
  begin
    ah := $52;
    msdos(r);

    list := pointer(MemL[es:bx+4]);

    while ofs(list^) <> $FFFF do
    begin
      with list^ do
        for i:=1 to numfiles do
          case lo(dosversion) of
          2 : with dos2files[i] do
               if numhandles > 0 then
                 writeln(where,filename);
          3 : if hi(dosversion) = 0 then                            {!!2}
              begin                                                 {!!2}
                with dos30files[i] do                               {!!2}
                 if (numhandles > 0) and (allfiles or               {!!2}
                                          (pspseg = prefixseg)) then{!!2}
                   writeln(where,filename)                          {!!2}
              end                                                   {!!2}
              else                                                  {!!2}
                with dos3files[i] do
                 if (numhandles > 0) and (allfiles or
                                          (pspseg = prefixseg)) then{!!2}
                   writeln(where,filename);
        4,5,6:with dos4files[i] do
               if (numhandles > 0) and (allfiles or                 {!!2}
                                        (pspseg = prefixseg)) then  {!!2}
                 writeln(where,filename);
          end;
      list := list^.next;
    end;
  end;
DELAY(500);
end;

var
  exit_save : pointer;

procedure my_exit_proc; far;
var
  junk : word;
begin
  ExitProc := Exit_save;
  junk := ioresult;
  assign(output,'');
  rewrite(output);
  writeln('Files open as program terminates:');
  print_open_files(output);
end;

begin
  if not (lo(dosversion) in [2..7]) then
    writeln('OPENFILES only works with DOS 2 to 5')
  else
  begin
    exit_save := ExitProc;
    ExitProc := @my_exit_proc;
  end;
end.


