{$R-,S-,I-,D-,F+,V-,B-,N-,L+,O+ }

(* Vision .99 Gamma Configurable Chat Routine
   Written by Amorphis
*)

unit bchat;        (* Chat Mode and F2 Keys *)

interface
USES DOS,CRT,SUBS1,GENTYPES,STRINGS,GENERAL,PROTCOMM,modem,PULLMENU;
procedure chat;
PROCEDURE PAGE;
implementation
USES IO;

type CHATREC=record
     CX1  :array[1..30] of 1..80;
     CX2  :array[1..30] of 1..80;
     CY   :array[1..30] of 1..80;
     MAXY:1..25;
     end;
var
   lclchat,usrchat:chatrec;
   TX,TY:1..80;

PROCEDURE PAGE;
VAR S:STRING;
    X:1..10;
BEGIN
S:='';
SS(21);
SREADLN(S);
IF S='' THEN BEGIN; EXIT; END;
FOR X:=1 TO 10 DO BEGIN; WRITE(#7); DELAY(500); END;
END;

procedure chat;
var k:char;
    StartedTime:Word;
    cnt:integer;
    ingetstr:boolean;
    quit,carrierloss,fromkbd:boolean;
    baudstr,commstr:string[25];
    xsys     :byte;
    ysys     :byte;
    xusr     :byte;
    yusr     :byte;
    ec       :byte;
    linebufs :string[80];
    linebufu :string[80];
    localcurline:integer;
    modemcurline:integer;

var cr:chatrec;

procedure LOADCHATDAT;
var T:TEXT;
    D:string[13];
    x,LMAX,UMAX:BYTE;

begin
     ASSIGN (T, CONFIGSET.DATADIR + 'VISDAT.1');
     LMax := 0;UMax := 0;
     RESET (T);
     repeat
          READLN (T, D);
          case D[1] of
               'L','l': begin
                    INC (LMAX);
                    LCLCHAT.MAXY := LMAX;
                    LCLCHAT.CY[LMAX] := valu (copy (D, 3, 2));
                    LCLCHAT.CX1[LMAX] := valu (copy (D, 6, 2));
                    LCLCHAT.CX2[LMAX] := valu (copy (D, 9, 2));
               end;
               'M','m': begin
                    INC (UMAX);
                    USRCHAT.MAXY := UMAX;
                    USRCHAT.CY [UMAX] := valu (copy (D, 3, 2));
                    USRCHAT.CX1[UMAX] := valu (copy (D, 6, 2));
                    USRCHAT.CX2[UMAX] := valu (copy (D, 9, 2));
               end;
          end;
     until EOF (T) ;
     system.close (T);
end;

procedure init;
VAR CHATMCI:MCIS;
begin
     loadchatdat;                      {loads chat xy coordinates}
     { PRINTMCI(CONFIGSET.TEXTFILEDI+'VISCHAT.ANS');}
     PRINTfile ('VCHAT' + STRR (1) + '.' + STRR (1),CHATMCI,FALSE);

     localcurline := 1;
     xsys := lclchat.cx1[1];
     ysys := lclchat.cy[1];

     modemcurline := 1;
     xusr := usrchat.cx1[1];
     yusr := usrchat.cy[1];

     ec := 1;
     linebufs := '';
     linebufu := '';
end;

procedure sendxy (x, y: byte);
begin
     swrite (#27 + '['+strr(y)+ ';'+strr(x)+ 'H');
end;

procedure clearbox (I: BYTE);

var Y,x:BYTE; s:string[80];

begin
     case i of
          0: begin
               for y := 1 to lclchat.maxy do begin
                    s := '';
                    for x := 1 to (lclchat.cx2[y] - lclchat.cx1[y]) + 1 do s := s + ' ';
                    GOXY (LCLCHAT.CX1[y], LCLCHAT.CY[y]);
                    swrite (s);
               end;
          end;
          1: begin
               for y := 1 to usrchat.maxy do begin
                    s := '';
                    for x := 1 to (usrchat.cx2[y] - usrchat.cx1[y]) + 1 do s := s + ' ';
                    GOXY (usrCHAT.CX1[y], usrCHAT.CY[y]);
                    swrite (s);
               end;
          end;
     end;
end;

procedure setc;
begin
     if fromkbd then ec := {urec.statcolor}12
     else ec := {urec.inputcolor}9;
end;

procedure wordwrap (s: string; var wrap: string);
var
  index:integer;
begin
     index := length (s);
     while (s[index] <> ' ') and (index > 0) do dec (index);
     if index = 0 then index := length (s);
     wrap := s;
     delete (wrap, 1, index);
end;

procedure locate;
 var wrap,linelocaldelete,linemodemdelete:string[80];
     x:BYTE;
 begin
      linelocaldelete := '';
      linemodemdelete := '';
      if fromkbd then begin
           if (xsys = lclchat.cx2[localcurline] + 1) and (ysys < lclchat.cy[lclchat.maxy]) then begin
                wordwrap (linebufs, wrap);
                dec (xsys, length (wrap));
                for x := 1 to length (wrap) do linelocaldelete := linelocaldelete + ' ';
                sendxy (xsys, ysys);
                swrite (linelocaldelete);
                linebufs := '';
                inc (localcurline);
                ysys := lclchat.cy[localcurline];
                xsys := lclchat.cx1[localcurline];
                sendxy (xsys, ysys);
                swrite (wrap);
                xsys := xsys + (length (wrap));
           end;
           if ((ysys = lclchat.cy[lclchat.maxy]) and (xsys = lclchat.cx2[lclchat.maxy] + 1))
                     or (ysys > (lclchat.cy[lclchat.maxy])) then begin
                wordwrap (linebufs, wrap);
                CLEARBOX (0);
                localcurline := 1;
                ysys := lclchat.cy[localcurline];
                xsys := lclchat.cx1[localcurline];
                sendxy (xsys, ysys);
                swrite (wrap);
                xsys := xsys + length (wrap);
           end;
           sendxy (xsys, ysys);
           inc (xsys);
      end;
      if not fromkbd then begin
           if (xusr = usrchat.cx2[modemcurline] + 1) and (yusr < usrchat.cy[usrchat.maxy]) then begin
                wordwrap (linebufu, wrap);
                dec (xusr, length (wrap));
                for x := 1 to length (wrap) do linemodemdelete := linemodemdelete + ' ';
                sendxy (xusr, yusr);
                swrite (linemodemdelete);
                linebufu := '';
                inc (modemcurline);
                yusr := usrchat.cy[modemcurline];
                xusr := usrchat.cx1[modemcurline];
                sendxy (xusr, yusr);
                swrite (wrap);
                xusr := xusr + (length (wrap));
           end;
           if ((yusr = usrchat.cy[usrchat.maxy]) and (xusr = usrchat.cx2[usrchat.maxy] + 1))
                     or (yusr > usrchat.cy[usrchat.maxy]) then begin
                wordwrap (linebufu, wrap);
                CLEARBOX (1);
                modemcurline := 1;
                yusr := usrchat.cy[modemcurline];
                xusr := usrchat.cx1[modemcurline];
                sendxy (xusr, yusr);
                swrite (wrap);
                xusr := xusr + length (wrap);
           end;
           sendxy (xusr, yusr);
           inc (xusr);
      end;
 end;
{TYPE CHAR}
  procedure typedchar (k: char);
  begin
       locate;
       if fromkbd then linebufs := linebufs + k
       else
            if not fromkbd then linebufu := linebufu + k;
       swrite (k)
  end;

begin
     TX:=WHEREX;
     TY:=WHEREY;
     SAVESCREEN;
{    IF exist(configset.datadi+'VISDAT.'+STRR(THECHATNUMBER)) then
     if exist(CONFIGSET.TEXTFILEDI+'VISCHAT.'+STRR(THECHATNUMBER)) THEN
     init ELSE EXIT;}
{     THECHATNUMBER:=1;}
     if not exist (configset.datadir + 'VISDAT.' + STRR (1)) then EXIT;
     INIT;
     carrierloss := false;
     Chatmode := false;
     quit := false;
     textcolor (15);
     CHATMODE:=TRUE;
     repeat
          repeat
          until keyhit or (NOT LOCAL and (numchars > 0)) ;
          fromkbd := keypressed;
          ingetstr := true;
          if fromkbd then k := readkey
          else k := getchar2;
          if k = #127 then k := #8;
          case ord (k) of
               8: begin
                    if (xsys > lclchat.cx1[localcurline]) and fromkbd then begin
                         if xsys > lclchat.cx1[localcurline] then dec (xsys);
                         sendxy (xsys, ysys);
                         swrite (' ');
                         sendxy (xsys, ysys);
                         if length (linebufs) > 0 then linebufs := copy (linebufs, 1, length (linebufs) - 1);
                    end;
                    if (xusr > usrchat.cx1[modemcurline]) and not fromkbd then begin
                         if xusr > usrchat.cx1[modemcurline] then dec (xusr);
                         sendxy (xusr, yusr);
                         swrite (' ');
                         sendxy (xusr, yusr);
                         if length (linebufu) > 0 then linebufu := copy (linebufu, 1, length (linebufu) - 1);
                    end;
               end;
               27:IF FROMKBD THEN QUIT := TRUE;
               0:;
               13: begin
                    if fromkbd then begin
                         inc (localcurline);
                         xsys := lclchat.cx1[localcurline];
                         ysys := lclchat.cy[localcurline];
                         if localcurline > LCLCHAT.MAXY then begin
                              CLEARBOX (0);
                              localcurline := 1;
                              ysys := lclchat.cy[localcurline];
                              xsys := lclchat.cx1[localcurline];
                              sendxy (xsys, ysys);
                         end;
                         sendxy (xsys, ysys);
                         linebufs := '';
                    end;

                    if not fromkbd then begin
                         inc (modemcurline);
                         xusr := USRCHAT.cx1[modemcurline];
                         yusr := USRCHAT.cy[modemcurline];
                         if modemcurline > USRCHAT.MAXY then begin
                              CLEARBOX (1);
                              modemcurline := 1;
                              yusr := usrchat.cy[modemcurline];
                              xusr := usrchat.cx1[modemcurline];
                              sendxy (xusr, yusr);
                         end;
                         sendxy (xusr, yusr);
                         linebufu := '';
                    end;
               end;
               32..255:typedchar (k);
               1..31:if fromkbd and carrier then swrite (k);
          end
     until quit ;
SHOWSCREEN;
GOXY(TX,TY);
CHATMODE:=TRUE;
end;


begin
end.
