Unit arcview;
interface
USES DOS,CRT,FILEPULL,gentypes,subs1,general,strings,io;

procedure LoadZip(filename: string);
procedure DisplayZip(BACK:BOOLEAN);
procedure DisposeZip;
Procedure DO_LZH (FN : String);
PROCEDURE DO_ZIP (FN :STRING);
PROCEDURE VIEWFILE(S:STRING);
implementation

PROCEDURE VIEWFILE(S:STRING);
BEGIN
WRITELN(S);
READKEY;
IF POS('.ZIP',S)>0 THEN DO_ZIP(S) ELSE
IF POS('.LZH',S)>0 THEN DO_LZH(S);
END;


type
 barray= array[1..8192] of byte;
 ZipPtr=^ZipRec;
 ZipRec= Record
          version_made: word;
          version_extr: word;
          flags: word;
          comp_method: word;
          last_mod_time: word;
          last_mod_date: word;
          crc_32: longint;
          compressed_size: longint;
          uncompressed_size: longint;
          fname_length: word;
          extra_length: word;
          comment_length: word;
          disk_num_start: word;
          internal_attr: word;
          external_attr: longint;
          rel_ofs: longint;
          name: string[12];
          Next: ZipPtr;
         end;
 bptr = ^barray;
const
 ZipMethod: array[0..9] of string[15] =
           ('stored   ',          'shrunk   ',       'reduced-1',
            'reduced-2',          'reduced-3',       'reduced-4',
            'imploded ',          'DeflatX  ',       'DeflatN  ',
            'unknown  ');

var
 totallength,totalsize,numfiles: longint;
 firstzip: zipptr;
 lineout: string;
 outPtr: pointer;
 filen:string;
var
 f: file of barray;
 buffer: barray;
 addr: longint;
 bufptr: word;


Const
  BSize = 4096;                                  { I/O Buffer Size }

Type LZHHead = Record
                 HSize      : Byte;
                 Fill1      : Byte;
                 Method     : Array[1..5] of Char;
                 CompSize   : LongInt;
                 UCompSize  : LongInt;
                 Dos_DT     : LongInt;
                 Fill2      : Word;
                 FileNameLen: Byte;
                 FileName   : Array[1..12] of Char;
               end;

Var LZH1       : LZHHead;
    DT         : DateTime;
    FSize,L,C  : LongInt;
    AF          : File;
    BUFF       : Array[1..BSize] of Byte;
    DATE       : String[8];                { formatted date as YY/MM/DD }
    TIME       : String[6];                {     "     time as HH:MM }
    RES        : Word;
    DIR        : DirStr;
    FNAME      : NameStr;
    EXT        : ExtStr;
    LZHString,
    SName      : String;
    QUIT       : Boolean;
    SW         : Pointer;

PROCEDURE DO_ZIP(FN:STRING);
BEGIN
{FILLCHAR(ARCINFO,SIZEOF(ARCINFO),#0);}
LOADZIP(FN);
DISPLAYZIP(FALSE);
DISPOSEZIP;
END;

Function upper(st:String):String;
Var i : Integer;
begin
  For i := 1 to length(st) do st[i] :=upcase(st[i]);
  upper := st;
end;

Function ord_to_str(i:LongInt;j:Byte):String;
Var c:String;
begin
  str(i,c);
  While length(c)<j do c:=' '+c;
  ord_to_str:=c;
end;

Procedure FDT(LI:LongInt); { Format Date/Time (time With AM PM) fields }
Var t_ext : String;
begin
  UnPackTime (LI,DT);
  DATE := ord_to_str(DT.Month,2)+'/'+ord_to_str(DT.Day,2)+'/'
         +ord_to_str(DT.Year mod 100,2);
  if DATE[1] = ' ' then DATE[1] := '0';
  if DATE[4] = ' ' then DATE[4] := '0';
  if DATE[7] = ' ' then DATE[7] := '0';
  if DT.Hour in [0..11] then t_ext:='a' else t_ext:='p';
  if DT.Hour in [13..24] then Dec(DT.Hour,12);
  TIME := ord_to_str(DT.Hour,2)+':'+ord_to_str(DT.Min,2);
  if TIME[1] = ' ' then TIME[1] := '0';
  if TIME[4] = ' ' then TIME[4] := '0';
  TIME:=TIME+t_ext;
end;  { FDT }

Procedure GET_LZH_ENTRY;
begin
  FillChar(LZH1,SizeOf(LZHHead),#0);
  FillChar (DT,SizeOf(DT),#0);
  L := SizeOf(LZHHead);
  Seek (AF,C); BlockRead (AF,BUFF,L,RES);
  Move (BUFF[1],LZH1,L);
  With LZH1 do
    if HSize > 0 then
      begin
        Move (FileNameLen,SNAME,FileNameLen+1);
        UnPackTime (Dos_DT,DT);
        FSize := CompSize
      end
    else QUIT := True
end;  { GET_LZH_ENTRY }

Procedure DO_LZH (FN : String);
Var fnstr, LZHMeth : String;
    fls,totu,totc : LongInt;
begin
  totu:=0; totc:=0; fls:=0;
  Assign (AF,FN);
  {$I-} Reset (AF,1); {$I+}
  if Ioresult<>0 then
    begin
      Writeln(upper(FN)+' not found');
      Exit;
    end;
  FSize := FileSize(AF);
  C := 0;
  QUIT := False;
  Repeat
    GET_LZH_ENTRY;
    if not QUIT then
      begin
        FSplit (SNAME,DIR,FNAME,EXT);
        fnstr:=FNAME+EXT;
        While length(fnstr)<12 do insert(' ',fnstr,length(fnstr)+1);
        FDT(LZH1.Dos_DT);
        inc(totu,lzh1.ucompsize);
        inc(totc,lzh1.compsize);
        inc(fls,1);
        Case LZH1.Method[4] of       {normally only 0,1 or 5}
          '0' : LZHMeth:='Stored  ';
          '1' : LZHMeth:='Frozen 1';
          '2' : LZHMeth:='Frozen 2';
          '3' : LZHMeth:='Frozen 3';
          '4' : LZHMeth:='Frozen 4';
          '5' : LZHMeth:='Frozen 5';
        else LZHMeth:=' Unknown';
        end;
        LZHString:=Fnstr+'  '+ord_to_str(LZH1.UCompsize,8)+'  '+
                   ord_to_str(LZH1.Compsize,8)+'  '+lzhmeth+'  '
                   +DATE+'  '+TIME;
        Writeln(LZHString);
      end;
    Inc (C,FSize+LZH1.HSize+2)
  Until QUIT;
  Close (AF);
{  Writeln(ord_to_str(fls,5)+' Files   '+ord_to_str(totu,8)+'  '
  +ord_to_str(totc,8));}
end;  { DO_LZH }

{$F+}
Procedure CallProc;
inline($FF/$1E/OutPtr);
{$F-}

Function NextByte: byte;
var i: integer;
begin;
 inc(addr);
 inc(bufptr);
 if bufptr=8193 then begin;
  {$I-}
  read(f,buffer);
  {$I+}
  i:=ioresult;
  bufptr:=1;
 end;
 nextbyte:=buffer[bufptr];
end;

procedure LoadZip(filename: string);
var
 b: byte;
 f2: file of byte;
 fs: longint;
 LastZip,Zip: ZipPtr;
 Bytes: Bptr absolute zip;
 a: integer;
 sr: searchrec;
begin;
 filen:=filename;
 firstzip:=nil;
 findfirst(filename,anyfile,sr);
 fs:=sr.size;
 assign(f,filename);
 reset(f);
 addr:=0;
 if fs>65535 then begin;
  seek(f,(fs div 8192)-4);
  addr:=addr+((fs div 8192)-4)*8192;
 end;
 {$I-}
 read(f,buffer);
 {$I+}
 a:=ioresult;
 bufptr:=0;
 b:=nextbyte;
 repeat;
  if b=$50 then begin;
   b:=nextbyte;
   if b=$4b then begin;
    b:=nextbyte;
    if b=$01 then begin;
     b:=nextbyte;
     if b=$02 then begin;
      new(zip);
      zip^.next:=nil;
      if firstzip=nil then firstzip:=zip else lastzip^.next:=zip;
      lastzip:=zip;
      for a:=1 to 42 do bytes^[a]:=nextbyte;
      zip^.name:='';
      for a:=1 to zip^.fname_length do zip^.name:=zip^.name+chr(nextbyte);
      b:=nextbyte;
     end;
    end;
   end;
  end else b:=nextbyte;
 until addr>=fs;
close(f);
end;

procedure OutLine(s: string);
begin;
 lineout:=s;
 if OutPtr=NIL then writeln(s) else CallProc;
end;

function format_date(date: word): string;
var
 s,s2: string;
 y,m,d: word;
begin
 m:=(date shr 5) and 15;
 d:=( (date      ) and 31);
 y:=(((date shr 9) and 127)+80);
 str(m,s);
 while length(s)<2 do s:='0'+s;
 s:=s+'-';
 str(d,s2);
 while length(s2)<2 do s2:='0'+s2;
 s:=s+s2+'-';
 str(y,s2);
 while length(s2)<2 do s2:='0'+s2;
 s:=s+s2;
 format_date:=s;
end;

function format_time(time: word): string;
var
 s,s2: string;
 h,m,se: word;
begin
 h:=(time shr 11) and 31;
 m:=(time shr  5) and 63;
 se:=(time shl  1) and 63;
 str(h,s);
 while length(S)<2 do s:='0'+s;
 s:=s+':';
 str(m,s2);
 while length(s2)<2 do s2:='0'+s2;
 s:=s+s2;
 format_time:=s;
end;

  procedure DisplayZip;
  var
  curzip: zipptr;
  n:integer;
  s,s2: string;
  lc:integer;
  ARCLIST:MCIS;
{ P:POINTER;}
  begin;
  PRINTFILE('ARCTOP.ANS',ARCLIST,FALSE);
  curzip:=firstzip;
  LC:=1;
{  NEW(aRCINFO);}
  while curzip<>nil do begin;
  PRINTFILE('ARCMID.ANS',ARCLIST,FALSE);
  str(100-curzip^.compressed_size/curzip^.uncompressed_size*100:1:1,s2);
{  printxyrec(ARCINFO^.NAME.USED,ARCINFO^.NAME.X,WHEREY,curzip^.name);
  printxyrec(ARCINFO^.SIZE.USED,ARCINFO^.SIZE.X,WHEREY, strR(curzip^.uncompressed_size DIV 1024)+'k');
  printxyrec(ARCINFO^.cSIZE.USED,ARCINFO^.cSIZE.X,WHEREY, strR(curzip^.compressed_size DIV 1024)+'k');
  printxyrec(ARCINFO^.ratio.used,ARCINFO^.ratio.x,wherey,s2);
{ print('%');}
{  printxyrec(ARCINFO^.method.used,ARCINFO^.method.x,wherey,ZipMethod[curzip^.comp_method]);
  printxyrec(ARCINFO^.date.used,ARCINFO^.date.x,wherey,format_date(curzip^.last_mod_date));
  printxyrec(ARCINFO^.time.used,ARCINFO^.time.x,wherey,format_time(curzip^.last_mod_time));}
  println('');
  totallength:=totallength+curzip^.uncompressed_size;
  totalsize:=totalsize+curzip^.compressed_size;
  inc(numfiles);
  curzip:=curzip^.next;
  INC(LC);
  IF LC=20 THEN BEGIN
  PRINTLN('');
  PAUSE;
  GOXY(1,WHEREY);
  PRINT(#27+'[K');
  GOXY(1,WHEREY);
  LC:=1;
  END;
  end;

  PRINTLN('');
  PAUSE;
  GOXY(1,WHEREY);
  PRINT(#27+'[K');
  GOXY(1,WHEREY);
  PRINTFILE('ARCBOT.ANS',ARCLIST,FALSE);
{  dispose(arcinfo);}
  END;


procedure DisposeZip;
var
 curzip,savezip: zipptr;
begin;
 curzip:=firstzip;
 while curzip<>nil do begin;
  savezip:=curzip^.next;
  dispose(curzip);
  curzip:=savezip;
 end;
end;

begin;
 OutPtr:=Nil;
end.


