Unit ADFUnit;

Interface

 Procedure DisplayADF(Filename : String);
Implementation

Uses Dos; { Needed for 'Registers' Type }

     type adfrec=record
     ADF_Version  : Char;
     ADF_Pallette : Array[0..63,1..3] of Byte;
     ADF_Font     : Array[1..4096] of Char;
     ADF_Handle   : File;
     end;
{ This loads the font contained in array ADF_Font into the VGA Font Table }
Procedure Set_Font(adfinfo:adfrec);
Var Regs: Registers;
Begin
  regs.bx:= 4096;          {16 scanline font}
  regs.es:= seg(adfinfo.ADF_Font); {segment of the font data}
  regs.bp:= ofs(adfinfo.ADF_Font); {offset of the font data}
  regs.ax:= 4368;          {int 10h subfunction}
  regs.cx:= 256;           {256 characters}
  regs.dx:= 0;             {start with char #0}
  Intr(16, Regs);          {load actual data $10}
End;

{ This Sets a Value in the VGA Pallette }
Procedure SetPallette(Color,R,G,B : Byte);
Begin
 Port[$3c8] := Color;
 Port[$3c9] := R;
 Port[$3c9] := G;
 Port[$3c9] := B;
End;

{ This makes the VGA Font 8x16, eliminating the extra line on the right side }
Procedure Set8x16Font;assembler;
Asm
 mov dx,03c4h
 mov ax,0100h
 out dx,ax
 mov dx,03c4h
 mov ax,0301h
 out dx,ax
 mov dx,03c2h
 mov al,063h
 out dx,al
 mov dx,03c4h
 mov ax,0300h
 out dx,ax
 mov dx,03d4h
 mov ax,4f09h
 out dx,ax
end;
{ This changes the Blink State.. False=High Backgrounds, True=Blinking }

Procedure Blinking(State : Boolean);Assembler;
Asm
 MOV AX,1003h
 MOV BH,0
 MOV BL,State
 INT 10h
End;

Procedure DisplayADF(Filename : String);
Var    X : word;
 NumRead : Integer;
       F : File;
       adfinfo:adfrec;
Begin
 Blinking(False);
 Set8x16Font;
 asm mov ah,1;mov cx,2000h; int 10h end;  { No Cursor }
 Assign(F,Filename);
 Reset(F,1);
 Seek(F,0);
 BlockRead(F,adfinfo.ADF_Version,1);
 BlockRead(F,adfinfo.ADF_Pallette,Sizeof(adfinfo.ADF_Pallette));
 BlockRead(F,adfinfo.ADF_Font[1],4096);
 For X := 0 to 63 do
  SetPallette(X,adfinfo.ADF_Pallette[X,1],adfinfo.ADF_Pallette[X,2],adfinfo.ADF_Pallette[X,3]);
 Seek(F,4289);
 Set_Font(adfinfo);
 asm mov ah,1;mov cx,2000h; int 10h end;  { No Cursor }
 {$I-}
 BlockRead(F,Mem[$b800:0000],Filesize(F)-4289);
 {$I+}
 Close(F);
End;

Procedure GetPallette(Col : Byte; Var R,G,B : Byte);
Var rr,gg,bb : Byte;
Begin
   asm
      mov    dx,3c7h
      mov    al,col
      out    dx,al
      add    dx,2
      in     al,dx
      mov    [rr],al
      in     al,dx
      mov    [gg],al
      in     al,dx
      mov    [bb],al
   end;
   r := rr;g := gg;b := bb;
end;


Procedure LoadADFFont(Filename : String;adfinfo:adfrec);
Var X : Byte;
Begin
 Assign(adfinfo.ADF_Handle,Filename);
 Reset(adfinfo.ADF_Handle,1);
 Seek(adfinfo.ADF_Handle,193);
 BlockRead(adfinfo.ADF_Handle,adfinfo.ADF_Font[1],4096);
 Set_Font(adfinfo);
 asm mov ah,1;mov cx,2000h; int 10h end;  { No Cursor }
 Close(adfinfo.ADF_Handle);
End;

Procedure LoadADFPallette(Filename : String;adfinfo:adfrec);
Var X : Word;
Begin
 Assign(adfinfo.ADF_Handle,Filename);
 Reset(adfinfo.ADF_Handle,1);
 Seek(adfinfo.ADF_Handle,1);
 BlockRead(adfinfo.ADF_Handle,adfinfo.ADF_Pallette,Sizeof(adfinfo.ADF_Pallette));
 For X := 0 to 63 do SetPallette(X,adfinfo.ADF_Pallette[X,1],adfinfo.ADF_Pallette[X,2],adfinfo.ADF_Pallette[X,3]);
 Close(adfinfo.ADF_Handle);
End;

End.





