
'
' In all cases, Handle or Alias fields are ignored in favor of Real Name
' fields.
'
' Not converted: toggles/settings (ansi/width/protocol/etc.)
' (users)        attribute flags (deleted/etc.)
'                high msg ptr's (last message read)
'                time/dates (last on/etc.)
'                phone numbers (home/bbs/etc.)
'                time usage (used today, avail today, etc.)
'                msg/conference/file area information
'                hack attempts
'                temporary stuff (DL's today/etc.)
'                address or zip code fields (only city & state)
'
' Not converted: time/date fields
' (messages)     attribute fields
'                cost field
'
' If any of these non-conversions are a problem, let me know and I'll
' fix it.


DEFINT A-Z
'
'
' Create the data structures.
'
'
' UserRecord is the record structure of the USERS file.
'
TYPE UserRecord                    'Len = 384
  UserName      AS STRING * 30     'Uppercase only.
  Password      AS STRING * 15     'Uppercase only.
  CityState     AS STRING * 30     'Uppercase only.
  HomePhone     AS LONG            'See "ModHomePhone"
  BBSPhone      AS LONG            'See "ModBBSPhone"
  BirthDate     AS INTEGER         'Birthdate of user.
                                   'Date stored in integer form.
  SecLevel      AS INTEGER         '-32,767 to 32,767 security level.
  FirstCall     AS INTEGER         'First date user called.
                                   'Date stored in integer form.
  Attr          AS INTEGER         '16 bits: see useredit.ans
  Toggles       AS INTEGER         '16 bits:
                                   '1 True if should beep after transfers.
                                   '2 True if show Enter Msg line numbers.
                                   '3 True if show Read Msg total lines.
                                   '4 True if should "turbo" out the msgs.
                                   '5 True if user is a male.
                                   '6 True if password assist is on.
                                   '7 True if want to see L&D/Point values.
                                   'rest are used. this needs updating.
  Protocol      AS STRING * 1      'User's procotol default.
  Votes         AS STRING * 100    '=100 Voting questions (Byte answers).
  SubsStart     AS INTEGER         'Subscription start date.
                                   'Date stored in integer form.
  Language      AS STRING * 3
  ElapsedMinsC  AS INTEGER
  ElapsedMins   AS INTEGER         'elapsed non-DL/UL mins of calls today.
  LastCallerNum AS LONG
  LastDateOn    AS INTEGER         'Last time user called.
                                   'Date stored in integer form.
  PswdChange    AS STRING * 1      'Counter towards user change password order.
                                   '0 = off, 1 to 255 ascii value.
  AlterDate     AS INTEGER         'The last date in which they exercised
                                   'their Life & Death options.
                                   'Date stored in integer form.
  Toggles2      AS INTEGER         '16 bits:
  PRStuff       AS STRING * 8      'Peer Review information.
  Connect       AS STRING * 1      'Last baud user connected at.
  HiFilePtr     AS LONG            '0 to 2,100,000,000
                                   'What the "HiFilePtr" number was at the last
                                   'time they called, any stuff with
                                   'numbers higher is new to them.
  HighestPtr    AS LONG            '0 to 2,100,000,000 Highest HileFilePtr they
                                   'know about.  HiFilePtr is call
                                   'dependant--it's updated after they log out,
                                   'this isn't--this is a security measure.
  PagedSysop    AS INTEGER         '0 to 32,767 Number of times they've tried to
                                   'page the sysop.
  Logons        AS INTEGER         '0 to 32,767 Number of logons.
  Attempts      AS STRING * 1      '0 to 255 Number of bad password attempts
                                   'since their last call.
  MinCredits    AS INTEGER         '-32,767 to 32,767
                                   'Number of minutes to add to their daily
                                   'that their security level gets.
  MinMegs       AS INTEGER         '-32,767 to 32,767
                                   'This number is multiplied by 1 megabyte
                                   'and then added to their "number of
                                   'bytes can download" to determine what
                                   'their download bytes limit is.
  MsgsPosted    AS INTEGER         '0 to 32,767 Total number of public messages
                                   '(excluding NetMail) they've posted.
  EMsgsPosted   AS INTEGER         '0 to 32,767 Total number of private
                                   '(excluding feedback and NetMail) messages
                                   'they've posted.
  FMsgsPosted   AS INTEGER         '0 to 32,767 Total number of feedback
                                   'messages they've posted.
  NetMailSent   AS INTEGER         '0 to 32,767 Total number of NetMail letters
                                   'they've sent.
  NetMailRcvd   AS INTEGER         '0 to 32,767 Total number of NetMail letters
                                   'they've received.
  Elapsed       AS INTEGER         '0 to 32,767 Length of previous call(s).
                                   'Never exceeds maximum daily limit for
                                   'whatever security level.
                                   'Download minutes.
  Dnlds         AS INTEGER         '0 to 32,767 Total files downloaded.
  DLBytes       AS LONG            '0 to 2,100,000,000 Total bytes downloaded.
  MinsDLing     AS LONG            '0 to 2,100,000,000 Total number of minutes
                                   'downloading.
  BadDLs        AS INTEGER         '0 to 32,767 Total number of bad DL's.
  Uplds         AS INTEGER         '0 to 32,767 Total files uploaded.
  ULBytes       AS LONG            '-'ve to 2,100,000,000 Total bytes uploaded.
  MinsULing     AS LONG            '0 to 2,100,000,000 Total number of minutes
                                   'uploading.
  BadULs        AS INTEGER         '0 to 32,767 Total number of bad UL's.
  Doors         AS INTEGER         '0 to 32,767 Number of accesses to doors.
  SubsEnd       AS INTEGER         'Date subscription ends.
  SysopNote     AS STRING * 52     'Sysop's note field about the user.
                                   'For important internal information.
  UserNote      AS STRING * 52     'User modifiable note field.
                                   'Can be used for: self-praise, some item
                                   'the sysop should know, if a sysop--then
                                   'name of their BBS, their street address,
                                   'zip, system type, etc..  Whatever you want.
END TYPE



'
' Spitfire 3.1 user record.
'
TYPE SFUserRecord                'Len = 315
  LenUserName      AS STRING * 31
  LenCallingFrom   AS STRING * 31
  LenPassword      AS STRING * 15
  LenTimeDate      AS STRING * 15
  LenPhoneNumber   AS STRING * 13
  LenBirthDate     AS STRING * 9
  SecurityLevel    AS INTEGER
  Uploads          AS LONG
  Downloads        AS LONG
  TotalUK          AS LONG
  TotalDK          AS LONG
  TimesOn          AS INTEGER
  TimeLeft         AS INTEGER
  LastMConf        AS INTEGER
  LastFArea        AS INTEGER
  TransPro         AS INTEGER
  Defaults         AS STRING * 1
  LenFirstLogDate  AS STRING * 9
  SubscriptionDate AS LONG
  ConfQueue        AS STRING * 32
  ExtraBytes       AS STRING * 75
  AllowPurge       AS STRING * 1
  BadLastOff       AS STRING * 1
  ScrollBack       AS STRING * 1
  Xpert            AS STRING * 1
  LockedOut        AS STRING * 1
  Deleted          AS STRING * 1
  Linelen          AS STRING * 1
  Pagelen          AS STRING * 1
  OnToday          AS STRING * 1
  Illegal          AS STRING * 1
  DLToday          AS STRING * 1
  ForeGround       AS STRING * 1
  ExtraWord        AS INTEGER
  DLBytes          AS LONG
  LenNewFCheck     AS STRING * 9
  OrgSecurity      AS INTEGER
  ChatsToday       AS INTEGER
  Extra            AS STRING * 21
END TYPE
'
' Telegard 2.7 user record.
'
TYPE TGUserRecord                'Len = 2089
  LenHandle    AS STRING * 37    '/* user name */
  LenName      AS STRING * 37    '/* real name */
  LenAddress   AS STRING * 31    '/* mailing address */
  LenCityState AS STRING * 31    '/* city, state */
  LenZipCode   AS STRING * 11    '/* zipcode */
  LenPhone     AS STRING * 13    '/* user phone # */
  LenBirthDate AS STRING * 9     '/* user birthdate */
  Gender       AS STRING * 1     '/* user sex */
  LenPassword  AS STRING * 21    '/* user password */
  LenFirstCall AS STRING * 9     '/* firston date */
  LenLastOn    AS STRING * 9     '/* laston date */
  LenComputer  AS STRING * 31    '/* type of computer */
  LenJob       AS STRING * 41    '/* occupation */
  LenBBSRef    AS STRING * 41    '/* BBS reference */
  LenSysopNote AS STRING * 40    '/* SysOp note */
  LenLockOut   AS STRING * 9     '/* lockout msg to print */
  Colors       AS STRING * 20    '/* user colors */
  LineLength   AS STRING * 1     '/* line length (# cols) */
  PageLength   AS STRING * 1     '/* page length (# rows) */
  MacroPtr     AS LONG           '/* pointer to entry in MACRO.LST */
  LenMenu      AS STRING * 9     '/* menu to start user out on */
  Toggles      AS STRING * 2     '/* flags (see above) */
  SecLevel     AS STRING * 1     '/* SL */
  DSL          AS STRING * 1     '/* DSL */
  Attr         AS STRING * 3     '/* user flags */
  ARFlags      AS STRING * 4     '/* AR flags */
  LastMsgBase  AS STRING * 1     '/* last message base # */
  MsgsPosted   AS INTEGER        '/* # public posts */
  EMsgsPosted  AS INTEGER        '/* # private posts */
  NetMailSent  AS INTEGER        '/* # NetMail posts */
  FwdToUserNum AS INTEGER        '/* forward mail to user # */
  CreditMonies AS LONG           '/* NetMail points (credit) */
  DebitMonies  AS LONG           '/* NetMail points (debit) */
  LastRead     AS STRING * 1536  '/* NewScan high message pointers */
  MBasesTogs   AS STRING * 32    '/* NewScan message bases */
  BoardSysop   AS STRING * 5     '/* msg board SysOp */
  LastFileBase AS STRING * 1     '/* last file base # */
  Uplds        AS INTEGER        '/* # of ULs */
  Dnlds        AS INTEGER        '/* # of DLs */
  ULBytesK     AS LONG           '/* amount ULed (kilobytes) */
  DLBytesK     AS LONG           '/* amount DLed (kilobytes) */
  FilePoints   AS INTEGER        '/* # of file points */
  ListType     AS STRING * 1     '/* type of file list type to use */
  FBasesTogs   AS STRING * 32    '/* NewScan file bases */
  TotalMins    AS LONG           '/* total mins spent on */
  Logons       AS INTEGER        '/* # times logged on */
  MinsLeft     AS INTEGER        '/* # min left today */
  TimesOnToday AS STRING * 1     '/* # times on today */
  Attempts     AS STRING * 1     '/* # illegal logon attempts */
  VoteData     AS STRING * 20    '/* voting data */
  BankedMins   AS INTEGER        '/* # mins in Time Bank */
  BankedToday  AS INTEGER        '/* time added to timebank TODAY */
END TYPE
'
' Renegade 11-xx-92 user record.
'
TYPE RGUserRecord                'Len = 1567
  LenHandle    AS STRING * 37    '/* user name */
  LenName      AS STRING * 37    '/* real name */
  LenPassword  AS STRING * 21    '/* user password */
  LenPhone     AS STRING * 13    '/* user phone # */
  LenBirthDate AS STRING * 9     '/* user birthdate */
  LenFirstCall AS STRING * 9     '/* firston date */
  LenLastOn    AS STRING * 9     '/* laston date */
  LenAddress   AS STRING * 31    '/* mailing address */
  LenCityState AS STRING * 31    '/* city, state */
  LenZipCode   AS STRING * 11    '/* zipcode */
  LenComputer  AS STRING * 36    '/* type of computer */
  LenJob       AS STRING * 36    '/* occupation */
  LenBBSRef    AS STRING * 36    '/* BBS reference */
  LenSysopNote AS STRING * 36    '/* SysOp note */
  LenMenu      AS STRING * 9     '/* menu to start user out on */
  LenLockOut   AS STRING * 9     '/* lockout msg to print */
  Toggles      AS STRING * 2     '/* flags (see above) */
  Attr         AS STRING * 3     '/* user flags */
  ARFlags      AS STRING * 4     '/* AR flags */
  VoteData     AS STRING * 25    '/* voting data */
  Gender       AS STRING * 1     '/* user sex */
  TotalMins    AS LONG           '/* total mins spent on */
  ULBytesK     AS LONG           '/* amount ULed (kilobytes) */
  DLBytesK     AS LONG           '/* amount DLed (kilobytes) */
  MinsLeft     AS INTEGER        '/* # min left today */
  FwdToUserNum AS INTEGER        '/* forward mail to user # */
  FilePoints   AS INTEGER        '/* # of file points */
  Uplds        AS INTEGER        '/* # of ULs */
  Dnlds        AS INTEGER        '/* # of DLs */
  Logons       AS INTEGER        '/* # times logged on */
  MsgsPosted   AS INTEGER        '/* # public posts */
  EMsgsPosted  AS INTEGER        '/* # private posts */
  FeedbackSent AS INTEGER        '/* # feedback posts */
  BankedMins   AS INTEGER        '/* # mins in Time Bank */
  BankedToday  AS INTEGER        '/* time added to timebank TODAY */
  DLKBToday    AS INTEGER        '{ # kbytes dl today}
  FilesToday   AS INTEGER        '{ # files dl today }
  MailWaiting  AS STRING * 1     '{ mail waiting     }
  LineLength   AS STRING * 1     '/* line length (# cols) */
  PageLength   AS STRING * 1     '/* page length (# rows) */
  TimesOnToday AS STRING * 1     '/* # times on today */
  Attempts     AS STRING * 1     '/* # illegal logon attempts */
  Barf         AS STRING * 1     '
  LastMsgBase  AS STRING * 1     '/* last message base # */
  LastFileBase AS STRING * 1     '/* last file base # */
  SecLevel     AS STRING * 1     '/* SL */
  DSL          AS STRING * 1     '/* DSL */
  LastRead     AS STRING * 1000  '/* NewScan high message pointers */
  MBasesTogs   AS STRING * 32    '/* NewScan message bases */
  FBasesTogs   AS STRING * 32    '/* NewScan file bases */
  Colors       AS STRING * 20    '/* user colors */
  Garbage      AS STRING * 1
  TimeBankWith AS INTEGER        '{ amount of time withdrawn today}
  PassWordCh   AS INTEGER        '{ last day password changed }
  DefArcType   AS STRING * 1     '{ default QWK archive type }
  LastConf     AS STRING * 1     '{ last conference they were in }
  LastQwk      AS LONG           '{ date/time of last qwk packet }
  GetOwnQwk    AS STRING * 1     '{ add own messages to qwk packet? }
  ScanFilesQwk AS STRING * 1     '{ scan file bases for qwk packets? }
  PrivateQwk   AS STRING * 1     '{ get private mail in qwk packets? }
  Res          AS STRING * 16    '{ RESERVED }
END TYPE
'
' RemoteAccess 1.11 user record.
'
TYPE RAUserRecord                'Len = 158
  LenName       AS STRING * 36
  LenLocation   AS STRING * 26
  LenPassword   AS STRING * 16
  LenDataPhone  AS STRING * 13
  LenVoicePhone AS STRING * 13
  LenLastTime   AS STRING * 6
  LenLastDate   AS STRING * 9
  Attr          AS STRING * 1
  Flags         AS STRING * 4
  Credit        AS INTEGER
  Pending       AS INTEGER
  MsgsPosted    AS INTEGER
  LastRead      AS INTEGER
  Security      AS INTEGER
  NoCalls       AS INTEGER
  Uploads       AS INTEGER
  Downloads     AS INTEGER
  UploadsK      AS INTEGER
  DownloadsK    AS INTEGER
  TodayK        AS INTEGER
  Elapsed       AS INTEGER
  ScreenLength  AS INTEGER
  LastPwdChange AS STRING * 1
  Toggles       AS STRING * 1
  Group         AS STRING * 1
  XIrecord      AS INTEGER
  ExtraSpace    AS STRING * 3
END TYPE
'
'
' MessageRecord is the record structure used for each messages header in
' the MESSAGES file.
'
TYPE MessageRecord               'Len = 136
  Attr          AS INTEGER       '16 bits:
                                 '1 True if a deleted message.
                                 '2 True if Msg body is compressed.
                                 '3 True if this is a reply.
                                 'x True if NetMail
                                 'x True if shouldn't ever NetMail out.
                                 'x True if shouldn't ever Auto delete.
                                 'x True if should never delete at all.
                                 '8 True if redirected from sysop.
                                 '9 True if redirected from AI.
                                 '10 True if redirected to sysop.
                                 '11 True if redirected to AI.
                                 '12 True if there are file attaches.
                                 '13 True if message will be completed later.
                                 '14 True if any file attaches are free.
                                 '16 True if want's RR (temporary until NetMail)
                                 'Rest are for the future.
  MsgNum        AS LONG          '1 to 2,100,000,000 message number.
                                 'Each message base has it's own message
                                 'counter.
  MsgFrom       AS STRING * 30   'Name of sender.  Uppercase.
  MsgTo         AS STRING * 30   'Name of receiver or "ALL".  Uppercase.
  MsgDateSent   AS INTEGER       'Date message was sent.
                                 'Date stored in integer form.
  MsgTimeSent   AS INTEGER       'Time stored in integer form.
                                 'HHMM and +/-'ve depending on am/pm.
  MsgDateRcvd   AS INTEGER       'Date message was received.  0 if not
                                 'received or sent to "ALL".
                                 'Date stored in integer form.
  MsgTimeRcvd   AS INTEGER       'Time stored in integer form.
                                 'HHMM and +/-'ve depending on am/pm.
  NumOfBytes    AS INTEGER       'Doesn't exceed 8192, message length.
  NumberReplies AS STRING * 1    'This message has been replied to x times.
                                 'This is not the number of active replies.
  TimesRead     AS INTEGER       'Number of times this message has been read.
  LastDateRead  AS INTEGER       'last date anybody read the message.
  MsgSubject    AS STRING * 33   'Compressed text--message subject.
  MsgBase       AS INTEGER       '0 - 32,767 Message bases.
  MsgCheckSum   AS INTEGER       'ELIM
  Attr2         AS INTEGER       '
  SourceAddr    AS STRING * 6          'NetMail source address.
  DestAddr      AS STRING * 6          'NetMail destination address.
  MsgLoc        AS LONG
END TYPE
'
' Spitfire 3.1 message header record.
'
TYPE SFMsgHeaderRec              'Len = 256
  LenMDate        AS STRING * 18
  LenFromWho      AS STRING * 31
  LenToWho        AS STRING * 31
  LenOrgTo        AS STRING * 31
  LenSubject      AS STRING * 41
  NetMail         AS STRING * 1
  MsgSent         AS STRING * 1
  PurgeWhenSent   AS STRING * 1
  ThreadMsg       AS STRING * 1
  ThreadStart     AS STRING * 1
  Private         AS STRING * 1
  Deleted         AS STRING * 1
  Received        AS STRING * 1
  Where           AS INTEGER
  NumberofRecords AS INTEGER
  Conference      AS INTEGER
  MsgNumber       AS LONG
  OrgMsgNumber    AS LONG
  Extra           AS STRING * 82
END TYPE
'
' Telegard 2.7 message header record.
'
TYPE TGMsgHeaderRec              'Len = 345
  TextPtr    AS LONG             '/* pointer to message text */
  MsgLength  AS INTEGER          '/* length of message text */
  Cost       AS INTEGER          '/* cost to send message (NetMail only) */
  FAnonFlag  AS STRING * 1       '/* anonymous type (0=no, 1/2=yes, 3="Abby", */
  FUserRec   AS INTEGER          '/* user number (0=none) */
  FZone      AS INTEGER          '/* zone (0=none) */
  FNet       AS INTEGER          '/* net (0=none) */
  FNode      AS INTEGER          '/* node (0=none) */
  FPoint     AS INTEGER          '/* point (0=none) */
  FLenHandle AS STRING * 37      '/* user name (all caps) if anon=3..5, */
  FLenName   AS STRING * 37      '/* user real name (all caps) */
  FLenAlias  AS STRING * 37      '/* user alias (all caps) */
  TAnonFlag  AS STRING * 1       '/* anonymous type (0=no, 1/2=yes, 3="Abby", */
  TUserRec   AS INTEGER          '/* user number (0=none) */
  TZone      AS INTEGER          '/* zone (0=none) */
  TNet       AS INTEGER          '/* net (0=none) */
  TNode      AS INTEGER          '/* node (0=none) */
  TPoint     AS INTEGER          '/* point (0=none) */
  TLenHandle AS STRING * 37      '/* user name (all caps) if anon=3..5, */
  TLenName   AS STRING * 37      '/* user real name (all caps) */
  TLenAlias  AS STRING * 37      '/* user alias (all caps) */
  LenTitle   AS STRING * 72      '/* title of message */
  LenDate    AS STRING * 20      '/* Net/Echo/Group original msg date */
END TYPE
'
' Renegade 11-xx-92 message header record.
'
TYPE RGMsgHeaderRec              'Len = 326
  FAnonFlag  AS STRING * 1       '/* anonymous type (0=no, 1/2=yes, 3="Abby", */
  FUserRec   AS INTEGER          '/* user number (0=none) */
  FLenHandle AS STRING * 37      '/* user name (all caps) if anon=3..5, */
  FLenName   AS STRING * 37      '/* user real name (all caps) */
  FLenAlias  AS STRING * 37      '/* user alias (all caps) */
  FZone      AS INTEGER          '/* zone (0=none) */
  FNet       AS INTEGER          '/* net (0=none) */
  FNode      AS INTEGER          '/* node (0=none) */
  FPoint     AS INTEGER          '/* point (0=none) */
  TAnonFlag  AS STRING * 1       '/* anonymous type (0=no, 1/2=yes, 3="Abby", */
  TUserRec   AS INTEGER          '/* user number (0=none) */
  TLenHandle AS STRING * 37      '/* user name (all caps) if anon=3..5, */
  TLenName   AS STRING * 37      '/* user real name (all caps) */
  TLenAlias  AS STRING * 37      '/* user alias (all caps) */
  TZone      AS INTEGER          '/* zone (0=none) */
  TNet       AS INTEGER          '/* net (0=none) */
  TNode      AS INTEGER          '/* node (0=none) */
  TPoint     AS INTEGER          '/* point (0=none) */
  TextPtr    AS LONG             '/* pointer to message text */
  MsgLength  AS INTEGER          '/* length of message text */
  ReplyTo    AS INTEGER          '{ message it's a reply to }
  Date       AS LONG             '{ date/time packed string }
  DayOfWeek  AS STRING * 1       '{ message day of week     }
  Status     AS STRING * 1       '{ message status flags    }
  Replies    AS INTEGER          '{ times replied to        }
  LenSubject AS STRING * 41      '{ subject of message      }
  LenOrgDate AS STRING * 20      '{ date of echo/group msgs }
  FileAttach AS STRING * 1       '{ 0=No, 1=Yes&Del, 2=Yes&Save }
  Res        AS STRING * 4       '{ reserved }
END TYPE
'
' RemoteAccess 1.11 message header record.
'
TYPE RAMsgHeaderRec              'Len = 187
  MsgNum      AS INTEGER
  PrevReply   AS INTEGER
  NextReply   AS INTEGER
  TimesRead   AS INTEGER
  StartBlock  AS INTEGER
  NumBlocks   AS INTEGER
  DestNet     AS INTEGER
  DestNode    AS INTEGER
  OrigNet     AS INTEGER
  OrigNode    AS INTEGER
  DestZone    AS STRING * 1
  OrigZone    AS STRING * 1
  Cost        AS INTEGER
  MsgAttr     AS STRING * 1
  NetAttr     AS STRING * 1
  Board       AS STRING * 1
  LenPostTime AS STRING * 6
  LenPostDate AS STRING * 9
  LenWhoTo    AS STRING * 36
  LenWhoFrom  AS STRING * 36
  LenSubject  AS STRING * 73
END TYPE


DECLARE FUNCTION Adjust$ (st$)


COMMON SHARED _
  User AS UserRecord, _
  SFUser AS SFUserRecord, _
  TGUser AS TGUserRecord, _
  RGUser AS RGUserRecord, _
  RAUser AS RAUserRecord, _
  Message AS MessageRecord, _
  SFMsg AS SFMsgHeaderRec, _
  TGMsg AS TGMsgHeaderRec, _
  RGMsg AS RGMsgHeaderRec, _
  RAMsg AS RAMsgHeaderRec


'
' Start of actual code.
'
CLS
PRINT
PRINT "This program converts the users and messages of other BBS programs to JDR_BBS"
PRINT "format.  The USERS file is created new, but MESSAGES is appended onto."
PRINT
PRINT "  *All files must be in the current directory.*      *Make backups.*"
PRINT
PRINT "     FROM                                             TO"
PRINT "* 1. Spitfire 3.1 SFUSERS.DAT                         JDR_BBS .09 USERS"
PRINT "* 2. Telegard 2.7 USER.LST                            JDR_BBS .09 USERS"
PRINT "* 3. RemoteAccess 1.11 USERS.BBS                      JDR_BBS .09 USERS"
PRINT "* 4. Renegade 11-xx-92 USER.LST                       JDR_BBS .09 USERS"
PRINT "* 5. Spitfire 3.1 SFMSGxx.PTR/SFMSGxx.DAT             JDR_BBS .09 MESSAGES"
PRINT "* 6. Telegard 2.7 x.BRD                               JDR_BBS .09 MESSAGES"
PRINT "  7. RemoteAccess 1.11 MSGHDR.BBS/MSGTXT.BBS          JDR_BBS .09 MESSAGES"
PRINT "* 8. Renegade 11-xx-92 x.BRD                          JDR_BBS .09 MESSAGES"
PRINT "*These have not yet been tested."
PRINT
PRINT "If the conversion doesn't work, or is not to your liking, tell me and I will"
PRINT "fix the problem, and put up a working/better version the next day on my BBS."
PRINT
PRINT "Do which [1..8]";
INPUT K
PRINT
SELECT CASE K
  CASE 1 : PRINT "Working...";
           CALL SFtoJDR
  CASE 2 : PRINT "Working...";
           CALL TGtoJDR
  CASE 3 : PRINT "Working...";
           CALL RAtoJDR
  CASE 4 : PRINT "Working...";
           CALL RGtoJDR
  CASE 5 : CALL SFMsgToJDR
  CASE 6 : CALL TGMsgToJDR
  CASE 7 : PRINT "Working...";
           CALL RAMsgToJDR
  CASE 8 : CALL RGMsgToJDR
END SELECT
SELECT CASE K
  CASE 1 TO 4
       PRINT "Done."
       PRINT
       PRINT "Please delete your INDEXES\USERS.IDX file if it had previously existed."
       PRINT "Copy USERS to GLOBAL\SYSTEM\ for use."
  CASE 5 TO 8
       PRINT "Done."
       PRINT
       PRINT "Please delete your INDEXES\MSGS_*.IDX files if they had previously existed."
       PRINT "Copy MESSAGES.* to GLOBAL\SYSTEM\ for use."
END SELECT
END


SUB SFtoJDR
OPEN "SFUSERS.DAT" FOR BINARY AS #1
OPEN "USERS" FOR BINARY AS #2
CALL InitNewUser
FOR K0 = 1 TO LOF(1) \ 315
  GET #1,K0,SFUser
  User.UserName  = Adjust$(SFUser.LenUserName)
  User.Password  = Adjust$(SFUser.LenPassword)
  User.CityState = Adjust$(SFUser.LenCallingFrom)
  User.SecLevel  = SFUser.SecurityLevel
  User.Logons    = SFUser.TimesOn
  User.Dnlds     = SFUser.Downloads
  User.DLBytes   = SFUser.TotalDK * 1024&
  User.Uplds     = SFUser.Uploads
  User.ULBytes   = SFUser.TotalUK * 1024&
  PUT #2,K0 + 1,User
NEXT
CLOSE 1, 2
END SUB


SUB TGtoJDR
OPEN "USER.LST" FOR BINARY AS #1
OPEN "USERS" FOR BINARY AS #2
CALL InitNewUser
FOR K0 = 2 TO LOF(1) \ 2089      'Start at second record.
  GET #1,K0,TGUser
  User.UserName    = Adjust$(TGUser.LenName)
  User.Password    = Adjust$(TGUser.LenPassword)
  User.CityState   = Adjust$(TGUser.LenCityState)
  User.SecLevel    = ASC(TGUser.SecLevel)
'  User.Monies      = TGUser.CreditMonies
'  User.TotalMonies = TGUser.DebitMonies
  User.Logons      = TGUser.Logons
  User.MinCredits  = TGUser.FilePoints
  User.MsgsPosted  = TGUser.MsgsPosted
  User.EMsgsPosted = TGUser.EMsgsPosted
  User.NetMailSent = TGUser.NetMailSent
  User.Dnlds       = TGUser.Dnlds
  User.DLBytes     = TGUser.DLBytesK * 1024&
  User.Uplds       = TGUser.Uplds
  User.ULBytes     = TGUser.ULBytesK * 1024&
  User.SysopNote   = Adjust$(TGUser.LenSysopNote)
  PUT #2,K0,User
NEXT
CLOSE 1, 2
END SUB


SUB RGtoJDR
OPEN "USER.LST" FOR BINARY AS #1
OPEN "USERS" FOR BINARY AS #2
CALL InitNewUser
FOR K0 = 2 TO LOF(1) \ 1567      'Start at second record.
  GET #1,K0,RGUser
  User.UserName    = Adjust$(RGUser.LenName)
  User.Password    = Adjust$(RGUser.LenPassword)
  User.CityState   = Adjust$(RGUser.LenCityState)
  User.SecLevel    = ASC(RGUser.SecLevel)
  User.Logons      = RGUser.Logons
  User.MinCredits  = RGUser.FilePoints
  User.MsgsPosted  = RGUser.MsgsPosted
  User.EMsgsPosted = RGUser.EMsgsPosted
  User.FMsgsPosted = RGUser.FeedbackSent
  User.Dnlds       = RGUser.Dnlds
  User.DLBytes     = RGUser.DLBytesK * 1024&
  User.Uplds       = RGUser.Uplds
  User.ULBytes     = RGUser.ULBytesK * 1024&
  User.SysopNote   = Adjust$(RGUser.LenSysopNote)
  PUT #2,K0,User
NEXT
CLOSE 1, 2
END SUB


SUB RAtoJDR
OPEN "USERS.BBS" FOR BINARY AS #1
OPEN "USERS" FOR BINARY AS #2
CALL InitNewUser
FOR K0 = 1 TO LOF(1) \ 158
  GET #1,K0,RAUser
  User.UserName   = Adjust$(RAUser.LenName)
  User.Password   = Adjust$(RAUser.LenPassword)
  User.CityState  = Adjust$(RAUser.LenLocation)
  User.SecLevel   = RAUser.Security
  User.Logons     = RAUser.NoCalls
  User.Dnlds      = RAUser.Downloads
  User.DLBytes    = RAUser.DownloadsK * 1024&
  User.Uplds      = RAUser.Uploads
  User.ULBytes    = RAUser.UploadsK * 1024&
  User.MinCredits = RAUser.Credit
  User.MsgsPosted = RAUser.MsgsPosted
  PUT #2,K0 + 1,User
NEXT
CLOSE 1, 2
END SUB


SUB SFMsgToJDR
INPUT "Full path\filename to use [no extension] (a .PTR file): ";K$
IF K$ = "" THEN EXIT SUB
PRINT "Working..."
OPEN K$ + "PTR" FOR BINARY AS #1
OPEN K$ + "DAT" FOR BINARY AS #2
OPEN "MESSAGES.HDR" FOR BINARY AS #3
OPEN "MESSAGES.BDY" FOR BINARY AS #4
CALL InitMsg
SEEK #3,LOF(3) + 1
SEEK #4,LOF(4) + 1
K& = 0
DO
  GET #1,,SFMsg
  Message.MsgNum      = SFMsg.MsgNumber
  Message.MsgFrom     = Adjust$(SFMsg.LenFromWho)
  Message.MsgTo       = Adjust$(SFMsg.LenToWho)
  Message.MsgSubject  = Adjust$(SFMsg.LenSubject)
  Message.MsgBase     = SFMsg.Conference
  MessageBody$ = ""
  K$ = SPACE$(128)
  FOR K = SFMsg.Where TO SFMsg.Where + SFMsg.NumberofRecords - 1
    K0& = (K - 1) * 128& + 1
    GET #2,K0&,K$
    MessageBody$ = LEFT$(MessageBody$ + Adjust$(K$),8192)
  NEXT
  Message.NumOfBytes = LEN(MessageBody$)
  Message.MsgLoc = K&
  PUT #3,,Message
  PUT #4,,MessageBody$
  K& = K& + Message.NumOfBytes
LOOP UNTIL EOF(1)
CLOSE 1, 2, 3, 4
END SUB


SUB TGMsgToJDR
INPUT "Full path\filename to use (a .BRD file): ";K$
IF K$ = "" THEN EXIT SUB
INPUT "Message base number to use (1..n): ";K0
PRINT "Working..."
OPEN K$ FOR BINARY AS #1
OPEN "MESSAGES.HDR" FOR BINARY AS #2
OPEN "MESSAGES.BDY" FOR BINARY AS #3
CALL InitMsg
SEEK #3,LOF(2) + 1
SEEK #4,LOF(3) + 1
K& = 0
K = 0
DO
  GET #1,,TGMsg
  K = K + 1
  Message.MsgNum      = K
  Message.MsgFrom     = Adjust$(TGMsg.FLenName)
  Message.MsgTo       = Adjust$(TGMsg.TLenName)
  Message.MsgSubject  = Adjust$(TGMsg.LenTitle)
  Message.MsgBase     = K0
  Message.SourceAddr  = MKI$(TGMsg.FZone) + MKI$(TGMsg.FNet) + MKI$(TGMsg.FNode)
  IF Message.SourceAddr = STRING$(6,0) THEN Message.SourceAddr = SPACE$(6)
  Message.DestAddr    = MKI$(TGMsg.TZone) + MKI$(TGMsg.TNet) + MKI$(TGMsg.TNode)
  IF Message.DestAddr = STRING$(6,0) THEN Message.DestAddr = SPACE$(6)
  MessageBody$ = SPACE$(TGMsg.MsgLength)
  GET #1,,MessageBody$
  MessageBody$ = LEFT$(MessageBody$,8192)
  Message.NumOfBytes = LEN(MessageBody$)
  Message.MsgLoc = K&
  PUT #2,,Message
  PUT #3,,MessageBody$
  K& = K& + Message.NumOfBytes
LOOP UNTIL EOF(1)
CLOSE 1, 2, 3
END SUB


SUB RGMsgToJDR
INPUT "Full path\filename to use (a .BRD file): ";K$
IF K$ = "" THEN EXIT SUB
INPUT "Message base number to use (1..n): ";K0
PRINT "Working..."
OPEN K$ FOR BINARY AS #1
OPEN "MESSAGES.HDR" FOR BINARY AS #2
OPEN "MESSAGES.BDY" FOR BINARY AS #3
CALL InitMsg
SEEK #3,LOF(2) + 1
SEEK #4,LOF(3) + 1
K& = 0
K = 0
DO
  GET #1,,RGMsg
  K = K + 1
  Message.MsgNum      = K
  Message.MsgFrom     = Adjust$(RGMsg.FLenName)
  Message.MsgTo       = Adjust$(RGMsg.TLenName)
  Message.MsgSubject  = Adjust$(RGMsg.LenSubject)
  Message.MsgBase     = K0
  Message.SourceAddr  = MKI$(RGMsg.FZone) + MKI$(RGMsg.FNet) + MKI$(RGMsg.FNode)
  IF Message.SourceAddr = STRING$(6,0) THEN Message.SourceAddr = SPACE$(6)
  Message.DestAddr    = MKI$(RGMsg.TZone) + MKI$(RGMsg.TNet) + MKI$(RGMsg.TNode)
  IF Message.DestAddr = STRING$(6,0) THEN Message.DestAddr = SPACE$(6)
  MessageBody$ = SPACE$(RGMsg.MsgLength)
  GET #1,,MessageBody$
  MessageBody$ = LEFT$(MessageBody$,8192)
  Message.NumOfBytes = LEN(MessageBody$)
  Message.MsgLoc = K&
  PUT #2,,Message
  PUT #3,,MessageBody$
  K& = K& + Message.NumOfBytes
LOOP UNTIL EOF(1)
CLOSE 1, 2, 3
END SUB


SUB RAMsgToJDR
OPEN "MSGHDR.BBS" FOR BINARY AS #1
OPEN "MSGTXT.BBS" FOR BINARY AS #2
OPEN "MESSAGES.HDR" FOR BINARY AS #3
OPEN "MESSAGES.BDY" FOR BINARY AS #4
CALL InitMsg
SEEK #3,LOF(3) + 1
SEEK #4,LOF(4) + 1
K& = 0
DO
  GET #1,,RAMsg
  Message.MsgNum      = RAMsg.MsgNum
  Message.MsgFrom     = Adjust$(RAMsg.LenWhoFrom)
  Message.MsgTo       = Adjust$(RAMsg.LenWhoTo)
  Message.TimesRead   = RAMsg.TimesRead
  Message.MsgSubject  = Adjust$(RAMsg.LenSubject)
  Message.MsgBase     = ASC(RAMsg.Board) - 1
  IF Message.MsgBase < 0 THEN Message.MsgBase = 0
  Message.SourceAddr  = MKI$(ASC(RAMsg.OrigZone)) + MKI$(RAMsg.OrigNet) + MKI$(RAMsg.OrigNode)
  IF Message.SourceAddr = STRING$(6,0) THEN Message.SourceAddr = SPACE$(6)
  Message.DestAddr    = MKI$(ASC(RAMsg.DestZone)) + MKI$(RAMsg.DestNet) + MKI$(RAMsg.DestNode)
  IF Message.DestAddr = STRING$(6,0) THEN Message.DestAddr = SPACE$(6)
  MessageBody$ = ""
  K$ = SPACE$(256)
  FOR K = RAMsg.StartBlock TO RAMsg.StartBlock + RAMsg.NumBlocks - 1
    K0& = K * 256& + 1
    GET #2,K0&,K$
    MessageBody$ = LEFT$(MessageBody$ + Adjust$(K$),8192)
  NEXT
  Message.NumOfBytes = LEN(MessageBody$)
  Message.MsgLoc = K&
  PUT #3,,Message
  PUT #4,,MessageBody$
  K& = K& + Message.NumOfBytes
LOOP UNTIL EOF(1)
CLOSE 1, 2, 3, 4
END SUB


SUB InitMsg
Message.Attr          = 0
Message.MsgNum        = 0
Message.MsgFrom       = ""
Message.MsgTo         = ""
Message.MsgDateSent   = 0
Message.MsgTimeSent   = 0
Message.MsgDateRcvd   = 0
Message.MsgTimeRcvd   = 0
Message.NumOfBytes    = 0
Message.NumberReplies = CHR$(0)
Message.TimesRead     = 0
Message.LastDateRead  = 0
Message.MsgSubject    = ""
Message.MsgBase       = 0
Message.MsgCheckSum   = 0
Message.Attr2         = 0
Message.SourceAddr    = SPACE$(6)
Message.DestAddr      = SPACE$(6)
END SUB


SUB InitNewUser
User.UserName      = ""
User.Password      = ""
User.CityState     = ""
User.HomePhone     = 0
User.BBSPhone      = 0
User.BirthDate     = 0
User.SecLevel      = 0
User.FirstCall     = 0
User.Attr          = 0
User.Toggles       = 0
User.Protocol      = "Z"
User.Votes         = ""
User.SubsStart     = 0
User.Language      = ""
ElapsedMinsC       = 0
ElapsedMins        = 0
'User.Monies        = 0
User.LastCallerNum = 0
User.LastDateOn    = 0
User.PswdChange    = CHR$(0)
User.AlterDate     = 0
User.Toggles2      = 0
User.PRStuff       = STRING$(8,0)
User.Connect       = ""
User.HiFilePtr     = 0
User.HighestPtr    = 0
User.PagedSysop    = 0
User.Logons        = 0
User.Attempts      = CHR$(0)
User.MinCredits    = 0
User.MinMegs       = 0
User.MsgsPosted    = 0
User.EMsgsPosted   = 0
User.FMsgsPosted   = 0
User.NetMailSent   = 0
User.NetMailRcvd   = 0
User.Elapsed       = 0
User.Dnlds         = 0
User.DLBytes       = 0
User.MinsDLing     = 0
User.BadDLs        = 0
User.Uplds         = 0
User.ULBytes       = 0
User.MinsULing     = 0
User.BadULs        = 0
User.Doors         = 0
User.SubsEnd       = 0
User.SysopNote     = ""
User.UserNote      = ""
PUT #1,1,User
END SUB


FUNCTION Adjust$ (K$)
Adjust$ = MID$(K$,2,ASC(K$))
END FUNCTION




'
' to compile: BC CONVERT.BAS /O/S/FS;
' to link   : LINK /EXEPACK /PACKCODE CONVERT;
' requires  : BC.EXE, LINK.EXE, BCL70EFR.LIB, BRT70EFR.LIB
'             (Basic PDS 7.0+, although it should compile with other Basic's).
'


