' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.
'
'
' Various sysop routines that affect the file(s):
'   AlterTheFilesData
'   DescImport
'   ValidateFiles
'   Penalize





        '* * * * * *
        ' This routine works on a active file's FILELIST record.  It
        ' can also be used to move a file to a different downloads
        ' directory.
        '
        ' p number of directories to use.
        '
        ' Date last checked for perfection: Sep 14 1992
        '
SUB AlterTheFilesData (p)

  CALL BlockToO(3,10)
  DO
    TT = 20001
    CALL SendTT
    CALL GetFileName(16,K$,K,Null$)
    IF K < 1 THEN EXIT DO
    K4 = FileOpenR(FileNames(4))
    K = BiSearch(3,0,Form$(1201,K$))
    CALL FileGetRec(K4,FileIDX.FRec,119,FileList)
    CALL FileCloseR(K4)
    TT = 20005
    CALL SendTT
    K5 = -1
    K7 = 0
    FOR K0 = 1 TO 13
      SELECT CASE K0
        CASE 1  : K$ = FileList.FName
        CASE 2  : K$ = STR$(FileList.FSize)
        CASE 3  : K$ = FileList.FDesc
        CASE 4  : K$ = FileList.UserName
        CASE 5  : K$ = STR$(FileList.LDCount)
        CASE 6  : K$ = STR$(FileList.FArea)
        CASE 7  : K$ = STR$(FileList.Group)
        CASE 8  : K$ = STR$(FileList.Password)
        CASE 9  : K$ = STR$(FileList.HiFilePtr)
        CASE 10 : K$ = STR$(FileList.Downloaded)
        CASE 11 : K$ = IntToDate2$(FileList.DateULed)
        CASE 12 : K$ = IntToDate2$(FileList.LastDLed)
        CASE 13 : K$ = IntToAttr$(FileList.Attr)
                  K6 = BitTest(FileList.Attr,3)
      END SELECT
      SELECT CASE K0
        CASE 3     : TT$ = o$(K0 + 5) + LTRIM$(RTRIM$(K$)) + o$(19)
        CASE 13    : TT$ = o$(K0 + 5) + K$ + o$(20)
        CASE ELSE  : TT$ = o$(K0 + 5) + LTRIM$(RTRIM$(K$)) + o$(20)
      END SELECT
      IF K0 = 4 THEN K1 = GetUserNameTT _
                ELSE K$ = LineEditTT$(51) : _
                     K& = Val2&(K$) : _
                     K1 = LEN(K$)
      IF NoCarrier THEN EXIT FOR
      CALL DispCRLF
      IF K1 > 0 THEN K1 = K0 : _
                     K7 = -1 _
                ELSE K1 = 0
      SELECT CASE K1
        CASE 1
             K$ = LTRIM$(UCASE$(K$))
             SELECT CASE K$
               CASE IS <> RTRIM$(FileList.FName)
                    IF FileList.FArea <= DirsSize _
                       THEN K0$ = FileAreaInfo3$(FileList.FArea,2) : _
                            CALL CopyFile(1,K0$ + FileList.FName,K0$ + K$)
                    KK = FileOpenW(FileNames(59))
                    K = BiSearch(3,KK,FileList.FName)
                    FileIDX.FName = K$
                    CALL FilePutRec(KK,K,22,FileIDX)
                    CALL FileSort2(KK,22,-2)
                    CALL FileCloseW(KK)
                    FileList.FName = K$
             END SELECT
        CASE 2 : FileList.FSize = K&
        CASE 3
             FileList.FDesc = K$
             CALL BitClear(FileList.Attr,7)
             CALL BitClear(FileList.Attr,6)
             CALL GetDesc(-2,Null$,Null$)        'Insert .GIF specs (if GIF).
        CASE 4 : FileList.UserName = AnyUser.UserName
        CASE 5
             IF ASC(K$) = 63 THEN TT = 20002 : _
                                  CALL SendTT : _
                                  K0 = K0 - 1 _
                             ELSE FileList.LDCount = K&
        CASE 6
             SELECT CASE ASC(K$)
               CASE 63
                    FOR K2 = 1 TO p
                      TT$ = o$(24) + STR$(K2) + o$(25) + _
                            FileAreaInfo3$(K2,4) + C1310$
                      CALL SendTT
                    NEXT
                    K0 = K0 - 1
               CASE ELSE
                    K2 = 0
                    IF K& <= p AND K& > 0 THEN K2 = -1
                    SELECT CASE K2
                      CASE -1
                           K0$ = FileAreaInfo3$(FileList.FArea,2) + _
                                 FileList.FName
                           ka = K&
                           K1$ = FileAreaInfo3$(ka,2) + FileList.FName
                           K2 = FindF2(K0$,FFile)
                           K3 = FindF2(K1$,FFile)
                           TT$ = o$(27 + (K2 = 0)) + _
                                 FileAreaInfo3$(FileList.FArea,4) + _
                                 o$(30) + o$(29 + (K3 = 0)) + _
                                 FileAreaInfo3$(ka,4) + o$(30)
                           CALL SendTT
                           SELECT CASE K2
                             CASE 0 : IF K3 = 0 THEN TT = 20031 _
                                                ELSE TT = 20032 : _
                                                     FileList.FArea = K&
                             CASE ELSE
                                  IF NOT (DriveSpc&(K1$) > FileIDX.FSize _
                                     OR AscNull(K0$) = AscNull(K1$)) _
                                     THEN K2 = 0 : _
                                          TT = 20033
                           END SELECT
                           SELECT CASE K2
                             CASE IS <> 0
                                  CALL CopyFile(1,K0$,K1$)
                                  CALL IncreaseHiFilePtr
                                  FileList.HiFilePtr = Settings.HiFilePtr
                                  FileList.FArea = K&
                                  IF FileAreaI(FileList.FArea).HiFilePtr < FileList.HiFilePtr _
                                     THEN CALL UpdateHiFilePtr(FileList.FArea,FileList.HiFilePtr)
                                  TT = 20034
                           END SELECT
                           CALL SendTT
                    END SELECT
             END SELECT
        CASE 7 : FileList.Group = K&
        CASE 8 : IF ASC(K$) = 32 _
                    THEN FileList.Password = 0 _
                    ELSE FileList.Password = StrCkSum(LEFT$(K$,30))
        CASE 9 : FileList.HiFilePtr = K&
        CASE 10 : FileList.Downloaded = K&
        CASE 11 : FileList.DateULed = DateToInt(K$)
        CASE 12 : FileList.LastDLed = DateToInt(K$)
        CASE 13
             SELECT CASE ASC(K$)
               CASE 63
                    FOR K2 = 20035 TO 20041
                      TT = K2
                      CALL SendTT
                    NEXT
                    K0 = K0 - 1
               CASE ELSE
                    FileList.Attr = AttrToInt(K$)
                    IF K6 AND NOT BitTest(FileList.Attr,3) _
                       THEN TT$ = o$(42) : _
                            IF GetYNTT THEN CALL GiveCredit(Null$,2)
                    IF BitTest(FileList.Attr,1) _
                       THEN CALL RemoveFile(FileList.FName) : _
                            K5 = 0
             END SELECT
      END SELECT
    NEXT
    IF K7 AND K5 THEN K4 = FileOpenW(FileNames(4)) : _
                      KK = FileOpenW(FileNames(59)) : _
                      K = BiSearch(3,KK,FileList.FName) : _
                      FileIDX.Attr = FileList.Attr : _
                      FileIDX.FSize = FileList.FSize : _
                      CALL FilePutRec(K4,FileIDX.FRec,119,FileList) : _
                      CALL FilePutRec(KK,K,22,FileIDX) : _
                      CALL FileCloseW(K4) : _
                      CALL FileCloseW(KK)
  LOOP UNTIL NoCarrier

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will import file descriptions from text files.
        '
        ' p  number of directories.
        '
        ' Date last checked for perfection: Sep 15 1992
        '
SUB DescImport (p)

  '
  ' Get the text file's pathname.
  '
  CALL BlockToO(3,12)
  TT$ = Null$
  FOR K = 1 TO 19
    TT$ = TT$ + o$(K)
  NEXT
  IF NOT ConfirmFile(K0$) THEN EXIT SUB
  TT = 20020
  Kz = Val2&(LineEditTT$(3))
  IF kz = 0 THEN EXIT SUB
  Kn = FileOpenW(FileNames(10))   'For wildcards, build list of files.
  K0 = FindF2(K0$,FFile)
  kz2 = 0
  DO
    CALL FilePutSEnd(Kn,LEFT$(K0$,StrSrchR(K0$,92)) + FFile.FName + C1310$)
    kz2 = kz2 + 1
  LOOP UNTIL FindF2(Null$,FFile) = 0
  K0& = 0
  DO
    '
    ' Get the file area to put the descriptions.
    '
    kz2 = kz2 - 1
    CALL DispCRLF
    CALL DispCRLF
    K0$ = FileGetLine$(Kn,K0&)
    z$ = RTRIM$(MID$(K0$,StrSrchR(K0$,92) + 1))
    TT$ = o$(23) + z$ + o$(24)
    zz$ = Null$
    FOR K = 1 TO p
      zz$ = zz$ + FileAreaInfo3$(K,4) + C0$
    NEXT
    CALL MenuSystem(zz$,0)
    IF TGot = 0 THEN EXIT DO
    '
    ' Actually import descriptions.
    '
    FileIndex = TGot
    CALL DispCRLF
    CALL DispCRLF
    K3 = FileOpenR(K0$)
    K& = 0
    K2 = FileOpenW(FileNames(4))
    DO
      K$ = LTRIM$(FileGetLine$(K3,K&))
      SELECT CASE LEN(K$)
        CASE IS > 0
             '
             ' Get and prep the file name.
             '
             K0$ = UCASE$(LEFT$(K$,12))
             K = StrSrch1(K0$,46)                           'Looking for a '.'.
             K0 = StrSrch1(K0$,32)                          'Looking for a space.
             IF K = 0 THEN K = K0
             IF K = 0 THEN K = 1
             MID$(K0$,K,1) = o$(25)                         'Give it a '.'.
             CALL ReplaceCharacters(K0$,-3,Null$,32)
             IF AscRight(K0$) = 46 THEN K0$ = ChopRight1$(K0$)
             FFile.FName = K0$
             '
             ' If file already exists, then just update it, else make a new entry.
             '
             K = BiSearch(3,0,FFile.FName)
             SELECT CASE K
               CASE 0
                    FFile.FSize = 0
                    CALL CreateFileStuff(1,0,10,0,0)
                    FileList.FDesc = LTRIM$(MID$(K$,kz))
                    CALL CreateFileStuff(2,0,0,K2,0)
                    CALL FilePutRec(K2,FileLof&(K2,119) + 1,119,FileList)
               CASE ELSE
                    CALL FileGetRec(K2,FileIDX.FRec,119,FileList)
                    FileList.FDesc = LTRIM$(MID$(K$,kz))
                    CALL BitClear(FileList.Attr,7)
                    CALL BitClear(FileIDX.Attr,7)
                    CALL FilePutRec(K2,FileIDX.FRec,119,FileList)
             END SELECT
             TT$ = o$(27 + (K = 0)) + FileList.FName + o$(28) + _
                   FileList.FDesc + C1310$
             CALL SendTT
             IF TGot > 0 THEN EXIT DO
      END SELECT
    LOOP UNTIL K& = -1
    CALL FileCloseR(K3)
    CALL FileCloseW(K2)
    TT = 20022 + (K& = -1)
    CALL SendTT
  LOOP UNTIL K0& = -1 OR TGot > 0  OR kz2 = 0
  CALL FileCloseW(kn)
  CALL KillFile(FileNames(10))
  CALL Paused

END SUB
        '
        '* * * *



SUB ValidateFiles

  DO
    TT = 10283
    CALL SendTT
    K1 = -1
    TT = 10937
    CALL SendTT
    CALL GetFileName(17,K$,K2,Null$)
    IF LEN(K$) = 0 OR NoCarrier THEN TT = 10283 : _
                                     CALL SendTT : _
                                     EXIT DO
    K3 = FileOpenW(FileNames(4))
    K = BiSearch(3,0,Form$(1201,K$))
    SELECT CASE K
      CASE IS > 0
           CALL FileGetRec(K3,FileIDX.FRec,119,FileList)
           IF BitTest(FileList.Attr,3) _
              THEN CALL GiveCredit(Null$,2) : _
                   CALL BitClear(FileList.Attr,3) : _
                   FileIDX.Attr = FileList.Attr : _
                   CALL FilePutRec(K3,FileIDX.FRec,119,FileList) : _
                   KK = FileOpenW(FileNames(59)) : _
                   CALL FilePutRec(KK,K,22,FileIDX) : _
                   CALL FileCloseW(KK) _
              ELSE TT = 10939 : _
                   CALL SendTT
    END SELECT
    CALL FileCloseW(K3)
  LOOP UNTIL NoCarrier

END SUB




        '* * * * * *
        ' This routine removes a file and penalizes the uploader.
        '
        ' Uploads are reduced by one.
        '
        ' Minute-credits are reduced by the amount normally given for
        ' the file size (which is based on 2400 baud transfer).  They
        ' lose twice if they forgot to leave a description, since they
        ' were never given minute-credits.
        '
        ' Bytes-off are based on a multiplier.
        '
        ' Date last checked for perfection: Sep 15 1992
        '
SUB Penalize

  CALL BlockToO(3,30)
  DO
    TT = 20001
    CALL SendTT
    DO
      CALL GetFileName(16,K$,K,Null$)
      kz = LEN(K$)
      IF kz = 0 OR NoCarrier OR K < 1 THEN kz = -1 : _
                                           EXIT DO
      CALL TGet(C13$ + C8$)
      IF TGot = 8 THEN CALL Wipe(LEN(K$)) : _
                       Kz = 0
    LOOP UNTIL kz <> 0
    IF kz < 0  THEN EXIT DO
    K0 = FileOpenR(FileNames(4))
    K = BiSearch(3,0,Form$(1201,K$))
    CALL FileGetRec(K0,FileIDX.FRec,119,FileList)
    CALL FileCloseR(K0)
    TT$ = o$(2) + FileList.UserName
    CALL SendTT
    IF LEN(RTRIM$(FileList.UserName)) = 0 OR NOT ReadStuff(2,FileList.UserName) _
       THEN TT = 20002 : _
            CALL SendTT : _
            EXIT DO
    K0 = ReadStuff(2,FileList.UserName)
    TT$ = o$(4) + AnyUser.UserName + o$(5) + STR$(AnyUser.Uplds) + _
          o$(6) + STR$(AnyUser.ULBytes) + o$(7)
    CALL SendTT
    AnyUser.Uplds = AnyUser.Uplds + (AnyUser.Uplds > 0)
    AnyUser.ULBytes = AnyUser.ULBytes - (FileIDX.FSize \ 100) * Settings.TakeOffBytes
    AnyUser.MinCredits = AnyUser.MinCredits - ((FileIDX.FSize \ 100) * Settings.TakeOffMins) \ 27600&
    AnyUser.BadULs = AnyUser.BadULs - (AnyUser.BadULs < 32767)
    K0 = WriteStuff(2)
    SELECT CASE BitTest(AnyUser.Attr,11)
      CASE -1
           TT = 20008
           CALL SendTT
      CASE ELSE
           SELECT CASE BitTest(Settings.Toggles3,6)
             CASE -1
                  TT = 20009
                  K$ = LineEditTT$(79)
                  CALL DispCRLF
                  CALL DispCRLF
                  K2$ = o$(10) + RTRIM$(FileList.FName) + o$(11) + _
                        Commas$(FileIDX.FSize) + o$(12)
                  IF LEN(K$) > 0 THEN K2$ = K2$ + o$(13) + K$ + o$(14)
                  Message.MsgTo = AnyUser.UserName
                  CALL AddAMessage(2,K2$,0,0)
           END SELECT
    END SELECT
    TT = 20015
    CALL SendTT
    IF BitTest(Settings.LoggingAmount,9) _
       THEN TT$ = IntToDate3$(SumLog.DateOn) + C32$ + NCR$(AnyUser.UserName) + _
                  o$(16) + RTRIM$(FileList.FName) + Chars$(46) : _
            CALL LogTT
    CALL RemoveFile(FileList.FName)
    TT = 20017
    CALL SendTT
  LOOP UNTIL NoCarrier

END SUB
        '
        '* * * *



SUB KillErrorsLog

  CALL BlockToO(3,14)
  K = FindF(FileNames(29),FFile)
  CALL TTInsertStr2(o$(1),RTRIM$(FileNames(29)),Commas$(FFile.FSize))
  IF NOT GetYNTT THEN EXIT SUB
  CALL KillFile(FileNames(29))
  TT = 20002
  CALL SendTT

END SUB

SUB KillCallersLog

  CALL BlockToO(3,25)
  K = FindF(FileNames(25),FFile)
  CALL TTInsertStr2(o$(1),RTRIM$(FileNames(25)),Commas$(FFile.FSize))
  IF NOT GetYNTT THEN EXIT SUB
  CALL KillFile(FileNames(25))
  TT = 20002
  CALL SendTT

END SUB

SUB ListErrorsLog

  TT$ = ">"
  CALL SendTT
  K = FileOpenR(FileNames(29))
  K& = 0
  K0& = FileLof&(K,1)
  WHILE NOT NoCarrier AND K0& <> K& AND TGot < 1
    TT$ = "|~|+" + FileGetBlock$(K,K&,K0&)
    CALL SendTT
  WEND
  CALL FileCloseR(K)
  IF TGot < 1 THEN CALL Paused

END SUB
