' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.
'
'Various independent, mail or message area, related routines that users access:
'  ListMsgs
'  SelectMArea
'  SetAllLastReadsHigh
'  Chat
' These routines handle the Ramble system:
'   Ramblings
'   RambleReader
'   POLine
' These are internode routines:
'   WhosDoingWhat
'   InternodeChat
'   WhosHooked
'   SendToHooks
'   SendPvtNote
'
'
SUB OverLay9
END SUB




        '* * * * * *
        ' This routine will list the active messages in a message
        ' base.
        '
        ' MENUTEXT.DAT should be used as the SL gate stopping users
        ' from accessing message bases.
        '
        ' Date last checked for perfection: Sep 15 1992
        '
SUB ListMsgs

  IF BaseIndex = 32767 OR BaseIndex < 0 THEN EXIT SUB
  IF LongMid(UserMsgInfo$,BaseIndex * 4 + 1) < 0 _
     AND BitTest(MsgAreaI(BaseIndex + 1).SubType,4) _
     THEN EXIT SUB
  K0 = 1
  DO
    TT$ = Short$(181) + MsgAreaInfo3$(BaseIndex + 1,2) + Lines$(146)
    CALL SendTT
    k99 = FileOpenR(FileNames(2))
    K6 = FileOpenR(Form4$(10,BaseIndex + 1))
    K5 = FileLof&(K6,12)
    IF K0 = 1 THEN K = K5 _
              ELSE K = 1
    WHILE TGot < 1 AND K > 0 AND K <= K5
      CALL FileGetRec(K6,K,12,MsgIDX)
      CALL FileGetLoc(k99,MsgIDX.MsgLoc,136,Message)
      K$ = Short$(447 + (Message.MsgNum > LongMid(UserMsgInfo$,BaseIndex * 4 + 1))) + _
           Form$(601,STR$(Message.MsgNum))
      IF User.UserName = Message.MsgFrom THEN K$ = K$ + Short$(87) _
                                         ELSE K$ = K$ + Short$(66)
      K$ = K$ + Form$(2369,Message.MsgFrom)
      IF User.UserName = Message.MsgTo THEN K$ = K$ + Short$(87) _
                                       ELSE K$ = K$ + Short$(78)
      TT$ = Form$(2305,Message.MsgTo)
      IF RTRIM$(TT$) = Short$(402) THEN TT$ = Lines$(111)
      TT$ = K$ + TT$ + Short$(565) + _
            LEFT$(UnSq$(RTRIM$(Message.MsgSubject)),25) + C1310$
      CALL SendTT
      IF K0 = 1 THEN K = K - 1 _
                ELSE K = K + 1
    WEND
    CALL FileCloseR(K6)
    CALL FileCloseR(k99)
    K0 = - K0
  LOOP UNTIL TGot <> 45
  IF TGot < 1 THEN TT = 156 : _
                   CALL SendTT
  CALL Paused

END SUB
        '
        '* * * *



        '* * * * * *
        ' This routine allows one to select a message area from a
        ' menu of all the areas.
        '
        ' Date last checked for perfection: Nov 24 1992
        '
SUB SelectMArea

  TT = 1
  CALL SendTT
  K = BaseIndex
  BaseIndex = 32767
  CALL NextArea(2,BasesSize)
  IF BaseIndex = 32767 THEN EXIT SUB          'No accessible areas.
  K1 = BaseIndex
  BaseIndex = 32767
  K2 = 0
  K$ = Null$
  DO
    k3 = BaseIndex
    CALL NextArea(2,BasesSize)
    K2 = K2 + 1
    K$ = K$ + MsgAreaInfo3$(BaseIndex + 1,2) + C0$
    Work(K2) = BaseIndex
  LOOP UNTIL BaseIndex = K1 AND K3 <> 32767
  TT = 53
  CALL MenuSystem(K$,0)
  IF TGot < 1 THEN BaseIndex = K _
              ELSE BaseIndex = Work(TGot)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will set all new messages a user has unread
        ' (in, and only in, those message areas the user has toggled
        ' on and access to) to read.  Turning formerly new messages
        ' into not-new messages.
        '
        ' Date last checked for perfection: Sep 3 1992
        '
SUB SetAllLastReadsHigh

  TT = 192
  IF NOT GetYNTT THEN EXIT SUB
  K0 = -3
  FOR K = 0 TO BasesSize
    K0 = K0 + 4
    K& = MsgAreaI(K + 1).NextNumber - 1
    IF LongMid(UserMsgInfo$,K0) < 0 THEN K& = 0
    IF K& > 0 THEN MID$(UserMsgInfo$,K0,4) = MKL$(K&)
  NEXT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine handles the user requesting chat of the sysop
        ' (and then requesting again, and again, and ...)
        '
        ' Date last checked for perfection: Sep 2 1992 
        '
SUB Chat

  CALL BlockToO(0,46)
  IF NOT BitTest(Settings.Toggles1,4) THEN TT = 20001 : _
                                           CALL SendTT : _
                                           EXIT SUB
  IF StrSrch(1,GlobalStuff$(17),o$(2)) > 0 AND User.PagedSysop < 32767 _
     THEN User.PagedSysop = User.PagedSysop + 1 : _
          SumLog.PagedSysop = SumLog.PagedSysop + 1 : _
          TT = 20003 : _
          CALL SendTT : _
          EXIT SUB
  TT = 20004
  K$ = RTRIM$(LineEditTT$(30))
  IF LEN(K$) < 2 THEN EXIT SUB
  IF User.PagedSysop < 32767 THEN User.PagedSysop = User.PagedSysop + 1 : _
                                  SumLog.PagedSysop = SumLog.PagedSysop + 1
  K1 = -1
  TT = 20005
  K0$ = UCASE$(K$)
  CALL StrXLate(K0$,GlobalStuff$(14))
  K3 = WordsCnt(K0$)
  IF K3 < Settings.ChatWords THEN K1 = 20006
  FOR K = 1 TO K3
    IF InList(1,WordsGet$(K0$,K,0),Short$(3)) THEN K1 = 20007
  NEXT
  IF K1 > 0 THEN TT = K1
  CALL SendTT
  IF K1 = -1 THEN GlobalStuff$(17) = o$(2) + K$ + o$(8) : _
                  TT$ = STRING$(5,7) : _
                  CALL AnsiTT
  IF BitTest(Settings.LoggingAmount,8) THEN TT$ = o$(9) + K$ : _
                                            CALL LogTT
  IF BitTest(User.Attr,10) AND LEN(LTRIM$(RTRIM$(LEFT$(User.SysopNote,8)))) = 8 _
     THEN CALL SharedWriteEOF(0,0,RTRIM$(FileNames(39)) + o$(10) + _
                                  LEFT$(User.SysopNote,2),o$(11) + K$)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine handles the creation, addition, listing, and
        ' deletion, of file messages--files containing messages.
        '
        ' Date last checked for perfection: Sep 12 1992
        '
SUB Ramblings

  CALL BlockToO(0,39)
  K3 = FileOpenW(FileNames(43))
  DO
    K1 = -1
    DO
      TT = 20001
      CALL SendTT
      aa$ = o$(2)
      IF Levels(UserSL).SecLevel < Settings.RambleAddSL _
         OR FileLof&(K3,77) + 3 = Settings.MaxFilesInDir _
         THEN K0 = 3 _
         ELSE aa$ = aa$ + o$(3) : _
              K0 = 4
      FOR K = 1 TO FileLof&(K3,77)
        CALL FileGetRec(K3,K,77,Ramble)
        SELECT CASE Ramble.AccessSL
          CASE IS > Levels(UserSL).SecLevel
               K$ = o$(4) + STR$(Ramble.AccessSL)
          CASE ELSE
               IF K1 < 0 THEN K$ = Ramble.Title _
                         ELSE K$ = IntToStr$(Ramble.Count) + _
                                   o$(6 + (Ramble.Count > 1)) + _
                                   IntToDate3$(Ramble.LastDate)
               IF Ramble.HiFilePtr > User.HiFilePtr THEN K$ = o$(7) + K$
        END SELECT
        aa$ = aa$ + RTRIM$(K$) + C1$
      NEXT
      TT = 20008
      CALL MenuSystem(aa$,1)
      IF K0 = 3 AND TGot > 3 THEN TGot = TGot + 1
      IF TGot = 3 THEN K1 = - K1
    LOOP UNTIL TGot <> 3
    SELECT CASE TGot
      CASE 0 : EXIT DO
      CASE 1 : CALL DispTextBlock(0,8,Null$)
               CALL Paused
      CASE 2
           FOR K = 1 TO FileLof&(K3,77)
             CALL FileGetRec(K3,K,77,Ramble)
             IF Ramble.HiFilePtr > User.HiFilePtr _
                AND Ramble.AccessSL <= Levels(UserSL).SecLevel _
                THEN CALL RambleReader(K,K3,0)
           NEXT
      CASE 4
           IF SumLog.RamblesMade = Settings.MaxRambles _
              AND Settings.MaxRambles > 0 THEN TT = 20036 : _
                                               CALL SendTT : _
                                               Ramble.Title = Null$ _
                                          ELSE TT = 20009 : _
                                               Ramble.Title = LineEditTT$(34)
           SELECT CASE LEN(RTRIM$(Ramble.Title))
             CASE IS > 0
                  Ramble.RambleOp = User.UserName
                  CALL DispCRLF
                  CALL DispCRLF
                  FOR K = 1 TO 996
                    K$ = Form4$(3,K)
                    IF NOT FindF2(RTRIM$(FileNames(53)) + K$,FFile) _
                       THEN EXIT FOR
                  NEXT
                  IF K = 997 THEN K = 1
                  Ramble.Number = K$
                  TT = 20010
                  CALL SendTT
                  K2$ = Null$
                  CALL GetMessageText(0,K2$)
                  SELECT CASE LEN(K2$)
                    CASE 0 TO 4 : TT = 20011
                    CASE ELSE
                         K2 = FileOpenW(RTRIM$(FileNames(53)) + K$)
                         CALL IncreaseHiFilePtr
                         Ramble.HiFilePtr = Settings.HiFilePtr
                         K$ = o$(12) + IntToDate3$(SumLog.DateOn) + _
                              STR$(Settings.HiFilePtr) + C1310$ + o$(13) + _
                              NCR$(User.UserName) + o$(14) + C1310$ + o$(15) + _
                              C1310$ + o$(15) + C1310$
                         CALL FilePutSEnd(K2,K$)
                         K = 1
                         K0 = 0
                         DO : CALL POLine(K,78,o$(15),K0,K2,K2$)
                         LOOP UNTIL K < 0
                         K$ = o$(15) + C1310$ + o$(12) + _
                              IntToDate3$(SumLog.DateOn) + _
                              STR$(Settings.HiFilePtr) + C1310$
                         CALL FilePutSEnd(K2,K$)
                         TT = 20016
                         CALL GetNumPlusTT(Null$)
                         Ramble.AccessSL = Val2&(TGot$)
                         CALL DispCRLF
                         IF Ramble.AccessSL > Levels(UserSL).SecLevel _
                            THEN Ramble.AccessSL = Levels(UserSL).SecLevel
                         CALL FileCloseW(K2)
                         Ramble.LastDate = SumLog.DateOn
                         Ramble.Count = 1
                         CALL FilePutRec(K3,FileLof&(K3,77) + 1,77,Ramble)
                         TT = 20017
                         SumLog.RamblesMade = SumLog.RamblesMade + 1
                  END SELECT
                  CALL SendTT
           END SELECT
      CASE ELSE
           K1 = TGot - 4
           CALL DispCRLF
           CALL FileGetRec(K3,K1,77,Ramble)
           K6 = -1
           IF Levels(UserSL).SecLevel < Ramble.AccessSL THEN K6 = 0
           IF UserSL = LevelsSize THEN K6 = -1
           SELECT CASE K6
             CASE 0 : TGot$ = Null$
                      TGot = 0
             CASE ELSE
                  K$ = o$(18) + C13$
                  TT$ = o$(25)
                  IF UserSL = LevelsSize OR Ramble.RambleOp = User.UserName _
                     THEN TT$ = o$(19) + TT$ _
                     ELSE MID$(K$,3,1) = C13$
                  IF Ramble.HiFilePtr > User.HiFilePtr AND User.HiFilePtr <> 0 _
                     THEN TT$ = o$(21) + TT$ _
                     ELSE MID$(K$,4,1) = C13$
                  CALL SendTT
                  CALL TGet2(K$)
           END SELECT
           SELECT CASE TGot
             CASE 1
                  TT = 20027
                  CALL SendTT
                  K2 = FileOpenR(RTRIM$(FileNames(53)) + Ramble.Number)
                  K& = 0
                  DO
                    K$ = FileGetLine$(K2,K&)
                    IF AscNull(K$) = 49 _
                       THEN TT$ = o$(28) + MID$(K$,2) + C1310$ : _
                            CALL SendTT
                  LOOP UNTIL K& = -1 OR TGot > 0
                  CALL FileCloseR(K2)
                  CALL Paused
             CASE 2
                  TT = 20031
                  CALL SendTT
                  K2$ = Null$
                  CALL GetMessageText(0,K2$)
                  SELECT CASE LEN(K2$)
                    CASE 0 TO 4 : TT = 20032
                    CASE ELSE
                         K2 = FileOpenW(RTRIM$(FileNames(53)) + Ramble.Number)
                         K = 1
                         K0 = 0
                         DO : CALL POLine(K,78,o$(15),K0,K2,K2$)
                         LOOP UNTIL K < 0
                         CALL IncreaseHiFilePtr
                         K$ = o$(15) + C1310$ + o$(12) + _
                              IntToDate3$(SumLog.DateOn) + _
                              STR$(Settings.HiFilePtr) + C1310$
                         CALL FilePutSEnd(K2,K$)
                         Ramble.HiFilePtr = Settings.HiFilePtr
                         CALL FileCloseW(K2)
                         Ramble.LastDate = SumLog.DateOn
                         Ramble.Count = Ramble.Count + 1
                         CALL FilePutRec(K3,K1,77,Ramble)
                         TT = 20017
                         SumLog.RamblesAdded = SumLog.RamblesAdded + 1
                  END SELECT
                  CALL SendTT
             CASE 3
                  TT = 20029
                  CALL SendTT
                  K4 = FileOpenR(RTRIM$(FileNames(53)) + Ramble.Number)
                  K2 = FileOpenW(FileNames(41))
                  K& = 0
                  CALL FilePutSEnd(K2,o$(30) + RTRIM$(Ramble.Title) + C1310$)
                  DO
                    K$ = FileGetLine$(K4,K&)
                    CALL FilePutSEnd(K2,K$ + C1310$)
                  LOOP UNTIL K& = -1
                  CALL FilePutSEnd(K2,STRING$(79,124) + C1310$)
                  CALL FileCloseW(K2)
                  CALL FileCloseR(K4)
                  CALL KillFile(RTRIM$(FileNames(53)) + Ramble.Number)
                  CALL FileCloseW(K3)
                  CALL CutOut(0,FileNames(43),K1 * 77& - 76,77&)
                  K3 = FileOpenW(FileNames(43))
                  TT = 20017
                  CALL SendTT
             CASE 4
                  TT = 20026
                  CALL SendTT
                  CALL RambleReader(K1,K3,0)
             CASE 5
                  CALL TTInsertStr1(o$(24),IntToStr$(Ramble.Count))
                  CALL GetNumPlusTT(Null$)
                  K4 = Val2&(TGot$)
                  IF K4 > 0 AND K4 < Ramble.Count _
                     THEN CALL RambleReader(K1,K3,K4)
           END SELECT
    END SELECT
  LOOP UNTIL NoCarrier
  CALL FileCloseW(K3)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to Ramblings, reads all new entries
        ' in a Ramble file.
        '
        ' p   ramble number to read.
        '
        ' p0  ramble file handle.
        '
        ' p1  0 to read new ramble entries.
        '     n to read after skipping first n messages.
        '
        ' Date last checked for perfection: Sep 12 1992
        '
SUB RambleReader (p,p0,p1)

  CALL FileGetRec(p0,p,77,Ramble)
  TT$ = o$(33) + RTRIM$(Ramble.Title) + o$(34)
  CALL SendTT
  K0 = FileOpenR(RTRIM$(FileNames(53)) + Ramble.Number)
  K& = 0
  SELECT CASE p1
    CASE 0
         IF User.HiFilePtr <> 0 _
            THEN K& = FileLof&(K0,1) : _
                 DO : _
                   DO : K$ = FileGetLineR$(K0,K&) : _
                   LOOP UNTIL AscNull(K$) = 50 OR K& = -1 : _
                 LOOP UNTIL User.HiFilePtr > Val2&(K$) OR K& = -1 : _
                 IF User.HiFilePtr <= Val2&(K$) THEN K& = 0
    CASE ELSE
         DO
           DO : K$ = FileGetLine$(K0,K&)
           LOOP UNTIL AscNull(K$) = 50 OR K& = -1
           p1 = p1 - 1
         LOOP UNTIL p1 = -1 OR K& = -1
  END SELECT
  K$ = FileGetLine$(K0,K&)
  DO
    IF AscNull(K$) <> 50 THEN TT$ = o$(28) + MID$(K$,2) + C1310$ : _
                              CALL SendTT
    K$ = FileGetLine$(K0,K&)
  LOOP UNTIL K& = -1 OR TGot > 0
  CALL FileCloseR(K0)
  CALL Paused

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to Ramblings, displays a line of text
        ' from a ramble.  When it gets to the last line, it also
        ' displays the author.
        '
        ' p   line number to show.  Returns -1 if just did last
        '     line, otherwise it's incremented.
        '
        ' p0  line size.
        '
        ' p1  maintains the maximum line width.
        '
        ' p$  what leads the output line.
        '
        ' p2  file to tack it on to.
        '
        ' p0$ message body
        '
        ' Date last checked for perfection: Sep 12 1992
        '
SUB POLine (p,p0,p$,p1,p2,p0$)

  CALL FindMsgLine(p,p0,5,K0$,K5,K3,p0$)
  CALL IntMax(p1,StripLen(RTRIM$(K0$)))
  IF K5 > 0 THEN CALL FilePutSEnd(p2,p$ + K0$ + C1310$) : _
                 p = p + 1 : _
                 EXIT SUB
  p = -1
  K1$ = o$(35) + NCR$(User.UserName)
  K4 = p1 - StripLen(K1$)
  K5 = K4 - StripLen(K0$)
  IF K5 > 0 THEN K0$ = K0$ + SPACE$(K5) + K1$ _
            ELSE CALL FilePutSEnd(p2,p$ + K0$ + C1310$) : _
                 IF K4 > 0 THEN K0$ = SPACE$(K4) + K1$ _
                           ELSE K0$ = K1$
  CALL FilePutSEnd(p2,p$ + K0$ + C1310$)

END SUB
        '
        '* * * *





'p = 1 if calling from ICht
'    0 if menu command
SUB WhosDoingWhat (p)

  IF p = 0 THEN CALL BlockToO(0,49)
  K = FileOpenR(FileNames(7))
  K0 = FileLof&(K,1)
  K$ = SPACE$(K0)
  CALL FileGetSLoc(K,0&,K$)
  CALL FileCloseR(K)
  TT$ = o$(12 + (p = 0)) + o$(13)
  K = 1
  K1 = 0
  DO
    K1 = K1 + 1
    K0$ = MID$(K$,K,30)
    SELECT CASE LEN(RTRIM$(K0$))
      CASE 0 : K1$ = o$(14)
      CASE ELSE
           K2 = AscMid(K$,K + 30)
           IF K2 > 6 THEN K2 = 0
           CALL ParseNext(K2 + 1,o$(5),20,1,0,K1$)
    END SELECT
    TT$ = TT$ + o$(6) + IntToStr$(K1) + o$(7)
    CALL TTInsertStr3(Null$,Form$(2505,K0$),Form$(1805,MID$(K$,K + 30,18)),Form$(2801,K1$))
    K = K + 62
  LOOP UNTIL K >= K0
  TT$ = TT$ + o$(8)
  CALL SendTT
  IF p = 1 THEN TT = 20009 : _
                CALL SendTT

END SUB



SUB InternodeChat

  CALL WhatDoing(0)
  CALL BlockToO(0,49)
  K3$ = Null$
  FOR K = 1 TO WordsCnt(User.UserName)
    IF LEN(K3$) <= 2 THEN K3$ = K3$ + LEFT$(WordsGet$(User.UserName,K,0),1)
  NEXT
  K4$ = IntToStr$(Settings.Node) + C1310$
  K3$ = o$(19) + K3$ + o$(20) + STRING$(4 - LEN(K3$),46) + K4$
  TT = 20015
  CALL SendTT
  K3 = FindF(FileNames(7),FFile)
  K3 = FFile.FSize \ 62
  IF K3 > 20 THEN TT = 20025 : _
                  CALL SendTT _
             ELSE FOR K4 = 3 TO K3 : _
                    CALL DispCRLF : _
                  NEXT
  K = 0
  K0$ = Null$
  CALL WhosHooked(K,K0$,K5$)
  K$ = Null$
  CALL TTInsertStr2(o$(30),NCR$(User.UserName),IntToStr$(Settings.Node))
  CALL SendToHooks(K0$,K$,TT$,K3$)
  K$ = Null$
  K6$ = Null$
  CALL CursorOn
  DO
    SELECT CASE LEN(K$)
      CASE 0
           '
           ' User is not typing something, so check and display other nodes.
           '
           K0 = FindF(FileNames(12),FFile)
           IF K0 = 0 THEN FFile.FSize = 0
           SELECT CASE FFile.FSize
             CASE IS > 0
                  K0 = FileOpenW(FileNames(12))
                  K& = 0
                  DO
                    TT$ = o$(16) + FileGetLine$(K0,K&) + o$(17)
                    CALL SendTT
                  LOOP UNTIL K& = -1
                  CALL FilePutLoc(K0,0&,0,K1)
                  CALL FileCloseW(K0)
           END SELECT
    END SELECT
    K0 = -1
    K1 = 0
    IF CommPort = 0 THEN K1 = 2    'turn <esc><esc> off.
    K0 = CommIn(K1)
    SELECT CASE K0
      CASE 8, 127
           IF LEN(K$) > 0 THEN K$ = ChopRight1$(K$) : _
                               CALL Wipe(1)
      CASE 9, 11 TO 126, 128 TO 255    'CommIn doesn't return ASCII 10.
           IF K0 <> 13 THEN CALL Ansi2(Chars$(K0)) : _
                            K$ = K$ + Chars$(K0)
           SELECT CASE LEN(K$)
             CASE 72
                  K4 = StrSrchR(K$,32)
                  IF K4 = 0 THEN K6$ = K6$ + LEFT$(K$,71) + C32$ + K3$ : _
                                 K$ = RIGHT$(K$,1) _
                            ELSE K6$ = K6$ + Form1$(72,LEFT$(K$,K4 - 1)) + K3$ : _
                                 K$ = MID$(K$,K4 + 1)
                  CALL Wipe(LEN(K$))
                  CALL Ansi2(C1310$ + K$)
           END SELECT
           SELECT CASE K0
             CASE 13
                  SELECT CASE UCASE$(K$)
                    CASE o$(26) : EXIT DO
                    CASE o$(27) : CALL Wipe(1)
                                  CALL WhosDoingWhat(1)
                    CASE o$(28) : CALL Wipe(1)
                                  TT = 20021
                                  CALL SendTT
                    CASE ELSE
                         IF AscNull(K$) = 64 AND LEN(K$) < 4 _
                            THEN CALL SendPvtNote(1,K$,K0$,K4$) _
                            ELSE CALL WhosHooked(K,K0$,K5$) : _
                                 CALL SendToHooks(K0$,K$,K6$,K3$) : _
                                 CALL DispCRLF : _
                                 K6$ = Null$
                  END SELECT
                  K$ = Null$
           END SELECT
    END SELECT
  LOOP UNTIL NoCarrier
  CALL CursorOff
  CALL WhatDoing(0)
  CALL WhosHooked(K,K0$,K5$)
  K$ = Null$
  CALL TTInsertStr2(o$(29),NCR$(User.UserName),IntToStr$(Settings.Node))
  CALL SendToHooks(K0$,K$,TT$,K3$)
  CALL KillFile(FileNames(12))

END SUB

                                ' Watch for new people logging in.
'    and report them.
'p last FindF check of filenames(7)
'p$ returns with our list of hooked-in nodes.
'p0$ old p$
SUB WhosHooked (p,p$,p0$)

  IF p = 0 THEN p0$ = Null$
  K0 = FindF(FileNames(7),FFile)
  SELECT CASE K0
    CASE IS <> p
         K4 = FFile.FSize \ 62
         K = FileOpenR(FileNames(7))
         K1 = FileLof&(K,1)
         K1$ = SPACE$(K1)
         CALL FileGetSLoc(K,0&,K1$)
         CALL FileCloseR(K)
         K = 1
         p$ = Null$
         K2 = 1
         DO
           IF LEN(RTRIM$(MID$(K1$,K,30))) > 0 AND AscMid(K1$,K + 30) = 6 _
              AND K2 <> Settings.Node _
              THEN p$ = p$ + Chars$(K2)
           K = K + 62
           K2 = K2 + 1
         LOOP UNTIL K >= K1
         K5 = 1
         FOR K1 = 1 TO K4
           K2 = StrSrch1(p$,K1)
           K3 = StrSrch1(p0$,K1)
           IF K2 > 0 AND K3 = 0 _
              THEN CALL TTInsertStr3(o$(31),NCR$(MID$(K1$,K5,30)),IntToStr$(AscMid(p$,K1)),C1310$) : _
                   CALL SendTT
           IF K2 = 0 AND K3 > 0 _
              THEN CALL TTInsertStr3(o$(32),NCR$(MID$(K1$,K5,30)),IntToStr$(AscMid(p0$,K2)),C1310$) : _
                   CALL SendTT
           K5 = K5 + 62
         NEXT
         p = K0
         p0$ = p$
  END SELECT

END SUB


SUB SendToHooks (p$,p0$,p1$,p2$)

  FOR K0 = 1 TO LEN(p$)
    K1 = AscMid(p$,K0)
    SWAP Settings.Node,K1
    K1$ = NodeFix$(GlobalStuff$(23))
    Settings.Node = K1
    IF LEN(p0$) = 0 THEN p0$ = p1$ + C1310$ _
                    ELSE p0$ = p1$ + Form1$(72,p0$) + p2$
    K2 = FileOpenW(K1$)
    CALL FilePutSEnd(K2,p0$)
    CALL FileCloseW(K2)
  NEXT

END SUB


'convert this to a menu command as well.
'p = 1 for within chat
'    0 for menu cmd.
SUB SendPvtNote (p,p$,p0$,p1$)

  K3 = FindF(FileNames(7),FFile)
  K3 = FFile.FSize \ 62
  IF p = 0 THEN CALL BlockToO(0,49)
  o$(1) = Null$
  o$(2) = Null$
  o$(3) = Null$
  o$(4) = Null$
  K2 = Val2&(p$)
  IF p = 0 THEN TT = 20034 : _
                K2 = Val2&(LineEditTT$(4)) : _
                IF K2 = 0 OR K2 > K3 THEN EXIT SUB
  FOR K4 = 1 TO LEN(p0$)
    IF AscMid(p0$,K4) = K2 THEN K2 = - K2
  NEXT
  K2$ = Null$
  IF p = 1 THEN TT = 20018 _
           ELSE TT = 20033
  CALL SendTT
  SELECT CASE K2
    CASE -1 TO - K3
         K2 = - K2
         CALL BoxEdit(1,8,4,71,o$(23))
         FOR K4 = 1 TO 4
           o$(K4) = RTRIM$(o$(K4))
           IF LEN(o$(K4)) > 0 THEN K2$ = K2$ + Form1$(72,o$(K4)) + o$(24) + p1$
         NEXT
    CASE 1 TO K3
         CALL BoxEdit(3 + (p = 1) * 2,1,4,79,o$(23))
         FOR K4 = 1 TO 4
           o$(K4) = RTRIM$(o$(K4))
           IF LEN(o$(K4)) > 0 THEN K2$ = K2$ + o$(K4) + C1310$
         NEXT
         CALL TTInsertStr3(o$(22),NCR$(User.UserName),IntToStr$(Settings.Node),C1310$ + C1310$)
         K2$ = TT$ + K2$ + C1310$ + C1310$
  END SELECT
  IF p = 1 THEN TT = 20009 : _
                CALL SendTT : _
                CALL Wipe(LEN(p$)) : _
                CALL CursorOn
  IF LEN(K2$) = 0 THEN EXIT SUB
  SWAP Settings.Node,K2
  K1$ = NodeFix$(GlobalStuff$(23))
  Settings.Node = K2
  K2 = FileOpenW(K1$)
  CALL FilePutSEnd(K2,K2$)
  CALL FileCloseW(K2)

END SUB

