' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.
'
' Overlaid  routines from MainLoop module:
'  ReInit
'  StartUp
'  MainLoop2



        '* * * * * *
        ' This routine, internal to WFC, re-initializes the fossil and
        ' modem.
        '
        ' Date last checked for perfection: Sep 21 1992
        '
SUB ReInit (p)

  CommPort = Settings.CommPort
  IF CommPort = 0 THEN EXIT SUB
  CALL InitFossil(CommPort,Settings.ModemBaud)
  IF BitTest(Settings.Toggles2,15) THEN EXIT SUB
  K0$ = TIME$
  DO
    IF ElapsedTime(K0$,KK) = Settings.LogoTimeOut _
       THEN CommPort = 0 : _
            TT = 10993 : _
            CALL SendTT : _
            TT$ = Null$ : _
            CALL ShellDosTT(2)
    CALL PurgeComIO(CommPort)
    k = FosIntAX(CommPort,&H601)                  'Raise DTR.
    CALL Delay
    CALL CommOut(RTRIM$(Settings.ModemInit) + C1310$)     'ATZ
    DO : CALL GetModemLine(K$,1)
    LOOP UNTIL K$ = Short$(909) OR LEN(K$) = 0  'loop until OK or time-out
  LOOP UNTIL K$ = Short$(909)
  IF BitTest(Settings.Toggles2,7) _
     THEN CALL CommOut(Short$(144) + C1310$) : _
          DO : CALL GetModemLine(K$,1) : _
          LOOP UNTIL K$ = Short$(909) OR LEN(K$) = 0
  IF BitTest(Settings.Toggles2,12) _
     THEN CALL CommOut(Short$(161) + C1310$) : _
          DO : CALL GetModemLine(K$,1) : _
          LOOP UNTIL K$ = Short$(909) OR LEN(K$) = 0

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine handles the getting/accepting of the modem's
        ' CONNECT string.
        '
        ' Date last checked for perfection: Sep 19 1992
        '
SUB StartUp

  kk = CommPort
  IF ASC(GlobalStuff$(3)) = 1 THEN GlobalStuff$(3) = C0$ : _
                                   CommPort = 0
  '
  ' Retrieve the connect string from the modem.
  '
  IF BitTest(Settings.Toggles2,15) THEN CommPort = 0
  SELECT CASE CommPort
    CASE IS > 0
         K0 = FileOpenR(FileNames(74))
         K1 = FileLof&(K0,52) + 8
         K& = -52
         FOR K = 9 TO K1
           K& = K& + 52
           o$(K) = SPACE$(52)
           CALL FileGetSLoc(K0,K&,o$(K))
           Work(K) = IntMid(o$(K),31)
         NEXT
         CALL FileCloseR(K0)
         ConnectCPS = -1
         K1$ = Null$
         DO
           CALL GetModemLine(K1$,2)
           SELECT CASE LEN(K1$)
             CASE IS > 0
                  IF BitTest(Settings.Toggles2,7) _
                     THEN IF StrSrch(1,K1$,Short$(151)) > 0 _
                             THEN ConnectCPS = -2 : _
                                  EXIT DO
                  K2 = 0
                  ConnectCPS = -1
                  FOR K0 = 9 TO K1
                    K0$ = RTRIM$(LEFT$(o$(K0),30))
                    IF StrSrch(1,K1$,K0$) > 0 AND LEN(K0$) > K2 _
                       THEN K2 = LEN(K0$) : _
                            SumLog.BaudRate = o$(K0) : _
                            ConnectCPS = Work(K0)
                  NEXT
           END SELECT
           K2 = FosIntAX(CommPort,&H300)
           TT$ = o$(4 + BitTest(K2,5)) + o$(6 + BitTest(K2,6)) + _
                 o$(2 + BitTest(K2,7)) + o$(8 + BitTest(K2,8))
           CALL AnsiTT
           '
           ' 300 or bauds not in CONNECT strings database are just ignored
           ' until we time-out, or they hangup.
           '
         LOOP UNTIL LEN(K1$) = 0 OR NoCarrier OR ConnectCPS <> -1
         IF ConnectCPS = 2 THEN EXIT SUB
         CALL PurgeComIO(CommPort)
         IF ConnectCPS = -1 THEN CALL HangUp : _
                                 EXIT SUB
         IF BitTest(Settings.Toggles3,1) THEN TT = 10155 : _
                                              CALL SendTT
    CASE ELSE : SumLog.BaudRate = Short$(742)
                ConnectCPS = 11500
                CommPort = kk
  END SELECT
  '
  ' Set some 'safety' defaults.
  '
  K = ReadStuff(1,Null$)
  User.SecLevel = 0
  User.UserName = Null$
  User.Language = Null$
  UserSL = 1
  FileIndex = 1
  GlobalStuff$(21) = Null$

END SUB
        '
        '* * * *

'uses sumlog.baudrate for the baud string
SUB FESupt

  CommPort = Settings.CommPort
  CALL InitFossil(CommPort,Settings.ModemBaud)
  SELECT CASE CommPort
    CASE IS > 0
         K0 = FileOpenR(FileNames(74))
         K1 = FileLof&(K0,52) + 8
         K& = -52
         FOR K = 9 TO K1
           K& = K& + 52
           o$(K) = SPACE$(52)
           CALL FileGetSLoc(K0,K&,o$(K))
           Work(K) = IntMid(o$(K),31)
         NEXT
         CALL FileCloseR(K0)
         K2 = 0
         ConnectCPS = -1
         kx$ = SumLog.BaudRate
         FOR K0 = 9 TO K1
           K0$ = RTRIM$(LEFT$(o$(K0),30))
           IF StrSrch(1,kx$,K0$) > 0 AND LEN(K0$) > K2 _
              THEN K2 = LEN(K0$) : _
                   SumLog.BaudRate = o$(K0) : _
                   ConnectCPS = Work(K0)
         NEXT
         CALL PurgeComIO(CommPort)
         IF ConnectCPS = -1 THEN CALL HangUp : _
                                 EXIT SUB
         TT = 10155
         CALL SendTT
    CASE ELSE : SumLog.BaudRate = Short$(742)
                ConnectCPS = 11500
                CommPort = CommPort
  END SELECT
  '
  ' Set some 'safety' defaults.
  '
  K = ReadStuff(1,Null$)
  User.SecLevel = 0
  User.UserName = Null$
  User.Language = Null$
  UserSL = 1
  FileIndex = 1
  GlobalStuff$(21) = Null$


END SUB





        '* * * * * *
        ' This routine displays various parts of the WFC screen.
        '
        ' p   which of the screens to put up.
        ' p0  current help page being displayed.  Or which to do.
        ' p1    0 to n  display log page p1+1
        '           -1  ask for date for stats
        '     -2 to -n  display stats for p1-2 days ago
        '
        ' Date last checked for perfection: Jun 26 1993
        '
SUB MainLoop2 (p,p0,p1)

  SELECT CASE p
    CASE 1
         IF p0 = 0 THEN p0 = 1
         SELECT CASE p0
           CASE 1
                '
                ' Display the drive space.
                '
                CALL DispDriveSpace
           CASE ELSE
                TT$ = o$(10) + Form$(1002,Commas$(FRE(-1))) + o$(11) + _
                      Form$(702,Commas$(FRE(C0$))) + o$(12) + _
                      Form$(802,Commas$(FRE(-2))) + o$(13)
                CALL AnsiTT
         END SELECT
    CASE 2
         SELECT CASE p0
           CASE IS < 1, 32767
                '
                ' Display the for-sysop info and <ctrl>Fx key definitions.
                '
                TT$ = Null$
                FOR K = 1 TO 6
                  TT$ = TT$ + AnsiLocStr$(K,19) + o$(20)
                NEXT
                CALL AnsiTT
                IF NOT ReadStuff(1,Settings.Sysop) THEN EXIT SUB
                IF NOT ReadStuff(4,Settings.Sysop) THEN EXIT SUB
                K = BasesSize * 4 + 4 + 1
                K0 = 0
                FOR K1 = 0 to BasesSize
                  K0 = K0 + AscMid(UserMsgInfo$,K + K1)
                NEXT
                K = FileOpenR(FileNames(4))
                K& = FileLof&(K,1) - 6
                K0& = Settings.HiFilePtr
                K1 = -1
                WHILE K& > 0 AND K0& > User.HiFilePtr
                  CALL FileGetLoc(K,K& - 111,4,K0&)
                  K1 = K1 + 1
                  K& = K& - 119
                WEND
                CALL FileCloseR(K)
                IF K1 = -1 THEN K1 = 0
                K2 = 0
                K3 = FindF2(Paths$(7) + Short$(956),FFile)
                WHILE K3
                  K2 = K2 + 1
                  K3 = FindF2(Null$,FFile)
                WEND
                TT$ = o$(15) + Form4$(9,K0) + o$(17) + Form4$(9,K1) + o$(18) + _
                      Form4$(9,K2) + o$(19)
                FOR K = 0 TO 9
                  TT$ = TT$ + MID$(o$(16),K * 7 + 1,7) + _
                        Form$(401,Short$(851 + K))
                NEXT
                CALL AnsiTT
           CASE ELSE
                '
                ' Display the help pages.
                '
                k = FileOpenR(FileNames(115))
                IF Settings.WFCHelpBlk = 0 _
                   THEN k& = 0 _
                   ELSE k& = Blocks&(2,Settings.WFCHelpBlk)
                k0 = 0
                k0$ = Null$
                DO
                  k0 = k0 + 1
                  K0$ = K0$ + MKL$(k&)
                  FOR k1 = 1 TO 6
                    k$ = FileGetLine$(k,k&)
                  NEXT
                  k0& = k&
                  k$ = FileGetLine$(k,k0&)
                LOOP UNTIL k& = -1 OR Val3(k$,1) <> Settings.WFCHelpBlk
                IF p0 = 32766 THEN p0 = k0
                IF p0 > k0 THEN p0 = 1
                k& = LongMid(K0$,(p0 - 1) * 4 + 1)
                TT$ = Null$
                FOR k1 = 1 TO 6
                  k$ = FileGetLine$(k,k&)
                  TT$ = TT$ + AnsiLocStr$(k1,19)
                  IF k& = -1 OR Val3(k$,1) <> Settings.WFCHelpBlk OR LEN(k$) = 2 _
                     THEN TT$ = TT$ + o$(20) _
                     ELSE TT$ = TT$ + MID$(k$,3)
                NEXT
                CALL FileCloseR(k)
                CALL AnsiTT
         END SELECT
    CASE 3
         SELECT CASE p1
           CASE IS < 0
                CALL SystemStatsForADay(p1)
                IF p1 = -1 THEN p1 = -2
           CASE ELSE
                '
                ' Display the callers log.
                '
                K4 = FileOpenR(FileNames(25))
                K& = FileLof&(K4,1)
                SELECT CASE K&
                  CASE IS > 1
                       TT = 20021
                       CALL AnsiTT
                       FOR K2 = 13 TO p1 * 10 + 12
                         K1$ = FileGetLineR$(K4,K&)
                       NEXT
                       K2$ = RTRIM$(Settings.LogLeader)
                       FOR K2 = 13 TO 23
                         K3$ = Form$(7801,StripANSI$(FileGetLineR$(K4,K&))) + _
                               o$(22)
                         TT$ = o$(24 + (LEFT$(K3$,LEN(K2$)) = K2$)) + K3$
                         CALL AnsiTT
                       NEXT
                END SELECT
                CALL FileCloseR(K4)
         END SELECT
  END SELECT

END SUB
        '
        '* * * *



        '* * * * * *
        ' This routine, internal to MainLoop2, displays the total
        ' logged stats for a day.
        '
        'p  Day's ago in which to show stats for.
        '   if p = -1 then ask for a date and set p appropriately.
        '   -2 = today
        '   -3 = 1 day ago
        '
        ' Date last checked for perfection: Jun 26 1993
        '
SUB SystemStatsForADay (p)

  K = FileOpenR(FileNames(26))
  K& = FileLof&(K,1) - 146
  IF K& < 0 THEN CALL FileCloseR(K) : _
                 EXIT SUB
  K0 = CommPort
  CommPort = 0
  IF p <> -1 THEN CALL DispFile(Paths$(11) + Short$(111),Null$) _
             ELSE TT = 20025 : _
                  K$ = LineEditTT$(3) : _
                  IF LEN(K$) = 0 THEN p = -2 _
                                 ELSE p = (- Val2&(K$)) - 2
  CommPort = K0
  CALL FileGetLoc(K,K& + 88,2,K0)
  K1 = -2
  DO
    CALL FileGetLoc(K,K& + 88,2,K2)
    K& = K& - 146
    IF K2 <> K0 THEN K1 = K1 - 1 : _
                     K0 = K2
  LOOP UNTIL K& < 0 OR K1 = p
  IF K1 <> p THEN K& = 0 : _
                  p = -2 _
             ELSE K& = K& + 146
  FOR K1 = 1 TO 30
    Work(K1) = 0
  NEXT
  K1& = 0
  K2& = 0
  DO
    IF BitTest(FosIntAX(CommPort,&H300),7) THEN EXIT DO  'RING detected.
    CALL FileGetLoc(K,K&,146,SumRec)
    K& = K& - 146
    IF SumRec.DateOn <> K0 THEN EXIT DO
    Work(1) = Work(1) + 1                        'Number of calls.
    Work(2) = Work(2) + SumRec.TotalMinsUsed     'Mins used.
    Work(3) = Work(3) + SumRec.PagedSysop        'Sysop pages.
    Work(4) = Work(4) + SumRec.MsgsPosted        'Public messages posted.
    Work(5) = Work(5) + SumRec.MsgsRcvd          'Public messages received.
    Work(6) = Work(6) + SumRec.EMsgsPosted       'Private messages posted.
    Work(7) = Work(7) + SumRec.EMsgsRcvd         'Private messages received.
    Work(8) = Work(8) + SumRec.FMsgsPosted       'Feedback messages posted.
    Work(9) = Work(9) + SumRec.NetMailSent       'NetMail messages posted.
    Work(10) = Work(10) + SumRec.NetMailRcvd     'NetMail messages received.
    Work(11) = Work(11) + SumRec.Dnlds           'Files downloaded.
    K1& = K1& + SumRec.DLBytes                   'Bytes downloaded.
    Work(12) = Work(12) + SumRec.MinsDLing       'Minutes downloading.
    Work(13) = Work(13) + SumRec.BadDLs          'Number of bad DL's.
    Work(14) = Work(14) + SumRec.Uplds           'Files uploaded.
    K2& = K2& + SumRec.ULBytes                   'Bytes uploaded.
    Work(15) = Work(15) + SumRec.MinsULing       'Minutes uploading.
    Work(16) = Work(16) + SumRec.BadULs          'Number of bad UL's.
    Work(17) = Work(17) + SumRec.Doors           'Number of accesses to doors.
    Work(18) = Work(18) + SumRec.RamblesMade     'Created rambles.
    Work(19) = Work(19) + SumRec.RamblesAdded    'Ramble messages posted.
    Work(20) = Work(20) + SumRec.MsgsDownloaded  'Messages downloaded.
    Work(21) = Work(21) + SumRec.MsgsReadOnLine  'Messages Read on-line.
    Work(22) = Work(22) + SumRec.MsgsUploaded    'Messages uploaded.
  LOOP UNTIL K& < 0
  CALL FileCloseR(K)
  TT$ = o$(28) + Form$(1101,Commas$(K1&)) + o$(29) + Form$(1101,Commas$(K2&))
  FOR K = 1 TO 22
    TT$ = TT$ + MID$(o$(26),K * 8 - 7,8) + Form$(501,IntToStr$(Work(K)))
  NEXT
  TT$ = TT$ + o$(30) + IntToDate3$(K0) + o$(31) + Form3$((- p) - 2) + o$(32)
  CALL AnsiTT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to WFC, handles management of the
        ' limited-callers Hot List.
        '
        ' Date last checked for perfection: Jun 26 1993
        '
SUB HotListBuild

  K = CommPort
  CommPort = 0
  DO
    K1 = LEN(GlobalStuff$(11))
    TT$ = o$(33)
    SELECT CASE K1
      CASE 0 : TT$ = TT$ + o$(34)
      CASE ELSE
           K0 = 1
           DO
             TT$ = TT$ + NCR$(MID$(GlobalStuff$(11),K0,30)) + C1310$
             K0 = K0 + 31
           LOOP UNTIL K0 >= K1
    END SELECT
    TT$ = TT$ + o$(36)
    IF K1 > 0 THEN TT$ = TT$ + o$(37) : _
                   K0 = 38 _
              ELSE K0 = 35
    TT$ = TT$ + o$(39)
    CALL SendTT
    CALL TGet(o$(K0) + C13$)
    K0 = TGot
    SELECT CASE K0
      CASE 65
           TT = 20040
           CALL SendTT
           DO
             TT = 20041
             K$ = LineEditTT$(30)
             K1 = LEN(K$)
             IF K1 > 0 THEN TT$ = o$(42) : _
                            GlobalStuff$(11) = GlobalStuff$(11) + _
                                               UCASE$(Form$(3001,K$)) + _
                                               Chars$(1 + GetYNTT)
             CALL DispCRLF
           LOOP UNTIL K1 = 0
      CASE 82
           TT = 20043
           CALL SendTT
           DO
             TT = 20044
             K$ = LineEditTT$(30)
             K1 = LEN(K$)
             IF K1 > 0 _
                THEN K2 = StrSrch(1,GlobalStuff$(11),UCASE$(Form$(3001,K$))) : _
                     IF K2 = 0 _
                        THEN TT = 20045 : _
                             CALL SendTT _
                        ELSE GlobalStuff$(11) = LEFT$(GlobalStuff$(11),K2 - 1) + _
                                                MID$(GlobalStuff$(11),K2 + 31)
             CALL DispCRLF
           LOOP UNTIL K1 = 0 OR LEN(GlobalStuff$(11)) = 0
      CASE 67
           TT = 20046
           CALL SendTT
           GlobalStuff$(11) = Null$
    END SELECT
  LOOP UNTIL K0 = -1
  IF LEN(GlobalStuff$(11)) = 0 THEN CommPort = K : _
                                    EXIT SUB
  TT$ = o$(47) + SPACE$(78) + o$(48) + GlobalStuff$(12) + o$(49)
  K$ = LineEditTT$(78)
  IF LEN(K$) > 0 THEN GlobalStuff$(12) = K$ : _
                      TT$ = SPACE$(78 - LEN(K$)) : _
                      CALL SendTT
  TT = 20050
  K$ = LineEditTT$(9)
  IF LEN(K$) = 8 THEN GlobalStuff$(13) = K$
  CommPort = K

END SUB
        '
        '* * * *


