' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.
'
' Included in this package:
'   Initializer2
'   DirectryStart
'   BuildNetIndex



        '* * * * * *
        ' This routine is the second half the system startup.
        '
        ' p number of directories
        '
        ' These are initialization routines to not call if starting
        ' from a door.  'Fluff' routines to check the files/etc.
        '
        ' Date last checked for perfection: Mar 10 1993
        '
SUB Initializer2 (p)

  CALL BlockToO(3,8)
  TT$ = o$(1) + IntToStr$(1 * 5 + 3) + o$(2) + STR$(FRE(C0$)) + _
        STR$(FRE(-2)) + STR$(FRE(-1)) + o$(3)
  CALL SendTT
  '
  ' Create the user file if needed.  Build the user index if it is not there.
  '
  IF NOT FindF2(FileNames(1),FFile) THEN CALL InitNewUser
  K = FindF(FileNames(56),FFile)
  IF FFile.FSize < 31 THEN K = 0
  SELECT CASE K
    CASE 0
         K2 = FileOpenR(FileNames(1))
         K& = FileLof&(K2,1)
         CALL ShowMeter(- K&)
         KK = FileOpenWDA(FileNames(56))
         K0& = -295
         K4 = 0
         FOR K = 1 TO FileLof&(K2,384)
           K0& = K0& + 384
           CALL FileGetLoc(K2,K0&,2,K33)
           SELECT CASE BitTest(K33,1)
             CASE 0
                  CALL FileGetRec(K2,K,384,AnyUser)
                  K1 = ASC(AnyUser.UserName)
                  CALL ShowMeter(K0&)
                  IF K1 < 32 OR K1 > 90 _
                     THEN AnyUser.Attr = AnyUser.Attr + 1 : _
                          CALL FilePutRec(K2,K,384,AnyUser) _
                     ELSE UserIDX.UserName = AnyUser.UserName : _
                          UserIDX.RecNum = K : _
                          K4 = K4 + 1 : _
                          CALL FilePutRec(KK,K4,32,UserIDX)
           END SELECT
         NEXT
         CALL FileCloseR(K2)
         CALL FileSort2(KK,32,-1)
         CALL FileCloseW(KK)
  END SELECT
  KK = FindF(FileNames(56),FFile)
  K2 = FFile.FSize \ 32
  KK = FindF(FileNames(1),FFile)
  TT$ = o$(4) + STR$(FFile.FSize \ 384 - K2) + o$(5) + STR$(K2) + o$(6)
  CALL SendTT
  '
  ' Build messages index.
  '
  TT = 20007
  CALL SendTT
  KK& = 0
  FOR K = 0 TO BasesSize
    IF FindF(Form4$(10,K + 1),FFile) = 0 THEN CALL BuildMsgIDX(K) : _
                                              kk = FindF(Form4$(10,K + 1),FFile)
    KK& = KK& + FFile.FSize \ 12
  NEXT
  kk = FindF(FileNames(2),FFile)
  TT$ = LongToStr$(FFile.FSize \ 136 - KK&) + o$(8) + LongToStr$(KK&) + o$(9)
  CALL SendTT
  '
  ' Build files index.  Special processing is done for deleted or found files.
  '
  TT = 20010
  CALL SendTT
  K = FindF(FileNames(59),FFile)
  IF FFile.FSize < 21 THEN K = 0
  SELECT CASE K
    CASE 0
         '
         ' Build FILES.IDX.
         '
         K1 = 0
         K = FileOpenR(FileNames(4))
         K& = FileLof&(K,1)
         CALL ShowMeter(- K&)
         K0& = -4
         KK = FileOpenWDA(FileNames(59))
         FOR K0 = 1 TO K& \ 119
           K0& = K0& + 119
           CALL FileGetLoc(K,K0&,2,K3)
           SELECT CASE BitTest(K3,1)
             CASE 0
                  CALL FileGetRec(K,K0,119,FileList)
                  FileIDX.FName = UCASE$(FileList.FName)
                  FileIDX.FArea = FileList.FArea
                  IF FileIDX.FName <> FileList.FName _
                     THEN TT$ = C7$ + o$(38) : _
                          CALL SendTT : _
                          TT = 20039 : _
                          CALL ScreamErrorTT : _
                          FileIDX.FArea =  0   'no transient areas.
                  FileIDX.FSize = FileList.FSize
                  FileIDX.FRec = K0
                  FileIDX.Attr = K3
                  K1 = K1 + 1
                  CALL FilePutRec(KK,K1,22,FileIDX)
           END SELECT
           CALL ShowMeter(K0&)
         NEXT
         CALL FileCloseR(K)
         CALL FileSort2(KK,22,-2)
         CALL FileCloseW(KK)
  END SELECT
  IF BitTest(Settings.Toggles2,6) THEN CALL FileMatcher(p,0,0)
  KK = FindF(FileNames(59),FFile)
  K2 = FFile.FSize \ 22
  KK = FindF(FileNames(4),FFile)
  TT$ = o$(18) + STR$(FFile.FSize \ 119 - K2) + o$(19) + STR$(K2) + o$(20)
  CALL SendTT
  '
  ' Build the buffer file if needed.
  '
  K = FindF(FileNames(11),FFile)
  IF K = 0 OR FFile.FSize <> Settings.BufferSize * 4096 _
     THEN CALL KillFile(FileNames(11)) : _
          K$ = SPACE$(4096) : _
          FOR K = 1 TO Settings.BufferSize : _
            CALL SharedWriteEOF(11,-1,Null$,K$) : _
          NEXT
  '
  ' Build the Directry indexes if needed.
  '
  K = 0
  FOR K0 = 1 TO 99
    K$ = Form4$(2,K0)
    K1 = FindF(RTRIM$(FileNames(44)) + K$,FFile)      'DIRECTRY.Dxx
    IF K1 <> 0 _
       THEN IF K1 <> FindF(RTRIM$(FileNames(46)) + K$,FFile) _
               THEN IF K = 0 THEN TT = 20021 : _
                                  CALL SendTT : _
                                  K = 1 : _
                                  CALL DirectryStart(K$) _
                             ELSE CALL DirectryStart(K$)
  NEXT
  '
  ' Build the net address indexes if needed.
  '
  K = FileOpenW(FileNames(106))
  K$ = SPACE$(126)
  K& = -126
  zz = FindF2(FileNames(107),FFile)
  zz2 = 0
  KK = FileOpenWDA(FileNames(107))
  FOR K0 = 1 TO FileLof&(K,126)
    K& = K& + 126
    CALL FileGetSLoc(K,K&,K$)
    K0$ = RTRIM$(LEFT$(K$,64))
    K1 = FindF(K0$,FFile)
    IF (MKI$(K1) <> RIGHT$(K$,2) OR zz = 0) AND K1 <> 0 _
       THEN K0$ = ParseForPath$(K0$) + FFile.FName : _
            CALL BuildNetIndex(K,K0,K0$,KK) : _
            zz2 = -1
  NEXT
  CALL FileCloseW(K)
  IF zz2 THEN TT = 20037 : _
              CALL SendTT : _
              CALL FileSort2(KK,11,1)
 CALL FileCloseW(KK)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine builds/re-builds the index for a net mail
        ' nodelist file.
        '
        ' p   handle of the opened NODELIST.DAT file
        '
        ' p0  record working with in NODELIST.DAT
        '
        ' p$  pathname of the nodelist file
        '
        ' p1  handle of already-opened NODELIST.IDX
        '
        ' Date last checked for perfection: Dec 14 1992
        '
SUB BuildNetIndex (p,p0,p$,p1)

  TT$ = o$(22) + p$ + o$(23)
  CALL SendTT
  IF DriveSpc&(FileNames(107)) < 2& * FileLof&(p1,1) THEN TT = 20036 : _
                                                          CALL SendTT : _
                                                          EXIT SUB
  '
  ' Delete any old entries in there now.  Sneaky method; we 'don't-swap'
  ' the records to be deleted at the beginning, and then block-remove that
  ' beginning section.
  '
  K1 = 0
  K& = FileLof&(p1,11)
  CALL ShowMeter(- K&)
  K$ = Chars$(p0)
  FOR K2 = 1 TO K&
    CALL FileGetRec(p1,K2,11,NodeIndex)
    IF NodeIndex.NodeList = K$ _
       THEN K1 = K1 + 1 : _
            IF K1 < K2 THEN CALL FileGetRec(p1,K1,11,NodeIndex) : _
                            CALL FilePutRec(p1,K2,11,NodeIndex)
    CALL ShowMeter(1& * K2)
  NEXT
  CALL CutOut(p1,Null$,1&,K1 * 11&)
  K1 = FileLof&(p1,11)
  TT = 20024
  CALL SendTT
  '
  ' Append on all the new entries.
  '
  K$ = SPACE$(126)
  CALL FileGetSLoc(p,126& * p0 - 126,K$)
  K4 = FindF(p$,FFile)
  K = FileOpenR(p$)
  NodeIndex.NodeList = Chars$(p0)
  K5 = 1
  K6 = 1
  K& = FileLof&(K,1)
  CALL ShowMeter(- K&)
  K0& = 0
  DO
    K1& = K0&
    K0$ = FileGetLine$(K,K0&)
    IF LEN(K0$) < 15 OR AscNull(K0$) = 59 THEN K2 = 0 _
                                          ELSE K2 = 1
    SELECT CASE K2
      CASE IS > 0
           K2 = StrSrch1(K0$,44)
           K3 = StrSrch2(K2,K0$,44)
           '
           ' Process the node/net information.
           ' If Zone, then Zone = number, Net = number, Node = 0
           ' If Region or Host, then Net = number, Node = 0
           '
           K2 = Val2&(MID$(K0$,K2 + 1,K3 - K2 - 1))
           IF LEFT$(K0$,4) = o$(33) THEN K5 = K2 : _
                                         K6 = K2 : _
                                         K2 = 0
           IF LEFT$(K0$,6) = o$(34) OR LEFT$(K0$,4) = o$(35) THEN K6 = K2 : _
                                                                  K2 = 0
           NodeIndex.Location = K1&
           K1 = K1 + 1
           NodeIndex.Addr = IntToAddr$(K5,K6,K2)
           CALL FilePutRec(p1,K1,11,NodeIndex)
           CALL ShowMeter(K0&)
    END SELECT
  LOOP UNTIL K0& < 0
  CALL FileCloseR(K)
  CALL FilePutSLoc(p,126& * p0 - 126,LEFT$(K$,124) + MKI$(K4))
  TT = 20024
  CALL SendTT

END SUB
        '
        '* * * *



        '* * * * * *
        ' This routine, internal to Initialize, builds the index
        ' (DIRECTRY.Ixx) files for whatever DIRECTRY files exist.
        '
        ' p$  contains the 'xx' for the file names to use.
        '
        ' Even though it may actually add extra space, I usually end
        ' all the DIRECTRY.Dxx files with a '%%%' as well.
        '
        ' DIRECTRY.Dxx for the text, DIRECTRY.Txx for the menu
        ' selection titles.
        '
        ' The DIRECTRY.Dxx file structures are below.
        '
        ' The DIRECTRY.Txx structure:
        '   First line: SendTT line of text that makes up the heading.
        '   2nd line: Text of what question to ask.
        '   n lines: n lines of titles for each group of text in
        '            DIRECTRY.Dxx file.
        '
        ' For a lot of entries: using a max title width of 20 will get
        ' you 3 entries per line.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
SUB DirectryStart (p$)

  K3 = FileOpenR(RTRIM$(FileNames(44)) + p$)     'DIRECTRY.Dxx
  CALL KillFile(RTRIM$(FileNames(46)) + p$)      'DIRECTRY.Ixx
  K1 = FileOpenWDA(RTRIM$(FileNames(46)) + p$)
  K& = 0
'  K0$ = FileGetLine$(K3,K&)                     'Get the data type.
  k$ = FileGetLine$(K3,K&)                      'Past the header type.
  K0 = 0
  DO
    K0& = K&
    k$ = FileGetLine$(K3,K&)                    'Get the next line.
    K0 = K0 + 1
'    SELECT CASE LEFT$(K0$,4)
'      CASE o$(25)
'           '
'           ' LINE files consist of:  LINE
'           '                         HEADER/NOHEADER
'           '                         %%%
'           '                         text line 1
'           '                         text line 2
'           '                         text line 3
'           '                         . . .
'           '                         text line n
'           '
'           CALL FilePutRec(K1,K0,4,K&)         'Store start of line.
'      CASE o$(26)
           '
           ' BLOCK files consist of:  BLOCK
           '                          HEADER/NOHEADER
           '                          %%%
           '                          text line 1
           '                          . . .
           '                          text line n
           '                          %%%
           '                          text line 1
           '                          etc.
           '
           IF k$ = o$(27) THEN CALL FilePutRec(K1,K0,4,K&) _
                          ELSE K0 = K0 - 1      'Store start of block.
'      CASE o$(28)
'           '
'           ' LENGTH files consist of:  LENGTH
'           '                           HEADER/NOHEADER
'           '                           %%%
'           '                           size
'           '                           text of size bytes
'           '                           %%%
'           '                           size
'           '                           etc.
'           '
'           IF K& > 0 THEN k$ = FileGetLine$(K3,K&)   'Get length of the text.
'           CALL FilePutRec(K1,K0 * 2 - 1,4,K&)  'Store the start.
'           K0& = Val2&(k$)
'           IF K0& = 0 THEN K0& = 4096           'Off-block, so skip fast
'                                                'past the rest.
'           CALL FilePutRec(K1,K0 * 2,4,K0&)     'Store the length.
'           IF K& > 0 THEN K& = K& + K0&         'Jump over the text.
'      CASE ELSE
'           TT$ = o$(29) + RTRIM$(FileNames(44)) + p$ + o$(30)
'           CALL ScreamErrorTT
'           EXIT DO
'    END SELECT
  LOOP UNTIL K& = -1
  CALL SameDate(K3,K1)
  CALL FileCloseW(K1)
  CALL FileCloseR(K3)

END SUB
        '
        '* * * *



        '* * * * * *
        ' This routine re-initializes all the fields of the new user's
        ' base record.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
SUB InitNewUser

  K = FileOpenW(FileNames(1))
  AnyUser.UserName    = Short$(626)
  AnyUser.Password    = Null$
  AnyUser.CityState   = Null$
  AnyUser.HomePhone   = 0
  AnyUser.BBSPhone    = 0
  AnyUser.BirthDate   = 0
  AnyUser.SecLevel    = 5
  AnyUser.FirstCall   = 0
  AnyUser.Attr        = 0
  AnyUser.Toggles     = 2 + 16 + 32 + 2048 + 4096 + 8192
  CALL BitSet(AnyUser.Toggles,16)
  AnyUser.Protocol    = Chars$(90)
  AnyUser.Votes       = STRING$(100,0)
  AnyUser.SubsStart   = 0
'  AnyUser.SubsEnd     = 0
'  AnyUser.SubsType    = Chars$(48)
  AnyUser.Language    = Null$
'  AnyUser.Monies      = 0
'  AnyUser.TotalMonies = 0
AnyUser.ElapsedMins = 0
AnyUser.ElapsedMinsC = 0
  AnyUser.LastCallerNum = 0
  AnyUser.LastDateOn  = DateToInt(DATE$)
  AnyUser.PswdChange  = C0$
  AnyUser.AlterDate   = 0
  AnyUser.Toggles2    = 2
  AnyUser.PRStuff     = STRING$(8,0)
  AnyUser.Connect     = C0$
  AnyUser.HiFilePtr   = 0
  AnyUser.HighestPtr  = 0
  AnyUser.PagedSysop  = 0
  AnyUser.Logons      = 0
  AnyUser.Attempts    = C0$
  AnyUser.MinCredits  = 0
  AnyUser.MinMegs     = 0
  AnyUser.MsgsPosted  = 0
  AnyUser.EMsgsPosted = 0
  AnyUser.FMsgsPosted = 0
  AnyUser.NetMailSent = 0
  AnyUser.NetMailRcvd = 0
  AnyUser.Elapsed     = 0
  AnyUser.Dnlds       = 0
  AnyUser.DLBytes     = 0
  AnyUser.MinsDLing   = 0
  AnyUser.BadDLs      = 0
  AnyUser.Uplds       = 0
  AnyUser.ULBytes     = 0
  AnyUser.MinsULing   = 0
  AnyUser.BadULs      = 0
  AnyUser.Doors       = 0
  AnyUser.SubsEnd     = 0
  AnyUser.SysopNote   = Null$
  AnyUser.UserNote    = Null$
  CALL FilePutRec(K,1,384,AnyUser)
  K0 = FileOpenW(FileNames(3))
  CALL FileCloseW(K)
  K$ = STRING$(LEN(UserMsgInfo$),0)
  FOR K = 1 TO BasesSize
    IF BitTest(MsgAreaI(K + 1).SubType,4) THEN MID$(K$,K * 4 + 1,4) = MKL$(-1)
  NEXT
  CALL FilePutSLoc(K0,0&,K$)
  K = FileOpenW(FileNames(5))
  CALL FileCloseW(K0)
  CALL FilePutSLoc(K,0&,STRING$(99,0))
  CALL FileCloseW(K)

END SUB
        '
        '* * * *



        ' Note: This file matcher is about as optimized as it can get.
        '       It does n + n\6 disk reads only (n for the unbuffered
        '       FindF's, and n, but 128 byte buffered by DOS (so \6),
        '       .IDX file reads).
        '       We use the full 12 character filename in RAM.  Giving
        '       us a guarenteed minimum allowance of 1300 files per
        '       allowable character.  We do not reduce this to 10 by
        '       eliminating the first char and the period because the
        '       first char is needed for single letter filenames (rare)
        '       and the removal of the period adds a lot of extra work
        '       that really isn't needed (slows it down too).
'p = number of directories
SUB FileMatcher (p,killme1,killme2)

  K$ = SPACE$(64)
  K5$ = Null$
  K = FileOpenW(FileNames(20))
  FOR K0 = 1 to p
    CALL FileGetSLoc(K,K0 * 188& - 136,K$)
    K6$ = RTRIM$(K$)
    IF AscRight(K6$) <> 92 _
       THEN K6$ = K6$ + Chars$(92) : _
            CALL FilePutSLoc(K,K0 * 188& - 136,Form$(6401,K6$))
    K5$ = K5$ + K6$ + C32$
    IF LEN(K5$) > 8100 THEN K5$ = Null$ : _
                            EXIT FOR
  NEXT
  CALL FileCloseW(K)
  p1 = FileOpenWDA(FileNames(59))
  p0 = FileOpenW(FileNames(4))
  K5 = 0
  K0& = 0
  K$ = o$(17)
  K& = FileLof&(p1,1)   'Don't change, as we lengthen the file.
  CALL ShowMeter(- K&)
  FOR K = 1 TO LEN(o$(32))
    K2$ = SPACE$(1200)          'speed's things up.
    '
    ' Produce an unsorted list (K0$) of files on-line starting with (K).
    '
    K2 = 0
    K0$ = Null$
    FOR K0 = 1 TO p
      IF LEN(K5$) = 0 THEN K6$ = FileAreaInfo3$(K0,2) _
                      ELSE K6$ = WordsGet$(K5$,K0,0)
      SELECT CASE FindF2(K6$ + MID$(o$(32),K,1) + o$(31),FFile)
        CASE IS <> 0
             DO
               MID$(K2$,K2 + 1,12) = FFile.FName
               K2 = K2 + 12
               IF K2 = 1200 THEN K2 = 0 : _
                                 K0$ = K0$ + K2$
             LOOP UNTIL FindF2(Null$,FFile) = 0
      END SELECT
    NEXT
    K0$ = K0$ + LEFT$(K2$,K2)
    '
    ' Produce a sorted list (K1$) of all files in the .IDX starting with (K).
    '
    K1$ = Null$   'produce a sorted list of filenames.
    K0 = 0
    K1 = AscMid(o$(32),K)
    K2 = 0
    WHILE K0 = 0 AND K0& < K&
      CALL FileGetSLoc(p1,K0&,K$)
      IF ASC(K$) > K1 THEN K0 = 1 _
                      ELSE K0& = K0& + 22 : _
                           MID$(K2$,K2 + 1,12) = K$ : _
                           K2 = K2 + 12 : _
                           IF K2 = 1200 THEN K2 = 0 : _
                                             K1$ = K1$  + K2$
    WEND
    K1$ = K1$ + LEFT$(K2$,K2)
    '
    ' Compare the lists looking for differences.
    '
    K1 = LEN(K0$)
    K9 = LEN(K1$)
    K0 = 1
    WHILE (K0 + 11) <= K9
      '
      ' Match the .IDX filename with all those in our FindF list.
      '
      K2$ = MID$(K1$,K0,12)
      SELECT CASE K1
        CASE IS > 0
             K2 = 1
             DO
               IF K2$ = MID$(K0$,K2,12) THEN MID$(K0$,K2,1) = C0$ : _
                                             EXIT DO
               K2 = K2 + 12
             LOOP UNTIL K2 >= K1
      END SELECT
      '
      ' K2 <= K1 If the file was found, otherwise it's not on the drive.
      '
      SELECT CASE K2
        CASE IS > K1
             '
             ' A file has disappeared (found in .IDX but not on drive).
             '
             K3 = BiSearch(3,p1,K2$)
             '
             ' Files that have disappeared off the drive(s).  Officially
             ' remove them.  Provided they are not transients.
             '
             K4 = FileIDX.FArea
             IF K4 < 1 OR K4 > p THEN K4 = 1
             SELECT CASE BitTest(FileAreaI(K4).Attr,6)
               CASE 0
                    TT$ = o$(11) + FileIDX.FName + o$(12)
                    CALL SendTT
                    CALL FileGetRec(p0,FileIDX.FRec,119,FileList)
                    CALL RemoveReview(RTRIM$(FileIDX.FName),0)
                    IF BitTest(Settings.LoggingAmount,13) _
                       THEN TT$ = o$(13) + FileIDX.FName + C32$ + _
                                  RTRIM$(FileList.FDesc) : _
                            CALL LogTT
                    IF NOT BitTest(FileList.Attr,7) _
                       THEN K$ = FileList.FName + _
                                 Form$(1066,STR$(FileList.FSize)) + _
                                 RTRIM$(FileList.FDesc) : _
                            CALL SharedWriteEOF(24,0,Null$,K$)
                    CALL BitSet(FileList.Attr,1)
                    CALL FilePutRec(p0,FileIDX.FRec,119,FileList)
                    CALL CutOut(p1,Null$,K3 * 22& - 21,22&)
                    K0& = K0& - 22     'Our file is a rec smaller (offset).
                    K& = K& - 22       'Ditto for size.
             END SELECT
      END SELECT
      K0 = K0 + 12
    WEND
    '
    ' Now we go through our FindF list and see if anything is still active.
    '
    K2 = 1
    WHILE (K2 + 11) <= K1
      SELECT CASE AscMid(K0$,K2)
        CASE IS <> 0
             '
             ' A file has appeared (found on drive but not in .IDX).
             '
             '
             ' Files that have suddenly appeared on the drive(s).
             ' Officially add them.
             '
             K4 = 0
             K2& = FileLof&(p0,1)
             K2$ = MID$(K0$,K2,12)
             K3$ = LeftTill$(K2$,46)
             WHILE K2& > 118
               K2& = K2& - 119
               CALL FileGetSLoc(p0,K2& + 8,K$)
               SELECT CASE LeftTill$(K$,46)
                 CASE K3$
                      CALL FileGetLoc(p0,K2&,119,FileList)
                      TT$ = o$(14) + FileList.FName + o$(12)
                      CALL SendTT
                      '
                      ' If a file exists on the disk, but is marked as
                      ' deleted, then undelete it.
                      '
                      z = 0
                      IF BitTest(FileList.Attr,1) _
                         THEN TT$ = o$(15) + FileList.FName + _
                                    C32$ + RTRIM$(FileList.FDesc) : _
                              CALL LogTT : _
                              FileList.Attr = FileList.Attr - 1 : _
                              FileList.FName = K2$ : _
                              CALL FilePutLoc(p0,K2&,119,FileList) _
                         ELSE IF K$ <> K2$ THEN z = 1
                      IF z = 0 _
                         THEN FileIDX.FName = FileList.FName : _
                              FileIDX.FSize = FileList.FSize : _
                              FileIDX.FRec = (K2& \ 119) + 1 : _
                              FileIDX.Attr = FileList.Attr : _
                              FileIDX.FArea = FileList.FArea : _
                              CALL FilePutRec(p1,FileLof&(p1,22) + 1,22,FileIDX) : _
                              K4 = 1 : _
                              K2& = -1
               END SELECT
             WEND
             SELECT CASE K4
               CASE 0
                    User.UserName = Settings.Sysop
                    SumLog.DateOn = DateToInt(DATE$)
                    TT$ = o$(40) + K2$ + o$(12)
                    CALL SendTT
                    FOR FileIndex = 1 TO p
                      IF LEN(K5$) = 0 THEN K6$ = FileAreaInfo3$(FileIndex,2) _
                                      ELSE K6$ = WordsGet$(K5$,FileIndex,0)
                      SELECT CASE FindF(K6$ + K2$,FFile)
                        CASE IS <> 0
'problem with this: when restart a CD from scratch--like for transient disks.
'                             IF BitTest(FileAreaI(FileIndex).Attr,10) _
'                                THEN EXIT FOR   'multi-node UL area, no do.
'                             CALL FileCloseW(p1)
                             CALL CreateFileStuff(3,0,0,- p0,p1)
'                             p1 = FileOpenWDA(FileNames(59))
                             CALL FilePutRec(p0,FileLof&(p0,119) + 1,119,FileList)
                             EXIT FOR
                      END SELECT
                    NEXT
             END SELECT
             K5 = -1
      END SELECT
      K2 = K2 + 12
    WEND
    CALL ShowMeter(K0&)
  NEXT
  IF K5 THEN CALL FileSort2(p1,22,-2)
  CALL FileCloseW(p0)
  CALL FileCloseW(p1)

END SUB

