' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.
'
' This file contains the DataBaser routines:
'   DataBaser
'   RecFieldLen%
'   GetKeyRec
'   DisplayRec
'   AddARecord
'   DeleteARec
'   ListRecs
'   DispExpand
'




        '* * * * * *
        ' This routine oversee's the various data base functions.
        '
        ' o$(1)  data base file name
        '
        ' o$(2)  data base specs
        '
        ' o$(3)  'get the record' question line
        '
        ' o$(4)  what we're working with (linkage, sysop names, etc.)
        '
        ' o$(5)  header text
        '
        ' o$(6)  list body specs
        '
        ' o$(101) to o$(n) store current record data. (n max's at like 24).
        '
        ' K = block to do, if less than zero, then we just view it.
        '
        ' p  Number of directories
        '
        ' I estimate a maximum record size of 4096 bytes.  Figuring that
        ' that the block itself doesn't exceed 4096, and then the temporary
        ' output buffer is 4096, and the string routines double that--which
        ' is why 8192 limit for messages--equals about 16k or the normal
        ' safe limit.
        '
        ' Date last checked for perfection: Sep 11 1992
        '
SUB DataBaser (K,p)

  CALL BlockToO(0,40)
  IF K = 0 THEN EXIT SUB
  IF K < 0 THEN zz = -1 : _
                K = - K _
           ELSE zz = 0
'  IF zz THEN TT = 20007 : _
'             CALL SendTT
  K4 = FileOpenR(FileNames(111))
  K0& = Blocks&(1,K)
  K$ = FileGetLine$(K4,K0&)
  DO
    IF zz THEN TT$ = MID$(K$,3) + C1310$ : _
               CALL SendTT
    K$ = FileGetLine$(K4,K0&)
  LOOP UNTIL Val3(K$,1) <> K OR K0& = -1 OR LTRIM$(RTRIM$(MID$(K$,3))) = o$(8)
  IF K0& = -1 THEN CALL FileCloseR(K4) : _
                   EXIT SUB
  FOR K0 = 1 TO 4
    o$(K0) = MID$(FileGetLine$(K4,K0&),3)
  NEXT
  IF LEN(o$(1)) = 0 OR LEN(o$(2)) = 0 THEN TT = 20010 : _
                                           CALL ScreamErrorTT
  FOR K0 = 5 TO 6
    K$ = FileGetLine$(K4,K0&)
    o$(K0) = Null$
    DO
      o$(K0) = o$(K0) + MID$(K$,3)
      K$ = FileGetLine$(K4,K0&)
    LOOP UNTIL Val3(K$,1) <> K OR K0& = -1 _
               OR LTRIM$(RTRIM$(MID$(K$,3))) = o$(8)
    IF K0& = -1 THEN EXIT FOR
  NEXT
  IF K0& = -1 THEN CALL FileCloseR(K4) : _
                   EXIT SUB
  K& = K0&                              'Start of DisplayRec information.
  K9 = FileOpenW(o$(1))
  IF NOT zz THEN K0 = -1 : _
                 TGot = 1 : _
                 o$(4) = Null$ _
            ELSE K0 = 0
  DO
    IF NOT K0 THEN TT = 20011 : _
                   CALL GetNumPlusTT(o$(9)) : _
                   IF TGot > 0 THEN TGot = StrSrch1(o$(9),TGot)
    K2 = TGot
    IF K2 = 5 AND K = 10 THEN K2 = 2
    SELECT CASE K2
      CASE 1    ' List recs.
           IF zz THEN TT = 20017 : _
                      CALL SendTT
           CALL ListRecs(1,K9)
      CASE 2   'Add new record.
           TT = 20019
           CALL SendTT
           CALL DisplayRec(-1,K&,K1$,K2$,K4,K9,K)
           CALL AddARecord(K,K1$,K2$,-1,Null$,K9,K2)
      CASE 3   'Modify record.
           TT = 20018
           CALL GetKeyRec(K1,K9)
           IF K1 > 0 THEN CALL DisplayRec(K1,K&,K1$,K2$,K4,K9,K) : _
                          CALL AddARecord(K,K1$,K2$,K1,K0$,K9,K2)
      CASE 4   'Delete record.
           TT = 20015
           CALL SendTT
           IF K = 10 THEN CALL DeleteARec(K,0,K9) _
                     ELSE TT = 20016 : _
                          CALL GetKeyRec(K1,K9) : _
                          IF K1 > 0 THEN CALL DeleteARec(K,K1,K9)
      CASE 5   'Insert record.
           TT = 20014
           CALL GetKeyRec(K1,K9)
           IF K1 > 0 _
              THEN CALL DisplayRec(-1,K&,K1$,K2$,K4,K9,K) : _
                   CALL AddARecord(K,K1$,K2$,-1,Null$,K9,K2) : _
                   K14 = RecFieldLen(0,1) : _
                   K0$ = SPACE$(K14) : _
                   K1$ = SPACE$(K14) : _
                   K1& = 1& * K1 * K14 - K14: _
                   K2& = FileLof&(K9,1) - K14 : _
                   FOR K5 = K1 TO K2& \ K14 : _
                     CALL FileGetSLoc(K9,K2&,K0$) : _
                     CALL FileGetSLoc(K9,K1&,K1$) : _
                     CALL FilePutSLoc(K9,K2&,K1$) : _
                     CALL FilePutSLoc(K9,K1&,K0$) : _
                     K1& = K1& + K14 : _
                   NEXT
      CASE ELSE   'List recs given offset.
           kx = Val2&(TGot$)
           if kx = 0 then TT = 20013 : _
                          CALL SendTT : _
                          K0 = 0 : _
                          EXIT DO
           CALL ListRecs(kx,K9)
    END SELECT
    CALL DispCRLF
    '
    ' For safety's sake (and to handle any mods) read back in the arrays if
    ' do anything except List.
    '
    SELECT CASE K2
      CASE IS <> 1
           SELECT CASE K
             CASE 5
                  '
                  ' Load up Languages.
                  '
                  GlobalStuff$(19) = SPACE$(FileLof&(K9,1))
                  CALL FileGetSLoc(K9,0&,GlobalStuff$(19))
             CASE 39
                  '
                  ' Load up Events.
                  '
                  GlobalStuff$(18) = Null$
                  k11& = -54
                  K11$ = SPACE$(14)
                  FOR K12 = 1 TO FileLof&(K9,54)
                    k11& = k11& + 54
                    CALL FileGetSLoc(K9,k11&,K11$)
                    GlobalStuff$(18) = GlobalStuff$(18) + K11$
                  NEXT
             CASE 4
                  '
                  ' Read in DoPaths$() information.
                  '
                  K11 = FileLof&(K9,144)
                  REDIM DoPaths$(K11)
                  K11& = -144
                  K11$ = SPACE$(72)
                  FOR K12 = 1 TO K11
                    K11& = K11& + 144
                    CALL FileGetSLoc(K9,K11&,K11$)
                    DoPaths$(K12) = RTRIM$(K11$)
                  NEXT
             CASE 10
                  '
                  ' Read in message base information.  Load up MsgAreaI().
                  '
                  BasesSize = FileLof&(K9,108) - 1
                  REDIM MsgAreaI(BasesSize + 1) AS MsgAreaIRecord
                  FOR K3 = 0 TO BasesSize
                    CALL FileGetRec(K9,K3 + 1,108,MsgArea)
                    IF MsgArea.NextNumber = 0 THEN MsgArea.NextNumber = 1
                    MsgAreaI(K3 + 1).SubType    = MsgArea.SubType
                    MsgAreaI(K3 + 1).SLen       = StripLen(RTRIM$(MsgArea.Title))
                    MsgAreaI(K3 + 1).NextNumber = MsgArea.NextNumber
                    MsgAreaI(K3 + 1).ScanSL     = MsgArea.ScanSL
                  NEXT
             CASE 42
                  '
                  ' Read in the security level information.  Load up Levels().
                  '
                  LevelsSize = FileLof&(K9,28)
                  REDIM Levels(LevelsSize) AS LevelRecord
                  FOR K3 = 1 TO LevelsSize
                    CALL FileGetRec(K9,K3,28,Levels(K3))
                  NEXT
                  UserSL = MappedSL(User.SecLevel)
             CASE 41
                  '
                  ' Read in the file areas.  Load up FileAreaI().
                  '
                  p = FileLof&(K9,188)
                  REDIM FileAreaI(p) AS FileAreaIRecord
                  FOR K3 = 1 TO p
                    CALL FileGetRec(K9,K3,188,FileArea)
                    FileAreaI(K3).DLSL      = FileArea.DLSL
                    FileAreaI(K3).ScanSL    = FileArea.ScanSL
                    FileAreaI(K3).Attr      = FileArea.Attr
                    FileAreaI(K3).HiFilePtr = FileArea.HiFilePtr
                    FileAreaI(K3).FileOp    = StrCkSum(FileArea.FileOp)
                  NEXT
             CASE 2
                  '
                  ' Reload our base net address.
                  '
                  CALL FileGetSLoc(K9,0&,GlobalStuff$(25))
           END SELECT
     END SELECT
  LOOP UNTIL NoCarrier OR K0
  CALL FileCloseW(K9)
  CALL FileCloseR(K4)
  IF K0 THEN CALL Paused

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to DataBaser, returns the editing
        ' length or storage length needed for individual fields, given
        ' the record's DataBaser Specs.
        '
        ' o$(2)  the specs [rcvd]
        '
        ' p   field to find edit length of, or 0 to total all fields.
        '
        ' p0  0 to find the editing length of a field.
        '     1 to find the storage length of a field.
        '
        ' Date last checked for perfection: Sep 11 1992
        '
FUNCTION RecFieldLen% (p,p0)

  K$ = o$(2)
  K1 = 0                                   'Field counter.
  K2 = 0                                   'Total of all.
  DO
    SELECT CASE ASC(K$)
      CASE 65 : K3 = 16 : K4 = 2           'General attribute type.  16 bits.
      CASE 68 : K3 = 9  : K4 = 2           'Date DD-MMM-YY.  Integer format.
      CASE 84 : K3 = 8  : K4 = 2           'Time HH:MM:SS.  Integer format.
      CASE 73 : K3 = 6  : K4 = 2           'Integer number.
      CASE 77 : K3 = 3  : K4 = 2           'Message area number.
      CASE 70 : K3 = 3  : K4 = 2           'File area number.
      CASE 80 : K3 = 14 : K4 = 4           'Phone number.  Long Integer format.
      CASE 85 : K3 = 30                    'User name.
                K4 = K3
      CASE 83 : K3 = Val3(K$,2)           'String.
                K$ = MID$(K$,3)
                K4 = K3
      CASE 76 : K3 = 10 : K4 = 4           'Long number.
      CASE 78 : K3 = 17 : K4 = 6           'Node address.
      CASE 87 : K3 = 7  : K4 = 2           'Days of week field.
      CASE ELSE : K3 = 0  : K4 = K3
    END SELECT
    IF p0 = 1 THEN K3 = K4
    K2 = K2 + K3
    K$ = MID$(K$,2)
    K1 = K1 + 1
  LOOP UNTIL LEN(K$) = 0 OR p = K1
  IF p = K1 THEN RecFieldLen = K3 _
            ELSE RecFieldLen = K2

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to DataBaser, gets the key record
        ' from the user.
        '
        ' p   the record number.  Returns 0 if [Enter] or too big.
        '
        ' p0  handle of already-opened database.
        '
        ' o$(2)  the specs ('LS30II') of the record.
        '
        ' o$(3)  the question line to give to the user.
        '
        ' Date last checked for perfection: Sep 11 1992
        '
SUB GetKeyRec (p,p0)

  CALL SendTT
  K = RecFieldLen(0,1)
  K1 = FileLof&(p0,K)
  TT = 20003
  CALL GetNumPlusTT(Null$)
  p = Val2&(TGot$)
  IF p > K1 THEN p = 0
  CALL DispCRLF
  CALL DispCRLF

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to DataBaser, displays the field
        ' names of the record to add, and the current data if
        ' modifying a record.
        '
        ' p   record's number (rcvd)
        '
        ' p&   pos of of field names. (rcvd)
        '
        ' p0$  lengths of current data in fields (ret)
        '
        ' p1$  the actual record or NULL (ret)
        '
        ' p0   Handle of BLOCK.xxx (rcvd).
        '
        ' p1   Handle of the data file (rcvd).
        '
        ' o$(2)  record's specs (rcvd)
        '
        ' o$(4)  what it is ('message base') (rcvd)
        '
        ' p2  block number working with.
        '
        ' Date last checked for perfection: Sep 11 1992
        '
SUB DisplayRec (p,p&,p0$,p1$,p0,p1,p2)

  p0$ = Null$
  K = RecFieldLen(0,1)
  IF p > 0 THEN K2$ = SPACE$(K) : _
                CALL FileGetSLoc(p1,1& * (p - 1) * K,K2$) : _
                p1$ = K2$ : _
                k3 = 20 _
           ELSE p1$ = Null$ : _
                k3 = 21
  TT$ = o$(k3) + o$(4) + o$(22)
  CALL SendTT
  K0& = p&
  K1$ = o$(2)
  K3 = 0
  DO
    K3 = K3 + 1
    K0$ = Null$
    K1 = RecFieldLen(K3,0)
    K2 = RecFieldLen(K3,1)
    '
    ' If the record already exists, then get the current data from there.
    '
    IF p > 0 THEN K0$ = LEFT$(K2$,K2) : _
                  CALL DispExpand(K1$,K0$,K5,- K3)
    IF AscNull(K1$) = 83 THEN K1$ = MID$(K1$,4) _
                         ELSE K1$ = MID$(K1$,2)
    K2$ = MID$(K2$,K2 + 1)
    TT$ = FileGetLine$(p0,K0&)
    p0$ = p0$ + RIGHT$(o$(23) + STR$(LEN(TT$) + 1),2)
    IF LEN(K0$) > K1 THEN K0$ = LEFT$(K0$,K1)
    o$(100 + K3) = MKI$(LEN(TT$) + 2) + K0$
    TT$ = o$(24) + MID$(TT$,3) + o$(25) + K0$ + SPACE$(K1 - LEN(K0$)) + o$(26)
    CALL SendTT
  LOOP UNTIL LEN(K1$) = 0 OR NoCarrier

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to DataBaser, handles the altering of
        ' a data record.
        '
        ' p    the block database we're working on.
        '
        ' p$   'what field is' length specs.
        '
        ' p0$  original record.
        '
        ' p0   record number modifying or -1 if adding a new record.
        '
        ' p1$  User name field if it was entered as primary field or
        '      null, it makes up the first data field if not null.
        '
        ' p1   Handle of the data file (rcvd).
        '
        ' Record must already have been displayed with DisplayRec.
        '
        ' Date last checked for perfection: Sep 11 1992
        '
SUB AddARecord (p,p$,p0$,p0,p1$,p1,p2)

  K5$ = p1$
  TT = 20027
  CALL SendTT
  K2$ = o$(2)
  K3$ = Null$
  K1 = 0
  IF p2 = 2 THEN K99 = 5 _
            ELSE K99 = 7
  WHILE LEN(K2$) > 0 AND NOT NoCarrier
    CALL CursorOn
    TT$ = o$(28) + LTRIM$(MID$(p$,K1 * 2 + 1,2)) + o$(29)
    K1 = K1 + 1
    K5 = ASC(K2$)
    K99 = K99 + 1
    IF K99 = 26 THEN K99 = 25
    SELECT CASE K5
      CASE 85
           LESpecial = 4
           K3 = GetUserNameTT
           LESpecial = 0
           IF K3 < 2 AND p0 > 0 THEN K3$ = K3$ + MID$(p0$,LEN(K3$) + 1,30) _
                                ELSE K3$ = K3$ + AnyUser.UserName
      CASE 80
           CALL SendTT
           CALL GetPhoneNumber(0)
           IF TT& = 0 AND p0 > 0 THEN K3$ = K3$ + MID$(p0$,LEN(K3$) + 1,4) _
                                 ELSE K3$ = K3$ + MKL$(TT&)
      CASE ELSE
           K2 = RecFieldLen(K1,0)
           CALL SendTT
           K6$ = o$(1)
           o$(1) = MID$(o$(100 + K1),3)
           CALL BoxEdit(K99,IntMid(o$(100 + K1),1),1,K2,o$(30))
           K4$ = RTRIM$(o$(1))
           IF p0 > 0 AND LEN(K4$) = 0 AND LEN(o$(1)) > 0 THEN K4$ = o$(1)
           'The above is necessary to allow clearing off entries while at
           'the same time allowing [Enter] alone to keep current entry
           'and properly zero out new entries.
           o$(1) = K6$
           SELECT CASE LEN(K4$)
             CASE 0
                  k55 = RecFieldLen(K1,1)
                  IF p0 > 0 THEN K3$ = K3$ + MID$(p0$,LEN(K3$) + 1,k55) : _
                            ELSE IF K5 = 83 THEN K3$ = K3$ + SPACE$(k55) _
                                            ELSE K3$ = K3$ + STRING$(k55,0)
                  IF K5 = 83 THEN K2$ = MID$(K2$,3)
             CASE ELSE
                  SELECT CASE K5
                    CASE 73, 77, 70 : K3$ = K3$ + MKI$(Val2&(K4$))
                    CASE 83
                         IF LEFT$(K2$,3) = o$(31) _
                            THEN K3$ = K3$ + C1310$ _
                            ELSE K3$ = K3$ + LEFT$(K4$ + SPACE$(K2),K2)
                         IF LEFT$(K2$,3) = o$(32) AND AscRight(K4$) = 92 _
                            THEN CALL DirCreate(K4$)  '32='S64' w/a '\'.
                         K2$ = MID$(K2$,3)
                    CASE 76 : K3$ = K3$ + MKL$(Val2&(K4$))
                    CASE 68 : K3$ = K3$ + MKI$(DateToInt(K4$))
                    CASE 84 : IF K4$ = o$(41) OR K4$ = o$(33) THEN K4$ = o$(34)
                              K3$ = K3$ + MKI$(TimeToInt(K4$))
                    CASE 78 : K3$ = K3$ + StrToAddr$(K4$)
                    CASE 65 : K3$ = K3$ + MKI$(AttrToInt(K4$))
                    CASE 87
                         K3 = 0
                         K4$ = UCASE$(K4$)
                         FOR K4 = 1 TO 7
                           IF StrSrch1(K4$,AscMid(o$(35),K4)) > 0 _
                              THEN CALL BitSet(K3,K4)
                         NEXT
                         K3$ = K3$ + MKI$(K3)
                  END SELECT 
           END SELECT 
    END SELECT 
    TT = 20036
    CALL SendTT
    K2$ = MID$(K2$,2)
    CALL CursorOff
  WEND
  IF p0 > 0 THEN CALL FilePutSLoc(p1,1& * (p0 - 1) * RecFieldLen(0,1),K3$) _
            ELSE CALL FilePutSEnd(p1,K3$)
  SELECT CASE p
    CASE 10
         '
         ' Handle the adding/modification of message bases.
         '
         SELECT CASE p0
           CASE -1
                K5 = FileOpenR(FileNames(3))
                K6 = FileOpenW(FileNames(10))
                K2$ = UserMsgInfo$
                K2 = LEN(UserMsgInfo$)
                K& = FileLof&(K5,1)
                CALL ShowMeter(- K&)
                TT = 20037
                CALL SendTT
                K0& = - K2
                FOR K3 = 0 TO FileLof&(K5,K2) - 1
                  K0& = K0& + K2
                  CALL FileGetSLoc(K5,K0&,K2$)
                  K3$ = LEFT$(K2$,BasesSize * 4 + 4) + STRING$(4,0) + _
                        MID$(K2$,BasesSize * 4 + 5) + C0$
                  CALL FilePutSEnd(K6,K3$)
                  CALL ShowMeter(K0&)
                NEXT
                UserMsgInfo$ = K3$
                CALL FileGetSLoc(K6,1& * (BiSearch(5,0,User.UserName) - 1) * LEN(K3$),UserMsgInfo$)
                CALL FileCloseR(K5)
                CALL FileCloseW(K6)
                CALL CopyFile(1,FileNames(10),FileNames(3))
                TT = 20042
                CALL SendTT
         END SELECT
  END SELECT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to DataBaser, deletes a record in a
        ' DataBaser database.
        '
        ' p   the DataBaser block in BLOCK.TXT.
        '
        ' p0  the record number to delete
        '
        ' p1  Handle of the data file (rcvd).
        '
        ' You must delete any user name's in your databases before
        ' doing it from the BBS.  If not, then you'll have to undelete
        ' the name, or create a new one, before you'll be able to
        ' again access and delete the records corresponding to that
        ' name.
        '
        ' Deleteing has no effect on the messages themselves, those
        ' that are in a deleted message area won't be accessible and
        ' are assumed deleted when packed.
        '
        ' Date last checked for perfection: Sep 11 1992
        '
SUB DeleteARec (p,p0,p1)

  SELECT CASE p
    CASE 10
         K$ = SPACE$(60)
         CALL FileGetSLoc(p1,FileLof&(p1,108) * 108& - 60,K$)
         TT$ = o$(38) + RTRIM$(K$) + o$(39)
         IF NOT GetYNTT THEN TT = 20040 : _
                             CALL SendTT : _
                             EXIT SUB
         TT = 20037
         CALL SendTT
         CALL KillFile(FileNames(10))
         K6 = FileOpenW(FileNames(10))
         K7 = RecFieldLen(0,1)
         K& = FileLof&(p1,1)
         CALL ShowMeter(- K&)
         K$ = SPACE$(K7)
         K0& = - K7
         FOR K1 = 0 TO FileLof&(p1,K7) - 2
           K0& = K0& + K7
           CALL FileGetSLoc(p1,K0&,K$)
           CALL FilePutSEnd(K6,K$)
           CALL ShowMeter(K0&)
         NEXT
         CALL FileCloseW(K6)
         CALL FileCloseW(p1)
         CALL CopyFile(1,FileNames(10),o$(1))
         K6 = FileOpenR(FileNames(3))
         K7 = FileOpenW(FileNames(10))
         K$ = UserMsgInfo$
         K2 = LEN(UserMsgInfo$)
         K& = FileLof&(K6,1)
         CALL ShowMeter(- K&)
         K0& = - K2
         FOR K3 = 0 TO FileLof&(K6,K2) - 1
           K0& = K0& + K2
           CALL FileGetSLoc(K6,K0&,K$)
           K0$ = LEFT$(K$,BasesSize * 4) + MID$(K$,BasesSize * 4 + 5,BasesSize)
           CALL FilePutSEnd(K7,K0$)
           CALL ShowMeter(K0&)
         NEXT
         UserMsgInfo$ = K0$
         CALL FileGetSLoc(K7,1& * (BiSearch(5,0,User.UserName) - 1) * LEN(K0$),UserMsgInfo$)
         BasesSize = BasesSize - 1
         CALL FileCloseR(K6)
         CALL FileCloseW(K7)
         CALL CopyFile(1,FileNames(10),FileNames(3))
    CASE ELSE
         CALL KillFile(FileNames(10))
         K6 = FileOpenW(FileNames(10))
         K1 = RecFieldLen(0,1)
         K$ = SPACE$(K1)
         k0& = - k1
         FOR K2 = 1 TO FileLof&(p1,K1)
           k0& = k0& + k1
           CALL FileGetSLoc(p1,k0&,K$)
           IF K2 <> p0 THEN CALL FilePutSEnd(K6,K$)
         NEXT
         CALL FileCloseW(p1)
         CALL FileCloseW(K6)
         CALL CopyFile(1,FileNames(10),o$(1))
  END SELECT
  p1 = FileOpenW(o$(1))
  TT = 20042
  CALL SendTT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to DataBaser, lists the contents of
        ' the data files.
        '
        ' p   Record number to start listing at.
        '
        ' p0  Handle of the data file (rcvd).
        '
        ' Date last checked for perfection: Sep 11 1992
        '
SUB ListRecs (p,p0)

  IF LEN(o$(4)) > 0 THEN TT$ = o$(43) + o$(4) + o$(44) + o$(5) _
                    ELSE TT$ = o$(45) + o$(5)
  CALL SendTT
  IF TGot > 0 THEN EXIT SUB
  K1 = RecFieldLen(0,1)
  '
  ' Convert '~' characters to CR/LF's in the output specs.
  '
  K$ = o$(6)
  CALL ReplaceCharacters(K$,-1,C1310$,126)
  k& = - k1
  FOR K2 = 1 TO p - 1
    k& = k& + K1       'ugly, but p*k1 could overflow.
  NEXT
  FOR K2 = p TO FileLof&(p0,K1)
    '
    ' Load the database record.
    '
    K1$ = SPACE$(K1)
    k& = k& + k1
    CALL FileGetSLoc(p0,k&,K1$)
    K2$ = o$(2)
    K2$ = o$(47) + K2$                   'Add a '*' for rec num field.
    '
    ' Expand the specs to create the output.
    '
    TT$ = o$(46)
    K3 = 1
    K4 = 0
    K5 = 0
    DO
      IF ASC(K2$) <> 42 THEN K4 = K4 + 1
      K6 = StrSrch2(K3 - 1,K$,60)                   'Search for '<'.
      IF K6 - K3 > 0 _
         THEN TT$ = TT$ + MID$(K$,K3,K6 - K3) : _
              K7 = StrSrch1(MID$(K$,K3,K6 - K3),13) : _
              IF K7 > 0 _
                 THEN IF K5 = 0 THEN K8 = StrSrchR(TT$,13) : _
                                     K9 = StrSrchR(LEFT$(TT$,K8 - 1),13) : _
                                     TT$ = LEFT$(TT$,K9) + MID$(TT$,K8 + 1) _
                                ELSE K5 = 0
      K3 = K6 + 3
      IF ASC(K2$) <> 42 THEN K8 = RecFieldLen(K4,1) : _
                             K4$ = LEFT$(K1$,K8) : _
                             K1$ = MID$(K1$,K8 + 1)
      CALL DispExpand(K2$,K4$,K8,K2)
      IF LEN(RTRIM$(K4$)) > 0 THEN K5 = 1
      kz = Val3(K$,K6 + 1)
      IF kz > 0 THEN TT$ = TT$ + Form$(kz * 100 + K8,K4$)
      K2$ = MID$(K2$,2)
    LOOP UNTIL LEN(K2$) = 0
    K2$ = MID$(K$,K3)
    IF K5 = 0 THEN K7 = StrSrch1(K2$,13) : _
                   IF K7 > 0 THEN K8 = StrSrchR(TT$,13) : _
                                  TT$ = LEFT$(TT$,K8 + 1) : _
                                  K2$ = MID$(K2$,K7 + 2)
    TT$ = TT$ + K2$
    CALL SendTT
    IF TGot > 0 THEN EXIT FOR
  NEXT
  CALL DispCRLF

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to DataBaser, expands the various
        ' stored types into human readable format.
        '
        ' p$   DataBaser spec working on.
        '
        ' p0$  Returned line to display.
        '
        ' p    Returned Form$ format to display.
        '
        ' p0   Record number being worked on.
        '      -'ve if doing modification
        '
        ' Date last checked for perfection: Sep 11 1992
        '
SUB DispExpand (p$,p0$,p,p0)

  K2 = p0
  IF p0 < 0 THEN p0 = - p0
  SELECT CASE AscNull(p$)
    CASE 73 : p0$ = IntToStr$(IntMid(p0$,1))
              p = 02                 'Right justify.
    CASE 77 : K0 = IntMid(p0$,1)
              p0$ = Form4$(3,K0)
              K0 = K0 - 1
              IF K0 <= BasesSize AND K0 > 0 _
                 THEN p0$ = p0$ + C32$ + MsgAreaInfo3$(K0 + 1,2)
              p = 01                 'Trim and left justify.
    CASE 70 : K0 = IntMid(p0$,1)
              p0$ = Form4$(3,K0)
              IF K0 <= DirsSize AND K0 > 0 _
                 THEN p0$ = p0$ + C32$ + FileAreaInfo3$(K0,3)
              p = 01                 'Trim and left justify.
    CASE 80 : p0$ = IntToPhone$(LongMid(p0$,1))
              p = 02                 'Right justify.
    CASE 68 : p0$ = IntToDate3$(IntMid(p0$,1))
              p = 02                 'Trim and right justify.
    CASE 84 : p0$ = IntToTime$(IntMid(p0$,1))
              IF K2 >= 0 THEN p0$ = RightTime$(p0$)
              p = 02                 'Trim and right justify.
    CASE 65 : p0$ = IntToAttr$(IntMid(p0$,1))
              p = 01                 'Trim and left justify.
    CASE 83 : p$ = MID$(p$,3)
              p = 01                 'Trim and left justify.
    CASE 76 : p0$ = LongToStr$(LongMid(p0$,1))
              p = 02                 'Right justify.
    CASE 87 : K0 = IntMid(p0$,1)
              p0$ = o$(35)
              FOR p = 1 TO 7
                IF NOT BitTest(K0,p) THEN MID$(p0$,p,1) = C32$
              NEXT
              p = 01                 'Left justify.
    CASE 78 : p0$ = FidoForm$(p0$)
              p = 01                 'Trim and left justify.
    CASE 42 : p0$ = STR$(p0)
              p = 02                 'Right justify.
    CASE 85 : p = 05                 'WordsCase it and left justify.
  END SELECT

END SUB
        '
        '* * * *

