' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.




        '* * * * * *
        ' This routine displays a message, and handles all the
        ' reading messages user options.
        '
        ' p  0 for reading all mail sent TO/FROM user in messages.
        '      (only used with private message bases)
        '    1 for reading NEW mail TO user in a (any) base.
        '      (only used with logon mail read)
        '    2 for reading a single or multiple letter(s) in any base.
        '    4 same as 2, except doesn't ask for a number, or N for
        '      new, question. (for the 'read all new messages' command.)
        '
        ' This routine relies on BaseIndex to determine what area it's
        ' in.  It doesn't alter BaseIndex.
        '
        ' Date last checked for perfection: Aug 1 1993
        '
SUB ReadMessages (p)

  IF BaseIndex = 32767 OR BaseIndex < 0 THEN EXIT SUB
  K& = LongMid(UserMsgInfo$,BaseIndex * 4 + 1)   'User's last-read value.
  IF K& < 0 AND BitTest(MsgAreaI(BaseIndex + 1).SubType,4) THEN EXIT SUB  'Locked
  '
  ' If a sysop, and private mail, then offer them the opportunity to read any
  ' mail in the area.
  '
  K30$ = MsgAreaInfo3$(BaseIndex + 1,1)
  K30 = (User.UserName <> K30$)
  IF BitTest(MsgAreaI(BaseIndex + 1).SubType,2) AND p <> 1 THEN IF NOT K30 _
                                                                   THEN p = 2 _
                                                                   ELSE p = 0
  K = FindF(Form4$(10,BaseIndex + 1),FFile)
  K0& = FFile.FSize
  IF K0& < 12 THEN EXIT SUB        'No messages in this message base.
  K = K0& \ 12
  '
  ' K0 = index record of first message new to user in BaseIndex.
  ' K1 = index record of first message user sent or received in BaseIndex.
  ' K2 = index record of first message TO the user in BaseIndex.
  ' K3 = index record of current message.
  ' K4 = direction flag
  '
  CALL UserMsgAreaInfo(p,K0,K1,K2,K0&,K&,0)
  CALL BlockToO(0,20)
  '               
  ' Get the message to display first.
  '
  SELECT CASE p
    CASE 0 : K3 = K1
    CASE 1 : K3 = K2
             IF K2 = -1 THEN EXIT SUB
             K4 = FosIntAX(CommPort,&HA00)   'Purge the fossil's input buffer.
                                             'To stop inadvertent [Enter]'s.
    CASE 4 : K3 = K0
    CASE ELSE
         K1 = FileOpenR(Form4$(10,BaseIndex + 1))
         K2 = FileLof&(K1,12)
         IF K > K2 THEN K = K2
         IF FileLof&(K1,1) < 12 THEN CALL FileCloseR(K1) : _
                                     EXIT SUB
         CALL FileGetRec(K1,K,12,MsgIDX)     'last msg
         K& = MsgIDX.MsgNum
         CALL FileGetRec(K1,1,12,MsgIDX)     'first msg
         CALL FileCloseR(K1)
         TT$ = o$(1) + STR$(MsgIDX.MsgNum) + o$(2) + STR$(K&)
         IF K0 < 0 THEN K1 = 0 _
                   ELSE K1 = K - K0 + 1
         K2 = K1
         IF K1 > 1 THEN K2 = 2 : _
                        TT$ = TT$ + o$(3) + STR$(K1)
         TT$ = TT$ + o$(4 + K2)
         CALL SendTT
         IF TGot < 1 THEN TT = 20017 : _
                          CALL GetNumPlusTT(Chars$(78))
         IF TGot = 78 THEN TT = 20008 : _
                           CALL SendTT : _
                           K3 = K0 _
                      ELSE CALL FindMessageByNum(p,K3,1)
  END SELECT
  '
  ' No messages found, so exit.
  '
  IF K3 < 1 OR K3 > K THEN IF p = 1 OR p = 0 THEN TT = 20009 : _
                                                  CALL SendTT : _
                                                  EXIT SUB _
                                             ELSE EXIT SUB
  CALL WhatDoing(4)
  '
  ' Display a message, and handle the message commands.
  '
  K4 = 1
  DO
    IF K4 = 0 THEN K4 = 1
    K1$ = Null$
    K = FileOpenR(Form4$(10,BaseIndex + 1))
    IF K3 > FileLof&(K,12) THEN CALL FileCloseR(K) : _
                                EXIT DO
    CALL FileGetRec(K,K3,12,MsgIDX)
    K1 = FileOpenW(FileNames(2))
    CALL FileCloseR(K)
    K = 0
    K& = Message.MsgNum            'flag for if we got new Message.
'    K$ = o$(11 + (UserSL = LevelsSize)) + C13$
    K$ = o$(11 + (UserSL = LevelsSize))
    IF p <> 1 THEN K$ = K$ + C13$   'stop those login [enter]'s.
    IF K30 THEN MID$(K$,1,3) = C1$ + C1$ + C1$
    CALL DispMessage(MsgIDX.MsgLoc,9,o$(13) + K$,K1,0,K1$,K,K30$)
    K5 = TGot       '-1 for no key hit.
    IF K AND K5 = -1 AND K& <> Message.MsgNum THEN K0& = Message.MsgNum : _
                                                   CALL GiveRR(K3,K0&)
    '
    ' Some routines must have Message., so give it to them.  Doing for other
    ' commands just slows them down.
    '
    IF K5 > 1 THEN K5 = StrSrch1(c13$ + Chars$(9) + o$(10) + o$(104),K5) + 1
    SELECT CASE K5
      CASE 5, 6, 7, 8, 9, 13, 16, 17, 21, 23, 24, 25, 26, 27, 28
           IF K& = Message.MsgNum _
              THEN CALL FileGetLoc(K1,MsgIDX.MsgLoc,136,Message)
    END SELECT
    CALL FileCloseW(K1)
    '
    ' Update the high-message-read pointers if the message being read is greater
    ' than that they've seen.  Special situation: at logon--only want to update
    ' the private message bases, or the public areas only if the message at is
    ' the next unread message.
    '
    K = (MsgIDX.MsgNum > LongMid(UserMsgInfo$,BaseIndex * 4 + 1))
    IF p = 1 THEN IF NOT BitTest(MsgAreaI(BaseIndex + 1).SubType,2) _
                     THEN IF K3 <> K0 THEN K = 0
    IF K AND NOT NoCarrier _
       THEN MID$(UserMsgInfo$,BaseIndex * 4 + 1,4) = MKL$(MsgIDX.MsgNum)
    SELECT CASE K5
      CASE -1
           '
           ' Message completely sent.  List any file attaches, and display
           ' the command line.
           '
           IF BitTest(Message.Attr,12) THEN CALL ListFAs(K1)
           IF BitTest(User.Toggles,4) AND Message.MsgTo <> User.UserName _
              AND Message.MsgFrom <> User.UserName _
              THEN K5 = 1 _
              ELSE CALL ReadingCommandLine(K5,K1,p,k30) : _
                   IF K5 > 1 _
                      THEN K5 = StrSrch1(c13$ + Chars$(9) + o$(10) + o$(104),K5) + 1
    END SELECT
    IF NoCarrier THEN EXIT DO
    '
    ' Process the selected option.
    '
    SELECT CASE BitTest(Message.Attr,12)
      CASE -1
           SELECT CASE K5
             CASE 8  : IF User.UserName = Message.MsgFrom THEN K5 = 711
             CASE 27 : K5 = 712
             CASE 28 : K5 = 713
           END SELECT
    END SELECT
    '
    ' For when users do an option before the body of the message has been
    ' loaded.  These routines must have the message body.
    '
    SELECT CASE K5
      CASE 5, 6, 7, 13, 16, 21
           SELECT CASE LEN(K1$)
             CASE 0
                  CALL ReGetIDX2(K3,Message.MsgNum,K)
                  SELECT CASE K3
                    CASE IS <> 0
                         K1 = FileOpenR(FileNames(2))
                         CALL FileCloseR(K)
                         CALL FileGetLoc(K1,MsgIDX.MsgLoc,136,Message)
                         K = FileOpenR(FileNames(73))
                         CALL FileCloseR(K1)
                         K1$ = SPACE$(Message.NumOfBytes)
                         CALL FileGetSLoc(K,Message.MsgLoc,K1$)
                         CALL FileCloseR(K)
                         IF BitTest(Message.Attr,2) THEN K1$ = UnSq$(K1$)
                  END SELECT
           END SELECT
    END SELECT
    K6 = 0             'Flag for whether to find another msg, or redraw same.
    SELECT CASE K5
      CASE 1
           '
           ' Dummy flag for Continuous message reading.
           ' K4 is our direction flag: 1 for forward, -1 for reverse.
           '
           K6 = -1
      CASE 2, 3, 11
           '
           ' Next--go to next message.
           '
           TT = 20014
           CALL SendTT
           K4 = 1
           K6 = -1
           IF LEN(K1$) > 0 AND BitTest(Message.Attr,4) _
              AND NOT BitTest(MsgAreaI(BaseIndex + 1).SubType,3) _
              AND NOT BitTest(Message.Attr,5) _
              THEN CALL RemoveAMessage(K3,Message.MsgNum,K4)
      CASE 4
           '
           ' Delete--remove the message.  Ask first if user want's confirm
           ' or if it has file attaches.
           '
           K = (BitTest(User.Toggles2,3) OR BitTest(Message.Attr,12))
           IF K = 0 _
              THEN TT = 20015 : _
                   CALL SendTT : _
                   CALL RemoveAMessage(K3,Message.MsgNum,K4) _
              ELSE TT = 20016 : _
                   IF NOT GetYNTT THEN K4 = 0 _
                                  ELSE CALL RemoveAMessage(K3,Message.MsgNum,K4)
           K6 = -1
      CASE 5
           '
           ' Forward--forward the message to another user or area.
           '
           CALL ForwardNoteAdd(K3,K4,K1$)
           K6 = -1
      CASE 6
           '
           ' Edit--Search & Replace edit of the current message.
           '
           CALL EditSentMessage(K3,K4,K1$)
           K6 = -1
      CASE 7
           '
           ' Continue--continue a Finish-Later message.
           '
           CALL ContinueMessage(K3,K4,K1$)
           K6 = -1
      CASE 8
           '
           ' Send (user download) file attaches.
           '
           CALL SendFileAttach(K1,2)
           IF TGot = 1000 _
              THEN K1$ = MID$(TT$,54,40) : _
                   TT$ = o$(21) + RTRIM$(Form$(7908,MID$(TT$,20,34))) + o$(22) : _
                   IF BitTest(Message.Attr,14) THEN CALL ShellDownload(-3) : _
                                                    CALL FileAppendToLog(K1$) _
                                               ELSE CALL ShellDownload(3) : _
                                                    CALL FileAppendToLog(K1$)
      CASE 9
           '
           ' View a (text) file attach.
           '
           CALL SendFileAttach(K1,1)
      CASE 10
           '
           ' Again--re-display the message.
           '
           TT = 20027
           CALL SendTT
      CASE 12
           '
           ' Previous--read previous message.
           '
           TT = 20007
           CALL SendTT
           K4 = -1
           K6 = -1
           IF LEN(K1$) > 0 AND BitTest(Message.Attr,4) _
              AND NOT BitTest(MsgAreaI(BaseIndex + 1).SubType,3) _
              AND NOT BitTest(Message.Attr,5) _
              THEN CALL RemoveAMessage(K3,Message.MsgNum,K4)
      CASE 13
           '
           ' Reply--leave a message in reply to the current msg.
           '
           TT = 20024
           CALL SendTT
           K = ASC(Message.NumberReplies)
           IF K < 255 THEN Message.NumberReplies  = Chars$(K + 1)
           CALL ReGetIDX2(K3,Message.MsgNum,K1)
           IF K3 <> 0 THEN K2 = FileOpenW(FileNames(2)) : _
                           CALL FileCloseR(K1) : _
                           CALL FilePutLoc(K2,MsgIDX.MsgLoc,136,Message) : _
                           CALL FileCloseW(K2)
           K0$ = NCR$(Message.MsgFrom)
           IF K0$ <> o$(25) AND AscNull(K0$) <> 2 _
              AND NOT BitTest(MsgAreaI(BaseIndex + 1).SubType,3) _
              THEN K5 = BiSearch(2,0,Message.MsgFrom) : _
                   IF K5 < 2 THEN Message.MsgFrom = o$(26)
           K2$ = Message.MsgFrom
           K3$ = Message.MsgSubject
           CALL EnterMsg(0,4,K2$,K3$,K1$)
           CALL WhatDoing(4)
           CALL BlockToO(0,20)
           IF Message.MsgNum = 0 _
              THEN Message.NumberReplies = Chars$(K) : _
                   CALL ReGetIDX2(K3,Message.MsgNum,K1) : _
                   IF K3 <> 0 _
                      THEN K2 = FileOpenW(FileNames(2)) : _
                           CALL FileCloseR(K1) : _
                           CALL FilePutLoc(K2,MsgIDX.MsgLoc,136,Message) : _
                           CALL FileCloseW(K2)
      CASE 14
           '
           ' Quit--stop reading messages and exit.
           '
           K = ((NOT BitTest(User.Toggles,4)) OR (K5 = -1))
           SELECT CASE K
             CASE -1
                  TT = 20034
                  CALL SendTT
                  IF LEN(K1$) > 0 AND BitTest(Message.Attr,4) _
                     AND NOT BitTest(MsgAreaI(BaseIndex + 1).SubType,3) _
                     AND NOT BitTest(Message.Attr,5) _
                     THEN CALL RemoveAMessage(K3,Message.MsgNum,K4)
                  EXIT DO
           END SELECT
           K6 = -1
      CASE 16
           '
           ' Give a standard reply to tiring questions.
           '
           CALL SysopStandardReply(K3,K4,K1$)
           K6 = -1
      CASE 17
           '
           ' Move the message to another message area.
           '
           CALL ReLocateMessage(K3)
      CASE 18
           '
           ' Edit a (any) users record.
           '
           TT = 20028
           CALL SendTT
           CALL AlterTheUsersData(Null$)
           CALL BlockToO(0,20)
      CASE 19
           '
           ' Work with the Sysop's database.
           '
           TT = 20029
           CALL SendTT
           CALL DataBaser(-9,DirsSize)
           CALL BlockToO(0,20)
      CASE 21
           '
           ' Send the message, and user, to the Peer Review process.
           '
           CALL PRTheMessage(K3,K4,K1$)
           K6 = -1
      CASE 22
           '
           ' Duplicate the message into a text file.
           '
           TT = 20019
           K1$ = RTRIM$(LineEditTT$(40))
           CALL DispCRLF
           IF LEN(K1$) > 0 _
              THEN K = FileOpenW(K1$) : _
                   CALL DispMessage(MsgIDX.MsgLoc,-2,Null$,0,0,K1$,K,K30$) : _
                   CALL FileCloseW(K) : _
                   TT = 20020 : _
                   CALL SendTT
      CASE 23
           '
           ' Re-Set the user's mail-waiting flag.
           '
           CALL Inform
           K4 = 1
           K6 = -1
      CASE 24
           '
           ' Alter the message's header record.
           '
           CALL AlterTheMessagesData(K3)
      CASE 25
           '
           ' Delete all the file attaches for the message.
           '
           CALL DeleteAllFAs(0,Message.MsgNum,Message.MsgBase)
      CASE 26
           '
           ' Move all the file attaches for the message to another dir.
           '
           CALL MoveAllFAs(Message.MsgNum,Message.MsgBase)
      CASE 27, 28
           '
           ' BiModem or Zmodem detected.
           '
           EXIT DO
      CASE 711, 712, 713
           '
           ' Receive (user upload or console) file attaches.
           '
           IF K5 = 711 THEN TT = 20023 : _
                            CALL SendTT
           TGot = K5
           CALL DoFileAttach
      CASE ELSE
           '
           ' Get a message number to jump to.
           '
           CALL FindMessageByNum(p,K3,0)
           K3 = K3 - 1
           K6 = -1
    END SELECT
    IF K6 THEN CALL FindNextMsg(p,K3,K4,0,0)
    K = FindF(Form4$(10,BaseIndex + 1),FFile)
  LOOP UNTIL NoCarrier OR K3 < 1 OR K3 > FFile.FSize \ 12
  K = FindF(Form4$(10,BaseIndex + 1),FFile)
  CALL WhatDoing(0)
  IF p = 1 THEN EXIT SUB
  IF K3 > FFile.FSize \ 12 THEN TT = 20030 : _
                                CALL SendTT
  IF K3 < 1 THEN TT = 20031 : _
                 CALL SendTT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This subroutine, internal to ReadMessages, handles the
        ' process of Finishing-later a message.
        '
        ' p   .IDX record number
        '
        ' p0  directional flag
        '
        ' p$  message body
        '
        ' Current message must be loaded in Message.
        '
        ' Date last checked for perfection: Aug 1 1993
        '
SUB ContinueMessage (p,p0,p$)

  TT = 20036
  CALL SendTT
  IF DriveSpc&(FileNames(2)) < Settings.MinSpace THEN TT = 20037 : _
                                                      CALL SendTT : _
                                                      EXIT SUB
  K& = Message.MsgNum
  Message.MsgNum = MsgAreaI(Message.MsgBase + 1).NextNumber  'for Preview.
  Message.MsgDateSent = SumLog.DateOn
  GlobalStuff$(20) = Message.MsgTo
  CALL BitClear(Message.Attr,13)
  CALL StripExtras(p$)
  WHILE RIGHT$(p$,3) = C13$ + C13$ + C13$
    p$ = ChopRight1$(p$)
  WEND
  CALL EnterMsg(1,0,C0$,Null$,p$)   '.MsgNum = 0 if aborted.
  CALL WhatDoing(4)
  CALL BlockToO(0,20)
  IF Message.MsgNum = 0 THEN p = p - p0 : _
                             EXIT SUB
  '
  ' Remove/move/etc. the old message.
  '
  IF BitTest(Message.Attr,12) _
     THEN CALL MoveDirectory(K&,Message.MsgBase,Message.MsgNum)
  CALL RemoveAMessage(p,K&,p0)
  K = FileOpenW(FileNames(3))
  K0 = BiSearch(5,0,Message.MsgTo)
  SELECT CASE K0
    CASE IS > 1
         '
         ' Undo the inform if they haven't read their first message yet.
         '
         K$ = UserMsgInfo$
         K1 = BasesSize * 4 + Message.MsgBase + 5
         K& = 1& * (K0 - 1) * LEN(K$)
         CALL FileGetSLoc(K,K&,K$)
         K2 = AscMid(K$,K1)
         IF K2 > 1 THEN MID$(K$,K1,1) = Chars$(K2 - 1)
         CALL FilePutSLoc(K,K&,K$)
  END SELECT
  CALL FileCloseW(K)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to ReadMessages, handles the
        ' sending back of a Reception Report (Return Receipt)
        ' that a message has been received and read.
        '
        ' p   .idx record number
        '
        ' p&  message number
        '
        ' Current message must be loaded in Message. and MsgIDX.
        '
        ' These receipts are only done if: the message was received,
        ' and it was received fully (which presumes that it then was
        ' read)--thus, received and read.  They are not sent if the
        ' user read the messages with an off-line reader--considered
        ' very rare, since the message was TO: them and they would get
        ' it at login.
        '
        ' Date last checked for perfection: Aug 1 1993
        '
SUB GiveRR (p,p&)

  CALL BitClear(Message.Attr,16)
  CALL ReGetIDX2(p,p&,K)
  IF p = 0 THEN EXIT SUB
  K0 = FileOpenW(FileNames(2))
  CALL FilePutLoc(K0,MsgIDX.MsgLoc,136,Message)
  CALL FileCloseW(K0)
  CALL FileCloseR(K)
  K$ = o$(39) + C13$ + C32$ + C13$ + o$(40) + _
       LEFT$(MsgAreaInfo3$(Message.MsgBase + 1,2),22) + o$(41) + _
       LongToStr$(Message.MsgNum) + o$(42) + _
       IntToDate3$(Message.MsgDateSent)
  K$ = K$ + Form$(966,RightTime$(IntToTime$(Message.MsgTimeSent))) + o$(43) + _
       LEFT$(UnSq$(RTRIM$(Message.MsgSubject)),30) + C13$ + C32$ + C13$ + _
       o$(44) + NCR$(Message.MsgTo) + o$(45) + _
       IntToDate3$(Message.MsgDateRcvd) + _
       Form$(932,RightTime$(IntToTime$(Message.MsgTimeRcvd))) + o$(46)
  Message.Attr = 0
  Message.MsgTo = Message.MsgFrom
  CALL AddAMessage(2,K$,0,0)
  CALL ReGetIDX2(p,p&,K)
  IF p = 0 THEN EXIT SUB
  K0 = FileOpenR(FileNames(2))
  CALL FileGetLoc(K0,MsgIDX.MsgLoc,136,Message)
  CALL FileCloseR(K0)
  CALL FileCloseR(K)
  TGot = -1

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to ReadMessages, handles the
        ' displaying of the reading messages command line, and
        ' waits for input.
        '
        ' p   returns with the key hit.
        '
        ' p0  number of file attaches to this message.
        '
        ' p1  what type of message reading we're doing.
        '
        ' TGot$ returns with any message number if that's what they
        ' entered.
        '
        ' Current message must be loaded in Message. and MsgIDX.
        '
        ' Date last checked for perfection: Aug 1 1993
        '
SUB ReadingCommandLine (p,p0,p1,k30)

  DO
    IF UserSL = LevelsSize AND p = 63 _
       THEN TT$ = o$(47) _
       ELSE IF UserSL = LevelsSize THEN TT$ = o$(48) _
                                   ELSE TT$ = Null$
    K = 0
    K$ = o$(11 + (UserSL = LevelsSize))
    IF Message.MsgFrom = User.UserName OR Message.MsgTo = User.UserName _
       THEN CALL BitSet(K,1)
    IF NOT K30 THEN CALL BitSet(K,2)
    IF (BitTest(K,1) AND NOT BitTest(MsgAreaI(BaseIndex + 1).SubType,5)) _
       OR BitTest(K,2) _
       THEN TT$ = TT$ + o$(50) _
       ELSE MID$(K$,1,2) = C1$ + C1$
    IF K <> 0 THEN TT$ = TT$ + o$(52) _
              ELSE MID$(K$,3,1) = C1$
    IF BitTest(Message.Attr,13) AND User.UserName = Message.MsgFrom _
       THEN TT$ = TT$ + o$(54) _
       ELSE MID$(K$,4,1) = C1$
    IF NOT BitTest(Message.Attr,12) _
       THEN MID$(K$,5,2) = C1$ + C1$ _
       ELSE IF User.UserName <> Message.MsgFrom _
               THEN TT$ = TT$ + o$(57 + (p0 = 1)) _
               ELSE TT$ = TT$ + o$(58)
    IF (NOT BitTest(Message.Attr,12)) AND (UserSL = LevelsSize) _
       THEN MID$(K$,22,2) = C1$ + C1$
    TT$ = o$(59) + K$ + o$(60) + TT$ + o$(61) + o$(63 + (p1 <> 4))
    CALL GetNumPlusTT(K$ + Chars$(9))
    IF Val2&(TGot$) > 0 THEN p = 0 _
                        ELSE p = AscNull(TGot$) : _
                             IF p = 0 THEN p = 78
  LOOP UNTIL p <> 63 OR NoCarrier

END SUB
        '
        '* * * *



        '* * * * * *
        ' This routine, internal to ReadMessages, returns some info
        ' about the message area and the user's status within it.
        '
        ' p    type of message reading being done
        '
        ' p0   index record of first message new to user in this area.
        '
        ' p1   index record of first message user sent or received in
        '      this area.
        '
        ' p2   index record of first message TO the user in this area.
        '
        ' p&   size of index file
        '
        ' p0&  last message number read in this area
        '
        ' p3   0 if should open MESSAGES.HDR, otherwise handle of
        '      already-opened file.
        '
        ' Date last checked for perfection: Aug 1 1993
        '
SUB UserMsgAreaInfo (p,p0,p1,p2,p&,p0&,p3)

  p0 = -1
  p1 = -1
  p2 = -1
  K& = 0
  K = StrCkSum(User.UserName)
  K0 = 0
  K$ = SPACE$(30)
  K0$ = SPACE$(60)
  K1 = 6144
  IF K& + 6144 <= p& THEN K1$ = SPACE$(6144)
  IF p3 = 0 THEN K2 = FileOpenR(FileNames(2)) _
            ELSE K2 = p3
  K3 = FileOpenR(Form4$(10,BaseIndex + 1))
  DO
    IF K& + 6144 > p& THEN K1 = p& - K& : _
                           K1$ = SPACE$(K1)
    CALL FileGetSLoc(K3,K&,K1$)
    K& = K& + K1
    K4 = 1
    WHILE K4 > 0 AND K4 < K1
      K0 = K0 + 1
      IF p0 = -1 THEN IF LongMid(K1$,K4 + 4) > p0& THEN p0 = K0
      IF p = 1 _
         THEN IF p0 <> -1 AND p2 = -1 AND K = IntMid(K1$,K4 + 8) _
                 THEN CALL FileGetSLoc(K2,LongMid(K1$,K4) + 36,K$) : _
                      IF User.UserName = K$ THEN p2 = K0
      IF p = 0 _
         THEN IF p1 = -1 AND (K = IntMid(K1$,K4 + 8) OR K = IntMid(K1$,K4 + 10)) _
                 THEN CALL FileGetSLoc(K2,LongMid(K1$,K4) + 6,K0$) : _
                      IF User.UserName = LEFT$(K0$,30) _
                         OR User.UserName = RIGHT$(K0$,30) THEN p1 = K0
      IF p0 > 0 THEN IF (p1 > 0 OR p <> 0) AND (p2 > 0 OR p <> 1) THEN K4 = -13
      K4 = K4 + 12
    WEND
  LOOP UNTIL K4 = -1 OR K& = p&
  IF p3 = 0 THEN CALL FileCloseR(K2)
  CALL FileCloseR(K3)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to ReadMessages, lists which files
        ' are attached to the message.
        '
        ' p   returns with the number of files attached.
        '
        ' Current message must be loaded in Message.
        '
        ' Date last checked for perfection: Aug 1 1993
        '
SUB ListFAs (p)

  p = 0
  TT$ = Null$
  K$ = Paths$(5) + LongToStr$(Message.MsgNum) + o$(46) + _
       IntToStr$(Message.MsgBase + 1) + o$(64)
  K = FindF(K$,FFile)
  WHILE K <> 0
    TT$ = TT$ + o$(65) + Form$(1201,FFile.FName) + o$(66) + _
          Form$(1266,Commas$(FFile.FSize)) + o$(67)
    IF BitTest(Message.Attr,14) THEN TT$ = TT$ + o$(68) _
                                ELSE TT$ = TT$ + C1310$
    K = FindF(Null$,FFile)
    p = p + 1
  WEND
  IF p > 0 THEN TT$ = o$(70 + (p = 1)) + TT$ + C1310$ : _
                CALL SendTT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to ReadMessages, finds the next
        ' message to display.
        '
        ' p   type of message reading being done
        '
        ' p0  .idx record number
        '
        ' p1  direction flag being used.
        '
        ' p2  0 if should open MESSAGES.HDR, otherwise handle of the
        '     already-opened file.
        '
        ' p2  0 if should open MSGS_.IDX, otherwise handle of the
        '     already-opened file.
        '
        ' Uses BaseIndex to determine which message area working with.
        '
        ' Date last checked for perfection: Aug 5 1993
        '
SUB FindNextMsg (p,p0,p1,p2,p3)

  K = StrCkSum(User.UserName)
  IF p2 = 0 THEN K0 = FileOpenR(FileNames(2)) _
            ELSE K0 = p2
  IF p3 = 0 THEN K1 = FileOpenR(Form4$(10,BaseIndex + 1)) _
            ELSE K1 = p3
  K2 = FileLof&(K1,12)
  DO
    p0 = p0 + p1
    IF p0 < 1 OR p0 > K2 THEN EXIT DO
    CALL FileGetRec(K1,p0,12,MsgIDX)
    SELECT CASE p
      CASE 0, 1
           '
           ' Find next message TO user (p = 1) or TO/FROM user (p = 0)
           '
           IF K = MsgIDX.MsgTo _
              THEN CALL FileGetLoc(K0,MsgIDX.MsgLoc,136,Message) : _
                   IF Message.MsgTo = User.UserName THEN EXIT DO
           IF p = 0 AND K = MsgIDX.MsgFrom _
              THEN CALL FileGetLoc(K0,MsgIDX.MsgLoc,136,Message) : _
                   IF Message.MsgFrom = User.UserName THEN EXIT DO
      CASE ELSE
           '
           ' Find the next message.
           '
           CALL FileGetLoc(K0,MsgIDX.MsgLoc,136,Message)
           EXIT DO
    END SELECT
  LOOP UNTIL (NoCarrier AND p2 = 0)
  IF p3 = 0 THEN CALL FileCloseR(K1)
  IF p2 = 0 THEN CALL FileCloseR(K0)

END SUB
        '
        '* * * *


'the routines below here are used in other overlays as well.


'p = 0 to ask for confirmation
'    1 to just do it
'p&  message number
'p0  message area
SUB DeleteAllFAs (p,p&,p0)

  IF p = 0 THEN TT = 20107 : _
                IF NOT GetYNTT THEN EXIT SUB
  K$ = MakePathName$(p&,p0 + 1)
  K = FindF2(K$ + Short$(645),FFile)
  WHILE K <> 0
    CALL KillFile(K$ + FFile.FName)
    K = FindF2(K$ + Short$(645),FFile)
  WEND
  CALL DirDelete(K$)

END SUB


        '* * * * * *
        ' This routine will delete a message.
        '
        ' p   is the location of the message to remove.  (last known
        '     location)
        '
        ' p&  is the message number to be removed.
        '
        ' p0  direction flag being used.
        '
        ' Uses BaseIndex to determine which message area working with.
        '
        ' Does not alter Message., but does alter MsgIDX.
        '
        ' [Leave this in READMSGS.BAS because putting it in
        ' READMSG2.BAS just makes it look really slow and user will
        ' want to hit [Enter] after doing a delete.]
        '
        ' Date last checked for perfection: Aug 5 1993
        '
SUB RemoveAMessage (p,p&,p0)

  IF p < 1 THEN EXIT SUB
  CALL ReGetIDX(p,p&,K)
  IF p = 0 THEN EXIT SUB
  K0 = FileOpenW(FileNames(2))
  K$ = SPACE$(116)
  CALL FileGetSLoc(K0,MsgIDX.MsgLoc,K$)
  K1 = IntMid(K$,1)
  CALL BitSet(K1,1)
  CALL FilePutSLoc(K0,MsgIDX.MsgLoc,MKI$(K1))
  CALL FileCloseW(K0)
  CALL CutOut(K,Null$,p * 12& - 11,12&)
  CALL FileCloseW(K)
  IF p0 = 0 THEN p0 = 1
  p = p - p0
  IF BitTest(K1,12) THEN CALL DeleteAllFAs(1,LongMid(K$,3),IntMid(K$,115))

END SUB
        '
        '* * * *


        '* * * * * *
        ' This subroutine locates a message given it's message number.
        '
        ' p   what type message reading we're doing.
        '
        ' p0  returns with the .idx record number.
        '
        ' p1  what to do:
        '     1 at New/Message number line
        '     0 at reading messages command line
        '     2 at NetMail .IDX processing
        '
        ' Uses BaseIndex to determine what area to use.
        '
        ' Date last checked for perfection: Aug 5 1993
        '
SUB FindMessageByNum (killme1,p0,p1)

  K = FileOpenR(Form4$(10,BaseIndex + 1))
  K& = FileLof&(K,1)
  IF K& < 12 THEN CALL FileCloseR(K) : _
                  p0 = -1 : _
                  EXIT SUB
  K0& = Val2&(TGot$)
  CALL FileGetLoc(K,K& - 12,12,MsgIDX)
  SELECT CASE K0&
    CASE 0, IS > MsgIDX.MsgNum
         IF p1 = 1 THEN TT = 20033 + (K0& = 0) : _
                        p0 = -1 _
                   ELSE TT = 20035 + (K0& = 0)
         IF p1 <> 2 THEN CALL SendTT
    CASE ELSE
         IF p1 = 1 THEN CALL DispCRLF : _
                        CALL DispCRLF
         K1& = 0
         K0 = 3072
         IF K1& + 3072 <= K& THEN K$ = SPACE$(3072)
         K1 = 0
         DO
           IF K1& + 3072 > K& THEN K0 = K& - K1& : _
                                   K$ = SPACE$(K0)
           CALL FileGetSLoc(K,K1&,K$)
           K1& = K1& + K0
           K2 = 17
           K2& = LongMid(K$,5)
           K1 = K1 + 1
           WHILE K2& < K0& AND K2 < K0
             K2& = LongMid(K$,K2)
             K2 = K2 + 12
             K1 = K1 + 1
           WEND
         LOOP UNTIL K2& >= K0& OR K1& = K&
         IF K2& >= K0& THEN p0 = K1
  END SELECT
  CALL FileCloseR(K)

END SUB
        '
        '* * * *


        '* * * * * *
        ' This subroutine, internal to ReadMessages, re-locates
        ' an index record.
        '
        ' p   returns with the .IDX record number
        '     returns 0 if record not found (also closes the .IDX file).
        '
        ' p&  is the message number we're looking for.
        '
        ' p0  returns with the handle of the already-opened .IDX file.
        '
        ' Uses BaseIndex to determine what area to use.
        '
        ' Date last checked for perfection: Aug 1 1993
        '
SUB ReGetIDX (p,p&,p0)

  p0 = FileOpenWDA(Form4$(10,BaseIndex + 1))
  FOR K = p TO 1 STEP -1
    CALL FileGetRec(p0,K,12,MsgIDX)
    IF MsgIDX.MsgNum = p& THEN EXIT FOR
  NEXT
  IF K = 0 THEN CALL FileCloseW(p0)
  p = K

END SUB
        '
        '* * * *

