' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.
'
'Various internal routines:
'  CanDL&
'  DLTime
'  FAccessAllowed
'  MappedSL
'  MAccessAllowed
'  NextArea
'  InList




        '* * * * * *
        ' This routine calculates what the user can download in bytes.
        '
        ' Date last checked for perfection: Sep 21 1992
        '
FUNCTION CanDL&

  SELECT CASE User.ULBytes
    CASE IS <= 0 : K = UserSL
    CASE ELSE
         K = UserSL + 1
         DO
           K = K - 1
           K& = User.ULBytes * Levels(K).BRatio
         LOOP UNTIL K& > 0 OR K = 1
  END SELECT
  CanDL& = User.ULBytes * Levels(K).BRatio - User.DLBytes - User.MinMegs * Settings.ExchBytes

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' Calculate the download/door minutes user has left today.
        '
        ' Date last checked for perfection: Nov 6 1992
        '
FUNCTION DLTime%
  DLTime% = Levels(UserSL).DLMinsPerDay + User.MinCredits - User.Elapsed
END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine returns the next or previous message or file
        ' area that the current user can access.
        '
        ' p  What to do:
        '     1 to go to next file area
        '    -1 to go to previous file area
        '     2 to go to next message area
        '    -2 to go to previous message area
        '
        ' p0 Maximum size to use
        '
        ' FileIndex is relied upon and returns the next file area, or
        ' doesn't change.
        '
        ' BaseIndex is relied upon and returns the next message area,
        ' or doesn't change.
        '
        ' 32767 goes to first area or last area depending on selection.
        '
        ' SL level is based on Scan level for the area.
        '
        ' It's up to the calling routine to match what was sent to
        ' determine if at a quit/end/start point.
        '
        ' Date last checked for perfection: Nov 6 1992
        '
SUB NextArea (p,p0)

  SELECT CASE p
    CASE 1
         SELECT CASE FileIndex
           CASE IS < 1, IS > p0
                FOR K0 = 1 TO p0
                  IF FAccessAllowed(K0) THEN FileIndex = K0 : _
                                             EXIT FOR
                NEXT
           CASE ELSE
                K0 = FileIndex
                DO
                  FileIndex = FileIndex + 1
                  IF FileIndex > p0 THEN FileIndex = 1
                LOOP UNTIL FAccessAllowed(FileIndex) OR FileIndex = K0
         END SELECT
    CASE -1
         SELECT CASE FileIndex
           CASE IS < 1, IS > p0
                SELECT CASE p0
                  CASE IS > 0
                       K0 = p0
                       DO
                         IF FAccessAllowed(K0) THEN FileIndex = K0 : _
                                                    EXIT DO
                         K0 = K0 - 1
                       LOOP UNTIL K0 = 0
                END SELECT
           CASE ELSE
                K0 = FileIndex
                DO
                  FileIndex = FileIndex - 1
                  IF FileIndex = 0 THEN FileIndex = p0
                LOOP UNTIL FAccessAllowed(FileIndex) OR FileIndex = K0
         END SELECT
    CASE 2
         SELECT CASE BaseIndex
           CASE IS < 0, IS > p0
                FOR K0 = 0 TO p0
                  IF MAccessAllowed(K0) THEN BaseIndex = K0 : _
                                             EXIT FOR
                NEXT
           CASE ELSE
                K0 = BaseIndex
                DO
                  BaseIndex = BaseIndex + 1
                  IF BaseIndex > p0 THEN BaseIndex = 0
                LOOP UNTIL MAccessAllowed(BaseIndex) OR BaseIndex = K0
         END SELECT
    CASE -2
         SELECT CASE BaseIndex
           CASE IS < 0, IS > p0
                SELECT CASE p0
                  CASE IS >= 0
                       K0 = p0
                       DO
                         IF MAccessAllowed(K0) THEN BaseIndex = K0 : _
                                                    EXIT DO
                         K0 = K0 - 1
                       LOOP UNTIL K0 = -1
                END SELECT
           CASE ELSE
                K0 = BaseIndex
                DO
                  BaseIndex = BaseIndex - 1
                  IF BaseIndex = -1 THEN BaseIndex = p0
                LOOP UNTIL MAccessAllowed(BaseIndex) OR BaseIndex = K0
         END SELECT
  END SELECT

END SUB
        '
        '* * * *




        '* * * * * *
        ' Check to see if the user has access to a file area.
        '
        ' p  file area to check
        '
        ' returns with 0 if no access allowed, or -1 if they can
        ' access the area.
        '
        ' Access is based on the file area's ScanSL, or whether
        ' they are undergoing Peer Review.
        '
        ' Date last checked for perfection: Sep 21 1992
        '
FUNCTION FAccessAllowed% (p)

  IF p < 1 OR p > DirsSize THEN FAccessAllowed% = 0 : _
                                EXIT FUNCTION
  '
  ' The user must have an SL at least that of the file area's ScanSL.
  ' If the user is undergoing Peer Review, then the area must have
  ' the PRL flag set for them to have access.
  '
  IF Levels(UserSL).SecLevel < FileAreaI(p).ScanSL THEN FAccessAllowed% = 0 _
                                                   ELSE FAccessAllowed% = -1

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' Check to see if the user has access to a message area.
        '
        ' p  message area to check
        '
        ' returns with 0 if no access allowed, or -1 if they can
        ' access the area.
        '
        ' Access is based on the message area's ScanSL, or whether
        ' they have it toggled OFF, or are locked out.
        '
        ' Date last checked for perfection: Sep 21 1992
        '
FUNCTION MAccessAllowed% (p)

  IF p < 0 OR p > BasesSize THEN MAccessAllowed% = 0 : _
                                 EXIT FUNCTION
  '
  ' The user must have an SL at least that of the message area's ScanSL.
  ' Areas that the user is locked out of or has turned off are considered
  ' inaccessible.
  '
  IF (Levels(UserSL).SecLevel < MsgAreaI(p + 1).ScanSL) _
     OR (LongMid(UserMsgInfo$,p * 4 + 1) < 0) _
     THEN MAccessAllowed% = 0 _
     ELSE MAccessAllowed% = -1

END FUNCTION
        '
        '* * * *





        '* * * * * *
        ' This routine finds the SL given the SL value (eg. given 5 it
        ' returns 1, because the SL of one has a defined value of 5 to
        ' 9 (2 = 10 to 19, etc.) as defined in SETUP.INI.
        '
        ' p  is the SL value to match.
        '
        ' returns with the SL that the SL value matches.
        '
        ' Date last checked for perfection: Sep 21 1992
        '
FUNCTION MappedSL% (p)

  K0 = LevelsSize
  SELECT CASE LevelsSize
    CASE IS > 1
         DO
           SELECT CASE p
             CASE IS < 0 : IF (- p) >= Levels(K0).ShowLevel THEN EXIT DO
             CASE ELSE   : IF p >= Levels(K0).SecLevel THEN EXIT DO
           END SELECT
           K0 = K0 - 1
         LOOP UNTIL K0 = 1
  END SELECT
  MappedSL = K0

END FUNCTION
        '
        '* * * *

'make this a function.
'p = fileindex
'p0 returns with number 1..n in a range of file areas the user can access.
'assumes that the user can access the current area. (or else it will return
'zero or 1 less than the actual area).
FUNCTION MappedFileArea% (p)

  k0 = 0
  FOR K = 1 TO p
    IF FAccessAllowed(K) THEN k0 = k0 + 1
  NEXT
  MappedFileArea% = k0

END FUNCTION

'See if p$ is in p0$
'p$ must contain no spaces
'p0$ must be a list of words separated by one or more spaces.
'p = 
'   1  uppercase's both strings then searches for exact match.
'returns -1 if found, 0 if not.
'   2  uppercase's both strings and searchs for matching first part.
'      (eg. search for AMAZING and will locate if word is AMAZ)
'      (opposite of 4)
'returns -1 if found, 0 if not.
'   3  searches for a word in p0$ at the end of the p$ word.
'   4  searches for a word in p0$ at the front of the p$ word.
'w/ 2&3&4 p might get changed, but the calling routine should be using a solid
'unchangeable number so it shouldn't matter.
FUNCTION InList% (p,p$,p0$)

  SELECT CASE p
    CASE 1 : K = (StrSrch(1,C32$ + UCASE$(p0$) + C32$,C32$ + UCASE$(p$) + C32$) > 0)
    CASE 2, 3, 4
         K0 = LEN(p$) + 1
         IF K0 < 4 THEN K = 0 : _
                        p = 0
         SELECT CASE p
           CASE 2
                K$ = C32$ + UCASE$(p$)
                K0$ = C32$ + UCASE$(p0$)
                FOR K = 4 TO K0
                  IF StrSrch(1,K0$,LEFT$(K$,K)) > 0 THEN K = -1 : _
                                                         EXIT FOR
                NEXT
                IF K <> -1 THEN K = 0
           CASE 3
                K$ = p$ + C32$
                K0$ = C32$ + p0$ + C32$
                FOR K = 4 TO K0
                  IF StrSrch(1,K0$,C32$ + RIGHT$(K$,K)) > 0 THEN K = K - 1 : _
                                                                 EXIT FOR
                NEXT
                IF K > K0 THEN K = 0
           CASE 4
                K$ = C32$ + p$
                K0$ = C32$ + p0$ + C32$
                FOR K = 4 TO K0
                  IF StrSrch(1,K0$,LEFT$(K$,K) + C32$) > 0 THEN K = K - 1 : _
                                                                EXIT FOR
                NEXT
                IF K > K0 THEN K = 0
         END SELECT
  END SELECT
  InList% = K

END FUNCTION



'given a group name (or number), return it's group number and name
'returns 0 for no match
SUB GroupMapper (p$,p,p0$)

  p = 0
  p0$ = Null$
  IF LEN(p$) = 0 THEN EXIT SUB
  K = FileOpenR(FileNames(63))
  SELECT CASE LEN(p$)
    CASE 1 TO 3
         p = Val2&(p$)
         IF p > 0 AND LEN(IntToStr$(p)) = LEN(p$) _
            THEN IF p > FileLof&(K,30) THEN p = 0
  END SELECT
  p0$ = SPACE$(30)
  SELECT CASE p
    CASE 0
         K$ = Null$
         K0 = 0
         K& = 0
         WHILE K& < FileLof&(K,1) AND K& >= 0
           K0 = K0 + 1
           CALL FileGetSLoc(K,K&,p0$)
           K& = K& + 30
           IF UCASE$(p0$) = Form$(3001,UCASE$(p$)) THEN K& = -1
           IF StrSrch(1,UCASE$(p0$),UCASE$(p$)) > 0 _
              THEN K$ = K$ + p0$ + MKI$(K0)
         WEND
         IF K& < 0 THEN p = K0 _
                   ELSE IF LEN(K$) <> 32 THEN p0$ = Null$ _
                                         ELSE p0$ = LEFT$(K$,30) : _
                                              p = IntMid(K$,31)
    CASE ELSE
         CALL FileGetSLoc(K,(p - 1) * 30&,p0$)
  END SELECT
  CALL FileCloseR(K)

END SUB


'maybe make a function
'given a group number, decide if user is in it (if not, p -> 0, otherwise
'nothing changes (p>0)
SUB InGroup (p,p$)

  K = FileOpenR(FileNames(64))
  K& = 0
  K0& = FileLof&(K,1)
  K$ = Form3$(p) + C1$ + Form$(3001,UCASE$(p$)) + C1310$
  DO : K0 = StrSrch(1,FileGetBlock$(K,K&,K0&),K$)
  LOOP UNTIL K& = K0& OR K0 > 0
  CALL FileCloseR(K)
  p = K0

END SUB




'p returns -2 if post/call ratio is out of balance
'  returns -3 if files ratio is out of balance
'  otherwise doesn't change p
SUB RatiosCheck (p)

  kz = 0
  IF Levels(UserSL).PCRatio > 0 THEN Kz = 1
  SELECT CASE kz
    CASE 1
         kz1 = User.Logons
         kz2 = User.MsgsPosted
         WHILE kz1 > Levels(UserSL).PCRatio
           kz1 = kz1 - Levels(UserSL).PCRatio
           kz2 = kz2 - 1
         WEND
         IF kz2 < 0 THEN p = -2 : _
                         EXIT SUB
  END SELECT
  IF Levels(UserSL).FRatio > 0 THEN Kz = 2
  SELECT CASE kz
    CASE 2
         kz1 = User.Dnlds
         kz2 = User.Uplds
         WHILE kz1 > Levels(UserSL).FRatio
           kz1 = kz1 - Levels(UserSL).FRatio
           kz2 = kz2 - 1
         WEND
         IF kz2 < 0 THEN p = -3
  END SELECT

END SUB

