' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.




'theory of operation:
'  strings are processed by 'groups': GIP codes, ANSI codes, LINES.TXT codes.
'  normal text is held until: text end, ASCII 13, 19, 20, 27
'  only normal text output is tested for incoming stop/exit keys.
'if commport = 0 then we have AnsiProcess and DoGIPForBBS short circuit itself,
'so no real need to do that at this level.
'a bittest for whether to send to the screen need only be done after each
'commin
'it now only does character pacing when there is a chance for the user to hit
'a key while the text is displayed.


'Best to use +|keys|
'rather than |keys|+
'the reason is because the pause-allowed won't be checked during the keyboard
'check just after defining the valid stop and exit keys--so a pause gets
'ignored as an invalid key.  You would think rare, right?  Nope, turns out
'that because disk activity probably occured just before this, that the user
'could quite easily have hit the space bar during that pause--about 50% for
'LstF--because that's the time it takes to load and the other 50% of the time
'is the time it takes to draw.
'
'problem is right, but the solution merely reverses the problem: space bar 
'acts instantly, keys only 50% of the time.
'
'so I put in k99 to not do a key check after + or ||
'
'the problem with this, however, is that it must wait until the following
'text is sent before noticing a key.  And that text is noticable if you've
'just hit a key and are waiting for it to react.
'
'So, assuming I follow the standard of +|keys|  I should be OK if I
'only disable the check for after +'s.




        '* * * * * *
        ' This routine will output text to comm and screen.
        '
        ' TT$  is the string to output (includes other information).
        '
        ' TT   is the LINES.xxx referenced string to use (overrides
        '      TT$).
        '
        ' TGot$ = NULL if string completely outputed, otherwise = the
        ' valid key hit.
        '
        ' TGot = -1 if string completely outputed, otherwise = the
        ' valid key hit.
        '
        ' The above are global, making them parameters uses too much
        ' unnecessary space.
        '
        ' The initial logic is so:  IF TT = 0 THEN use TT$
        '                                     ELSE get TT$ based on TT
        '
        ' A loss of carrier returns TGot$ = C13$ and TGot = 13 (as if
        ' the user hit [Enter]--which by design aborts most things, or
        ' issues the 'no' default to a question).
        '
        ' Rather than the awkward '|' + C13$ + '|' just use a '~' to
        ' represent a C13$ (that [Enter] is a valid option).
        ' Example: '|~|'.
        '
        ' Date last checked for perfection: Sep 16 1992
        '
SUB SendTT

  CALL IDTT
  KK$ = TT$
  CALL SendIt(KK$)

END SUB


'p$ is altered if there is object display codes in the string.
SUB SendIt (p$)
 
  K$ = Null$                           'Stop/exit keys.
  K0 = BitTest(Settings.Toggles2,2)    'Send to screen on/off status.
  K1 = BitTest(User.Toggles,15)        'Avatar on/off status.
  K2 = 0                               '-1, Pause allowed.
  K3 = 0                               '-1, Look for abort keys.
  TGot$ = Null$                        'Exit with a Null.
  TGot = -1                            'Exit with a -1.
  K = 1                                'Pointer in p$.
  K4 = LEN(p$)                         'Length of p$.
  K5 = 1                       'Start of normal text to output next in string.
  K6 = 0                       'Length of normal text to output next in string.
  WHILE K <= K4                        'Do until reach the end.
    SELECT CASE AscMid(p$,K)
      CASE 10
           '
           ' CR/LF -- for files without ANSI/GIP codes.
           '
           CALL SendItDo(MID$(p$,K5,K6 + 1),K0,K1)
           IF K3 THEN CALL SendItInCk(K2,K4,K,K$,K0)
           K = K + 1
           K5 = K
           K6 = 0
      CASE 27
           '
           ' ANSI display codes.
           '
           IF K6 > 0 THEN CALL SendItDo(MID$(p$,K5,K6),K0,K1) : _
                          IF K3 THEN CALL SendItInCk(K2,K4,K,K$,K0)
           IF K < K4 THEN CALL AnsiProcessor(p$,K0$,K1$,K) : _
                          CALL SendItDo2(K0$,K1$,K0)
           K5 = K
           K6 = 0
      CASE 19
           '
           ' GIP graphics codes.
           '
           IF K6 > 0 THEN CALL SendItDo(MID$(p$,K5,K6),K0,K1) : _
                          IF K3 THEN CALL SendItInCk(K2,K4,K,K$,K0)
           K$ = Null$                      'No stop/exit keys with GIP.
           IF K < K4 THEN CALL DoGIPForBBS(p$,K,K0$,K1$) : _
                          CALL SendItDo2(K0$,K1$,K0)
           K5 = K
           K6 = 0
           IF LEN(GlobalStuff$(26)) > 0 _
              THEN p$ = LEFT$(p$,K - 1) + Chars$(19) + Chars$(255) + C0$ + _
                        Chars$(59) + GlobalStuff$(26) + Chars$(19) + _
                        Chars$(255) + Chars$(CommPort) + Chars$(59) + _
                        MID$(p$,K) : _
                   K4 = LEN(p$) : _
                   GlobalStuff$(26) = Null$
      CASE 20
           '
           ' A '' smart designator was found.
           '
           IF K6 > 0 THEN CALL SendItDo(MID$(p$,K5,K6),K0,K1) : _
                          IF K3 THEN CALL SendItInCk(K2,K4,K,K$,K0)
           K0$ = Null$
           K = K + 1
           IF K <= K4 THEN K7 = AscMid(p$,K) _
                      ELSE K7 = 0
           k99 = 0
           SELECT CASE K7
             CASE 62 : K0$ = C1310$                   '>  CR/LF.
             CASE 124                                 '|  Define abort keys.
                  K7 = StrSrch2(K,p$,124)
                  IF K7 > 0 THEN K$ = MID$(p$,K + 1,K7 - K - 1) : _
                                 K3 = -1 : _
                                 K = K7 : _
                                 CALL ReplaceCharacters(K$,126,Null$,13)
             CASE 33 : K0$ = Form$(20,Settings.Sysop) '!  Sysop's first name.
             CASE 63 : K0$ = Form$(20,User.UserName)  '?  User's first name.
             CASE 42 : IF NOT NoCarrier THEN CALL Delay  '*  Pause 1 second.
             CASE 43 : K2 = -1                        '+  Pause allowed.
                       K3 = -1
                       k99 = -1
             CASE 45                                  '-  Draw 'top box'.
                  K0$ = Short$(380) + STRING$(Val3(p$,K + 1),196) + _
                        Chars$(191) + C1310$
                  K = K + 2
             CASE 95                                  '_  Draw 'bottom box'.
                  K0$ = Short$(477) + STRING$(Val3(p$,K + 1),223) + Short$(673)
                  K = K + 2
             CASE 231 : K0$ = Lines$(1)               '  Insert title.
             CASE 64                                  '@  Display file.
                  K7 = StrSrch2(K,p$,64)
                  IF K7 > 0 AND GInUse >= 0 _
                     THEN K1$ = MID$(p$,K + 1,K7 - K - 1) : _
                          CALL DispFile(K1$,Null$) : _
                          K = k7
           END SELECT
           K = K + 1
           CALL SendItDo(K0$,K0,K1)
           IF K3 AND TGot < 1 AND NOT K99 THEN CALL SendItInCk(K2,K4,K,K$,K0)
           K5 = K
           K6 = 0
      CASE ELSE : K6 = K6 + 1
                  K = K + 1
   END SELECT
  WEND
  IF TGot < 1 AND K6 > 0 THEN CALL SendItDo(MID$(p$,K5,K6),K0,K1) : _
                                IF K3 THEN CALL SendItInCk(K2,K4,K,K$,K0)
      '
      'Loop until the buffer is clear (characters were sent) or a valid
      'key was entered or if we're local.  No need for NoCarrier because
      'that will clear the buffer too.
      '
'  WHILE NOT BitTest(FosIntAX(CommPort,&H300),15) AND TGot < 1 AND CommPort <> 0
    IF K3 THEN CALL SendItInCk(K2,K4,K,K$,K0)
'  WEND
  IF NoCarrier THEN TGot$ = C13$ : _
                    TGot = 13

END SUB


SUB SendItDo2 (ToScreen$,ToPort$,p1)

IF TGot > 0 THEN EXIT SUB
    IF CommPort = 0 _
       THEN CALL Ansi2(ToScreen$) _
       ELSE CALL CommOut(ToPort$) : _
            IF NOT p1 THEN CALL Ansi2(ToScreen$)

END SUB


SUB SendItDo (p$,p1,k6)

    IF CommPort = 0 THEN CALL Ansi2(p$) : _
                         EXIT SUB
    SELECT CASE K6
      CASE 0
           CALL CommOut(p$)
           IF NOT p1 THEN CALL Ansi2(p$)
      CASE -1
           K$ = p$
           K = 1
           WHILE K + 3 <= LEN(K$)
             K0 = AscMid(K$,K)
             IF MID$(K$,K + 1,3) = Chars$(K0) + Chars$(K0) + Chars$(K0) _
                THEN K1 = K : _
                     K = K + 3 : _
                     DO : K = K + 1 : _
                     LOOP UNTIL AscMid(K$,K) <> K0 : _
                     K$ = LEFT$(K$,K1 - 1) + Chars$(25) + Chars$(K0) + _
                          Chars$(K - K1) + MID$(K$,K) : _
                     K = K1 + 2
             K = K + 1
           WEND
           CALL CommOut(K$)
           IF NOT p1 THEN CALL Ansi2(p$)
    END SELECT

END SUB



        '
        '* * * *


SUB SendItInCk (K1,K4,K,K0$,p1)

    DO
      '
      ' If we're to look for keys, then do so, and process what we find.
      ' We do the shorter logo timeout because if we're displaying lists/etc.
      ' we're keeping files open--which could mean we're holding other nodes
      ' hostage.
      '
      '
      ' If we're to look for keys, then do so, and process what we find.
      '
             K2 = CommIn(0)
             SELECT CASE K2 
               CASE IS >= 0
                    IF K1 AND (K2 = 32 OR K2 = 9) _
                       THEN z$ = TIME$ : _
                            DO : z = CommIn(0) : _
                            LOOP UNTIL z = 32 OR z = 13 OR z = 9 OR NoCarrier _
                                       OR ElapsedTime(z$,K2) = Settings.LogoTimeOut : _
                            K2 = -1
                    IF NoCarrier THEN K = K4
                    IF K2 > 96 THEN CALL BitClear(K2,6)  'Uppercase it.
                    IF StrSrch1(K0$,K2) > 0 _
                       THEN TGot$ = Chars$(K2) : _
                            TGot = K2 : _
                            TT$ = Short$(68) : _
                            CALL CommOut(TT$) : _
                            CALL AnsiTT : _
                            K = K4              'We want to exit our WHILE loop.
'                            CALL PurgeComIO(CommPort) : _
'                            TT$ = Short$(68) : _
'                            CALL CommOut(TT$) : _
'                            CALL AnsiTT : _
'                            K = K4              'We want to exit our WHILE loop.
             END SELECT
  p1 = BitTest(Settings.Toggles2,2)
      '
      'Loop until the buffer is clear (characters were sent) or a valid
      'key was entered or if we're local.  No need for NoCarrier because
      'that will clear the buffer too.
      '
  LOOP UNTIL CommPort = 0 OR BitTest(FosIntAX(CommPort,&H300),15) OR TGot > 0

END SUB







        '* * * * * *
        ' This routine will send/display a file.
        '
        ' p$   pathname
        '
        ' p0$  list of valid stop & exit commands
        '
        ' TGot$ = NULL if completely outputed, otherwise = the valid key
        ' hit.
        '
        ' TGot = -1 if completely outputed, otherwise = the valid key
        ' hit.  Unlike TGet which returns a -1 when you hit CR, this
        ' will return 13.
        '
        ' Don't use for files larger than, say, 8192 bytes--since the
        ' whole thing is read in as a single string.
        '
        ' I break the read-in string up by ASCII 27's (first letter of
        ' ANSI commands) to provide better control when exit early (so
        ' a bunch of garbage characters aren't displayed).  However,
        ' with the HST's 128 byte buffer, I'm not so sure it matters.
        ' But it seems to work ok, so I've kept it--even though you
        ' could blast the whole read-in string out at once with both
        ' ANSI and the block output routine.
        '
        ' Date last checked for perfection: Sep 18 1992
        '
SUB DispFile (p$,p0$)

  zz$ = p0$
  IF BaseIndex < 0 OR BaseIndex > BasesSize THEN BaseIndex = 32767
  IF FileIndex < 1 OR FileIndex > DirsSize THEN FileIndex = 32767
  TGot$ = Null$
  TGot = -1
  K2$ = NodeFix$(p$)
  K = FindF(K2$,FFile)
  K3 = StrSrchR(K2$,92)
  IF NoCarrier OR K = 0 OR FFile.FSize = 0 THEN EXIT SUB
  K = 0
  DO : K = K + 1
  LOOP UNTIL FindF(Null$,FFile) = 0          'Number of file's found (1 to n).
  FOR K0 = 1 TO GetRndNum(K)
    IF K0 = 1 THEN K1 = FindF(K2$,FFile) _
              ELSE K1 = FindF(Null$,FFile)
  NEXT
  K2$ = LEFT$(K2$,K3) + FFile.FName
  '
  ' Read in the file.
  '
  IF (BitTest(Settings.Toggles2,8) OR BitTest(User.Attr,6)) _
     AND NOT BitTest(Settings.Toggles2,9) _
     THEN IF DriveSpc&(FileNames(51)) > Settings.MinSpace _
             THEN CALL FilePutSEnd(Handle(1),Short$(741) + RTRIM$(K2$) + Short$(741))
  GDir$ = ParseForPath$(K2$)
  K2 = FileOpenR(K2$)
  K& = 0
  K0& = FFile.FSize
  CALL DFIncomingCheck(zz$)
  WHILE TGot < 1 AND NOT NoCarrier AND K0& <> K&
    CALL DispFileString(FileGetBlock$(K2,K&,K0&),zz$)
  WEND
  CALL FileCloseR(K2)
  IF NoCarrier THEN TGot$ = Null$ : _
                    TGot = -1

END SUB
        '
        '* * * *


SUB DispFileString (p$,p0$)

  p1 = BitTest(Settings.Toggles2,2)
  p2 = BitTest(User.Toggles,15)
  '
  ' Expand our 'x<<y' smart-codes.
  '
  K = StrSrch1(p$,20)
  IF K > 0 THEN CALL DoSmartAnsi(p$,K)
  '
  ' Output the text until at end, no carrier, or they hit a valid key.
  '
  ks = LEN(p$)
  K = 1
  K0 = BitTest(Settings.Toggles2,9)
  K1 = 1      'Start of normal text to output next in string.
  K2 = 0      'End of normal text to output next in string.
  WHILE K <= ks AND TGot < 1
    SELECT CASE AscMid(p$,K)
      CASE 10
           '
           ' CR/LF -- for files without ANSI/GIP codes.
           '
           CALL DFDoIt(K0,MID$(p$,K1,K2 + 1),p0$,p1,p2)
           K = K + 1
           K1 = K
           K2 = 0
      CASE 27
           '
           ' ANSI display codes.
           '
           IF K2 > 0 THEN CALL DFDoIt(K0,MID$(p$,K1,K2),p0$,p1,p2)
           CALL AnsiProcessor(p$,ToScreen$,ToPort$,K)
           CALL DFDoIt2(K0,ToScreen$,ToPort$,p1)
           K1 = K
           K2 = 0
      CASE 19
           '
           ' GIP graphics codes.
           '
           IF K2 > 0 THEN CALL DFDoIt(K0,MID$(p$,K1,K2),p0$,p1,p2)
           p0$ = Null$                      'No stop/exit keys with GIP.
           CALL DoGIPForBBS(p$,K,ToScreen$,ToPort$)
           CALL DFDoIt2(K0,ToScreen$,ToPort$,p1)
           K1 = K
           K2 = 0
           IF LEN(GlobalStuff$(26)) > 0 _
              THEN p$ = LEFT$(p$,K - 1) + Chars$(19) + Chars$(255) + C0$ + _
                        Chars$(59) + GlobalStuff$(26) + Chars$(19) + _
                        Chars$(255) + Chars$(CommPort) + Chars$(59) + _
                        MID$(p$,K) : _
                   ks = LEN(p$) : _
                   GlobalStuff$(26) = Null$
      CASE ELSE : K2 = K2 + 1
                  K = K + 1
   END SELECT
  WEND
  IF TGot < 1 AND K2 > 0 THEN CALL DFDoIt(K0,MID$(p$,K1,K2),p0$,p1,p2)

END SUB

'a null p$ shouldn't occur, so no need to test for it.
'nor should a tgot > 0
'p$ = normal text segment to send/display.
'p = bittest status of whether trapping-all-ansi's or not.
'p0$ = valid stop/exit keys.
SUB DFDoIt (p,p$,p0$,p1,p2)

  IF NOT p1 THEN CALL Ansi2(p$)
  SELECT CASE p2
    CASE -1
         K = 1
         WHILE K + 3 <= LEN(p$)
           K0 = AscMid(p$,K)
           IF MID$(p$,K + 1,3) = Chars$(K0) + Chars$(K0) + Chars$(K0) _
              THEN K1 = K : _
                   K = K + 3 : _
                   DO : K = K + 1 : _
                   LOOP UNTIL AscMid(p$,K) <> K0 : _
                   p$ = LEFT$(p$,K1 - 1) + Chars$(25) + Chars$(K0) + _
                        Chars$(K - K1) + MID$(p$,K) : _
                   K = K1 + 2
           K = K + 1
         WEND
  END SELECT
  IF p THEN CALL CommOut(p$) _
       ELSE CALL BlockOut(CommPort,p$)
  CALL DFIncomingCheck(p0$)
  p1 = BitTest(Settings.Toggles2,2)

END SUB


SUB DFDoIt2 (K0,ToScreen$,ToPort$,p1)

  IF TGot > 0 THEN EXIT SUB   'They hit a key in DFDoIt
  IF LEN(ToPort$) > 0 THEN IF K0 THEN CALL CommOut(ToPort$) _
                                 ELSE CALL BlockOut(CommPort,ToPort$)
  IF NOT p1 THEN CALL Ansi2(ToScreen$)

END SUB


SUB DFIncomingCheck (p0$)

    DO
      K0 = CommIn(32 + 256)     'Netmail detect on, allow <alt>c.
      SELECT CASE K0
        CASE IS >= 0
             IF NoCarrier THEN EXIT DO
             IF K0 > 96 THEN CALL BitClear(K0,6)  'Uppercase it.
             SELECT CASE StrSrch1(p0$,K0)
               CASE IS > 0
                    TGot$ = Chars$(K0)
                    TGot = K0
'                    CALL PurgeComIO(CommPort)
'with my looping till buffer empty--no need to purge--but watch just in case.
                    TT$ = Short$(68)
                    CALL CommOut(TT$)
                    CALL AnsiTT
                    CALL DispCRLF
                    CALL DispCRLF
             END SELECT
      END SELECT
    LOOP UNTIL BitTest(FosIntAX(CommPort,&H300),15) OR TGot > 0 OR CommPort = 0
'    LOOP UNTIL BitTest(FosIntAX(CommPort,&H300),15) OR NoCarrier OR (TGot > 0) _
'               OR (CommPort = 0)

END SUB

' p$ working with (gets changed)
' p  position of next '' char (gets changed)
SUB DoSmartAnsi (p$,p)

  DO
    '
    ' Parse '#><#'/'#<>#', '#>>#', '#<<#'
    '
    k = p
    p = StrSrch2(k,p$,20)
    IF p = 0 THEN EXIT DO
    k0$ = MID$(p$,k + 1,p - k - 1)
    K1 = StrToNumL&(K0$)
    K2 = Val2&(K0$)
    K3 = 0
    IF StrSrch(1,K0$,Short$(453)) > 0 _
       THEN K3 = 1 _
       ELSE IF StrSrch(1,K0$,Short$(454)) > 0 _
               THEN K3 = 2 _
               ELSE IF StrSrch(1,K0$,Short$(455)) > 0 _
                       THEN K3 = 8 _
                       ELSE IF StrSrch(1,K0$,Short$(216)) > 0 THEN K3 = 8
    '
    ' Decide what do do.
    '
    K0$ = Null$
    SELECT CASE K1
      CASE 1   : K0$ = NCR$(User.UserName)
      CASE 2   : K0$ = User.Password
      CASE 3   : K0$ = NCR$(User.CityState)
                 IF LEN(K0$) = 0 THEN K0$ = C32$
      CASE 4   : K0$ = IntToPhone$(User.HomePhone)
                 IF LEN(K0$) = 0 THEN K0$ = C32$
      CASE 5   : K0$ = IntToPhone$(User.BBSPhone)
                 IF LEN(K0$) = 0 THEN K0$ = C32$
      CASE 6   : K0$ = IntToDate3$(User.BirthDate)
      CASE 7   : K& = Levels(MappedSL(- User.SecLevel)).ShowLevel
      CASE 8   : K0$ = IntToDate3$(User.FirstCall)
      CASE 9   : K0$ = User.Protocol
      CASE 10  : K0$ = IntToDate3$(User.SubsStart)
      CASE 11  : K0$ = IntToDate3$(User.SubsEnd)
'      CASE 12  : K0$ = User.SubsType
'      CASE 13  : K& = User.Monies
'      CASE 14  : K& = User.TotalMonies
      CASE 15  : K0$ = IntToDate3$(User.LastDateOn)
      CASE 16  : K& = ASC(User.PswdChange)
      CASE 17  : K0$ = IntToDate3$(User.AlterDate)
      CASE 18  : K0$ = Form$(20,User.UserName)
      CASE 19  : K& = User.PagedSysop
      CASE 20  : K& = User.Logons
      CASE 21  : K& = User.MinCredits
      CASE 22  : K& = ASC(User.Attempts)
      CASE 23  : K& = User.MsgsPosted
      CASE 24  : K& = User.EMsgsPosted
      CASE 25  : K& = User.FMsgsPosted
      CASE 26  : K& = User.NetMailSent
      CASE 27  : K& = User.NetMailRcvd
      CASE 28  : K& = User.Elapsed
      CASE 29  : K& = User.Dnlds
      CASE 30  : K& = User.DLBytes
      CASE 31  : K& = User.MinsDLing
      CASE 32  : K& = User.BadDLs
      CASE 33  : K& = User.Uplds
      CASE 34  : K& = User.ULBytes
      CASE 35  : K& = User.MinsULing
      CASE 36  : K& = User.BadULs
      CASE 37  : K& = User.Doors
      CASE 38  : K0$ = User.SysopNote
      CASE 39  : K0$ = User.UserNote
      CASE 40  : K& = User.MsgsPosted + User.EMsgsPosted + _
                      User.FMsgsPosted + User.NetMailSent
      CASE 41  : K& = Levels(MappedSL(User.SecLevel)).DLMinsPerDay
      CASE 42  : K& = Levels(MappedSL(User.SecLevel)).DLMinsPerDay + _
                      User.MinCredits - User.Elapsed
      CASE 43  : K& = ElapsedTime(IntToTime$(SumLog.TimeOn),K4)
      CASE 44  : K& = DaysSince&(User.BirthDate) \ 365&
      CASE 45  : K0$ = SumLog.BaudRate
      CASE 46  : K0$ = IntToDate2$(User.BirthDate)
      CASE 47  : K& = User.SecLevel
      CASE 48  : K& = User.HiFilePtr
      CASE 49  : K& = User.HighestPtr
      CASE 50  : K0$ = STR$(User.MinMegs)
      CASE 51  : K0$ = User.Language
      CASE 52  : K0$ = IntToDate2$(User.SubsStart)
      CASE 53  : K0$ = IntToDate2$(User.SubsEnd)
      CASE 54  : K& = User.ElapsedMins + ElapsedTime(IntToTime$(MinTimer),0)
      CASE 55  : K& = User.ElapsedMinsC + ElapsedTime(IntToTime$(MinTimer),0)
      CASE 97  : K0$ = IntToPhone$(Settings.Phone)
                 IF LEN(K0$) = 0 THEN K0$ = C32$
      CASE 98  : K0$ = NCR$(Settings.Sysop)
      CASE 99  : K0$ = Form$(20,Settings.Sysop)
      CASE 101 : IF BaseIndex = 32767 THEN K0$ = Lines$(101) _
                                      ELSE K0$ = MsgAreaInfo3$(BaseIndex + 1,2)
      CASE 102 : IF BaseIndex = 32767 THEN K0$ = Lines$(101) _
                                      ELSE K0$ = MsgAreaInfo3$(BaseIndex + 1,1)
      CASE 103 : IF BaseIndex = 32767 _
                    THEN K& = 0 _
                    ELSE K& = Levels(MappedSL(- MsgAreaInfo2(BaseIndex + 1,1))).ShowLevel
      CASE 104 : IF BaseIndex = 32767 _
                    THEN K& = 0 _
                    ELSE K& = Levels(MappedSL(- MsgAreaInfo2(BaseIndex + 1,2))).ShowLevel
      CASE 105 : IF BaseIndex = 32767 _
                    THEN K& = 0 _
                    ELSE K& = Levels(MappedSL(- MsgAreaI(BaseIndex + 1).ScanSL)).ShowLevel
      CASE 106 : IF BaseIndex = 32767 _
                    THEN K0$ = Lines$(101) _
                    ELSE K0$ = Form$(20,MsgAreaInfo3$(BaseIndex + 1,1))
      CASE 201 : IF FileIndex = 32767 THEN K0$ = Lines$(101) _
                                      ELSE K0$ = FileAreaInfo3$(FileIndex,3)
      CASE 202 : IF FileIndex = 32767 THEN K0$ = Lines$(101) _
                                      ELSE K0$ = FileAreaInfo3$(FileIndex,1)
      CASE 203 : IF FileIndex = 32767 _
                    THEN K& = 0 _
                    ELSE K& = Levels(MappedSL(- FileAreaInfo2(FileIndex,2))).ShowLevel
      CASE 204 : IF FileIndex = 32767 _
                    THEN K& = 0 _
                    ELSE K& = Levels(MappedSL(- FileAreaI(FileIndex).DLSL)).ShowLevel
      CASE 205 : IF FileIndex = 32767 _
                    THEN K& = 0 _
                    ELSE K& = Levels(MappedSL(- FileAreaI(FileIndex).ScanSL)).ShowLevel
      CASE 206 : IF FileIndex = 32767 _
                    THEN K0$ = Lines$(101) _
                    ELSE K0$ = Form$(20,FileAreaInfo3$(FileIndex,1))
      CASE 1001 TO 1051
           K5 = FileOpenR(FileNames(13))
           CALL FileGetLoc(K5,2001& + (K1 - 1001) * 2,2,K6)
           K0$ = Form4$(7,K6)
           CALL FileCloseR(K5)
      CASE 1100 TO 2299
           K8 = K1 \ 100 - 11
           Kz1 = K1 - (K8 + 11) * 100
           K0& = 2514 + 34 * Settings.StatsSize * K8 + (Kz1 + 50 * (kz1 > 49)) * 34
           K5 = FileOpenR(FileNames(13))
           IF kz1 < 50 THEN K0$ = SPACE$(30) : _
                            CALL FileGetSLoc(K5,K0&,K0$) : _
                            K0$ = NCR$(K0$) _
                       ELSE CALL FileGetLoc(K5,K0& + 30,4,K&)
           CALL FileCloseR(K5)
      CASE ELSE : K = p
                  K1 = 0
    END SELECT
    '
    ' Do it.
    '
    IF LEN(K0$) = 0 THEN K0$ = Commas$(K&)
    IF K1 > 0 _
       THEN p$ = LEFT$(p$,K - 1) + Form$(K2 * 100 + K3,K0$) + MID$(p$,p + 1)
    p = StrSrch2(k,p$,20)
  LOOP UNTIL p = 0

END SUB




'1100 - 1199  'best DL bytes
'1200 - 1299  'best Files DL'd
'1300 - 1399  'best UL bytes
'1400 - 1499  'best files UL'd
'1500 - 1599  'best logons
'1600 - 1699  'best posters
'1700 - 1799  'worst DL bytes
'1800 - 1899  'worst DL files
'1900 - 1999  'worst UL bytes
'2000 - 2099  'worst UL files
'2100 - 2199  'worst logons
'2200 - 2299  'worst posts

