' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.




        '* * * * * *
        ' This routine generates the description line for a file.
        '
        ' p0  Output this character for file letter.
        '
        ' p   array location in FWork() for the file.
        '     a negative value means to also display extended info
        '     line.
        '
        ' p$  valid stop and exit keys.  (also the SendTT commands to do
        '     so and to pause).
        '
        ' p0$ list of files with reviews.
        '
        ' p1$ specifications to follow for output.
        '
        ' p1  only used by PagedFil system, returns 1 or 3 + number of
        '     reviews lines.
        '
        ' Relies on FileList for it's information.
        '
        ' Date last checked for perfection: Sep 19 1992
        '
SUB DispDescLine (p0,p,p$,p0$,p1$,p1)

  K0$ = MID$(p1$,IntMid(p1$,1) + 3)
  K3$ = p$
  K = StrSrch1(K0$,20)        'Find end of main desc line.
  SELECT CASE p
    CASE IS < 0
         p = - p
         p1 = 0
         DO
           p1 = p1 + 1
           K = StrSrch2(K,K0$,20)
         LOOP UNTIL K = 0
    CASE ELSE
         K0$ = LEFT$(K0$,K + 1)
         p1 = 1
  END SELECT

  'Char             Justified
  '/ LenForm     / Example  What
  'A   8  XXXXXXXX  L  FILENAME  File name
  'B   3  XXX       L  EXT       File extension
  'C                             reserved for ANSI [xC jumps.
  'D   9  #,###,### R  9,999,999 File size in bytes with comma separators
  '                              see SHORT 242 to change comma colors
  'E   9  #.###.### R  9.999.999 Same as D, see SHORT 245 to change colors.
  'F   7  #######   R  9999999   Same as D.
  'G   5  #,###     R  9,999     File size in k with comma separator.
  '                              see SHORT 242 to change comma colors
  'H   5  #.###     R  9.999     Same as G, see SHORT 245 to change colors.
  'I   4  ####      R  9999      Same as G.
  'J   2  XX        L  fp        File attributes--colorizing is added if
  '                              non-blank (locked in, but more effient).
  '                              See SHORT 249 to change the letters used.
  'K                             reserved for ANSI [0K command.
  'L   6  ######    N  041092    Date file was uploaded to the BBS.
  'M   3  |x#       L  |+5       L&D/file points/etc.
  'N   9  ##-XXX-## R  10-Apr-92 Date file was uploaded to the BBS.
  'O   30 XXX<30>XX L  John<etc> Uploader's name, case adjusted.
  'P   4  ####      L  99        Number of times downloaded.
  'Q   9  ##-XXX-## R  10-Apr-92 Date the file was last downloaded.
  'R   1  X         N  A         File-letter-on-screen   [A - R, for PagF only]
  'S   12 XXX<12>XX L  FILE<etc> Filename and extension with period.
  'T   9  ##-XXX-## R  10-Apr-92 File's actual date
  'a   8  xxxxxxxx  L  filename  File name
  'b   3  xxx       L  ext       File extension
  'm
  '$                             at position one means 'do not shrink spaces'.
  'Z   Description field--use's whatever's left of the 79 char's
  '    When figuring the length to use, all spaces are counted against
  '    it and taken into account (those in the original spec)--however
  '    any non-space/non-ansi chars are not--to compensate, add extra
  '    spaces at the end.  Eg. 'BZ' should be 'BZ  '
  '    Desc must be on first line, and not on any other lines.
  '
  K$ = ExpandFileName$(FWork(p).FName)
  K = 79
  kx = -1
  ky = -1
  K0 = LEN(K0$)
  WHILE K0 > 0
    K6 = AscMid(K0$,K0)
    if kx = 1 and K6 <> 126 then K6 = 0
    K1$ = Null$
    SELECT CASE K6
      CASE 20 : K = 79
      CASE 126 : Kx = - kx
                 K0$ = LEFT$(K0$,K0 - 1) + MID$(K0$,K0 + 1)
      CASE 32 : K = K - 1
      CASE 36 : IF K0 = 1 THEN ky = 0 : _
                               K0$ = LEFT$(K0$,K0 - 1) + MID$(K0$,K0 + 1)
      CASE 65, 97
           K1$ = LEFT$(K$,8)
           IF K6 = 97 THEN K1$ = LCASE$(K1$)
           IF FileList.HiFilePtr > User.HiFilePtr _
              THEN K1$ = Short$(96) + K1$ : _
                   User.HighestPtr = FileList.HiFilePtr
           K = K - 8
      CASE 66, 98
           K1$ = RIGHT$(K$,3)
           IF K6 = 98 THEN K1$ = LCASE$(K1$)
           IF FileList.HiFilePtr > User.HiFilePtr THEN K1$ = Short$(96) + K1$
           K = K - 3
      CASE 68 : CALL DDAddCommas(K1$,K1,Short$(242),FileList.FSize)
                IF K1 < 9 THEN K1$ = SPACE$(9 - K1) + K1$
                K = K - 9
      CASE 69 : CALL DDAddCommas(K1$,K1,Short$(245),FileList.FSize)
                IF K1 < 9 THEN K1$ = SPACE$(9 - K1) + K1$
                K = K - 9
      CASE 70 : K1$ = LongToStr$(FileList.FSize)
                K1 = LEN(K1$)
                IF K1 < 7 THEN K1$ = SPACE$(7 - K1) + K1$
                K = K - 7
      CASE 71 : CALL DDAddCommas(K1$,K1,Short$(242),FileList.FSize \ 1024 + 1)
                IF K1 < 5 THEN K1$ = SPACE$(5 - K1) + K1$
                K = K - 5
      CASE 72 : CALL DDAddCommas(K1$,K1,Short$(245),FileList.FSize \ 1024 + 1)
                IF K1 < 5 THEN K1$ = SPACE$(5 - K1) + K1$
                K = K - 5
      CASE 73 : K1$ = LongToStr$(FileList.FSize \ 1024 + 1)
                K1 = LEN(K1$)
                IF K1 < 4 THEN K1$ = SPACE$(4 - K1) + K1$
                K = K - 4
      CASE 74
           K1 = 1
           K2 = 1
           FOR K4 = 1 TO 5
             K5 = 0
             SELECT CASE K4
               CASE 1 : IF BitTest(FileList.Attr,2) _
                           OR (BitTest(FileList.Attr,9) AND ConnectCPS >= 800) _
                           THEN K5 = 2
               CASE 2 : IF BitTest(FileList.Attr,6) THEN K5 = 3
               CASE 3 : IF FileList.Password <> 0 THEN K5 = 4
               CASE 4 : IF FileList.Group > 0 THEN K5 = 5
               CASE 5 : IF LEN(p0$) > 0 _
                           THEN IF StrSrch(1,p0$,FWork(p).FName) > 0 _
                                   THEN K5 = 6
             END SELECT
             IF K5 > 0 THEN IF K1 = 1 THEN K1 = K5 _
                                      ELSE IF K2 = 1 THEN K2 = K5
           NEXT
           K1$ = Short$(82) + MID$(Short$(249),K1,1) + MID$(Short$(249),K2,1)
           K = K - 2
      CASE 76 : CALL DateDMY(FileList.DateULed,K1,K2,K4)
                K1$ = Form4$(2,K1) + Form4$(2,K2) + Form4$(2,K4 + 80)
                K = K - 6
      CASE 77
           IF NOT BitTest(FileArea.Attr,3) OR NOT BitTest(User.Toggles,7) _
              OR FileList.LDCount = 10 OR BitTest(FileList.Attr,7) _
              THEN K1 = 0 _
              ELSE K1 = -1
           SELECT CASE K1
             CASE 0 : K1$ = Short$(188)
             CASE -1
                  SELECT CASE FileList.LDCount
                    CASE 0        : K1$ = Short$(189)  '|? blinking
                    CASE 1        : K1$ = Short$(202)  '|1 blinking
                    CASE 2 to 9   : K1$ = Chars$(124) + Chars$(FileList.LDCount + 48) '|#
                    CASE 11 to 19 : K1$ = Short$(217) + Chars$(68 - FileList.LDCount) '|-#
                    CASE 20 to 28 : K1$ = Short$(220) + Chars$(FileList.LDCount + 29) '|+#
                    CASE 100 to 199 : K1$ = Chars$(179) + IntToStr$(FileList.LDCount - 100) '## 
                  END SELECT
                  K1$ = StripLeft$(K1$ + Short$(188),3)
           END SELECT
           K = K - 3
      CASE 78 : K1$ = IntToDate3$(FileList.DateULed)
                K = K - 9
      CASE 79 : K1$ = FileList.UserName
                CALL WordsCase(K1$)
                K = K - 30
      CASE 80 : K1$ = Form$(401,STR$(FileList.Downloaded))
                K = K - 4
      CASE 81 : K1$ = IntToDate3$(FileList.LastDLed)
                K = K - 9
      CASE 82 : MID$(K0$,K0,1) = Chars$(p0)
                K = K - 1
      CASE 83 : K1$ = FWork(p).FName
                K = K - 12
      CASE 84 : K1$ = FWork(p).FDate
                K = K - 9
      CASE 90 : MID$(K0$,K0,1) = c0$
      CASE 112 : IF FileList.LDCount > 99 _
                    THEN K1 = FileList.LDCount - 100 _
                    ELSE K1 = FileList.FSize \ Settings.FPWorthInBytes
                K1$ = IntToStr$(K1)
                K1 = LEN(K1$)
                IF K1 < 4 THEN K1$ = SPACE$(4 - K1) + K1$
                K = K - 4
      CASE 114
           SELECT CASE StrSrch(1,p0$,FWork(p).FName)
             CASE IS > 0
                  TT$ = Null$
                  CALL DisplayReviews(1,FWork(p).FName)
                  SELECT CASE LEN(TT$)
                    CASE 0 : K0$ = LEFT$(K0$,K0 - 1) + MID$(K0$,K0 + 1)
                    CASE ELSE
                         K1$ = TT$
                         K1 = StrSrch1(K1$,13)
                         WHILE K1 <> 0
                           p1 = p1 + 1
                           K1 = StrSrch2(K1,K0$,13)
                         WEND
                  END SELECT
             CASE ELSE : K0$ = LEFT$(K0$,K0 - 1) + MID$(K0$,K0 + 1)
           END SELECT
    END SELECT
    IF LEN(K1$) > 0 THEN K0$ = LEFT$(K0$,K0 - 1) + K1$ + MID$(K0$,K0 + 1)
    K0 = K0 - 1
  WEND
  '
  ' Insert the file description in whatever's left.
  '
  K0 = StrSrch1(K0$,0)
  SELECT CASE K0
    CASE IS > 0
         ka = LEN(RTRIM$(FileList.FDesc))
         IF BitTest(FileList.Attr,7) THEN ka = -1
         SELECT CASE ka
           CASE -1 : K1$ = StripLeft$(Lines$(201) + SPACE$(K),K)
           CASE 0 : K1$ = StripLeft$(Chars$(63) + SPACE$(K),K)
           CASE ELSE
                K1$ = FileList.FDesc
                CALL Colorize(K1$,7)
                SELECT CASE K
                  CASE IS < 51
                       ka$ = WordsGet$(k1$,WordsCnt(k1$),0)
                       kb$ = Null$
                       IF LEN(ka$) > 0 _
                          THEN IF ASC(ka$) = 91 AND AscRight(ka$) = 93 _
                                  THEN IF StrSrch2(StrSrch1(ka$,120),ka$,120) > 0 _
                                          THEN K = K - LEN(ka$) : _
                                               kb$ = ka$
'                                        THEN K = K - LEN(ka$) - 1 : _
'                                             kb$ = ka$
                       K1$ = StripLeft$(K1$ + SPACE$(K),K) + kb$
                END SELECT
         END SELECT
         K0$ = LEFT$(K0$,K0 - 1) + K1$ + MID$(K0$,K0 + 1)
  END SELECT
  '
  ' Reduce multiple spaces to [xC ANSI codes.  RTRIM$'s end-of-lines.
  '
  K0$ = RTRIM$(K0$)
  K1$ = C32$ + Chars$(20)
  K = StrSrch(1,K0$,K1$)
  WHILE K > 0
    K0$ = RTRIM$(LEFT$(K0$,K)) + MID$(K0$,K + 1)
    K = StrSrch(1,K0$,K1$)
  WEND
  K = StrSrch(1,K0$,Short$(296))
  IF NOT ky THEN K = 0
  WHILE K > 0
    K0 = 5
    K1 = K
    WHILE AscMid(K0$,K1 + 5) = 32
      K0 = K0 + 1
      K1 = K1 + 1
    WEND
    K0$ = LEFT$(K0$,K - 1) + Short$(213) + IntToStr$(K0) + Chars$(67) + _
          MID$(K0$,K1 + 5)
    K = StrSrch(K,K0$,Short$(296))
  WEND
  '
  ' Actually display it.
  '
  TT$ = K3$ + K0$
  IF NOT BitTest(FileList.Attr,6) _
     THEN CALL SendTT _
     ELSE IF UserSL = LevelsSize OR User.UserName = FileArea.FileOp _
             THEN CALL SendTT

END SUB
        '
        '* * * *


SUB DDAddCommas (K$,K0,K1$,K&)

  K$ = LongToStr$(K&)
  K0 = LEN(K$)
  SELECT CASE K0
    CASE 7
         K$ = LEFT$(K$,1) + K1$ + MID$(K$,2,3) + K1$ + RIGHT$(K$,3)
         K0 = 9
    CASE 4 TO 6
         K$ = LEFT$(K$,K0 - 3) + K1$ + RIGHT$(K$,3)
         K0 = K0 + 1
  END SELECT

END SUB



        '* * * * * *
        ' This routine generates the header line for a file area.
        '
        ' p$  valid stop and exit keys.  (also the SendTT commands to do
        '     so and to pause).
        '
        ' p0$ specifications to follow for output.
        '
        ' p   number of files in the area.
        '
        ' Date last checked for perfection: May 19 1993
        '
SUB DispHeaderLine (p$,p0$,p)

  K0$ = MID$(p0$,3,IntMid(p0$,1))
  '
  '  Char             Justified
  '  / LenForm     / Example  What
  '  A   ?  XxxxXXxxX N  Area One  Area title as you have it.
  '  B   ?  XXXXXXXXX N  AREA ONE  Area title upper-cased.
  '  C                             reserved for ANSI [xC forward jumps.
  '  D                             reserved for ANSI [xD backward jumps.
  '  E   ?  XxxxXXxxX L  Area One  Area title as you have it.
  '  F   ?  XXXXXXXXX L  AREA ONE  Area title upper-cased.
  '  G   ?  ###       N  6         File area's number (adjusted appropriately
  '                                to hide user-inaccessible areas).
  '  H   ?  ##        N  56        A number representing 79 - LEN(Title)
  '  I   ?  ##        N  20        A number representing LEN(Title)
  '  J                             reserved for ANSI [2J command (clear screen).
  '  K                             reserved for ANSI [0K command (clear to EOL).
  '                                to hide user-inaccessible areas).
  '  L   ?  ###,###   N  1,200     Number of files in the area.  For LstF
  '                                commands, or file areas which listing is done
  '                                from newest to oldest, the number will
  '                                instead be the number of files in all areas.
  '
  kx = -1
  K2$ = RTRIM$(FileArea.Title)
  K0 = LEN(K0$)
  WHILE K0 > 0
    K6 = AscMid(K0$,K0)
    if kx = 1 and K6 <> 126 then K6 = 0
    K1$ = Null$
    SELECT CASE K6
      CASE 126 : Kx = - kx
                 K0$ = LEFT$(K0$,K0 - 1) + MID$(K0$,K0 + 1)
      CASE 65 : K1$ = K2$
      CASE 66 : K1$ = UCASE$(K2$)
      CASE 69 : K1$ = LTRIM$(K2$)
      CASE 70 : K1$ = UCASE$(LTRIM$(K2$))
      CASE 71 : K1$ = IntToStr$(MappedFileArea(FileIndex))
      CASE 72 : K1$ = IntToStr$(79 - LEN(LTRIM$(K2$)))
      CASE 73 : K1$ = IntToStr$(LEN(LTRIM$(K2$)))
      CASE 76 : CALL DDAddCommas(K1$,0,Short$(245),1& * p)
    END SELECT
    IF LEN(K1$) > 0 THEN K0$ = LEFT$(K0$,K0 - 1) + K1$ + MID$(K0$,K0 + 1)
    K0 = K0 - 1
  WEND
  '
  ' Reduce multiple spaces to [xC ANSI codes.  RTRIM$'s end-of-lines.
  '
  K0$ = RTRIM$(K0$)
  K1$ = C32$ + Chars$(20)
  K = StrSrch(1,K0$,K1$)
  WHILE K > 0
    K0$ = RTRIM$(LEFT$(K0$,K)) + MID$(K0$,K + 1)
    K = StrSrch(1,K0$,K1$)
  WEND
  K = StrSrch(1,K0$,Short$(296))
  WHILE K > 0
    K0 = 5
    K1 = K
    WHILE AscMid(K0$,K1 + 5) = 32
      K0 = K0 + 1
      K1 = K1 + 1
    WEND
    K0$ = LEFT$(K0$,K - 1) + Short$(213) + IntToStr$(K0) + Chars$(67) + _
          MID$(K0$,K1 + 5)
    K = StrSrch(K,K0$,Short$(296))
  WEND
  '
  ' Actually display it.
  '
  TT$ = p$ + K0$
  CALL SendTT

END SUB
        '
        '* * * *

